/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.DebugFlag;
import com.amazon.corretto.crypto.provider.Janitor;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Loader {
    static final String PROPERTY_BASE = "com.amazon.corretto.crypto.provider.";
    private static final String TEMP_DIR_PREFIX = "amazonCorrettoCryptoProviderNativeLibraries.";
    private static final String JNI_LIBRARY_NAME = "amazonCorrettoCryptoProvider";
    private static final String PROPERTY_VERSION_STR = "versionStr";
    private static final String LIBCRYPTO_NAME = "crypto";
    private static final String[] JAR_RESOURCES = new String[]{"amazonCorrettoCryptoProvider", "crypto"};
    private static final Pattern TEST_FILENAME_PATTERN = Pattern.compile("[-a-zA-Z0-9]+(\\.[a-zA-Z0-9]+)*");
    private static final FileAttribute<Set<PosixFilePermission>> SELF_OWNER_FILE_PERMISSIONS = PosixFilePermissions.asFileAttribute(new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)));
    private static final Logger LOG = Logger.getLogger("AmazonCorrettoCryptoProvider");
    private static final Pattern OLD_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+)\\.\\d+");
    @Deprecated
    static final double PROVIDER_VERSION;
    static final String PROVIDER_VERSION_STR;
    static final boolean FIPS_BUILD;
    static final boolean IS_AVAILABLE;
    static final Throwable LOADING_ERROR;
    static final Janitor RESOURCE_JANITOR;

    Loader() {
    }

    static InputStream getTestData(String string) {
        if (!TEST_FILENAME_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException("Invalid filename: " + string);
        }
        InputStream inputStream = AccessController.doPrivileged(() -> Loader.class.getResourceAsStream("testdata/" + string));
        if (inputStream == null) {
            throw new AssertionError((Object)("Unable to load test data from file testdata/" + string));
        }
        return inputStream;
    }

    static String getProperty(String string) {
        return AccessController.doPrivileged(() -> System.getProperty(PROPERTY_BASE + string));
    }

    static String getProperty(String string, String string2) {
        return AccessController.doPrivileged(() -> System.getProperty(PROPERTY_BASE + string, string2));
    }

    private static void tryLoadLibraryFromJar() throws IOException {
        Path path = Loader.createPrivateTmpDir(TEMP_DIR_PREFIX);
        for (String string : JAR_RESOURCES) {
            String string2 = System.mapLibraryName(string);
            Loader.writeJarResourceToTemporaryFile(path, string2);
        }
        Path path2 = path.resolve(System.mapLibraryName(JNI_LIBRARY_NAME)).toAbsolutePath();
        System.load(path2.toString());
        Loader.validateLibcryptoVersion(false);
        Loader.maybeDeletePrivateTempDir(path);
    }

    private static void tryLoadLibraryFromSystem() {
        System.loadLibrary(JNI_LIBRARY_NAME);
        Loader.validateLibcryptoVersion(true);
    }

    private static void tryLoadLibrary() throws Exception {
        boolean bl = Boolean.parseBoolean(Loader.getProperty("useExternalLib", "false"));
        boolean bl2 = false;
        Exception exception = null;
        if (!bl) {
            try {
                Loader.tryLoadLibraryFromJar();
                bl2 = true;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (!bl2) {
            if (exception == null) {
                exception = new RuntimeCryptoException("Skipping bundled library due to system property");
            }
            try {
                Loader.tryLoadLibraryFromSystem();
            }
            catch (Throwable throwable) {
                exception.addSuppressed(throwable);
                throw exception;
            }
        }
    }

    static void load() {
    }

    static void checkNativeLibraryAvailability() {
        if (!IS_AVAILABLE) {
            throw new UnsupportedOperationException("Native library not available");
        }
    }

    private static native String getNativeLibraryVersion();

    private static native boolean validateLibcryptoVersion(boolean var0);

    private static native boolean isFipsMode();

    private static void assertVersionMatch() {
        String string;
        try {
            string = Loader.getNativeLibraryVersion();
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
        if (!PROVIDER_VERSION_STR.equals(string)) {
            throw new AssertionError((Object)String.format("Library version mismatch. Java: %s, Native: %s", PROVIDER_VERSION_STR, string));
        }
    }

    private static void maybeDelete(Path path) {
        if (!DebugFlag.PRESERVE_NATIVE_LIBRARIES.isEnabled()) {
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                LOG.warning("Unable to delete native library: " + iOException);
            }
        }
    }

    private static void maybeDeletePrivateTempDir(Path path) {
        for (String string : JAR_RESOURCES) {
            String string2 = System.mapLibraryName(string);
            Loader.maybeDelete(path.resolve(string2));
        }
        Loader.maybeDelete(path);
    }

    private static Path writeJarResourceToTemporaryFile(Path path, String string) throws IOException {
        Path path2 = path.resolve(string);
        Files.createFile(path2, SELF_OWNER_FILE_PERMISSIONS);
        try (InputStream inputStream = Loader.class.getResourceAsStream(string);
             OutputStream outputStream = Files.newOutputStream(path2, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            byte[] byArray = new byte[16384];
            int n = inputStream.read(byArray);
            while (n >= 0) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            outputStream.flush();
        }
        path2.toFile().deleteOnExit();
        return path2;
    }

    private static byte[] bootstrapRng(int n) throws IOException {
        Path path = Paths.get("/dev/urandom", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new AssertionError((Object)"/dev/urandom must exist for bootstrapping");
        }
        byte[] byArray = new byte[n];
        try (InputStream inputStream = Files.newInputStream(path, StandardOpenOption.READ);){
            for (int i = 0; i < 10; ++i) {
                if (inputStream.read(byArray) != byArray.length) continue;
                byte[] byArray2 = byArray;
                return byArray2;
            }
        }
        throw new AssertionError((Object)"Unable to read enough entropy");
    }

    private static synchronized Path createPrivateTmpDir(String string) throws IOException {
        Path path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        AssertionError assertionError = new AssertionError((Object)"Unable to create temporary directory. Retries exceeded.");
        for (int i = 0; i < 10; ++i) {
            try {
                byte[] byArray = Loader.bootstrapRng(8);
                StringBuilder stringBuilder = new StringBuilder(string);
                for (byte by : byArray) {
                    String string2 = Integer.toHexString(Byte.toUnsignedInt(by));
                    if (string2.length() == 1) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                }
                Path path2 = path.resolve(stringBuilder.toString());
                Path path3 = Files.createDirectories(path2, SELF_OWNER_FILE_PERMISSIONS);
                if (DebugFlag.VERBOSELOGS.isEnabled()) {
                    LOG.log(Level.FINE, "Created temporary library directory");
                }
                path3.toFile().deleteOnExit();
                return path3;
            }
            catch (IOException iOException) {
                assertionError = new AssertionError("Unable to create temporary directory due to IOException: " + iOException.getMessage(), iOException);
                continue;
            }
            catch (Exception exception) {
                throw new AssertionError("Unable to create temporary directory due to Exception: " + exception.getMessage(), exception);
            }
        }
        throw assertionError;
    }

    static {
        boolean bl = false;
        Object object = null;
        String string = null;
        double d = 0.0;
        try {
            string = AccessController.doPrivileged(() -> {
                try (InputStream inputStream = Loader.class.getResourceAsStream("version.properties");){
                    if (inputStream == null) {
                        String string = System.getProperty(PROPERTY_VERSION_STR);
                        return string;
                    }
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String string = properties.getProperty(PROPERTY_VERSION_STR);
                    return string;
                }
            });
            Matcher matcher = OLD_VERSION_PATTERN.matcher(string);
            if (!matcher.matches()) {
                throw new AssertionError((Object)("Version string has wrong form: " + string));
            }
            d = Double.parseDouble(matcher.group(1));
            bl = AccessController.doPrivileged(() -> {
                FileSystems.getDefault();
                Loader.tryLoadLibrary();
                return true;
            });
        }
        catch (Throwable throwable) {
            bl = false;
            object = throwable;
        }
        PROVIDER_VERSION_STR = string;
        PROVIDER_VERSION = d;
        boolean bl2 = FIPS_BUILD = bl && Loader.isFipsMode();
        if (bl) {
            try {
                Loader.assertVersionMatch();
            }
            catch (AssertionError assertionError) {
                bl = false;
                object = assertionError;
            }
        }
        IS_AVAILABLE = bl;
        LOADING_ERROR = object;
        if (DebugFlag.VERBOSELOGS.isEnabled()) {
            if (bl) {
                LOG.log(Level.CONFIG, "Successfully loaded native library version " + PROVIDER_VERSION_STR);
            } else {
                LOG.log(Level.CONFIG, "Unable to load native library", (Throwable)object);
            }
        }
        RESOURCE_JANITOR = new Janitor();
    }
}

