/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EcUtils;
import com.amazon.corretto.crypto.provider.EvpEcPrivateKey;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class EcGen
extends KeyPairGeneratorSpi {
    private static final ECGenParameterSpec DEFAULT_SPEC = new ECGenParameterSpec("secp384r1");
    private static final ConcurrentHashMap<EcUtils.ECInfo, ThreadLocal<NativeParams>> PARAM_CACHE = new ConcurrentHashMap();
    private static final Function<EcUtils.ECInfo, ThreadLocal<NativeParams>> CACHE_LOADER = eCInfo -> new ThreadLocal<NativeParams>(){

        @Override
        protected NativeParams initialValue() {
            return new NativeParams(EcGen.buildEcParams(eCInfo.nid));
        }
    };
    private final AmazonCorrettoCryptoProvider provider_;
    private ECParameterSpec spec = null;
    private byte[] encodedSpec = null;
    private EcUtils.ECInfo ecInfo = null;

    private static native long buildEcParams(int var0);

    private static native void freeEcParams(long var0);

    private static native long generateEvpEcKey(long var0, boolean var2);

    private static native long generateEvpEcKeyFromSpec(byte[] var0, boolean var1);

    EcGen(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
    }

    @Override
    public KeyPair generateKeyPair() {
        Object object;
        EvpEcPrivateKey evpEcPrivateKey;
        if (this.spec == null) {
            try {
                this.initialize(DEFAULT_SPEC, null);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeCryptoException(invalidAlgorithmParameterException);
            }
        }
        boolean bl = this.provider_.hasExtraCheck(ExtraCheck.KEY_PAIR_GENERATION_CONSISTENCY);
        if (this.encodedSpec != null) {
            evpEcPrivateKey = new EvpEcPrivateKey(EcGen.generateEvpEcKeyFromSpec(this.encodedSpec, bl));
        } else {
            object = EcGen.getParams(this.ecInfo);
            evpEcPrivateKey = new EvpEcPrivateKey(((NativeResource)object).use(l -> EcGen.generateEvpEcKey(l, bl)));
        }
        object = evpEcPrivateKey.getPublicKey();
        return new KeyPair((PublicKey)object, evpEcPrivateKey);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
            if (eCGenParameterSpec.getName() == null) {
                throw new NullPointerException("Curve name may not be null");
            }
            try {
                this.ecInfo = EcUtils.getSpecByName(eCGenParameterSpec.getName());
                this.spec = this.ecInfo.spec;
                this.encodedSpec = this.ecInfo.nid == 0 ? EcGen.encodeSpec(this.spec) : null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + eCGenParameterSpec.getName(), illegalArgumentException);
            }
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.ecInfo = null;
            this.spec = (ECParameterSpec)algorithmParameterSpec;
            this.encodedSpec = EcGen.encodeSpec(this.spec);
        } else {
            throw new InvalidAlgorithmParameterException("Unsupported parameter spec: " + algorithmParameterSpec);
        }
    }

    private static byte[] encodeSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
            algorithmParameters.init(algorithmParameterSpec);
            return algorithmParameters.getEncoded();
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RuntimeCryptoException(exception);
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) throws InvalidParameterException {
        try {
            String string;
            switch (n) {
                case 224: {
                    string = "secp224r1";
                    break;
                }
                case 256: {
                    string = "secp256r1";
                    break;
                }
                case 384: {
                    string = "secp384r1";
                    break;
                }
                case 521: {
                    string = "secp521r1";
                    break;
                }
                default: {
                    throw new InvalidParameterException("No default NIST prime curve for keysize " + n);
                }
            }
            this.initialize(new ECGenParameterSpec(string), secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    private static NativeParams getParams(EcUtils.ECInfo eCInfo) {
        return PARAM_CACHE.computeIfAbsent(eCInfo, CACHE_LOADER).get();
    }

    private static final class NativeParams
    extends NativeResource {
        private NativeParams(long l2) {
            super(l2, (long l) -> EcGen.freeEcParams(l));
        }
    }
}

