/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;

public class HostDifferences {
    private final Map<InetAddressAndPort, NavigableSet<Range<Token>>> perHostDifferences = new HashMap<InetAddressAndPort, NavigableSet<Range<Token>>>();
    private static final Comparator<Range<Token>> comparator = Comparator.comparing(o -> (Token)o.left);

    public void add(InetAddressAndPort endpoint, Collection<Range<Token>> difference) {
        TreeSet<Range<Token>> sortedDiffs = new TreeSet<Range<Token>>(comparator);
        sortedDiffs.addAll(difference);
        this.perHostDifferences.put(endpoint, sortedDiffs);
    }

    public void addSingleRange(InetAddressAndPort remoteNode, Range<Token> rangeToFetch) {
        this.perHostDifferences.computeIfAbsent(remoteNode, x -> new TreeSet<Range<Token>>(comparator)).add(rangeToFetch);
    }

    public boolean hasDifferencesFor(InetAddressAndPort node2, Range<Token> range) {
        NavigableSet<Range<Token>> differences = this.get(node2);
        if (differences.size() > 0 && ((Range)differences.last()).isWrapAround() && ((Range)differences.last()).intersects(range)) {
            return true;
        }
        block0: for (Range<Token> unwrappedRange : range.unwrap()) {
            Iterator<Range<Token>> iter;
            Range<Token> startKey = differences.floor(unwrappedRange);
            Iterator<Range<Token>> iterator = iter = startKey == null ? differences.iterator() : differences.tailSet(startKey, true).iterator();
            while (iter.hasNext()) {
                Range<Token> diff = iter.next();
                if (unwrappedRange.equals(diff) || unwrappedRange.intersects(diff)) {
                    return true;
                }
                if (((Token)unwrappedRange.right).compareTo((Token)diff.left) >= 0 || unwrappedRange.isWrapAround()) continue;
                continue block0;
            }
        }
        return false;
    }

    public Set<InetAddressAndPort> hosts() {
        return this.perHostDifferences.keySet();
    }

    public NavigableSet<Range<Token>> get(InetAddressAndPort differingHost) {
        return this.perHostDifferences.getOrDefault(differingHost, Collections.emptyNavigableSet());
    }

    public String toString() {
        return "HostDifferences{perHostDifferences=" + this.perHostDifferences + "}";
    }
}

