/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.Rebufferer;

@NotThreadSafe
public abstract class WrappingRebufferer
implements Rebufferer,
Rebufferer.BufferHolder {
    protected final Rebufferer wrapped;
    protected Rebufferer.BufferHolder bufferHolder;
    protected ByteBuffer buffer;
    protected long offset;

    public WrappingRebufferer(Rebufferer wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Rebufferer.BufferHolder rebuffer(long position) {
        assert (this.buffer == null);
        this.bufferHolder = this.wrapped.rebuffer(position);
        this.buffer = this.bufferHolder.buffer();
        this.offset = this.bufferHolder.offset();
        return this;
    }

    @Override
    public ChannelProxy channel() {
        return this.wrapped.channel();
    }

    @Override
    public long fileLength() {
        return this.wrapped.fileLength();
    }

    @Override
    public double getCrcCheckChance() {
        return this.wrapped.getCrcCheckChance();
    }

    @Override
    public void close() {
        assert (this.buffer == null) : "Rebufferer is attempted to be closed but the buffer holder has not been released";
        this.wrapped.close();
    }

    @Override
    public void closeReader() {
        this.wrapped.closeReader();
    }

    public String toString() {
        return String.format("%s[]:%s", this.getClass().getSimpleName(), this.wrapped.toString());
    }

    @Override
    public ByteBuffer buffer() {
        assert (this.buffer != null) : "Buffer holder has not been acquired";
        return this.buffer;
    }

    @Override
    public long offset() {
        assert (this.buffer != null) : "Buffer holder has not been acquired";
        return this.offset;
    }

    @Override
    public void release() {
        assert (this.buffer != null);
        if (this.bufferHolder != null) {
            this.bufferHolder.release();
            this.bufferHolder = null;
        }
        this.buffer = null;
    }
}

