/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;

class PartitionIterator
extends PartitionIndex.IndexPosIterator
implements KeyReader {
    private final PartitionIndex partitionIndex;
    private final IPartitioner partitioner;
    private final PartitionPosition limit;
    private final int exclusiveLimit;
    private final FileHandle dataFile;
    private final FileHandle rowIndexFile;
    private final Version version;
    private FileDataInput dataInput;
    private FileDataInput indexInput;
    private DecoratedKey currentKey;
    private TrieIndexEntry currentEntry;
    private DecoratedKey nextKey;
    private TrieIndexEntry nextEntry;

    static PartitionIterator create(PartitionIndex partitionIndex, IPartitioner partitioner, FileHandle rowIndexFile, FileHandle dataFile, PartitionPosition left, int inclusiveLeft, PartitionPosition right, int exclusiveRight, Version version) throws IOException {
        PartitionIterator partitionIterator = null;
        PartitionIndex partitionIndexCopy = null;
        FileHandle dataFileCopy = null;
        FileHandle rowIndexFileCopy = null;
        try {
            partitionIndexCopy = partitionIndex.sharedCopy();
            dataFileCopy = dataFile.sharedCopy();
            rowIndexFileCopy = rowIndexFile.sharedCopy();
            partitionIterator = new PartitionIterator(partitionIndexCopy, partitioner, rowIndexFileCopy, dataFileCopy, left, right, exclusiveRight, version);
            partitionIterator.readNext();
            if (partitionIterator.nextKey != null && partitionIterator.nextKey.compareTo(left) <= inclusiveLeft) {
                partitionIterator.readNext();
            }
            partitionIterator.advance();
            return partitionIterator;
        }
        catch (Throwable ex) {
            if (partitionIterator != null) {
                partitionIterator.close();
            } else {
                Throwables.closeNonNullAndAddSuppressed(ex, rowIndexFileCopy, dataFileCopy, partitionIndexCopy);
            }
            throw ex;
        }
    }

    static PartitionIterator create(PartitionIndex partitionIndex, IPartitioner partitioner, FileHandle rowIndexFile, FileHandle dataFile, Version version) throws IOException {
        return PartitionIterator.create(partitionIndex, partitioner, rowIndexFile, dataFile, partitionIndex.firstKey(), -1, partitionIndex.lastKey(), 0, version);
    }

    static PartitionIterator empty(PartitionIndex partitionIndex) {
        return new PartitionIterator(partitionIndex.sharedCopy(), null);
    }

    private PartitionIterator(PartitionIndex partitionIndex, IPartitioner partitioner, FileHandle rowIndexFile, FileHandle dataFile, PartitionPosition left, PartitionPosition right, int exclusiveRight, Version version) {
        super(partitionIndex, left, right);
        this.partitionIndex = partitionIndex;
        this.partitioner = partitioner;
        this.limit = right;
        this.exclusiveLimit = exclusiveRight;
        this.rowIndexFile = rowIndexFile;
        this.dataFile = dataFile;
        this.version = version;
    }

    private PartitionIterator(PartitionIndex partitionIndex, Version version) {
        super(partitionIndex, partitionIndex.firstKey(), partitionIndex.firstKey());
        this.partitionIndex = partitionIndex;
        this.partitioner = null;
        this.limit = partitionIndex.firstKey();
        this.exclusiveLimit = -1;
        this.rowIndexFile = null;
        this.dataFile = null;
        this.currentEntry = null;
        this.currentKey = null;
        this.nextEntry = null;
        this.nextKey = null;
        this.version = version;
    }

    @Override
    public void close() {
        Throwable accum = null;
        accum = Throwables.close(accum, FBUtilities.immutableListWithFilteredNulls(this.partitionIndex, this.dataFile, this.rowIndexFile));
        accum = Throwables.close(accum, FBUtilities.immutableListWithFilteredNulls(this.dataInput, this.indexInput));
        accum = Throwables.perform(accum, () -> super.close());
        Throwables.maybeFail(accum);
    }

    public DecoratedKey decoratedKey() {
        return this.currentKey;
    }

    @Override
    public ByteBuffer key() {
        return this.currentKey.getKey();
    }

    @Override
    public long dataPosition() {
        return this.currentEntry != null ? this.currentEntry.position : -1L;
    }

    @Override
    public long keyPositionForSecondaryIndex() {
        return this.dataPosition();
    }

    public TrieIndexEntry entry() {
        return this.currentEntry;
    }

    @Override
    public boolean advance() throws IOException {
        this.currentKey = this.nextKey;
        this.currentEntry = this.nextEntry;
        if (this.currentKey != null) {
            this.readNext();
            if (this.nextKey == null && this.limit != null && this.currentKey.compareTo(this.limit) > this.exclusiveLimit) {
                this.currentKey = null;
                this.currentEntry = null;
                return false;
            }
            return true;
        }
        return false;
    }

    private void readNext() throws IOException {
        long pos = this.nextIndexPos();
        if (pos != Long.MIN_VALUE) {
            if (pos >= 0L) {
                this.seekIndexInput(pos);
                this.nextKey = this.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.indexInput));
                this.nextEntry = TrieIndexEntry.deserialize(this.indexInput, this.indexInput.getFilePointer(), this.version);
            } else {
                this.seekDataInput(pos ^= 0xFFFFFFFFFFFFFFFFL);
                this.nextKey = this.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.dataInput));
                this.nextEntry = new TrieIndexEntry(pos);
            }
        } else {
            this.nextKey = null;
            this.nextEntry = null;
        }
    }

    private void seekIndexInput(long pos) throws IOException {
        if (this.indexInput == null) {
            this.indexInput = this.rowIndexFile.createReader(pos);
        } else {
            this.indexInput.seek(pos);
        }
    }

    private void seekDataInput(long pos) throws IOException {
        if (this.dataInput == null) {
            this.dataInput = this.dataFile.createReader(pos);
        } else {
            this.dataInput.seek(pos);
        }
    }

    @Override
    public boolean isExhausted() {
        return this.currentKey == null;
    }

    @Override
    public void reset() {
        this.go(this.root);
    }

    @Override
    public String toString() {
        return String.format("BTI-PartitionIterator(%s)", this.partitionIndex.getFileHandle().path());
    }
}

