/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.lifecycle.ILifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SSTableRewriter
extends Transactional.AbstractTransactional
implements Transactional {
    @VisibleForTesting
    public static boolean disableEarlyOpeningForTests = false;
    private final long preemptiveOpenInterval;
    private final long maxAge;
    private long repairedAt = -1L;
    private final ILifecycleTransaction transaction;
    private final List<SSTableReader> preparedForCommit = new ArrayList<SSTableReader>();
    private long currentlyOpenedEarlyAt;
    private long bytesWritten;
    private final List<SSTableWriter> writers = new ArrayList<SSTableWriter>();
    private final boolean keepOriginals;
    private final boolean eagerWriterMetaRelease;
    private SSTableWriter writer;
    private boolean throwEarly;
    private boolean throwLate;

    @Deprecated(since="3.4")
    public SSTableRewriter(ILifecycleTransaction transaction, long maxAge, long preemptiveOpenInterval, boolean keepOriginals) {
        this(transaction, maxAge, preemptiveOpenInterval, keepOriginals, false);
    }

    SSTableRewriter(ILifecycleTransaction transaction, long maxAge, long preemptiveOpenInterval, boolean keepOriginals, boolean eagerWriterMetaRelease) {
        this.transaction = transaction;
        this.maxAge = maxAge;
        this.preemptiveOpenInterval = preemptiveOpenInterval;
        this.keepOriginals = keepOriginals;
        this.eagerWriterMetaRelease = eagerWriterMetaRelease;
    }

    public static SSTableRewriter constructKeepingOriginals(ILifecycleTransaction transaction, boolean keepOriginals, long maxAge) {
        return new SSTableRewriter(transaction, maxAge, SSTableRewriter.calculateOpenInterval(true), keepOriginals, true);
    }

    public static SSTableRewriter constructWithoutEarlyOpening(ILifecycleTransaction transaction, boolean keepOriginals, long maxAge) {
        return new SSTableRewriter(transaction, maxAge, SSTableRewriter.calculateOpenInterval(false), keepOriginals, true);
    }

    public static SSTableRewriter construct(ColumnFamilyStore cfs, ILifecycleTransaction transaction, boolean keepOriginals, long maxAge) {
        return new SSTableRewriter(transaction, maxAge, SSTableRewriter.calculateOpenInterval(cfs.supportsEarlyOpen()), keepOriginals, true);
    }

    private static long calculateOpenInterval(boolean shouldOpenEarly) {
        long interval = (long)DatabaseDescriptor.getSSTablePreemptiveOpenIntervalInMiB() * 0x100000L;
        if (disableEarlyOpeningForTests || !shouldOpenEarly || interval < 0L) {
            interval = Long.MAX_VALUE;
        }
        return interval;
    }

    public SSTableWriter currentWriter() {
        return this.writer;
    }

    public long bytesWritten() {
        return this.bytesWritten + (this.writer == null ? 0L : this.writer.getFilePointer());
    }

    public void forEachWriter(Consumer<SSTableWriter> op) {
        for (SSTableWriter writer : this.writers) {
            op.accept(writer);
        }
        if (this.writer != null) {
            op.accept(this.writer);
        }
    }

    public AbstractRowIndexEntry append(UnfilteredRowIterator partition) {
        DecoratedKey key = partition.partitionKey();
        this.maybeReopenEarly(key);
        return this.writer.append(partition);
    }

    public AbstractRowIndexEntry tryAppend(UnfilteredRowIterator partition) {
        this.writer.mark();
        try {
            return this.append(partition);
        }
        catch (Throwable t) {
            this.writer.resetAndTruncate();
            throw t;
        }
    }

    private void maybeReopenEarly(DecoratedKey key) {
        if (this.writer.getFilePointer() - this.currentlyOpenedEarlyAt > this.preemptiveOpenInterval) {
            if (this.transaction.isOffline()) {
                for (SSTableReader reader2 : this.transaction.originals()) {
                    reader2.trySkipFileCacheBefore(key);
                }
            } else {
                this.writer.setMaxDataAge(this.maxAge);
                this.writer.openEarly(reader -> {
                    this.transaction.update((SSTableReader)reader, false);
                    this.currentlyOpenedEarlyAt = this.writer.getFilePointer();
                    this.moveStarts(reader.getLast());
                    this.transaction.checkpoint();
                });
            }
        }
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        for (SSTableWriter writer : this.writers) {
            accumulate = writer.abort(accumulate);
        }
        accumulate = this.transaction.abort(accumulate);
        return accumulate;
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        for (SSTableWriter writer : this.writers) {
            accumulate = writer.commit(accumulate);
        }
        accumulate = this.transaction.commit(accumulate);
        return accumulate;
    }

    private void moveStarts(DecoratedKey lowerbound) {
        if (this.transaction.isOffline() || this.preemptiveOpenInterval == Long.MAX_VALUE) {
            return;
        }
        for (SSTableReader sstable : this.transaction.originals()) {
            SSTableReader latest = this.transaction.current(sstable);
            if (latest.getFirst().compareTo(lowerbound) > 0) continue;
            if (lowerbound.compareTo(latest.getLast()) >= 0) {
                if (this.transaction.isObsolete(latest)) continue;
                this.transaction.obsolete(latest);
                continue;
            }
            if (this.transaction.isObsolete(latest)) continue;
            DecoratedKey newStart = latest.firstKeyBeyond(lowerbound);
            assert (newStart != null);
            SSTableReader replacement = latest.cloneWithNewStart(newStart);
            this.transaction.update(replacement, true);
        }
    }

    public void switchWriter(SSTableWriter newWriter) {
        if (newWriter != null) {
            newWriter.setMaxDataAge(this.maxAge);
            this.writers.add(newWriter);
        }
        if (this.eagerWriterMetaRelease && this.writer != null) {
            this.writer.releaseMetadataOverhead();
        }
        if (this.writer == null || this.writer.getFilePointer() == 0L) {
            if (this.writer != null) {
                this.writer.abort();
                this.transaction.untrackNew(this.writer);
                this.writers.remove(this.writer);
            }
            this.writer = newWriter;
            return;
        }
        if (this.preemptiveOpenInterval != Long.MAX_VALUE) {
            this.writer.setMaxDataAge(this.maxAge);
            SSTableReader reader = this.writer.openFinalEarly();
            this.transaction.update(reader, false);
            this.moveStarts(reader.getLast());
            this.transaction.checkpoint();
        }
        this.currentlyOpenedEarlyAt = 0L;
        this.bytesWritten += this.writer.getFilePointer();
        this.writer.onSSTableWriterSwitched();
        this.writer = newWriter;
    }

    public SSTableRewriter setRepairedAt(long repairedAt) {
        this.repairedAt = repairedAt;
        return this;
    }

    @Override
    public List<SSTableReader> finish() {
        super.finish();
        return this.finished();
    }

    public List<SSTableReader> finished() {
        assert (this.state() == Transactional.AbstractTransactional.State.COMMITTED || this.state() == Transactional.AbstractTransactional.State.READY_TO_COMMIT);
        return this.preparedForCommit;
    }

    @Override
    protected void doPrepare() {
        this.switchWriter(null);
        if (this.throwEarly) {
            throw new RuntimeException("exception thrown early in finish, for testing");
        }
        for (SSTableWriter writer : this.writers) {
            assert (writer.getFilePointer() > 0L);
            writer.setRepairedAt(this.repairedAt);
            writer.setOpenResult(true);
            writer.prepareToCommit();
            SSTableReader reader = writer.finished();
            this.transaction.update(reader, false);
            this.preparedForCommit.add(reader);
        }
        this.transaction.checkpoint();
        if (this.throwLate) {
            throw new RuntimeException("exception thrown after all sstables finished, for testing");
        }
        if (!this.keepOriginals) {
            this.transaction.obsoleteOriginals();
        }
        this.transaction.prepareToCommit();
    }

    public void throwDuringPrepare(boolean earlyException) {
        if (earlyException) {
            this.throwEarly = true;
        } else {
            this.throwLate = true;
        }
    }
}

