/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;

public class KeyRangeConcatIterator
extends KeyRangeIterator {
    public static final String MUST_BE_SORTED_ERROR = "RangeIterator must be sorted, previous max: %s, next min: %s";
    private final List<KeyRangeIterator> ranges;
    private int current;

    protected KeyRangeConcatIterator(KeyRangeIterator.Builder.Statistics statistics, List<KeyRangeIterator> ranges, Runnable onClose) {
        super(statistics, onClose);
        if (ranges.isEmpty()) {
            throw new IllegalArgumentException("Cannot concatenate empty list of ranges");
        }
        this.current = 0;
        this.ranges = ranges;
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        KeyRangeIterator currentIterator;
        while (!(this.current >= this.ranges.size() || (currentIterator = this.ranges.get(this.current)).hasNext() && ((PrimaryKey)currentIterator.peek()).compareTo(nextKey, false) >= 0)) {
            if (currentIterator.getMaximum().compareTo(nextKey, false) >= 0) {
                currentIterator.skipTo(nextKey);
                break;
            }
            ++this.current;
        }
    }

    @Override
    protected PrimaryKey computeNext() {
        while (this.current < this.ranges.size()) {
            KeyRangeIterator currentIterator = this.ranges.get(this.current);
            if (currentIterator.hasNext()) {
                return (PrimaryKey)currentIterator.next();
            }
            ++this.current;
        }
        return (PrimaryKey)this.endOfData();
    }

    @Override
    public void close() {
        super.close();
        FileUtils.closeQuietly(this.ranges);
    }

    public static Builder builder(int size) {
        return KeyRangeConcatIterator.builder(size, () -> {});
    }

    public static Builder builder(int size, Runnable onClose) {
        return new Builder(size, onClose);
    }

    private static class ConcatStatistics
    extends KeyRangeIterator.Builder.Statistics {
        private ConcatStatistics() {
        }

        @Override
        public void update(KeyRangeIterator range) {
            if (range.getMaxKeys() > 0L) {
                if (this.count == 0L) {
                    this.min = range.getMinimum();
                } else if (this.count > 0L && this.max.compareTo(range.getMinimum(), false) > 0) {
                    throw new IllegalArgumentException(String.format(KeyRangeConcatIterator.MUST_BE_SORTED_ERROR, this.max, range.getMinimum()));
                }
                this.max = range.getMaximum();
                this.count += range.getMaxKeys();
            }
        }
    }

    @VisibleForTesting
    public static class Builder
    extends KeyRangeIterator.Builder {
        private final List<KeyRangeIterator> ranges;

        Builder(int size, Runnable onClose) {
            super(new ConcatStatistics(), onClose);
            this.ranges = new ArrayList<KeyRangeIterator>(size);
        }

        @Override
        public KeyRangeIterator.Builder add(KeyRangeIterator range) {
            if (range == null) {
                return this;
            }
            if (range.getMaxKeys() > 0L) {
                this.ranges.add(range);
            } else {
                FileUtils.closeQuietly(range);
            }
            this.statistics.update(range);
            return this;
        }

        @Override
        public int rangeCount() {
            return this.ranges.size();
        }

        @Override
        public void cleanup() {
            super.cleanup();
            FileUtils.closeQuietly(this.ranges);
        }

        @Override
        protected KeyRangeIterator buildIterator() {
            if (this.rangeCount() == 0) {
                this.onClose.run();
                return KeyRangeIterator.empty();
            }
            if (this.rangeCount() == 1) {
                KeyRangeIterator single = this.ranges.get(0);
                single.setOnClose(this.onClose);
                return single;
            }
            return new KeyRangeConcatIterator(this.statistics, this.ranges, this.onClose);
        }
    }
}

