/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.util.List;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.SinglePartitionReadQuery;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.RowIterators;
import org.apache.cassandra.db.transform.MorePartitions;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.AbstractIterator;

public abstract class PartitionIterators {
    private PartitionIterators() {
    }

    public static RowIterator getOnlyElement(PartitionIterator iter, SinglePartitionReadQuery query) {
        RowIterator toReturn = iter.hasNext() ? (RowIterator)iter.next() : EmptyIterators.row(query.metadata(), query.partitionKey(), query.clusteringIndexFilter().isReversed());
        class Close
        extends Transformation {
            final /* synthetic */ PartitionIterator val$iter;

            Close(PartitionIterator partitionIterator) {
                this.val$iter = partitionIterator;
            }

            @Override
            public void onPartitionClose() {
                boolean hadNext = this.val$iter.hasNext();
                this.val$iter.close();
                assert (!hadNext);
            }
        }
        return Transformation.apply(toReturn, new Close(iter));
    }

    public static PartitionIterator concat(List<PartitionIterator> iterators) {
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        class Extend
        implements MorePartitions<PartitionIterator> {
            int i = 0;
            final /* synthetic */ List val$iterators;

            Extend(List list) {
                this.val$iterators = list;
            }

            @Override
            public PartitionIterator moreContents() {
                if (this.i >= this.val$iterators.size()) {
                    return null;
                }
                return (PartitionIterator)this.val$iterators.get(this.i++);
            }
        }
        return MorePartitions.extend(EmptyIterators.partition(), new Extend(iterators));
    }

    public static PartitionIterator singletonIterator(RowIterator iterator) {
        return new SingletonPartitionIterator(iterator);
    }

    public static void consume(PartitionIterator iterator) {
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            try {
                while (partition.hasNext()) {
                    partition.next();
                }
            }
            finally {
                if (partition == null) continue;
                partition.close();
            }
        }
    }

    public static PartitionIterator loggingIterator(PartitionIterator iterator, String id) {
        class Logger
        extends Transformation<RowIterator> {
            final /* synthetic */ String val$id;

            Logger(String string) {
                this.val$id = string;
            }

            @Override
            public RowIterator applyToPartition(RowIterator partition) {
                return RowIterators.loggingIterator(partition, this.val$id);
            }
        }
        return Transformation.apply(iterator, new Logger(id));
    }

    public static PartitionIterator doOnClose(final PartitionIterator delegate, final Runnable action) {
        return new PartitionIterator(){

            @Override
            public void close() {
                try {
                    delegate.close();
                }
                finally {
                    action.run();
                }
            }

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public RowIterator next() {
                return (RowIterator)delegate.next();
            }
        };
    }

    private static class SingletonPartitionIterator
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final RowIterator iterator;
        private boolean returned;

        private SingletonPartitionIterator(RowIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        protected RowIterator computeNext() {
            if (this.returned) {
                return (RowIterator)this.endOfData();
            }
            this.returned = true;
            return this.iterator;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }
}

