/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import java.nio.ByteBuffer;
import org.apache.cassandra.transport.ProtocolVersion;

public final class CodecUtils {
    private static final long MAX_CQL_LONG_VALUE = 0xFFFFFFFFL;
    private static final long EPOCH_AS_CQL_LONG = 0x80000000L;

    private CodecUtils() {
    }

    public static ByteBuffer pack(ByteBuffer[] buffers, int elements, ProtocolVersion version) {
        int size = 0;
        for (ByteBuffer bb : buffers) {
            int elemSize = CodecUtils.sizeOfValue(bb, version);
            size += elemSize;
        }
        ByteBuffer result = ByteBuffer.allocate(CodecUtils.sizeOfCollectionSize(version) + size);
        CodecUtils.writeSize(result, elements, version);
        for (ByteBuffer bb : buffers) {
            CodecUtils.writeValue(result, bb, version);
        }
        return result.flip();
    }

    static int readSize(ByteBuffer input, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return CodecUtils.getUnsignedShort(input);
            }
            case V3: 
            case V4: 
            case V5: 
            case V6: {
                return input.getInt();
            }
        }
        throw new IllegalArgumentException(String.valueOf(version));
    }

    private static void writeSize(ByteBuffer output, int size, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                if (size > 65535) {
                    throw new IllegalArgumentException(String.format("Native protocol version %d supports up to 65535 elements in any collection - but collection contains %d elements", version.asInt(), size));
                }
                output.putShort((short)size);
                break;
            }
            case V3: 
            case V4: 
            case V5: 
            case V6: {
                output.putInt(size);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(version));
            }
        }
    }

    public static ByteBuffer readValue(ByteBuffer input, ProtocolVersion version) {
        int size = CodecUtils.readSize(input, version);
        return size < 0 ? null : CodecUtils.readBytes(input, size);
    }

    public static void writeValue(ByteBuffer output, ByteBuffer value, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                assert (value != null);
                output.putShort((short)value.remaining());
                output.put(value.duplicate());
                break;
            }
            case V3: 
            case V4: 
            case V5: 
            case V6: {
                if (value == null) {
                    output.putInt(-1);
                    break;
                }
                output.putInt(value.remaining());
                output.put(value.duplicate());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(version));
            }
        }
    }

    public static ByteBuffer readBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    static int fromUnsignedToSignedInt(int unsigned) {
        return unsigned + Integer.MIN_VALUE;
    }

    static int fromSignedToUnsignedInt(int signed) {
        return signed - Integer.MIN_VALUE;
    }

    static int fromCqlDateToDaysSinceEpoch(long raw) {
        if (raw < 0L || raw > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("Numeric literals for DATE must be between 0 and %d (got %d)", 0xFFFFFFFFL, raw));
        }
        return (int)(raw - 0x80000000L);
    }

    private static int sizeOfCollectionSize(ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return 2;
            }
            case V3: 
            case V4: 
            case V5: 
            case V6: {
                return 4;
            }
        }
        throw new IllegalArgumentException(String.valueOf(version));
    }

    private static int sizeOfValue(ByteBuffer value, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                int elemSize = value.remaining();
                if (elemSize > 65535) {
                    throw new IllegalArgumentException(String.format("Native protocol version %d supports only elements with size up to 65535 bytes - but element size is %d bytes", version.asInt(), elemSize));
                }
                return 2 + elemSize;
            }
            case V3: 
            case V4: 
            case V5: 
            case V6: {
                return value == null ? 4 : 4 + value.remaining();
            }
        }
        throw new IllegalArgumentException(String.valueOf(version));
    }

    private static int getUnsignedShort(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }
}

