/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcmon;

import org.gridkit.jvmtool.event.SimpleCounterCollection;
import org.gridkit.jvmtool.event.SimpleTagCollection;
import org.gridkit.jvmtool.gcmon.MemoryPoolInfoEvent;
import org.gridkit.jvmtool.gcmon.MemoryUsageBean;

public class MemoryInfoEventPojo
implements MemoryPoolInfoEvent {
    private long timestamp;
    private SimpleTagCollection tags = new SimpleTagCollection();
    private SimpleCounterCollection counters = new SimpleCounterCollection();

    public long timestamp() {
        return this.timestamp;
    }

    public void timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public SimpleCounterCollection counters() {
        return this.counters;
    }

    public SimpleTagCollection tags() {
        return this.tags;
    }

    @Override
    public String name() {
        return this.tags.firstTagFor("jvm.memory-pool.name");
    }

    public void name(String value) {
        this.tags.put("jvm.memory-pool.name", value);
    }

    @Override
    public boolean nonHeap() {
        return this.tags.firstTagFor("jvm.memory-pool.nonHeap") != null;
    }

    public void nonHeap(boolean nonHeap) {
        if (nonHeap) {
            this.tags.put("jvm.memory-pool.nonHeap", "");
        }
    }

    @Override
    public Iterable<String> memoryManagers() {
        return this.tags.tagsFor("jvm.memory-pool.memoryManager");
    }

    @Override
    public MemoryUsageBean peakUsage() {
        return this.readMemUsage("jvm.memory-pool.memoryPeak");
    }

    public void peakUsage(MemoryUsageBean usage) {
        this.storeMemUsage("jvm.memory-pool.memoryPeak", usage);
    }

    @Override
    public MemoryUsageBean currentUsage() {
        return this.readMemUsage("jvm.memory-pool.memoryUsage");
    }

    public void currentUsage(MemoryUsageBean usage) {
        this.storeMemUsage("jvm.memory-pool.memoryUsage", usage);
    }

    @Override
    public MemoryUsageBean collectionUsage() {
        return this.readMemUsage("jvm.memory-pool.collectionUsage");
    }

    public void collectionUsage(MemoryUsageBean usage) {
        this.storeMemUsage("jvm.memory-pool.collectionUsage", usage);
    }

    private MemoryUsageBean readMemUsage(String name) {
        if (this.counters.getValue(name + "." + "init") >= 0L) {
            return new MemoryUsageBean(this.counters.getValue(name + "." + "init"), this.counters.getValue(name + "." + "used"), this.counters.getValue(name + "." + "committed"), this.counters.getValue(name + "." + "max"));
        }
        return null;
    }

    private void storeMemUsage(String name, MemoryUsageBean bean) {
        this.counters.set(name + "." + "init", bean.init());
        this.counters.set(name + "." + "used", bean.used());
        this.counters.set(name + "." + "committed", bean.committed());
        this.counters.set(name + "." + "max", bean.max());
    }
}

