/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.util.AbstractInterner;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import org.jetbrains.annotations.NotNull;

public class UTF8StringInterner
extends AbstractInterner<String> {
    private static final StringBuilderPool SBP = new StringBuilderPool();

    public UTF8StringInterner(@NonNegative int capacity) throws IllegalArgumentException {
        super(capacity);
    }

    @Override
    @NotNull
    protected String getValue(@NotNull BytesStore cs, @NonNegative int length) throws UTFDataFormatRuntimeException, IllegalStateException, BufferUnderflowException {
        StringBuilder sb = SBP.acquireStringBuilder();
        AppendableUtil.parseUtf8(cs, sb, true, length);
        return sb.toString();
    }
}

