"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Protocol Buffers describing Beam Schemas, a portable representation for
complex types.

The primary application of Schema is as the payload for the standard coder
"beam:coder:row:v1", defined in beam_runner_api.proto
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AtomicType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AtomicTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AtomicType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNSPECIFIED: _AtomicType.ValueType  # 0
    BYTE: _AtomicType.ValueType  # 1
    INT16: _AtomicType.ValueType  # 2
    INT32: _AtomicType.ValueType  # 3
    INT64: _AtomicType.ValueType  # 4
    FLOAT: _AtomicType.ValueType  # 5
    DOUBLE: _AtomicType.ValueType  # 6
    STRING: _AtomicType.ValueType  # 7
    BOOLEAN: _AtomicType.ValueType  # 8
    BYTES: _AtomicType.ValueType  # 9

class AtomicType(_AtomicType, metaclass=_AtomicTypeEnumTypeWrapper): ...

UNSPECIFIED: AtomicType.ValueType  # 0
BYTE: AtomicType.ValueType  # 1
INT16: AtomicType.ValueType  # 2
INT32: AtomicType.ValueType  # 3
INT64: AtomicType.ValueType  # 4
FLOAT: AtomicType.ValueType  # 5
DOUBLE: AtomicType.ValueType  # 6
STRING: AtomicType.ValueType  # 7
BOOLEAN: AtomicType.ValueType  # 8
BYTES: AtomicType.ValueType  # 9
global___AtomicType = AtomicType

@typing_extensions.final
class Schema(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELDS_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    ENCODING_POSITIONS_SET_FIELD_NUMBER: builtins.int
    @property
    def fields(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Field]:
        """List of fields for this schema. Two fields may not share a name."""
    id: builtins.str
    """REQUIRED. An RFC 4122 UUID."""
    @property
    def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Option]: ...
    encoding_positions_set: builtins.bool
    """Indicates that encoding positions have been overridden."""
    def __init__(
        self,
        *,
        fields: collections.abc.Iterable[global___Field] | None = ...,
        id: builtins.str | None = ...,
        options: collections.abc.Iterable[global___Option] | None = ...,
        encoding_positions_set: builtins.bool | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["encoding_positions_set", b"encoding_positions_set", "fields", b"fields", "id", b"id", "options", b"options"]) -> None: ...

global___Schema = Schema

@typing_extensions.final
class Field(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    ENCODING_POSITION_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """REQUIRED. Name of this field within the schema."""
    description: builtins.str
    """OPTIONAL. Human readable description of this field, such as the query that generated it."""
    @property
    def type(self) -> global___FieldType: ...
    id: builtins.int
    encoding_position: builtins.int
    """OPTIONAL. The position of this field's data when encoded, e.g. with beam:coder:row:v1.
    Either no fields in a given row are have encoding position populated,
    or all of them are. Used to support backwards compatibility with schema
    changes.
    If no fields have encoding position populated the order of encoding is the same as the order in the Schema.
    If this Field is part of a Schema where encoding_positions_set is True then encoding_position must be
    defined, otherwise this field is ignored.
    """
    @property
    def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Option]: ...
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        description: builtins.str | None = ...,
        type: global___FieldType | None = ...,
        id: builtins.int | None = ...,
        encoding_position: builtins.int | None = ...,
        options: collections.abc.Iterable[global___Option] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "encoding_position", b"encoding_position", "id", b"id", "name", b"name", "options", b"options", "type", b"type"]) -> None: ...

global___Field = Field

@typing_extensions.final
class FieldType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NULLABLE_FIELD_NUMBER: builtins.int
    ATOMIC_TYPE_FIELD_NUMBER: builtins.int
    ARRAY_TYPE_FIELD_NUMBER: builtins.int
    ITERABLE_TYPE_FIELD_NUMBER: builtins.int
    MAP_TYPE_FIELD_NUMBER: builtins.int
    ROW_TYPE_FIELD_NUMBER: builtins.int
    LOGICAL_TYPE_FIELD_NUMBER: builtins.int
    nullable: builtins.bool
    atomic_type: global___AtomicType.ValueType
    @property
    def array_type(self) -> global___ArrayType: ...
    @property
    def iterable_type(self) -> global___IterableType: ...
    @property
    def map_type(self) -> global___MapType: ...
    @property
    def row_type(self) -> global___RowType: ...
    @property
    def logical_type(self) -> global___LogicalType: ...
    def __init__(
        self,
        *,
        nullable: builtins.bool | None = ...,
        atomic_type: global___AtomicType.ValueType | None = ...,
        array_type: global___ArrayType | None = ...,
        iterable_type: global___IterableType | None = ...,
        map_type: global___MapType | None = ...,
        row_type: global___RowType | None = ...,
        logical_type: global___LogicalType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["array_type", b"array_type", "atomic_type", b"atomic_type", "iterable_type", b"iterable_type", "logical_type", b"logical_type", "map_type", b"map_type", "row_type", b"row_type", "type_info", b"type_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["array_type", b"array_type", "atomic_type", b"atomic_type", "iterable_type", b"iterable_type", "logical_type", b"logical_type", "map_type", b"map_type", "nullable", b"nullable", "row_type", b"row_type", "type_info", b"type_info"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type_info", b"type_info"]) -> typing_extensions.Literal["atomic_type", "array_type", "iterable_type", "map_type", "row_type", "logical_type"] | None: ...

global___FieldType = FieldType

@typing_extensions.final
class ArrayType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_TYPE_FIELD_NUMBER: builtins.int
    @property
    def element_type(self) -> global___FieldType: ...
    def __init__(
        self,
        *,
        element_type: global___FieldType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["element_type", b"element_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["element_type", b"element_type"]) -> None: ...

global___ArrayType = ArrayType

@typing_extensions.final
class IterableType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_TYPE_FIELD_NUMBER: builtins.int
    @property
    def element_type(self) -> global___FieldType: ...
    def __init__(
        self,
        *,
        element_type: global___FieldType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["element_type", b"element_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["element_type", b"element_type"]) -> None: ...

global___IterableType = IterableType

@typing_extensions.final
class MapType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_TYPE_FIELD_NUMBER: builtins.int
    VALUE_TYPE_FIELD_NUMBER: builtins.int
    @property
    def key_type(self) -> global___FieldType: ...
    @property
    def value_type(self) -> global___FieldType: ...
    def __init__(
        self,
        *,
        key_type: global___FieldType | None = ...,
        value_type: global___FieldType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["key_type", b"key_type", "value_type", b"value_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["key_type", b"key_type", "value_type", b"value_type"]) -> None: ...

global___MapType = MapType

@typing_extensions.final
class RowType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCHEMA_FIELD_NUMBER: builtins.int
    @property
    def schema(self) -> global___Schema: ...
    def __init__(
        self,
        *,
        schema: global___Schema | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["schema", b"schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["schema", b"schema"]) -> None: ...

global___RowType = RowType

@typing_extensions.final
class LogicalType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URN_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    REPRESENTATION_FIELD_NUMBER: builtins.int
    ARGUMENT_TYPE_FIELD_NUMBER: builtins.int
    ARGUMENT_FIELD_NUMBER: builtins.int
    urn: builtins.str
    payload: builtins.bytes
    @property
    def representation(self) -> global___FieldType: ...
    @property
    def argument_type(self) -> global___FieldType: ...
    @property
    def argument(self) -> global___FieldValue: ...
    def __init__(
        self,
        *,
        urn: builtins.str | None = ...,
        payload: builtins.bytes | None = ...,
        representation: global___FieldType | None = ...,
        argument_type: global___FieldType | None = ...,
        argument: global___FieldValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["argument", b"argument", "argument_type", b"argument_type", "representation", b"representation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["argument", b"argument", "argument_type", b"argument_type", "payload", b"payload", "representation", b"representation", "urn", b"urn"]) -> None: ...

global___LogicalType = LogicalType

@typing_extensions.final
class LogicalTypes(google.protobuf.message.Message):
    """Universally defined Logical types for Row schemas.
    These logical types are supposed to be understood by all SDKs.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LogicalTypes._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PYTHON_CALLABLE: LogicalTypes._Enum.ValueType  # 0
        """A URN for Python Callable logical type
          - Representation type: STRING
          - Language type: In Python SDK, PythonCallableWithSource.
            In any other SDKs, a wrapper object for a string which
            can be evaluated to a Python Callable object.
        """
        MICROS_INSTANT: LogicalTypes._Enum.ValueType  # 1
        """A URN for MicrosInstant type
          - Representation type: ROW<seconds: INT64, micros: INT64>
          - A timestamp without a timezone where seconds + micros represents the
            amount of time since the epoch.
        """
        MILLIS_INSTANT: LogicalTypes._Enum.ValueType  # 2
        """A URN for MillisInstant type
          - Representation type: INT64
          - A timestamp without a timezone represented by the number of
            milliseconds since the epoch. The INT64 value is encoded with
            big-endian shifted such that lexicographic ordering of the bytes
            corresponds to chronological order.
        """
        DECIMAL: LogicalTypes._Enum.ValueType  # 3
        """A URN for Decimal type
          - Representation type: BYTES
          - A decimal number with variable scale. Its BYTES
            representation consists of an integer (INT32) scale followed by a
            two's complement encoded big integer.
        """
        FIXED_BYTES: LogicalTypes._Enum.ValueType  # 4
        """A URN for FixedLengthBytes type
          - Representation type: BYTES
          - Argument type: INT32.
            A fixed-length bytes with its length as the argument.
        """
        VAR_BYTES: LogicalTypes._Enum.ValueType  # 5
        """A URN for VariableLengthBytes type
          - Representation type: BYTES
          - Argument type: INT32.
            A variable-length bytes with its maximum length as the argument.
        """
        FIXED_CHAR: LogicalTypes._Enum.ValueType  # 6
        """A URN for FixedLengthString type
          - Representation type: STRING
          - Argument type: INT32.
            A fixed-length string with its length as the argument.
        """
        VAR_CHAR: LogicalTypes._Enum.ValueType  # 7
        """A URN for VariableLengthString type
          - Representation type: STRING
          - Argument type: INT32.
            A variable-length string with its maximum length as the argument.
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    PYTHON_CALLABLE: LogicalTypes.Enum.ValueType  # 0
    """A URN for Python Callable logical type
      - Representation type: STRING
      - Language type: In Python SDK, PythonCallableWithSource.
        In any other SDKs, a wrapper object for a string which
        can be evaluated to a Python Callable object.
    """
    MICROS_INSTANT: LogicalTypes.Enum.ValueType  # 1
    """A URN for MicrosInstant type
      - Representation type: ROW<seconds: INT64, micros: INT64>
      - A timestamp without a timezone where seconds + micros represents the
        amount of time since the epoch.
    """
    MILLIS_INSTANT: LogicalTypes.Enum.ValueType  # 2
    """A URN for MillisInstant type
      - Representation type: INT64
      - A timestamp without a timezone represented by the number of
        milliseconds since the epoch. The INT64 value is encoded with
        big-endian shifted such that lexicographic ordering of the bytes
        corresponds to chronological order.
    """
    DECIMAL: LogicalTypes.Enum.ValueType  # 3
    """A URN for Decimal type
      - Representation type: BYTES
      - A decimal number with variable scale. Its BYTES
        representation consists of an integer (INT32) scale followed by a
        two's complement encoded big integer.
    """
    FIXED_BYTES: LogicalTypes.Enum.ValueType  # 4
    """A URN for FixedLengthBytes type
      - Representation type: BYTES
      - Argument type: INT32.
        A fixed-length bytes with its length as the argument.
    """
    VAR_BYTES: LogicalTypes.Enum.ValueType  # 5
    """A URN for VariableLengthBytes type
      - Representation type: BYTES
      - Argument type: INT32.
        A variable-length bytes with its maximum length as the argument.
    """
    FIXED_CHAR: LogicalTypes.Enum.ValueType  # 6
    """A URN for FixedLengthString type
      - Representation type: STRING
      - Argument type: INT32.
        A fixed-length string with its length as the argument.
    """
    VAR_CHAR: LogicalTypes.Enum.ValueType  # 7
    """A URN for VariableLengthString type
      - Representation type: STRING
      - Argument type: INT32.
        A variable-length string with its maximum length as the argument.
    """

    def __init__(
        self,
    ) -> None: ...

global___LogicalTypes = LogicalTypes

@typing_extensions.final
class Option(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """REQUIRED. Identifier for the option."""
    @property
    def type(self) -> global___FieldType:
        """REQUIRED. Type specifier for the structure of value.
        Conventionally, options that don't require additional configuration should
        use a boolean type, with the value set to true.
        """
    @property
    def value(self) -> global___FieldValue: ...
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        type: global___FieldType | None = ...,
        value: global___FieldValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["type", b"type", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type", b"type", "value", b"value"]) -> None: ...

global___Option = Option

@typing_extensions.final
class Row(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FieldValue]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[global___FieldValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values", b"values"]) -> None: ...

global___Row = Row

@typing_extensions.final
class FieldValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATOMIC_VALUE_FIELD_NUMBER: builtins.int
    ARRAY_VALUE_FIELD_NUMBER: builtins.int
    ITERABLE_VALUE_FIELD_NUMBER: builtins.int
    MAP_VALUE_FIELD_NUMBER: builtins.int
    ROW_VALUE_FIELD_NUMBER: builtins.int
    LOGICAL_TYPE_VALUE_FIELD_NUMBER: builtins.int
    @property
    def atomic_value(self) -> global___AtomicTypeValue: ...
    @property
    def array_value(self) -> global___ArrayTypeValue: ...
    @property
    def iterable_value(self) -> global___IterableTypeValue: ...
    @property
    def map_value(self) -> global___MapTypeValue: ...
    @property
    def row_value(self) -> global___Row: ...
    @property
    def logical_type_value(self) -> global___LogicalTypeValue: ...
    def __init__(
        self,
        *,
        atomic_value: global___AtomicTypeValue | None = ...,
        array_value: global___ArrayTypeValue | None = ...,
        iterable_value: global___IterableTypeValue | None = ...,
        map_value: global___MapTypeValue | None = ...,
        row_value: global___Row | None = ...,
        logical_type_value: global___LogicalTypeValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["array_value", b"array_value", "atomic_value", b"atomic_value", "field_value", b"field_value", "iterable_value", b"iterable_value", "logical_type_value", b"logical_type_value", "map_value", b"map_value", "row_value", b"row_value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["array_value", b"array_value", "atomic_value", b"atomic_value", "field_value", b"field_value", "iterable_value", b"iterable_value", "logical_type_value", b"logical_type_value", "map_value", b"map_value", "row_value", b"row_value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["field_value", b"field_value"]) -> typing_extensions.Literal["atomic_value", "array_value", "iterable_value", "map_value", "row_value", "logical_type_value"] | None: ...

global___FieldValue = FieldValue

@typing_extensions.final
class AtomicTypeValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BYTE_FIELD_NUMBER: builtins.int
    INT16_FIELD_NUMBER: builtins.int
    INT32_FIELD_NUMBER: builtins.int
    INT64_FIELD_NUMBER: builtins.int
    FLOAT_FIELD_NUMBER: builtins.int
    DOUBLE_FIELD_NUMBER: builtins.int
    STRING_FIELD_NUMBER: builtins.int
    BOOLEAN_FIELD_NUMBER: builtins.int
    BYTES_FIELD_NUMBER: builtins.int
    byte: builtins.int
    int16: builtins.int
    int32: builtins.int
    int64: builtins.int
    float: builtins.float
    double: builtins.float
    string: builtins.str
    boolean: builtins.bool
    bytes: builtins.bytes
    def __init__(
        self,
        *,
        byte: builtins.int | None = ...,
        int16: builtins.int | None = ...,
        int32: builtins.int | None = ...,
        int64: builtins.int | None = ...,
        float: builtins.float | None = ...,
        double: builtins.float | None = ...,
        string: builtins.str | None = ...,
        boolean: builtins.bool | None = ...,
        bytes: builtins.bytes | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["boolean", b"boolean", "byte", b"byte", "bytes", b"bytes", "double", b"double", "float", b"float", "int16", b"int16", "int32", b"int32", "int64", b"int64", "string", b"string", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["boolean", b"boolean", "byte", b"byte", "bytes", b"bytes", "double", b"double", "float", b"float", "int16", b"int16", "int32", b"int32", "int64", b"int64", "string", b"string", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["byte", "int16", "int32", "int64", "float", "double", "string", "boolean", "bytes"] | None: ...

global___AtomicTypeValue = AtomicTypeValue

@typing_extensions.final
class ArrayTypeValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    @property
    def element(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FieldValue]: ...
    def __init__(
        self,
        *,
        element: collections.abc.Iterable[global___FieldValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element", b"element"]) -> None: ...

global___ArrayTypeValue = ArrayTypeValue

@typing_extensions.final
class IterableTypeValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    @property
    def element(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FieldValue]: ...
    def __init__(
        self,
        *,
        element: collections.abc.Iterable[global___FieldValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element", b"element"]) -> None: ...

global___IterableTypeValue = IterableTypeValue

@typing_extensions.final
class MapTypeValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MapTypeEntry]: ...
    def __init__(
        self,
        *,
        entries: collections.abc.Iterable[global___MapTypeEntry] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entries", b"entries"]) -> None: ...

global___MapTypeValue = MapTypeValue

@typing_extensions.final
class MapTypeEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    @property
    def key(self) -> global___FieldValue: ...
    @property
    def value(self) -> global___FieldValue: ...
    def __init__(
        self,
        *,
        key: global___FieldValue | None = ...,
        value: global___FieldValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

global___MapTypeEntry = MapTypeEntry

@typing_extensions.final
class LogicalTypeValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    @property
    def value(self) -> global___FieldValue: ...
    def __init__(
        self,
        *,
        value: global___FieldValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

global___LogicalTypeValue = LogicalTypeValue
