/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordWithPKDataParser;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;

public class RecordWithPKDataParser<T>
implements IRecordWithPKDataParser<T> {
    private final IRecordDataParser<T> recordParser;

    public RecordWithPKDataParser(IRecordDataParser<T> recordParser, IAType[] pkTypes) {
        this.recordParser = recordParser;
    }

    @Override
    public boolean parse(IRawRecord<? extends T> record, DataOutput out) throws HyracksDataException {
        if (record.size() == 0) {
            try {
                out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                return true;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        return this.recordParser.parse(record, out);
    }

    @Override
    public void appendKeys(ArrayTupleBuilder tb, IRawRecord<? extends T> record) throws HyracksDataException {
    }
}

