/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row;

import com.google.common.collect.Lists;
import com.teradata.tpcds.generator.StoreGeneratorColumn;
import com.teradata.tpcds.row.TableRowWithNulls;
import com.teradata.tpcds.type.Address;
import com.teradata.tpcds.type.Decimal;
import java.util.List;

public class StoreRow
extends TableRowWithNulls {
    private final long storeSk;
    private final String storeId;
    private final long recStartDateId;
    private final long recEndDateId;
    private final long closedDateId;
    private final String storeName;
    private final int employees;
    private final int floorSpace;
    private final String hours;
    private final String storeManager;
    private final int marketId;
    private final Decimal dTaxPercentage;
    private final String geographyClass;
    private final String marketDesc;
    private final String marketManager;
    private final long divisionId;
    private final String divisionName;
    private final long companyId;
    private final String companyName;
    private final Address address;

    public StoreRow(long nullBitMap, long storeSk, String storeId, long recStartDateId, long recEndDateId, long closedDateId, String storeName, int employees, int floorSpace, String hours, String storeManager, int marketId, Decimal dTaxPercentage, String geographyClass, String marketDesc, String marketManager, long divisionId, String divisionName, long companyId, String companyName, Address address) {
        super(nullBitMap, StoreGeneratorColumn.W_STORE_SK);
        this.storeSk = storeSk;
        this.storeId = storeId;
        this.recStartDateId = recStartDateId;
        this.recEndDateId = recEndDateId;
        this.closedDateId = closedDateId;
        this.storeName = storeName;
        this.employees = employees;
        this.floorSpace = floorSpace;
        this.hours = hours;
        this.storeManager = storeManager;
        this.marketId = marketId;
        this.dTaxPercentage = dTaxPercentage;
        this.geographyClass = geographyClass;
        this.marketDesc = marketDesc;
        this.marketManager = marketManager;
        this.divisionId = divisionId;
        this.divisionName = divisionName;
        this.companyId = companyId;
        this.companyName = companyName;
        this.address = address;
    }

    public long getClosedDateId() {
        return this.closedDateId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public int getEmployees() {
        return this.employees;
    }

    public int getFloorSpace() {
        return this.floorSpace;
    }

    public String getHours() {
        return this.hours;
    }

    public String getStoreManager() {
        return this.storeManager;
    }

    public int getMarketId() {
        return this.marketId;
    }

    public Decimal getdTaxPercentage() {
        return this.dTaxPercentage;
    }

    public String getMarketDesc() {
        return this.marketDesc;
    }

    public String getMarketManager() {
        return this.marketManager;
    }

    public Address getAddress() {
        return this.address;
    }

    @Override
    public List<String> getValues() {
        return Lists.newArrayList((Object[])new String[]{this.getStringOrNullForKey(this.storeSk, StoreGeneratorColumn.W_STORE_SK), this.getStringOrNull(this.storeId, StoreGeneratorColumn.W_STORE_ID), this.getDateStringOrNullFromJulianDays(this.recStartDateId, StoreGeneratorColumn.W_STORE_REC_START_DATE_ID), this.getDateStringOrNullFromJulianDays(this.recEndDateId, StoreGeneratorColumn.W_STORE_REC_END_DATE_ID), this.getStringOrNullForKey(this.closedDateId, StoreGeneratorColumn.W_STORE_CLOSED_DATE_ID), this.getStringOrNull(this.storeName, StoreGeneratorColumn.W_STORE_NAME), this.getStringOrNull(this.employees, StoreGeneratorColumn.W_STORE_EMPLOYEES), this.getStringOrNull(this.floorSpace, StoreGeneratorColumn.W_STORE_FLOOR_SPACE), this.getStringOrNull(this.hours, StoreGeneratorColumn.W_STORE_HOURS), this.getStringOrNull(this.storeManager, StoreGeneratorColumn.W_STORE_MANAGER), this.getStringOrNull(this.marketId, StoreGeneratorColumn.W_STORE_MARKET_ID), this.getStringOrNull(this.geographyClass, StoreGeneratorColumn.W_STORE_GEOGRAPHY_CLASS), this.getStringOrNull(this.marketDesc, StoreGeneratorColumn.W_STORE_MARKET_DESC), this.getStringOrNull(this.marketManager, StoreGeneratorColumn.W_STORE_MARKET_MANAGER), this.getStringOrNullForKey(this.divisionId, StoreGeneratorColumn.W_STORE_DIVISION_ID), this.getStringOrNull(this.divisionName, StoreGeneratorColumn.W_STORE_DIVISION_NAME), this.getStringOrNullForKey(this.companyId, StoreGeneratorColumn.W_STORE_COMPANY_ID), this.getStringOrNull(this.companyName, StoreGeneratorColumn.W_STORE_COMPANY_NAME), this.getStringOrNull(this.address.getStreetNumber(), StoreGeneratorColumn.W_STORE_ADDRESS_STREET_NUM), this.getStringOrNull(this.address.getStreetName(), StoreGeneratorColumn.W_STORE_ADDRESS_STREET_NAME1), this.getStringOrNull(this.address.getStreetType(), StoreGeneratorColumn.W_STORE_ADDRESS_STREET_TYPE), this.getStringOrNull(this.address.getSuiteNumber(), StoreGeneratorColumn.W_STORE_ADDRESS_SUITE_NUM), this.getStringOrNull(this.address.getCity(), StoreGeneratorColumn.W_STORE_ADDRESS_CITY), this.getStringOrNull(this.address.getCounty(), StoreGeneratorColumn.W_STORE_ADDRESS_COUNTY), this.getStringOrNull(this.address.getState(), StoreGeneratorColumn.W_STORE_ADDRESS_STATE), this.getStringOrNull(String.format("%05d", this.address.getZip()), StoreGeneratorColumn.W_STORE_ADDRESS_ZIP), this.getStringOrNull(this.address.getCountry(), StoreGeneratorColumn.W_STORE_ADDRESS_COUNTRY), this.getStringOrNull(this.address.getGmtOffset(), StoreGeneratorColumn.W_STORE_ADDRESS_GMT_OFFSET), this.getStringOrNull(this.dTaxPercentage, StoreGeneratorColumn.W_STORE_TAX_PERCENTAGE)});
    }
}

