/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java.base;

import java.io.DataOutput;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.external.library.java.base.JObject;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class JInterval
extends JObject<List<Long>> {
    public JInterval(long intervalStart, long intervalEnd) {
        super((IAObject)new AMutableInterval(intervalStart, intervalEnd, 0));
    }

    public void setValue(long intervalStart, long intervalEnd, byte typetag) throws HyracksDataException {
        ((AMutableInterval)this.value).setValue(intervalStart, intervalEnd, typetag);
    }

    public long getIntervalStart() {
        return ((AMutableInterval)this.value).getIntervalStart();
    }

    public long getIntervalEnd() {
        return ((AMutableInterval)this.value).getIntervalEnd();
    }

    public short getIntervalType() {
        return ((AMutableInterval)this.value).getIntervalType();
    }

    @Override
    public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
        this.serializeTypeTag(writeTypeTag, dataOutput, ATypeTag.INTERVAL);
        AIntervalSerializerDeserializer.INSTANCE.serialize((AInterval)((AMutableInterval)this.value), dataOutput);
    }

    @Override
    public void reset() throws HyracksDataException {
        ((AMutableInterval)this.value).setValue(0L, 0L, (byte)0);
    }

    @Override
    public IAType getIAType() {
        return BuiltinType.AINTERVAL;
    }

    @Override
    public void setValueGeneric(List<Long> o) {
        try {
            this.setValue(o.get(0), o.get(1), o.get(2).byteValue());
        }
        catch (HyracksDataException e) {
            throw new ArithmeticException("Invalid interval");
        }
    }

    @Override
    public List<Long> getValueGeneric() {
        long type = this.getIntervalType();
        Long[] interval = ArrayUtils.toObject((long[])new long[]{this.getIntervalStart(), this.getIntervalEnd(), type});
        return Arrays.asList(interval);
    }
}

