/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.ambari.server.controller;

import org.apache.ambari.server.controller.spi.PageRequest;
import org.apache.ambari.server.controller.spi.Predicate;
import org.apache.ambari.server.controller.spi.SortRequest;
import org.apache.ambari.server.orm.entities.AlertNoticeEntity;

/**
 * The {@link AlertNoticeRequest} encapsulates the data necessary to make a
 * backend request for {@link AlertNoticeEntity}.
 */
public class AlertNoticeRequest {

  /**
   * An Ambari predicate, or {@code null} for none.
   */
  public Predicate Predicate;

  /**
   * Pagination information, or {@code null} for none.
   */
  public PageRequest Pagination;

  /**
   * Sort information, or {@code null} for none.
   */
  public SortRequest Sort;

}
