/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.ClassType;
import com.ibm.xylem.types.NamedType;
import java.io.IOException;
import java.util.LinkedList;

public class ReadFieldInstruction
extends UnaryPrimopInstruction {
    protected String m_fieldName;

    public ReadFieldInstruction() {
    }

    public ReadFieldInstruction(Instruction instruction, String string) {
        super(instruction);
        this.m_fieldName = string;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string2 + "." + this.m_fieldName, codeGenerationTracker);
        return string3;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        codeGenerationTracker.generateConventionally(this.m_operand, bCELCodeGenerationHelper, null, instructionListBuilder);
        NamedType namedType = (NamedType)codeGenerationTracker.resolveType(this.m_operand);
        Type type = codeGenerationTracker.resolveType(this);
        instructionListBuilder.appendGetField(bCELCodeGenerationHelper.getClassName() + "$" + namedType.getName(), this.m_fieldName, type);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new ReadFieldInstruction(this.m_operand.cloneWithoutTypeInformation(), this.m_fieldName);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new ReadFieldInstruction(instruction, this.m_fieldName);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type = type.resolveType(typeEnvironment);
        if (type == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand), this);
        }
        if (!(type instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand + " is not an object"), this);
        }
        ClassType classType = (ClassType)((NamedType)type).resolveName(typeEnvironment);
        ClassType.Field field = classType.resolveField(this.m_fieldName, typeEnvironment);
        if (field == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + classType.getName() + " does not contain field " + this.m_fieldName), this);
        }
        return this.setCachedType(field.getType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_operand.getType(typeEnvironment, bindingEnvironment);
        type = type.resolveType(typeEnvironment);
        ClassType classType = (ClassType)((NamedType)type).resolveName(typeEnvironment);
        ClassType.Field field = classType.resolveField(this.m_fieldName, typeEnvironment);
        return field.getType();
    }

    @Override
    public String innerToString() {
        return "get-field! " + this.m_fieldName;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_fieldName = readObjectFileHelper.readString();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_fieldName);
    }
}

