/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IdentityHashMap;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.LinkedList;

public final class ReductionHelper {
    protected IdentityHashMap m_convertedBindings;
    protected HashMap m_subexpressions;
    protected HashMap m_postConversionSubexpressions;
    public TypeEnvironment m_typeEnvironment;
    public Type m_type;
    static final Logger s_logger = Logger.getInstance(ReductionHelper.class);
    private static ThreadLocal tLocal = new ThreadLocal();

    public static Instruction oneTimeReduceAndTypeCheck(TypeEnvironment typeEnvironment, Instruction instruction, LinkedList linkedList) {
        Instruction instruction2 = new ReductionHelper(typeEnvironment).reduce(instruction, instruction.getBindingEnvironment());
        try {
            instruction2.typeCheck(typeEnvironment, instruction.getBindingEnvironment(), linkedList);
        }
        catch (TypeCheckException typeCheckException) {
            throw new XylemError("ERR_SYSTEM", "Should not happen--reduction should be type preserving");
        }
        return instruction2;
    }

    public ReductionHelper(TypeEnvironment typeEnvironment) {
        this.m_convertedBindings = new IdentityHashMap();
        this.m_subexpressions = new HashMap(64);
        this.m_postConversionSubexpressions = new HashMap(64);
        this.m_typeEnvironment = typeEnvironment;
    }

    public IBinding lookupConvertedBinding(IBinding iBinding) {
        if (iBinding == null) {
            throw new RuntimeException();
        }
        IBinding iBinding2 = (IBinding)this.m_convertedBindings.get(iBinding);
        if (iBinding2 != null) {
            return iBinding2;
        }
        return iBinding;
    }

    public void registerConvertedBinding(IBinding iBinding, IBinding iBinding2) {
        if (iBinding2 == null) {
            throw new RuntimeException();
        }
        this.m_convertedBindings.put(iBinding, iBinding2);
    }

    public Object upgradeBinding(IBinding iBinding) {
        Object object = this.generateReducedIdentifier(iBinding.getName());
        this.m_convertedBindings.put(iBinding, iBinding);
        iBinding.setName(object);
        return object;
    }

    public Object generateReducedIdentifier(Object object) {
        return ReductionHelper.generateIntermediateIdentifier2();
    }

    public static void resetIntermediateIdentifierCounter(int n) {
        Counter counter = new Counter();
        counter.set(n);
        tLocal.set(counter);
    }

    public static int getIntermediateIdentifierCount() {
        Counter counter = (Counter)tLocal.get();
        if (counter == null) {
            return 0;
        }
        return counter.get();
    }

    public static Integer generateIntermediateIdentifier2() {
        Counter counter = (Counter)tLocal.get();
        if (counter == null) {
            counter = new Counter();
            tLocal.set(counter);
        } else {
            counter.add();
        }
        return new Integer(counter.get());
    }

    public static Object newIdentifier(int n) {
        Counter counter = (Counter)tLocal.get();
        if (counter == null) {
            counter = new Counter();
            tLocal.set(counter);
        }
        if (counter.get() < n) {
            counter.set(n);
        }
        return new Integer(n);
    }

    public IBinding lookupSubexpression(Instruction instruction) {
        return (IBinding)this.m_subexpressions.get(instruction);
    }

    public void registerSubexpression(IBinding iBinding, Instruction instruction, Instruction instruction2) {
        this.m_subexpressions.put(instruction, iBinding);
        this.m_postConversionSubexpressions.put(instruction2, iBinding);
    }

    public Object clone() {
        return new ReductionHelper(this);
    }

    protected ReductionHelper(ReductionHelper reductionHelper) {
        this.m_convertedBindings = (IdentityHashMap)reductionHelper.m_convertedBindings.clone();
        this.m_subexpressions = (HashMap)reductionHelper.m_subexpressions.clone();
        this.m_postConversionSubexpressions = (HashMap)reductionHelper.m_postConversionSubexpressions.clone();
        this.m_typeEnvironment = reductionHelper.m_typeEnvironment;
        if (this.m_typeEnvironment == null) {
            throw new RuntimeException();
        }
    }

    public Instruction reduceToBasicInstruction(Instruction[] instructionArray, Instruction instruction, BindingEnvironment bindingEnvironment) {
        if (instruction instanceof LiteralInstruction) {
            return instruction;
        }
        IBinding iBinding = this.reduceToIdentifier(instructionArray, instruction, "", bindingEnvironment);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(iBinding.getName());
        identifierInstruction.m_hasBeenTypechecked = true;
        identifierInstruction.setCachedType(iBinding.getBindingType());
        return identifierInstruction;
    }

    public IBinding reduceToIdentifier(Instruction[] instructionArray, Instruction instruction, Object object, BindingEnvironment bindingEnvironment) {
        return this.reduceToIdentifier(instructionArray, instruction, object, bindingEnvironment, null);
    }

    public IBinding reduceToIdentifier(Instruction[] instructionArray, Instruction instruction, Object object, BindingEnvironment bindingEnvironment, LetInstruction letInstruction) {
        LetInstruction letInstruction2;
        if (instruction instanceof IdentifierInstruction) {
            return this.lookupConvertedBinding(((IdentifierInstruction)instruction).getBinding());
        }
        IBinding iBinding = this.lookupSubexpression(instruction);
        if (iBinding != null) {
            return iBinding;
        }
        instruction.generateReducedForm(this, instructionArray, bindingEnvironment);
        instruction.m_hasBeenTypechecked = false;
        Instruction instruction2 = instructionArray[0];
        if (instruction2 instanceof IdentifierInstruction) {
            return bindingEnvironment.getVariableBinding(((IdentifierInstruction)instruction2).getVariable());
        }
        iBinding = (IBinding)this.m_postConversionSubexpressions.get(instruction2);
        if (iBinding != null) {
            return iBinding;
        }
        Object object2 = this.generateReducedIdentifier(object);
        if (letInstruction != null) {
            letInstruction2 = letInstruction;
            letInstruction2.m_bindingEnvironment = null;
            letInstruction2.getBinding().setName(object2);
            letInstruction2.resetCachedValueType();
            bindingEnvironment.setVariableBinding(letInstruction2.getBinding());
            letInstruction2.setValue(instruction2);
            letInstruction2.setBody(null);
        } else {
            letInstruction2 = new LetInstruction(object2, instruction2, null);
            bindingEnvironment.setVariableBinding(letInstruction2.getBinding());
            letInstruction2.resetCachedValueType();
            letInstruction2.setCachedType(this.m_type);
            letInstruction2.m_hasBeenTypechecked = true;
        }
        if (instructionArray[2] != null) {
            ((LetInstruction)instructionArray[2]).setBody(letInstruction2);
        } else {
            instructionArray[1] = letInstruction2;
        }
        instructionArray[2] = letInstruction2;
        this.registerSubexpression(letInstruction2.getBinding(), instruction, instruction2);
        return letInstruction2.getBinding();
    }

    public Instruction reduce(Instruction instruction, BindingEnvironment bindingEnvironment) {
        Instruction[] instructionArray = new Instruction[3];
        this.m_type = instruction.getCachedType();
        instruction.generateReducedForm(this, instructionArray, bindingEnvironment);
        instruction.m_hasBeenTypechecked = false;
        if (instructionArray[2] != null) {
            ((LetInstruction)instructionArray[2]).setBody(instructionArray[0]);
        } else {
            instructionArray[1] = instructionArray[0];
        }
        return instructionArray[1];
    }

    private static class Counter {
        private int num = 1;

        private Counter() {
        }

        public int get() {
            return this.num;
        }

        public void add() {
            ++this.num;
        }

        public void set(int n) {
            this.num = n;
        }
    }
}

