/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xylem.Logger;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class SettingsReader {
    static final Logger s_logger = Logger.getInstance(SettingsReader.class);

    /*
     * WARNING - void declaration
     */
    public static void applySettings(Class clazz) {
        Object object;
        while (clazz.getDeclaringClass() != null) {
            clazz = clazz.getDeclaringClass();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = SettingsReader.getSettingsFile(clazz.getName() + ".settings");
        s_logger.debug("Configuration file " + uRL + " for " + clazz.getName());
        if (uRL == null) {
            s_logger.debug("no settings file for '" + clazz.getName() + "'");
        } else {
            try {
                void var5_8;
                object = uRL.openStream();
                Iterator iterator = new LineNumberReader(new InputStreamReader((InputStream)object));
                String string = ((LineNumberReader)((Object)iterator)).readLine();
                while (var5_8 != null) {
                    String string2 = var5_8.trim();
                    if (string2.length() != 0 && !string2.startsWith("#")) {
                        String string3;
                        String string4;
                        int n = string2.indexOf(61);
                        if (n < 0) {
                            string4 = string2;
                            string3 = "";
                        } else {
                            string4 = string2.substring(0, n);
                            string3 = string2.substring(n + 1);
                        }
                        hashMap.put(string4, string3);
                        s_logger.debug("read line " + string4 + "='" + string3 + "'");
                    }
                    String string5 = ((LineNumberReader)((Object)iterator)).readLine();
                }
            }
            catch (Throwable throwable) {
                String string = "Error reading settings file '" + uRL + "'";
                s_logger.error(string, throwable);
                throw new RuntimeException(string);
            }
        }
        object = System.getProperties();
        for (String string : ((Properties)object).keySet()) {
            String string6 = (String)((Properties)object).get(string);
            hashMap.put(string, string6);
            s_logger.debug("sysprop " + string + "='" + string6 + "'");
        }
        for (String string : hashMap.keySet()) {
            String string7 = (String)hashMap.get(string);
            if (string7.equals("")) {
                string7 = "true";
            }
            SettingsReader.setField(string, clazz, string7, true);
        }
    }

    private static void setField(String string, Class clazz, String string2, boolean bl) {
        String string3;
        if (string.indexOf(46) < 0) {
            try {
                String string4 = "m_" + string;
                Field field = clazz.getDeclaredField(string4);
                Class<?> clazz2 = field.getType();
                String string5 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
                Method method = clazz.getMethod(string5, clazz2);
                Object object = null;
                if (field.getType().isPrimitive()) {
                    if (field.getType() == Boolean.TYPE) {
                        object = new Boolean(string2);
                    } else if (field.getType() == Byte.TYPE) {
                        object = new Byte(string2);
                    } else if (field.getType() == Character.TYPE) {
                        object = new Character(string2.charAt(0));
                    } else if (field.getType() == Short.TYPE) {
                        object = new Short(string2);
                    } else if (field.getType() == Double.TYPE) {
                        object = new Double(string2);
                    } else if (field.getType() == Float.TYPE) {
                        object = new Float(string2);
                    } else if (field.getType() == Integer.TYPE) {
                        object = new Integer(string2);
                    } else if (field.getType() == Long.TYPE) {
                        object = new Long(string2);
                    }
                } else {
                    object = field.getType() == String.class ? string2 : field.getType().getConstructor(String.class).newInstance(string2);
                }
                method.invoke(null, object);
                s_logger.debug("successfully set '" + string + "'='" + object + "' using method " + method.getName());
                return;
            }
            catch (Throwable throwable) {
                string3 = "can't set field " + string + " reflectively";
                s_logger.debug(string3, throwable);
            }
        }
        try {
            Method method = clazz.getMethod("setProperty", String.class, String.class);
            method.invoke(null, string, string2);
            s_logger.debug("successfully set '" + string + "'='" + string2 + "' using method " + method.getName());
        }
        catch (Throwable throwable) {
            string3 = "can't set field " + string + " dynamically";
            s_logger.debug(string3, throwable);
            if (bl) {
                // empty if block
            }
        }
    }

    private static URL getSettingsFile(String string) {
        Object object;
        try {
            object = new File(new File(System.getProperty("user.home", ".")), string);
            s_logger.debug("Trying " + ((File)object).getAbsolutePath());
            if (((File)object).exists() && ((File)object).canRead()) {
                return ((File)object).toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = new File(string);
            s_logger.debug("Trying " + ((File)object).getAbsolutePath());
            if (((File)object).exists() && ((File)object).canRead()) {
                return ((File)object).toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = SettingsReader.class.getClassLoader();
        if (object == null) {
            return null;
        }
        return SettingsReader.class.getClassLoader().getResource(string);
    }
}

