/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.ref;

import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;

public final class XDMNodeValueCursor
extends XDMCursorProxyCursor {
    private XDMCursor _source;
    private String _value;
    private boolean _op;
    private boolean _more = true;
    private boolean _returnParent = true;
    private int _position = -1;
    private int _length = -1;

    public XDMNodeValueCursor(XDMCursor xDMCursor, int n, String string, boolean bl) {
        this(xDMCursor, n == 1, string, bl);
    }

    public XDMNodeValueCursor(XDMCursor xDMCursor, boolean bl, String string, boolean bl2) {
        super(xDMCursor);
        this._source = xDMCursor;
        this._returnParent = bl;
        this._value = string;
        this._op = bl2;
        if (this._returnParent) {
            this.m_currentCursor = xDMCursor.getAxisCursor(10);
        }
        if (xDMCursor.isEmpty()) {
            this._length = 0;
            this._more = false;
            return;
        }
        this.ensureMatching();
    }

    @Override
    public XDMCursor newContext(XDMCursor xDMCursor, Object object, boolean bl) {
        if (bl) {
            return new XDMNodeValueCursor(this._source.newContext(xDMCursor), this._returnParent, this._value, this._op);
        }
        this._source = this._source.newContext(xDMCursor);
        if (this._source.isEmpty()) {
            this._length = 0;
            this._position = -1;
            this._more = false;
            return this;
        }
        this._length = -1;
        this._more = true;
        this._position = -1;
        this.ensureMatching();
        return this;
    }

    @Override
    public XDMCursor cloneXDMCursor() {
        XDMNodeValueCursor xDMNodeValueCursor = new XDMNodeValueCursor(this._source.cloneXDMCursor(), this._returnParent, this._value, this._op);
        xDMNodeValueCursor._position = this._position;
        xDMNodeValueCursor._length = this._length;
        xDMNodeValueCursor._more = this._more;
        return xDMNodeValueCursor;
    }

    @Override
    public void resetIteration() {
        if (this._length == 0 || this._length == 1 || this._position == 0) {
            return;
        }
        this._position = -1;
        this._source.resetIteration();
        this.ensureMatching();
    }

    @Override
    public boolean nextNode() {
        if (this._more) {
            this._more = this._source.nextNode();
        }
        if (!this._more) {
            return false;
        }
        return this.ensureMatching();
    }

    private final boolean ensureMatching() {
        if (this._source.isEmpty()) {
            this._position = 0;
            this._length = 0;
            this._more = false;
            return false;
        }
        do {
            String string;
            if (this._value.equals(string = this._source.getStringValueX()) != this._op) continue;
            this.m_currentCursor = this._returnParent ? this.m_currentCursor.newContext(this._source) : this._source;
            ++this._position;
            return true;
        } while (this._more = this._source.nextNode());
        this._length = this._position + 1;
        return false;
    }

    @Override
    public int getCurrentPos() {
        return this._position + 1;
    }

    @Override
    public boolean setCurrentPos(int n) {
        if (this.m_currentCursor == null) {
            return n == 0;
        }
        if (n == this._position + 1) {
            return true;
        }
        if (n <= this._position) {
            this.resetIteration();
        }
        while (n > this._position + 1) {
            if (this.nextNode()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this._position < 0;
    }

    @Override
    public int getLength() {
        if (this._length < 0) {
            this._length = this._position + 1;
            XDMCursor xDMCursor = this._source.cloneXDMCursor();
            boolean bl = xDMCursor.nextNode();
            while (bl) {
                String string = xDMCursor.getStringValueX();
                if (this._value.equals(string) == this._op) {
                    ++this._length;
                }
                bl = xDMCursor.nextNode();
            }
        }
        return this._length;
    }

    public boolean returnsParent() {
        return this._returnParent;
    }
}

