/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.util.ChecksumUtil;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;

class BlockSender
implements Closeable,
FSConstants {
    public static final Log LOG = DataNode.LOG;
    static final Log ClientTraceLog = DataNode.ClientTraceLog;
    private Block block;
    private InputStream blockIn;
    private long blockInPosition = -1L;
    private DataInputStream checksumIn;
    private DataChecksum checksum;
    private long initialOffset;
    private long offset;
    private long endOffset;
    private long blockLength;
    private int bytesPerChecksum;
    private int checksumSize;
    private boolean corruptChecksumOk;
    private boolean chunkOffsetOK;
    private long seqno;
    private boolean transferToAllowed = true;
    private boolean blockReadFully;
    private boolean verifyChecksum;
    private DataTransferThrottler throttler;
    private final String clientTraceFmt;
    private final MemoizedBlock memoizedBlock;
    private static final int MIN_BUFFER_WITH_TRANSFERTO = 65536;
    private FileDescriptor blockInFd;
    private final long readaheadLength;
    private boolean shouldDropCacheBehindRead;
    private ReadaheadPool readaheadPool;
    private ReadaheadPool.ReadaheadRequest curReadahead;
    private long lastCacheDropOffset;
    private static final long CACHE_DROP_INTERVAL_BYTES = 0x100000L;
    private static final long LONG_READ_THRESHOLD_BYTES = 262144L;

    BlockSender(Block block, long startOffset, long length, boolean corruptChecksumOk, boolean chunkOffsetOK, boolean verifyChecksum, DataNode datanode) throws IOException {
        this(block, startOffset, length, corruptChecksumOk, chunkOffsetOK, verifyChecksum, datanode, null);
    }

    BlockSender(Block block, long startOffset, long length, boolean corruptChecksumOk, boolean chunkOffsetOK, boolean verifyChecksum, DataNode datanode, String clientTraceFmt) throws IOException {
        try {
            long checksumSkip;
            this.block = block;
            this.chunkOffsetOK = chunkOffsetOK;
            this.corruptChecksumOk = corruptChecksumOk;
            this.verifyChecksum = verifyChecksum;
            this.blockLength = datanode.data.getVisibleLength(block);
            this.transferToAllowed = datanode.transferToAllowed;
            this.clientTraceFmt = clientTraceFmt;
            this.readaheadLength = datanode.getReadaheadLength();
            this.readaheadPool = datanode.readaheadPool;
            this.shouldDropCacheBehindRead = datanode.shouldDropCacheBehindReads();
            if (!corruptChecksumOk || datanode.data.metaFileExists(block)) {
                this.checksumIn = new DataInputStream(new BufferedInputStream(datanode.data.getMetaDataInputStream(block), BUFFER_SIZE));
                BlockMetadataHeader header = BlockMetadataHeader.readHeader(this.checksumIn);
                short version = header.getVersion();
                if (version != 1) {
                    LOG.warn("Wrong version (" + version + ") for metadata file for " + block + " ignoring ...");
                }
                this.checksum = header.getChecksum();
            } else {
                LOG.warn("Could not find metadata file for " + block);
                this.checksum = DataChecksum.newDataChecksum(0, 16384);
            }
            this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            if (this.bytesPerChecksum > 0xA00000 && (long)this.bytesPerChecksum > this.blockLength) {
                this.checksum = DataChecksum.newDataChecksum(this.checksum.getChecksumType(), Math.max((int)this.blockLength, 0xA00000));
                this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            }
            this.checksumSize = this.checksum.getChecksumSize();
            if (length < 0L) {
                length = this.blockLength;
            }
            this.endOffset = this.blockLength;
            if (startOffset < 0L || startOffset > this.endOffset || length + startOffset > this.endOffset) {
                String msg = " Offset " + startOffset + " and length " + length + " don't match " + block + " ( blockLen " + this.endOffset + " )";
                LOG.warn(datanode.dnRegistration + ":sendBlock() : " + msg);
                throw new IOException(msg);
            }
            this.offset = startOffset - startOffset % (long)this.bytesPerChecksum;
            if (length >= 0L) {
                long tmpLen = startOffset + length;
                if (tmpLen % (long)this.bytesPerChecksum != 0L) {
                    tmpLen += (long)this.bytesPerChecksum - tmpLen % (long)this.bytesPerChecksum;
                }
                if (tmpLen < this.endOffset) {
                    this.endOffset = tmpLen;
                }
            }
            if (this.offset > 0L && (checksumSkip = this.offset / (long)this.bytesPerChecksum * (long)this.checksumSize) > 0L) {
                IOUtils.skipFully(this.checksumIn, checksumSkip);
            }
            this.seqno = 0L;
            this.blockIn = datanode.data.getBlockInputStream(block, this.offset);
            this.blockInFd = this.blockIn instanceof FileInputStream ? ((FileInputStream)this.blockIn).getFD() : null;
            this.memoizedBlock = new MemoizedBlock(this.blockIn, this.blockLength, datanode.data, block);
        }
        catch (IOException ioe) {
            IOUtils.closeStream(this);
            IOUtils.closeStream(this.blockIn);
            throw ioe;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.blockInFd != null && this.shouldDropCacheBehindRead && this.isLongRead()) {
            try {
                NativeIO.posixFadviseIfPossible(this.blockInFd, this.lastCacheDropOffset, this.offset - this.lastCacheDropOffset, 4);
            }
            catch (Exception e) {
                LOG.warn("Unable to drop cache on file close", e);
            }
        }
        if (this.curReadahead != null) {
            this.curReadahead.cancel();
        }
        IOException ioe = null;
        if (this.checksumIn != null) {
            try {
                this.checksumIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.checksumIn = null;
        }
        if (this.blockIn != null) {
            try {
                this.blockIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.blockIn = null;
            this.blockInFd = null;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static IOException ioeToSocketException(IOException ioe) {
        if (ioe.getClass().equals(IOException.class)) {
            SocketException se = new SocketException("Original Exception : " + ioe);
            se.initCause(ioe);
            se.setStackTrace(ioe.getStackTrace());
            return se;
        }
        return ioe;
    }

    private int sendChunks(ByteBuffer pkt, int maxChunks, OutputStream out) throws IOException {
        int len = (int)Math.min(this.endOffset - this.offset, (long)this.bytesPerChecksum * (long)maxChunks);
        if (len > this.bytesPerChecksum && len % this.bytesPerChecksum != 0) {
            len -= len % this.bytesPerChecksum;
        }
        if (len == 0) {
            return 0;
        }
        int numChunks = (len + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
        int packetLen = len + numChunks * this.checksumSize + 4;
        pkt.clear();
        pkt.putInt(packetLen);
        pkt.putLong(this.offset);
        pkt.putLong(this.seqno);
        pkt.put((byte)(this.offset + (long)len >= this.endOffset ? 1 : 0));
        pkt.putInt(len);
        int checksumOff = pkt.position();
        int checksumLen = numChunks * this.checksumSize;
        byte[] buf = pkt.array();
        if (this.checksumSize > 0 && this.checksumIn != null) {
            try {
                this.checksumIn.readFully(buf, checksumOff, checksumLen);
            }
            catch (IOException e) {
                LOG.warn(" Could not read or failed to veirfy checksum for data at offset " + this.offset + " for block " + this.block + " got : " + StringUtils.stringifyException(e));
                IOUtils.closeStream(this.checksumIn);
                this.checksumIn = null;
                if (this.corruptChecksumOk) {
                    if (checksumOff < checksumLen) {
                        Arrays.fill(buf, checksumOff, checksumLen, (byte)0);
                    }
                }
                throw e;
            }
        }
        int dataOff = checksumOff + checksumLen;
        if (this.blockInPosition < 0L) {
            IOUtils.readFully(this.blockIn, buf, dataOff, len);
            if (this.verifyChecksum) {
                int dOff = dataOff;
                int cOff = checksumOff;
                int dLeft = len;
                for (int i = 0; i < numChunks; ++i) {
                    this.checksum.reset();
                    int dLen = Math.min(dLeft, this.bytesPerChecksum);
                    this.checksum.update(buf, dOff, dLen);
                    if (!this.checksum.compare(buf, cOff)) {
                        throw new ChecksumException("Checksum failed at " + (this.offset + (long)len - (long)dLeft), len);
                    }
                    dLeft -= dLen;
                    dOff += dLen;
                    cOff += this.checksumSize;
                }
            }
            if (this.memoizedBlock.hasBlockChanged(len)) {
                ChecksumUtil.updateChunkChecksum(buf, checksumOff, dataOff, len, this.checksum);
            }
            try {
                out.write(buf, 0, dataOff + len);
            }
            catch (IOException e) {
                throw BlockSender.ioeToSocketException(e);
            }
        }
        try {
            SocketOutputStream sockOut = (SocketOutputStream)out;
            FileChannel fileChannel = ((FileInputStream)this.blockIn).getChannel();
            if (this.memoizedBlock.hasBlockChanged(len)) {
                fileChannel.position(this.blockInPosition);
                IOUtils.readFileChannelFully(fileChannel, buf, dataOff, len);
                ChecksumUtil.updateChunkChecksum(buf, checksumOff, dataOff, len, this.checksum);
                sockOut.write(buf, 0, dataOff + len);
            } else {
                sockOut.write(buf, 0, dataOff);
                sockOut.transferToFully(fileChannel, this.blockInPosition, len);
            }
            this.blockInPosition += (long)len;
        }
        catch (IOException e) {
            throw BlockSender.ioeToSocketException(e);
        }
        if (this.throttler != null) {
            this.throttler.throttle(packetLen);
        }
        return len;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long sendBlock(DataOutputStream out, OutputStream baseStream, DataTransferThrottler throttler) throws IOException {
        long totalRead;
        block15: {
            if (out == null) {
                throw new IOException("out stream is null");
            }
            this.throttler = throttler;
            this.initialOffset = this.offset;
            totalRead = 0L;
            DataOutputStream dataOutputStream = out;
            this.lastCacheDropOffset = this.initialOffset;
            if (this.isLongRead() && this.blockInFd != null) {
                NativeIO.posixFadviseIfPossible(this.blockInFd, 0L, 0L, 2);
            }
            this.manageOsCache();
            long startTime = ClientTraceLog.isInfoEnabled() ? System.nanoTime() : 0L;
            try {
                int maxChunksPerPacket;
                try {
                    this.checksum.writeHeader(out);
                    if (this.chunkOffsetOK) {
                        out.writeLong(this.offset);
                    }
                    out.flush();
                }
                catch (IOException e) {
                    throw BlockSender.ioeToSocketException(e);
                }
                int pktSize = 25;
                if (this.transferToAllowed && !this.verifyChecksum && baseStream instanceof SocketOutputStream && this.blockIn instanceof FileInputStream) {
                    FileChannel fileChannel = ((FileInputStream)this.blockIn).getChannel();
                    this.blockInPosition = fileChannel.position();
                    OutputStream outputStream = baseStream;
                    maxChunksPerPacket = (Math.max(BUFFER_SIZE, 65536) + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
                    pktSize += (this.bytesPerChecksum + this.checksumSize) * maxChunksPerPacket;
                } else {
                    maxChunksPerPacket = Math.max(1, (BUFFER_SIZE + this.bytesPerChecksum - 1) / this.bytesPerChecksum);
                    pktSize += (this.bytesPerChecksum + this.checksumSize) * maxChunksPerPacket;
                }
                ByteBuffer pktBuf = ByteBuffer.allocate(pktSize);
                while (this.endOffset > this.offset) {
                    void var6_7;
                    this.manageOsCache();
                    long len = this.sendChunks(pktBuf, maxChunksPerPacket, (OutputStream)var6_7);
                    this.offset += len;
                    totalRead += len + (len + (long)this.bytesPerChecksum - 1L) / (long)this.bytesPerChecksum * (long)this.checksumSize;
                    ++this.seqno;
                }
                try {
                    out.writeInt(0);
                    out.flush();
                }
                catch (IOException e) {
                    throw BlockSender.ioeToSocketException(e);
                }
                if (this.clientTraceFmt == null) break block15;
            }
            catch (RuntimeException e) {
                try {
                    LOG.error("unexpected exception sending block", e);
                    throw new IOException("unexpected runtime exception", e);
                }
                catch (Throwable throwable) {
                    if (this.clientTraceFmt != null) {
                        long endTime = System.nanoTime();
                        ClientTraceLog.info(String.format(this.clientTraceFmt, totalRead, this.initialOffset, endTime - startTime));
                    }
                    this.close();
                    throw throwable;
                }
            }
            long endTime = System.nanoTime();
            ClientTraceLog.info(String.format(this.clientTraceFmt, totalRead, this.initialOffset, endTime - startTime));
        }
        this.close();
        this.blockReadFully = this.initialOffset == 0L && this.offset >= this.blockLength;
        return totalRead;
    }

    private void manageOsCache() throws IOException {
        if (!this.isLongRead() || this.blockInFd == null) {
            return;
        }
        if (this.readaheadLength > 0L && this.readaheadPool != null) {
            this.curReadahead = this.readaheadPool.readaheadStream(this.clientTraceFmt, this.blockInFd, this.offset, this.readaheadLength, Long.MAX_VALUE, this.curReadahead);
        }
        long nextCacheDropOffset = this.lastCacheDropOffset + 0x100000L;
        if (this.shouldDropCacheBehindRead && this.offset >= nextCacheDropOffset) {
            long dropLength = this.offset - this.lastCacheDropOffset;
            if (dropLength >= 1024L) {
                NativeIO.posixFadviseIfPossible(this.blockInFd, this.lastCacheDropOffset, dropLength, 4);
            }
            this.lastCacheDropOffset += 0x100000L;
        }
    }

    private boolean isLongRead() {
        return this.endOffset - this.offset > 262144L;
    }

    boolean isBlockReadFully() {
        return this.blockReadFully;
    }

    private class MemoizedBlock {
        private InputStream inputStream;
        private long blockLength;
        private final FSDatasetInterface fsDataset;
        private final Block block;

        private MemoizedBlock(InputStream inputStream, long blockLength, FSDatasetInterface fsDataset, Block block) {
            this.inputStream = inputStream;
            this.blockLength = blockLength;
            this.fsDataset = fsDataset;
            this.block = block;
        }

        boolean hasBlockChanged(long dataLen) throws IOException {
            if (BlockSender.this.blockInPosition >= 0L) {
                long currentLength = ((FileInputStream)this.inputStream).getChannel().size();
                return (BlockSender.this.blockInPosition % (long)BlockSender.this.bytesPerChecksum != 0L || dataLen % (long)BlockSender.this.bytesPerChecksum != 0L) && currentLength > this.blockLength;
            }
            long currentLength = this.fsDataset.getLength(this.block);
            return (BlockSender.this.offset % (long)BlockSender.this.bytesPerChecksum != 0L || dataLen % (long)BlockSender.this.bytesPerChecksum != 0L) && currentLength > this.blockLength;
        }
    }
}

