/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xylem.Binding;
import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGeneration;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.types.CompoundType;
import com.ibm.xylem.types.NamedType;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;

public abstract class AbstractDataType
extends CompoundType {
    public Constructor[] m_constructors;

    public AbstractDataType() {
    }

    protected AbstractDataType(String string, Constructor[] constructorArray) {
        super(string);
        if (constructorArray != null) {
            this.setConstructors(constructorArray);
        }
    }

    public String getImplementationName(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        if (dataFlowCodeGenerationHelper.isTargetCPP()) {
            return dataFlowCodeGenerationHelper.getSafeName(this.getName());
        }
        return dataFlowCodeGenerationHelper.getClassName() + "." + dataFlowCodeGenerationHelper.getSafeName(this.getName());
    }

    public String getImplementationName(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        return bCELCodeGenerationHelper.getClassName() + "$" + bCELCodeGenerationHelper.getSafeName(this.getName());
    }

    public com.ibm.xtq.bcel.generic.Type getImplementationType(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        return new ObjectType(this.getImplementationName(bCELCodeGenerationHelper));
    }

    public String toString() {
        return this.getName();
    }

    public String debugToString() {
        String string = "(" + this.getName();
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor constructor = this.m_constructors[i];
            string = string + " (" + constructor.m_name + ")";
        }
        return string + ")";
    }

    public int getChildTypeCount() {
        int n = 0;
        for (int i = 0; i < this.m_constructors.length; ++i) {
            n += this.m_constructors[i].m_parameters.length;
        }
        return n;
    }

    public Type getChildType(int n) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor constructor = this.m_constructors[i];
            for (int j = 0; j < constructor.m_parameters.length; ++j) {
                if (n == 0) {
                    return constructor.m_parameters[j].getBindingType();
                }
                --n;
            }
        }
        return null;
    }

    public void setChildType(int n, Type type) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor constructor = this.m_constructors[i];
            for (int j = 0; j < constructor.m_parameters.length; ++j) {
                if (n == 0) {
                    constructor.m_parameters[j].setType(type);
                    return;
                }
                --n;
            }
        }
    }

    public void setConstructors(Constructor[] constructorArray) {
        if (this.m_constructors != null && this.m_constructors.length != 0) {
            throw new Error("Tried to overwrite existing (" + this.m_constructors.length + ") constructors in " + this.getName() + " (don't do that!)");
        }
        this.m_constructors = constructorArray;
        for (int i = 0; i < this.m_constructors.length; ++i) {
            this.m_constructors[i].m_adt = this;
        }
    }

    public Constructor getConstructor(String string) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            if (!this.m_constructors[i].getName().equals(string)) continue;
            return this.m_constructors[i];
        }
        return null;
    }

    public int getConstructorCount() {
        return this.m_constructors == null ? 0 : this.m_constructors.length;
    }

    public Constructor getConstructor(int n) {
        return this.m_constructors[n];
    }

    public abstract String generateConstructorTypeDeconstructionCode(DataFlowCodeGenerationHelper var1, String var2);

    public abstract void generateConstructorTypeDeconstructionCode(BCELCodeGenerationHelper var1, InstructionListBuilder var2);

    public abstract void generateConstructorDeconstructionCode(DataFlowCodeGenerationHelper var1, String var2, CodeGenerationTracker var3, String[] var4, Constructor var5);

    public abstract CodeGenerationTracker generateConstructorDeconstructionCode(DataFlowCodeGenerationHelper var1, String var2, CodeGenerationTracker var3, Binding[] var4, Constructor var5, Instruction var6, Binding var7);

    public abstract CodeGenerationTracker generateConstructorDeconstructionCode(BCELCodeGenerationHelper var1, int var2, CodeGenerationTracker var3, Binding[] var4, Constructor var5, Instruction var6, Binding var7, InstructionListBuilder var8);

    public abstract CodeGenerationTracker generateConstructorDeconstructionCodeForSome(DataFlowCodeGenerationHelper var1, String var2, CodeGenerationTracker var3, Binding[] var4, Constructor var5, Instruction var6, Binding var7, boolean[] var8);

    public abstract CodeGenerationTracker generateConstructorDeconstructionCodeForSome(BCELCodeGenerationHelper var1, int var2, CodeGenerationTracker var3, Binding[] var4, Constructor var5, Instruction var6, Binding var7, InstructionListBuilder var8, boolean[] var9);

    public abstract String generateConstructorConstructionCode(DataFlowCodeGenerationHelper var1, CodeGenerationTracker var2, Constructor var3, Instruction[] var4, NamedType var5);

    public abstract void generateConstructorConstructionCode(BCELCodeGenerationHelper var1, CodeGenerationTracker var2, Constructor var3, Instruction[] var4, NamedType var5, InstructionListBuilder var6);

    public abstract void generateCode(DataFlowCodeGenerationHelper var1);

    public abstract void generateCode(BCELCodeGenerationHelper var1);

    public abstract void generateDeclarationCode(DataFlowCodeGenerationHelper var1) throws IOException;

    public abstract void toString(PrettyPrinter var1, int var2);

    public void addComment(String string) {
    }

    @Override
    public boolean refersToType(Type type, ITypeStore iTypeStore, HashSet hashSet) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor constructor = this.m_constructors[i];
            for (int j = 0; j < constructor.m_parameters.length; ++j) {
                if (!constructor.m_parameters[j].getBindingType().refersToType(type, iTypeStore, hashSet)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Constructor
    implements Serializable {
        private static final long serialVersionUID = -18502971452733861L;
        protected String m_name;
        public Binding[] m_parameters;
        protected AbstractDataType m_adt;
        public String[] m_defaultValues;

        public Constructor(String string, Binding[] bindingArray) {
            this.m_name = string;
            this.m_parameters = bindingArray;
        }

        public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
            writeObjectFileHelper.writeString(this.m_name);
            writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_parameters);
            writeObjectFileHelper.writeObject(this.m_adt);
            writeObjectFileHelper.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
            if (this.m_defaultValues != null) {
                for (int i = 0; i < this.m_defaultValues.length; ++i) {
                    writeObjectFileHelper.writeBoolean(this.m_defaultValues[i] != null);
                    if (this.m_defaultValues[i] == null) continue;
                    writeObjectFileHelper.writeString(this.m_defaultValues[i]);
                }
            }
        }

        public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
            this.m_name = readObjectFileHelper.readString();
            this.m_parameters = readObjectFileHelper.readTypeSpecificBindingSet();
            this.m_adt = (AbstractDataType)readObjectFileHelper.readObject();
            int n = readObjectFileHelper.readInt();
            if (n > 0) {
                this.m_defaultValues = new String[n];
                for (int i = 0; i < this.m_defaultValues.length; ++i) {
                    if (!readObjectFileHelper.readBoolean()) continue;
                    this.m_defaultValues[i] = readObjectFileHelper.readString();
                }
            }
        }

        public String getName() {
            return this.m_name;
        }

        public Object[] getParameterNames() {
            Object[] objectArray = new Object[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                objectArray[i] = this.m_parameters[i].getName();
            }
            return objectArray;
        }

        public Type[] getParameterTypes() {
            Type[] typeArray = new Type[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                typeArray[i] = this.m_parameters[i].getBindingType();
            }
            return typeArray;
        }

        public AbstractDataType getAbstractDataType() {
            return this.m_adt;
        }

        public int getIndex() {
            for (int i = 0; i < this.m_adt.m_constructors.length; ++i) {
                if (this.m_adt.m_constructors[i] != this) continue;
                return i;
            }
            return -1;
        }

        public int findBinding(Binding binding) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (this.m_parameters[i] != binding) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            stringBuffer.append(this.m_name);
            stringBuffer.append("@");
            stringBuffer.append(this.m_adt);
            stringBuffer.append(" ");
            for (int i = 0; i < this.m_parameters.length; ++i) {
                stringBuffer.append(this.m_parameters[i]);
                if (i >= this.m_parameters.length - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public void toString(PrettyPrinter prettyPrinter, int n) {
            prettyPrinter.printFormOpen(this.m_name, n);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                prettyPrinter.printIdentifier(this.m_parameters[i].getName(), n + 1);
                prettyPrinter.print("@");
                prettyPrinter.print(this.m_parameters[i].getBindingType().prettyPrint());
            }
            prettyPrinter.printFormClose(n);
        }

        public String prettyPrint() {
            StringBuffer stringBuffer = new StringBuffer();
            Type[] typeArray = this.getParameterTypes();
            stringBuffer.append(this.m_adt.getModuleName());
            stringBuffer.append('.');
            stringBuffer.append(this.m_name);
            stringBuffer.append("(");
            for (int i = 0; i < typeArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(typeArray[i].prettyPrint());
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public String getConstructorQualifiedFieldName(int n, CodeGeneration codeGeneration) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("m_");
            stringBuffer.append(codeGeneration.getSafeName(this.getName()));
            stringBuffer.append("_");
            stringBuffer.append(Binding.generateVariableName(this.m_parameters[n], codeGeneration));
            return stringBuffer.toString();
        }
    }
}

