/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.codegen.bcel.SwitchBuilder;
import com.ibm.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.DecimalType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TagType;
import com.ibm.xylem.utils.XylemError;
import java.util.LinkedList;

public class PrimitiveEqualityInstruction
extends BinaryPrimopInstruction {
    public PrimitiveEqualityInstruction(Instruction instruction, Instruction instruction2) {
        super(instruction, instruction2);
    }

    public PrimitiveEqualityInstruction() {
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new PrimitiveEqualityInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        Type type = codeGenerationTracker.resolveType(this.m_operand1);
        codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
        codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
        PrimitiveEqualityInstruction.generatePrimitiveEquality(bCELCodeGenerationHelper, codeGenerationTracker, type, instructionListBuilder);
    }

    public static void generatePrimitiveEquality(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, Type type, InstructionListBuilder instructionListBuilder) {
        Object object;
        while (type instanceof TagType) {
            type = ((TagType)type).getElementType();
        }
        if (type instanceof INumericalType) {
            object = (INumericalType)((Object)type);
            object.generateCodeForOperation(instructionListBuilder, 9);
        } else if (type instanceof JavaObjectType || type instanceof StreamType) {
            object = new SwitchBuilder(instructionListBuilder, 1);
            ((SwitchBuilder)object).startTestAEquals();
            instructionListBuilder.appendConstant(true);
            ((SwitchBuilder)object).endTest();
            ((SwitchBuilder)object).startElse();
            instructionListBuilder.appendConstant(false);
            ((SwitchBuilder)object).endElse();
        } else if (type instanceof BooleanType) {
            IntType.s_intType.generateCodeForOperation(instructionListBuilder, 9);
        } else {
            throw new UnsupportedOperationException("Cannot perform primitive equality on " + type);
        }
        object = new SwitchBuilder(instructionListBuilder, 1);
        ((SwitchBuilder)object).startTestTrue();
        instructionListBuilder.appendConstant(1);
        ((SwitchBuilder)object).endTest();
        ((SwitchBuilder)object).startElse();
        instructionListBuilder.appendConstant(0);
        ((SwitchBuilder)object).endElse();
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = codeGenerationTracker.resolveType(this.m_operand1);
        Type type2 = codeGenerationTracker.resolveType(this.m_operand2);
        try {
            if (type == null) {
                throw new XylemError("ERR_SYSTEM", "" + this);
            }
            if (type2 == null) {
                throw new XylemError("ERR_SYSTEM", "" + this);
            }
            if (type.equals(DecimalType.s_decimalType) && type2.equals(DecimalType.s_decimalType)) {
                String string3 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
                String string4 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
                dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string3 + ".compareTo(" + string4 + ") == 0", codeGenerationTracker);
            } else {
                String string5 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
                String string6 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
                dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string5 + " == " + string6, codeGenerationTracker);
            }
        }
        catch (NullPointerException nullPointerException) {
            s_logger.error("npe in " + this, nullPointerException);
            throw new RuntimeException();
        }
        return string2;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("eq?", n);
        this.m_operand1.toString(prettyPrinter, n + 1);
        this.m_operand2.toString(prettyPrinter, n + 1);
        prettyPrinter.printFormClose(n);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Type type = this.m_operand1.evaluateType(function);
        Type type2 = this.m_operand2.evaluateType(function);
        Object object = this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
        Object object2 = this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        Object object3 = type instanceof INumericalType && type2 instanceof INumericalType ? ((INumericalType)((Object)type)).evaluateOperation(object, object2, 9) : (object == null || object2 == null ? (object == object2 ? Boolean.TRUE : Boolean.FALSE) : (object.equals(object2) ? Boolean.TRUE : Boolean.FALSE));
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object3);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction, Instruction instruction2) {
        return new PrimitiveEqualityInstruction(instruction, instruction2);
    }
}

