/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xylem.Program;
import com.ibm.xylem.Type;
import com.ibm.xylem.codegen.CodeGenerationHelper;
import com.ibm.xylem.codegen.CodeGenerationSettings;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xylem.codegen.MemoryEfficientBuffer;
import com.ibm.xylem.codegen.MemoryManagementHelper;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.LazyStreamType;
import com.ibm.xylem.types.PromiseType;
import com.ibm.xylem.types.SlotType;
import com.ibm.xylem.utils.XylemError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DataFlowCodeGenerationHelper
extends CodeGenerationHelper {
    private MemoryEfficientBuffer m_currentBuffer;
    private MemoryEfficientBuffer m_primaryBuffer;
    private MemoryEfficientBuffer m_constantBuffer = MemoryEfficientBuffer.obtainCountableBuffer();
    private MemoryEfficientBuffer m_staticBuffer = MemoryEfficientBuffer.obtainCountableBuffer();
    private MemoryEfficientBuffer m_postClassBuffer = MemoryEfficientBuffer.obtainBuffer();
    private MemoryEfficientBuffer m_preClassBuffer = MemoryEfficientBuffer.obtainBuffer();
    private MemoryEfficientBuffer m_endOfClassBuffer = MemoryEfficientBuffer.obtainBuffer();
    private MemoryEfficientBuffer m_functionBuffer = MemoryEfficientBuffer.obtainBuffer();
    private int m_constantClassIndex = 0;
    private int m_constantCount = 0;
    private int m_staticMethodIndex = 0;
    private int m_staticCount = 0;
    private int m_staticBufferLength = 0;
    private int m_identifiers = 0;
    private int m_memberIdentifiers = 0;
    private int m_functionCount = 0;
    private HashMap m_constants = new HashMap();
    public File m_basePath = null;
    public String m_packageName = null;
    protected FunctionGenerationStyle m_currentFGS;
    public String m_constantsClassPrefix = "";
    private char[] m_scratchCharBuffer = new char[131072];
    private byte[] m_scratchByteBuffer = new byte[131072];
    public MemoryManagementHelper m_mmh = new MemoryManagementHelper();
    public static final int s_java = 0;
    public static final int s_cpp = 1;
    public String m_finalKeyword = "final";
    public String m_dot = ".";
    public String m_arraySuffix = "[]";
    public String m_null = "null";
    static final int s_indexMax = 16384;
    public int m_targetLanguage = 0;
    private Set m_imports = new HashSet();
    private HashMap m_threadLocalVariables = new HashMap();
    static final int s_maxPoolSize = 4096;
    protected HashMap m_typedConstantPools = new HashMap();
    private MemoryEfficientBuffer m_recycleBuffer = MemoryEfficientBuffer.obtainBuffer();

    private void setupCPP() {
        this.m_finalKeyword = "";
        this.m_dot = "->";
        this.m_arraySuffix = "*";
        this.m_null = "NULL";
        this.m_targetLanguage = 1;
        this.getSettings().m_makeAllMethodsStatic = false;
    }

    public boolean isTargetJava() {
        return this.m_targetLanguage == 0;
    }

    public boolean isTargetCPP() {
        return this.m_targetLanguage == 1;
    }

    public DataFlowCodeGenerationHelper(String string) {
        this(string, new CodeGenerationSettings());
    }

    public DataFlowCodeGenerationHelper(String string, CodeGenerationSettings codeGenerationSettings) {
        this.setSettings(codeGenerationSettings);
        this.m_currentBuffer = this.m_primaryBuffer = MemoryEfficientBuffer.obtainBuffer();
        this.setClassName(string);
        if (codeGenerationSettings.getTargetLanguage() == 3) {
            this.setupCPP();
        }
    }

    public void generateMainProgram(Writer writer) {
        this.m_preClassBuffer.releaseAndWriteOut(writer, this.m_scratchCharBuffer);
        this.m_primaryBuffer.releaseAndWriteOut(writer, this.m_scratchCharBuffer);
    }

    public String generateNewLocalVariableName(Object object) {
        return object == null || this.getSettings().isSuppressComments() ? this.generateNewLocalVariableName() : "/* " + object + " */" + this.generateNewLocalVariableName();
    }

    public String generateNewLocalVariableName() {
        return "ivn" + ++this.m_identifiers;
    }

    public String generateNewMemberVariableName(Object object) {
        if (object == null) {
            return this.generateNewMemberVariableName();
        }
        String string = object.toString();
        return "m" + ++this.m_memberIdentifiers + "_" + string.replace('-', '_').replace('.', '_');
    }

    public String generateNewMemberVariableName() {
        return "m" + ++this.m_memberIdentifiers;
    }

    public String generateThisVar() {
        return this.getSettings().isMakeAllMethodsStatic() ? "__this__" : this.getClassName() + ".this";
    }

    public String generateStringConstant(String string) {
        if (this.isTargetJava()) {
            int n;
            if (string.length() == 0) {
                return "new char[0]";
            }
            if (string.length() < 8191) {
                return "\"" + LiteralInstruction.escape(string) + "\".toCharArray()";
            }
            StringBuffer stringBuffer = new StringBuffer("new StringBuffer()");
            for (int i = 0; i < string.length(); i += n) {
                n = Math.min(8191, string.length() - i);
                stringBuffer.append(".append(\"");
                stringBuffer.append(LiteralInstruction.escape(string.substring(i, i + n)));
                stringBuffer.append("\")");
            }
            return stringBuffer.append(".toString().toCharArray()").toString();
        }
        return "__makeStringConstant(\"" + LiteralInstruction.escape(string) + "\")";
    }

    public void startFunction(FunctionGenerationStyle functionGenerationStyle) {
        if (this.getSettings().isMakeAllMethodsStatic()) {
            this.m_currentBuffer = this.m_functionBuffer;
        }
        this.m_currentFGS = functionGenerationStyle;
        this.m_identifiers = 0;
    }

    public String getCurrentFunction() {
        return this.m_currentFGS == null ? null : this.m_currentFGS.getFunction().getName();
    }

    public FunctionGenerationStyle getCurrentFunctionGenerationStyle() {
        return this.m_currentFGS;
    }

    public void endFunction() {
        if (this.getSettings().isMakeAllMethodsStatic()) {
            ++this.m_functionCount;
            if (this.m_functionCount == this.getSettings().getMaxFunctionsPerPartition()) {
                this.flushFunctions();
            }
            this.m_currentBuffer = this.m_primaryBuffer;
        }
        this.m_currentFGS = null;
    }

    protected void emitPartition(MemoryEfficientBuffer memoryEfficientBuffer) {
        String string = this.m_constantsClassPrefix + "Partition" + this.m_constantClassIndex;
        if (this.m_basePath == null) {
            if (this.isTargetJava()) {
                this.m_postClassBuffer.write("abstract class " + string + " extends " + this.m_constantsClassPrefix + "Partition" + (this.m_constantClassIndex + 1) + " {\n");
            }
            memoryEfficientBuffer.releaseAndWriteOut(this.m_postClassBuffer, this.m_scratchCharBuffer);
            if (this.isTargetJava()) {
                this.m_postClassBuffer.write("}\n\n");
            }
        } else {
            File file = new File(this.m_basePath, string + ".java");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                if (this.m_packageName != null) {
                    outputStreamWriter.write("package " + this.m_packageName + ";\n");
                }
                outputStreamWriter.write("abstract class " + string + " extends ");
                if (this.m_packageName != null) {
                    outputStreamWriter.write(this.m_packageName + ".");
                }
                outputStreamWriter.write(this.m_constantsClassPrefix + "Partition" + (this.m_constantClassIndex + 1) + " {\n");
                outputStreamWriter.flush();
                memoryEfficientBuffer.releaseAndWriteOut(fileOutputStream, this.m_scratchByteBuffer);
                fileOutputStream.flush();
                outputStreamWriter.write("}\n\n");
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void flushFunctions() {
        this.m_functionCount = 0;
        this.emitPartition(this.m_functionBuffer);
        this.m_functionBuffer = MemoryEfficientBuffer.obtainBuffer();
        ++this.m_constantClassIndex;
    }

    public void append(String string) {
        this.m_currentBuffer.write(string);
    }

    public void append(char c) {
        this.m_currentBuffer.write(c);
    }

    public void append(Object object) {
        this.m_currentBuffer.write(object.toString());
        String string = object.toString();
    }

    public void appendStaticStatement(String string) {
        this.m_staticBuffer.write(string);
        if (this.getSettings().isMakeAllMethodsStatic()) {
            ++this.m_staticCount;
            this.m_staticBufferLength += string.length();
            if (this.m_staticBufferLength > 16384) {
                this.flushStatics();
            }
        }
    }

    public void addImport(String string) {
        this.m_imports.add(string);
    }

    protected void flushStatics() {
        if (this.m_staticCount == 0) {
            return;
        }
        if (this.isTargetJava()) {
            this.m_constantBuffer.write("public static final ");
        }
        this.m_constantBuffer.write("void __xylem_initStatic" + this.m_staticMethodIndex + "() {\n");
        this.m_staticBuffer.releaseAndWriteOut(this.m_constantBuffer, this.m_scratchCharBuffer);
        this.m_staticBufferLength = 0;
        this.m_constantCount += this.m_staticCount;
        this.m_constantBuffer.write("}\n\n");
        this.m_staticCount = 0;
        if (this.m_staticMethodIndex % 20 == 0) {
            this.emitPartition(this.m_constantBuffer);
            this.m_constantBuffer = MemoryEfficientBuffer.obtainCountableBuffer();
            ++this.m_constantClassIndex;
            this.m_constantCount = 0;
        }
        this.m_staticBuffer = MemoryEfficientBuffer.obtainCountableBuffer();
        ++this.m_staticMethodIndex;
    }

    public void flushStaticBuffer(Writer writer) {
        this.m_staticBuffer.releaseAndWriteOut(writer, this.m_scratchCharBuffer);
        this.m_staticBufferLength = 0;
    }

    public void generateStaticSection(Writer writer) throws IOException {
        if (this.getSettings().isMakeAllMethodsStatic()) {
            int n;
            this.flushStatics();
            if (this.isTargetJava()) {
                writer.write("static {\n");
            } else {
                writer.write("__xylem_postStatic();\n");
                for (n = 0; n < this.m_staticMethodIndex; ++n) {
                    writer.write("void __xylem_initStatic");
                    writer.write(Integer.toString(n));
                    writer.write("();\n");
                }
                writer.write("int __xylem_doStaticInit() {\n");
            }
            for (n = 0; n < this.m_staticMethodIndex; ++n) {
                writer.write(this.getStaticFieldPrefix());
                writer.write("__xylem_initStatic");
                writer.write(Integer.toString(n));
                writer.write("();\n");
            }
            writer.write("__xylem_postStatic();\n");
            if (this.isTargetCPP()) {
                writer.write("return 0;\n");
                writer.write("}\n");
                writer.write("int __static_init_dummy__ = __xylem_doStaticInit();\n");
            } else {
                writer.write("}\n");
            }
            this.m_endOfClassBuffer.releaseAndWriteOut(writer, this.m_scratchCharBuffer);
        } else {
            if (this.isTargetJava()) {
                writer.write("static {\n");
                this.m_staticBuffer.releaseAndWriteOut(writer, this.m_scratchCharBuffer);
                this.m_staticBufferLength = 0;
            }
            if (!this.isTargetJava()) {
                writer.write("static int __xylem_postStatic();\nstatic int run__xylem_poststatic=");
            }
            writer.write("__xylem_postStatic();\n");
            if (this.isTargetJava()) {
                writer.write("}\n");
            }
        }
    }

    public void generateConstantsSection(Writer writer) throws IOException {
        if (!this.isTargetJava()) {
            writer.write("static jmp_buf ErrorJmp;\n");
        }
        this.generateConstantPools();
        if (!this.getSettings().isMakeAllMethodsStatic()) {
            this.m_constantBuffer.releaseAndWriteOut(writer, this.m_scratchCharBuffer);
        }
        this.generateThreadLocalVariables(writer);
    }

    public void generateImports(Writer writer) throws IOException {
        Iterator iterator = this.m_imports.iterator();
        while (iterator.hasNext()) {
            this.generateImport(writer, (String)iterator.next());
        }
    }

    private void generateImport(Writer writer, String string) throws IOException {
        if (this.isTargetJava()) {
            writer.write("import " + string + ";\n");
        } else if (this.isTargetCPP()) {
            writer.write("#include " + string + "\n");
        }
    }

    public void generateLambdaTypes(Writer writer, Program program) throws IOException {
        Iterator iterator = this.lambdaTypeGenerationRequestsIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LambdaType lambdaType = this.lambdaTypeGenerationRequestsGet(string);
            writer.write("abstract static class " + string + " {\n");
            writer.write("abstract public " + lambdaType.getReturnType().getImplementationName(this) + " invoke(");
            Type[] typeArray = lambdaType.getElementTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                if (i != 0) {
                    writer.write(", ");
                }
                StringBuffer stringBuffer = new StringBuffer();
                typeArray[i].generateParamSpec(stringBuffer, this, "x" + i, program);
                writer.write(stringBuffer.toString());
            }
            writer.write(");\n}\n");
        }
    }

    public final void generateSlotTypes(Writer writer) throws IOException {
        Iterator iterator = this.slotTypeGenerationRequestsIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SlotType slotType = this.slotTypeGenerationRequestsGet(string);
            writer.write("static class " + string + " {\n");
            String string2 = slotType.getElementType().getImplementationName(this);
            writer.write("public " + string + "(" + string2 + " x) { this.m_value = x; }\n");
            writer.write("public " + string2 + " m_value;\n");
            writer.write("}\n");
        }
    }

    public final void generatePromiseTypes(Writer writer) throws IOException {
        Iterator iterator = this.promiseTypeGenerationRequestsIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PromiseType promiseType = this.promiseTypeGenerationRequestsGet(string);
            writer.write("static abstract class " + string + " {\n");
            String string2 = promiseType.getBodyType().getImplementationName(this);
            writer.write("public boolean forced = false;\n");
            writer.write("public " + string2 + " mem;\n");
            writer.write("public final " + string2 + " force() { if (forced) return mem; else { forced = true; return mem = memoize(); } }");
            writer.write("protected abstract " + string2 + " memoize();");
            writer.write("}\n");
        }
    }

    public final void generateLazyStreamTypes(Writer writer) throws IOException {
        Iterator iterator = this.lazyStreamTypeGenerationRequestsIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LazyStreamType lazyStreamType = this.lazyStreamTypeGenerationRequestsGet(string);
            writer.write("static abstract class " + string + " {\n");
            String string2 = lazyStreamType.getElementType().getImplementationName(this);
            writer.write("public " + string2 + "[] m_data;\n");
            writer.write("public int m_length = 0;\n");
            writer.write("public boolean m_complete = false;\n");
            writer.write("protected abstract void evaluateMore(int newIndex);\n");
            writer.write("}\n");
        }
    }

    public void appendPostClass(String string) {
        this.m_postClassBuffer.write(string);
    }

    public void appendPreClass(String string) {
        this.m_preClassBuffer.write(string);
    }

    public void generatePostClassSection(String string, Writer writer, Program program) throws IOException {
        if (this.getSettings().isMakeAllMethodsStatic()) {
            this.flushConstants();
            this.flushFunctions();
            if (this.isTargetJava()) {
                this.m_postClassBuffer.write("abstract class " + this.m_constantsClassPrefix + "Partition" + this.m_constantClassIndex + " extends " + this.m_constantsClassPrefix + "PartitionFinal {}\n");
                this.m_postClassBuffer.write("abstract class " + this.m_constantsClassPrefix + "PartitionFinal ");
                if (string != null) {
                    this.m_postClassBuffer.write("extends ");
                    this.m_postClassBuffer.write(string);
                }
                this.m_postClassBuffer.write("{\n");
                this.generateLambdaTypes(this.m_postClassBuffer, program);
                this.generatePromiseTypes(this.m_postClassBuffer);
                this.generateLazyStreamTypes(this.m_postClassBuffer);
                this.generateSlotTypes(this.m_postClassBuffer);
                this.m_postClassBuffer.write("}\n");
            }
            this.m_postClassBuffer.releaseAndWriteOut(writer, this.m_scratchCharBuffer);
        }
    }

    public void appendConstantStatement(String string) {
        if (this.isTargetCPP()) {
            this.m_preClassBuffer.write(string);
            return;
        }
        this.m_constantBuffer.write(string);
        if (this.getSettings().isMakeAllMethodsStatic()) {
            ++this.m_constantCount;
            if (this.m_constantCount > 16384) {
                this.flushConstants();
            }
        }
    }

    protected void flushConstants() {
        if (this.m_constantCount == 0) {
            return;
        }
        this.m_constantCount = 0;
        this.emitPartition(this.m_constantBuffer);
        this.m_constantBuffer = MemoryEfficientBuffer.obtainCountableBuffer();
        ++this.m_constantClassIndex;
    }

    public String getStaticFieldPrefix() {
        return this.isTargetCPP() ? "" : this.getClassName() + ".";
    }

    public String generateConstant(String string, String string2) {
        if (this.m_constants.containsKey(string2)) {
            return this.getStaticFieldPrefix() + (String)this.m_constants.get(string2);
        }
        String string3 = "s_" + this.generateNewMemberVariableName();
        this.appendConstantStatement((this.isTargetJava() ? "public " : "") + "static " + string + " " + string3 + ";\n");
        this.appendStaticStatement(this.getStaticFieldPrefix() + string3 + " = " + string2 + ";\n");
        this.m_constants.put(string2, string3);
        return this.getStaticFieldPrefix() + string3;
    }

    public void appendAssignment(String string, Type type, String string2, CodeGenerationTracker codeGenerationTracker) {
        this.append(this.m_finalKeyword + " ");
        Type type2 = type.resolveType(codeGenerationTracker.m_typeEnvironment);
        if (type2 == null) {
            throw new XylemError("ERR_SYSTEM", "type not found for " + type + " (" + string + ")");
        }
        this.append(type2.getImplementationName(this));
        this.append(" ");
        this.append(string);
        this.append(" = ");
        this.append(string2);
        this.append(";\n");
    }

    public void appendConstantAssignment(String string, Type type, String string2, CodeGenerationTracker codeGenerationTracker) {
        type = type.resolveType(codeGenerationTracker.m_typeEnvironment);
        this.appendConstantStatement((this.isTargetJava() ? "public " : "") + "static " + type.getImplementationName(this) + " " + string + ";\n");
        this.appendStaticStatement(this.getStaticFieldPrefix() + string + " = " + string2 + ";\n");
    }

    public void allocateThreadLocalVariable(String string, String string2) {
        if (!this.m_threadLocalVariables.containsKey(string)) {
            this.m_threadLocalVariables.put(string, string2);
            if (this.isTargetCPP()) {
                this.appendPreClass(string2 + " m_tls_" + string + ";\n");
            }
        }
    }

    public String generateThreadLocalVarReference(String string) {
        string = "m_tls_" + string;
        if (this.getSettings().isSingleThreadPerInstance()) {
            return (this.getSettings().isMakeAllMethodsStatic() ? "__this__." : "") + string;
        }
        return "((ThreadLocalVariables) m___threadlocal__.get())." + string;
    }

    protected void generateThreadLocalVariables(Writer writer) throws IOException {
        if (!this.m_threadLocalVariables.isEmpty() && this.isTargetJava()) {
            if (!this.getSettings().isSingleThreadPerInstance()) {
                writer.write("class ThreadLocalVariables {\n");
            }
            for (String string : this.m_threadLocalVariables.keySet()) {
                String string2 = (String)this.m_threadLocalVariables.get(string);
                writer.write(string2 + " m_tls_" + string + ";\n");
            }
            if (!this.getSettings().isSingleThreadPerInstance()) {
                writer.write("}\nprotected ThreadLocal m___threadlocal__ = new ThreadLocal() {\nprotected synchronized Object initialValue() {\nreturn new ThreadLocalVariables();\n}\n};\n");
            }
        }
    }

    protected void generateConstantPools() throws IOException {
        for (Type type : this.m_typedConstantPools.keySet()) {
            TypedConstantPool typedConstantPool = (TypedConstantPool)this.m_typedConstantPools.get(type);
            typedConstantPool.generate(type);
        }
    }

    public ConstantEntry addConstantElement(String string, Type type) {
        return this.getConstantPool(type).addEntries(new String[]{string});
    }

    public ConstantEntry addConstantElements(String[] stringArray, Type type) {
        ConstantEntry constantEntry = this.getConstantPool(type).addEntries(stringArray);
        if (!this.getSettings().m_suppressComments) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
            }
            this.append("//pooled constant " + constantEntry.m_identifier + "[" + constantEntry.m_index + "]='" + stringBuffer.toString().replace('\n', 'n') + "'\n");
        }
        return constantEntry;
    }

    public String getConstantPoolName(Type type) {
        return this.getConstantPool((Type)type).m_name;
    }

    private TypedConstantPool getConstantPool(Type type) {
        TypedConstantPool typedConstantPool = (TypedConstantPool)this.m_typedConstantPools.get(type);
        if (typedConstantPool == null) {
            if (type == CharType.s_charType) {
                typedConstantPool = new CharConstantPool();
                this.m_typedConstantPools.put(type, typedConstantPool);
            } else {
                typedConstantPool = new TypedConstantPool();
                this.m_typedConstantPools.put(type, typedConstantPool);
            }
        }
        return typedConstantPool;
    }

    public int getConstantClassIndex() {
        return this.m_constantClassIndex;
    }

    public String getConstantsClassPrefix() {
        return this.m_constantsClassPrefix;
    }

    public void appendRecycleStatement(String string) {
        this.m_recycleBuffer.write(string);
    }

    public void generateRecycleMethod(Writer writer) throws IOException {
        if (this.isTargetJava()) {
            writer.write("public ");
        }
        writer.write("void __xylem_recycle() {\n");
        this.m_recycleBuffer.releaseAndWriteOut(writer, this.m_scratchCharBuffer);
        writer.write("\n}\n");
    }

    class CharConstantPool
    extends TypedConstantPool {
        CharConstantPool() {
        }

        @Override
        int addEntry(String string) {
            this.m_buffer.append(string.substring(1, string.length() - 1));
            return this.m_entries++;
        }

        @Override
        void generateBuffer(StringBuffer stringBuffer, String string, Type type) throws IOException {
            DataFlowCodeGenerationHelper.this.appendConstantStatement((DataFlowCodeGenerationHelper.this.isTargetJava() ? "public " : "") + "static " + type.getImplementationName(DataFlowCodeGenerationHelper.this) + (DataFlowCodeGenerationHelper.this.isTargetCPP() ? DataFlowCodeGenerationHelper.this.m_arraySuffix : "[] ") + string + ";\n");
            DataFlowCodeGenerationHelper.this.flushStatics();
            DataFlowCodeGenerationHelper.this.appendStaticStatement(DataFlowCodeGenerationHelper.this.getStaticFieldPrefix() + string + " = (\"" + stringBuffer.toString() + "\")" + (DataFlowCodeGenerationHelper.this.isTargetJava() ? ".toCharArray()" : "") + ";\n");
            DataFlowCodeGenerationHelper.this.flushStatics();
        }
    }

    class TypedConstantPool {
        ArrayList m_pastBuffers = new ArrayList();
        StringBuffer m_buffer = new StringBuffer();
        int m_entries = 0;
        String m_name = DataFlowCodeGenerationHelper.this.generateNewMemberVariableName("pool");
        int m_poolIndex = 0;
        HashMap m_cache = new HashMap();

        TypedConstantPool() {
        }

        ConstantEntry addEntries(String[] stringArray) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length + this.m_entries > 4096) {
                ++this.m_poolIndex;
                this.m_entries = 0;
                this.m_pastBuffers.add(this.m_buffer);
                this.m_buffer = new StringBuffer();
            }
            if (this.m_cache.containsKey(stringBuffer.toString())) {
                return (ConstantEntry)this.m_cache.get(stringBuffer.toString());
            }
            n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = this.addEntry(stringArray[i]);
                if (n != -1) continue;
                n = n2;
            }
            ConstantEntry constantEntry = new ConstantEntry(this.m_name + this.m_poolIndex, n);
            this.m_cache.put(stringBuffer.toString(), constantEntry);
            return constantEntry;
        }

        int addEntry(String string) {
            this.m_buffer.append(string);
            this.m_buffer.append(',');
            if (this.m_entries % 100 == 0) {
                this.m_buffer.append('\n');
            }
            return this.m_entries++;
        }

        void generate(Type type) throws IOException {
            if (this.m_buffer.length() > 0) {
                this.m_pastBuffers.add(this.m_buffer);
            }
            int n = this.m_pastBuffers.size();
            for (int i = 0; i < n; ++i) {
                this.generateBuffer((StringBuffer)this.m_pastBuffers.get(i), this.m_name + i, type);
            }
        }

        void generateBuffer(StringBuffer stringBuffer, String string, Type type) throws IOException {
            DataFlowCodeGenerationHelper.this.appendConstantStatement((DataFlowCodeGenerationHelper.this.isTargetJava() ? "public " : "") + "static " + type.getImplementationName(DataFlowCodeGenerationHelper.this) + "[] " + string + ";\n");
            DataFlowCodeGenerationHelper.this.flushStatics();
            DataFlowCodeGenerationHelper.this.appendStaticStatement(DataFlowCodeGenerationHelper.this.getStaticFieldPrefix() + string + " = new " + type.getImplementationName(DataFlowCodeGenerationHelper.this) + "[] " + "{\n" + stringBuffer.toString() + "};\n");
            DataFlowCodeGenerationHelper.this.flushStatics();
        }
    }

    public static class ConstantEntry {
        public String m_identifier;
        public int m_index;

        public ConstantEntry(String string, int n) {
            this.m_identifier = string;
            this.m_index = n;
        }
    }
}

