/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator.v1;

import com.ibm.xtq.xslt.translator.v1.NamespaceContext;
import com.ibm.xtq.xslt.translator.v1.RTFContext;
import com.ibm.xtq.xslt.translator.v1.TranslatorConstants;
import com.ibm.xtq.xslt.translator.v1.ValueContext;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class TranslatorContext
implements TranslatorConstants {
    protected final Map EMPTY_HASH = new HashMap();
    private TranslatorContext m_parent;
    private StaticContext m_staticContext;
    private boolean m_seenChild;
    private boolean m_neverEscapeText;
    private Instruction m_enclosingElement;

    protected TranslatorContext(TranslatorContext translatorContext, boolean bl, boolean bl2, Instruction instruction) {
        this.m_parent = translatorContext;
        this.m_staticContext = translatorContext.m_staticContext;
        this.m_seenChild = bl;
        this.m_neverEscapeText = bl2;
        this.m_enclosingElement = instruction;
    }

    protected TranslatorContext(StaticContext staticContext, boolean bl, boolean bl2, Instruction instruction) {
        this.m_parent = null;
        this.m_staticContext = staticContext;
        this.m_seenChild = bl;
        this.m_neverEscapeText = bl2;
        this.m_enclosingElement = instruction;
    }

    public static RTFContext createInitialContext(HashSet hashSet, String string) {
        StaticContext staticContext = new StaticContext(hashSet, string);
        RTFContext rTFContext = new RTFContext(staticContext, false, false, null);
        return rTFContext;
    }

    public static RTFContext createElementContext(TranslatorContext translatorContext, Instruction instruction, boolean bl) {
        if (instruction == null) {
            instruction = new IdentifierInstruction("__parentnodename__");
        }
        NamespaceContext namespaceContext = new NamespaceContext(translatorContext, false, bl, instruction);
        return namespaceContext;
    }

    public static RTFContext createElementContext(TranslatorContext translatorContext, Instruction instruction) {
        return TranslatorContext.createElementContext(translatorContext, instruction, translatorContext.m_neverEscapeText);
    }

    public static RTFContext createInnerRTFContext(TranslatorContext translatorContext) {
        RTFContext rTFContext = new RTFContext(translatorContext, translatorContext.m_seenChild, translatorContext.m_neverEscapeText, translatorContext.enclosingElement());
        return rTFContext;
    }

    public static ValueContext createValueContext(TranslatorContext translatorContext) {
        ValueContext valueContext = new ValueContext(translatorContext, true, translatorContext.m_neverEscapeText, null);
        return valueContext;
    }

    public static TranslatorContext createConditionalContext(TranslatorContext translatorContext) {
        if (translatorContext.isRTFContext()) {
            NamespaceContext namespaceContext = new NamespaceContext(translatorContext, translatorContext.m_seenChild, translatorContext.m_neverEscapeText, translatorContext.enclosingElement());
            return namespaceContext;
        }
        return TranslatorContext.createValueContext(translatorContext);
    }

    public boolean isRTFContext() {
        return false;
    }

    public boolean isValueContext() {
        return false;
    }

    public TranslatorContext getParent() {
        return this.m_parent;
    }

    public void addConstraint(Object object) {
        this.m_staticContext.m_constraints.add(object);
    }

    public HashSet constraints() {
        return this.m_staticContext.m_constraints;
    }

    public String variablePrefix() {
        return this.m_staticContext.m_variablePrefix;
    }

    public void setSeenChild() {
        this.m_seenChild = true;
    }

    public boolean seenChild() {
        return this.m_seenChild;
    }

    public boolean neverEscapeText() {
        return this.m_neverEscapeText;
    }

    public Instruction enclosingElement() {
        if (this.m_enclosingElement == null) {
            return null;
        }
        return this.m_enclosingElement.cloneWithoutTypeInformation();
    }

    public boolean namespacesValid() {
        return true;
    }

    public void setNamespacesInvalid() {
        if (this.m_parent != null) {
            this.m_parent.setNamespacesInvalid();
        }
    }

    public Map getNamespaces() {
        return this.EMPTY_HASH;
    }

    public void addNamespaces(Map map) {
        if (this.m_parent != null) {
            this.m_parent.addNamespaces(map);
        }
    }

    public void addNamespace(String string, String string2) {
        if (this.m_parent != null) {
            this.m_parent.addNamespace(string, string2);
        }
    }

    public abstract void addVarDecl(Object var1, Instruction var2);

    public abstract void addText(Instruction var1);

    public abstract void addSAXEvents(Instruction var1);

    public abstract void addBody(Instruction var1);

    public abstract Instruction getBody();

    public abstract void createContextLoopAndClose(Instruction var1);

    protected static class StaticContext {
        public HashSet m_constraints;
        public String m_variablePrefix;

        public StaticContext(HashSet hashSet, String string) {
            this.m_constraints = hashSet;
            this.m_variablePrefix = string;
        }
    }
}

