/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.classfile;

import com.ibm.xtq.bcel.classfile.Attribute;
import com.ibm.xtq.bcel.classfile.Code;
import com.ibm.xtq.bcel.classfile.CodeException;
import com.ibm.xtq.bcel.classfile.Constant;
import com.ibm.xtq.bcel.classfile.ConstantClass;
import com.ibm.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xtq.bcel.classfile.ConstantInterfaceMethodref;
import com.ibm.xtq.bcel.classfile.ConstantLong;
import com.ibm.xtq.bcel.classfile.ConstantMethodref;
import com.ibm.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xtq.bcel.classfile.ConstantPool;
import com.ibm.xtq.bcel.classfile.ConstantString;
import com.ibm.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xtq.bcel.classfile.ConstantValue;
import com.ibm.xtq.bcel.classfile.Deprecated;
import com.ibm.xtq.bcel.classfile.ExceptionTable;
import com.ibm.xtq.bcel.classfile.Field;
import com.ibm.xtq.bcel.classfile.InnerClass;
import com.ibm.xtq.bcel.classfile.InnerClasses;
import com.ibm.xtq.bcel.classfile.JavaClass;
import com.ibm.xtq.bcel.classfile.LineNumber;
import com.ibm.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xtq.bcel.classfile.LocalVariable;
import com.ibm.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xtq.bcel.classfile.Method;
import com.ibm.xtq.bcel.classfile.Signature;
import com.ibm.xtq.bcel.classfile.SourceFile;
import com.ibm.xtq.bcel.classfile.StackMap;
import com.ibm.xtq.bcel.classfile.StackMapEntry;
import com.ibm.xtq.bcel.classfile.Synthetic;
import com.ibm.xtq.bcel.classfile.Unknown;
import com.ibm.xtq.bcel.classfile.Visitor;
import java.util.Stack;

public class DescendingVisitor
implements Visitor {
    private JavaClass clazz;
    private Visitor visitor;
    private Stack stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass clazz, Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    public void visitJavaClass(JavaClass clazz) {
        this.stack.push(clazz);
        clazz.accept(this.visitor);
        Field[] fields = clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            fields[i].accept(this);
            ++i;
        }
        Method[] methods = clazz.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            methods[i2].accept(this);
            ++i2;
        }
        Attribute[] attributes = clazz.getAttributes();
        int i3 = 0;
        while (i3 < attributes.length) {
            attributes[i3].accept(this);
            ++i3;
        }
        clazz.getConstantPool().accept(this);
        this.stack.pop();
    }

    public void visitField(Field field) {
        this.stack.push(field);
        field.accept(this.visitor);
        Attribute[] attributes = field.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            attributes[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitConstantValue(ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    public void visitMethod(Method method) {
        this.stack.push(method);
        method.accept(this.visitor);
        Attribute[] attributes = method.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            attributes[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitExceptionTable(ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    public void visitCode(Code code) {
        this.stack.push(code);
        code.accept(this.visitor);
        CodeException[] table = code.getExceptionTable();
        int i = 0;
        while (i < table.length) {
            table[i].accept(this);
            ++i;
        }
        Attribute[] attributes = code.getAttributes();
        int i2 = 0;
        while (i2 < attributes.length) {
            attributes[i2].accept(this);
            ++i2;
        }
        this.stack.pop();
    }

    public void visitCodeException(CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLineNumberTable(LineNumberTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        LineNumber[] numbers = table.getLineNumberTable();
        int i = 0;
        while (i < numbers.length) {
            numbers[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitLineNumber(LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariableTable(LocalVariableTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        LocalVariable[] vars = table.getLocalVariableTable();
        int i = 0;
        while (i < vars.length) {
            vars[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitStackMap(StackMap table) {
        this.stack.push(table);
        table.accept(this.visitor);
        StackMapEntry[] vars = table.getStackMap();
        int i = 0;
        while (i < vars.length) {
            vars[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitStackMapEntry(StackMapEntry var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariable(LocalVariable var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantPool(ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        int i = 1;
        while (i < constants.length) {
            if (constants[i] != null) {
                constants[i].accept(this);
            }
            ++i;
        }
        this.stack.pop();
    }

    public void visitConstantClass(ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantDouble(ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFieldref(ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFloat(ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInteger(ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantLong(ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantMethodref(ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantNameAndType(ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantString(ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantUtf8(ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitInnerClasses(InnerClasses ic) {
        this.stack.push(ic);
        ic.accept(this.visitor);
        InnerClass[] ics = ic.getInnerClasses();
        int i = 0;
        while (i < ics.length) {
            ics[i].accept(this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitInnerClass(InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    public void visitDeprecated(Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSignature(Signature attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSourceFile(SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSynthetic(Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitUnknown(Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }
}

