/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    static final long serialVersionUID = -6670449967116905820L;
    private StepPattern[] m_patterns;

    @Override
    public void fixupVariables(Vector vector, int n) {
        for (int i = 0; i < this.m_patterns.length; ++i) {
            this.m_patterns[i].fixupVariables(vector, n);
        }
    }

    @Override
    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            for (int i = 0; i < n; ++i) {
                if (!this.m_patterns[i].canTraverseOutsideSubtree()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] stepPatternArray) {
        this.m_patterns = stepPatternArray;
        if (null != stepPatternArray) {
            for (int i = 0; i < stepPatternArray.length; ++i) {
                stepPatternArray[i].exprSetParent(this);
            }
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    @Override
    public XObject execute(XPathContext xPathContext) throws TransformerException {
        XObject xObject = null;
        int n = this.m_patterns.length;
        for (int i = 0; i < n; ++i) {
            XObject xObject2 = this.m_patterns[i].execute(xPathContext);
            if (xObject2 == NodeTest.SCORE_NONE) continue;
            if (null == xObject) {
                xObject = xObject2;
                continue;
            }
            if (!(xObject2.num() > xObject.num())) continue;
            xObject = xObject2;
        }
        if (null == xObject) {
            xObject = NodeTest.SCORE_NONE;
        }
        return xObject;
    }

    @Override
    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitUnionPattern(expressionOwner, this);
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            for (int i = 0; i < n; ++i) {
                this.m_patterns[i].callVisitors(new UnionPathPartOwner(i), xPathVisitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expression) {
        if (!this.isSameClass(expression)) {
            return false;
        }
        UnionPattern unionPattern = (UnionPattern)expression;
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            if (null == unionPattern.m_patterns || unionPattern.m_patterns.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_patterns[i].deepEquals(unionPattern.m_patterns[i])) continue;
                return false;
            }
        } else if (unionPattern.m_patterns != null) {
            return false;
        }
        return true;
    }

    class UnionPathPartOwner
    implements ExpressionOwner {
        int m_index;

        UnionPathPartOwner(int n) {
            this.m_index = n;
        }

        @Override
        public Expression getExpression() {
            return UnionPattern.this.m_patterns[this.m_index];
        }

        @Override
        public void setExpression(Expression expression) {
            expression.exprSetParent(UnionPattern.this);
            ((UnionPattern)UnionPattern.this).m_patterns[this.m_index] = (StepPattern)expression;
        }
    }
}

