DECLARE SUB setopfreq (f AS SINGLE, iyaesu AS INTEGER)
DECLARE SUB decompose (qrg AS SINGLE, iq() AS INTEGER)
DECLARE SUB selectopmode (i AS INTEGER, iyaesu AS INTEGER)
DEFINT I-N
DIM f AS STRING, m AS STRING, iyaesu AS INTEGER

'       CAT CONTROL SOFTWARE FOR YAESU
'
'       COPYRIGHT LAURENT LABOURIE F6DEX
'
'       CHOOSE A TRANSCEIVER

        iyaesu = 6      '1=990 2=1000MP 3=840 4=890 5=900 6=920 7=1000D
'
'       CHOOSE A SERIAL PORT

        com$ = "1"      'serial port = com1'

        YAESU$ = "COM" + com$ + ":4800,n,8,2,CD0,CS0,DS0,OP0,BIN"
        OPEN YAESU$ FOR RANDOM AS #2 LEN = 1

'       HOW TO SET A FREQUENCY & MODE

        DO
                CLS
                LOCATE 1, 1, 0
                PRINT "SOFT990 - DEMO MODULE BY F6DEX - ENTER TO EXIT"
                INPUT "ENTER THE FREQUENCY (MHZ) : "; f
                IF f = "" THEN END
                CALL setopfreq(VAL(f), iyaesu)
                INPUT "ENTER THE MODE 0=LSB 1=USB 2=CW 3=AM 4=FM 5=FSK 6=PKT : "; m
                IF m = "" THEN END
                CALL selectopmode(VAL(m), iyaesu)
        LOOP
END

DEFSNG I-N
SUB decompose (qrg AS SINGLE, iq() AS INTEGER)
DEFINT I-N
iq(1) = FIX(qrg / 10! + .0000001)
iq(2) = FIX(qrg - iq(1) * 10! + .000001)
qrg = qrg * 1000! - iq(1) * 10000! - iq(2) * 1000!
iq(3) = 10
iq(4) = FIX(qrg / 100! + .00001)
iq(5) = FIX((qrg - iq(4) * 100!) / 10 + .0001)
iq(6) = FIX(qrg - iq(4) * 100! - iq(5) * 10! + .001)
qrg = qrg * 100! - iq(4) * 10000! - iq(5) * 1000! - iq(6) * 100!
iq(7) = 10
iq(8) = FIX(qrg / 10! + .01)
iq(9) = FIX(qrg - iq(8) * 10! + .1)
END SUB

DEFSNG I-N
SUB selectopmode (i AS INTEGER, iyaesu AS INTEGER)
DEFINT I-N
iopcode = 0     ' VFO B (FT1000MP/D & FT-920) : iopcode=128
im = i
IF i = 3 THEN im = 5    ' im = 4 for AM wide
IF i = 3 AND iyaesu = 2 THEN im = 4
IF i = 4 THEN im = 7
IF i = 5 THEN im = 8
IF i = 5 AND iyaesu = 6 THEN im = 9
IF i = 6 THEN im = 10
PRINT #2, CHR$(0); CHR$(0); CHR$(0); CHR$(im + iopcode); CHR$(12);
END SUB

DEFSNG I-N
SUB setopfreq (f AS SINGLE, iyaesu AS INTEGER)
DEFINT I-N
DIM iq(12) AS INTEGER
freq = f
iopcode = 10    ' VFO B (FT1000MP/D & FT-920) : iopcode=138
freq = ABS(freq)
CALL decompose(freq, iq())
a1 = iq(8) * 16 + iq(9)
a2 = iq(5) * 16 + iq(6)
a3 = iq(2) * 16 + iq(4)
a4 = iq(1)
PRINT #2, CHR$(a1); CHR$(a2); CHR$(a3); CHR$(a4); CHR$(iopcode);
END SUB

