.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE RULE" "" "2010-10-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE RULE \- define a new rewrite rule

.SH SYNOPSIS
.sp
.nf
CREATE [ OR REPLACE ] RULE \fIname\fR AS ON \fIevent\fR
    TO \fItable\fR [ WHERE \fIcondition\fR ]
    DO [ ALSO | INSTEAD ] { NOTHING | \fIcommand\fR | ( \fIcommand\fR ; \fIcommand\fR ... ) }
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE RULE\fR defines a new rule applying to a specified
table or view.
\fBCREATE OR REPLACE RULE\fR will either create a
new rule, or replace an existing rule of the same name for the same
table.
.PP
The PostgreSQL rule system allows one to
define an alternative action to be performed on insertions, updates,
or deletions in database tables. Roughly speaking, a rule causes
additional commands to be executed when a given command on a given
table is executed. Alternatively, an INSTEAD
rule can replace a given command by another, or cause a command
not to be executed at all. Rules are used to implement table
views as well. It is important to realize that a rule is really
a command transformation mechanism, or command macro. The
transformation happens before the execution of the commands starts.
If you actually want an operation that fires independently for each
physical row, you probably want to use a trigger, not a rule.
More information about the rules system is in in the documentation.
.PP
Presently, ON SELECT rules must be unconditional
INSTEAD rules and must have actions that consist
of a single \fBSELECT\fR command. Thus, an
ON SELECT rule effectively turns the table into
a view, whose visible contents are the rows returned by the rule's
\fBSELECT\fR command rather than whatever had been
stored in the table (if anything). It is considered better style
to write a \fBCREATE VIEW\fR command than to create a
real table and define an ON SELECT rule for it.
.PP
You can create the illusion of an updatable view by defining
ON INSERT, ON UPDATE, and
ON DELETE rules (or any subset of those that's
sufficient for your purposes) to replace update actions on the view
with appropriate updates on other tables. If you want to support
\fBINSERT RETURNING\fR and so on, then be sure to put a suitable
RETURNING clause into each of these rules.
.PP
There is a catch if you try to use conditional rules for view
updates: there \fBmust\fR be an unconditional
INSTEAD rule for each action you wish to allow
on the view. If the rule is conditional, or is not
INSTEAD, then the system will still reject
attempts to perform the update action, because it thinks it might
end up trying to perform the action on the dummy table of the view
in some cases. If you want to handle all the useful cases in
conditional rules, add an unconditional DO
INSTEAD NOTHING rule to ensure that the system
understands it will never be called on to update the dummy table.
Then make the conditional rules non-INSTEAD; in
the cases where they are applied, they add to the default
INSTEAD NOTHING action. (This method does not
currently work to support RETURNING queries, however.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of a rule to create. This must be distinct from the
name of any other rule for the same table. Multiple rules on
the same table and same event type are applied in alphabetical
name order.
.TP
\fB\fIevent\fB\fR
The event is one of SELECT,
INSERT, UPDATE, or
DELETE.
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of the table or view the
rule applies to.
.TP
\fB\fIcondition\fB\fR
Any SQL conditional expression (returning
\fBboolean\fR). The condition expression cannot refer
to any tables except NEW and OLD, and
cannot contain aggregate functions.
.TP
\fBINSTEAD\fR
INSTEAD indicates that the commands should be
executed \fBinstead of\fR the original command.
.TP
\fBALSO\fR
ALSO indicates that the commands should be
executed \fBin addition to\fR the original
command.

If neither ALSO nor
INSTEAD is specified, ALSO
is the default.
.TP
\fB\fIcommand\fB\fR
The command or commands that make up the rule action. Valid
commands are \fBSELECT\fR,
\fBINSERT\fR, \fBUPDATE\fR,
\fBDELETE\fR, or \fBNOTIFY\fR.
.PP
Within \fIcondition\fR and
\fIcommand\fR, the special
table names NEW and OLD can
be used to refer to values in the referenced table.
NEW is valid in ON INSERT and
ON UPDATE rules to refer to the new row being
inserted or updated. OLD is valid in
ON UPDATE and ON DELETE rules
to refer to the existing row being updated or deleted.
.PP
.SH "NOTES"
.PP
You must be the owner of a table to create or change rules for it.
.PP
In a rule for INSERT, UPDATE, or
DELETE on a view, you can add a RETURNING
clause that emits the view's columns. This clause will be used to compute
the outputs if the rule is triggered by an \fBINSERT RETURNING\fR,
\fBUPDATE RETURNING\fR, or \fBDELETE RETURNING\fR command
respectively. When the rule is triggered by a command without
RETURNING, the rule's RETURNING clause will be
ignored. The current implementation allows only unconditional
INSTEAD rules to contain RETURNING; furthermore
there can be at most one RETURNING clause among all the rules
for the same event. (This ensures that there is only one candidate
RETURNING clause to be used to compute the results.)
RETURNING queries on the view will be rejected if
there is no RETURNING clause in any available rule.
.PP
It is very important to take care to avoid circular rules. For
example, though each of the following two rule definitions are
accepted by PostgreSQL, the
\fBSELECT\fR command would cause
PostgreSQL to report an error because
of recursive expansion of a rule:
.sp
.nf
CREATE RULE "_RETURN" AS
    ON SELECT TO t1
    DO INSTEAD 
        SELECT * FROM t2;

CREATE RULE "_RETURN" AS
    ON SELECT TO t2
    DO INSTEAD 
        SELECT * FROM t1;

SELECT * FROM t1;
.sp
.fi
.PP
Presently, if a rule action contains a \fBNOTIFY\fR
command, the \fBNOTIFY\fR command will be executed
unconditionally, that is, the \fBNOTIFY\fR will be
issued even if there are not any rows that the rule should apply
to. For example, in:
.sp
.nf
CREATE RULE notify_me AS ON UPDATE TO mytable DO ALSO NOTIFY mytable;

UPDATE mytable SET name = 'foo' WHERE id = 42;
.sp
.fi
one \fBNOTIFY\fR event will be sent during the
\fBUPDATE\fR, whether or not there are any rows that
match the condition id = 42. This is an
implementation restriction that might be fixed in future releases.
.SH "COMPATIBILITY"
.PP
\fBCREATE RULE\fR is a
PostgreSQL language extension, as is the
entire query rewrite system.
