<?
/*
Autor (Author): Guilherme Augusto da Rocha Silva <gars.dba@gmail.com>
Criao (Created) - ISO: 2007/04/19
Verso (Version): 0.1
Liberao (Release): 20070430a

Desenvolvido, testado e funcionou bem em/com (Developed, tested and worked well in/with):
   - Intel Pentium IV 1.7GHZ, 256kb cache, 512mb RAM.
   - GNU/Linux with kernel 2.6, distro Debian 3.1.
   - PostgreSQL 8.1.
   - PHP 4.3.10 +  Zend Engine 1.3.0.
   - Apache 2.0.54 + PHP module.
   - Mozilla Firefox 2.0.0.3.
*/

// Bibliotecas
require_once('inc/inc_lib_db.php');
require_once('inc/inc_lib_geral.php');

// Configurao de conexo ao banco de dados.
$pg_usuario  = 'postgres';
$pg_servidor = 'localhost';
$pg_porta    = '5432';
$pg_base     = 'postgres';

// Instancializao de banco de dados.
$db = new database;
$db->connect ($pg_servidor, $pg_porta, $pg_base, $pg_usuario);

// Configurao do intervalo de atualizao de consultas.
$intervalos = array(2, 3, 5, 10, 30, 60);

// Configurao do menu de navegao.
$menu = array();
$menu[] = array('modulo' => 'geral',       'nome' => 'Geral',        'imagem' => 'pg_elefante.png');
$menu[] = array('modulo' => 'estatistica', 'nome' => 'Estatsticas', 'imagem' => 'dev_splash.png' );
$menu[] = array('modulo' => 'monitor',     'nome' => 'Monitor',      'imagem' => 'action_find.png');
//$menu[] = array('modulo' => 'estrutura',   'nome' => 'Estruturas',   'imagem' => 'dev_block.png'  );
//$menu[] = array('modulo' => 'ajuda',       'nome' => 'Ajuda',        'imagem' => 'msg_talk.png'   );

$filtros_gerais = array();
$filtros_gerais[] = array('nome' => 'Databases',   'imagem' => '');
$filtros_gerais[] = array('nome' => 'Tablespaces', 'imagem' => '');

$estruturas = array();
$estruturas[] = array('nome' => 'Databases',   'imagem' => '');
$estruturas[] = array('nome' => 'Tablespaces', 'imagem' => '');
$estruturas[] = array('nome' => 'Esquemas',    'imagem' => '');
$estruturas[] = array('nome' => 'Tabelas',     'imagem' => '');
$estruturas[] = array('nome' => 'ndices',     'imagem' => '');
$estruturas[] = array('nome' => 'Sequncias',  'imagem' => '');

echo '<html>'
   . identar(0).'<head>'
   . identar(1).'<title>Elefante PostgreSQL Monitor ... '.$_SERVER['SERVER_ADDR'].':'.$_SERVER['SERVER_PORT'].' ('.$_SERVER['SERVER_NAME'].')</title>'
   . identar(1)."<meta http-equiv='content-type' content='text/html;charset=iso-8859-2'>"
   . identar(1)."<meta http-equiv='pragma' content='no-cache'>"
   . identar(1)."<link rel='shortcut icon' href='img/pg_elefante.png'>";
   if (($intervalo = $_GET['intervalo']) or ($intervalo = $_POST['intervalo']) or ($intervalo = $GLOBALS['intervalo']) or ($intervalo = 10)) {
      echo identar(1)."<meta http-equiv='refresh' content=".$intervalo.';>';
   }
echo identar(0).'</head>'
   . identar(0).'<body>'
   . identar(1)."<font face='arial,helvetica' size='-1'>"
   . identar(1)."<form method='POST'>"
;
// Tabela do menu.
echo identar(2)."<table align='center' border='0' cellpadding='3' cellspacing='0' width='50%'>"
   . identar(3)."<tr bgcolor='#F0F0F0' valign='center'>"
;
foreach ($menu as $id=>$item) {
   echo identar(4)."<td align='center'>"
      . "<a href='index.php?menu_id=".$id."'>"
      . "<img src='img/".$item['imagem']."' alt='".$item['imagem']."' text='".$item['nome']."' border='0' align='base'>"
      . '</a>'
      . '<br>'
      . "<font face='arial,helvetica' size='-2'><b>".$item['nome'].'</b></font>'
      . '</td>'
   ;
}
// Tabela do contedo.
echo identar(2)."<table align='center' border='0' cellpadding='0' cellspacing='0' width='100%'>"
   . identar(3)."<tr bgcolor='' valign='center'>"
;
// Seleo de opo do menu navegao.
switch ($menu_id) {
   case 1:
      if (!$db or ! $db->connect) {
         //echo identar(4)."<td align='center' width='100%' nowrap><p><b>N&atilde;o foi poss&iacute;vel estabelecer a conex&atilde;o com o banco de dados.</b></p></td>";
         echo identar(4).mensagem_erro('N&atilde;o foi poss&iacute;vel estabelecer a conex&atilde;o com o banco de dados.');
         break;
      }
      echo identar(4)."<td align='center' width='100%' nowrap>".exibir_data_hora().'<br>'.exibir_estatisticas($db->get_databases(true, false, true, ($datname? $datname : ''))).'</td>';
      break;
   case 2:
      if (!$db or ! $db->connect) {
         echo identar(4).mensagem_erro('N&atilde;o foi poss&iacute;vel estabelecer a conex&atilde;o com o banco de dados.');
         break;
      }
      echo identar(4)."<td align='center' width='100%' nowrap>".exibir_data_hora().'<br>'.exibir_atividades($db->get_stat_activity()).'</td>';
      break;
   case 3:
      echo identar(4)."<td align='center' width='100%' nowrap>".exibir_data_hora().'<br>'.exibir_estruturas().'</td>';
      break;
   case 4:
      echo identar(4)."<td align='center' width='100%' nowrap>".exibir_data_hora().'<br>'.exibir_ajuda().'</td>';
      break;
   default:
      echo identar(4)."<td align='center' width='100%' nowrap>".exibir_data_hora().'<br>'.exibir_estado_servidor().'</td>';
      break;
}
echo identar(3).'</tr>'
   . identar(2)."</table>"
;
flush();
echo identar(2)."<input type='hidden' name='intervalo' value='" . ($intervalo? $intervalo : '') . "'>"
   . identar(2)."<input type='hidden' name='menu_id'   value='" . ($menu_id?   $menu_id   : '') . "'>"
   . identar(2)."<input type='hidden' name='opcao_id'  value='" . ($opcao_id?  $opcao_id  : '') . "'>"
   . identar(2)."<input type='hidden' name='operacao'  value='" . ($operacao?  $operacao  : '') . "'>"
   . identar(2)."<input type='hidden' name='status'    value='" . ($status?    $status    : '') . "'>"
   . identar(2)."<input type='hidden' name='base'      value='" . ($base?      $base      : '') . "'>"
   . identar(2)."<input type='hidden' name='usuario'   value='" . ($usuario?   $usuario   : '') . "'>"
   . identar(2)."<input type='hidden' name='objeto'    value='" . ($objeto?    $objeto    : '') . "'>"
   . identar(1).'</form>'
   . identar(1).'</font>'
   . identar(0).'</body>'
   . identar(0).'</html>'
;
$db->close();
?>
