/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Field {
    public static final int TEXT_FORMAT = 0;
    public static final int BINARY_FORMAT = 1;
    private final int length;
    private final int oid;
    private final int mod;
    private final String columnLabel;
    private String columnName;
    private Integer nullable;
    private Boolean autoIncrement;
    private int format = 0;
    private final int tableOid;
    private final int positionInTable;

    public Field(String name, int oid, int length, int mod) {
        this(name, name, oid, length, mod, 0, 0);
    }

    public Field(String name, int oid) {
        this(name, oid, 0, -1);
    }

    public Field(String columnLabel, String columnName, int oid, int length, int mod, int tableOid, int positionInTable) {
        this.columnLabel = columnLabel;
        this.columnName = columnName;
        this.oid = oid;
        this.length = length;
        this.mod = mod;
        this.tableOid = tableOid;
        this.positionInTable = positionInTable;
    }

    public int getOID() {
        return this.oid;
    }

    public int getMod() {
        return this.mod;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public int getLength() {
        return this.length;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public int getTableOid() {
        return this.tableOid;
    }

    public int getPositionInTable() {
        return this.positionInTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNullable(Connection con) throws SQLException {
        if (this.nullable != null) {
            return this.nullable;
        }
        if (this.tableOid == 0 || this.positionInTable == 0) {
            this.nullable = new Integer(2);
            return this.nullable;
        }
        ResultSet res = null;
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("SELECT attnotnull FROM pg_catalog.pg_attribute WHERE attrelid = ? AND attnum = ?;");
            ps.setInt(1, this.tableOid);
            ps.setInt(2, this.positionInTable);
            res = ps.executeQuery();
            int nullResult = 2;
            if (res.next()) {
                nullResult = res.getBoolean(1) ? 0 : 1;
            }
            this.nullable = new Integer(nullResult);
            int n = nullResult;
            return n;
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoIncrement(Connection con) throws SQLException {
        if (this.autoIncrement != null) {
            return this.autoIncrement;
        }
        if (this.tableOid == 0 || this.positionInTable == 0) {
            this.autoIncrement = Boolean.FALSE;
            return this.autoIncrement;
        }
        ResultSet res = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT def.adsrc FROM pg_catalog.pg_class c JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid) LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum) WHERE c.oid = ? and a.attnum = ? AND def.adsrc LIKE '%nextval(%'";
            ps = con.prepareStatement("SELECT def.adsrc FROM pg_catalog.pg_class c JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid) LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum) WHERE c.oid = ? and a.attnum = ? AND def.adsrc LIKE '%nextval(%'");
            ps.setInt(1, this.tableOid);
            ps.setInt(2, this.positionInTable);
            res = ps.executeQuery();
            this.autoIncrement = res.next() ? Boolean.TRUE : Boolean.FALSE;
            boolean bl = this.autoIncrement;
            return bl;
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(Connection con) throws SQLException {
        if (this.columnName != null) {
            return this.columnName;
        }
        this.columnName = "";
        if (this.tableOid == 0 || this.positionInTable == 0) {
            return this.columnName;
        }
        ResultSet res = null;
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("SELECT attname FROM pg_catalog.pg_attribute WHERE attrelid = ? AND attnum = ?");
            ps.setInt(1, this.tableOid);
            ps.setInt(2, this.positionInTable);
            res = ps.executeQuery();
            if (res.next()) {
                this.columnName = res.getString(1);
            }
            String string = this.columnName;
            return string;
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }
}

