/* 
 * PHP3 Internationalization support program.
 *
 * Copyright (c) 1999 by the PHP3 internationalization team.
 * All rights reserved.
 *
 * This program is free software. You can use, redistribute and/or modify
 * without fee under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY including implied or express warranty of
 * marchantability or fitness for a particular purpose.
 *
 * Currently, the "PHP3 internationalization team" has no relationship with
 * the "PHP Development Team". But we hope these code will be integrated
 * into the PHP3, and it will be distributed as a part of PHP3.
 *
 * See README_i18n for more detail.
 *
 * Authors:
 *    Hironori Sato <satoh@jpnnet.com>
 *    Shigeru Kanemoto <sgk@happysize.co.jp>
 */

/*
    FIXME Currently, this code supports only "ja_JP" locale.
    Some more abstraction is needed.
*/

#include "php.h"
#include "tls.h"
#include "internal_functions.h"
#include <stdio.h>	/* FILE */

#ifdef	PHP3_I18N

#include "php3_i18n.h"
#include "i18n_ja_jp_filter.h"

#ifdef HAVE_MBREGEX
#include "mbregex.h"
#endif

#ifdef THREAD_SAFE
# error "i18n.c is not thread safe yet."
#else
/* global */
int i18n_http_output = mbfl_no_encoding_pass;
int i18n_internal_encoding = mbfl_no_encoding_utf8;
int i18n_script_encoding = mbfl_no_encoding_auto;
int i18n_http_input = mbfl_no_encoding_pass;
int i18n_http_input_default = mbfl_no_encoding_pass;
/* internal use, which also should be in tls.h when threaded. */
static int i18n_current_http_output = mbfl_no_encoding_pass;	/* http output code the filter does */
static struct mbfl_output_filter* i18n_http_output_filter = NULL;
static struct mbfl_output_filter* i18n_http_post_filter = NULL;
int i18n_http_input_identify = mbfl_no_encoding_pass;
#endif	/* THREAD_SAFE */


/*
 * initialize
 */
void
i18n_init(void)
{
	mbfl_encoding_ptr penc;
	TLS_VARS;

	/*
	 * FIXME: multi languege suport
	 */

	/* http output should be one of pass|EUC|JIS|SJIS|UTF-8 [pass] */
	penc = mbfl_name2encoding(php3_ini.i18n_http_output_string);
	if (penc != NULL) {
		GLOBAL(i18n_http_output) = penc->no_encoding;
	} else {
		GLOBAL(i18n_http_output) = mbfl_no_encoding_pass;
	}

	/* internal encoding should be EUC, SJIS or UTF-8 [EUC] */
	penc = mbfl_name2encoding(php3_ini.i18n_internal_encoding_string);
	if (penc != NULL && penc->no_encoding != mbfl_no_encoding_auto) {
		GLOBAL(i18n_internal_encoding) = penc->no_encoding;
	} else {
		GLOBAL(i18n_internal_encoding) = mbfl_no_encoding_ja_jp_euc;
	}

	/* script encoding should be one of auto|pass|EUC|JIS|SJIS|UTF-8 [auto] */
	penc = mbfl_name2encoding(php3_ini.i18n_script_encoding_string);
	if (penc != NULL) {
		GLOBAL(i18n_script_encoding) = penc->no_encoding;
	} else {
		GLOBAL(i18n_script_encoding) = mbfl_no_encoding_auto;
	}

	/* http input should be pass or auto */
	penc = mbfl_name2encoding(php3_ini.i18n_http_input_string);
	if (penc != NULL) {
		GLOBAL(i18n_http_input) = penc->no_encoding;
	} else {
		GLOBAL(i18n_http_input) = mbfl_no_encoding_auto;
	}
	penc = mbfl_name2encoding(php3_ini.i18n_http_input_default_string);
	if (penc != NULL && penc->no_encoding != mbfl_no_encoding_auto) {
		GLOBAL(i18n_http_input_default) = penc->no_encoding;
	} else {
		GLOBAL(i18n_http_input_default) = mbfl_no_encoding_pass;
	}

	/* output filter for http */
	GLOBAL(i18n_current_http_output) = GLOBAL(i18n_http_output);
	GLOBAL(i18n_http_output_filter) = mbfl_output_filter_new(
	  GLOBAL(i18n_internal_encoding),
	  GLOBAL(i18n_current_http_output),
#if	APACHE
	  (int (*)(int, void*))rputc,
	  (int (*)(void*))rflush,
	  (void*)GLOBAL(php3_rqst)
#else
	  (int (*)(int, void*))fputc,
	  (int (*)(void*))fflush,
	  (void*)stdout
#endif	/* APACHE */
	);

	/* output filter for use to handle post/get/cookie data */
	GLOBAL(i18n_http_input_identify) = GLOBAL(i18n_http_input);
	GLOBAL(i18n_http_post_filter) = mbfl_output_to_memory_new(
	  GLOBAL(i18n_http_input),
	  GLOBAL(i18n_internal_encoding));
	if (GLOBAL(i18n_http_input) == mbfl_no_encoding_auto) {
		mbfl_output_filter_unknown_default(
		  GLOBAL(i18n_http_post_filter),
		  GLOBAL(i18n_http_input_default));
	}

#ifdef HAVE_MBREGEX
	/* MultiByte regex initialize */
	if (GLOBAL(i18n_internal_encoding) == mbfl_no_encoding_ja_jp_euc){
		mbre_mbcinit(MBCTYPE_EUC);
	} else if(GLOBAL(i18n_internal_encoding) == mbfl_no_encoding_ja_jp_sjis) {
		mbre_mbcinit(MBCTYPE_SJIS);
	} else if(GLOBAL(i18n_internal_encoding) == mbfl_no_encoding_utf8) {
		mbre_mbcinit(MBCTYPE_UTF8);
	} else {
		mbre_mbcinit(MBCTYPE_ASCII);
	}
#endif
}

/*
 * cleanup
 */
void
i18n_cleanup(void)
{
	TLS_VARS;

	/* flush and delete filters */
	if (GLOBAL(i18n_http_output_filter)) {
		mbfl_output_filter_delete(GLOBAL(i18n_http_output_filter));
		GLOBAL(i18n_http_output_filter) = NULL;
	}
	if (GLOBAL(i18n_http_post_filter)) {
		mbfl_output_to_memory_delete(GLOBAL(i18n_http_post_filter));
		GLOBAL(i18n_http_post_filter) = NULL;
	}
}

/*
 * HTTP output
 */
/* returns a negative value on error */
int
i18n_http_putc(int c)
{
	TLS_VARS;

	if (GLOBAL(i18n_http_output_filter)) {
		/* check if i18n_http_output is changed by php3 function. */
		if (GLOBAL(i18n_current_http_output) != GLOBAL(i18n_http_output)) {
			GLOBAL(i18n_current_http_output) = GLOBAL(i18n_http_output);
			mbfl_output_filter_reset(GLOBAL(i18n_http_output_filter),
			    GLOBAL(i18n_internal_encoding),
			    GLOBAL(i18n_current_http_output));
		}
		return mbfl_output_filter_feed(GLOBAL(i18n_http_output_filter), c);
	} else {
#if	APACHE
		return (rputc(c, GLOBAL(php3_rqst)) == c ? c : -1);
#else
		return (fputc(c, stdout) == c ? c : -1);
#endif	/* APACHE */
	}
}

int
i18n_set_output_encoding(const char *name)
{
	mbfl_encoding_ptr penc;
	TLS_VARS;

	penc = mbfl_name2encoding(name);
	if(penc != NULL && penc->no_encoding != mbfl_no_encoding_auto) {
		return GLOBAL(i18n_http_output) = penc->no_encoding;
	} else {
		return -1;
	}
}

int
i18n_get_output_encoding(void)
{
	TLS_VARS;

	return GLOBAL(i18n_http_output);
}

/* charset string for current HTTP output encoding. */
const char*
i18n_get_output_charset(void)
{
	mbfl_encoding_ptr penc;
	TLS_VARS;

	penc = mbfl_no2encoding(GLOBAL(i18n_http_output));
	if (penc != NULL) {
		return penc->mime_name;
	}

	return NULL;
}

/*
 * script input
 */
void*
i18n_script_input_new(FILE* in)
{
	/* input filter for script */
	return (void*)mbfl_input_filter_new(
		GLOBAL(i18n_script_encoding),
		GLOBAL(i18n_internal_encoding),
		(int (*)(void*))fgetc,
		(void*)in);
}

void
i18n_script_input_delete(void* filter)
{
	mbfl_input_filter_delete((struct mbfl_input_filter*)filter);
}

int
i18n_script_input_getc(void* filter)
{
	return mbfl_input_filter_retrieve((struct mbfl_input_filter*)filter);
}

int
i18n_get_script_encoding(void)
{
	TLS_VARS;

	return GLOBAL(i18n_script_encoding);
}


/*
 * HTTP input (POST/GET/COOKIE)
 */
int
i18n_http_post_putc(int c)
{
	return mbfl_output_filter_feed(GLOBAL(i18n_http_post_filter), c);
}

int
i18n_http_post_puts(const char* s)
{
	int n = 0;
	TLS_VARS;

	while (*s) {
		if (mbfl_output_filter_feed(
				GLOBAL(i18n_http_post_filter), *s++ & 0xff) < 0) {
			return n;
		}
		n++;
    }
    return n;
}

/* returns a newly malloc'ed momory. */
char*
i18n_http_post_result(void)
{
	char *result;
	TLS_VARS;

	result = mbfl_output_to_memory_result(GLOBAL(i18n_http_post_filter));
	GLOBAL(i18n_http_input_identify) = mbfl_output_filter_encoding(GLOBAL(i18n_http_post_filter));

	mbfl_output_filter_reset(
	  GLOBAL(i18n_http_post_filter),
	  GLOBAL(i18n_http_input),
	  GLOBAL(i18n_internal_encoding));

	if (GLOBAL(i18n_http_input) == mbfl_no_encoding_auto) {
		mbfl_output_filter_unknown_default(
		  GLOBAL(i18n_http_post_filter),
		  GLOBAL(i18n_http_input_default));
	}

	return result;
}

int
i18n_http_input_encoding(void)
{
	TLS_VARS;

	return GLOBAL(i18n_http_input);
}

int
i18n_http_input_identify_encoding(void)
{
	TLS_VARS;

	return GLOBAL(i18n_http_input_identify);
}

int
i18n_get_internal_encoding(void)
{
	TLS_VARS;

	return GLOBAL(i18n_internal_encoding);
}


/*
 * send an email message using "sendmail"
 */
void
i18n_sendmail(
    FILE *sendmail,
    const char *to,
    const char *subject,
    const char *message,
    const char *headers)
{
	char *enc_text = NULL;
	int code;
	TLS_VARS;

	/*
	 * FIXME strings in headers should also be encoded
	 *     To: <sgk@happysize.co.jp> =?iso-2022-jp?B?GyRCNmJLXCEhTFAbKEo=?=
	 */

	/* addressing will be as is */
	fprintf(sendmail, "To: %s\n", to);

	/* no header modification, just too damn messy */
	if (headers != NULL) {
		fputs(headers, sendmail);
		if (headers[strlen(headers) - 1] != '\n')
			fputc('\n', sendmail);
	}

	fprintf(sendmail, "Mime-Version: 1.0\n");

	/* subject */
	code = mbfl_identify_encoding(subject);
	if(code == mbfl_no_encoding_pass) {
		code = GLOBAL(i18n_internal_encoding);
	}
	enc_text = mbfl_mime_header_encode(
		code,
		mbfl_no_encoding_ja_jp_jis,
		mbfl_no_encoding_base64,
		subject,
		"\n");
	fprintf(sendmail, "Subject: %s\n", enc_text);
	efree(enc_text);

	/* body */
	code = mbfl_identify_encoding(message);
	if(code == mbfl_no_encoding_pass) {
		code = GLOBAL(i18n_internal_encoding);
	}
	if(code == mbfl_no_encoding_en_us_ascii) {
		fprintf(sendmail, "Content-Type: text/plain; charset=US-ASCII\nContent-Transfer-Encoding: 7bit\n\n");
		fputs(message, sendmail);
	} else {
		fprintf(sendmail, "Content-Type: text/plain; charset=iso-2022-jp\nContent-Transfer-Encoding: 7bit\n\n");
		/* simple jis conversion */
		enc_text = mbfl_encoding_convert(
			code,
			mbfl_no_encoding_ja_jp_jis,
			message);
		fputs(enc_text, sendmail);
		efree(enc_text);
	}

	fputc('\n', sendmail);
	fflush(sendmail);

} /* end of i18n_sendmail */

#endif	/* PHP3_I18N */
/* vi:set sw=4 ts=4: */
