#! /usr/local/bin/php -q
<?php

$table_name = "noname";
$db_class = "DB_Noname";
$db = "test";

if ($argc != 1 && $argc != 4) {
  print("Usage: $argv[0] [table_name db_class database]\n");
  exit;
}

if (isset($argv) && is_array($argv) && isset($argv[1])) {
  $table_name = $argv[1];
}
if (isset($argv) && is_array($argv) && isset($argv[2])) {
  $db_class = $argv[2];
}
if (isset($argv) && is_array($argv) && isset($argv[3])) {
  $db = $argv[3];
}

//$table_name = "auth_user_md5";
//$db_class = "DB_Pgimage";
//$db = "pgimage";

pg_connect("","5432","",$db);

$sql = "SELECT a.attnum, a.attname, t.typname, a.attlen, a.atttypmod,
      a.attnotnull, a.atthasdef, c.oid
      FROM pg_class c, pg_attribute a, pg_type t
      WHERE c.relname = '$table_name' 
      AND a.attnum > 0 AND a.attrelid = c.oid AND a.atttypid = t.oid
      ORDER BY a.attnum";

$result = pg_exec($sql);
$oid = pg_result($result,0,"oid");
$num_attrs = pg_numrows($result);
for ($i=0;$i<$num_attrs;$i++) {
  $md[$i][name] = pg_result($result,$i,"attname");
  $md[$i][typename] = pg_result($result,$i,"typname");
  $md[$i][len] = pg_result($result,$i,"attlen");
  $md[$i][modifier] = pg_result($result,$i,"atttypmod");
  $md[$i][notnull] = pg_result($result,$i,"attnotnull");
  $md[$i][defaultval] = pg_result($result,$i,"atthasdef");
}
pg_freeresult($result);

$sql = "SELECT a.attname FROM pg_index i, pg_class c, pg_attribute a WHERE i.indisprimary AND i.indrelid = $oid  AND i.indexrelid = c.oid AND a.attnum > 0 AND a.attrelid = c.oid ORDER BY a.attnum";
$result = pg_exec($sql);
$rows = pg_numrows($result);

for ($i=0;$i<$rows;$i++) {
  $pkeys[$i] = pg_result($result,$i,"attname");
}
pg_freeresult($result);

pg_close();

print("<?php\n");
print("/*\n");
print(" * This file was automatically generated by gen_class.php3.\n");
print(" * Please do not edit by hand.\n");
printf(" * Generated on %s. generated by %s.\n", date("Y/m/d H:i:s"),getenv("USER"));
print(" */\n\n");
//------------------------------------------------------
print("class $table_name {\n");
print("  var \$table_name = \"$table_name\";	// ơ֥̾\n");
print("  var \$num_attrs = \"$num_attrs\";	// \n");
print("  var \$col_info;	// [0-n][name]or[typename]\n");
print("  var \$col_vars;	// (̾б)\n");
print("  var \$nulls;		// NULLե饰(̾б)\n");
print("  var \$db;		// DB֥\n");
print("\n");

//------------------------------------------------------
print("  // 󥹥ȥ饯\n"); 
print("  function $table_name () {\n");
for ($i=0;$i<$num_attrs;$i++) {
  printf("    \$this->col_info[$i][\"name\"] = \"%s\";\n",$md[$i]["name"]);
  printf("    \$this->col_info[$i][\"typename\"] = \"%s\";\n",$md[$i]["typename"]);
}
print("    \$this->db = new $db_class;\n");
print("  }\n\n");

//------------------------------------------------------
print("  // ߤΥ쥳ɤ饤󥹥ѿ\n");
print("  function get_one_record (\$db) {\n");
print("    if (\$this->db->next_record() == false) return;\n");
print("    for (\$i=0;\$i<\$this->num_attrs;\$i++) {\n");
print("      \$name = \$this->col_info[\$i][\"name\"];\n");
print("      \$this->col_vars[\"\$name\"] = \$this->db->f(\$name);\n");
print("      \$this->nulls[\"\$name\"] = pg_fieldisnull(\$this->db->Query_ID, \$n, \$i);\n");
print("    }\n");
print("  }\n");

//------------------------------------------------------
print("\n  // 祭饤󥹥ѿ\n");
print("  function create_obj (");
for ($i=0;$i<count($pkeys);$i++) {
  print("\$$pkeys[$i]");
  if ($i != (count($pkeys)-1)) print(",");
}
print(") {\n");
print("    \$this->db->query(sprintf(\"SELECT * FROM \$this->table_name ");
print("WHERE ");
for ($i=0;$i<count($pkeys);$i++) {
  print("$pkeys[$i] = '%s'");
  if ($i != (count($pkeys)-1)) print(" AND ");
}
print("\",\n    ");
for ($i=0;$i<count($pkeys);$i++) {
  print("addslashes(\$$pkeys[$i])");
  if ($i != (count($pkeys)-1)) print(", ");
}
print("));\n");
print("    \$this->get_one_record(\$this->db);\n");
print("  }\n");

//------------------------------------------------------
print("\n  // 쥳ɤINSERT⤷UPDATE\n");
print("  function insert_or_update () {\n");
print("    \$sql = \"SELECT * FROM \$this->table_name \";\n");
print("    \$where = \" WHERE \";\n");
for ($i=0;$i<count($pkeys);$i++) {
  print("    \$val = addslashes(\$this->get(\"$pkeys[$i]\"));\n");
  print("    \$where .= \"$pkeys[$i] = '\$val'\";\n");
  if ($i != (count($pkeys)-1)) print("    \$where .= \" AND \";\n");
}
print("    \$sql .= \$where;\n");
print("    \$this->db->query(\$sql);\n");
print("    if (\$this->db->num_rows() == 0) {\n");
print("      \$sql = \"INSERT INTO \$this->table_name VALUES (\";\n");
print("      for (\$i=0;\$i<\$this->num_attrs;\$i++) {\n");
print("        \$name = \$this->col_info[\$i][\"name\"];\n");
print("        if (\$this->nulls[\"\$name\"]) \$sql .= \"NULL\";\n");
print("        else \$sql .= \"'\" . addslashes(\$this->col_vars[\$name]) . \"'\";\n");
print("        if (\$i != (\$this->num_attrs -1)) {\n");
print("          \$sql .= \",\";\n");
print("        }\n");
print("      }\n");
print("      \$sql .= \")\";\n");
print("    } else {\n");
print("      \$sql = \"UPDATE \$this->table_name SET \";\n");
print("      for (\$i=0;\$i<\$this->num_attrs;\$i++) {\n");
print("        \$name = \$this->col_info[\$i][\"name\"];\n");
print("        \$sql .= \"\$name = \";\n");
print("        if (\$this->nulls[\"\$name\"]) \$sql .= \"NULL\";\n");
print("        else \$sql .= \"'\" . addslashes(\$this->col_vars[\"\$name\"]) . \"'\";\n");
print("        if (\$i != (\$this->num_attrs -1)) {\n");
print("          \$sql .= \",\";\n");
print("        }\n");
print("      }\n");
print("      \$sql .= \$where;\n");
print("    }\n");
print("    \$this->db->query(\$sql);\n");
print("    return(\$this->db->affected_rows());\n");
print("  }\n");

//------------------------------------------------------
print("\n  // 쥳ɤINSERT\n");
print("  function insert () {\n");
print("    \$this->db->query(\"BEGIN\");\n");
print("    \$this->db->query(\"LOCK TABLE \$this->table_name IN SHARE ROW EXCLUSIVE MODE\");\n");
print("    \$sql = \"SELECT * FROM \$this->table_name \";\n");
print("    \$where = \" WHERE \";\n");
for ($i=0;$i<count($pkeys);$i++) {
  print("    \$val = addslashes(\$this->get(\"$pkeys[$i]\"));\n");
  print("    \$where .= \"$pkeys[$i] = '\$val'\";\n");
  if ($i != (count($pkeys)-1)) print("    \$where .= \" AND \";\n");
}
print("    \$sql .= \$where;\n");
print("    \$this->db->query(\$sql);\n");
print("    if (\$this->db->num_rows() > 0) {\n");
print("      print(\"$table_name: ǤƱΥ쥳ɤ¸ߤޤ<br>\");\n");
print("      \$this->db->query(\"COMMIT\");\n");
print("      return(0);\n");
print("    } else {\n");
print("      \$sql = \"INSERT INTO \$this->table_name VALUES (\";\n");
print("      for (\$i=0;\$i<\$this->num_attrs;\$i++) {\n");
print("        \$name = \$this->col_info[\$i][\"name\"];\n");
print("        if (\$this->nulls[\"\$name\"]) \$sql .= \"NULL\";\n");
print("        else \$sql .= \"'\" . addslashes(\$this->col_vars[\$name]) . \"'\";\n");
print("        if (\$i != (\$this->num_attrs -1)) {\n");
print("          \$sql .= \",\";\n");
print("        }\n");
print("      }\n");
print("      \$sql .= \")\";\n");
print("      \$this->db->query(\$sql);\n");
print("      \$rtn = \$this->db->affected_rows();\n");
print("      \$this->db->query(\"COMMIT\");\n");
print("      return(\$rtn);\n");
print("    }\n");
print("  }\n");

//------------------------------------------------------
print("\n  // 쥳ɤUPDATE\n");
print("  function update (");
for ($i=0;$i<count($pkeys);$i++) {
  print("\$$pkeys[$i]");
  if ($i != (count($pkeys)-1)) print(",");
}
print(") {\n");

print("    \$where = \" WHERE \";\n");
for ($i=0;$i<count($pkeys);$i++) {
  print("    \$val = addslashes(\"\$$pkeys[$i]\");\n");
  print("    \$where .= \"$pkeys[$i] = '\$val'\";\n");
  //print("    \$where .= \"$pkeys[$i] = '\$$pkeys[$i]'\";\n");
  if ($i != (count($pkeys)-1)) print("    \$where .= \" AND \";\n");
}
print("    \$sql = \"UPDATE \$this->table_name SET \";\n");
print("    for (\$i=0;\$i<\$this->num_attrs;\$i++) {\n");
print("      \$name = \$this->col_info[\$i][\"name\"];\n");
print("      \$sql .= \"\$name = \";\n");
print("      if (\$this->nulls[\"\$name\"]) \$sql .= \"NULL\";\n");
print("      else \$sql .= \"'\" . addslashes(\$this->col_vars[\"\$name\"]) . \"'\";\n");
print("      if (\$i != (\$this->num_attrs -1)) {\n");
print("        \$sql .= \",\";\n");
print("      }\n");
print("    }\n");
print("    \$sql .= \$where;\n");
print("    \$this->db->query(\$sql);\n");
print("    return(\$this->db->affected_rows());\n");
print("  }\n");

//------------------------------------------------------
print("\n  // ֤ͤ\n");
print("  function get (\$col) {\n");
print("    return(\$this->col_vars[\$col]);\n");
print("  }\n");

//------------------------------------------------------
print("\n  // ͤ򥻥åȤ\n");
print("  function put (\$col, \$val) {\n");
print("    \$this->col_vars[\$col] = \$val;\n");
print("  }\n");

//------------------------------------------------------
print("\n  // NULLɤ֤\n");
print("  function is_null (\$col) {\n");
print("    if (\$this->nulls[\$col] == true) {\n");
print("      return(true);\n");
print("    } else {\n");
print("      return(false);\n");
print("    }\n");
print("  }\n");

//------------------------------------------------------
print("\n  // NULL򥻥åȤ\n");
print("  function set_null (\$col) {\n");
print("    \$this->nulls[\$col] = true;\n");
print("  }\n");

//------------------------------------------------------
print("\n  // NULLꥻåȤ\n");
print("  function reset_null (\$col) {\n");
print("    \$this->nulls[\$col] = false;\n");
print("  }\n");

//------------------------------------------------------
print("\n  // DB֥Ȥ֤\n");
print("  function connect () {\n");
print("    return(\$this->db);\n");
print("  }\n");

//------------------------------------------------------
print("\n  // DB³\n");
print("  function connect () {\n");
print("    return(\$this->db->connect());\n");
print("  }\n");

//------------------------------------------------------
print("\n  // Link_ID֤\n");
print("  function link_id () {\n");
print("    \$this->db->connect();\n");
print("    return(\$this->db->Link_ID);\n");
print("  }\n");


print("}\n");

//------------------------------------------------------
print("?>\n");
?>
