.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER OPERATOR FAMILY" "" "2007-10-05" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER OPERATOR FAMILY \- change the definition of an operator family

.SH SYNOPSIS
.sp
.nf
ALTER OPERATOR FAMILY \fIname\fR USING \fIindex_method\fR ADD
  {  OPERATOR \fIstrategy_number\fR \fIoperator_name\fR ( \fIop_type\fR, \fIop_type\fR ) [ RECHECK ]
   | FUNCTION \fIsupport_number\fR [ ( \fIop_type\fR [ , \fIop_type\fR ] ) ] \fIfuncname\fR ( \fIargument_type\fR [, ...] )
  } [, ... ]
ALTER OPERATOR FAMILY \fIname\fR USING \fIindex_method\fR DROP
  {  OPERATOR \fIstrategy_number\fR ( \fIop_type\fR [ , \fIop_type\fR ] )
   | FUNCTION \fIsupport_number\fR ( \fIop_type\fR [ , \fIop_type\fR ] )
  } [, ... ]
ALTER OPERATOR FAMILY \fIname\fR USING \fIindex_method\fR RENAME TO \fInewname\fR
ALTER OPERATOR FAMILY \fIname\fR USING \fIindex_method\fR OWNER TO \fInewowner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER OPERATOR FAMILY\fR changes the definition of
an operator family. You can add operators and support functions
to the family, remove them from the family,
or change the family's name or owner.
.PP
When operators and support functions are added to a family with
\fBALTER OPERATOR FAMILY\fR, they are not part of any
specific operator class within the family, but are just ``loose''
within the family. This indicates that these operators and functions
are compatible with the family's semantics, but are not required for
correct functioning of any specific index. (Operators and functions
that are so required should be declared as part of an operator class,
instead; see CREATE OPERATOR CLASS [\fBcreate_operator_class\fR(l)].)
PostgreSQL will allow loose members of a
family to be dropped from the family at any time, but members of an
operator class cannot be dropped without dropping the whole class and
any indexes that depend on it.
Typically, single-data-type operators
and functions are part of operator classes because they are needed to
support an index on that specific data type, while cross-data-type
operators and functions are made loose members of the family.
.PP
You must be a superuser to use \fBALTER OPERATOR FAMILY\fR.
(This restriction is made because an erroneous operator family definition
could confuse or even crash the server.)
.PP
\fBALTER OPERATOR FAMILY\fR does not presently check
whether the operator family definition includes all the operators and
functions required by the index method, nor whether the operators and
functions form a self-consistent set. It is the user's
responsibility to define a valid operator family.
.PP
Refer to in the documentation for further information.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing operator
family.
.TP
\fB\fIindex_method\fB\fR
The name of the index method this operator family is for.
.TP
\fB\fIstrategy_number\fB\fR
The index method's strategy number for an operator
associated with the operator family.
.TP
\fB\fIoperator_name\fB\fR
The name (optionally schema-qualified) of an operator associated
with the operator family.
.TP
\fB\fIop_type\fB\fR
In an OPERATOR clause,
the operand data type(s) of the operator, or NONE to
signify a left-unary or right-unary operator. Unlike the comparable
syntax in \fBCREATE OPERATOR CLASS\fR, the operand data types
must always be specified.

In an ADD FUNCTION clause, the operand data type(s) the
function is intended to support, if different from
the input data type(s) of the function. For B-tree and hash indexes
it is not necessary to specify \fIop_type\fR since the function's input
data type(s) are always the correct ones to use. For GIN and GiST
indexes it is necessary to specify the input data type the function
is to be used with.

In a DROP FUNCTION clause, the operand data type(s) the
function is intended to support must be specified.
.TP
\fBRECHECK\fR
If present, the index is ``lossy'' for this operator, and
so the rows retrieved using the index must be rechecked to
verify that they actually satisfy the qualification clause
involving this operator.
.TP
\fB\fIsupport_number\fB\fR
The index method's support procedure number for a
function associated with the operator family.
.TP
\fB\fIfuncname\fB\fR
The name (optionally schema-qualified) of a function that is an
index method support procedure for the operator family.
.TP
\fB\fIargument_types\fB\fR
The parameter data type(s) of the function.
.TP
\fB\fInewname\fB\fR
The new name of the operator family.
.TP
\fB\fInewowner\fB\fR
The new owner of the operator family.
.PP
The OPERATOR and FUNCTION
clauses can appear in any order.
.PP
.SH "NOTES"
.PP
Notice that the DROP syntax only specifies the ``slot''
in the operator family, by strategy or support number and input data
type(s). The name of the operator or function occupying the slot is not
mentioned. Also, for DROP FUNCTION the type(s) to specify
are the input data type(s) the function is intended to support; for
GIN and GiST indexes this might have nothing to do with the actual input
argument types of the function.
.PP
Because the index machinery does not check access permissions on functions
before using them, including a function or operator in an operator family
is tantamount to granting public execute permission on it. This is usually
not an issue for the sorts of functions that are useful in an operator
family.
.PP
The operators should not be defined by SQL functions. A SQL function
is likely to be inlined into the calling query, which will prevent
the optimizer from recognizing that the query matches an index.
.SH "EXAMPLES"
.PP
The following example command adds cross-data-type operators and
support functions to an operator family that already contains B-tree
operator classes for data types \fBint4\fR and \fBint2\fR.
.sp
.nf
ALTER OPERATOR FAMILY integer_ops USING btree ADD

  -- int4 vs int2
  OPERATOR 1 < (int4, int2) ,
  OPERATOR 2 <= (int4, int2) ,
  OPERATOR 3 = (int4, int2) ,
  OPERATOR 4 >= (int4, int2) ,
  OPERATOR 5 > (int4, int2) ,
  FUNCTION 1 btint42cmp(int4, int2) ,

  -- int2 vs int4
  OPERATOR 1 < (int2, int4) ,
  OPERATOR 2 <= (int2, int4) ,
  OPERATOR 3 = (int2, int4) ,
  OPERATOR 4 >= (int2, int4) ,
  OPERATOR 5 > (int2, int4) ,
  FUNCTION 1 btint24cmp(int2, int4) ;
.sp
.fi
.PP
To remove these entries again:
.sp
.nf
ALTER OPERATOR FAMILY integer_ops USING btree DROP

  -- int4 vs int2
  OPERATOR 1 (int4, int2) ,
  OPERATOR 2 (int4, int2) ,
  OPERATOR 3 (int4, int2) ,
  OPERATOR 4 (int4, int2) ,
  OPERATOR 5 (int4, int2) ,
  FUNCTION 1 (int4, int2) ,

  -- int2 vs int4
  OPERATOR 1 (int2, int4) ,
  OPERATOR 2 (int2, int4) ,
  OPERATOR 3 (int2, int4) ,
  OPERATOR 4 (int2, int4) ,
  OPERATOR 5 (int2, int4) ,
  FUNCTION 1 (int2, int4) ;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER OPERATOR FAMILY\fR statement in
the SQL standard.
.SH "SEE ALSO"
CREATE OPERATOR FAMILY [\fBcreate_operator_family\fR(l)], DROP OPERATOR FAMILY [\fBdrop_operator_family\fR(l)], CREATE OPERATOR CLASS [\fBcreate_operator_class\fR(l)], ALTER OPERATOR CLASS [\fBalter_operator_class\fR(l)], DROP OPERATOR CLASS [\fBdrop_operator_class\fR(l)]
