/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_REFERENCE = 290,
     SQL_RETURNED_LENGTH = 291,
     SQL_RETURNED_OCTET_LENGTH = 292,
     SQL_SCALE = 293,
     SQL_SECTION = 294,
     SQL_SHORT = 295,
     SQL_SIGNED = 296,
     SQL_SQL = 297,
     SQL_SQLERROR = 298,
     SQL_SQLPRINT = 299,
     SQL_SQLWARNING = 300,
     SQL_START = 301,
     SQL_STOP = 302,
     SQL_STRUCT = 303,
     SQL_UNSIGNED = 304,
     SQL_VALUE = 305,
     SQL_VAR = 306,
     SQL_WHENEVER = 307,
     S_ADD = 308,
     S_AND = 309,
     S_ANYTHING = 310,
     S_AUTO = 311,
     S_CONST = 312,
     S_DEC = 313,
     S_DIV = 314,
     S_DOTPOINT = 315,
     S_EQUAL = 316,
     S_EXTERN = 317,
     S_INC = 318,
     S_LSHIFT = 319,
     S_MEMPOINT = 320,
     S_MEMBER = 321,
     S_MOD = 322,
     S_MUL = 323,
     S_NEQUAL = 324,
     S_OR = 325,
     S_REGISTER = 326,
     S_RSHIFT = 327,
     S_STATIC = 328,
     S_SUB = 329,
     S_VOLATILE = 330,
     S_TYPEDEF = 331,
     TYPECAST = 332,
     ABORT_P = 333,
     ABSOLUTE_P = 334,
     ACCESS = 335,
     ACTION = 336,
     ADD = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     AT = 352,
     AUTHORIZATION = 353,
     BACKWARD = 354,
     BEFORE = 355,
     BEGIN_P = 356,
     BETWEEN = 357,
     BIGINT = 358,
     BINARY = 359,
     BIT = 360,
     BOOLEAN_P = 361,
     BOTH = 362,
     BY = 363,
     CACHE = 364,
     CALLED = 365,
     CASCADE = 366,
     CASE = 367,
     CAST = 368,
     CHAIN = 369,
     CHAR_P = 370,
     CHARACTER = 371,
     CHARACTERISTICS = 372,
     CHECK = 373,
     CHECKPOINT = 374,
     CLASS = 375,
     CLOSE = 376,
     CLUSTER = 377,
     COALESCE = 378,
     COLLATE = 379,
     COLUMN = 380,
     COMMENT = 381,
     COMMIT = 382,
     COMMITTED = 383,
     CONSTRAINT = 384,
     CONSTRAINTS = 385,
     CONVERSION_P = 386,
     CONVERT = 387,
     COPY = 388,
     CREATE = 389,
     CREATEDB = 390,
     CREATEUSER = 391,
     CROSS = 392,
     CSV = 393,
     CURRENT_DATE = 394,
     CURRENT_TIME = 395,
     CURRENT_TIMESTAMP = 396,
     CURRENT_USER = 397,
     CURSOR = 398,
     CYCLE = 399,
     DATABASE = 400,
     DAY_P = 401,
     DEALLOCATE = 402,
     DEC = 403,
     DECIMAL_P = 404,
     DECLARE = 405,
     DEFAULT = 406,
     DEFAULTS = 407,
     DEFERRABLE = 408,
     DEFERRED = 409,
     DEFINER = 410,
     DELETE_P = 411,
     DELIMITER = 412,
     DELIMITERS = 413,
     DESC = 414,
     DISTINCT = 415,
     DO = 416,
     DOMAIN_P = 417,
     DOUBLE_P = 418,
     DROP = 419,
     EACH = 420,
     ELSE = 421,
     ENCODING = 422,
     ENCRYPTED = 423,
     END_P = 424,
     ESCAPE = 425,
     EXCEPT = 426,
     EXCLUSIVE = 427,
     EXCLUDING = 428,
     EXECUTE = 429,
     EXISTS = 430,
     EXPLAIN = 431,
     EXTERNAL = 432,
     EXTRACT = 433,
     FALSE_P = 434,
     FETCH = 435,
     FIRST_P = 436,
     FLOAT_P = 437,
     FOR = 438,
     FORCE = 439,
     FOREIGN = 440,
     FORWARD = 441,
     FREEZE = 442,
     FROM = 443,
     FULL = 444,
     FUNCTION = 445,
     GET = 446,
     GLOBAL = 447,
     GRANT = 448,
     GROUP_P = 449,
     HANDLER = 450,
     HAVING = 451,
     HOLD = 452,
     HOUR_P = 453,
     ILIKE = 454,
     IMMEDIATE = 455,
     IMMUTABLE = 456,
     IMPLICIT_P = 457,
     IN_P = 458,
     INCLUDING = 459,
     INCREMENT = 460,
     INDEX = 461,
     INHERITS = 462,
     INITIALLY = 463,
     INNER_P = 464,
     INOUT = 465,
     INPUT_P = 466,
     INSENSITIVE = 467,
     INSERT = 468,
     INSTEAD = 469,
     INT_P = 470,
     INTEGER = 471,
     INTERSECT = 472,
     INTERVAL = 473,
     INTO = 474,
     INVOKER = 475,
     IS = 476,
     ISNULL = 477,
     ISOLATION = 478,
     JOIN = 479,
     KEY = 480,
     LANCOMPILER = 481,
     LANGUAGE = 482,
     LARGE_P = 483,
     LAST_P = 484,
     LEADING = 485,
     LEFT = 486,
     LEVEL = 487,
     LIKE = 488,
     LIMIT = 489,
     LISTEN = 490,
     LOAD = 491,
     LOCAL = 492,
     LOCATION = 493,
     LOCK_P = 494,
     MATCH = 495,
     MAXVALUE = 496,
     MINUTE_P = 497,
     MINVALUE = 498,
     MODE = 499,
     MONTH_P = 500,
     MOVE = 501,
     NAMES = 502,
     NATIONAL = 503,
     NATURAL = 504,
     NCHAR = 505,
     NEW = 506,
     NEXT = 507,
     NO = 508,
     NOCREATEDB = 509,
     NOCREATEUSER = 510,
     NONE = 511,
     NOT = 512,
     NOTHING = 513,
     NOTIFY = 514,
     NOTNULL = 515,
     NOWAIT = 516,
     NULL_P = 517,
     NULLIF = 518,
     NUMERIC = 519,
     OBJECT_P = 520,
     OF = 521,
     OFF = 522,
     OFFSET = 523,
     OIDS = 524,
     OLD = 525,
     ON = 526,
     ONLY = 527,
     OPERATOR = 528,
     OPTION = 529,
     OR = 530,
     ORDER = 531,
     OUT_P = 532,
     OUTER_P = 533,
     OVERLAPS = 534,
     OVERLAY = 535,
     OWNER = 536,
     PARTIAL = 537,
     PASSWORD = 538,
     PLACING = 539,
     POSITION = 540,
     PRECISION = 541,
     PRESERVE = 542,
     PREPARE = 543,
     PRIMARY = 544,
     PRIOR = 545,
     PRIVILEGES = 546,
     PROCEDURAL = 547,
     PROCEDURE = 548,
     QUOTE = 549,
     READ = 550,
     REAL = 551,
     RECHECK = 552,
     REFERENCES = 553,
     REINDEX = 554,
     RELATIVE_P = 555,
     RELEASE = 556,
     RENAME = 557,
     REPEATABLE = 558,
     REPLACE = 559,
     RESET = 560,
     RESTART = 561,
     RESTRICT = 562,
     RETURNS = 563,
     REVOKE = 564,
     RIGHT = 565,
     ROLLBACK = 566,
     ROW = 567,
     ROWS = 568,
     RULE = 569,
     SAVEPOINT = 570,
     SCHEMA = 571,
     SCROLL = 572,
     SECOND_P = 573,
     SECURITY = 574,
     SELECT = 575,
     SEQUENCE = 576,
     SERIALIZABLE = 577,
     SESSION = 578,
     SESSION_USER = 579,
     SET = 580,
     SETOF = 581,
     SHARE = 582,
     SHOW = 583,
     SIMILAR = 584,
     SIMPLE = 585,
     SMALLINT = 586,
     SOME = 587,
     STABLE = 588,
     START = 589,
     STATEMENT = 590,
     STATISTICS = 591,
     STDIN = 592,
     STDOUT = 593,
     STORAGE = 594,
     STRICT_P = 595,
     SUBSTRING = 596,
     SYSID = 597,
     TABLE = 598,
     TABLESPACE = 599,
     TEMP = 600,
     TEMPLATE = 601,
     TEMPORARY = 602,
     THEN = 603,
     TIME = 604,
     TIMESTAMP = 605,
     TO = 606,
     TOAST = 607,
     TRAILING = 608,
     TRANSACTION = 609,
     TREAT = 610,
     TRIGGER = 611,
     TRIM = 612,
     TRUE_P = 613,
     TRUNCATE = 614,
     TRUSTED = 615,
     TYPE_P = 616,
     UNCOMMITTED = 617,
     UNENCRYPTED = 618,
     UNION = 619,
     UNIQUE = 620,
     UNKNOWN = 621,
     UNLISTEN = 622,
     UNTIL = 623,
     UPDATE = 624,
     USAGE = 625,
     USER = 626,
     USING = 627,
     VACUUM = 628,
     VALID = 629,
     VALUES = 630,
     VARCHAR = 631,
     VARYING = 632,
     VERBOSE = 633,
     VIEW = 634,
     VOLATILE = 635,
     WHEN = 636,
     WHERE = 637,
     WITH = 638,
     WITHOUT = 639,
     WORK = 640,
     WRITE = 641,
     YEAR_P = 642,
     ZONE = 643,
     UNIONJOIN = 644,
     IDENT = 645,
     SCONST = 646,
     Op = 647,
     CSTRING = 648,
     CVARIABLE = 649,
     CPP_LINE = 650,
     IP = 651,
     BCONST = 652,
     XCONST = 653,
     ICONST = 654,
     PARAM = 655,
     FCONST = 656,
     POSTFIXOP = 657,
     UMINUS = 658
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_REFERENCE 290
#define SQL_RETURNED_LENGTH 291
#define SQL_RETURNED_OCTET_LENGTH 292
#define SQL_SCALE 293
#define SQL_SECTION 294
#define SQL_SHORT 295
#define SQL_SIGNED 296
#define SQL_SQL 297
#define SQL_SQLERROR 298
#define SQL_SQLPRINT 299
#define SQL_SQLWARNING 300
#define SQL_START 301
#define SQL_STOP 302
#define SQL_STRUCT 303
#define SQL_UNSIGNED 304
#define SQL_VALUE 305
#define SQL_VAR 306
#define SQL_WHENEVER 307
#define S_ADD 308
#define S_AND 309
#define S_ANYTHING 310
#define S_AUTO 311
#define S_CONST 312
#define S_DEC 313
#define S_DIV 314
#define S_DOTPOINT 315
#define S_EQUAL 316
#define S_EXTERN 317
#define S_INC 318
#define S_LSHIFT 319
#define S_MEMPOINT 320
#define S_MEMBER 321
#define S_MOD 322
#define S_MUL 323
#define S_NEQUAL 324
#define S_OR 325
#define S_REGISTER 326
#define S_RSHIFT 327
#define S_STATIC 328
#define S_SUB 329
#define S_VOLATILE 330
#define S_TYPEDEF 331
#define TYPECAST 332
#define ABORT_P 333
#define ABSOLUTE_P 334
#define ACCESS 335
#define ACTION 336
#define ADD 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define AT 352
#define AUTHORIZATION 353
#define BACKWARD 354
#define BEFORE 355
#define BEGIN_P 356
#define BETWEEN 357
#define BIGINT 358
#define BINARY 359
#define BIT 360
#define BOOLEAN_P 361
#define BOTH 362
#define BY 363
#define CACHE 364
#define CALLED 365
#define CASCADE 366
#define CASE 367
#define CAST 368
#define CHAIN 369
#define CHAR_P 370
#define CHARACTER 371
#define CHARACTERISTICS 372
#define CHECK 373
#define CHECKPOINT 374
#define CLASS 375
#define CLOSE 376
#define CLUSTER 377
#define COALESCE 378
#define COLLATE 379
#define COLUMN 380
#define COMMENT 381
#define COMMIT 382
#define COMMITTED 383
#define CONSTRAINT 384
#define CONSTRAINTS 385
#define CONVERSION_P 386
#define CONVERT 387
#define COPY 388
#define CREATE 389
#define CREATEDB 390
#define CREATEUSER 391
#define CROSS 392
#define CSV 393
#define CURRENT_DATE 394
#define CURRENT_TIME 395
#define CURRENT_TIMESTAMP 396
#define CURRENT_USER 397
#define CURSOR 398
#define CYCLE 399
#define DATABASE 400
#define DAY_P 401
#define DEALLOCATE 402
#define DEC 403
#define DECIMAL_P 404
#define DECLARE 405
#define DEFAULT 406
#define DEFAULTS 407
#define DEFERRABLE 408
#define DEFERRED 409
#define DEFINER 410
#define DELETE_P 411
#define DELIMITER 412
#define DELIMITERS 413
#define DESC 414
#define DISTINCT 415
#define DO 416
#define DOMAIN_P 417
#define DOUBLE_P 418
#define DROP 419
#define EACH 420
#define ELSE 421
#define ENCODING 422
#define ENCRYPTED 423
#define END_P 424
#define ESCAPE 425
#define EXCEPT 426
#define EXCLUSIVE 427
#define EXCLUDING 428
#define EXECUTE 429
#define EXISTS 430
#define EXPLAIN 431
#define EXTERNAL 432
#define EXTRACT 433
#define FALSE_P 434
#define FETCH 435
#define FIRST_P 436
#define FLOAT_P 437
#define FOR 438
#define FORCE 439
#define FOREIGN 440
#define FORWARD 441
#define FREEZE 442
#define FROM 443
#define FULL 444
#define FUNCTION 445
#define GET 446
#define GLOBAL 447
#define GRANT 448
#define GROUP_P 449
#define HANDLER 450
#define HAVING 451
#define HOLD 452
#define HOUR_P 453
#define ILIKE 454
#define IMMEDIATE 455
#define IMMUTABLE 456
#define IMPLICIT_P 457
#define IN_P 458
#define INCLUDING 459
#define INCREMENT 460
#define INDEX 461
#define INHERITS 462
#define INITIALLY 463
#define INNER_P 464
#define INOUT 465
#define INPUT_P 466
#define INSENSITIVE 467
#define INSERT 468
#define INSTEAD 469
#define INT_P 470
#define INTEGER 471
#define INTERSECT 472
#define INTERVAL 473
#define INTO 474
#define INVOKER 475
#define IS 476
#define ISNULL 477
#define ISOLATION 478
#define JOIN 479
#define KEY 480
#define LANCOMPILER 481
#define LANGUAGE 482
#define LARGE_P 483
#define LAST_P 484
#define LEADING 485
#define LEFT 486
#define LEVEL 487
#define LIKE 488
#define LIMIT 489
#define LISTEN 490
#define LOAD 491
#define LOCAL 492
#define LOCATION 493
#define LOCK_P 494
#define MATCH 495
#define MAXVALUE 496
#define MINUTE_P 497
#define MINVALUE 498
#define MODE 499
#define MONTH_P 500
#define MOVE 501
#define NAMES 502
#define NATIONAL 503
#define NATURAL 504
#define NCHAR 505
#define NEW 506
#define NEXT 507
#define NO 508
#define NOCREATEDB 509
#define NOCREATEUSER 510
#define NONE 511
#define NOT 512
#define NOTHING 513
#define NOTIFY 514
#define NOTNULL 515
#define NOWAIT 516
#define NULL_P 517
#define NULLIF 518
#define NUMERIC 519
#define OBJECT_P 520
#define OF 521
#define OFF 522
#define OFFSET 523
#define OIDS 524
#define OLD 525
#define ON 526
#define ONLY 527
#define OPERATOR 528
#define OPTION 529
#define OR 530
#define ORDER 531
#define OUT_P 532
#define OUTER_P 533
#define OVERLAPS 534
#define OVERLAY 535
#define OWNER 536
#define PARTIAL 537
#define PASSWORD 538
#define PLACING 539
#define POSITION 540
#define PRECISION 541
#define PRESERVE 542
#define PREPARE 543
#define PRIMARY 544
#define PRIOR 545
#define PRIVILEGES 546
#define PROCEDURAL 547
#define PROCEDURE 548
#define QUOTE 549
#define READ 550
#define REAL 551
#define RECHECK 552
#define REFERENCES 553
#define REINDEX 554
#define RELATIVE_P 555
#define RELEASE 556
#define RENAME 557
#define REPEATABLE 558
#define REPLACE 559
#define RESET 560
#define RESTART 561
#define RESTRICT 562
#define RETURNS 563
#define REVOKE 564
#define RIGHT 565
#define ROLLBACK 566
#define ROW 567
#define ROWS 568
#define RULE 569
#define SAVEPOINT 570
#define SCHEMA 571
#define SCROLL 572
#define SECOND_P 573
#define SECURITY 574
#define SELECT 575
#define SEQUENCE 576
#define SERIALIZABLE 577
#define SESSION 578
#define SESSION_USER 579
#define SET 580
#define SETOF 581
#define SHARE 582
#define SHOW 583
#define SIMILAR 584
#define SIMPLE 585
#define SMALLINT 586
#define SOME 587
#define STABLE 588
#define START 589
#define STATEMENT 590
#define STATISTICS 591
#define STDIN 592
#define STDOUT 593
#define STORAGE 594
#define STRICT_P 595
#define SUBSTRING 596
#define SYSID 597
#define TABLE 598
#define TABLESPACE 599
#define TEMP 600
#define TEMPLATE 601
#define TEMPORARY 602
#define THEN 603
#define TIME 604
#define TIMESTAMP 605
#define TO 606
#define TOAST 607
#define TRAILING 608
#define TRANSACTION 609
#define TREAT 610
#define TRIGGER 611
#define TRIM 612
#define TRUE_P 613
#define TRUNCATE 614
#define TRUSTED 615
#define TYPE_P 616
#define UNCOMMITTED 617
#define UNENCRYPTED 618
#define UNION 619
#define UNIQUE 620
#define UNKNOWN 621
#define UNLISTEN 622
#define UNTIL 623
#define UPDATE 624
#define USAGE 625
#define USER 626
#define USING 627
#define VACUUM 628
#define VALID 629
#define VALUES 630
#define VARCHAR 631
#define VARYING 632
#define VERBOSE 633
#define VIEW 634
#define VOLATILE 635
#define WHEN 636
#define WHERE 637
#define WITH 638
#define WITHOUT 639
#define WORK 640
#define WRITE 641
#define YEAR_P 642
#define ZONE 643
#define UNIONJOIN 644
#define IDENT 645
#define SCONST 646
#define Op 647
#define CSTRING 648
#define CVARIABLE 649
#define CPP_LINE 650
#define IP 651
#define BCONST 652
#define XCONST 653
#define ICONST 654
#define PARAM 655
#define FCONST 656
#define POSTFIXOP 657
#define UMINUS 658




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * { 
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable 
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 311 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1202 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1214 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   51633

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  424
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  514
/* YYNRULES -- Number of rules. */
#define YYNRULES  1943
/* YYNRULES -- Number of states. */
#define YYNSTATES  3191

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   659

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   410,     2,     2,
     415,   416,   408,   406,   421,   407,   417,   409,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   423,   418,
     403,   402,   404,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   413,     2,   414,   411,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   419,     2,   420,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   405,   412,   422
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   224,   226,   227,
     232,   238,   244,   249,   253,   256,   257,   260,   263,   265,
     267,   269,   271,   275,   279,   283,   285,   290,   296,   299,
     300,   303,   306,   313,   320,   324,   331,   336,   338,   339,
     342,   343,   345,   347,   349,   351,   353,   355,   358,   362,
     366,   370,   374,   378,   381,   387,   390,   394,   398,   400,
     404,   406,   408,   410,   414,   417,   420,   423,   425,   427,
     429,   431,   433,   435,   437,   439,   441,   443,   447,   454,
     456,   458,   460,   462,   463,   465,   467,   470,   474,   479,
     483,   486,   489,   493,   498,   502,   505,   510,   512,   514,
     516,   518,   520,   525,   530,   532,   536,   540,   545,   552,
     559,   566,   573,   578,   585,   588,   593,   597,   601,   605,
     609,   611,   615,   619,   623,   627,   630,   632,   634,   635,
     638,   639,   642,   652,   654,   656,   658,   660,   662,   665,
     666,   668,   670,   674,   678,   680,   684,   688,   692,   697,
     699,   700,   703,   704,   708,   709,   711,   712,   724,   737,
     739,   741,   744,   747,   750,   753,   754,   756,   757,   759,
     763,   765,   767,   769,   773,   776,   777,   781,   783,   785,
     788,   790,   793,   797,   802,   805,   811,   813,   816,   819,
     822,   826,   829,   832,   833,   837,   839,   844,   850,   857,
     869,   873,   874,   878,   880,   882,   885,   888,   889,   891,
     893,   896,   899,   900,   904,   908,   911,   913,   915,   918,
     921,   926,   927,   930,   933,   934,   938,   943,   948,   949,
     952,   953,   958,   959,   960,   969,   973,   977,   979,   983,
     984,   988,   990,   992,   998,  1003,  1006,  1007,  1010,  1012,
    1015,  1019,  1022,  1025,  1028,  1031,  1035,  1039,  1041,  1042,
    1051,  1053,  1054,  1056,  1059,  1062,  1063,  1069,  1071,  1072,
    1079,  1082,  1083,  1087,  1102,  1122,  1124,  1126,  1128,  1132,
    1138,  1140,  1142,  1144,  1148,  1149,  1151,  1152,  1154,  1156,
    1158,  1162,  1163,  1165,  1167,  1168,  1171,  1173,  1176,  1178,
    1181,  1184,  1186,  1189,  1192,  1199,  1208,  1212,  1217,  1222,
    1227,  1233,  1237,  1241,  1243,  1247,  1251,  1253,  1255,  1257,
    1259,  1272,  1274,  1278,  1283,  1291,  1296,  1299,  1301,  1302,
    1304,  1305,  1313,  1318,  1320,  1322,  1324,  1326,  1328,  1330,
    1332,  1334,  1336,  1340,  1342,  1345,  1348,  1352,  1356,  1362,
    1367,  1372,  1376,  1381,  1385,  1389,  1392,  1397,  1400,  1402,
    1404,  1406,  1408,  1411,  1414,  1416,  1418,  1420,  1423,  1426,
    1428,  1431,  1434,  1436,  1438,  1440,  1447,  1457,  1465,  1475,
    1484,  1493,  1500,  1510,  1518,  1529,  1537,  1539,  1541,  1543,
    1545,  1547,  1549,  1551,  1553,  1555,  1557,  1559,  1561,  1569,
    1578,  1581,  1583,  1585,  1587,  1591,  1593,  1595,  1597,  1599,
    1601,  1603,  1605,  1607,  1609,  1611,  1613,  1615,  1617,  1620,
    1623,  1626,  1629,  1632,  1635,  1637,  1641,  1643,  1646,  1650,
    1651,  1655,  1656,  1658,  1662,  1665,  1678,  1680,  1681,  1684,
    1685,  1687,  1691,  1694,  1697,  1702,  1704,  1707,  1708,  1718,
    1721,  1722,  1726,  1729,  1731,  1735,  1739,  1742,  1744,  1746,
    1748,  1749,  1751,  1755,  1757,  1759,  1761,  1766,  1768,  1771,
    1774,  1777,  1779,  1781,  1783,  1788,  1794,  1796,  1800,  1804,
    1807,  1810,  1813,  1814,  1820,  1828,  1830,  1832,  1840,  1842,
    1846,  1850,  1854,  1856,  1860,  1872,  1883,  1886,  1887,  1896,
    1901,  1906,  1908,  1910,  1912,  1913,  1923,  1930,  1937,  1945,
    1952,  1959,  1969,  1976,  1983,  1990,  1999,  2008,  2015,  2022,
    2024,  2025,  2035,  2042,  2049,  2056,  2064,  2074,  2084,  2091,
    2098,  2105,  2106,  2121,  2123,  2125,  2129,  2133,  2135,  2137,
    2139,  2141,  2143,  2145,  2147,  2148,  2150,  2152,  2154,  2156,
    2158,  2160,  2161,  2168,  2171,  2174,  2177,  2180,  2183,  2187,
    2191,  2194,  2197,  2200,  2203,  2207,  2210,  2216,  2221,  2223,
    2225,  2226,  2230,  2233,  2236,  2238,  2242,  2245,  2247,  2248,
    2256,  2259,  2265,  2269,  2271,  2274,  2278,  2282,  2286,  2290,
    2294,  2298,  2302,  2306,  2310,  2314,  2316,  2317,  2323,  2328,
    2332,  2339,  2344,  2351,  2358,  2364,  2372,  2374,  2375,  2386,
    2391,  2394,  2396,  2401,  2407,  2413,  2416,  2421,  2423,  2425,
    2427,  2428,  2430,  2431,  2433,  2434,  2438,  2439,  2444,  2446,
    2448,  2450,  2452,  2454,  2456,  2457,  2462,  2467,  2470,  2472,
    2480,  2485,  2489,  2491,  2494,  2499,  2505,  2509,  2510,  2513,
    2516,  2519,  2523,  2525,  2529,  2531,  2534,  2536,  2537,  2544,
    2552,  2553,  2556,  2559,  2562,  2566,  2567,  2570,  2573,  2575,
    2577,  2581,  2585,  2587,  2590,  2595,  2600,  2602,  2604,  2613,
    2618,  2623,  2628,  2631,  2633,  2634,  2638,  2642,  2647,  2652,
    2657,  2662,  2665,  2667,  2669,  2670,  2672,  2673,  2675,  2681,
    2683,  2684,  2686,  2687,  2691,  2693,  2697,  2701,  2704,  2707,
    2709,  2714,  2719,  2722,  2725,  2730,  2732,  2733,  2735,  2737,
    2739,  2743,  2744,  2747,  2748,  2752,  2756,  2758,  2759,  2762,
    2763,  2766,  2767,  2771,  2773,  2775,  2778,  2780,  2783,  2789,
    2796,  2802,  2804,  2807,  2809,  2814,  2818,  2823,  2827,  2833,
    2838,  2844,  2849,  2855,  2858,  2863,  2865,  2868,  2871,  2874,
    2876,  2878,  2879,  2884,  2887,  2889,  2892,  2895,  2900,  2902,
    2905,  2906,  2908,  2912,  2915,  2918,  2922,  2928,  2935,  2939,
    2944,  2945,  2947,  2951,  2955,  2959,  2963,  2967,  2971,  2973,
    2975,  2977,  2979,  2981,  2983,  2985,  2988,  2994,  2997,  2999,
    3001,  3003,  3005,  3007,  3009,  3011,  3013,  3015,  3017,  3019,
    3022,  3025,  3028,  3031,  3034,  3036,  3040,  3041,  3047,  3051,
    3052,  3058,  3062,  3063,  3065,  3067,  3069,  3071,  3077,  3080,
    3082,  3084,  3086,  3088,  3094,  3097,  3100,  3103,  3105,  3109,
    3113,  3116,  3118,  3119,  3123,  3124,  3130,  3133,  3139,  3142,
    3144,  3148,  3152,  3153,  3155,  3157,  3159,  3161,  3163,  3165,
    3169,  3173,  3177,  3181,  3185,  3189,  3193,  3194,  3196,  3200,
    3206,  3209,  3212,  3215,  3218,  3221,  3224,  3228,  3232,  3236,
    3240,  3244,  3248,  3252,  3256,  3260,  3264,  3267,  3270,  3274,
    3278,  3281,  3285,  3291,  3296,  3303,  3307,  3313,  3318,  3325,
    3330,  3337,  3343,  3351,  3354,  3358,  3361,  3366,  3370,  3375,
    3379,  3384,  3388,  3393,  3399,  3406,  3414,  3420,  3427,  3431,
    3436,  3441,  3448,  3451,  3453,  3457,  3460,  3463,  3466,  3469,
    3472,  3476,  3480,  3484,  3488,  3492,  3496,  3500,  3504,  3508,
    3512,  3515,  3518,  3524,  3531,  3539,  3541,  3543,  3546,  3551,
    3553,  3555,  3557,  3560,  3563,  3566,  3568,  3572,  3577,  3583,
    3589,  3594,  3596,  3599,  3604,  3607,  3612,  3615,  3618,  3621,
    3628,  3633,  3638,  3643,  3648,  3655,  3661,  3667,  3673,  3678,
    3685,  3690,  3697,  3702,  3707,  3711,  3717,  3719,  3721,  3723,
    3725,  3727,  3729,  3731,  3733,  3735,  3737,  3739,  3741,  3743,
    3745,  3747,  3752,  3754,  3759,  3761,  3766,  3768,  3771,  3773,
    3776,  3778,  3782,  3786,  3787,  3791,  3793,  3795,  3799,  3803,
    3807,  3809,  3811,  3813,  3815,  3817,  3819,  3821,  3823,  3828,
    3832,  3835,  3839,  3840,  3844,  3848,  3851,  3854,  3856,  3857,
    3860,  3863,  3867,  3870,  3872,  3874,  3878,  3884,  3887,  3889,
    3894,  3897,  3898,  3900,  3901,  3903,  3906,  3909,  3912,  3916,
    3922,  3924,  3927,  3928,  3931,  3934,  3935,  3939,  3941,  3945,
    3947,  3949,  3953,  3961,  3963,  3966,  3971,  3973,  3977,  3982,
    3987,  3991,  3993,  3995,  3997,  3999,  4001,  4003,  4007,  4009,
    4012,  4014,  4018,  4020,  4022,  4024,  4026,  4028,  4030,  4032,
    4035,  4037,  4040,  4044,  4051,  4053,  4055,  4057,  4059,  4061,
    4063,  4065,  4067,  4069,  4071,  4073,  4075,  4078,  4080,  4082,
    4084,  4086,  4089,  4092,  4094,  4096,  4098,  4100,  4102,  4104,
    4106,  4108,  4111,  4114,  4116,  4118,  4120,  4122,  4124,  4126,
    4128,  4130,  4132,  4134,  4136,  4138,  4144,  4148,  4151,  4154,
    4158,  4166,  4168,  4170,  4173,  4176,  4178,  4179,  4181,  4185,
    4187,  4190,  4191,  4194,  4195,  4198,  4199,  4201,  4205,  4210,
    4214,  4216,  4218,  4220,  4223,  4224,  4232,  4236,  4239,  4241,
    4243,  4245,  4246,  4252,  4253,  4258,  4261,  4263,  4266,  4267,
    4269,  4273,  4277,  4281,  4285,  4286,  4291,  4297,  4303,  4304,
    4306,  4308,  4310,  4312,  4315,  4318,  4321,  4323,  4326,  4327,
    4335,  4336,  4342,  4343,  4348,  4351,  4354,  4356,  4358,  4360,
    4362,  4364,  4366,  4368,  4370,  4372,  4374,  4376,  4382,  4385,
    4387,  4391,  4394,  4397,  4401,  4402,  4408,  4410,  4411,  4417,
    4420,  4423,  4425,  4427,  4429,  4432,  4435,  4439,  4441,  4444,
    4447,  4451,  4455,  4460,  4463,  4465,  4468,  4470,  4472,  4475,
    4478,  4482,  4484,  4486,  4488,  4490,  4491,  4493,  4497,  4502,
    4503,  4506,  4507,  4509,  4512,  4516,  4519,  4521,  4523,  4525,
    4526,  4528,  4530,  4534,  4535,  4540,  4543,  4546,  4548,  4550,
    4551,  4553,  4555,  4557,  4559,  4562,  4566,  4567,  4569,  4572,
    4574,  4579,  4584,  4585,  4587,  4590,  4592,  4594,  4598,  4600,
    4602,  4607,  4612,  4617,  4622,  4624,  4625,  4629,  4633,  4638,
    4640,  4644,  4648,  4653,  4655,  4659,  4663,  4665,  4672,  4674,
    4678,  4682,  4689,  4691,  4695,  4699,  4701,  4703,  4705,  4707,
    4709,  4711,  4713,  4715,  4717,  4719,  4721,  4723,  4725,  4727,
    4729,  4734,  4739,  4741,  4743,  4748,  4753,  4757,  4758,  4766,
    4768,  4769,  4770,  4778,  4782,  4787,  4791,  4793,  4795,  4797,
    4800,  4804,  4810,  4813,  4819,  4822,  4824,  4826,  4828,  4830,
    4832,  4834,  4836,  4838,  4840,  4842,  4844,  4846,  4848,  4850,
    4852,  4854,  4856,  4858,  4860,  4862,  4864,  4866,  4868,  4870,
    4872,  4874,  4876,  4878,  4880,  4882,  4884,  4886,  4888,  4890,
    4892,  4894,  4896,  4898,  4900,  4902,  4904,  4906,  4908,  4910,
    4912,  4914,  4916,  4918,  4920,  4922,  4924,  4926,  4928,  4930,
    4932,  4934,  4936,  4938,  4940,  4942,  4944,  4946,  4948,  4950,
    4952,  4954,  4956,  4958,  4960,  4962,  4964,  4966,  4968,  4970,
    4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,  4990,
    4992,  4994,  4996,  4998,  5000,  5002,  5004,  5006,  5008,  5010,
    5012,  5014,  5016,  5018,  5020,  5022,  5024,  5026,  5028,  5030,
    5032,  5034,  5036,  5038,  5040,  5042,  5044,  5046,  5048,  5050,
    5052,  5054,  5056,  5058,  5060,  5062,  5064,  5066,  5068,  5070,
    5072,  5074,  5076,  5078,  5080,  5082,  5084,  5086,  5088,  5090,
    5092,  5094,  5096,  5098,  5100,  5102,  5104,  5106,  5108,  5110,
    5112,  5114,  5116,  5118,  5120,  5122,  5124,  5126,  5128,  5130,
    5132,  5134,  5136,  5138,  5140,  5142,  5144,  5146,  5148,  5150,
    5152,  5154,  5156,  5158,  5160,  5162,  5164,  5166,  5168,  5170,
    5172,  5174,  5176,  5178,  5180,  5182,  5184,  5186,  5188,  5190,
    5192,  5194,  5196,  5198,  5200,  5202,  5204,  5206,  5208,  5210,
    5212,  5214,  5216,  5218,  5220,  5222,  5224,  5226,  5228,  5230,
    5232,  5234,  5236,  5238,  5240,  5242,  5244,  5246,  5248,  5250,
    5252,  5254,  5256,  5258,  5260,  5262,  5264,  5266,  5268,  5270,
    5272,  5274,  5276,  5278,  5280,  5282,  5284,  5286,  5288,  5290,
    5292,  5294,  5296,  5298,  5300,  5302,  5304,  5306,  5308,  5310,
    5312,  5314,  5316,  5318,  5320,  5322,  5324,  5326,  5328,  5330,
    5332,  5334,  5336,  5338,  5340,  5342,  5344,  5346,  5348,  5350,
    5352,  5354,  5356,  5358,  5360,  5362,  5364,  5366,  5368,  5370,
    5372,  5374,  5376,  5378,  5380,  5382,  5384,  5386,  5388,  5390,
    5392,  5394,  5396,  5398,  5400,  5402,  5404,  5406,  5408,  5410,
    5412,  5414,  5416,  5418,  5420,  5422,  5424,  5426,  5428,  5430,
    5432,  5434,  5436,  5438,  5440,  5442,  5444,  5446,  5448,  5450,
    5452,  5454,  5456,  5458,  5460,  5462,  5464,  5466,  5468,  5470,
    5472,  5474,  5476,  5478,  5480,  5482,  5484,  5486,  5488,  5490,
    5492,  5494,  5496,  5498,  5500,  5502,  5504,  5506,  5508,  5510,
    5512,  5514,  5516,  5518,  5520,  5522,  5524,  5526,  5528,  5530,
    5532,  5534,  5536,  5538,  5540,  5542,  5544,  5546,  5548,  5550,
    5552,  5554,  5556,  5558,  5560,  5562,  5564,  5566,  5568,  5570,
    5572,  5574,  5576,  5578,  5580,  5582,  5584,  5586,  5588,  5592,
    5594,  5595,  5597,  5600,  5602,  5605,  5607,  5609,  5612,  5615,
    5617,  5619,  5621,  5623,  5625,  5627,  5630,  5634,  5636,  5639,
    5641,  5645,  5647,  5651,  5653,  5655,  5657,  5659,  5661,  5663,
    5665,  5667,  5669,  5671,  5673,  5675,  5677,  5679,  5681,  5683,
    5685,  5687,  5689,  5691,  5693,  5695,  5697,  5699,  5701,  5703,
    5705,  5707,  5709,  5711,  5713,  5715,  5717,  5719,  5721,  5723,
    5725,  5727,  5729,  5731,  5733,  5735,  5737,  5739,  5741,  5743,
    5745,  5747,  5749,  5751,  5753,  5755,  5757,  5759,  5761,  5763,
    5765,  5767,  5769,  5771
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     425,     0,    -1,   426,    -1,    -1,   426,   427,    -1,   923,
     428,   429,   418,    -1,   923,   429,   418,    -1,   923,   816,
      -1,   824,    -1,   936,    -1,   395,    -1,   419,    -1,   420,
      -1,    97,   802,    -1,   639,    -1,   642,    -1,   441,    -1,
     615,    -1,   516,    -1,   464,    -1,   433,    -1,   432,    -1,
     647,    -1,   463,    -1,   472,    -1,   645,    -1,   567,    -1,
     460,    -1,   473,    -1,   509,    -1,   543,    -1,   607,    -1,
     644,    -1,   641,    -1,   588,    -1,   438,    -1,   520,    -1,
     551,    -1,   443,    -1,   515,    -1,   482,    -1,   529,    -1,
     526,    -1,   430,    -1,   635,    -1,   666,    -1,   545,    -1,
     660,    -1,   544,    -1,   609,    -1,   442,    -1,   556,    -1,
     524,    -1,   624,    -1,   557,    -1,   528,    -1,   542,    -1,
     434,    -1,   640,    -1,   653,    -1,   563,    -1,   570,    -1,
     582,    -1,   656,    -1,   626,    -1,   634,    -1,   661,    -1,
     625,    -1,   610,    -1,   602,    -1,   604,    -1,   601,    -1,
     613,    -1,   571,    -1,   616,    -1,   669,    -1,   628,    -1,
     562,    -1,   627,    -1,   665,    -1,   646,    -1,   447,    -1,
     458,    -1,   459,    -1,   633,    -1,   878,    -1,   801,    -1,
     814,    -1,   815,    -1,   879,    -1,   856,    -1,   876,    -1,
     857,    -1,   860,    -1,   865,    -1,   887,    -1,   880,    -1,
     866,    -1,   875,    -1,   894,    -1,   896,    -1,   890,    -1,
     883,    -1,   897,    -1,   900,    -1,   902,    -1,   134,   371,
     799,   431,   435,    -1,   383,    -1,    -1,    87,   371,   799,
     435,    -1,    87,   371,   799,   383,   435,    -1,    87,   371,
     799,   325,   448,    -1,    87,   371,   799,   459,    -1,   164,
     371,   437,    -1,   435,   436,    -1,    -1,   283,   789,    -1,
     342,   790,    -1,   135,    -1,   254,    -1,   136,    -1,   255,
      -1,   203,   194,   437,    -1,   374,   368,   789,    -1,   437,
     421,   799,    -1,   799,    -1,   134,   194,   799,   439,    -1,
     134,   194,   799,   383,   439,    -1,   439,   440,    -1,    -1,
     371,   437,    -1,   342,   790,    -1,    87,   194,   799,    82,
     371,   437,    -1,    87,   194,   799,   164,   371,   437,    -1,
     164,   194,   799,    -1,   134,   316,   444,    98,   799,   445,
      -1,   134,   316,   909,   445,    -1,   909,    -1,    -1,   445,
     446,    -1,    -1,   482,    -1,   582,    -1,   515,    -1,   529,
      -1,   570,    -1,   633,    -1,   325,   448,    -1,   325,   237,
     448,    -1,   325,   323,   448,    -1,   449,   351,   450,    -1,
     449,   422,   450,    -1,   349,   388,   455,    -1,   354,   631,
      -1,   323,   117,    93,   354,   631,    -1,   247,   456,    -1,
     323,    98,   457,    -1,   323,    98,   151,    -1,   909,    -1,
     449,   417,   909,    -1,   451,    -1,   151,    -1,   453,    -1,
     451,   421,   453,    -1,   295,   362,    -1,   295,   128,    -1,
     303,   295,    -1,   322,    -1,   454,    -1,   797,    -1,   909,
      -1,   358,    -1,   179,    -1,   271,    -1,   267,    -1,   797,
      -1,   930,    -1,   727,   794,   729,    -1,   727,   415,   790,
     416,   794,   729,    -1,   151,    -1,   237,    -1,   794,    -1,
     151,    -1,    -1,   909,    -1,   794,    -1,   328,   909,    -1,
     328,   349,   388,    -1,   328,   354,   223,   232,    -1,   328,
     323,    98,    -1,   328,    85,    -1,   305,   909,    -1,   305,
     349,   388,    -1,   305,   354,   223,   232,    -1,   305,   323,
      98,    -1,   305,    85,    -1,   325,   130,   461,   462,    -1,
      85,    -1,   776,    -1,   154,    -1,   200,    -1,   119,    -1,
      87,   343,   700,   465,    -1,    87,   206,   700,   467,    -1,
     466,    -1,   465,   421,   466,    -1,    82,   614,   487,    -1,
      87,   614,   909,   469,    -1,    87,   614,   909,   164,   257,
     262,    -1,    87,   614,   909,   325,   257,   262,    -1,    87,
     614,   909,   325,   336,   790,    -1,    87,   614,   909,   325,
     339,   909,    -1,   164,   614,   909,   470,    -1,    87,   614,
     909,   361,   705,   471,    -1,    82,   494,    -1,   164,   129,
     777,   470,    -1,   325,   384,   269,    -1,   134,   352,   343,
      -1,   122,   271,   777,    -1,   325,   384,   122,    -1,   468,
      -1,   467,   421,   468,    -1,   281,   351,   799,    -1,   325,
     344,   777,    -1,   325,   151,   730,    -1,   164,   151,    -1,
     111,    -1,   307,    -1,    -1,   372,   730,    -1,    -1,   121,
     777,    -1,   133,   478,   775,   479,   474,   475,   480,   431,
     476,    -1,   351,    -1,   188,    -1,   794,    -1,   337,    -1,
     338,    -1,   476,   477,    -1,    -1,   104,    -1,   269,    -1,
     157,   643,   794,    -1,   262,   643,   794,    -1,   138,    -1,
     294,   643,   789,    -1,   170,   643,   789,    -1,   184,   294,
     497,    -1,   184,   257,   262,   497,    -1,   104,    -1,    -1,
     383,   269,    -1,    -1,   481,   158,   794,    -1,    -1,   372,
      -1,    -1,   134,   483,   343,   775,   415,   484,   416,   504,
     505,   506,   507,    -1,   134,   483,   343,   775,   266,   775,
     415,   484,   416,   505,   506,   507,    -1,   347,    -1,   345,
      -1,   237,   347,    -1,   237,   345,    -1,   192,   347,    -1,
     192,   345,    -1,    -1,   485,    -1,    -1,   486,    -1,   485,
     421,   486,    -1,   487,    -1,   492,    -1,   494,    -1,   909,
     705,   488,    -1,   488,   489,    -1,    -1,   129,   777,   490,
      -1,   490,    -1,   491,    -1,   257,   262,    -1,   262,    -1,
     365,   508,    -1,   289,   225,   508,    -1,   118,   415,   730,
     416,    -1,   151,   731,    -1,   298,   775,   496,   499,   500,
      -1,   153,    -1,   257,   153,    -1,   208,   154,    -1,   208,
     200,    -1,   233,   775,   493,    -1,   204,   152,    -1,   173,
     152,    -1,    -1,   129,   777,   495,    -1,   495,    -1,   118,
     415,   730,   416,    -1,   365,   415,   497,   416,   508,    -1,
     289,   225,   415,   497,   416,   508,    -1,   185,   225,   415,
     497,   416,   298,   775,   496,   499,   500,   539,    -1,   415,
     497,   416,    -1,    -1,   497,   421,   498,    -1,   498,    -1,
     909,    -1,   240,   189,    -1,   240,   282,    -1,    -1,   501,
      -1,   502,    -1,   501,   502,    -1,   502,   501,    -1,    -1,
     271,   156,   503,    -1,   271,   369,   503,    -1,   253,    81,
      -1,   307,    -1,   111,    -1,   325,   151,    -1,   325,   262,
      -1,   207,   415,   774,   416,    -1,    -1,   383,   269,    -1,
     384,   269,    -1,    -1,   271,   127,   164,    -1,   271,   127,
     156,   313,    -1,   271,   127,   287,   313,    -1,    -1,   344,
     777,    -1,    -1,   372,   206,   344,   777,    -1,    -1,    -1,
     134,   483,   343,   775,   512,   511,   510,   669,    -1,   383,
     269,    93,    -1,   384,   269,    93,    -1,    93,    -1,   415,
     513,   416,    -1,    -1,   513,   421,   514,    -1,   514,    -1,
     909,    -1,   134,   483,   321,   775,   517,    -1,    87,   321,
     775,   517,    -1,   517,   518,    -1,    -1,   109,   796,    -1,
     144,    -1,   253,   144,    -1,   205,   519,   796,    -1,   241,
     796,    -1,   243,   796,    -1,   253,   241,    -1,   253,   243,
      -1,   334,   431,   796,    -1,   306,   431,   796,    -1,   108,
      -1,    -1,   134,   521,   525,   227,   457,   195,   522,   523,
      -1,   360,    -1,    -1,   777,    -1,   777,   561,    -1,   226,
     794,    -1,    -1,   164,   525,   227,   794,   470,    -1,   292,
      -1,    -1,   134,   344,   777,   527,   238,   789,    -1,   281,
     777,    -1,    -1,   164,   344,   777,    -1,   134,   356,   777,
     530,   531,   271,   775,   533,   174,   293,   777,   415,   536,
     416,    -1,   134,   129,   356,   777,    83,   531,   271,   775,
     538,   539,   183,   165,   312,   174,   293,   783,   415,   536,
     416,    -1,   100,    -1,    83,    -1,   532,    -1,   532,   275,
     532,    -1,   532,   275,   532,   275,   532,    -1,   213,    -1,
     156,    -1,   369,    -1,   183,   534,   535,    -1,    -1,   165,
      -1,    -1,   312,    -1,   335,    -1,   537,    -1,   536,   421,
     537,    -1,    -1,   798,    -1,   909,    -1,    -1,   188,   775,
      -1,   540,    -1,   540,   541,    -1,   541,    -1,   541,   540,
      -1,   257,   153,    -1,   153,    -1,   208,   200,    -1,   208,
     154,    -1,   164,   356,   777,   271,   775,   470,    -1,   134,
      95,   777,   118,   415,   730,   416,   539,    -1,   164,    95,
     777,    -1,   134,    84,   783,   547,    -1,   134,   273,   736,
     547,    -1,   134,   361,   560,   547,    -1,   134,   361,   560,
      93,   546,    -1,   415,   703,   416,    -1,   415,   548,   416,
      -1,   549,    -1,   548,   421,   549,    -1,   912,   402,   550,
      -1,   912,    -1,   596,    -1,   739,    -1,   797,    -1,   134,
     273,   120,   560,   554,   183,   361,   705,   372,   779,    93,
     552,    -1,   553,    -1,   552,   421,   553,    -1,   273,   790,
     606,   555,    -1,   273,   790,   606,   415,   605,   416,   555,
      -1,   190,   790,   783,   590,    -1,   339,   705,    -1,   151,
      -1,    -1,   297,    -1,    -1,   164,   273,   120,   560,   372,
     779,   470,    -1,   164,   558,   559,   470,    -1,   343,    -1,
     321,    -1,   379,    -1,   206,    -1,   361,    -1,   162,    -1,
     131,    -1,   316,    -1,   560,    -1,   559,   421,   560,    -1,
     909,    -1,   909,   561,    -1,   417,   780,    -1,   561,   417,
     780,    -1,   359,   676,   775,    -1,   180,   564,   566,   777,
     872,    -1,   180,   564,   777,   872,    -1,   180,   566,   777,
     872,    -1,   180,   777,   872,    -1,   180,   564,   566,   777,
      -1,   180,   564,   777,    -1,   180,   566,   777,    -1,   180,
     777,    -1,   246,   564,   566,   777,    -1,   246,   777,    -1,
     252,    -1,   290,    -1,   181,    -1,   229,    -1,    79,   565,
      -1,   300,   565,    -1,   565,    -1,    85,    -1,   186,    -1,
     186,   565,    -1,   186,    85,    -1,    99,    -1,    99,   565,
      -1,    99,    85,    -1,   791,    -1,   203,    -1,   188,    -1,
     126,   271,   568,   777,   221,   569,    -1,   126,   271,    84,
     783,   415,   603,   416,   221,   569,    -1,   126,   271,   190,
     783,   590,   221,   569,    -1,   126,   271,   273,   736,   415,
     605,   416,   221,   569,    -1,   126,   271,   356,   777,   271,
     560,   221,   569,    -1,   126,   271,   314,   777,   271,   560,
     221,   569,    -1,   126,   271,   314,   777,   221,   569,    -1,
     126,   271,   273,   120,   560,   372,   779,   221,   569,    -1,
     126,   271,   228,   265,   796,   221,   569,    -1,   126,   271,
     113,   415,   705,    93,   705,   416,   221,   569,    -1,   126,
     271,   525,   227,   560,   221,   569,    -1,   125,    -1,   145,
      -1,   316,    -1,   206,    -1,   321,    -1,   343,    -1,   162,
      -1,   361,    -1,   379,    -1,   131,    -1,   794,    -1,   262,
      -1,   193,   572,   271,   575,   351,   576,   578,    -1,   309,
     579,   572,   271,   575,   188,   576,   470,    -1,    85,   291,
      -1,    85,    -1,   573,    -1,   574,    -1,   573,   421,   574,
      -1,   320,    -1,   213,    -1,   369,    -1,   156,    -1,   314,
      -1,   298,    -1,   356,    -1,   174,    -1,   370,    -1,   134,
      -1,   347,    -1,   345,    -1,   774,    -1,   343,   774,    -1,
     190,   580,    -1,   145,   776,    -1,   227,   776,    -1,   316,
     776,    -1,   344,   776,    -1,   577,    -1,   576,   421,   577,
      -1,   909,    -1,   194,   909,    -1,   383,   193,   274,    -1,
      -1,   193,   274,   183,    -1,    -1,   581,    -1,   580,   421,
     581,    -1,   783,   590,    -1,   134,   583,   206,   781,   271,
     775,   584,   415,   585,   416,   507,   702,    -1,   365,    -1,
      -1,   372,   779,    -1,    -1,   586,    -1,   585,   421,   586,
      -1,   909,   587,    -1,   733,   587,    -1,   415,   730,   416,
     587,    -1,   560,    -1,   372,   560,    -1,    -1,   134,   589,
     190,   783,   590,   308,   596,   598,   600,    -1,   275,   304,
      -1,    -1,   415,   591,   416,    -1,   415,   416,    -1,   592,
      -1,   591,   421,   592,    -1,   593,   595,   597,    -1,   593,
     597,    -1,   203,    -1,   277,    -1,   210,    -1,    -1,   794,
      -1,   794,   421,   794,    -1,   911,    -1,   597,    -1,   705,
      -1,   910,   561,   410,   361,    -1,   599,    -1,   598,   599,
      -1,    93,   594,    -1,   227,   457,    -1,   201,    -1,   333,
      -1,   380,    -1,   110,   271,   262,   211,    -1,   308,   262,
     271,   262,   211,    -1,   340,    -1,   177,   319,   155,    -1,
     177,   319,   220,    -1,   319,   155,    -1,   319,   220,    -1,
     383,   547,    -1,    -1,   164,   190,   783,   590,   470,    -1,
     164,    84,   783,   415,   603,   416,   470,    -1,   705,    -1,
     408,    -1,   164,   273,   736,   415,   605,   416,   470,    -1,
     705,    -1,   705,   421,   705,    -1,   256,   421,   705,    -1,
     705,   421,   256,    -1,   736,    -1,   909,   417,   606,    -1,
     134,   113,   415,   705,    93,   705,   416,   383,   190,   581,
     608,    -1,   134,   113,   415,   705,    93,   705,   416,   384,
     190,   608,    -1,    93,    96,    -1,    -1,   164,   113,   415,
     705,    93,   705,   416,   470,    -1,   299,   611,   775,   612,
      -1,   299,   145,   777,   612,    -1,   206,    -1,   343,    -1,
     184,    -1,    -1,    87,    84,   783,   415,   603,   416,   302,
     351,   777,    -1,    87,   131,   560,   302,   351,   777,    -1,
      87,   145,   778,   302,   351,   778,    -1,    87,   190,   783,
     590,   302,   351,   777,    -1,    87,   194,   799,   302,   351,
     799,    -1,    87,   227,   777,   302,   351,   777,    -1,    87,
     273,   120,   560,   372,   779,   302,   351,   777,    -1,    87,
     316,   777,   302,   351,   777,    -1,    87,   343,   700,   302,
     351,   777,    -1,    87,   206,   700,   302,   351,   777,    -1,
      87,   343,   700,   302,   614,   777,   351,   777,    -1,    87,
     356,   777,   271,   700,   302,   351,   777,    -1,    87,   371,
     799,   302,   351,   799,    -1,    87,   344,   777,   302,   351,
     777,    -1,   125,    -1,    -1,    87,    84,   783,   415,   603,
     416,   281,   351,   799,    -1,    87,   131,   560,   281,   351,
     799,    -1,    87,   145,   778,   281,   351,   799,    -1,    87,
     162,   778,   281,   351,   799,    -1,    87,   190,   783,   590,
     281,   351,   799,    -1,    87,   273,   606,   415,   605,   416,
     281,   351,   799,    -1,    87,   273,   120,   560,   372,   779,
     281,   351,   799,    -1,    87,   316,   777,   281,   351,   799,
      -1,    87,   361,   560,   281,   351,   799,    -1,    87,   344,
     777,   281,   351,   799,    -1,    -1,   134,   589,   314,   777,
      93,   617,   271,   622,   351,   775,   702,   161,   623,   618,
      -1,   258,    -1,   620,    -1,   415,   619,   416,    -1,   619,
     418,   621,    -1,   621,    -1,   669,    -1,   656,    -1,   665,
      -1,   660,    -1,   625,    -1,   620,    -1,    -1,   320,    -1,
     369,    -1,   156,    -1,   213,    -1,   214,    -1,    86,    -1,
      -1,   164,   314,   777,   271,   775,   470,    -1,   259,   775,
      -1,   235,   775,    -1,   367,   775,    -1,   367,   408,    -1,
      78,   629,    -1,   101,   629,   632,    -1,   334,   354,   632,
      -1,   127,   629,    -1,   169,   629,    -1,   311,   629,    -1,
     315,   909,    -1,   301,   315,   909,    -1,   301,   909,    -1,
     311,   629,   351,   315,   909,    -1,   311,   629,   351,   909,
      -1,   385,    -1,   354,    -1,    -1,   223,   232,   452,    -1,
     295,   272,    -1,   295,   386,    -1,   630,    -1,   631,   421,
     630,    -1,   631,   630,    -1,   631,    -1,    -1,   134,   589,
     379,   775,   496,    93,   669,    -1,   236,   782,    -1,   134,
     145,   778,   383,   636,    -1,   134,   145,   778,    -1,   637,
      -1,   636,   637,    -1,   344,   638,   777,    -1,   344,   638,
     151,    -1,   238,   638,   794,    -1,   238,   638,   151,    -1,
     346,   638,   777,    -1,   346,   638,   151,    -1,   167,   638,
     795,    -1,   167,   638,   151,    -1,   281,   638,   777,    -1,
     281,   638,   151,    -1,   402,    -1,    -1,    87,   145,   778,
     325,   448,    -1,    87,   145,   778,   459,    -1,   164,   145,
     778,    -1,   134,   162,   560,   643,   705,   488,    -1,    87,
     162,   560,   469,    -1,    87,   162,   560,   164,   257,   262,
      -1,    87,   162,   560,   325,   257,   262,    -1,    87,   162,
     560,    82,   494,    -1,    87,   162,   560,   164,   129,   777,
     470,    -1,    93,    -1,    -1,   134,   554,   131,   560,   183,
     794,   351,   794,   188,   560,    -1,   122,   781,   271,   775,
      -1,   122,   775,    -1,   122,    -1,   373,   650,   651,   649,
      -1,   373,   650,   651,   649,   775,    -1,   373,   650,   651,
     649,   647,    -1,   648,   649,    -1,   648,   649,   775,   652,
      -1,    89,    -1,    88,    -1,   378,    -1,    -1,   189,    -1,
      -1,   187,    -1,    -1,   415,   776,   416,    -1,    -1,   176,
     655,   649,   654,    -1,   669,    -1,   656,    -1,   665,    -1,
     660,    -1,   666,    -1,   648,    -1,    -1,   213,   219,   775,
     657,    -1,   375,   415,   771,   416,    -1,   151,   375,    -1,
     669,    -1,   415,   658,   416,   375,   415,   771,   416,    -1,
     415,   658,   416,   669,    -1,   658,   421,   659,    -1,   659,
      -1,   909,   763,    -1,   156,   188,   700,   702,    -1,   239,
     676,   774,   662,   664,    -1,   203,   663,   244,    -1,    -1,
      80,   327,    -1,   312,   327,    -1,   312,   172,    -1,   327,
     369,   172,    -1,   327,    -1,   327,   312,   172,    -1,   172,
      -1,    80,   172,    -1,   261,    -1,    -1,   369,   700,   325,
     767,   692,   702,    -1,   150,   777,   667,   143,   668,   183,
     669,    -1,    -1,   667,   104,    -1,   667,   212,    -1,   667,
     317,    -1,   667,   253,   317,    -1,    -1,   383,   197,    -1,
     384,   197,    -1,   671,    -1,   670,    -1,   415,   671,   416,
      -1,   415,   670,   416,    -1,   673,    -1,   672,   680,    -1,
     672,   679,   689,   684,    -1,   672,   679,   683,   690,    -1,
     673,    -1,   670,    -1,   320,   678,   765,   674,   692,   702,
     687,   688,    -1,   672,   364,   677,   672,    -1,   672,   217,
     677,   672,    -1,   672,   171,   677,   672,    -1,   219,   675,
      -1,   872,    -1,    -1,   347,   676,   775,    -1,   345,   676,
     775,    -1,   237,   347,   676,   775,    -1,   237,   345,   676,
     775,    -1,   192,   347,   676,   775,    -1,   192,   345,   676,
     775,    -1,   343,   775,    -1,   775,    -1,   343,    -1,    -1,
      85,    -1,    -1,   160,    -1,   160,   271,   415,   741,   416,
      -1,    85,    -1,    -1,   680,    -1,    -1,   276,   108,   681,
      -1,   682,    -1,   681,   421,   682,    -1,   730,   372,   739,
      -1,   730,    94,    -1,   730,   159,    -1,   730,    -1,   234,
     685,   268,   686,    -1,   268,   686,   234,   685,    -1,   234,
     685,    -1,   268,   686,    -1,   234,   685,   421,   686,    -1,
     683,    -1,    -1,   730,    -1,    85,    -1,   730,    -1,   194,
     108,   741,    -1,    -1,   196,   730,    -1,    -1,   183,   369,
     691,    -1,   183,   295,   272,    -1,   689,    -1,    -1,   266,
     776,    -1,    -1,   188,   693,    -1,    -1,   693,   421,   694,
      -1,   694,    -1,   700,    -1,   700,   696,    -1,   701,    -1,
     701,   696,    -1,   701,    93,   415,   703,   416,    -1,   701,
      93,   909,   415,   703,   416,    -1,   701,   909,   415,   703,
     416,    -1,   670,    -1,   670,   696,    -1,   695,    -1,   415,
     695,   416,   696,    -1,   415,   695,   416,    -1,   694,   137,
     224,   694,    -1,   694,   389,   694,    -1,   694,   697,   224,
     694,   699,    -1,   694,   224,   694,   699,    -1,   694,   249,
     697,   224,   694,    -1,   694,   249,   224,   694,    -1,    93,
     909,   415,   776,   416,    -1,    93,   909,    -1,   909,   415,
     776,   416,    -1,   909,    -1,   189,   698,    -1,   231,   698,
      -1,   310,   698,    -1,   209,    -1,   278,    -1,    -1,   372,
     415,   776,   416,    -1,   271,   730,    -1,   775,    -1,   775,
     408,    -1,   272,   775,    -1,   272,   415,   775,   416,    -1,
     733,    -1,   382,   730,    -1,    -1,   704,    -1,   703,   421,
     704,    -1,   909,   705,    -1,   708,   706,    -1,   326,   708,
     706,    -1,   708,    92,   413,   790,   414,    -1,   326,   708,
      92,   413,   790,   414,    -1,   413,   414,   706,    -1,   413,
     707,   414,   706,    -1,    -1,   790,    -1,   415,   707,   416,
      -1,   707,   406,   707,    -1,   707,   407,   707,    -1,   707,
     408,   707,    -1,   707,   409,   707,    -1,   707,   410,   707,
      -1,   789,    -1,   909,    -1,   710,    -1,   726,    -1,   711,
      -1,   715,    -1,   719,    -1,   727,   729,    -1,   727,   415,
     790,   416,   729,    -1,   910,   561,    -1,   710,    -1,   726,
      -1,   711,    -1,   716,    -1,   720,    -1,   910,    -1,   215,
      -1,   216,    -1,   331,    -1,   103,    -1,   296,    -1,   182,
     712,    -1,   163,   286,    -1,   149,   714,    -1,   148,   714,
      -1,   264,   713,    -1,   106,    -1,   415,   790,   416,    -1,
      -1,   415,   790,   421,   790,   416,    -1,   415,   790,   416,
      -1,    -1,   415,   790,   421,   790,   416,    -1,   415,   790,
     416,    -1,    -1,   717,    -1,   718,    -1,   717,    -1,   718,
      -1,   105,   724,   415,   790,   416,    -1,   105,   724,    -1,
     721,    -1,   722,    -1,   721,    -1,   722,    -1,   723,   415,
     790,   416,   725,    -1,   723,   725,    -1,   116,   724,    -1,
     115,   724,    -1,   376,    -1,   248,   116,   724,    -1,   248,
     115,   724,    -1,   250,   724,    -1,   377,    -1,    -1,   116,
     325,   909,    -1,    -1,   350,   415,   790,   416,   728,    -1,
     350,   728,    -1,   349,   415,   790,   416,   728,    -1,   349,
     728,    -1,   218,    -1,   383,   349,   388,    -1,   384,   349,
     388,    -1,    -1,   387,    -1,   245,    -1,   146,    -1,   198,
      -1,   242,    -1,   318,    -1,   387,   351,   245,    -1,   146,
     351,   198,    -1,   146,   351,   242,    -1,   146,   351,   318,
      -1,   198,   351,   242,    -1,   242,   351,   318,    -1,   198,
     351,   318,    -1,    -1,   732,    -1,   730,    77,   705,    -1,
     730,    97,   349,   388,   732,    -1,   406,   730,    -1,   407,
     730,    -1,   410,   730,    -1,   411,   730,    -1,   730,   410,
      -1,   730,   411,    -1,   730,   406,   730,    -1,   730,   407,
     730,    -1,   730,   408,   730,    -1,   730,   409,   730,    -1,
     730,   410,   730,    -1,   730,   411,   730,    -1,   730,   403,
     730,    -1,   730,   404,   730,    -1,   730,   402,   730,    -1,
     730,   738,   730,    -1,   738,   730,    -1,   730,   738,    -1,
     730,    90,   730,    -1,   730,   275,   730,    -1,   257,   730,
      -1,   730,   233,   730,    -1,   730,   233,   730,   170,   730,
      -1,   730,   257,   233,   730,    -1,   730,   257,   233,   730,
     170,   730,    -1,   730,   199,   730,    -1,   730,   199,   730,
     170,   730,    -1,   730,   257,   199,   730,    -1,   730,   257,
     199,   730,   170,   730,    -1,   730,   329,   351,   730,    -1,
     730,   329,   351,   730,   170,   730,    -1,   730,   257,   329,
     351,   730,    -1,   730,   257,   329,   351,   730,   170,   730,
      -1,   730,   222,    -1,   730,   221,   262,    -1,   730,   260,
      -1,   730,   221,   257,   262,    -1,   730,   221,   358,    -1,
     730,   221,   257,   358,    -1,   730,   221,   179,    -1,   730,
     221,   257,   179,    -1,   730,   221,   366,    -1,   730,   221,
     257,   366,    -1,   730,   221,   160,   188,   730,    -1,   730,
     221,   266,   415,   743,   416,    -1,   730,   221,   257,   266,
     415,   743,   416,    -1,   730,   102,   731,    90,   731,    -1,
     730,   257,   102,   731,    90,   731,    -1,   730,   203,   754,
      -1,   730,   257,   203,   754,    -1,   730,   740,   735,   670,
      -1,   730,   740,   735,   415,   730,   416,    -1,   365,   670,
      -1,   732,    -1,   731,    77,   705,    -1,   407,   731,    -1,
     410,   731,    -1,   411,   731,    -1,   731,   410,    -1,   731,
     411,    -1,   731,   406,   731,    -1,   731,   407,   731,    -1,
     731,   408,   731,    -1,   731,   409,   731,    -1,   731,   410,
     731,    -1,   731,   411,   731,    -1,   731,   403,   731,    -1,
     731,   404,   731,    -1,   731,   402,   731,    -1,   731,   392,
     731,    -1,   738,   731,    -1,   731,   738,    -1,   731,   221,
     160,   188,   731,    -1,   731,   221,   266,   415,   731,   416,
      -1,   731,   221,   257,   266,   415,   731,   416,    -1,   760,
      -1,   784,    -1,   400,   763,    -1,   415,   730,   416,   763,
      -1,   755,    -1,   733,    -1,   670,    -1,   175,   670,    -1,
      92,   670,    -1,    92,   745,    -1,   734,    -1,   783,   415,
     416,    -1,   783,   415,   741,   416,    -1,   783,   415,    85,
     741,   416,    -1,   783,   415,   160,   741,   416,    -1,   783,
     415,   408,   416,    -1,   139,    -1,   140,   764,    -1,   140,
     415,   790,   416,    -1,   141,   764,    -1,   141,   415,   790,
     416,    -1,   142,   764,    -1,   324,   764,    -1,   371,   764,
      -1,   113,   415,   730,    93,   705,   416,    -1,   178,   415,
     742,   416,    -1,   280,   415,   747,   416,    -1,   285,   415,
     749,   416,    -1,   341,   415,   750,   416,    -1,   355,   415,
     730,    93,   705,   416,    -1,   357,   415,   107,   753,   416,
      -1,   357,   415,   230,   753,   416,    -1,   357,   415,   353,
     753,   416,    -1,   357,   415,   753,   416,    -1,   132,   415,
     730,   372,   560,   416,    -1,   132,   415,   741,   416,    -1,
     263,   415,   730,   421,   730,   416,    -1,   123,   415,   741,
     416,    -1,   312,   415,   741,   416,    -1,   312,   415,   416,
      -1,   415,   741,   421,   730,   416,    -1,    91,    -1,   332,
      -1,    85,    -1,   392,    -1,   737,    -1,   406,    -1,   407,
      -1,   408,    -1,   410,    -1,   411,    -1,   409,    -1,   403,
      -1,   404,    -1,   402,    -1,   392,    -1,   273,   415,   606,
     416,    -1,   736,    -1,   273,   415,   606,   416,    -1,   736,
      -1,   273,   415,   606,   416,    -1,   233,    -1,   257,   233,
      -1,   199,    -1,   257,   199,    -1,   730,    -1,   741,   421,
     730,    -1,   746,   188,   730,    -1,    -1,   743,   421,   705,
      -1,   705,    -1,   745,    -1,   744,   421,   745,    -1,   413,
     741,   414,    -1,   413,   744,   414,    -1,   930,    -1,   387,
      -1,   245,    -1,   146,    -1,   198,    -1,   242,    -1,   318,
      -1,   794,    -1,   730,   748,   751,   752,    -1,   730,   748,
     751,    -1,   284,   730,    -1,   731,   203,   731,    -1,    -1,
     730,   751,   752,    -1,   730,   752,   751,    -1,   730,   751,
      -1,   730,   752,    -1,   741,    -1,    -1,   188,   730,    -1,
     183,   730,    -1,   730,   188,   741,    -1,   188,   741,    -1,
     741,    -1,   670,    -1,   415,   741,   416,    -1,   112,   759,
     756,   758,   169,    -1,   756,   757,    -1,   757,    -1,   381,
     730,   348,   730,    -1,   166,   730,    -1,    -1,   730,    -1,
      -1,   773,    -1,   773,   762,    -1,   417,   780,    -1,   417,
     408,    -1,   413,   730,   414,    -1,   413,   730,   423,   730,
     414,    -1,   761,    -1,   762,   761,    -1,    -1,   763,   761,
      -1,   415,   416,    -1,    -1,   765,   421,   766,    -1,   766,
      -1,   730,    93,   912,    -1,   730,    -1,   408,    -1,   767,
     421,   770,    -1,   415,   768,   416,   402,   415,   769,   416,
      -1,   770,    -1,   909,   763,    -1,   909,   763,   421,   768,
      -1,   730,    -1,   730,   421,   769,    -1,   909,   763,   402,
     730,    -1,   909,   763,   402,   151,    -1,   771,   421,   772,
      -1,   772,    -1,   730,    -1,   151,    -1,   800,    -1,   909,
      -1,   775,    -1,   774,   421,   775,    -1,   773,    -1,   773,
     762,    -1,   777,    -1,   776,   421,   777,    -1,   909,    -1,
     909,    -1,   909,    -1,   912,    -1,   909,    -1,   794,    -1,
     911,    -1,   773,   762,    -1,   798,    -1,   709,   794,    -1,
     727,   794,   729,    -1,   727,   415,   790,   416,   794,   729,
      -1,   358,    -1,   179,    -1,   262,    -1,   926,    -1,   399,
      -1,   401,    -1,   397,    -1,   398,    -1,   391,    -1,   785,
      -1,   927,    -1,   790,    -1,   407,   790,    -1,   785,    -1,
     929,    -1,   786,    -1,   792,    -1,   407,   786,    -1,   407,
     785,    -1,   789,    -1,   789,    -1,   927,    -1,   785,    -1,
     789,    -1,   927,    -1,   786,    -1,   785,    -1,   407,   786,
      -1,   407,   785,    -1,   927,    -1,   789,    -1,   796,    -1,
     789,    -1,   786,    -1,   785,    -1,   787,    -1,   788,    -1,
     927,    -1,   909,    -1,   270,    -1,   251,    -1,     9,   351,
     802,   808,   809,    -1,     9,   351,   151,    -1,     9,   810,
      -1,   145,   802,    -1,   778,   805,   807,    -1,   803,   423,
     804,   807,   409,   778,   813,    -1,   789,    -1,   812,    -1,
     930,   929,    -1,   392,   806,    -1,   804,    -1,    -1,   909,
      -1,   909,   417,   806,    -1,   396,    -1,   423,   790,    -1,
      -1,    93,   802,    -1,    -1,   371,   810,    -1,    -1,   811,
      -1,   811,   409,   811,    -1,   811,    25,   108,   811,    -1,
     811,   372,   811,    -1,   799,    -1,   794,    -1,   929,    -1,
     392,   909,    -1,    -1,   150,   777,   667,   143,   668,   183,
     864,    -1,   147,   288,   864,    -1,   147,   864,    -1,   817,
      -1,   831,    -1,   818,    -1,    -1,   836,   839,   819,   852,
     418,    -1,    -1,   839,   820,   852,   418,    -1,   842,   418,
      -1,   796,    -1,   421,   796,    -1,    -1,   729,    -1,   387,
     351,   242,    -1,   387,   351,   318,    -1,   146,   351,   146,
      -1,   245,   351,   245,    -1,    -1,   826,   825,   828,   827,
      -1,   923,   101,   150,    39,   418,    -1,   923,   169,   150,
      39,   418,    -1,    -1,   829,    -1,   395,    -1,   833,    -1,
     831,    -1,   829,   833,    -1,   829,   831,    -1,   829,   395,
      -1,   833,    -1,   830,   833,    -1,    -1,    76,   832,   839,
     855,   913,   706,   418,    -1,    -1,   836,   839,   834,   852,
     418,    -1,    -1,   839,   835,   852,   418,    -1,   842,   418,
      -1,   837,   838,    -1,   837,    -1,   838,    -1,    62,    -1,
      73,    -1,    71,    -1,    56,    -1,    57,    -1,    75,    -1,
     848,    -1,   844,    -1,   840,    -1,   913,   415,   821,   822,
     416,    -1,   913,   823,    -1,   846,    -1,    20,   908,   841,
      -1,    20,   841,    -1,    20,   908,    -1,   419,   934,   420,
      -1,    -1,   846,   843,   419,   830,   420,    -1,   842,    -1,
      -1,   847,   845,   419,   830,   420,    -1,    48,   908,    -1,
     364,   908,    -1,    48,    -1,   364,    -1,   849,    -1,   851,
     850,    -1,    49,    40,    -1,    49,    40,   215,    -1,    49,
      -1,    49,   215,    -1,    49,    29,    -1,    49,    29,   215,
      -1,    49,    29,    29,    -1,    49,    29,    29,   215,    -1,
      49,   115,    -1,    40,    -1,    40,   215,    -1,   215,    -1,
      29,    -1,    29,   215,    -1,    29,    29,    -1,    29,    29,
     215,    -1,     5,    -1,   115,    -1,   163,    -1,    41,    -1,
      -1,   853,    -1,   852,   421,   853,    -1,   855,   914,   706,
     854,    -1,    -1,   402,   935,    -1,    -1,   408,    -1,   408,
     408,    -1,   150,   335,   930,    -1,    19,   858,    -1,   859,
      -1,    13,    -1,    85,    -1,    -1,   802,    -1,   151,    -1,
     174,   200,   863,    -1,    -1,   174,   864,   861,   862,    -1,
     868,   872,    -1,   872,   868,    -1,   868,    -1,   872,    -1,
      -1,   812,    -1,   393,    -1,   777,    -1,   812,    -1,    22,
     777,    -1,    33,   777,   867,    -1,    -1,   868,    -1,   372,
     873,    -1,   869,    -1,   372,   871,    18,   931,    -1,   219,
     871,    18,   931,    -1,    -1,    42,    -1,   219,   922,    -1,
     870,    -1,   874,    -1,   874,   421,   873,    -1,   797,    -1,
     926,    -1,   288,   864,   188,   863,    -1,    17,   211,   777,
     869,    -1,    17,   877,   777,   869,    -1,    17,   877,   777,
     870,    -1,    34,    -1,    -1,     3,    18,   931,    -1,   147,
      18,   931,    -1,   191,    18,   931,   881,    -1,   882,    -1,
     881,   421,   882,    -1,   929,   402,   886,    -1,   325,    18,
     931,   884,    -1,   885,    -1,   884,   421,   885,    -1,   886,
     402,   792,    -1,    12,    -1,   191,    18,   931,    50,   792,
     888,    -1,   889,    -1,   888,   421,   889,    -1,   929,   402,
     893,    -1,   325,    18,   931,    50,   792,   891,    -1,   892,
      -1,   891,   421,   892,    -1,   893,   402,   793,    -1,     8,
      -1,    14,    -1,    15,    -1,    16,    -1,    26,    -1,    27,
      -1,    28,    -1,    30,    -1,    31,    -1,    32,    -1,   286,
      -1,    36,    -1,    37,    -1,    38,    -1,   361,    -1,   325,
       4,   402,   895,    -1,   325,     4,   351,   895,    -1,   271,
      -1,   267,    -1,   325,    10,   351,   859,    -1,   325,    10,
     402,   859,    -1,   325,    10,   859,    -1,    -1,   361,   898,
     913,   221,   839,   706,   899,    -1,    35,    -1,    -1,    -1,
      51,   901,   912,   221,   839,   706,   899,    -1,    52,    43,
     903,    -1,    52,   257,    21,   903,    -1,    52,    45,   903,
      -1,    11,    -1,    44,    -1,    47,    -1,    24,   777,    -1,
      23,   351,   777,    -1,   161,   777,   415,   924,   416,    -1,
     161,     6,    -1,     7,   777,   415,   924,   416,    -1,     7,
     777,    -1,   905,    -1,   906,    -1,     6,    -1,     7,    -1,
       8,    -1,    11,    -1,    12,    -1,    14,    -1,    15,    -1,
      16,    -1,    21,    -1,    23,    -1,    24,    -1,    25,    -1,
      26,    -1,    27,    -1,    28,    -1,    30,    -1,    31,    -1,
      32,    -1,    36,    -1,    37,    -1,    38,    -1,    39,    -1,
      43,    -1,    44,    -1,    45,    -1,    47,    -1,    50,    -1,
       9,    -1,    17,    -1,    19,    -1,    33,    -1,    51,    -1,
      52,    -1,     5,    -1,    29,    -1,    34,    -1,    40,    -1,
      48,    -1,    41,    -1,    49,    -1,   912,    -1,   930,    -1,
     916,    -1,   919,    -1,   904,    -1,   915,    -1,   115,    -1,
     930,    -1,   916,    -1,   904,    -1,   907,    -1,   915,    -1,
     930,    -1,   916,    -1,   920,    -1,   904,    -1,   915,    -1,
     914,    -1,   907,    -1,   115,    -1,   211,    -1,   215,    -1,
     364,    -1,   351,    -1,   915,    -1,   917,    -1,   930,    -1,
     919,    -1,   920,    -1,   905,    -1,   913,    -1,   921,    -1,
     918,    -1,   906,    -1,    56,    -1,    57,    -1,    62,    -1,
      71,    -1,    73,    -1,    76,    -1,    75,    -1,   917,    -1,
     918,    -1,   146,    -1,   198,    -1,   242,    -1,   245,    -1,
     318,    -1,   387,    -1,    78,    -1,    79,    -1,    80,    -1,
      81,    -1,    82,    -1,    83,    -1,    84,    -1,    86,    -1,
      87,    -1,    95,    -1,    96,    -1,    97,    -1,    99,    -1,
     100,    -1,   101,    -1,   108,    -1,   109,    -1,   111,    -1,
     114,    -1,   117,    -1,   119,    -1,   120,    -1,   121,    -1,
     122,    -1,   126,    -1,   127,    -1,   128,    -1,   130,    -1,
     131,    -1,   133,    -1,   135,    -1,   136,    -1,   138,    -1,
     143,    -1,   144,    -1,   145,    -1,   147,    -1,   150,    -1,
     152,    -1,   154,    -1,   156,    -1,   157,    -1,   158,    -1,
     162,    -1,   163,    -1,   164,    -1,   165,    -1,   167,    -1,
     168,    -1,   170,    -1,   173,    -1,   172,    -1,   174,    -1,
     176,    -1,   180,    -1,   181,    -1,   184,    -1,   186,    -1,
     190,    -1,   192,    -1,   195,    -1,   197,    -1,   200,    -1,
     201,    -1,   202,    -1,   204,    -1,   205,    -1,   206,    -1,
     207,    -1,   212,    -1,   213,    -1,   214,    -1,   223,    -1,
     225,    -1,   226,    -1,   227,    -1,   228,    -1,   229,    -1,
     232,    -1,   235,    -1,   236,    -1,   237,    -1,   238,    -1,
     239,    -1,   240,    -1,   241,    -1,   243,    -1,   244,    -1,
     246,    -1,   247,    -1,   252,    -1,   253,    -1,   254,    -1,
     255,    -1,   258,    -1,   259,    -1,   261,    -1,   265,    -1,
     266,    -1,   269,    -1,   273,    -1,   274,    -1,   281,    -1,
     282,    -1,   283,    -1,   288,    -1,   287,    -1,   290,    -1,
     291,    -1,   292,    -1,   293,    -1,   294,    -1,   295,    -1,
     297,    -1,   299,    -1,   300,    -1,   301,    -1,   302,    -1,
     303,    -1,   304,    -1,   305,    -1,   306,    -1,   307,    -1,
     308,    -1,   309,    -1,   311,    -1,   313,    -1,   314,    -1,
     315,    -1,   316,    -1,   317,    -1,   321,    -1,   322,    -1,
     323,    -1,   325,    -1,   327,    -1,   328,    -1,   330,    -1,
     333,    -1,   334,    -1,   335,    -1,   336,    -1,   337,    -1,
     338,    -1,   339,    -1,   340,    -1,   342,    -1,   344,    -1,
     345,    -1,   346,    -1,   347,    -1,   352,    -1,   354,    -1,
     356,    -1,   359,    -1,   360,    -1,   361,    -1,   362,    -1,
     363,    -1,   366,    -1,   367,    -1,   368,    -1,   369,    -1,
     370,    -1,   373,    -1,   374,    -1,   375,    -1,   377,    -1,
     379,    -1,   383,    -1,   384,    -1,   385,    -1,   386,    -1,
     388,    -1,   103,    -1,   105,    -1,   116,    -1,   123,    -1,
     132,    -1,   148,    -1,   149,    -1,   175,    -1,   178,    -1,
     182,    -1,   210,    -1,   216,    -1,   218,    -1,   248,    -1,
     250,    -1,   256,    -1,   263,    -1,   264,    -1,   277,    -1,
     280,    -1,   285,    -1,   286,    -1,   296,    -1,   312,    -1,
     326,    -1,   331,    -1,   341,    -1,   349,    -1,   350,    -1,
     355,    -1,   357,    -1,   376,    -1,    98,    -1,   102,    -1,
     104,    -1,   137,    -1,   187,    -1,   189,    -1,   199,    -1,
     209,    -1,   221,    -1,   222,    -1,   224,    -1,   231,    -1,
     233,    -1,   249,    -1,   260,    -1,   278,    -1,   279,    -1,
     310,    -1,   329,    -1,   378,    -1,    85,    -1,    88,    -1,
      89,    -1,    90,    -1,    91,    -1,    92,    -1,    93,    -1,
      94,    -1,   107,    -1,   112,    -1,   113,    -1,   118,    -1,
     124,    -1,   125,    -1,   129,    -1,   134,    -1,   139,    -1,
     140,    -1,   141,    -1,   142,    -1,   151,    -1,   153,    -1,
     159,    -1,   160,    -1,   161,    -1,   166,    -1,   169,    -1,
     171,    -1,   179,    -1,   183,    -1,   185,    -1,   188,    -1,
     193,    -1,   194,    -1,   196,    -1,   203,    -1,   208,    -1,
     217,    -1,   219,    -1,   230,    -1,   234,    -1,   251,    -1,
     257,    -1,   262,    -1,   267,    -1,   268,    -1,   270,    -1,
     271,    -1,   272,    -1,   275,    -1,   276,    -1,   289,    -1,
     298,    -1,   320,    -1,   324,    -1,   332,    -1,   343,    -1,
     348,    -1,   353,    -1,   358,    -1,   365,    -1,   371,    -1,
     372,    -1,   381,    -1,   382,    -1,   925,    -1,   922,   421,
     925,    -1,    46,    -1,    -1,   934,    -1,   929,   928,    -1,
     929,    -1,   929,   928,    -1,   929,    -1,   929,    -1,    26,
     929,    -1,    26,   777,    -1,   394,    -1,   390,    -1,   393,
      -1,   777,    -1,   812,    -1,   937,    -1,   415,   416,    -1,
     415,   933,   416,    -1,   932,    -1,   933,   932,    -1,   935,
      -1,   934,   421,   935,    -1,   933,    -1,   419,   934,   420,
      -1,   937,    -1,   415,    -1,   416,    -1,   421,    -1,   418,
      -1,   390,    -1,   393,    -1,   785,    -1,   786,    -1,   789,
      -1,   408,    -1,   406,    -1,   407,    -1,   409,    -1,   410,
      -1,   262,    -1,    53,    -1,    54,    -1,    55,    -1,    56,
      -1,    57,    -1,    58,    -1,    59,    -1,    60,    -1,    61,
      -1,    62,    -1,    63,    -1,    64,    -1,    66,    -1,    65,
      -1,    67,    -1,    68,    -1,    69,    -1,    70,    -1,    71,
      -1,    72,    -1,    73,    -1,    74,    -1,    76,    -1,    75,
      -1,     5,    -1,    20,    -1,   198,    -1,   215,    -1,    29,
      -1,   242,    -1,   245,    -1,   318,    -1,    40,    -1,    41,
      -1,    48,    -1,    49,    -1,   387,    -1,   115,    -1,   182,
      -1,   351,    -1,   364,    -1,   376,    -1,   413,    -1,   414,
      -1,   402,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   591,   591,   593,   594,   597,   598,   599,   605,   606,
     607,   608,   609,   612,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   633,   634,   656,   657,   658,   659,   660,
     661,   662,   663,   664,   665,   666,   667,   668,   669,   670,
     671,   672,   673,   674,   675,   677,   678,   679,   680,   681,
     682,   683,   684,   685,   686,   687,   688,   689,   690,   691,
     693,   694,   695,   696,   697,   698,   699,   700,   702,   703,
     704,   705,   706,   707,   708,   709,   710,   716,   717,   718,
     719,   720,   721,   722,   723,   724,   730,   740,   744,   752,
     760,   764,   775,   785,   789,   796,   803,   809,   817,   827,
     833,   842,   849,   855,   864,   871,   892,   896,   897,   908,
     910,   914,   916,   926,   933,   934,   937,   939,   941,   943,
     945,   947,   949,   951,   955,   957,   967,   969,   976,   977,
     980,   982,   993,   995,  1005,  1016,  1018,  1022,  1023,  1026,
    1027,  1034,  1035,  1036,  1037,  1038,  1039,  1052,  1054,  1056,
    1060,  1062,  1064,  1066,  1068,  1070,  1072,  1074,  1078,  1079,
    1083,  1085,  1089,  1091,  1095,  1096,  1097,  1098,  1101,  1102,
    1103,  1106,  1107,  1108,  1109,  1119,  1120,  1121,  1123,  1125,
    1127,  1131,  1132,  1133,  1136,  1137,  1140,  1142,  1144,  1146,
    1148,  1152,  1154,  1156,  1158,  1160,  1164,  1168,  1170,  1174,
    1175,  1181,  1192,  1194,  1200,  1201,  1205,  1209,  1212,  1215,
    1218,  1221,  1224,  1227,  1230,  1233,  1236,  1239,  1242,  1245,
    1249,  1250,  1256,  1259,  1264,  1265,  1268,  1269,  1270,  1273,
    1274,  1284,  1298,  1303,  1304,  1312,  1313,  1314,  1317,  1318,
    1321,  1322,  1323,  1325,  1327,  1328,  1330,  1332,  1334,  1339,
    1340,  1343,  1344,  1351,  1354,  1357,  1358,  1368,  1371,  1381,
    1382,  1383,  1384,  1385,  1386,  1387,  1391,  1394,  1396,  1398,
    1402,  1403,  1404,  1407,  1413,  1414,  1417,  1419,  1420,  1434,
    1436,  1438,  1440,  1442,  1444,  1446,  1461,  1462,  1463,  1464,
    1467,  1474,  1475,  1476,  1483,  1485,  1489,  1491,  1493,  1495,
    1500,  1501,  1504,  1506,  1510,  1513,  1515,  1521,  1524,  1525,
    1526,  1527,  1528,  1531,  1535,  1539,  1540,  1541,  1542,  1543,
    1546,  1549,  1552,  1553,  1554,  1557,  1558,  1559,  1560,  1563,
    1564,  1567,  1568,  1577,  1576,  1594,  1595,  1596,  1600,  1603,
    1606,  1608,  1612,  1623,  1627,  1631,  1632,  1635,  1637,  1639,
    1641,  1643,  1645,  1647,  1649,  1651,  1653,  1657,  1658,  1669,
    1674,  1675,  1682,  1683,  1686,  1689,  1692,  1696,  1697,  1707,
    1711,  1712,  1726,  1737,  1742,  1750,  1751,  1754,  1756,  1758,
    1762,  1763,  1764,  1767,  1770,  1773,  1774,  1777,  1778,  1781,
    1783,  1786,  1789,  1790,  1793,  1794,  1797,  1798,  1805,  1806,
    1815,  1817,  1821,  1823,  1827,  1838,  1846,  1861,  1863,  1865,
    1867,  1871,  1875,  1879,  1880,  1883,  1884,  1888,  1889,  1890,
    1893,  1900,  1901,  1904,  1906,  1908,  1910,  1914,  1915,  1918,
    1919,  1922,  1934,  1938,  1939,  1940,  1941,  1942,  1943,  1944,
    1945,  1948,  1950,  1954,  1955,  1958,  1959,  1968,  1983,  1988,
    1993,  1998,  2003,  2008,  2013,  2018,  2023,  2025,  2029,  2030,
    2031,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2042,  2045,  2048,  2049,  2052,  2054,  2056,  2058,  2060,
    2062,  2064,  2066,  2068,  2070,  2072,  2076,  2077,  2078,  2079,
    2080,  2081,  2082,  2083,  2084,  2085,  2088,  2089,  2099,  2103,
    2110,  2111,  2112,  2115,  2117,  2121,  2122,  2123,  2124,  2125,
    2126,  2127,  2128,  2129,  2130,  2131,  2132,  2135,  2137,  2139,
    2141,  2143,  2145,  2147,  2151,  2153,  2157,  2158,  2161,  2166,
    2169,  2174,  2177,  2179,  2183,  2194,  2199,  2200,  2203,  2206,
    2209,  2210,  2213,  2215,  2217,  2221,  2222,  2223,  2226,  2231,
    2232,  2235,  2237,  2241,  2243,  2247,  2248,  2251,  2252,  2258,
    2265,  2268,  2270,  2274,  2276,  2286,  2288,  2293,  2295,  2299,
    2301,  2303,  2305,  2307,  2309,  2311,  2313,  2315,  2317,  2319,
    2321,  2325,  2326,  2339,  2343,  2347,  2348,  2352,  2356,  2358,
    2360,  2362,  2367,  2369,  2373,  2376,  2381,  2382,  2386,  2397,
    2399,  2403,  2404,  2407,  2408,  2419,  2421,  2423,  2425,  2427,
    2429,  2431,  2433,  2435,  2437,  2439,  2441,  2443,  2445,  2449,
    2450,  2459,  2461,  2463,  2465,  2467,  2469,  2471,  2473,  2475,
    2477,  2489,  2488,  2498,  2499,  2500,  2504,  2506,  2510,  2511,
    2512,  2513,  2514,  2517,  2518,  2522,  2523,  2524,  2525,  2528,
    2529,  2530,  2533,  2545,  2549,  2553,  2555,  2568,  2569,  2570,
    2571,  2572,  2573,  2574,  2575,  2576,  2577,  2578,  2582,  2583,
    2584,  2588,  2590,  2591,  2595,  2596,  2597,  2601,  2602,  2612,
    2624,  2636,  2638,  2642,  2644,  2648,  2650,  2652,  2654,  2656,
    2658,  2660,  2662,  2664,  2666,  2670,  2671,  2682,  2684,  2695,
    2706,  2713,  2715,  2717,  2719,  2721,  2725,  2726,  2730,  2744,
    2746,  2748,  2761,  2763,  2765,  2769,  2771,  2775,  2776,  2779,
    2780,  2783,  2784,  2787,  2788,  2791,  2794,  2805,  2810,  2811,
    2812,  2813,  2814,  2818,  2819,  2868,  2872,  2874,  2876,  2878,
    2880,  2884,  2886,  2890,  2902,  2906,  2910,  2913,  2916,  2917,
    2918,  2919,  2920,  2921,  2922,  2923,  2926,  2927,  2937,  2951,
    2982,  2983,  2984,  2985,  2986,  2989,  2993,  2994,  3004,  3006,
    3010,  3012,  3016,  3018,  3020,  3022,  3026,  3027,  3030,  3034,
    3036,  3038,  3042,  3047,  3048,  3058,  3060,  3062,  3064,  3066,
    3068,  3070,  3072,  3076,  3077,  3080,  3081,  3084,  3086,  3088,
    3091,  3094,  3095,  3098,  3102,  3103,  3106,  3108,  3110,  3112,
    3116,  3118,  3120,  3122,  3124,  3128,  3129,  3132,  3133,  3136,
    3146,  3149,  3152,  3155,  3158,  3160,  3164,  3165,  3168,  3169,
    3180,  3181,  3184,  3185,  3195,  3197,  3199,  3201,  3203,  3205,
    3207,  3209,  3211,  3213,  3215,  3236,  3238,  3240,  3242,  3244,
    3246,  3248,  3252,  3254,  3256,  3258,  3262,  3263,  3264,  3265,
    3269,  3270,  3280,  3282,  3286,  3288,  3290,  3292,  3296,  3299,
    3300,  3303,  3305,  3309,  3322,  3324,  3326,  3328,  3333,  3339,
    3346,  3353,  3354,  3355,  3356,  3357,  3358,  3359,  3360,  3361,
    3364,  3365,  3366,  3367,  3368,  3369,  3371,  3373,  3377,  3378,
    3379,  3380,  3381,  3384,  3392,  3394,  3396,  3398,  3400,  3402,
    3404,  3406,  3408,  3410,  3412,  3416,  3419,  3422,  3424,  3427,
    3430,  3432,  3435,  3443,  3444,  3447,  3448,  3451,  3455,  3464,
    3465,  3468,  3469,  3472,  3476,  3480,  3482,  3484,  3486,  3488,
    3490,  3494,  3497,  3500,  3503,  3506,  3508,  3510,  3512,  3516,
    3520,  3522,  3525,  3528,  3529,  3530,  3531,  3532,  3533,  3534,
    3535,  3536,  3537,  3538,  3539,  3540,  3541,  3567,  3569,  3571,
    3582,  3584,  3586,  3588,  3590,  3592,  3594,  3596,  3598,  3600,
    3602,  3604,  3606,  3608,  3610,  3612,  3614,  3616,  3618,  3620,
    3622,  3624,  3626,  3628,  3630,  3632,  3634,  3636,  3638,  3640,
    3642,  3644,  3646,  3648,  3650,  3652,  3654,  3665,  3667,  3669,
    3671,  3673,  3675,  3677,  3679,  3681,  3683,  3685,  3687,  3689,
    3691,  3693,  3695,  3707,  3709,  3711,  3713,  3715,  3717,  3719,
    3721,  3723,  3725,  3727,  3729,  3731,  3733,  3735,  3737,  3739,
    3741,  3743,  3745,  3747,  3749,  3761,  3763,  3765,  3767,  3769,
    3771,  3773,  3775,  3777,  3779,  3781,  3793,  3795,  3797,  3799,
    3801,  3803,  3805,  3807,  3809,  3811,  3813,  3815,  3817,  3819,
    3821,  3823,  3825,  3827,  3829,  3832,  3834,  3836,  3838,  3840,
    3842,  3844,  3846,  3851,  3853,  3855,  3859,  3860,  3861,  3864,
    3865,  3868,  3869,  3870,  3871,  3872,  3873,  3874,  3875,  3876,
    3879,  3880,  3883,  3884,  3887,  3888,  3889,  3890,  3891,  3892,
    3895,  3897,  3901,  3904,  3907,  3909,  3913,  3914,  3918,  3919,
    3925,  3926,  3927,  3928,  3929,  3930,  3931,  3932,  3936,  3938,
    3943,  3947,  3950,  3953,  3955,  3957,  3959,  3961,  3964,  3967,
    3971,  3975,  3977,  3979,  3983,  3985,  3992,  3996,  3998,  4002,
    4006,  4009,  4012,  4013,  4016,  4017,  4021,  4022,  4023,  4024,
    4027,  4028,  4032,  4033,  4036,  4037,  4047,  4049,  4054,  4056,
    4058,  4063,  4065,  4089,  4093,  4102,  4113,  4121,  4131,  4133,
    4137,  4139,  4143,  4144,  4154,  4155,  4158,  4160,  4164,  4166,
    4170,  4172,  4177,  4178,  4179,  4180,  4181,  4183,  4185,  4187,
    4195,  4197,  4199,  4201,  4203,  4205,  4207,  4209,  4213,  4214,
    4215,  4216,  4217,  4228,  4229,  4232,  4233,  4236,  4244,  4247,
    4255,  4256,  4265,  4274,  4286,  4287,  4290,  4291,  4292,  4295,
    4296,  4297,  4298,  4299,  4302,  4303,  4306,  4307,  4308,  4309,
    4310,  4311,  4314,  4316,  4323,  4339,  4341,  4344,  4346,  4350,
    4358,  4374,  4381,  4387,  4399,  4408,  4409,  4412,  4413,  4414,
    4417,  4418,  4421,  4422,  4425,  4426,  4429,  4431,  4433,  4435,
    4439,  4446,  4469,  4501,  4511,  4518,  4558,  4560,  4567,  4569,
    4570,  4575,  4573,  4588,  4587,  4600,  4606,  4608,  4609,  4612,
    4613,  4614,  4615,  4616,  4623,  4622,  4632,  4634,  4636,  4637,
    4638,  4641,  4642,  4643,  4644,  4645,  4648,  4649,  4653,  4652,
    4713,  4711,  4726,  4725,  4738,  4744,  4748,  4752,  4758,  4759,
    4760,  4761,  4764,  4765,  4768,  4776,  4793,  4801,  4824,  4918,
    4952,  4954,  4956,  4960,  4964,  4963,  5014,  5016,  5015,  5030,
    5036,  5043,  5048,  5051,  5052,  5055,  5056,  5057,  5058,  5059,
    5060,  5061,  5069,  5077,  5080,  5081,  5082,  5083,  5084,  5085,
    5093,  5101,  5102,  5103,  5106,  5107,  5110,  5112,  5116,  5187,
    5188,  5195,  5196,  5197,  5203,  5212,  5215,  5216,  5217,  5218,
    5221,  5222,  5228,  5242,  5241,  5259,  5260,  5261,  5262,  5263,
    5266,  5268,  5272,  5273,  5280,  5285,  5287,  5288,  5291,  5292,
    5295,  5302,  5309,  5309,  5311,  5312,  5315,  5315,  5317,  5327,
    5336,  5342,  5348,  5354,  5362,  5363,  5375,  5385,  5396,  5400,
    5401,  5404,  5409,  5413,  5414,  5417,  5424,  5431,  5435,  5436,
    5439,  5442,  5446,  5447,  5450,  5457,  5458,  5459,  5460,  5461,
    5462,  5463,  5464,  5465,  5466,  5467,  5468,  5469,  5470,  5471,
    5501,  5502,  5505,  5506,  5513,  5514,  5515,  5522,  5521,  5580,
    5581,  5588,  5587,  5656,  5662,  5668,  5676,  5682,  5688,  5694,
    5700,  5706,  5712,  5718,  5724,  5735,  5736,  5739,  5740,  5741,
    5742,  5743,  5744,  5745,  5746,  5747,  5748,  5749,  5750,  5751,
    5752,  5753,  5754,  5755,  5756,  5757,  5758,  5759,  5760,  5761,
    5762,  5763,  5764,  5765,  5768,  5769,  5770,  5771,  5772,  5773,
    5777,  5778,  5779,  5780,  5781,  5782,  5783,  5786,  5802,  5803,
    5804,  5805,  5806,  5807,  5812,  5813,  5814,  5815,  5816,  5821,
    5822,  5823,  5824,  5825,  5831,  5832,  5833,  5834,  5835,  5836,
    5837,  5838,  5839,  5842,  5843,  5844,  5845,  5848,  5849,  5850,
    5851,  5854,  5855,  5856,  5857,  5858,  5859,  5860,  5878,  5878,
    5880,  5881,  5882,  5883,  5884,  5885,  5888,  5889,  5890,  5891,
    5892,  5893,  5894,  5895,  5896,  5897,  5898,  5899,  5900,  5901,
    5902,  5903,  5904,  5905,  5906,  5907,  5908,  5909,  5910,  5911,
    5912,  5913,  5914,  5915,  5916,  5917,  5918,  5919,  5920,  5921,
    5922,  5923,  5925,  5926,  5927,  5928,  5929,  5930,  5931,  5932,
    5933,  5934,  5935,  5936,  5937,  5938,  5939,  5940,  5941,  5942,
    5943,  5944,  5945,  5946,  5947,  5948,  5949,  5950,  5952,  5953,
    5954,  5955,  5956,  5957,  5958,  5959,  5960,  5961,  5962,  5963,
    5964,  5965,  5966,  5967,  5968,  5969,  5970,  5971,  5972,  5973,
    5974,  5975,  5977,  5978,  5980,  5981,  5982,  5983,  5984,  5985,
    5986,  5987,  5988,  5989,  5990,  5991,  5992,  5993,  5994,  5995,
    5996,  5997,  5998,  5999,  6000,  6001,  6002,  6003,  6004,  6005,
    6006,  6007,  6008,  6009,  6010,  6011,  6012,  6013,  6014,  6015,
    6016,  6017,  6018,  6019,  6020,  6021,  6022,  6024,  6025,  6026,
    6027,  6028,  6029,  6030,  6031,  6032,  6033,  6034,  6035,  6036,
    6037,  6038,  6039,  6040,  6041,  6042,  6043,  6044,  6045,  6046,
    6047,  6048,  6049,  6050,  6051,  6052,  6053,  6054,  6055,  6056,
    6057,  6058,  6059,  6060,  6061,  6062,  6063,  6064,  6065,  6067,
    6081,  6082,  6086,  6087,  6088,  6089,  6090,  6091,  6092,  6093,
    6094,  6098,  6099,  6100,  6101,  6102,  6103,  6104,  6105,  6106,
    6107,  6108,  6109,  6110,  6111,  6112,  6113,  6114,  6115,  6116,
    6117,  6118,  6132,  6133,  6134,  6135,  6136,  6137,  6138,  6139,
    6140,  6141,  6142,  6143,  6144,  6145,  6146,  6147,  6148,  6149,
    6150,  6151,  6161,  6162,  6163,  6164,  6165,  6166,  6167,  6168,
    6169,  6170,  6171,  6172,  6173,  6174,  6175,  6176,  6177,  6178,
    6179,  6180,  6181,  6182,  6183,  6184,  6185,  6186,  6187,  6188,
    6189,  6190,  6191,  6192,  6193,  6194,  6195,  6196,  6197,  6198,
    6199,  6200,  6201,  6202,  6203,  6204,  6205,  6206,  6207,  6208,
    6209,  6210,  6211,  6212,  6213,  6214,  6215,  6216,  6217,  6218,
    6222,  6223,  6227,  6228,  6229,  6230,  6231,  6235,  6235,  6238,
    6241,  6242,  6245,  6247,  6252,  6262,  6269,  6270,  6271,  6274,
    6303,  6304,  6307,  6309,  6317,  6318,  6319,  6323,  6324,  6328,
    6329,  6332,  6333,  6336,  6337,  6338,  6339,  6340,  6343,  6344,
    6345,  6346,  6347,  6348,  6349,  6350,  6351,  6352,  6353,  6354,
    6355,  6356,  6357,  6358,  6359,  6360,  6361,  6362,  6363,  6364,
    6365,  6366,  6367,  6368,  6369,  6370,  6371,  6372,  6373,  6374,
    6375,  6376,  6377,  6378,  6379,  6380,  6381,  6382,  6383,  6384,
    6385,  6386,  6387,  6388,  6389,  6390,  6391,  6392,  6393,  6394,
    6395,  6396,  6397,  6398
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", 
  "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", 
  "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", 
  "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", 
  "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", "SQL_WHENEVER", "S_ADD", 
  "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", "S_DEC", "S_DIV", 
  "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", "S_LSHIFT", "S_MEMPOINT", 
  "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", "S_OR", "S_REGISTER", 
  "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", "S_TYPEDEF", "TYPECAST", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", 
  "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "AT", "AUTHORIZATION", 
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", 
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASE", "CAST", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONSTRAINT", "CONSTRAINTS", 
  "CONVERSION_P", "CONVERT", "COPY", "CREATE", "CREATEDB", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", 
  "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", 
  "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", 
  "DISTINCT", "DO", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENCODING", "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", 
  "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", 
  "FALSE_P", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", 
  "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", 
  "GRANT", "GROUP_P", "HANDLER", "HAVING", "HOLD", "HOUR_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCATION", "LOCK_P", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", 
  "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", "NONE", "NOT", 
  "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PRIMARY", "PRIOR", "PRIVILEGES", 
  "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", "RECHECK", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", 
  "REVOKE", "RIGHT", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", 
  "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", 
  "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", "START", 
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", 
  "SUBSTRING", "SYSID", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", 
  "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", "TOAST", "TRAILING", 
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", 
  "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", 
  "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USAGE", "USER", "USING", 
  "VACUUM", "VALID", "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", 
  "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", 
  "YEAR_P", "ZONE", "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", 
  "CVARIABLE", "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", 
  "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", 
  "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", 
  "'}'", "','", "\"=\"", "':'", "$accept", "prog", "statements", 
  "statement", "opt_at", "stmt", "CreateUserStmt", "opt_with", 
  "AlterUserStmt", "AlterUserSetStmt", "DropUserStmt", "OptUserList", 
  "OptUserElem", "user_list", "CreateGroupStmt", "OptGroupList", 
  "OptGroupElem", "AlterGroupStmt", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list_or_default", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_rel_cmds", "alter_rel_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids", 
  "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "like_including_defaults", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "key_actions", "key_delete", "key_update", "key_action", 
  "OptInherit", "OptWithOids", "OnCommitOption", "OptTableSpace", 
  "OptConsTableSpace", "CreateAsStmt", "@1", "WithOidsAs", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", 
  "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_Trusted", 
  "handler_name", "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "fetch_count", 
  "from_in", "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "opt_revoke_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "createfunc_opt_item", 
  "opt_definition", "RemoveFuncStmt", "RemoveAggrStmt", "aggr_argtype", 
  "RemoveOperStmt", "oper_argtypes", "any_operator", "CreateCastStmt", 
  "cast_context", "DropCastStmt", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "AlterOwnerStmt", "RuleStmt", 
  "@2", "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "LoadStmt", 
  "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", "opt_equal", 
  "AlterDatabaseSetStmt", "DropdbStmt", "CreateDomainStmt", 
  "AlterDomainStmt", "opt_as", "CreateConversionStmt", "ClusterStmt", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "DeleteStmt", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_update_clause", "opt_for_update_clause", 
  "update_list", "from_clause", "from_list", "table_ref", "joined_table", 
  "alias_clause", "join_type", "join_outer", "join_qual", "relation_expr", 
  "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", 
  "opt_empty_parentheses", "target_list", "target_el", 
  "update_target_list", "inf_col_list", "inf_val_list", 
  "update_target_el", "insert_target_list", "insert_target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "UserId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "db_prefix", "server", "opt_server", 
  "server_name", "opt_port", "opt_connection_name", "opt_user", 
  "ora_user", "user_name", "char_variable", "opt_options", 
  "ECPGCursorStmt", "ECPGDeallocate", "ECPGVarDeclaration", 
  "single_vt_declaration", "single_var_declaration", "@3", "@4", 
  "precision", "opt_scale", "ecpg_interval", "ECPGDeclaration", "@5", 
  "sql_startdeclare", "sql_enddeclare", "var_type_declarations", 
  "vt_declarations", "variable_declarations", "type_declaration", "@6", 
  "var_declaration", "@7", "@8", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into", "using_list", "UsingConst", "ECPGPrepare", 
  "ECPGDescribe", "opt_output", "ECPGAllocateDescr", 
  "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "col_name_keyword", "func_name_keyword", "reserved_keyword", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "cvariable", "ident", "quoted_ident_stringvar", 
  "c_stuff_item", "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,    61,    60,    62,   657,    43,    45,    42,    47,
      37,    94,   658,    91,    93,    40,    41,    46,    59,   123,
     125,    44,   659,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   424,   425,   426,   426,   427,   427,   427,   427,   427,
     427,   427,   427,   428,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   430,   431,   431,   432,
     432,   433,   433,   434,   435,   435,   436,   436,   436,   436,
     436,   436,   436,   436,   437,   437,   438,   438,   439,   439,
     440,   440,   441,   441,   442,   443,   443,   444,   444,   445,
     445,   446,   446,   446,   446,   446,   446,   447,   447,   447,
     448,   448,   448,   448,   448,   448,   448,   448,   449,   449,
     450,   450,   451,   451,   452,   452,   452,   452,   453,   453,
     453,   454,   454,   454,   454,   455,   455,   455,   455,   455,
     455,   456,   456,   456,   457,   457,   458,   458,   458,   458,
     458,   459,   459,   459,   459,   459,   460,   461,   461,   462,
     462,   463,   464,   464,   465,   465,   466,   466,   466,   466,
     466,   466,   466,   466,   466,   466,   466,   466,   466,   466,
     467,   467,   468,   468,   469,   469,   470,   470,   470,   471,
     471,   472,   473,   474,   474,   475,   475,   475,   476,   476,
     477,   477,   477,   477,   477,   477,   477,   477,   477,   478,
     478,   479,   479,   480,   480,   481,   481,   482,   482,   483,
     483,   483,   483,   483,   483,   483,   484,   484,   485,   485,
     486,   486,   486,   487,   488,   488,   489,   489,   489,   490,
     490,   490,   490,   490,   490,   490,   491,   491,   491,   491,
     492,   493,   493,   493,   494,   494,   495,   495,   495,   495,
     496,   496,   497,   497,   498,   499,   499,   499,   500,   500,
     500,   500,   500,   501,   502,   503,   503,   503,   503,   503,
     504,   504,   505,   505,   505,   506,   506,   506,   506,   507,
     507,   508,   508,   510,   509,   511,   511,   511,   512,   512,
     513,   513,   514,   515,   516,   517,   517,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   519,   519,   520,
     521,   521,   522,   522,   523,   523,   524,   525,   525,   526,
     527,   527,   528,   529,   529,   530,   530,   531,   531,   531,
     532,   532,   532,   533,   533,   534,   534,   535,   535,   536,
     536,   536,   537,   537,   538,   538,   539,   539,   539,   539,
     540,   540,   541,   541,   542,   543,   544,   545,   545,   545,
     545,   546,   547,   548,   548,   549,   549,   550,   550,   550,
     551,   552,   552,   553,   553,   553,   553,   554,   554,   555,
     555,   556,   557,   558,   558,   558,   558,   558,   558,   558,
     558,   559,   559,   560,   560,   561,   561,   562,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   564,   564,
     564,   564,   564,   564,   564,   564,   564,   564,   564,   564,
     564,   564,   565,   566,   566,   567,   567,   567,   567,   567,
     567,   567,   567,   567,   567,   567,   568,   568,   568,   568,
     568,   568,   568,   568,   568,   568,   569,   569,   570,   571,
     572,   572,   572,   573,   573,   574,   574,   574,   574,   574,
     574,   574,   574,   574,   574,   574,   574,   575,   575,   575,
     575,   575,   575,   575,   576,   576,   577,   577,   578,   578,
     579,   579,   580,   580,   581,   582,   583,   583,   584,   584,
     585,   585,   586,   586,   586,   587,   587,   587,   588,   589,
     589,   590,   590,   591,   591,   592,   592,   593,   593,   593,
     593,   594,   594,   595,   596,   597,   597,   598,   598,   599,
     599,   599,   599,   599,   599,   599,   599,   599,   599,   599,
     599,   600,   600,   601,   602,   603,   603,   604,   605,   605,
     605,   605,   606,   606,   607,   607,   608,   608,   609,   610,
     610,   611,   611,   612,   612,   613,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   613,   613,   614,
     614,   615,   615,   615,   615,   615,   615,   615,   615,   615,
     615,   617,   616,   618,   618,   618,   619,   619,   620,   620,
     620,   620,   620,   621,   621,   622,   622,   622,   622,   623,
     623,   623,   624,   625,   626,   627,   627,   628,   628,   628,
     628,   628,   628,   628,   628,   628,   628,   628,   629,   629,
     629,   630,   630,   630,   631,   631,   631,   632,   632,   633,
     634,   635,   635,   636,   636,   637,   637,   637,   637,   637,
     637,   637,   637,   637,   637,   638,   638,   639,   639,   640,
     641,   642,   642,   642,   642,   642,   643,   643,   644,   645,
     645,   645,   646,   646,   646,   647,   647,   648,   648,   649,
     649,   650,   650,   651,   651,   652,   652,   653,   654,   654,
     654,   654,   654,   655,   655,   656,   657,   657,   657,   657,
     657,   658,   658,   659,   660,   661,   662,   662,   663,   663,
     663,   663,   663,   663,   663,   663,   664,   664,   665,   666,
     667,   667,   667,   667,   667,   668,   668,   668,   669,   669,
     670,   670,   671,   671,   671,   671,   672,   672,   673,   673,
     673,   673,   674,   674,   674,   675,   675,   675,   675,   675,
     675,   675,   675,   676,   676,   677,   677,   678,   678,   678,
     678,   679,   679,   680,   681,   681,   682,   682,   682,   682,
     683,   683,   683,   683,   683,   684,   684,   685,   685,   686,
     687,   687,   688,   688,   689,   689,   690,   690,   691,   691,
     692,   692,   693,   693,   694,   694,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   695,   695,   695,   695,   695,
     695,   695,   696,   696,   696,   696,   697,   697,   697,   697,
     698,   698,   699,   699,   700,   700,   700,   700,   701,   702,
     702,   703,   703,   704,   705,   705,   705,   705,   706,   706,
     706,   707,   707,   707,   707,   707,   707,   707,   707,   707,
     708,   708,   708,   708,   708,   708,   708,   708,   709,   709,
     709,   709,   709,   710,   711,   711,   711,   711,   711,   711,
     711,   711,   711,   711,   711,   712,   712,   713,   713,   713,
     714,   714,   714,   715,   715,   716,   716,   717,   718,   719,
     719,   720,   720,   721,   722,   723,   723,   723,   723,   723,
     723,   724,   724,   725,   725,   726,   726,   726,   726,   727,
     728,   728,   728,   729,   729,   729,   729,   729,   729,   729,
     729,   729,   729,   729,   729,   729,   729,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   731,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   732,   732,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   734,   734,   734,   735,   735,   735,   736,
     736,   737,   737,   737,   737,   737,   737,   737,   737,   737,
     738,   738,   739,   739,   740,   740,   740,   740,   740,   740,
     741,   741,   742,   742,   743,   743,   744,   744,   745,   745,
     746,   746,   746,   746,   746,   746,   746,   746,   747,   747,
     748,   749,   749,   750,   750,   750,   750,   750,   750,   751,
     752,   753,   753,   753,   754,   754,   755,   756,   756,   757,
     758,   758,   759,   759,   760,   760,   761,   761,   761,   761,
     762,   762,   763,   763,   764,   764,   765,   765,   766,   766,
     766,   767,   767,   767,   768,   768,   769,   769,   770,   770,
     771,   771,   772,   772,   773,   773,   774,   774,   775,   775,
     776,   776,   777,   778,   779,   780,   781,   782,   783,   783,
     784,   784,   784,   784,   784,   784,   784,   784,   785,   786,
     787,   788,   789,   790,   790,   791,   791,   792,   792,   793,
     793,   793,   793,   793,   794,   794,   795,   795,   795,   796,
     796,   796,   796,   796,   797,   797,   798,   798,   798,   798,
     798,   798,   799,   800,   800,   801,   801,   801,   801,   802,
     802,   802,   802,   803,   804,   805,   805,   806,   806,   806,
     807,   807,   808,   808,   809,   809,   810,   810,   810,   810,
     811,   811,   812,   813,   813,   814,   815,   815,   816,   817,
     817,   819,   818,   820,   818,   818,   821,   822,   822,   823,
     823,   823,   823,   823,   825,   824,   826,   827,   828,   828,
     828,   829,   829,   829,   829,   829,   830,   830,   832,   831,
     834,   833,   835,   833,   833,   836,   836,   836,   837,   837,
     837,   837,   838,   838,   839,   839,   839,   839,   839,   839,
     840,   840,   840,   841,   843,   842,   844,   845,   844,   846,
     846,   847,   847,   848,   848,   849,   849,   849,   849,   849,
     849,   849,   849,   849,   850,   850,   850,   850,   850,   850,
     850,   850,   850,   850,   851,   851,   852,   852,   853,   854,
     854,   855,   855,   855,   856,   857,   858,   858,   858,   858,
     859,   859,   860,   861,   860,   862,   862,   862,   862,   862,
     863,   863,   864,   864,   865,   866,   867,   867,   868,   868,
     869,   870,   871,   871,   872,   872,   873,   873,   874,   874,
     875,   876,   876,   876,   877,   877,   878,   879,   880,   881,
     881,   882,   883,   884,   884,   885,   886,   887,   888,   888,
     889,   890,   891,   891,   892,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     894,   894,   895,   895,   896,   896,   896,   898,   897,   899,
     899,   901,   900,   902,   902,   902,   903,   903,   903,   903,
     903,   903,   903,   903,   903,   904,   904,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   906,   906,   906,   906,   906,   906,
     907,   907,   907,   907,   907,   907,   907,   908,   909,   909,
     909,   909,   909,   909,   910,   910,   910,   910,   910,   911,
     911,   911,   911,   911,   912,   912,   912,   912,   912,   912,
     912,   912,   912,   913,   913,   913,   913,   914,   914,   914,
     914,   915,   915,   915,   915,   915,   915,   915,   916,   916,
     917,   917,   917,   917,   917,   917,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   920,   920,   920,   920,   920,   920,   920,   920,
     920,   920,   920,   920,   920,   920,   920,   920,   920,   920,
     920,   920,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   922,   922,   923,
     924,   924,   925,   925,   926,   927,   928,   928,   928,   929,
     930,   930,   931,   931,   932,   932,   932,   933,   933,   934,
     934,   935,   935,   936,   936,   936,   936,   936,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     1,     0,     4,
       5,     5,     4,     3,     2,     0,     2,     2,     1,     1,
       1,     1,     3,     3,     3,     1,     4,     5,     2,     0,
       2,     2,     6,     6,     3,     6,     4,     1,     0,     2,
       0,     1,     1,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     2,     5,     2,     3,     3,     1,     3,
       1,     1,     1,     3,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     6,     1,
       1,     1,     1,     0,     1,     1,     2,     3,     4,     3,
       2,     2,     3,     4,     3,     2,     4,     1,     1,     1,
       1,     1,     4,     4,     1,     3,     3,     4,     6,     6,
       6,     6,     4,     6,     2,     4,     3,     3,     3,     3,
       1,     3,     3,     3,     3,     2,     1,     1,     0,     2,
       0,     2,     9,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     3,     3,     1,     3,     3,     3,     4,     1,
       0,     2,     0,     3,     0,     1,     0,    11,    12,     1,
       1,     2,     2,     2,     2,     0,     1,     0,     1,     3,
       1,     1,     1,     3,     2,     0,     3,     1,     1,     2,
       1,     2,     3,     4,     2,     5,     1,     2,     2,     2,
       3,     2,     2,     0,     3,     1,     4,     5,     6,    11,
       3,     0,     3,     1,     1,     2,     2,     0,     1,     1,
       2,     2,     0,     3,     3,     2,     1,     1,     2,     2,
       4,     0,     2,     2,     0,     3,     4,     4,     0,     2,
       0,     4,     0,     0,     8,     3,     3,     1,     3,     0,
       3,     1,     1,     5,     4,     2,     0,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     0,     8,
       1,     0,     1,     2,     2,     0,     5,     1,     0,     6,
       2,     0,     3,    14,    19,     1,     1,     1,     3,     5,
       1,     1,     1,     3,     0,     1,     0,     1,     1,     1,
       3,     0,     1,     1,     0,     2,     1,     2,     1,     2,
       2,     1,     2,     2,     6,     8,     3,     4,     4,     4,
       5,     3,     3,     1,     3,     3,     1,     1,     1,     1,
      12,     1,     3,     4,     7,     4,     2,     1,     0,     1,
       0,     7,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     2,     2,     3,     3,     5,     4,
       4,     3,     4,     3,     3,     2,     4,     2,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     2,     2,     1,
       2,     2,     1,     1,     1,     6,     9,     7,     9,     8,
       8,     6,     9,     7,    10,     7,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     7,     8,
       2,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     2,     1,     3,     1,     2,     3,     0,
       3,     0,     1,     3,     2,    12,     1,     0,     2,     0,
       1,     3,     2,     2,     4,     1,     2,     0,     9,     2,
       0,     3,     2,     1,     3,     3,     2,     1,     1,     1,
       0,     1,     3,     1,     1,     1,     4,     1,     2,     2,
       2,     1,     1,     1,     4,     5,     1,     3,     3,     2,
       2,     2,     0,     5,     7,     1,     1,     7,     1,     3,
       3,     3,     1,     3,    11,    10,     2,     0,     8,     4,
       4,     1,     1,     1,     0,     9,     6,     6,     7,     6,
       6,     9,     6,     6,     6,     8,     8,     6,     6,     1,
       0,     9,     6,     6,     6,     7,     9,     9,     6,     6,
       6,     0,    14,     1,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     6,     2,     2,     2,     2,     2,     3,     3,
       2,     2,     2,     2,     3,     2,     5,     4,     1,     1,
       0,     3,     2,     2,     1,     3,     2,     1,     0,     7,
       2,     5,     3,     1,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     1,     0,     5,     4,     3,
       6,     4,     6,     6,     5,     7,     1,     0,    10,     4,
       2,     1,     4,     5,     5,     2,     4,     1,     1,     1,
       0,     1,     0,     1,     0,     3,     0,     4,     1,     1,
       1,     1,     1,     1,     0,     4,     4,     2,     1,     7,
       4,     3,     1,     2,     4,     5,     3,     0,     2,     2,
       2,     3,     1,     3,     1,     2,     1,     0,     6,     7,
       0,     2,     2,     2,     3,     0,     2,     2,     1,     1,
       3,     3,     1,     2,     4,     4,     1,     1,     8,     4,
       4,     4,     2,     1,     0,     3,     3,     4,     4,     4,
       4,     2,     1,     1,     0,     1,     0,     1,     5,     1,
       0,     1,     0,     3,     1,     3,     3,     2,     2,     1,
       4,     4,     2,     2,     4,     1,     0,     1,     1,     1,
       3,     0,     2,     0,     3,     3,     1,     0,     2,     0,
       2,     0,     3,     1,     1,     2,     1,     2,     5,     6,
       5,     1,     2,     1,     4,     3,     4,     3,     5,     4,
       5,     4,     5,     2,     4,     1,     2,     2,     2,     1,
       1,     0,     4,     2,     1,     2,     2,     4,     1,     2,
       0,     1,     3,     2,     2,     3,     5,     6,     3,     4,
       0,     1,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     5,     3,     0,
       5,     3,     0,     1,     1,     1,     1,     5,     2,     1,
       1,     1,     1,     5,     2,     2,     2,     1,     3,     3,
       2,     1,     0,     3,     0,     5,     2,     5,     2,     1,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     0,     1,     3,     5,
       2,     2,     2,     2,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     3,     3,
       2,     3,     5,     4,     6,     3,     5,     4,     6,     4,
       6,     5,     7,     2,     3,     2,     4,     3,     4,     3,
       4,     3,     4,     5,     6,     7,     5,     6,     3,     4,
       4,     6,     2,     1,     3,     2,     2,     2,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     5,     6,     7,     1,     1,     2,     4,     1,
       1,     1,     2,     2,     2,     1,     3,     4,     5,     5,
       4,     1,     2,     4,     2,     4,     2,     2,     2,     6,
       4,     4,     4,     4,     6,     5,     5,     5,     4,     6,
       4,     6,     4,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     3,     0,     3,     1,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     3,
       2,     3,     0,     3,     3,     2,     2,     1,     0,     2,
       2,     3,     2,     1,     1,     3,     5,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     2,     0,     3,     1,     3,     1,
       1,     3,     7,     1,     2,     4,     1,     3,     4,     4,
       3,     1,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     2,     3,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     3,     2,     2,     3,
       7,     1,     1,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     2,     0,     7,     3,     2,     1,     1,
       1,     0,     5,     0,     4,     2,     1,     2,     0,     1,
       3,     3,     3,     3,     0,     4,     5,     5,     0,     1,
       1,     1,     1,     2,     2,     2,     1,     2,     0,     7,
       0,     5,     0,     4,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     5,     2,     1,
       3,     2,     2,     3,     0,     5,     1,     0,     5,     2,
       2,     1,     1,     1,     2,     2,     3,     1,     2,     2,
       3,     3,     4,     2,     1,     2,     1,     1,     2,     2,
       3,     1,     1,     1,     1,     0,     1,     3,     4,     0,
       2,     0,     1,     2,     3,     2,     1,     1,     1,     0,
       1,     1,     3,     0,     4,     2,     2,     1,     1,     0,
       1,     1,     1,     1,     2,     3,     0,     1,     2,     1,
       4,     4,     0,     1,     2,     1,     1,     3,     1,     1,
       4,     4,     4,     4,     1,     0,     3,     3,     4,     1,
       3,     3,     4,     1,     3,     3,     1,     6,     1,     3,
       3,     6,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     4,     1,     1,     4,     4,     3,     0,     7,     1,
       0,     0,     7,     3,     4,     3,     1,     1,     1,     2,
       3,     5,     2,     5,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       0,     1,     2,     1,     2,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     2,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1923,  1924,  1927,  1931,  1932,  1859,
    1933,  1934,  1899,  1900,  1901,  1902,  1903,  1904,  1905,  1906,
    1907,  1908,  1909,  1910,  1912,  1911,  1913,  1914,  1915,  1916,
    1917,  1918,  1919,  1920,  1922,  1921,  1936,  1937,  1925,  1926,
    1928,  1929,  1898,  1930,  1938,  1939,  1940,  1935,  1888,  1212,
    1889,    10,  1208,  1209,  1943,  1894,  1895,  1893,  1896,  1897,
    1941,  1942,  1884,  1885,  1887,    11,    12,  1886,     4,  1890,
    1891,  1892,     8,  1294,  1365,     9,  1883,  1365,     0,  1477,
    1478,  1479,     0,  1480,  1481,  1482,  1483,  1484,  1415,  1379,
       0,  1485,     0,  1486,  1487,  1488,  1489,  1490,  1491,  1492,
    1493,  1494,     0,  1495,  1496,  1497,  1498,  1364,  1499,  1500,
    1501,  1502,  1341,  1347,  1503,  1461,     0,  1321,  1322,  1318,
    1320,  1319,  1323,  1308,   670,     0,   718,   717,     0,  1772,
     670,  1773,  1740,  1774,  1741,  1742,   201,     0,   711,  1743,
       0,   670,  1744,   250,   550,  1775,     0,     0,  1745,  1746,
       0,     0,   368,   670,     0,  1747,   734,  1748,     0,  1749,
    1776,  1777,     0,     0,  1778,  1779,  1750,     0,  1751,  1752,
    1780,  1781,  1782,  1783,  1784,     0,     0,   794,     0,  1753,
    1785,  1754,  1755,     0,  1786,  1756,  1757,  1758,  1787,  1788,
    1759,  1760,  1761,     0,  1762,     0,     0,     0,   531,  1789,
     670,  1763,     0,   800,     0,  1764,     0,  1790,  1765,     0,
    1766,  1767,  1768,  1769,  1770,   794,  1457,  1342,     0,     0,
     722,  1771,  1791,  1870,  1871,     0,     0,     0,    43,    21,
      20,    57,    35,    16,    50,    38,    81,    82,    83,    27,
      23,    19,    24,    28,    40,    29,    39,    18,    36,    52,
      42,    55,    41,    56,    30,    48,    46,    37,    51,    54,
      77,    60,    26,    61,    73,    62,    34,    71,    69,    70,
      31,    49,    68,    72,    17,    74,    53,    67,    64,    78,
      76,    84,    65,    44,    14,    58,    33,    15,    32,    25,
      80,    22,   720,    59,    63,    47,    66,    79,    45,    75,
     777,   768,   802,   776,    86,    87,    88,     7,  1278,  1280,
    1279,  1365,  1316,  1317,  1283,  1326,  1336,  1325,  1329,  1337,
    1324,  1343,     0,    90,    92,    93,    94,    97,    98,    91,
      85,    89,    96,   102,    95,   101,    99,   100,   103,   104,
     105,  1546,   966,  1544,  1545,  1543,  1300,     0,  1365,  1302,
    1301,  1365,  1312,  1336,     0,  1504,  1505,  1506,  1507,  1508,
    1509,  1551,  1552,  1553,  1554,  1555,  1557,  1556,  1566,  1567,
    1568,  1569,  1570,  1571,  1572,  1573,  1574,  1575,  1576,  1577,
    1578,  1579,  1580,  1581,  1582,  1583,  1584,  1523,  1585,  1586,
    1587,  1588,  1589,  1590,  1591,  1592,  1593,  1594,  1595,  1596,
    1597,  1598,  1599,  1600,  1601,  1560,  1602,  1603,  1604,  1605,
    1606,  1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,  1615,
    1617,  1616,  1618,  1619,  1620,  1621,  1622,  1623,  1624,  1625,
    1626,  1627,  1561,  1628,  1629,  1630,  1631,  1632,  1633,  1634,
    1635,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,  1644,
    1645,  1646,  1647,  1648,  1649,  1650,  1651,  1562,  1652,  1653,
    1563,  1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,  1662,
    1663,  1664,  1665,  1666,  1667,  1668,  1669,  1670,  1672,  1671,
    1673,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,  1682,
    1683,  1684,  1685,  1686,  1687,  1688,  1689,  1690,  1691,  1692,
    1693,  1694,  1695,  1696,  1564,  1697,  1698,  1699,  1700,  1701,
    1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,     0,  1717,  1718,  1719,  1720,
    1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,
    1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,  1565,  1739,
    1869,  1224,  1271,  1270,  1247,  1266,  1521,  1475,  1476,  1242,
    1522,  1519,  1558,  1559,  1520,  1225,  1865,  1518,  1414,     0,
       0,  1377,  1378,  1381,  1256,  1251,  1380,     0,  1252,  1375,
    1376,  1193,  1272,  1518,  1510,  1511,  1512,  1513,  1515,  1514,
    1516,  1792,  1793,  1794,  1795,  1796,  1797,  1798,  1799,  1800,
    1801,  1802,  1536,  1803,  1804,  1805,  1806,  1807,  1808,  1809,
    1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,  1818,  1819,
    1820,  1821,  1822,  1823,  1824,  1825,  1826,  1827,  1828,  1537,
    1538,  1829,  1830,  1831,  1832,  1833,  1834,  1835,  1836,  1837,
    1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,  1846,  1847,
    1848,  1849,  1540,  1850,  1851,  1539,  1852,  1853,  1854,  1855,
    1856,     0,  1331,  1550,  1535,  1332,  1517,  1547,  1534,  1541,
    1542,  1549,  1548,  1394,  1192,  1396,  1339,  1349,  1345,  1353,
    1348,     0,     0,     0,     0,  1365,   669,   668,   657,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    13,     0,   678,   231,  1244,
    1243,  1188,   710,     0,  1184,  1185,   368,   660,   249,     0,
       0,     0,     0,     0,     0,   427,     0,     0,     0,     0,
       0,     0,   138,     0,   260,   259,     0,   360,     0,   536,
       0,     0,   368,     0,     0,     0,  1248,     0,  1671,  1392,
    1393,  1277,  1706,   760,     0,     0,     0,     0,   439,     0,
     438,     0,     0,   436,     0,   367,     0,   440,   434,   433,
       0,     0,   437,     0,   435,     0,     0,   661,  1628,  1383,
     733,   720,  1567,   465,   469,   460,   466,   474,   473,   461,
     458,   459,  1681,     0,     0,   464,     0,   455,  1213,  1215,
     472,  1214,     0,   501,   514,   508,   512,   506,   510,   509,
     505,   516,   515,   511,   507,   513,     0,   502,   503,     0,
     654,  1185,   680,  1197,   793,     0,     0,   457,   653,     0,
       0,   601,   602,     0,  1694,   665,   195,  1699,  1767,  1718,
     191,     0,     0,   662,   663,   799,   797,     0,     0,     0,
       0,  1593,  1647,  1655,  1699,  1767,  1718,   147,     0,   158,
     190,  1699,  1767,  1718,   186,   678,     0,     0,  1340,   656,
     655,     0,     0,   864,   721,   724,   777,     0,   670,     0,
       6,   719,   715,   796,   796,     0,   796,     0,   773,  1281,
    1336,  1315,  1371,  1285,     0,     0,  1361,  1357,  1354,  1362,
    1363,  1356,  1344,   955,   956,   957,   954,   958,   953,     0,
    1289,  1328,  1295,     0,  1305,  1304,  1303,  1310,  1371,  1314,
    1872,  1873,  1416,  1246,  1263,     0,     0,     0,     0,     0,
       0,  1255,  1261,     0,  1253,     0,     0,  1877,  1881,     0,
    1879,  1874,  1330,  1402,  1395,  1397,  1399,  1351,  1350,  1346,
       0,     0,  1466,     0,     0,  1467,  1468,     0,  1463,  1465,
       0,  1371,     0,     0,  1521,  1198,  1522,  1519,  1531,  1518,
       0,   443,     0,     0,     0,   443,     0,     0,     0,     0,
    1587,  1089,  1099,  1097,  1098,  1091,  1092,  1093,  1096,  1094,
    1095,     0,   592,  1090,     0,     0,   346,     0,     0,     0,
       0,   115,     0,     0,     0,   674,   677,   658,     0,     0,
    1160,  1189,     0,     0,     0,   486,   495,   487,   492,     0,
     489,     0,     0,     0,   488,   490,   491,     0,   493,   494,
       0,     0,   252,     0,     0,     0,     0,   682,   707,   264,
     263,   129,   262,   261,     0,     0,   549,     0,   140,   371,
       0,     0,   108,     0,     0,     0,     0,     0,     0,     0,
       0,  1417,  1276,  1374,     0,   870,     0,   406,     0,   699,
       0,   134,     0,     0,     0,   372,     0,   113,   125,     0,
     228,   441,  1391,  1390,  1382,  1389,     0,   462,   471,   470,
     468,   467,   463,  1216,     0,   453,   454,  1402,  1405,   451,
       0,   500,     0,     0,     0,   747,  1186,     0,     0,   604,
     604,   664,   194,   192,     0,     0,     0,     0,     0,     0,
    1740,  1741,   914,  1153,     0,  1523,  1742,  1743,  1744,  1061,
    1165,  1165,  1165,  1745,  1746,  1610,  1747,  1748,  1205,  1749,
     904,  1751,  1752,  1753,  1754,     0,  1206,  1756,  1757,  1666,
    1759,  1760,  1762,  1763,  1165,  1765,  1766,  1767,  1768,  1769,
    1770,  1204,     0,  1165,  1771,  1100,  1210,  1211,  1162,     0,
       0,  1170,     0,     0,     0,  1051,     0,   898,   900,   901,
     925,   926,   902,   931,   932,   944,   899,     0,  1169,   967,
    1050,  1055,     0,  1049,  1045,   784,  1167,  1154,     0,  1046,
    1238,  1237,  1239,  1240,  1236,  1200,  1521,  1527,   903,  1522,
    1519,  1207,  1241,  1865,  1518,     0,     0,     0,     0,  1456,
       0,   197,     0,   198,  1190,  1699,   148,   182,   155,   181,
       0,  1585,   149,     0,   153,     0,     0,     0,   189,   187,
       0,   659,   447,     0,     0,   866,     0,   865,   723,   720,
     771,   770,     5,   726,   795,     0,     0,     0,     0,     0,
       0,     0,   827,   816,  1371,  1372,     0,  1366,     0,  1365,
    1365,  1359,  1358,  1355,     0,     0,     0,     0,     0,     0,
    1230,  1229,  1286,  1288,  1233,     0,  1371,     0,     0,  1265,
       0,  1269,  1267,  1402,  1411,  1402,  1412,  1413,  1259,  1254,
    1257,     0,  1249,  1261,  1875,     0,     0,  1878,  1333,     0,
    1403,  1234,  1235,  1408,     0,  1398,  1406,  1409,  1352,  1365,
    1474,     0,  1469,  1472,     0,  1464,     0,  1199,     0,     0,
       0,     0,   444,     0,     0,     0,   698,     0,     0,     0,
     701,     0,   560,     0,     0,     0,     0,     0,     0,     0,
     203,   220,     0,     0,     0,     0,     0,     0,   344,   620,
     620,     0,     0,   620,   620,     0,   202,   204,     0,     0,
       0,     0,     0,     0,   115,   109,   112,  1296,     0,   672,
     673,     0,   676,     0,  1157,  1156,  1195,  1161,   709,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   407,     0,   907,   942,   942,   942,   922,   922,
     916,   905,   949,     0,   942,   919,   908,     0,   906,   952,
     952,   937,     0,   880,   890,   892,   893,   923,   924,   894,
     929,   930,   891,   966,  1526,   903,  1528,  1525,  1524,     0,
       0,   706,     0,   129,   126,   428,   408,     0,   136,     0,
       0,   376,   375,     0,     0,   409,   107,   115,   346,   339,
       0,     0,     0,  1196,     0,     0,   301,   761,   765,   762,
       0,   763,     0,   744,     0,     0,   228,     0,     0,     0,
       0,     0,   228,   226,   227,     0,   432,  1384,  1387,  1388,
       0,   727,   729,   731,   730,   732,   728,   452,   449,   450,
       0,  1404,  1857,  1863,     0,  1418,  1419,     0,  1601,  1624,
    1641,  1695,     0,  1713,     0,   517,   504,     0,     0,     0,
     735,   738,     0,     0,   757,   456,  1410,   603,   600,   599,
     193,   530,     0,  1694,   667,     0,     0,  1053,  1054,   941,
     928,  1152,     0,     0,   936,   935,     0,     0,     0,  1062,
       0,  1064,     0,  1066,     0,   912,   911,   910,  1052,  1113,
       0,   909,   942,   942,   940,   990,     0,     0,   913,     0,
       0,  1132,     0,  1067,  1138,     0,     0,     0,   948,     0,
     946,     0,     0,  1022,  1068,  1047,   970,   971,   972,   973,
    1051,  1110,     0,  1201,     0,     0,   934,     0,   966,     0,
       0,     0,     0,     0,  1108,     0,     0,  1003,  1106,     0,
    1005,     0,     0,     0,  1100,  1099,  1097,  1098,  1091,  1092,
    1093,  1096,   974,   975,  1104,   987,     0,   986,  1402,     0,
     831,   783,  1155,     0,     0,  1864,  1866,  1453,  1452,  1451,
    1450,  1454,  1455,  1426,     0,  1422,  1423,     0,   199,   200,
     196,     0,     0,   157,   156,   185,   184,     0,   179,   180,
     152,     0,   175,   176,   161,   172,   174,   173,   171,   150,
     160,   162,   168,   169,   170,   159,   151,   188,  1365,     0,
       0,   831,  1173,  1162,   712,     0,   716,   777,   781,   776,
     780,   803,   804,   809,   779,     0,   829,   818,   812,   817,
     813,   819,   826,   775,   815,   774,     0,  1373,  1284,  1371,
     880,  1365,  1306,  1365,  1360,  1292,   960,   961,   962,   963,
     965,   964,  1293,  1290,   959,  1291,  1232,  1231,     0,     0,
       0,     0,  1313,  1262,     0,  1245,  1268,     0,  1260,     0,
    1876,  1882,  1880,     0,     0,   880,  1860,  1470,  1860,   880,
     586,     0,   585,     0,     0,   445,     0,     0,     0,   697,
       0,     0,     0,     0,     0,   704,   295,     0,   225,     0,
       0,     0,     0,   557,   559,   558,   552,     0,   553,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   588,   593,     0,     0,     0,   348,   358,
       0,     0,     0,   108,   108,   345,   619,   214,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   111,   110,   118,   120,     0,   119,   121,
       0,     0,     0,   114,     0,     0,   167,   671,   675,  1158,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   251,   234,   233,     0,     0,   413,   416,     0,
     880,     0,     0,     0,   874,   955,   954,   953,     0,   895,
     897,     0,   696,   696,   696,   696,   696,   681,   683,   275,
     127,     0,     0,   128,     0,   140,   265,   139,   141,   143,
     144,   145,   142,   146,   370,     0,   381,   380,   382,     0,
     377,     0,   410,   106,   343,     0,   267,     0,     0,     0,
       0,     0,   631,     0,     0,     0,     0,     0,   764,   869,
       0,     0,   583,     0,     0,   228,   228,   124,   366,   442,
    1385,  1386,   760,   448,     0,     0,  1862,  1217,     0,  1218,
       0,     0,   520,   519,   532,     0,   521,   522,   518,   523,
       0,   737,     0,     0,   742,  1162,     0,   754,     0,   752,
       0,  1187,   756,   745,     0,   666,  1110,     0,     0,     0,
    1116,     0,     0,  1151,  1148,     0,     0,  1110,     0,  1164,
       0,     0,     0,  1123,  1124,  1125,  1122,  1126,  1121,     0,
       0,  1127,  1120,     0,   939,   938,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1023,     0,     0,  1084,     0,
    1110,  1137,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1110,  1143,     0,  1163,  1162,     0,     0,     0,
       0,  1202,   968,   988,  1168,     0,     0,   995,     0,  1144,
    1018,     0,  1009,     0,  1004,     0,  1007,  1011,   991,     0,
    1109,     0,  1107,     0,     0,   989,     0,   984,   982,   983,
     976,   977,   978,   979,   980,   981,   985,  1088,  1086,  1087,
       0,  1625,  1647,     0,   794,   794,   782,   792,  1166,     0,
     870,     0,     0,     0,  1056,     0,  1868,  1867,     0,     0,
       0,  1191,     0,     0,   966,     0,   880,   867,     0,  1162,
       0,   870,     0,   714,   713,     0,     0,   807,   808,     0,
     825,     0,   824,     0,     0,     0,  1282,  1367,  1369,  1335,
    1307,  1338,  1287,  1327,     0,  1311,  1264,  1258,     0,  1400,
    1407,  1460,     0,  1861,     0,     0,     0,   622,   606,   446,
     623,   607,     0,     0,     0,     0,     0,   228,   702,   224,
     703,   624,   551,   560,     0,   556,   565,  1532,   903,   563,
    1533,  1530,  1529,     0,     0,   132,   133,   609,   222,   614,
     223,   221,   610,     0,  1194,     0,     0,     0,   628,   612,
     347,   357,     0,   351,   352,   349,   353,   354,     0,     0,
     206,     0,     0,   218,   217,   228,   228,   613,     0,   219,
     216,   205,   630,   618,     0,   629,   617,     0,   116,   117,
       0,   165,   164,   166,     0,     0,     0,     0,     0,     0,
       0,   497,   481,   496,     0,     0,     0,   475,   236,   237,
     254,   235,   412,     0,     0,     0,     0,   875,     0,     0,
     880,     0,     0,   888,   881,   889,     0,     0,     0,     0,
     695,     0,     0,     0,     0,     0,   684,   700,   131,   130,
       0,   135,     0,     0,   369,     0,     0,     0,   871,     0,
       0,     0,     0,   266,   268,   270,   271,   272,     0,   341,
     342,   337,     0,     0,   333,     0,     0,   539,     0,     0,
       0,   303,   304,     0,   766,   767,     0,   228,     0,   228,
     228,   652,   404,     0,  1401,  1858,  1427,  1428,     0,  1420,
    1421,     0,   534,     0,   529,   524,   526,  1183,  1182,     0,
    1181,     0,     0,   743,   755,   748,   750,   749,     0,     0,
     746,     0,   798,     0,  1118,  1119,     0,     0,     0,     0,
    1147,     0,     0,  1082,     0,  1080,  1063,  1065,   921,     0,
    1070,     0,   915,     0,   918,     0,  1101,     0,     0,  1071,
    1025,  1026,  1027,     0,     0,     0,     0,  1100,     0,     0,
       0,     0,     0,     0,     0,  1028,  1029,  1041,  1040,  1072,
    1083,     0,     0,  1135,  1136,  1073,   950,   951,   952,   952,
       0,     0,  1142,     0,     0,     0,  1078,  1048,  1111,   943,
     944,     0,     0,     0,     0,     0,     0,  1010,  1006,     0,
    1008,  1012,     0,     0,     0,   997,  1019,   993,     0,     0,
     999,     0,  1020,   794,   794,   794,   794,   791,     0,     0,
       0,   841,   830,   833,   843,   834,   836,   868,  1188,   821,
       0,     0,  1060,  1057,  1435,  1436,  1437,  1438,  1439,  1440,
    1441,  1442,  1443,  1444,  1446,  1447,  1448,  1445,  1449,  1431,
    1432,     0,  1424,  1425,   154,     0,   177,   163,  1460,     0,
    1174,  1171,   758,     0,   725,   805,     0,  1102,   806,   828,
     810,   814,   811,     0,  1368,  1297,  1274,  1459,  1462,  1473,
    1471,  1309,     0,     0,     0,   294,     0,     0,     0,   705,
     554,   555,   897,   625,   608,     0,     0,   590,     0,   591,
     589,   350,   356,   355,   275,     0,     0,     0,   207,   215,
     212,     0,     0,   122,   123,  1159,     0,     0,   477,   483,
       0,     0,     0,     0,   485,   255,   108,     0,   414,  1666,
    1092,   415,   417,   564,   418,   419,     0,     0,     0,     0,
     878,     0,     0,     0,     0,     0,     0,   880,   966,     0,
     692,  1226,  1227,   691,  1228,   688,   687,   694,   693,   686,
     685,   690,   689,     0,     0,     0,   286,     0,     0,   280,
       0,     0,   332,   274,   277,   278,     0,     0,   384,   378,
     411,     0,   873,   267,   293,   321,     0,   338,     0,     0,
       0,     0,   365,   362,     0,     0,     0,     0,     0,   300,
       0,   679,   759,  1275,   584,   228,   431,   587,   765,     0,
       0,   533,   527,     0,     0,   498,   736,     0,     0,   740,
     741,   753,   751,   228,  1111,  1117,   927,     0,  1150,  1146,
       0,     0,     0,  1112,     0,     0,  1130,  1129,  1024,  1131,
       0,     0,     0,  1039,  1038,  1036,  1037,  1030,  1031,  1032,
    1033,  1034,  1035,  1140,  1139,  1133,  1134,   947,   945,     0,
    1075,  1076,  1077,  1141,  1085,   933,   966,   969,  1016,   996,
    1145,  1013,     0,  1115,     0,   992,     0,     0,     0,  1001,
    1101,     0,     0,     0,     0,     0,     0,   786,   785,   841,
       0,   843,     0,   842,   855,     0,     0,   861,   859,     0,
     861,     0,   861,     0,     0,   835,     0,   837,   855,  1189,
       0,   823,  1058,  1059,     0,     0,     0,  1458,     0,     0,
    1179,  1178,     0,  1370,     0,  1250,     0,     0,   296,     0,
       0,   332,     0,     0,     0,     0,   273,     0,     0,     0,
       0,   230,   615,   616,     0,     0,     0,     0,   480,   479,
     239,     0,   401,     0,     0,   405,   396,   398,     0,     0,
       0,   876,   882,   883,   884,   885,   886,   887,   879,   896,
     394,     0,     0,   284,   288,   289,   287,   279,   332,   301,
       0,   281,     0,     0,   386,     0,     0,   872,     0,     0,
       0,   290,     0,   324,   269,   340,   342,   335,   336,   334,
       0,   359,   363,     0,   538,     0,     0,     0,     0,   571,
       0,     0,     0,   572,   576,   573,   582,   567,   647,   648,
     645,   646,     0,   302,   598,     0,  1429,  1430,     0,   525,
    1180,     0,   499,  1149,  1069,  1079,   920,  1081,   917,  1128,
       0,     0,     0,  1074,  1203,     0,  1014,     0,  1017,   998,
     994,     0,  1000,  1021,   790,   789,   788,   787,   845,   853,
       0,   832,     0,   860,   856,     0,   857,     0,     0,   858,
     847,     0,     0,   853,     0,     0,     0,   778,  1433,     0,
    1219,  1223,  1220,  1434,   966,     0,  1175,     0,  1273,   621,
     605,     0,   332,   297,   566,   627,   611,   626,   208,   209,
     210,   211,     0,   213,   476,     0,   482,   478,   232,   253,
     403,   402,   400,   397,   399,   877,     0,   597,     0,     0,
       0,     0,   276,   282,   307,     0,     0,   267,   385,     0,
       0,   379,   324,   292,   291,     0,     0,     0,   328,   364,
       0,     0,     0,   540,   547,   547,   569,   561,     0,     0,
     570,     0,   579,   580,     0,   568,   548,     0,     0,   528,
       0,  1042,     0,     0,  1015,  1114,  1002,   844,     0,     0,
     846,     0,     0,   849,   851,     0,     0,     0,     0,     0,
    1192,   820,   822,  1222,  1221,   178,  1176,     0,  1103,     0,
     298,   229,   484,   240,   244,   707,   707,     0,   707,   241,
     707,   238,   597,     0,   595,   395,     0,   283,     0,   312,
       0,     0,   387,   388,   383,     0,   328,     0,   322,   323,
       0,   330,   708,     0,   330,     0,     0,   545,   543,   542,
       0,     0,   577,   578,     0,   581,   870,   739,     0,  1043,
       0,   854,   863,     0,   850,   848,   838,     0,   840,     0,
    1172,   301,     0,     0,     0,     0,     0,     0,   594,   596,
       0,   305,   306,     0,   285,   308,   309,   331,     0,     0,
     330,   320,     0,     0,   257,   547,   870,   541,   546,   562,
     574,     0,     0,  1044,   852,     0,   839,  1177,   307,   242,
     246,     0,   247,   243,   245,     0,     0,     0,     0,   310,
       0,   311,     0,     0,     0,   420,   421,   391,   258,     0,
     325,     0,   329,   544,   535,   575,   651,   862,   312,   248,
       0,   317,     0,   316,     0,   313,   314,     0,     0,   426,
       0,     0,   389,   392,   393,   326,   327,   650,   649,     0,
       0,     0,   315,   318,   319,     0,   430,   422,   373,     0,
     633,   644,   632,   634,   642,   639,   641,   640,   638,   299,
       0,   425,   429,     0,   423,   390,     0,   643,   637,   777,
     768,     0,     0,   635,   644,   391,   430,   636,     0,   424,
     374
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   226,   227,   228,  1457,   229,   230,
     231,  1375,  1833,  1077,   232,  1444,  1883,   233,   234,   235,
    1047,  1448,  1887,   236,   857,   858,  1669,  1670,  1837,  1671,
    1672,  1660,  1228,  1654,   237,   238,   239,  1222,  1650,   240,
     241,  1366,  1367,  1350,  1351,  1340,  1486,  2913,   242,   243,
    1855,  2230,  2918,  3011,   719,  1400,  2536,  2537,   244,   741,
    2272,  2273,  2274,  2275,  2257,  2583,  2584,  2585,  2276,  2801,
    2277,  1766,  1914,  2290,  2291,  3019,  3074,  3075,  3076,  3135,
    2803,  2948,  3031,  3084,  2791,   245,  2601,  2284,  1907,  2278,
    2279,   246,   247,  1358,  1805,  2182,   248,   742,  2602,  2811,
     249,   775,   250,  1450,   251,   252,  1453,  1899,  1900,  2795,
    2939,  3024,  3141,  3142,  2929,  2765,  2766,  2767,   253,   254,
     255,   256,  1902,  1402,  1856,  1857,  2541,   257,  3115,  3116,
     743,  3174,   258,   259,   776,  1080,  3037,  1332,   260,   261,
     794,   795,   796,   262,  1031,  2222,   263,   264,   816,   817,
     818,  1514,  2314,  2315,  2625,   842,  1943,  1944,   265,   744,
    2606,  2952,  2953,  3038,   266,   745,  1343,  1777,  1778,  1779,
    2956,  2154,  2542,  2543,  2826,  2827,  2966,   267,   268,  1751,
     269,  1792,   991,   270,  3014,   271,   272,   833,  1528,   273,
    1808,   274,   275,  2289,  3162,  3176,  3177,  3178,  2832,  3149,
     276,  3164,   278,   279,   280,   707,  1005,  1006,  1007,   281,
     282,   283,  1877,  1878,  2251,   284,   285,   286,   287,  1442,
     288,   289,   290,   291,   292,   882,   875,  1249,  1686,   293,
    1491,   781,  3165,  1520,  1953,  1954,  3166,   296,  1524,  1960,
    1963,  3167,   298,  1064,  1917,  3168,  1175,   301,   302,   303,
    1630,  2076,   825,  1255,   847,   887,   888,  1691,  1692,  1262,
    1705,  1698,  1700,  2721,  2887,  1263,  1703,  2112,  2080,  2432,
    2433,  2434,  2703,  2714,  2874,  2983,  2435,  2436,  1473,  2267,
    2268,  1793,  1864,  2242,  1423,  1176,  1177,  1178,  1561,  1568,
    1555,  1426,  1179,  1180,  1181,  1429,  1182,  1183,  1184,  1185,
    1540,  1596,  1186,  1187,  1578,   910,  1966,  2004,  1189,  1190,
    1191,  2070,  1624,   993,  1192,  2478,  1626,  2023,  1989,  2684,
    1969,  1538,  1990,  2000,  2358,  2007,  2012,  2383,  2384,  2024,
    2040,  1193,  1973,  1974,  2341,  1542,  1194,  2025,  1011,  1585,
    1549,  1195,  1196,  1681,  2098,  2997,  1682,  2319,  2320,  1197,
    1515,   873,  2979,  1224,   574,  2173,  1385,   713,   822,  1198,
    1199,  1200,  1201,  1202,  1203,  1204,  2244,   800,  1938,  2893,
    2223,  2563,  1312,  1673,  1205,   553,   714,   304,   576,   577,
     931,   932,  1299,  1302,  1289,  1735,   554,   555,   578,  2735,
     305,   306,   307,   308,   309,  1264,   892,  1283,  1729,   911,
      72,    77,    73,   912,   347,   348,  1711,   310,   685,  1712,
    1286,   918,   351,   312,   313,   352,   315,   662,   353,   894,
     317,   895,   318,   319,   320,   321,   902,   322,  1266,  1267,
    2484,  1268,   323,   324,   579,   580,   325,  1085,  1487,  1084,
     751,   326,   327,   944,   945,   946,  1098,  1500,  1099,  1315,
    1316,   328,   329,   570,   330,   331,   332,  1505,  1506,   333,
    1645,  1646,  1647,   334,  2306,  2307,   335,  2459,  2460,  2461,
     336,  1639,   337,   338,   867,  2488,   339,   681,   340,   958,
     556,   557,   558,  1207,   665,   821,  1208,   965,   666,   342,
     668,   560,   561,   562,   563,   564,   968,   672,  1501,    74,
    2132,  1502,  1211,  1212,  1635,  1213,   567,   922,   937,   938,
    2133,   940,    75,   941
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2857
static const int yypact[] =
{
   -2857,   278, 12160, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, 14273, -2857, -2857, 33783,   696, -2857,
   -2857, -2857, 36119, -2857, -2857, -2857, -2857, -2857,   552, 35341,
   13123, -2857, 48159, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, 48159, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, 34564,   688, -2857, -2857,   253, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857,   316,  4455, -2857, -2857, 37675, -2857,
       2, -2857, -2857, -2857, -2857, -2857, -2857, 48159, 43115, -2857,
     538,   316, -2857,   717,  9518, -2857, 37675, 38064, -2857, -2857,
   48547,   693,  3388,   316, 38453, -2857,   573, -2857, 31441, -2857,
   -2857, -2857,   876,  2235, -2857, -2857, -2857,   720, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, 43115,   993,   654, 31830, -2857,
   -2857, -2857, -2857, 43115, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, 38842, -2857,   381, 48935, 43891,   829, -2857,
     316, -2857, 48159,   157, 33395, -2857, 44279, -2857, -2857,   707,
   -2857, -2857, -2857, -2857, -2857,   654, -2857, 34564, 30259, 42339,
     860, -2857, -2857, -2857, -2857,   -57, 14602,   649, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857,   764, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
      11, -2857,   594,   101, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, 50867,   950, -2857, -2857, -2857,   770, -2857,   736, -2857,
   -2857, -2857,  1138, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857,   153, -2857, -2857, -2857, -2857,  1134, 34173, -2857,
   -2857, 50867, -2857,   800, 38842, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, 36508, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857,    87, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, 48159,
   48159, -2857, -2857, -2857,   837, -2857, -2857,   838, -2857, -2857,
   -2857, -2857, -2857,   904, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, 10948, -2857, -2857, -2857,   851, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857,   946, -2857,   332,  1170, -2857,
   -2857, 34564,  1452,  1452,  1345, 50867, -2857, -2857, -2857, 41175,
   48159, 48159, 48159, 41175, 48159, 42339, 48159, 28668, 48159, 43115,
   42339, 48159, 48159, 48159, 48159, -2857,  1354,    25, -2857, -2857,
   -2857,   982, -2857,  1130, -2857,  1147,  3748, -2857, -2857, 43115,
   41175, 48159,  1014,  1080, 48159, -2857, 48159,  1241, 48159,  1278,
     686,  1154, 48159, 48159, -2857, -2857, 48159, -2857, 48159, -2857,
   48159,   628,  1176,  1343,  1288,   431, -2857, 38842, 38842, -2857,
   -2857, -2857,  1047, -2857, 42339, 41175, 48159,  1067, -2857, 48159,
   -2857, 41175, 48159, -2857,  1103, -2857, 48159, -2857, -2857, -2857,
   48159, 48159, -2857, 48159, -2857,  1296, 48159, -2857,   258, -2857,
   -2857,   764,   925, -2857,    49,    35,   100, -2857, -2857,   126,
     131,   134,   925,   861, 43503, -2857, 48159,  1281, -2857, -2857,
   -2857, -2857, 38842,  1228, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857,  1298,  1200, -2857, 43115,
   -2857, -2857, -2857, -2857, -2857, 43115,  1038, -2857, -2857,  1371,
   48159, -2857, -2857, 43115, 48159, -2857, -2857,  1549,  1268,  1440,
   -2857,  1417,  2235,  1322, -2857, -2857,  1409, 16992,   -60, 32219,
   38842, 44667, 49323,   154, 45055,  1332,    25, -2857,   589, -2857,
   -2857,  1647,  1368,  1537, -2857,    25, 43115, 51240, -2857, -2857,
   -2857, 26297,  1446,  1379, -2857,  1607,  1380,  1381,   316,  1383,
   -2857, -2857, 43115,  1725,  1725,  1704,  1725,   774,   816, -2857,
   -2857, -2857,  1403, -2857,  1402,  1405, -2857,   551,  1610, -2857,
   -2857, -2857, -2857,  1471,  1477,  1479,  1480, -2857,  1481,   979,
   -2857, -2857, -2857,  1664, -2857, -2857, -2857, -2857,  1403, -2857,
   -2857, -2857, -2857, -2857,  1741,  1728, 37675, 37675,  1470,    -6,
   33004, -2857,  1415,   837, -2857, 12578, 10948, -2857, 23903,  1120,
   -2857, -2857, -2857,   121, -2857, -2857, -2857,  1628, -2857, -2857,
    1623, 48159, -2857,  1494, 48159, -2857, -2857, 49711, -2857, -2857,
    1452,  1403,   982,  1432,  1434, -2857,  1435,  1437, -2857,  1438,
     472,  1439,   905,   256,  1579,   -83,  1454,   133,   832,  1568,
   48159, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857,  1457, -2857, -2857,  1456,   868, -2857,  1019,   923,  1603,
    1595,   554,  1459,  1646,   -65, -2857,   -20, -2857, 19869, 29481,
   -2857,   982, 43115, 41175,  1467, -2857, -2857, -2857, -2857, 41175,
   -2857,  1616,  1251, 48159, -2857, -2857, -2857, 48159, -2857, -2857,
    1656, 48159,  1501,  1473,  1767, 40010, 48159,  1503,  1794, -2857,
   -2857,  1506, -2857, -2857, 48159,  1473, -2857,  1792,  1795,  1613,
     981,    39,  1514, 43115, 43115,  1671, 48159, 48159, 41175, 48159,
   43115, -2857, -2857, -2857,    65,  1517,  1485, -2857, 40010, -2857,
    1454, -2857, 48159,  1486,  1632, -2857,  1633,  1490, -2857,   993,
      26, -2857, -2857, -2857, -2857,    -5,    24, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, 48159,  1281,  1281,    88, -2857, -2857,
      97, -2857, 42727,  2386,    15,   -32, -2857, 48159,   258,  1723,
    1723, -2857, -2857, -2857,  1680,  1733,  1648, 50099,  1502,  1233,
    1055,   653, -2857, 19869,  1505,    46,    46,  1513,  1516, -2857,
    1522,  1523,  1526,  -120,  -120,  1635,  1527,  1528, -2857,   723,
   -2857,  1087,   857,  1489,    46, 19869, -2857,  1540,   891,  1542,
    1544,  1546,  1156,  1547,  1526,  1169,  1550,   724,   812,  1551,
    1553, -2857,  1527,  1526,    34, -2857, -2857, -2857, -2857, 19869,
   19869, -2857, 19869, 19869, 17403, -2857,   993, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857,    17, -2857,   914,  7249, -2857,
   -2857, -2857, 19869, -2857, -2857,   103, -2857,   982,  1555, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857,   964, -2857, -2857,   974,
     997, -2857, -2857,    96,  1016,  1168,  1168, 36897, 36897, -2857,
     773, -2857,    84,  1497, -2857,   833, -2857, -2857, -2857, -2857,
   37286,  1871, -2857,  1190,   -20, 30647, 48159, 30647, -2857, -2857,
    1739, -2857, -2857,  1751, 43115, -2857, 27476, -2857, -2857,   764,
   -2857, -2857, -2857,  1558, -2857,   -57,   -57, 19869,   -57,   380,
   17814, 19869,  1791,   560,  1403,  1567,   701, -2857, 40787, 50487,
   50487,  1762, -2857, -2857,   818,   531,  1661,  1736,   768,  1312,
   -2857, -2857, -2857,  1561, -2857,  1833,  1403,  1083, 37675,  1614,
   37675, -2857, -2857,  1942, -2857,  1942, -2857, -2857, -2857, -2857,
    1569,   861, -2857,  1415, -2857, 16169,  1194, -2857, -2857, 10948,
   -2857, -2857, -2857, -2857,  1969, -2857,  1570, -2857, -2857, 50867,
    1575, 48159, -2857,  1577,  1578, -2857, 51240,   982, 29871,  1643,
    1644, 34564,  1581,  1645,  1649, 49323, -2857,    59,   512,   445,
   -2857,  1650,   527,   934,  1634,  1636,  1652,  1658,  1663,  1666,
    1591, -2857,  1665,  1662, 39232, 29074,  1667,  1669,   534,   528,
    1892,  1760,  1683,  1292,    54,  1670,  1615, -2857,  1689,  1692,
   42339,  1695,  1702, 49323, -2857,  1161, -2857, -2857,   871, -2857,
   -2857,    25, -2857,  2776, -2857, -2857, -2857, -2857, -2857,  1640,
   40010,  1454,   979, 48159,  1642,    38,  1785, 48159,  1837,  1790,
      12, 34564, -2857,  1651, -2857,  1684,  1684,  1684,  1653,  1653,
    1654, -2857, -2857,  1489,  1684,  1655, -2857, 40399, -2857,   689,
     875, -2857,  1967,    47, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857,   438, -2857,  1439, -2857, -2857, -2857,  1979,
     616, -2857, 40010, -2857,   370,  1912, -2857, 48159,   729, 48159,
    1826, -2857, -2857,    75,  1657, -2857, -2857, -2857, -2857,   276,
   37675,  1882,  1796, -2857,  1454,  1980,  1660, -2857,  1315, -2857,
    1757, -2857, 19869, -2857, 29871,  1983,   193,  1705, 39232, 43115,
   43115, 48159,   193, -2857, -2857, 48159, -2857, -2857,  1281,   946,
   48159, -2857, -2857, -2857, -2857, -2857, -2857,  1281, -2857, -2857,
    2060,  1668, -2857,    96,   861,  1675, -2857,  1677, 48159, 41175,
   48159, 48159, 43115, 48159,  1729,  1676, -2857,  1706,  1672, 27083,
   -2857, -2857,    85, 43115,  1821, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, 42727, 48159, -2857, 19869, 18225, -2857, -2857, -2857,
    1685,  9723,  1709, 19869, -2857, -2857, 19869, 19869,  -129, -2857,
    -129, -2857,  1682, -2857,   861, -2857, -2857, -2857, -2857,  1539,
     861, -2857,  1684,  1684, -2857,  4505, 19869,   861, -2857, 29074,
   19869, 20280, 15383, -2857, 19869,  1734,  1735,   861, -2857,   861,
   -2857, 19869, 16581, -2857, -2857,   982,  2009,  2009,    63,   725,
     584,  3313,  1678, -2857,  1776,   861, -2857,   861,    22, 40010,
   19869, 34564,  1743, 20280, 19869,  1687,   813, -2857, 19869,   517,
   -2857,  1688, 19869,  1753,   110, 19869, 19869, 19869, 19869, 19869,
   19869, 19869, 21910, 22321, -2857, 20691,   120,   645, 35730, 16992,
    1920, -2857,   804, 14971, 38842, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857,   861,  1694, -2857,  1715, -2857, -2857,
   -2857, 48159,  1871, -2857, -2857, -2857, -2857,  1764, -2857, -2857,
   -2857,  1062, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
    1698, -2857, -2857, -2857, -2857, -2857, -2857, -2857, 50867,  1711,
   48159,    48, -2857, -2857, 41951, 48159, -2857, -2857,  1904, -2857,
   -2857,  1701, -2857,  6428,  1904,  1856,  1863, -2857,   323,  9723,
    1896,  9723, -2857, -2857, -2857, -2857,  1213, -2857, -2857,  1403,
    1719, 13513, -2857, 13893, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,   979,  1720,
    2094,  1246, -2857, -2857, 37675, -2857, -2857, 33004, -2857,  1726,
   -2857, -2857, -2857, 38842,  1131,  1719, 10948, -2857, 10948,  1719,
   -2857,  1721, -2857, 48159, 48159, -2857, 34564, 48159, 48159, -2857,
    1724, 48159,  1913,  1915,  1727, -2857, -2857, 48159, -2857,  1879,
   19869,  1884, 48159, -2857, -2857, -2857, -2857,   684, -2857, 34953,
    1797,  1798, 48159, 48159, 48159, 48159, 48159, 48159,   -25, 48159,
   48159,  1730,  1731,  1737, -2857, 48159, 48159,   979, -2857,  2042,
     979,   979,   762,  1514,  1514, -2857, -2857, -2857, 48159, 48159,
   48159,  1811, 48159, 48159, 48159, 48159,   112,  1086, 48159, 48159,
    1853, 48159, 48159, -2857,  1161, -2857, -2857,  1962, -2857, -2857,
    1766,   861,  1793, -2857,    42,  1865, -2857, -2857, -2857, -2857,
   19869, 29871,  2072,  1946,  1950,  1800, 39232,   -66, 48159, 48159,
    1957,   -66, -2857, -2857, -2857,   296,   873, -2857,  1777, 19869,
      57, 40010,  1768, 25492, -2857,  1831, -2857,  1832,   861, -2857,
    1581,    75,  1782,  1782,  1782,  1782,  1782,   616, -2857, -2857,
     370,   861, 48159, -2857,  2002, -2857,  1659, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857,  1766, -2857, -2857, -2857,  1919,
    1916, 48159, -2857,  1161,   534, 43115, 41563,   125,  2004,   993,
   43115,  1895, -2857, 48159,  2114,  2016,  2017,  2033, -2857,  9723,
    1801, 40010, -2857, 48159,  1802,   193,   193, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, 38842,   904, -2857, -2857,   904, -2857,
     904,  2209,  1497,  1805, -2857,  1454,  1497,  1497,  1676,  1497,
   45443, -2857, 18636,   901, -2857, -2857,   411, -2857,   452,   613,
    1985, -2857, -2857, -2857,  2035, -2857,  9723,   918,  -131,   740,
   -2857,   861, 19869,    94, -2857,  7440,   919,  7490,   930, -2857,
    1814,  1817,   953, -2857, -2857, -2857, -2857, -2857, -2857,  1819,
    2048, -2857, -2857,  1825, -2857, -2857,  1703,  1041,  1828,  8179,
    1835, 20280, 20280, 20280,   836, -2857, 20280,  1838, -2857,  1099,
    6662,  1834,  1845,  1874,  1875,  1848,  1849,  9113, 19047, 19869,
   19047, 19047,  9139,  1834,  1851, -2857, -2857, 19869, 48159,  1854,
    1855, -2857, -2857,  4505, -2857,  1881,  1355,  3758, 17403, -2857,
   -2857,  2065, -2857,  1094, -2857,  1857, -2857, -2857,  5346, 20280,
   19869,  1687, 19869,  1922, 29074,  8284, 19869,  2728,  2813,  2813,
      95,    95,    63,    63,    63,   725,   645, -2857, -2857, -2857,
    1860,  1422,  1423, 43115,  2650,  3966, -2857, -2857, -2857, 24706,
    1517, 19869, 19869,  1861, -2857,  1108, -2857, -2857,   562,  2209,
     861, -2857,    25,   861,    22, 31044,  1719, -2857,  1864, -2857,
   48159,  1517,   743, -2857, -2857,  1110, 19869, -2857, -2857,  1543,
   -2857, 48159, -2857, 19869, 19869, 17814, -2857, -2857,  1877, -2857,
   -2857, -2857, -2857, -2857,  1858, -2857, -2857, -2857, 48159, -2857,
   -2857,  2246,  1866,  1862,  1868,  1867,   984, -2857, -2857, -2857,
   -2857, -2857, 19869,    73,  1876,  1878, 48159,   193, -2857,  9723,
   -2857, -2857, -2857,   668, 40010, -2857, -2857,   118,  1439, -2857,
     158,   255,   268, 48159, 48159,  1490,  1490, -2857, -2857, -2857,
   -2857, -2857, -2857,  1007, -2857, 40010,  2008, 39621, -2857, -2857,
   -2857, -2857,   979, -2857, -2857, -2857, -2857, -2857,   979,   979,
   -2857, 40010,   453, -2857, -2857,   193,   193, -2857,  1939, -2857,
   -2857, -2857, -2857, -2857,  1943, -2857, -2857, 48159, -2857, -2857,
    1766, -2857, -2857, -2857,  3220,  1880, 40010,   -66,   -66, 48159,
    1883, -2857, -2857, -2857,  2074,  2076,   -66, -2857, -2857, -2857,
       6, -2857, -2857, 34564, 28262,  3918,  1885, -2857,  1888,   861,
    1719, 25902,  1325, -2857, -2857, -2857,   458,  2055,  1889,  2036,
   -2857,     0,   142, 45831, 46219, 46607, -2857,  1063, -2857,  1490,
    1948,   729,   737,  1933, -2857, 43115,    75,  1121, -2857, 40010,
    1899, 43115,  1900,  1894, -2857, -2857, -2857, -2857,  1128, -2857,
   40010, -2857,  2049,  2056, -2857, 48159,  1966,  1956, 40010,  2058,
    1135, -2857, -2857,   -57, -2857, -2857, 26690,   193,  1914,   193,
     193, -2857, -2857,   834, -2857, -2857,  1910, -2857,  1930, -2857,
   -2857, 41175, -2857, 48159,   606, -2857, -2857, -2857,  9723,  1150,
   -2857,   487, 48159,   982, -2857, -2857, -2857, -2857,  2161,  2163,
   -2857, 45443, -2857, 19869, -2857, -2857,  1923,  1921,  9609, 19869,
   -2857,  2169, 40010, -2857, 48159, -2857, -2857, -2857, -2857,   861,
   -2857, 19869, -2857, 19869, -2857,   861, -2857, 19869,  2151, -2857,
    2265,    51,  2265, 40010, 20280,   695,  1542, 21499, 20280, 20280,
   20280, 20280, 20280, 20280, 20280, 22718, 23129, -2857,   149, -2857,
   -2857, 19869, 19869,  2158,  2151, -2857, -2857, -2857,  1346,  1346,
   40010,  1927,  1834,  1932,  1935, 19869, -2857,   982,  4993, -2857,
    2233,   993, 21102, 20280, 19869,  1151, 19869, -2857, -2857,  1937,
   -2857, -2857, 40010, 19869,  1619,  5925, -2857,  5989, 19869,  1938,
    6546, 17403, -2857,   654,   654,   654,   654, -2857, 43115, 43115,
   24313, 46995,  1934,    92, -2857, 46995, 47383, -2857,   982,  2162,
    1157,  1178, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,  1936,
   -2857,  1959, -2857, -2857,   -20,  1949, -2857, -2857,  2246,  1960,
    1034, -2857, -2857, 19458, -2857, -2857,  1951, -2857, -2857,  1497,
   -2857, -2857, -2857, 10948, -2857, -2857,  1975, -2857, -2857, -2857,
   -2857, -2857,  2007,  2019,  5025, -2857, 48159, 48159,  1180, -2857,
   -2857, -2857,   846, -2857, -2857,  2020,  2021, -2857,  2022, -2857,
   -2857, -2857, -2857, -2857, -2857,   478,    32, 40010, -2857, -2857,
   -2857, 48159, 48159,  1490, -2857, -2857,  2153,  1961, -2857, -2857,
    2154,  2155,   -66,   -66, -2857, -2857,  1514,  2220, -2857,  1951,
    1312, -2857, -2857, -2857, -2857, -2857,   491,   861,  1399,  1965,
   -2857,  1229, 25902, 25902, 25902, 25902, 25902,  1719,    22, 43115,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857,  1968, 48159, 20280, -2857,   744,    64, -2857,
    2156, 43115,  2010, -2857, -2857, -2857, 40010, 43115,  2197,  2109,
   -2857, 48159, -2857, 41563,   841,  2178, 41563, -2857, 48159,  2293,
    2294,   -57,  2164,  1439,   993, 48159,  1973,  1812,   395, -2857,
   48159, -2857, -2857, -2857, -2857,   193, -2857, -2857,  1315,   904,
     562, -2857, -2857,  2196, 45443, -2857, -2857, 18636,  1977, -2857,
   -2857, -2857, -2857,    30,  9723, -2857, -2857, 19869,  9723, -2857,
    1978,  1981,  1984,  9723,  5253,  1987,  9723,  2158, -2857,   577,
    2207,  2130,  1986,   149,   577,  1641,  1641,   156,   156,    51,
      51,    51,  2265,  9723,  9723, -2857, -2857, -2857, -2857,  1988,
   -2857, -2857, -2857,  1834, -2857, -2857,    22, -2857,   300,  1295,
   -2857,   205, 40010, -2857,  1186,  1295, 20280, 19869, 19869,  7024,
     160, 19869,  5589, 43115, 43115, 43115, 43115, -2857, -2857, 23526,
      92,  1989, 48159, -2857,  1991, 24706,  2183,  2133, -2857, 24706,
    2133,   767,  2133, 24706,  2184, -2857, 27869, -2857,  1997,   804,
    2308,  2221, -2857, -2857,   562,  1191,   993, -2857,  2005, 48159,
   -2857,  9723, 29074, -2857, 48159, -2857, 48159, 48159, -2857,  1195,
    1196,  2010,  2061, 48159, 48159, 48159,  1063,  2159,  2165,   861,
   48159,  2052, -2857, -2857,   -66,  2204,   -66,   -66, -2857, -2857,
   -2857,   993, -2857,   775,  2275, -2857,  2223,   470,  2023,  2244,
    2249, -2857, -2857,   940,   940, -2857, -2857, -2857, -2857, -2857,
    2248, 19869,   706,   577, -2857, -2857, -2857, -2857,  2010,  1660,
    2234, -2857,  2069,   303,  2277,  2271,    75, -2857,  2030,  2295,
    2297, -2857,  2040,  1406, -2857, -2857, -2857, -2857, -2857, -2857,
     993, -2857,  1581,  2263, -2857, 25099,   993,  2185,  2138, -2857,
   37675,  2198,   550, -2857, -2857, -2857,  2253, -2857, -2857, -2857,
   -2857, -2857,  2107, -2857, -2857,  2276, -2857, -2857,  2187, -2857,
   -2857, 18636, -2857,  9723, -2857, -2857, -2857, -2857, -2857, -2857,
   20280,  2047, 20280, -2857, -2857,  1208, -2857, 40010,   300,  1295,
    1295, 19869,  1295, -2857, -2857, -2857, -2857, -2857, 46995,  2051,
   48159,    92, 24706, -2857, -2857,   537, -2857, 24706,  2239, -2857,
   -2857, 24706, 48159,  2054, 48159, 19869, 19869, -2857, -2857,  1312,
   -2857, -2857, -2857, -2857,    22, 19869, -2857,  2059, -2857, -2857,
   -2857,  2172,  2010, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, 19869, -2857, -2857,   -66, -2857, -2857,   928, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, 41175,  2379, 43115,   491,
    5810,  2212, -2857, -2857,  2236,  2134, 48159, 41563, -2857,   728,
    2186, -2857,  1406, -2857, -2857, 43115,  2208,  2213,  2214, -2857,
   48159, 19869,  1211, -2857, 47771, 15794, -2857,  2068,  2228,   746,
   -2857,  2222, -2857, -2857,  1473, -2857, -2857, 43115,   -57, -2857,
    1250,   195, 20280,   508, -2857, -2857,  1295, -2857, 48159,  1254,
   -2857, 19869,  2077, -2857, -2857, 24706,   537,  1263, 48159,  1265,
   40010,  1834,  9723, -2857, -2857, -2857,  2211,  2075, -2857, 43115,
   -2857,  9723, -2857, -2857, -2857,  1794,  1794,   -14,  1794, -2857,
    1794, -2857,  2379,  2400, -2857, -2857,  2314, -2857,   563,  2227,
   48159,  2409, -2857, -2857, -2857, 48159,  2214,  1267, -2857, -2857,
    2377,  2166, -2857,  6024,  2166, 25099, 48159, -2857, -2857, -2857,
     993,  2296, -2857, -2857,  2243, -2857,  1517, -2857,  1081, -2857,
    1273, -2857,  9723, 48159, -2857, -2857, -2857,  1274, -2857, 19869,
   -2857,  1660,   993,  1766,  2247, 48159,   993,  1766, -2857, -2857,
    2341, -2857, -2857,    76, -2857,  2241,  2250, -2857,    37,  2099,
    2166, -2857,   509, 48159, -2857, 47771,  1517, -2857, -2857, -2857,
   -2857,  2304,  2356, -2857, -2857,  1276, -2857, -2857,  2236, -2857,
   -2857, 48159,  2097, -2857, -2857,  2210,   544,   544,  2157, -2857,
    2367, -2857,   861,   861, 40010,  2103, -2857, 32608, -2857,  2224,
   -2857,  2226, -2857, -2857, -2857, -2857,   468, -2857,  2227,  2097,
    2351, -2857,  2446, -2857,   102, -2857, -2857, 41175, 29074, -2857,
      37,  1294, -2857, -2857, -2857, -2857, -2857, -2857, -2857,   475,
     491,  2242, -2857, -2857, -2857,  1454,  -103, -2857, -2857, 32608,
   -2857,    72, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   41175, -2857, -2857, 39232, -2857, -2857,  1356, -2857, -2857,  1357,
    1381,  2121,  2127, -2857,    72, 32608,  2251, -2857,  1300, -2857,
   -2857
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2857, -2857, -2857, -2857, -2857,  2320, -2857, -1717, -2857, -2857,
   -2857, -1150, -2857, -1680, -2857,  1114, -2857, -2857, -2857, -2857,
   -2857,   671, -2857, -2857,  -753, -2857,  1321, -2857, -2857,   464,
   -2857, -2857, -2857, -1438, -2857,   168, -2857, -2857, -2857, -2857,
   -2857, -2857,   745, -2857,   776,   373, -1424, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -1381,   682,
     -24, -2857,   -26,   763,    60, -2857,  -209, -2857, -2857, -2857,
    -238,   432, -2653, -2075,   -33,  -520,  -547,  -493,  -491,  -522,
   -2857,  -355,  -438, -2062, -2548, -2857, -2857, -2857, -2857, -2857,
      -8, -1373, -2857,  1136, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857,  -107, -2857, -2857, -2857, -1370, -2857,   721, -2174, -2857,
   -2857, -2857,  -589,  -562, -2857, -2740,  -167,  -165, -2857, -2857,
   -2857, -2857, -2857, -1037, -2857,   369, -2857, -2857, -2857,  -534,
    1162,  -578, -2857, -2857, -2857, -2857,  -672, -1398, -2857, -2857,
    2431,   638,  -168, -2857, -2857, -1733, -1369, -2857,  1769, -2857,
    1507,  1084,   281,    -1, -2857, -2857, -2857, -2222, -1366, -2857,
   -2857, -2857,  -411, -2749, -2857,   741, -1061, -2857,   476, -2857,
   -2857, -2857,   340, -1665, -2857,  -196, -2857, -2857, -2857, -1353,
   -2857, -1466, -1323, -2857,  -381, -2857, -2857, -2857,  1525, -2857,
     359, -2857, -2857, -2857, -2857, -2857,  -512,  -544, -2857, -2857,
   -2857,   113, -2857, -2857, -2857,  1113,  -985,  -828,  1774, -1365,
   -2857, -2857, -2857,   766,  -125, -2857, -2857, -2857, -2857, -1541,
   -2857, -2857, -2857,   957,  2488,  -688, -2857, -2857, -2857, -2857,
   -2857, -2857,   -27, -2857, -2857,   328,   -10, -2857, -2857, -2857,
   -2857,    -4,  1565,   722,    40,   -69,   -71,  -215,   485,   497,
   -2857, -2857,  -166,   892, -2857, -2857, -2857, -2857,   546,  1390,
   -2857,   540,  -322, -2857, -2857,  1394, -2857, -2857,   976, -2857,
   -2340,   229, -2339,   -51,  -933,  -325,  -157, -2857, -2003, -1954,
      71,  2264, -1630, -1858,  1247, -2857,  2417,  2702, -2857, -2857,
    -976, -2857, -2857,  2871,  3330, -2857, -2857,  4630,  5755, -2857,
   -1000,   263,  6870,  1466, -1105, -1408,  9132, -1244, -1538, -1973,
   -2857, -2857,  -695, -2857, 10093,   433, -2857, -1161, -2857,   -17,
   -2857, -1464, -2857, -2857, -2857, -2857, -2857, -1569, -2216,  -742,
     615, -2857, -2857,   697, -2857, -2857, -2857,  -700,  -945, -1576,
     184, -2857,  1040, -2857,   -54,  -387,   576,  -164,    52,  6228,
    -819,  2599,  -844,  1717,  -648, -1862, -1226,  1621, -2857,  -670,
   -2857,    -2,    58, -2857, -2857,    93,  -154, -2857, -1614, -2857,
     -41, -2857,  -846,  -901, -2856,  -620, -2857, -2857,   -89, -2857,
    1740, -2857,   943,  1378, -2857, -2857,   948,  -810,   -99, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857,  1413,    69, -2857,   -62,
   -2857, -2857,  2612, -2857,  2375,   -45, -2857,  2026,   -38, -2857,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,  -791,   983,
   -2857,  1732, -2857, -2857, -2857,  -740, -2857, -2857, -2857,  1580,
    -153, -2857, -2857, -2857,  -975,   879,  1765,  -814,  -972,   951,
   -2857, -2857, -2857, -2857, -2857, -2857, -2857, -2857,   756, -2857,
   -2857,   609,   760, -2857, -2857,    86, -2857, -2857,   -21,    90,
   -2857,  1488, -2857, -2857, -2857,   243, -2857, -2857, -2857,  -545,
    7560,   107,   -56,   -39,   129,  1472,  7460,   933,  -654,   -74,
    1445,  5789,  9026,   -31,   -44,   135,   202, -2857, -2857,  2368,
     966,   781,  -855,  6691,  1214,  3018,  4323,  -702,  -807,  1784,
    -502, -1283, -2857,  2719
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1717
static const short yytable[] =
{
      69,   779,   992,   300,   799,   299,  1105,  1223,  1446,  1476,
     877,  1010,  1924,  1592,  1455,   350,   667,  1327,   970,   963,
     973,  1382,  1908,   976,   799,  1869,  1742,   950,  1234,   314,
    2088,  1000,  1794,  2005,   663,  1045,   316,  1870,   667,   705,
     829,   552,  1313,   972,   974,  1061,   671,   294,   750,   866,
    1033,   664,  1922,  1580,  1038,   750,   663,   746,  1928,   670,
      70,  2299,   872,  1282,   295,  2005,  1051,  1888,   671,  1073,
     297,  2498,  1970,   664,   977,  1889,  1037,  2439,  1890,  1891,
    2118,   670,  1892,  1893,  1001,  1066,  2188,  2189,  1317,  2621,
    2700,  1070,  2589,  1086,   750,    71,  2715,  2717,  2472,  1226,
    1100,  1232,  2165,  2166,  1081,  1755,  2437,  2102,  1041,  1219,
    1488,  1069,   925,  1489,  2155,  2131,  1291,  1292,  2227,  2135,
    1052,  1920,  1634,  1498,  1499,  1544,  1545,  1287,  2363,  1314,
    1310,  1307,  1454,  1594,  1088,   823,  2934,  1483,   959,  1862,
    1599,  1483,  1071,   667,  1564,  -769,   349,  1504,  1220,  2236,
    -937,  2560,   706,  1078,   876,   300,   798,   299,  1556,   939,
    1602,   663,  -942,  1310,  -256,  1956,  1517,  2665,  1865,  1467,
    2211,  1522,  1599,   671,  1490,   551,   798,  1760,   664,  1806,
     151,   341,   575,  1770,   341,  1090,   670,   277,  1761,  3016,
    2031,  1760,  1602,  2903,  3172, -1089,  2221,   341, -1193,   294,
    1853, -1089,  2259,  1003,  -769,  2067,  3039,  1379,  1468,   343,
   -1526,  2068,   343,  1295,  1097,  1344,   295,  2786,  2281,   341,
     904,   575,   297,  1631,  1824,   343,  2363,  3112,   151,  2706,
    2237,  1896,  3106,  2363,  2199,  -772,  2079,   167,  1648,   575,
    2933,   676,   845,  3064,  1762, -1105,  1998,   343,  1003,  1382,
   -1528, -1105,  1632,  3153, -1621,   921,  1347,  1957,  1762,  1847,
    2339,  3143,  1010,   203,   905,   550,   889,  1866, -1578,   551,
      52,  -922,  2363,   890,  -922,  1004,   344,  1469,     3,   344,
    3065,  2707,  1599,  2334,  1649,   167,   916,  1979,  1897,  2748,
    2333,  1215,   344,  2565,  -772,  1554,   682,  1345,   683,   903,
    1349,  2708,  1602,  3143,  1483,  1227,   917,  1903,  1353,  1848,
    3113,  1387,  3173,   890,   344,  1580,  2709,   846,  1470, -1623,
    1004,  1380,  1628,  2710,   341,    49,  2787,  1394,   550,  3143,
    1843,   183,  1662,  1484,  1331,   203,  3123,  1484,  1337,   277,
     907,  2711,  1216,  1389,   203, -1643,   868, -1525,  1763,  1391,
   -1656,   904,   343, -1673,  3000,  1386,   686,  2530,   225,  2036,
   -1524,   947,  1763,  1854,  3154,  2871,  1293,   943,  2749,  2875,
    2365,  2750,  1445,  2880,  1967,  1968,  3114,  2363,  2535,  2323,
    2220,  2200,  1471,  2551,  1461,  1976,  1978,   687,  1464,  1523,
    1518,    49,   203,   219,   550,   905,  1838,  1958,   906,    52,
    1477,  1381,  2712,  1911,  2212,  1814,  1544,  1545,  3098,  1867,
    3169,  2009,  1959,  2011,  1564,  1325, -1717,   915,   341,   344,
    1338,  2739,  2740,  1539,  1764,  -937, -1717,  -769,  -937,  -769,
    1519,  2849,  1595,  1556,  1306,  1346,   924,  -942,  1764,   225,
    -942,   219, -1089,   550,  1898,  3107,   343,  1485,    52,  -937,
    2397,  2624,  2069, -1621,  1401,   341,   793,  2437,   341,   926,
    1863,  -942,  2376,  2005,  2005,  2005,  2468, -1578,  2005,  2100,
    1863,   907,  2085,  1706,  1623,  1972,  2463,  1641,  1642,  1314,
    1736,  2713,   550,   343,  2528,  2529,   343,   225,  2215,  2501,
     550,   550, -1105,  2534,   550,  1731,   927,  1010,  1307,    52,
    1484,  2301,  2302,  1620,  1621,  1622,  1623,   793,  2282,  2283,
     684,  2005,    49,   344,  1931,   550,  1930,  -772, -1623,  -772,
      52,  2365,    53,  2470,  1629,  1933,   830,  2523,  1279,  2977,
    2139, -1526,  2980,    49, -1526, -1526,   550,  2984,   978, -1526,
     908,  2986,  1905,   997, -1643,    49,  1844,   948,   550, -1656,
     344,  2828, -1673,   344,  3147,  2371,  2372,  2373,  2374,  2375,
    2376,  1684,  1994,  1995,  2373,  2374,  2375,  2376,   909,  1905,
    2444, -1528,  -183,  2366, -1528, -1528,  2445,  2446,  2447, -1528,
    1271,  1339,  1759,  2324,  1865,  2363,   568,   831,  2448,  2449,
    2450,  2113,  2451,  2452,  2453,  1062,  1770,  1065,  2454,  2455,
    2456,  2371,  2372,  2373,  2374,  2375,  2376,   667,  2829,  1030,
    2550,  1618,  1619,  1620,  1621,  1622,  1623,  2515,   575,  2049,
    1823,  1058,  2941,  2762,  2326,   663,  1094,  1387,   799,  1768,
     799,   151,   799,  2228,  2229,  1055,   904,   671,   799,  1093,
     961,  1767,   664,  1797,  2762,  3054,  1760,   890,   921,   750,
     670,  1082,   550,  1806,  2363,  3131,  1716,  1761,  1107,    69,
     992,   126,   127,  1768,  1942,  3119,  1946,  1947, -1525,  1949,
     686, -1525, -1525,  3120,  2706,  1695, -1525,  1386,  1798,  1083,
     905, -1524,  3148,  1866, -1524, -1524,  2466,    49,   167, -1524,
     550,  1906,  2367,  1948,  2773,  2774,  2775,  2776,  2777,  2763,
    1717,   687,  1771,   921,  3012,  2962,  2371,  2372,  2373,  2374,
    2375,  2376,  1881,  1762,   354,  2830,  2050,   677,  2937,    70,
    2051,  1845,  1599,  2499,   832,  1850,  2707,  2764,   678,  2365,
    1773,  2419,  2437,  3160,   183,  2747,  2437,  1774,  2325,  1799,
    2437,  1882,  1602,  2814,  2114,  1059,  2708,  1858,  2764,  1696,
    2052,   921,  3071,  1329,    71,  -777,   907,  2360,  2361,  2362,
    2502,  2709,  2378,   569,  2831,   883,  1272,  -777,  2710,  1769,
    2963,  2519,  2520,  1719,  1330,  1800,  1718,  1801,  2516,  2327,
     798,  2366,   798,  1872,   798,  1643,  2711,  1802,   341,  2647,
     798,   798,   341,  1243,  1260,   203,  3121,  3132,  2365,  2758,
    2759,  -777,  1599,   679,  1775,  2414,  1044,   203,  2981,   716,
    1060,   884,  1229,  1929,  2517,  2666,   343,  1763,  -777,  2760,
     343,   718,  1602,  1644,  2573,  1867,  2005,  1885,  1261,  2005,
    2005,  2005,  2005,  2005,  2005,  2005,  2005,  2005,  2005,  1945,
    1803,  2105,  2954,  1313,   219,  3072,  2053,  2712,  2457,  1720,
    2366,  3133,  -777,  1868,  1873,  2650,  1372,  2575,  2392,   197,
    -777,  1927,  2628,  1886,  2677,  2005,  1606,  1607,  1804,  3134,
     885,  1773,  2635,  2614,   992,  2616,  2617,  2405,  1774,  1373,
    1888,   754,  2122,   344,  2312,   552,   552,   344,  1889,  1317,
    3161,  1890,  1891,  1764,   802,  1892,  1893,  1874,  2784,  2437,
    2367,  3042,   225,   680,  2437,  1610,  2185,  1280,  2437,  2982,
    2368,  2369,  2370,  2363,  2371,  2372,  2373,  2374,  2375,  2376,
    2440,  2441,   163,  2458,  3049,  2328,  2713,  2778,  2987,  2920,
    2989,  1230,  1387,    69,    69,   667,    69,  1374,  1467,   819,
    1235,  1280,   575,  1776,  2785,  1775,   551,  2034,  -777,  1053,
    1652,  2180,  2651,   663,  2183,  2184,  2707,  1259,   886,   877,
    1875,  2652,  1876,  2931,  1715,   671,  3043,  1281,  2579,  2367,
     664,  1054,  3086,  2041,   341,  2921,  2708,  2618,   670,  2368,
    2369,  2370,  2329,  2371,  2372,  2373,  2374,  2375,  2376,  2623,
    3102,  2877,  2042,    70,    70,  2580,    70,   824,  2710,  -801,
    1250,  1281,   343,  2186,  2581,  2187,  1236,   118,  1260,  1083,
    1723,  1237,  2437,  1724,  2799,   300,  1716,  1496,  3118,   551,
     551,  2914,   841,  2916,  2917,   122,  3129,  2624,    71,    71,
    1539,    71,  3003,   300,  3057,  1521,  1311,  2005,  1482,  2364,
    3022,  2129,  1261,  3092,  -942,  2800,  1469,  -942,  1537,   874,
    -801,  1618,  1619,  1620,  1621,  1622,  1623,  2365,  1053,  1492,
    1717,   865,  2954,  3023,  1451,  1558,  3004,   880,  -942,   344,
    2043,  2582,  1575,  1576,  3021,  2044,  1493,  2712,   981,  2045,
    2587,  1452,  1494,  3124,  -801,  3005,  1725,  1470,   982,   983,
     984,  1583,   985,   986,   987,   988,   989,   990,  3006,  1765,
    2152,  1359,  1386,  1590,  1577,  2153,  1360,  1575,  1576,  2366,
    2141,  2892,  3007,  1347,  -916,  -952,   341,  -916,  -952,  1708,
    2649,  1807,  1709,  2653,  2654,  2655,  2656,  2657,  2658,  2659,
    2660,  2661,  2662,  2137,  1348,  1593,  1718,  2140,  1560,  1577,
    1336,  1361,   881,   896,   343,  2473,  1598,  1738,  2005,  1356,
    2779,  1471,  2151,  1362,  2335, -1334,  1008,  1349,  2363,  2678,
    1009,  2336,  1078,  1078,  2167,  2168,  1834,   897,  1359,  1376,
    1357,  2046,   551,  1360,  1835,  2178,  2224,  2225,   898,  2047,
       9,  2573,  3002,  1363,  1687,  1687,  1333,  1687,   893,  1655,
    3008,  2834,  2574,  1836,   667,  1575,  1576,  3009,  2202,  1733,
    2733,  2205,  2206,  -952,  1368,  2812,  -952,  1334,  1361,  2842,
     197,   344,   663,  1820,  2575,  1780,  2576,  1008,   919, -1199,
    1362,  1009,  3010,  1072,   671,  1369,   787,  1579,  2367,   930,
    1335,  1280,  2304,  1280,  2673,  1280,  1781,   688,  2368,  2369,
    2370,   788,  2371,  2372,  2373,  2374,  2375,  2376,  -949,   552,
    1363,  -949,  1749,   899,   717,   550,  2742,   667,  1575,  1576,
      52,   933,  1078,  1756,  2464,  2492,   777,  2479,  2854,   551,
     661,  2577,  -949,  2407,  1745,   663,  2391,  1726,  2393,  2394,
     551,   890,  -919,  2667,  2668,  -919,  2493,   671,  2505,  2232,
    1579,  1281,   664,  1281,  2233,  1281,  1825,  1826,   550,   798,
     670,   900,  2365,    69,   877,    49,  1567,    69,   550,  2506,
     575,   575,  2005,   843,  2005,  1551,  1553,  2321,   943,   550,
    2578,  1364,  2322,   551,    52,  2579,  1311,   667,  1311,  1597,
    1311,  2783,   793,  2545,  2332,  2343,  2511,  1727,  1573,  2333,
    2333,  1658,  2512,  2513,  1365,   663,  2345,  1584,  2554,  2555,
    2556,  2333,  2580,   901,  2366, -1526,  2408,   671, -1526,   992,
    2409,  2581,   664,    70,  1827, -1528,   960,    70, -1528,  2348,
     670,  1393,  1599,   550,  2349,   341,   341,   341,    52, -1532,
      53,   575,  2960,   551,    49,   949,  1279,   550, -1525, -1533,
    1280, -1525,  1602,  1002,  1980,  1008,  1981,  1603,    71,  1009,
    1982,  1012,    71,   343,   343,   343,  1993, -1524,  1412,  2897,
   -1524,  1365, -1530,  1997,  2477,  1828,  1829,  1806, -1196,  1655,
    1087,  1812,  1089,  2015,  1091,  2016,   341,  1659,  2582,  1035,
    1092, -1529,  2363,   341,  2005,  1637,  1036,   223,   341,  1638,
     224,  2029,  2858,  2030,  1830,  2403,  -907,  1008,   876,  -907,
    1281,  1009,  2410,    49,   343,  2729,   550,  2354,  1046,   951,
    2411,   343,  2355,   952,  3062,  3063,   343,  3066,   765,  3067,
     344,   344,   344,  2367,  1056,   953,   954,  2093,  -905,  1382,
    2486,  -905,  1068,  2368,  2369,  2370,  2995,  2371,  2372,  2373,
    2374,  2375,  2376,  2719,  1057,   981,   955,  3093,  1605,   956,
    1097,  1732,  1937,  1831,  1709,   982,   983,   984,   341,   985,
     986,   987,   988,   989,   990,  2380,  1606,  1607,  1991,  1101,
    2333,   344,    49,  1079,  2443,   550,  2474,   667,   344,  2333,
      52,  1651,    53,   344,  2039,  1832,   343,  2590,  1279,  2477,
    1308,  1309,  2591,  2503,  2597,   663,   798,  -908,   798,  2598,
    -908,  2609,   798,   551,   559,  1610,  2610,   671,   798,  1108,
    -906,   581,   664,  -906,   674,   798,  2626,  2680,  1611,  1102,
     670,  2627,  2333,  2722,   674,   798,  2365,   798,  2333,  1858,
     223,    49,    49,   224,   550,   550,  1039,  1078,  1040,    52,
      52,    53,    53,   798,  2723,   798,  2741,  1279,  2889,  2333,
     581,  2610,  2856,   344,  1562,  1563,  2971,  2857,  2973,   674,
     715,  2901,  2902,   957,  1741,  1309,  2610,  2610,   581,   674,
    2094,  1103,   674,  1042,  2974,  1043,   674,  3034,  2366,  2857,
     674,  2116,  3035,  2096,  1709,  2552,  2553,  2554,  2555,  2556,
     890,  1945,  1937,   981,   921,  2772,  1536,  1112,   225,  2120,
     674,  2120,   551,   982,   983,   984,  1113,   985,   986,   987,
     988,   989,   990,  1114,  2125,   674,  3047,  1709,   835,   840,
    3051,  2627,  2641,  1117,   844,  1651,   859,  2209,   864,  3056,
    1118,  3058,   667,  3081,  2591,  1983,  2591,  1614,  1523,  3094,
    3096,  1115,  3127,   552,  1651,  2591,  2363,  1651,  1915,  1916,
     663,  1618,  1619,  1620,  1621,  1622,  1623,  3182,   341,  2686,
    3158,    52,   671,    53,  2248,  3159,  3190,   664,  2363,  1809,
    1233,  3159,  1813,  1815,  2991,   670,  1280,  2258,  3048,  1575,
    1576,  2552,  2553,  2554,  2555,  2556,   343,  1984,  1010,  2557,
    1688,  1690,  1280,  1694,    69,  1238,    69,  2367,  2252,  2253,
    2254,  2255,  1689,  1689,   551,  1689,  1239,  2368,  2369,  2370,
    1240,  2371,  2372,  2373,  2374,  2375,  2376,  2423,  2425,  2424,
    2426,  1246,  3183,  1250,  3184,  -769,  1256,  2876,  1258,  2879,
    1599,  1985,  2769,  2770,  1986,   341,  1281,  1247,   723,  2946,
    2947,  2480,  2481,  1600,  1248,  1280,  1250,  1251,  1280,  1280,
    1602,  1252,  1281,   344,    70,  1603,    70,  1294,  1296,   673,
    1254,  1265,  1257,   343,  2231,  3156,  2476,  2337,   341,   675,
     341,  1269,  1274,   877,  1270,  1273,   674,   551,  1275,   798,
    1276,  1277,  1278,  1285,  1288,   921,  1290,  1311,  1301,    71,
    2365,    71,  1293,  1318,  1319,  1321,   343,  1328,   343, -1532,
   -1533,   727, -1530, -1529,   708,  1281,  1331,  1987,  1281,  1281,
    1341,   798,  2365,   341,   749,  -537,   798,   753,  2286,  1342,
    1352,   749,  1354,  1355,  1370,   797,  1371,  1377,  1378,   798,
     344,  1392,  1390,  1397,  1399,  1403,  1440,  1441,  1401,  1443,
    1447,   343,  2366,  -137,  1449,   827,   729,  1456,  1460,  1472,
    1474,  1478,  1604,  1479,  1480,  2816,  1605,  1527,  2428,  2429,
     749,  1481,  1530,   344,  2366,   344,  1531,  1535,  1651,  1532,
    1543,  1557,  2817,  2208,  1606,  1607,  1988,  3045,  1546,   223,
      49,  1547,   224,   550,   731,   981,  1608,  1548,  1550,  2465,
     551,  1552,   225,  1559,   551,   982,   983,   984,   551,   985,
     986,   987,   988,   989,   990,  1566,  2243,  1569,   344,  1570,
    1609,  1571,  1572,  1610,  1657,  1574,  1581,  1590,  1582,   798,
    1633,  1677,  1678,  1685,  1259,  1707,  1611,  1714,  1612,  1721,
    2039,  1722,  1728,  1730,  1310,  1734,  1737,  1743,  2264,  2818,
    1746,  1744, -1477,  1748,  1753,  1754,  1757,   581,  1756,  2422,
    1758,  1772,   551,  1784,   734,  1782,   735,  1783,  2431,  1785,
    1787,  2367,  1788,  2819,  1786,   736,  1789,  1806,  1795,  1387,
    1796,  2368,  2369,  2370,   739,  2371,  2372,  2373,  2374,  2375,
    2376,  1810,  1613,  2367,  1790,  1811,  1817,   992,  -550,  2820,
    1818,   674,   674,  1819, -1717, -1717,  1821,  2371,  2372,  2373,
    2374,  2375,  2376,  1822,  1816,  1841,  1849,  1846,  1851,  1852,
    1861,  1539,  1871,   725,  1895,  1909,  1859,  1910,  1554,  1560,
    1567,   920,  1901,  1912,  1918,  1913,  1921,  1923,  1934,  1941,
    1950,  1951,  1962,  2013,  2014,  2549,  1599,  1952,  1937,  1935,
    1972,   798,  2035,  1280,  3171,  1614,  1940,  1523,  1979,  2027,
    1971,  2028,  2038,  2054,  2056,  1615,  1616,  1617,  2079,  1618,
    1619,  1620,  1621,  1622,  1623,  2089,  2899,  2090,  2092,  2095,
    2821,   884,  2106,  2905,  2353,  2907,  3027,  2097,  2110,  2111,
    2115,  2822,  1863,  2124,  3050,  2128,  2123,  2136,  2144,  2142,
    2145,  2148,  2146,  2613,  3050,  2823,  2150,  2176,  2163,  2164,
    2181,  2175,  2824,  1281,  2194,  2204,  2207,    49,  2177,   667,
    2213,  2210,   971,   581,   975,  2216,   559,  2217,   674,   994,
     674,  2218,  2219,   674,   674,   971,   559,   663,  2226,  2234,
    1280,  2239,  2246,  2247,  2250,  2260,  1280,  1280,  1311,   671,
    2265,  2266,  2825,   674,   664,  2642,   581,   750,   971,  2285,
     559,  2645,   670,  2288,  1048,   674,   877,  2293,   674,  3095,
     971,  2566,   559,  2294,  2295,   877,  2296,  2297,  2300,   674,
     674,  1643,   300,  2331,  2611,   300,  2311,  2612,   674,  2330,
    2346,   581,  1280,  2347,   559,  2350,  2351,   798,   674,   798,
    1281,  2352,   674,   674,  2356,   559,  1281,  1281,   971,  2561,
     300,  2359,  2629,  2406,  2379,  2333,  1945,  2693,  2694,  2695,
    2696,  2385,  2386,  2387,  2388,  2389,   674,  2396,   674,  2402,
    2400,  2401,  2412,  2418,   674,  2421,  2485,  2442,  3032,  2483,
    2469,  2487,  2489,  1309,  2490,  2491,   928,   929,  1599,  2508,
    2521,  2496,  1281,  2497,  2522,  2532,  2526,  2533,  2547,  2531,
    1724,  1600,   674,  2524,  2548,  2558,  1111,  2559,  1602,  2586,
     551,   551,  1060,  1603,  2593,  2596,  2595,  2604,  2599,   551,
     803,   581,   674,   674,   859,  2600,   859,  1311,  2605,  2608,
    2615,  2619,  2620,  2631,  2243,  2632,  1536,  2636,  2639,  2382,
     341,  2381,  2363,  2670,  2562,   551,  2816,   798,  2671,  1594,
    1590,  2672,  2682,   798,  2690,  2705,  2720,  2724,  2736,  2699,
    2676,  2725,  2728,  2817,  3088,  2726,  2732,  2734,   343,   804,
    2737,  2743,  2744,  2745,  2754,  2756,  2757,  2755,  2761,  2771,
    2794,  2788,  2790,  2781,  2796,  2802,  2807,  2808,  2815,  2838,
    2810,   805,  2841,  2768,  2844,  2850,  2851,  2845,   559,   559,
    2846,  2852,  1300,  2848,  2853,  2868,  2870,  2872,  2881,   806,
    1604,  2873,  2884,   979,  1605,   995,  2885,  2886,   998,   999,
    2895,  2908,  2904,   674,  2912,  2915,   674,  2909,  2922,   674,
    2818,  2763,  1606,  1607,  2926,   344,  2928,  2925,  1034,  2927,
    2935,  2936,  2938,   992,  1608,  2940,  2942,  2943,   807,  2944,
    1049,  2950,   971,  1050,  2819,  2945,  2958,  2959,  2967,  2968,
    2961,  2969,  2972,  2985,   920,   749,  2978,  3155,  1609,  2988,
    2999,  1610,  3013,  1067,  2787,  2998,  3018,  3028,  3020,  3025,
    2820,    69,  3029,  1074,  1611,  3030,  1612,  1075,  1076,  3040,
    3041,  3060,  3053,  3044,   551,   674,  3069,  3070,  3073,   674,
    3181,  1433,  3078,   674,  3082,  3091,  3105,  3090,   674,  3101,
    3083,  1095,  3108,  1096,  3117,  3125,   971,  3126,  2610,   920,
     804,  3110,  3130,  3106,  3140,  3151,  3107,  3152,   971,  1463,
     300,   674,  2809,   808,  1433,  3170,  3185,  3145,  1726,  3146,
    1613,    70,   805,  3186,   971,   798,   879,  1109,  3172,   809,
     798,   798,   798,   798,   798,   810,  2261,  1880,  1676,  2467,
     806,  2821,  2201,  2813,  2171,  2518,   674,   920,  2262,  2798,
    2804,  2190,  2822,  2932,  2746,  2495,    71,  2833,  3128,   674,
     811,  3150,   812,  3111,  3109,  3136,  2823,  3026,  3080,  1534,
    2805,   813,  2249,  2824,  1904,  2910,  3188,  3175,  1727,   807,
    2924,  2923,  2538,  1614,   814,   815,  3157,  1884,  3189,   826,
    1516,  1116,  2633,  1615,  1616,  1617,  1964,  1618,  1619,  1620,
    1621,  1622,  1623,  2839,  3087,   551,   551,  2263,  2607,  2500,
    2965,  3068,  3059,  2825,  2431,  1529,  2964,  3163,  2431,  1241,
    3187,  2103,  2431,  2256,   780,  2243,  2243,  2243,  2243,  2243,
    2630,  1495,  2475,  1704,  2303,  2482,  1702,  2101,  2835,  2701,
    2878,  3055,  2797,  2675,  1860,  2855,  2416,  2544,  1320,  2078,
    2340,  1322,  3097,  1303,  1324,  2896,  2471,  2970,  1462,  2840,
    2127,  1739,  2126,  1713,   808,  2894,   311,   891,  1526,   581,
     581,   942,  2117,  1326,  1297,  2130,  2309,   551,  2462,  1661,
     809,  2310,  1656,  2888,  1640,  2836,   810,  1674,  1675,  1674,
    2837,  2727,  2159,  1710,  2134,   913,  2305,  1936,  1683,  1305,
    2919,    76,     0,  1937,     0,     0,     0,     0,     0,     0,
       0,   811,     0,   812,     0,     0,     0,   712,     0,     0,
    1395,     0,   813,     0,  1396,     0,     0,   798,  1398,     0,
       0,     0,     0,  1439,     0,   814,   815,     0,     0,     0,
     581,     0,   559,     0,     0,     0,     0,     0,     0,  2949,
       0,     0,     0,     0,   820,  2957,  1465,     0,     0,  1655,
       0,     0,   828,  2890, -1714,     0,     0,     0,     0,     0,
       0,     0,     0,   674,  1433,     0,     0,     0,     0,     0,
       0,  2431,     0,     0,     0,  1599,  2431,   859,     0,     0,
    2431,  1497,     0,     0,     0,     0,     0,   870,  2891,   551,
    1433, -1714,     0,     0,  1525,  1602,     0,   994,     0,     0,
    1603,     0,     0, -1714,     0,     0,     0,     0, -1714,     0,
       0,     0,     0, -1714, -1714,   859, -1714,   551,     0,   551,
     551,     0,     0,  1599,   551,     0,  1433,     0,     0,     0,
       0,     0,     0,     0,     0,   971,  1600, -1714,     0,   971,
       0,     0,     0,  1602,     0,     0,     0,     0,  1603,     0,
       0,     0,     0,  1433, -1714,     0,     0,  2993,     0,     0,
    1599,     0,     0,     0,     0,     0,     0,   300,     0,  2612,
       0,     0,     0,   551,     0,     0,     0,     0,  1433,   551,
    1602,     0,     0,   551,  2431,  1603,     0,     0, -1714,   559,
       0,   674,     0,     0,     0,     0, -1714,  1604,     0,     0,
       0,  1605,  1656,     0,     0,     0,     0,     0,     0,     0,
    1433,     0,     0,     0,  1433,     0,  3180,  2994,     0,  1606,
    1607,     0,     0,   559,     0,     0,     0,   971,  3137,  3138,
       0,  1608,   674,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1604,     0,     0,     0,  1605,
     674,     0,   674,   674,     0,   674,     0,     0,  1610,     0,
       0,  1955,     0,   824,     0,     0,     0,  1606,  1607,  3089,
       0,  1611,     0,     0,     0,  1965,     0,     0,   551,  1608,
       0,     0,  1604,     0, -1714,     0,  1605,     0,     0,     0,
       0,  3099,     0,     0,     0,  3103,     0,     0,     0,     0,
       0,     0, -1714,  1609,  1606,  1607,  1610,     0,  1747,     0,
       0,   994,     0,     0,     0,     0,  1608,     0,     0,  1611,
       0,  1612,     0,     0,     0,     0,     0,  1613,     0,     0,
       0,     0,     0, -1714,     0,  1433, -1714, -1714, -1714,     0,
       0,     0,     0,  1610,     0,     0,     0,     0,   300,     0,
       0,     0,     0,     0,     0,     0,  1611,     0,     0,     0,
    3179,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     566,     0,     0,     0,     0,  1613,   674,   582,     0,     0,
     798,   798,     0,   300,     0,     0,     0,     0,     0,     0,
    1614,     0,     0,   674,     0,     0,     0,     0,     0,     0,
    1615,  1616,  1617,   551,  1618,  1619,  1620,  1621,  1622,  1623,
       0,     0,  1613,     0,     0,     0,   582,     0,     0,     0,
       0,     0,  2099,     0,     0,   551,  3100,   674,     0,   551,
    3104,     0,     0,     0,   582,   582,  1894,     0,  1614,     0,
       0,     0,   582,     0,     0,     0,   566,     0,  1615,  1616,
    1617,     0,  1618,  1619,  1620,  1621,  1622,  1623,     0,     0,
    1839,     0,     0,     0,   566,     0,   566,     0,     0,  1840,
       0,     0,     0,     0,     0,  1614,   559,  1932,     0,  1300,
       0,   582,     0,     0,     0,   674, -1717, -1717,     0,  1618,
    1619,  1620,  1621,  1622,  1623,   559,   674,     0,     0,   559,
     581,     0,     0,   674,     0,     0,     0,     0,     0,   674,
       0,     0,     0,     0,   559,  1433,     0,     0,     0,     0,
       0,     0,     0,     0,   559,   559,   559,   559,   674,   674,
       0,   674,  2174,     0,     0,     0,     0,   559,   674,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2191,  2192,   674,     0,   674,  2196,   674,   674,     0,     0,
     559,   674,     0,   559,   559,     0,     0,  1599,   996,  1422,
       0,     0,     0,     0,     0,     0,     0,  1433,     0,     0,
    1600,     0,  1433,     0,     0,     0,     0,  1602,  1032,     0,
     971,   971,  1603,     0,     0,     0,     0,  1433,     0,     0,
       0,     0,  1475,     0,     0,  2245,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2086,     0,     0,   559,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2091,     0,
       0,     0,   582,  2269,     0,     0,     0,     0,  2280,     0,
       0,     0,     0,     0,     0,  2292,     0,  1433,     0,     0,
    1599,     0,     0,     0,     0,  2174,     0,     0,     0,     0,
       0,     0,     0,  1600,     0,     0,   674,     0,     0,     0,
    1602,     0,     0,     0,     0,  1603,     0,     0,  1104,  1604,
       0,     0,  2316,  1605,  1106,     0,     0,     0,     0,     0,
       0,     0,  1110,     0,     0,     0,     0,     0,     0,     0,
       0,  1606,  1607,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1424,  1608,     0,     0,     0,     0,     0,     0,
     920,     0,     0,     0,     0,  1242,     0,     0,     0,     0,
    1245,  2138,   755,     0,     0,     0,     0,  1609,  2143,     0,
    1610,  1253,     0,   756,  2147,  1424,     0,     0,     0,     0,
       0,     0,     0,  1611,     0,  1612,     0,     0,     0,     0,
    2399,   757,     0,  2169,  2170,     0,  2172,     0,     0,     0,
       0,     0,  1604,  2179,     0,     0,  1605,     0,     0,   758,
       0,     0,     0,     0,     0,     0,   994,  2193,     0,  2195,
       0,  2197,  2198,   759,  1606,  1607,  2203,     0,     0,     0,
       0,     0,     0,   582,     0,     0,  1608,     0,     0,  1613,
     760,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1674,     0,     0,
    1609,     0,  1683,  1610,     0,     0,     0,     0,   761,     0,
       0,     0,   762,   674,     0,     0,  1611,     0,  1612,     0,
       0,     0,  1752,     0,   763,     0,     0,     0,     0,     0,
     581,   934,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1388,  1614,     0,     0,     0,     0,     0,  2292,     0,
    1433,     0,  1615,  1616,  1617,     0,  1618,  1619,  1620,  1621,
    1622,  1623,     0,     0,  2525,   559,   674,     0,     0,     0,
       0,  1433,  1613,  1433,     0,     0,     0,     0,     0,     0,
       0,   920,  1458,  1459,  1842,     0,     0,  1433,     0,  1466,
       0,   764,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   559,
     765,     0,  1433,     0,     0,     0,     0,     0,     0,     0,
       0,  2174,     0,     0,     0,     0,     0,     0,     0,     0,
    1433,  1106,   766,     0,   767,  1614,  1879,     0,     0,   768,
       0,     0,     0,  2245,     0,  1615,  1616,  1617,     0,  1618,
    1619,  1620,  1621,  1622,  1623,   674,   674,   674,     0,  2026,
       0,   769,   770,     0,     0,  1433,     0,  1425,  1752,     0,
       0,     0,     0,     0,   771,  1424,  1433,     0,     0,   772,
       0,     0,     0,     0,  1433,     0,     0,   674,     0,   773,
       0,     0,     0,     0,     0,   582,   582,   774,   674,     0,
    1425,  1424,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2622,     0,     0,     0,     0,
       0,     0,     0,     0,  1955,     0,   582,     0,     0,     0,
     566,     0,   566,  2316,   566,     0,     0,  1424,  1433,     0,
     566,   566,     0,     0,     0,     0,   971,     0,     0,     0,
     582,     0,     0,     0,     0,     0,     0,     0,     0,  1433,
       0,     0,  1013,     0,  1424,  1599,     0,     0,     0,     0,
       0,     0,     0,  1679,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1602,  1433,     0,     0,  1424,
    1603,  1014,     0,  2032,     0,     0,     0,   582,   582,     0,
       0,   566,     0,  1015,     0,     0,     0,     0,  1433,  1016,
       0,  2504,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1424,     0,  1017,     0,  1424,     0,     0,     0,     0,
       0,     0,     0,  2704,     0,     0,  1427,  2704,  2718,     0,
    1018,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   566,  2404,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1019,  1427,
       0,     0,     0,     0,   566,   566,     0,     0,     0,     0,
       0,     0,     0,     0,  1020,     0,     0, -1717,     0,     0,
       0,  1605,     0,     0,     0,     0,     0,     0,  2292,  2292,
    2568,  2570,  2572,     0,     0,     0,  1021,     0,     0,  1606,
    1607,     0,     0,  1433,     0,     0,     0,     0,     0,     0,
       0, -1717,     0,   674,   674,  1599,     0,     0,     0,     0,
       0,     0,  2603,     0,     0,     0,     0,     0,  1600,     0,
       0,     0,     0,   749,     0,  1602,  1424,     0,  1610,     0,
    1603,  1022,     0,     0,  2245,  2245,  2245,  2245,  2245,     0,
    1425,  1611,     0,     0,     0,     0,     0,     0,     0,     0,
     765,     0,     0,  2156,     0,     0,   674,     0,     0,     0,
       0,     0,  1433,     0,     0,     0,  1425,     0,     0,     0,
       0,     0,  1023,  2269,  1024,  2191,     0,     0,  2191,  1025,
    2806,     0,     0,     0,     0,     0,     0,  2174,  1925,  1926,
       0,     0,  2292,     0,     0,     0,     0, -1717,     0,     0,
       0,  1026,  1425,     0,     0,     0,  2316,   566,     0,     0,
   -1716,     0,     0,     0,  1027,  1752,     0,     0,     0,  1028,
       0,  1106,     0,     0,     0,  1503,     0,  1604,  1507,  1425,
       0,  1605,  1961,     0,     0,  2238,   582,  1029,     0,     0,
       0,  1106,     0,     0,     0,     0,     0, -1716,     0,  1606,
    1607,     0,     0,     0,  1425,     0,     0,     0,  1433, -1716,
    1614,  1608,     0,     0, -1716,     0,     0,     0,     0, -1716,
   -1716,     0, -1716,     0,  1618,  1619,  1620,  1621,  1622,  1623,
       0,  2704,     0,     0,  2869,  1609,  1425,     0,  1610,     0,
    1425,     0,     0, -1716,     0,  2298,     0,     0,  2883,     0,
       0,  1611,     0,  1612,   566,     0,  1424,     0,     0,  1427,
   -1716,  2099,     0,     0,   994,   566,  2898,     0,   559,   674,
       0,     0,     0,     0,     0,   559,   674,   559,     0,     0,
       0,     0,  2911,     0,     0,  1427,     0,  2077,     0,     0,
       0,  1636,     0,     0, -1716,   582,   582,     0,  2752,  2753,
       0,     0, -1716,     0,     0,     0,     0,  1613,   566,     0,
       0,   566,     0,   566,     0,   566,     0,     0,  1424,     0,
       0,  1427,     0,  1424,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1424,     0,
       0,     0,     0,  2104,     0,     0,     0,  2955,  1427,     0,
       0,  2782,  1656,     0,     0,     0,     0,     0,     0,     0,
       0,  1425,     0,     0,     0,     0,   582,     0,   566,   824,
    1614,     0,     0,  1427,     0,     0,     0,     0,     0,   566,
    1615,  1616,  1617,  1433,  1618,  1619,  1620,  1621,  1622,  1623,
   -1716,     0,     0,     0,  2546,     0,     0,     0,  1424,     0,
    2704,     0,   674,     0,     0,  1427,     0,     0, -1716,  1427,
       0,     0,     0,     0,  2269,     0,  2990,     0,     0,     0,
       0,     0,     0,     0,     0,  1428,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1716,
       0,     0, -1716, -1716, -1716,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   345,  1428,     0,
     345,     0,     0,     0,     0,     0,     0,     0,  2174,  2191,
     566,     0,   583,   345,     0,     0,     0,     0,  2156,     0,
       0,     0,   971,     0,     0,     0,   971,   971,     0,     0,
       0,     0,     0,     0,     0,   345,     0,     0,     0,  2507,
       0,  2510,     0,     0,     0,     0,     0,     0,     0,     0,
     674,   583,     0,     0,  2900,  2514,  1433,     0,     0,     0,
    2990,  2906,     0,     0,     0,     0,     0,     0,     0,   583,
    1427,     0,     0,     0,     0,     0,     0,     0,   566,     0,
    2527,  1425,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   674,     0,     0,     0,     0,   674,  2156,     0,
       0,     0,     0,     0,  2270,     0,     0,  2955,   971,  2287,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1636,  1939,     0,     0,   674,     0,     0,     0,     0,
       0,     0,     0,  2592,     0,     0,     0,  2292,     0,   689,
     345,     0,     0,  1425,  2514,     0,     0,     0,  1425,     0,
       0,     0,  2156,     0,     0,   674,     0,   971,     0,     0,
       0,     0,     0,  1425,     0,     0,   566,     0,   566,     0,
       0,  1424,   566,  2292,     0,     0,     0,   566,   566,     0,
    1433,     0,  1599,     0,     0,   566,   690,     0,     0,  3144,
       0,     0,  1424,     0,  1424,   566,     0,   566,     0,     0,
     691,     0,  1602,     0,     0,     0,  2640,  1603,  1424,     0,
     994,     0,     0,   566,     0,   566,     0,   692,     0,     0,
       0,     0,     0,  1425,     0,     0,     0,  2648,     0,     0,
       0,  3144,     0,  1424,   345,     0,     0,     0,     0,  1433,
       0,     0,     0,     0,     0,   693,  1503,     0,     0,   694,
    1427,  1424,  2087,     0,  2669,     0,     0,  3144,  1428,     0,
       0,   695,  1939,     0,     0,     0,     0,     0,     0,     0,
       0,   345,  2427,     0,   345,     0,  2683,     0,     0,   566,
       0,     0,   696,     0,  1428,     0,  1424,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1424,     0,     0,
       0,     0,     0,     0,  1604,  1424,     0,     0,  1605,     0,
       0,     0,  1427,     0,     0,     0,     0,  1427,     0,     0,
    1428,     0,     0,     0,     0,     0,  1606,  1607,   697,     0,
       0,     0,  1427,     0,     0,     0,     0,  3077,  1608,     0,
       0,     0,  3079,     0,     0,     0,   566,  1428,     0,     0,
       0,     0,   566,     0,     0,     0,     0,     0,     0,  1424,
       0,   582,  1609,     0,     0,  1610,     0,     0,     0,     0,
       0,   698,  1428,     0,     0,     0,   699,     0,  1611,     0,
    1424,  2751,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1427,     0,     0,     0,     0,     0,   700,   701,
    3122,     0,     0,     0,  1428,     0,     0,  1424,  1428,     0,
       0,   702,     0,     0,     0,   566,   703,     0,   566,   566,
       0,     0,     0,     0,     0,     0,   704,     0,     0,  1424,
       0,     0,     0,     0,  1613,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   583,   566,
    2792,     0,     0,     0,     0,     0,  1425,     0,     0,     0,
       0,     0,     0,     0,  2588,   566,     0,     0,     0,   566,
    2594,     0,     0,   566,     0,     0,     0,  1425,     0,  1425,
       0,   566,     0,     0,     0,     0,   566,     0,     0,     0,
       0,     0,     0,  1425,     0,     0,     0,  1614,     0,   566,
       0,     0,     0,     0,     0,     0,     0,  1615,  1616,  1617,
       0,  1618,  1619,  1620,  1621,  1622,  1623,     0,  1425,     0,
       0,     0,     0,     0,     0,     0,     0,   566,     0,  1428,
       0,     0,     0,     0,  1424,     0,  1425,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2683,     0,     0,     0,
       0,     0,   582,  1503,     0,     0,  2308,     0,  1507,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1425,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1425,     0,     0,     0,     0,     0,     0,   566,
    1425,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1424,   345,     0,     0,     0,   345,     0,
       0,     0,   969,     0,     0,     0,   969,     0,     0,     0,
       0,     0,     0,     0,     0,  1427,     0,  2697,  2698,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   969,  1425,     0,  1427,     0,  1427,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1427,     0,     0,  1425,     0,     0,     0,     0,
    1599,     0,     0,     0,     0,  1063,     0,     0,   969,     0,
       0,     0,     0,  1600,   969,     0,     0,  1427,     0,     0,
    1602,     0,  1425,     0,     0,  1603,     0,     0,     0,  1424,
       0,     0,  1599,     0,     0,  1427,     0,     0,  1939,  1428,
       0,   566,     0,   566,  1425,  1600,     0,     0,     0,     0,
       0,  2975,  1602,     0,     0,     0,     0,  1603,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1427,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1427,     0,     0,     0,     0,     0,     0,  2780,  1427,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1214,  1428,   583,     0,     0,     0,  1428,     0,     0,     0,
    2789,     0,     0,     0,     0,     0,  2793,     0,     0,     0,
     345,  1428,  1604,     0,     0,     0,  1605,     0,     0,     0,
     566,     0,     0,     0,     0,     0,   566,   566,     0,     0,
       0,     0,     0,  1427,  1606,  1607,     0,     0,     0,  1425,
       0,     0,     0,     0,  1604,     0,  1608,     0,  1605,     0,
       0,     0,     0,     0,  1427,   566,   566,     0,     0,     0,
       0,     0,     0,     0,   566,     0,  1606,  1607,     0,     0,
    1609,  1428,   566,  1610,  2592,     0,     0,   566,  1608,   566,
       0,  1427,     0,     0,     0,     0,  1611,     0,  1612,   566,
     566,     0,     0,     0,  1424,     0,     0,     0,     0,     0,
       0,     0,  1609,  1427,     0,  1610,     0,     0,  1425,     0,
       0,     0,  2864,  2865,  2866,  2867,     0,     0,  1611,     0,
    1612,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   582,     0,     0,     0,     0,     0,
       0,     0,  1613,     0,     0,     0,     0,     0,     0,     0,
    1599,  1214,   345,     0,     0,     0,   969,     0,     0,     0,
       0,     0,   969,  1600,     0,     0,     0,     0,     0,     0,
    1602,     0,     0,     0,  1613,  1603,     0,     0,  1438,     0,
       0,     0,     0,     0,     0,     0,     0,   566,     0,     0,
       0,     0,     0,   566,     0,     0,     0,     0,  3139,     0,
       0,   969,     0,     0,  1425,  1614,     0,     0,  1427,     0,
       0,  1438,     0,     0,     0,  1615,  1616,  1617,     0,  1618,
    1619,  1620,  1621,  1622,  1623,     0,     0,  1424,     0,  2674,
       0,     0,     0,     0,     0,     0,     0,  1614,     0,   566,
       0,     0,     0,  1599,     0,     0,     0,  1615,  1616,  1617,
       0,  1618,  1619,  1620,  1621,  1622,  1623,     0,     0,     0,
       0,  2738,     0,  1602,     0,     0,  1214,     0,  1603,     0,
       0,     0,  1604,     0,     0,     0,  1605,  1427,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1214,     0,
       0,     0,     0,     0,  1606,  1607,     0,     0,     0,     0,
       0,     0,     0,     0,  1428,     0,  1608,     0,     0,     0,
       0,     0,  1214,  1214,     0,  1214,  1214,  1214,     0,     0,
       0,     0,     0,     0,     0,  1428,     0,  1428,     0,     0,
    1609,     0,     0,  1610,     0,  1214,  2413,     0,     0,     0,
       0,  1428,     0,     0,     0,     0,  1611,  3015,  1612,     0,
       0,  1424,     0,     0,     0,     0,     0,     0,     0,     0,
     583,   583,     0,     0,  1106, -1717,  1428,     0,     0,  1605,
     566,   566,     0,  1427,     0,     0,  1663,     0,     0,  1425,
       0,     0,     0,     0,  1428,   566,  3046,  1606,  1607,     0,
     566,   566,   566,   566,   566,     0,     0,     0,     0, -1717,
    1214,     0,  1613,  1214,  1214,     0,     0,     0,     0,     0,
    1424,   345,   345,   345,     0,     0,     0,     0,  3061,  1428,
       0,     0,     0,     0,     0,     0,  1610,     0,     0,     0,
    1428,   583,     0,     0,     0,     0,     0,     0,  1428,  1611,
       0,     0,   566,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2308,     0,     0,
       0,     0,   345,     0,     0,  1614,     0,     0,     0,   345,
       0,  1438,     0,     0,   345,  1615,  1616,  1617,     0,  1618,
    1619,  1620,  1621,  1622,  1623,  1430,  1599,     0,     0,  2847,
       0,     0,  1428,     0,     0, -1717,     0,  1438,     0,  1600,
       0,     0,     0,     0,     0,     0,  1602,     0,     0,     0,
       0,  1603,  1425,  1428,     0,     0,     0,     0,  1430,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1438,     0,     0,     0,     0,     0,     0,
    1428,     0,     0,     0,   345,     0,     0,     0,  1427,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1614,     0,
    1438,     0,  1428,  1939,   566,     0,     0,     0,     0,     0,
       0,     0,  1618,  1619,  1620,  1621,  1622,  1623,     0,     0,
       0,     0,     0,     0,     0,  1438,     0,   566,     0,     0,
       0,     0,   566,     0,   566,   566,     0,     0,     0,   566,
       0,     0,     0,     0,     0,     0,     0,     0,  1604,     0,
       0,     0,  1605,     0,     0,  1214,     0,  1438,     0,     0,
       0,  1438,     0,     0,     0,     0,     0,     0,     0,     0,
    1606,  1607,     0,     0,     0,     0,  1425,     0,     0,     0,
       0,     0,  1608,     0,     0,     0,     0,     0,   566,     0,
       0,     0,   969,     0,   566,     0,     0,     0,   566,     0,
       0,     0,     0,     0,     0,     0,  1609,  1428,     0,  1610,
       0,     0,     0,     0,     0,     0,     0,     0,  1214,  1214,
       0,  1427,  1611,     0,  1612,     0,  1214,     0,     0,  1214,
    1214,     0,     0,     0,     0,  1425,     0,     0,     0,   669,
       0,     0,  1992,     0,     0,     0,     0,  1599,     0,  1214,
       0,     0,     0,  1214,  1214,  1214,     0,  1214,     0,     0,
    1600,   669,     0,     0,  1214,  1214,     0,  1602,     0,     0,
       0,     0,  1603,     0,     0,     0,  1428,     0,  1613,     0,
       0,     0,  1438,  1214,   345,     0,  1214,  1214,     0,     0,
       0,  1214,     0,   566,     0,  1214,     0,     0,  1214,  1214,
    1214,  1214,  1214,  1214,  1214,  1214,  1214,     0,  1214,     0,
       0,     0,  1214,     0,     0,     0,  1214,     0,  1430,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1614,     0,     0,  1430,  1427,     0,     0,     0,     0,
       0,  1615,  1616,  1617,     0,  1618,  1619,  1620,  1621,  1622,
    1623,   345,  1599,     0,     0,  2863,   669,     0,     0,  1604,
       0,     0,  1428,  1605,     0,     0,     0,     0,     0,     0,
    1430,     0,  1602,     0,     0,     0,     0,  1603,     0,     0,
       0,  1606,  1607,     0,   345,     0,   345,     0,     0,     0,
       0,     0,     0,  1608,  1427,     0,     0,  1430,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   566,     0,
       0,     0,     0,     0,     0,     0,  1599,  1609,     0,     0,
    1610,     0,  1430,     0,     0,     0,     0,     0,     0,   345,
     566,     0,     0,  1611,   566,  1612,  1602,     0,     0,     0,
       0,  1603,     0,  1214,     0,  2687,     0,     0,     0,     0,
       0,  1599,  2162,     0,  1430,     0,     0,     0,  1430,     0,
       0,     0,     0,     0,  1600,     0,     0,     0,     0,     0,
       0,  1602,     0,     0, -1717,     0,  1603,     0,  1605,     0,
     566,   566,     0,     0,     0,   566,     0,     0,     0,  1613,
       0,     0,     0,     0,     0,     0,  1606,  1607,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1717,  2688,
       0,     0,     0,  1214,  1438,     0,     0,     0,     0,  1438,
       0,     0,     0,     0,     0,     0,     0,   566,     0,     0,
       0,     0,  1214,     0,  1438,  1610,     0,  1428, -1717,     0,
       0,     0,  1605,     0,     0,     0,     0,     0,  1611,     0,
       0,     0,  1614,   566,     0,     0,     0,     0,     0,     0,
    1606,  1607,  1615,  1616,  1617,     0,  1618,  1619,  1620,  1621,
    1622,  1623, -1717,  1604,     0,     0,  3017,  1605,     0,  1430,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1438,  1606,  1607,     0,     0,  1610,
       0,     0,     0,     0, -1717,     0,     0,  1608,     0,     0,
       0,     0,  1611,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1214,     0,     0,     0,     0,
       0,  1609,     0,     0,  1610,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1214,     0,  1611,     0,  1612,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1614, -1717,     0,
    1428,     0,     0,     0,  1214,  1214,  1214,     0,     0,  1214,
       0,  1618,  1619,  1620,  1621,  1622,  1623,     0,     0,     0,
       0,  1214,  1214,  1214,  1214,     0,     0,     0,     0,     0,
    1214,     0,     0,  1613,     0,     0,     0,     0,     0,     0,
       0,  1214,     0,     0,     0,     0,   711,     0,     0,     0,
       0,     0,  1214,  1214,     0,  1214,     0,     0,     0,  1214,
       0,  1614,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1618,  1619,  1620,  1621,  1622,
    1623,     0,   969,   711,  1214,  1214,     0,     0,     0,  1430,
       0,   711,     0,     0,     0,     0,  1614,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1615,  1616,  1617,  1214,
    1618,  1619,  1620,  1621,  1622,  1623,  1214,  1214,  1214,     0,
    3085,     0,     0,     0,  1428,     0,   711,   711,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1214,     0,     0,     0,     0,
     669,  1430,     0,     0,     0,     0,  1430,  1438,   966,     0,
       0,     0,   966,     0,     0,     0,     0,     0,     0,     0,
       0,  1430,     0,     0,     0,     0,     0,     0,  1438,     0,
    1438,     0,     0,  1428,     0,  1599,     0,     0,     0,   966,
       0,     0,     0,     0,  1438,     0,     0,     0,  1600,     0,
       0,     0,  2107,     0,     0,  1602,     0,     0,     0,     0,
    1603,     0,     0,     0,     0,     0,     0,     0,     0,  1438,
       0,     0,     0,     0,   966,     0,     0,     0,     0,     0,
     966,  1430,     0,     0,     0,     0,   345,  1438,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2108,     0,     0,
       0,     0,  1438,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1438,     0,     0,     0,     0,     0,     0,
       0,  1438,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1599,     0,     0,     0,  1604,     0,     0,
       0,  1605,     0,     0,   969,     0,  1209,     0,     0,     0,
       0,     0,     0,  1602,     0,     0,     0,     0,  1603,  1606,
    1607,     0,     0,     0,     0,     0,  1214,     0,     0,     0,
       0,  1608,  1214,     0,     0,  1438,     0,     0,     0,     0,
       0,     0,     0,     0,  1214,     0,  1214,     0,     0,     0,
    1214,     0,     0,     0,     0,  1609,  1438,  1214,  1610,     0,
    1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,  1214,
       0,  1611,     0,  1612,  1214,  1214,     0,     0,     0,     0,
       0,     0,     0,  1438,     0,     0,  2691,     0,  1214,     0,
       0,     0,     0,     0,     0,  1214,  1214,  1214,     0,  1214,
       0,     0,     0,     0,     0,  1438,  1214,     0,     0,  1599,
       0,  1214,     0,     0,  1214, -1717,     0,     0,     0,  1605,
       0,     0,  1600,   969,     0,     0,     0,  1613,     0,  1602,
       0,     0,     0,     0,  1603,     0,     0,  1606,  1607,     0,
       0,     0,     0,   565,     0,     0,     0,     0,     0, -1717,
       0,     0,     0,     0,  1430,     0,     0,     0,     0,     0,
    1431,     0,     0,     0,     0,     0,  1214,  1209,   669,     0,
    2109,     0,   966,     0,     0,  1430,  1610,  1430,   966,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1611,
    1614,  1430,     0,  1431,  1436,     0,     0,     0,     0,     0,
    1615,  1616,  1617,     0,  1618,  1619,  1620,  1621,  1622,  1623,
    1438,     0,     0,     0,     0,  2381,  1430,   966,     0,   801,
    2382,     0,     0,     0,     0,     0,     0,  1436,     0,     0,
       0,  1604,     0,     0,  1430,  1605,     0,   565,     0,   801,
       0,     0,     0,     0,     0, -1717,     0,     0,     0,     0,
       0,     0,     0,  1606,  1607,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1608,     0,     0,  1214,  1430,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1438,
    1430,     0,  1209,     0,     0,     0,     0,   962,  1430,  1609,
       0,   962,  1610,   711,     0,     0,     0,   711,   711,     0,
       0,     0,     0,     0,  1209,  1611,     0,  1612,  1614,     0,
       0,     0,     0,     0,     0,     0,     0,   711,   962,     0,
    1214,     0,  1618,  1619,  1620,  1621,  1622,  1623,  1209,  1209,
    1214,  1209,  1209,  1209,     0,     0,     0,     0,     0,     0,
       0,     0,  1430,     0,     0,     0,     0,     0,     0,     0,
       0,  1209,   711,   962,     0,     0,     0,     0,     0,   962,
       0,  1613,     0,  1430,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1438,     0,     0,     0,  1214,
    1214,  1214,     0,     0,  1214,     0,     0,     0,     0,     0,
    1430,     0,     0,     0,     0,     0,     0,     0,   969,     0,
       0,     0,   969,     0,     0,     0,   969,     0,     0,     0,
       0,     0,  1430,     0,     0,     0,  1209,   711,     0,  1209,
    1209,     0,     0,   711,  1614,     0,     0,     0,     0,     0,
       0,   711,     0,     0,  1615,  1616,  1617,     0,  1618,  1619,
    1620,  1621,  1622,  1623,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1431,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   711,     0,     0,     0,     0,   711,
       0,  1599,     0,     0,  1214,     0,     0,     0,     0,  1431,
     711,     0,     0,     0,     0,     0,     0,  1436,     0,     0,
     669,  1602,     0,     0,     0,     0,  1603,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   969,     0,
       0,     0,     0,  1436,     0,  1431,     0,  1430,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1214,     0,     0,     0,     0,     0,
       0,     0,  1431,  1214,     0,  1214,     0,     0,     0,  1436,
    1438,     0,     0,     0,  1214,     0,     0,     0,     0,     0,
     669,     0,     0,     0,  2861,   969,     0,  1431,     0,     0,
     969,     0,     0,     0,   969,     0,  1436,     0,  1214,  1214,
       0,     0,     0,     0,     0,     0,  1430,     0,  1214,     0,
       0,     0,     0, -1717,     0,     0,     0,  1605,     0,  1431,
       0,  1436,     0,  1431,     0,  1214,     0,     0,     0,     0,
     711,   962,     0,     0,     0,  1606,  1607,   962,     0,   969,
       0,     0,     0,     0,     0,     0,     0, -1717,     0,     0,
       0,  1209,     0,  1436,     0,     0,     0,  1436,     0,     0,
       0,     0,     0,     0,  1214,     0,     0,     0,     0,     0,
       0,   711,   711,     0,  1610,     0,   962,     0,   711,     0,
       0,     0,     0,     0,     0,  1214,     0,  1611,   966,     0,
       0,     0,     0,     0,  1214,     0,     0,     0,   969,     0,
       0,     0,  1430,  1438,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1209,  1209,  1599,     0,     0,     0,
     711,     0,  1209,     0,     0,  1209,  1209,     0,     0,  1600,
       0,     0,  1601,     0,     0,     0,  1602,     0,     0,     0,
       0,  1603,     0, -1717,  1431,  1209,     0,     0,   969,  1209,
    1209,  1209,     0,  1209,     0,     0,     0,     0,     0,     0,
    1209,  1209,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1214,     0,     0,     0,     0,     0,  1436,  1209,
     669,     0,  1209,  1209,     0,     0,     0,  1209,     0,     0,
       0,  1209,     0,     0,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,     0,  1209,     0,  1614,     0,  1209,     0,
       0,     0,  1209,     0,     0,     0,     0,     0,     0,     0,
    1618,  1619,  1620,  1621,  1622,  1623,     0,  1438,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1604,     0,
       0,     0,  1605,     0,     0,     0,     0,     0,     0,     0,
     969,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1606,  1607,   711,   801,     0,   801,     0,   801,     0,     0,
       0,     0,  1608,   801,   801,     0,     0,  1430,     0,     0,
       0,     0,     0,   969,     0,     0,  1438,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1609,     0,     0,  1610,
       0,     0,     0,     0,     0,     0,     0,  1599,     0,     0,
       0,     0,  1611,     0,  1612,     0,     0,     0,     0,     0,
    1600,     0,     0,  2342,  1431,     0,     0,  1602,     0,     0,
       0,     0,  1603,     0,   565,   669,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1209,
       0,     0,     0,     0,     0,     0,     0,  1599,  2160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1613,     0,
    1600,     0,     0,     0,     0,     0,     0,  1602,     0,     0,
       0,     0,  1603,     0,     0,     0,  1431,     0,   711,     0,
    1284,  1431,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1431,   565,   565,     0,
    1430,     0,     0,     0,     0,     0,     0,     0,     0,  1209,
    1436,     0,     0,     0,  1284,  1436,     0,     0,     0,  1604,
       0,  1614,     0,  1605,     0,     0,     0,     0,  1209,     0,
    1436,  1615,  1616,  1617,     0,  1618,  1619,  1620,  1621,  1622,
    1623,  1606,  1607,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1608,     0,     0,  1431,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1604,
       0,     0,     0,  1605,     0,     0,     0,  1609,     0,     0,
    1610,     0,     0,     0,     0,     0,     0,   711,   711,     0,
    1436,  1606,  1607,  1611,     0,  1612,     0,     0,     0,     0,
       0,     0,     0,  1608,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   962,     0,     0,
     711,  1209,     0,     0,  1430,     0,     0,  1609,     0,     0,
    1610,   711,     0,     0,     0,     0,     0,     0,     0,     0,
     711,  1209,     0,  1611,     0,  1612,     0,     0,     0,  1613,
     565,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1209,  1209,  1209,     0,     0,  1209,     0,     0,     0,     0,
       0,     0,     0,  1430,     0,     0,     0,  1209,  1209,  1209,
    1209,     0,     0,     0,     0,     0,  1209,     0,     0,  1613,
       0,     0,     0,     0,     0,     0,     0,  1209,     0,     0,
       0,     0,  1614,     0,     0,     0,     0,     0,  1209,  1209,
       0,  1209,  1615,  1616,  1617,  1209,  1618,  1619,  1620,  1621,
    1622,  1623,     0,     0,     0,     0,   711,     0,     0,     0,
       0,     0,  2344,     0,     0,     0,     0,   565,   966,     0,
    1209,  1209,     0,     0,     0,     0,     0,     0,   565,     0,
       0,     0,  1614,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1615,  1616,  1617,  1209,  1618,  1619,  1620,  1621,
    1622,  1623,  1209,  1209,  1209,  1432,     0,     0,     0,  1431,
       0,     0,   711,     0,     0,     0,     0,     0,     0,     0,
       0,   565,     0,     0,  1284,     0,  1284,     0,  1284,     0,
    1431,  1209,  1431,     0,     0,     0,     0,     0,  1432,     0,
       0,     0,     0,  1436,     0,     0,  1431,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1436,     0,  1436,     0,     0,     0,
       0,  1431,     0,     0,     0,     0,     0,     0,     0,     0,
    1436,   565,     0,     0,     0,     0,     0,     0,     0,  1431,
       0,     0,   801,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1436,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   669,  1436,  1431,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1431,     0,     0,     0,     0,
       0,     0,     0,  1431,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1436,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1436,
       0,     0,     0,     0,     0,     0,     0,  1436,     0,     0,
       0,     0,     0,  1284,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1431,     0,     0,
     966,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1431,     0,
       0,     0,  1209,     0,     0,     0,     0,     0,  1209,     0,
       0,  1436,     0,   711,     0,     0,     0,     0,   711,     0,
    1209,     0,  1209,     0,     0,  1431,  1209,     0,     0,     0,
       0,   565,  1436,  1209,     0,     0,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,     0,  1431,     0,     0,
    1209,  1209,     0,     0,     0,     0,     0,     0,     0,  1436,
       0,     0,     0,     0,  1209,     0,     0,     0,     0,     0,
       0,  1209,  1209,  1209,     0,  1209,     0,     0,  1432,     0,
       0,  1436,  1209,     0,     0,     0,     0,  1209,     0,     0,
    1209,     0,     0,     0,     0,     0,     0,     0,     0,   966,
       0,     0,     0,     0,  1432,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   801,
       0,   801,     0,     0,     0,   801,     0,     0,     0,   964,
     565,   801,     0,   964,     0,     0,  1599,     0,   801,     0,
    1432,     0,  1209,     0,     0,     0,     0,     0,   801,  1600,
     801,     0,  1431,     0,     0,     0,  1602,     0,     0,     0,
     964,  1603,     0,     0,     0,     0,   801,  1432,   801,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   711,     0,     0,     0,     0,  1436,  2438,     0,     0,
       0,     0,  1432,     0,     0,   964,     0,     0,     0,     0,
       0,   964,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1431,     0,     0,  1432,     0,     0,     0,  1432,     0,
       0,     0,   565,     0,     0,     0,     0,     0,     0,     0,
       0,  1599,     0,     0,  1209,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1600,  1436,     0,     0,  1604,     0,
       0,  1602,  1605,     0,     0,     0,  1603,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1606,  1607,     0,     0,     0,     0,     0,  1206,     0,     0,
       0,     0,  1608,     0,     0,     0,  1209,     0,     0,  1284,
       0,     0,     0,     0,     0,   565,  1209,     0,     0,     0,
       0,     0,     0,     0,     0,  1284,  1609,  1431,     0,  1610,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1611,     0,  1612,     0,     0,     0,     0,     0,
       0,     0,     0,  2357,     0,     0,     0,     0,     0,  1432,
       0,  1436,     0,     0,     0,  1209,  1209,  1209,     0,     0,
    1209,     0,     0,  1604,     0,     0,     0,  1605,  1284,     0,
       0,  1284,  1284,   711,   966,  1435,     0,     0,   966,   711,
       0,     0,   966,     0,     0,  1606,  1607,     0,  1613,     0,
       0,     0,     0,     0,     0,     0,     0,  1608,     0,     0,
       0,     0,   801,     0,     0,     0,     0,     0,  1435,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   565,   962,
       0,  1609,   565,     0,  1610,     0,   565,     0,     0,     0,
       0,     0,     0,     0,   801,     0,     0,  1611,     0,   801,
       0,     0,     0,     0,     0,     0,     0,     0,  1206,     0,
    1209,  1614,   801,   964,     0,     0,     0,     0,     0,   964,
       0,  1615,  1616,  1617,     0,  1618,  1619,  1620,  1621,  1622,
    1623,     0,     0,     0,     0,  1434,     0,     0,     0,     0,
     565,     0,     0,     0,   966,     0,     0,     0,     0,     0,
       0,     0,  1431,  1613,     0,     0,     0,     0,   964,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1434,     0,
    1209,     0,     0,     0,     0,     0,     0,     0,     0,  1209,
       0,  1209,     0,     0,     0,     0,  1436,     0,     0,  1432,
    1209,     0,     0,     0,     0,     0,   711,   711,  2438,     0,
       0,   966,   801,     0,     0,     0,   966,     0,     0,     0,
     966,     0,     0,     0,  1209,  1209,  1614,     0,     0,     0,
       0,     0,     0,  1206,  1209,     0,  1615,  1616,  1617,     0,
    1618,  1619,  1620,  1621,  1622,  1623,     0,     0,     0,     0,
       0,  1209,     0,     0,     0,  1206,     0,     0,     0,     0,
       0,  1432,     0,     0,     0,   966,  1432,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1206,
    1206,  1432,  1206,  1206,  1206,     0,     0,     0,     0,     0,
    1209,     0,     0,     0,     0,  1431,     0,     0,     0,     0,
       0,     0,  1206,     0,     0,     0,     0,     0,     0,     0,
       0,  1209,     0,     0,     0,     0,     0,     0,     0,     0,
    1209,     0,     0,     0,   966,     0,     0,     0,     0,  1436,
       0,     0,     0,     0,   801,     0,  1284,   711,  1435,     0,
       0,  1432,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   711,
       0,     0,     0,     0,  1435,   711,     0,  1206,     0,     0,
    1206,  1206,     0,     0,   966,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1209,     0,
    1435,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1431,
       0,     0,     0,  1284,     0,     0,     0,  1435,     0,  1284,
    1284,     0,     0,     0,     0,     0,     0,     0,  1434,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1435,  1436,     0,     0,     0,     0,   565,   565,
       0,     0,     0,     0,  1434,     0,     0,   565,     0,     0,
       0,   711,   711,   711,   711,  1284,   966,     0,  1431,     0,
     801,     0,   801,  2438,  1435,     0,     0,  2438,  1435,     0,
       0,  2438,  2564,   565,     0,     0,     0,     0,     0,     0,
    1434,     0,     0,     0,     0,     0,     0,     0,     0,   966,
       0,     0,  1436,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1434,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1434,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1432,     0,     0,     0,     0,     0,
       0,     0,  1206,     0,  1434,     0,     0,     0,  1434,     0,
     801,     0,     0,   962,     0,  1432,   801,  1432,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1435,
       0,  1432,     0,     0,     0,     0,     0,     0,     0,   964,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1432,     0,     0,     0,
       0,     0,   565,     0,     0,  1206,  1206,     0,     0,     0,
    2438,     0,     0,  1206,  1432,  2438,  1206,  1206,     0,  2438,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1206,     0,     0,     0,
    1206,  1206,  1206,     0,  1206,     0,     0,     0,     0,  1432,
       0,  1206,  1206,     0,     0,     0,     0,     0,     0,     0,
    1432,     0,     0,     0,   962,     0,   711,     0,  1432,  1434,
    1206,     0,     0,  1206,  1206,     0,     0,     0,  1206,     0,
       0,     0,  1206,   711,     0,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,     0,  1206,     0,     0,     0,  1206,
    1599,     0,     0,  1206,     0,   711,     0,     0,     0,     0,
       0,     0,     0,  1600,     0,     0,  2390,     0,     0,     0,
    1602,     0,  1432,  2438,     0,  1603,  1599,     0,     0,     0,
       0,     0,     0,   565,   565,     0,     0,   711,     0,  1600,
       0,     0,     0,  1432,     0,     0,  1602,     0,   801,  2158,
       0,  1603,     0,   801,   801,   801,   801,   801,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1432,     0,     0,   962,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1432,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   565,     0,     0,     0,     0,
       0,  1435,     0,     0,     0,     0,  1435,     0,     0,     0,
       0,     0,  1604,     0,     0,     0,  1605,     0,     0,     0,
       0,  1435,     0,     0,     0,     0,     0,  2395,     0,     0,
    1206,     0,     0,     0,  1606,  1607,     0,     0,  1604,  2157,
       0,     0,  1605,     0,     0,     0,  1608,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1606,  1607,     0,     0,     0,   962,     0,     0,     0,     0,
    1609,     0,  1608,  1610,     0,     0,     0,     0,     0,     0,
       0,  1435,     0,     0,     0,     0,  1611,  1432,  1612,     0,
       0,     0,     0,     0,     0,     0,  1609,     0,   962,  1610,
    1206,  1434,     0,     0,     0,     0,  1434,     0,     0,     0,
       0,     0,  1611,     0,  1612,     0,     0,   565,     0,  1206,
       0,  1434,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     801,     0,  1613,     0,     0,   565,     0,   565,   565,     0,
       0,     0,   565,     0,     0,     0,  1432,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1613,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1434,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   565,     0,     0,     0,  1614,     0,   565,     0,     0,
       0,   565,  1206,     0,     0,  1615,  1616,  1617,     0,  1618,
    1619,  1620,  1621,  1622,  1623,     0,     0,     0,     0,     0,
       0,  1614,  1206,     0,     0,     0,     0,     0,     0,     0,
       0,  1615,  1616,  1617,     0,  1618,  1619,  1620,  1621,  1622,
    1623,     0,  1432,     0,     0,     0,     0,     0,     0,     0,
       0,  1206,  1206,  1206,     0,     0,  1206,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1206,  1206,
    1206,  1206,     0,     0,     0,     0,     0,  1206,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1206,     0,
       0,     0,   720,     0,     0,     0,   565,     0,     0,  1206,
    1206,     0,  1206,   721,  2158,     0,  1206,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   722,     0,     0,     0,  1435,     0,  1435,     0,   964,
       0,  1206,  1206,     0,     0,     0,     0,   723,     0,  -428,
       0,  1435,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   724,     0,     0,  1206,     0,     0,   725,
       0,     0,     0,  1206,  1206,  1206,  1435,     0,     0,     0,
     726,     0,     0,     0,     0,     0,  1599,     0,     0,     0,
       0,     0,     0,     0,  2158,     0,     0,     0,     0,  1600,
       0,     0,  1206,     0,     0,     0,  1602,     0,     0,     0,
     727,  1603,   728,     0,  1434,   967,     0,     0,     0,   967,
       0,     0,     0,     0,  -537,     0,     0,  1432,     0,  1435,
       0,   565,     0,     0,     0,  1434,     0,  1434,     0,     0,
    1435,     0,     0,     0,     0,  -361,   967,     0,  2158,     0,
       0,  1434,     0,   565,     0,   729,     0,   565,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1434,     0,     0,     0,
       0,   967,     0,     0,     0,     0,     0,   967,     0,     0,
       0,   730,     0,   731,  1434,     0,     0,     0,     0,     0,
    1599,     0,  1435,   801,   801,     0,     0,     0,  1604,     0,
    -361,     0,  1605,  1600,     0,     0,     0,     0,     0,     0,
    1602,     0,     0,  1435,     0,  1603,     0,     0,     0,  1434,
    1606,  1607,     0,     0,   732,     0,     0,     0,     0,  -265,
    1434,     0,  1608,     0,     0,     0,     0,     0,  1434,     0,
    1435,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1432,  -265,   733,   734,     0,   735,  1609,     0,     0,  1610,
       0,   964,  1435,  1210,   736,     0,     0,     0,   737,   738,
       0,     0,  1611,   739,  1612,     0,     0,     0,     0,   740,
       0,     0,     0,  1206,     0,     0,     0,     0,     0,  1206,
       0,     0,  1434,     0,     0,     0,     0,     0,     0,     0,
       0,  1206,     0,  1206,     0,     0,     0,  1206,     0,     0,
       0,     0,  1604,  1434,  1206,     0,  1605,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,     0,  1613,     0,
       0,  1206,  1206,     0,  1606,  1607,     0,     0,     0,     0,
    1434,     0,     0,     0,     0,  1206,  1608,  2637,     0,     0,
       0,     0,  1206,  1206,  1206,     0,  1206,     0,     0,     0,
       0,     0,  1434,  1206,     0,     0,     0,  1435,  1206,  1188,
    1609,  1206,     0,  1610,  1432,     0,     0,     0,     0,     0,
     964,     0,     0,     0,     0,     0,  1611,     0,  1612,     0,
       0,  1614,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1615,  1616,  1617,     0,  1618,  1619,  1620,  1621,  1622,
    1623,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1206,  1210,     0,     0,     0,     0,   967,
       0,     0,     0,  1432,     0,   967,  1435,     0,     0,     0,
       0,     0,  1613,     0,     0,     0,     0,     0,     0,     0,
       0,  1437,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1434,     0,     0,
       0,     0,     0,     0,   967,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1437,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1614,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1615,  1616,  1617,     0,  1618,
    1619,  1620,  1621,  1622,  1623,  1206,     0,     0,     0,     0,
    1383,     0,  1435,     0,     0,     0,  1434,     0,     0,  1210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1210,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1206,     0,     0,
       0,     0,     0,     0,     0,  1210,  1210,  1206,  1210,  1210,
    1210,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1434,     0,     0,     0,  1206,  1206,  1206,     0,
       0,  1206,     0,     0,     0,  1541,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   964,     0,     0,     0,   964,
       0,     0,     0,   964,     0,     0,     0,  1565,     0,     0,
       0,     0,     0,  1210,     0,     0,  1210,  1210,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1586,  1587,     0,  1588,  1589,  1591,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1435,     0,     0,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1206,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1437,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   964,     0,     0,     0,     0,
    1437,     0,     0,     0,     0,     0,     0,     0,     0,  1693,
       0,     0,  1699,  1701,     0,     0,     0,     0,     0,     0,
       0,  1206,     0,     0,     0,     0,     0,     0,     0,     0,
    1206,     0,  1206,     0,     0,     0,  1437,  1434,     0,     0,
       0,  1206,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   964,     0,     0,     0,     0,   964,     0,     0,
       0,   964,     0,  1437,     0,  1206,  1206,     0,     0,     0,
    1435,     0,     0,     0,     0,  1206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1437,     0,
       0,     0,  1206,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   964,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1210,     0,
    1437,     0,     0,     0,  1437,     0,     0,     0,     0,     0,
       0,  1206,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1206,     0,     0,   967,     0,     0,     0,     0,
       0,  1206,     0,     0,     0,   964,     0,     0,     0,     0,
    1434,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1210,  1210,     0,     0,     0,     0,     0,     0,  1210,
       0,     0,  1210,  1210,  1435,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1210,     0,     0,   964,  1210,  1210,  1210,     0,
    1210,     0,     0,     0,  1919,     0,     0,  1210,  1210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1206,
       0,     0,     0,     0,     0,  1437,  1210,     0,     0,  1210,
    1210,     0,     0,  1435,  1210,     0,     0,     0,  1210,     0,
       0,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
       0,  1210,     0,     0,     0,  1210,     0,     0,     0,  1210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1434,  1975,     0,     0,     0,  1977,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   964,  1996,     0,
       0,     0,  1999,     0,     0,     0,  2010,     0,     0,     0,
       0,     0,     0,  2017,  2022,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     964,     0,  2033,  1434,     0,     0,  2037,     0,     0,     0,
    2048,     0,     0,     0,  2055,     0,     0,  2057,  2058,  2059,
    2060,  2061,  2062,  2063,  2064,  2065,     0,  2066,     0,     0,
       0,  1188,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1210,     0,     0,     0,
       0,     0,     0,     0,     0,  2161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1210,  1437,     0,     0,
       0,     0,  1437,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1210,     0,  1437,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1437,     0,     0,
       0,     0,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,  2214,     0,     0,     0,     0,     6,  1210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
       0,  2235,     0,     0,     0,     0,    10,    11,  1210,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,  1210,  1210,  1210,
       0,     0,  1210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1210,  1210,  1210,  1210,     0,     0,
       0,     0,     0,  1210,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,  1210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1210,  1210,     0,  1210,     0,
       0,     0,  1210,     0,  2318,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2338,   967,     0,  1210,  1210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,     0,  1210,     0,     0,     0,     0,     0,     0,  1210,
    1210,  1210,     0,     0,     0,     0,    38,     0,     0,     0,
    2022,     0,  2022,  2022,     0,     0,     0,     0,     0,  2398,
       0,     0,     0,    39,     0,     0,     0,     0,  1210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1437,     0,  2415,     0,  2417,     0,     0,     0,  2420,     0,
      40,     0,     0,    41,     0,     0,     0,     0,     0,     0,
       0,  1437,     0,  1437,     0,     0,     0,     0,     0,     0,
      42,     0,     0,     0,     0,     0,     0,  1437,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1693,     0,
       0,     0,  1437,     0,     0,  1701,  1701,  1699,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1437,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,  2494,     0,     0,     0,     0,     0,
       0,  1625,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1437,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,  1437,     0,     0,     0,
       0,     0,    45,     0,  1437,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,   967,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,     0,    53,
      54,     0,     0,     0,    55,    56,    57,    58,    59,  1210,
       0,    60,    61,   935,     0,  1210,     0,   936,  1437,     0,
       0,     0,     0,     0,     0,     0,     0,  1210,     0,  1210,
       0,     0,     0,  1210,     0,     0,     0,     0,     0,  1437,
    1210,     0,     0,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1210,  1210,     0,     0,     0,     0,  1210,  1210,     0,
       0,     0,     0,     0,     0,     0,  1437,     0,     0,     0,
       0,  1210,     0,     0,     0,     0,     0,     0,  1210,  1210,
    1210,     0,  1210,     0,     0,     0,     0,     0,  1437,  1210,
       0,     0,     0,     0,  1210,     0,     0,  1210,     0,     0,
       0,     0,     0,     0,     0,     0,   967,     0,     0,     0,
       0,     0,     0,     0,     0,  2634,     0,     0,     0,     0,
       0,  2638,     0,     0,     0,     0,  1625,     0,     0,     0,
       0,     0,     0,  2643,     0,  2644,     0,     0,     0,  2646,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2663,  2664,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2679,     0,  2681,     0,
       0,     0,     0,  1437,     0,  2685,     0,     0,     0,     0,
    2689,     0,     0,  2692,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1210,     0,     0,     0,  2731,     0,     0,     0,     0,
       0,     0,  1437,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1625,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1210,     0,     0,     0,     0,  1625,     0,
       0,     0,     0,  1210,  2006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1625,
    1625,  1625,  1625,     0,  1625,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2006,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1437,     0,
       0,     0,  1210,  1210,  1210,     0,     0,  1210,     0,     0,
    1625,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   967,     0,     0,     0,   967,     0,     0,     0,   967,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2318,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2843,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,     0,
       0,     0,  1625,     0,  1625,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1210,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2859,
    2860,     0,     0,  2862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   967,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1210,     0,     0,
       0,     0,     0,     0,     0,     0,  1210,     0,  1210,     0,
       0,     0,     0,  1437,     0,     0,     0,  1210,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   967,     0,
       0,     0,     0,   967,     0,     0,     0,   967,     0,     0,
       0,  1210,  1210,  2930,     0,     0,     0,     0,     0,     0,
       0,  1210,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   967,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2318,     0,     0,     0,  1210,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2976,     0,     0,     0,     0,  1210,     0,
       0,     0,     0,     0,     0,     0,     0,  1210,     0,     0,
       0,   967,  1625,     0,     0,     0,  1437,     0,  2992,     0,
       0,     0,     0,     0,     0,     0,     0,  2996,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3001,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1625,
       0,   967,     0,     0,     0,     0,     0,     0,  1625,     0,
    1625,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3033,     0,  1210,     0,     0,     0,  1625,
       0,     0,  1625,     0,  2006,  2006,  2006,  2377,     0,  2006,
       0,     0,     0,  1625,     0,     0,     0,     0,     0,     0,
    1625,     0,     0,  3052,     0,  1625,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,  2377,
    1625,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1437,  1625,  2006,     0,     0,     0,     0,     0,  1625,     0,
    1625,  1625,  1625,  1625,  1625,  1625,  1625,  1625,  1625,  1625,
       0,     0,     0,   967,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       0,  2996,     0,     0,     0,     0,   967,     0,     0,  1437,
       7,     8,     0,     0,     0,     0,     9,     0,    10,    11,
       0,     0,     0,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
       0,     0,  1625,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1625,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1625,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    40,     0,     0,    41,     0,     0,     0,     0,
       0,  1625,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    42,     0,     0,     0,     0,     0,     0,     0,
       0,  1625,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2377,  2377,  2377,     0,  2006,     0,     0,
    2006,  2006,  2006,  2006,  2006,  2006,  2006,  2006,  2006,  2006,
       0,  2377,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1625,     0,     0,     0,     0,  2006,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2377,  1625,     0,
    1625,    44,     0,  1625,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,    49,     0,    50,     0,    51,     0,     0,     0,    52,
       0,    53,    54,     0,     0,     0,    55,    56,    57,    58,
      59,     0,     0,    60,    61,    62,    63,     0,    64,    65,
      66,    67,     0,     4,     0,     0,     0,  1625,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
       0,     0,     0,     0,     0,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2006,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1625,     0,     0,
       0,  1625,     0,     0,     0,     0,  1625,  1625,     0,  1625,
       0,     0,  2377,     0,     0,     0,  2377,  2377,  2377,  2377,
    2377,  2377,  2377,  2377,  2377,  2377,  1625,  1625,     0,     0,
      37,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2377,  1625,     0,  1625,     0,    38,     0,  1625,  2006,
       0,     0,  1625,     0,     0,  1625,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      40,     0,     0,    41,  1625,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2377,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,     0,
       0,     0,    45,  2006,     0,  2006,     0,     0,     0,     0,
       0,  2377,  1625,  1625,    46,  1625,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,     0,    53,
      54,     0,     0,     0,    55,    56,    57,    58,    59,     0,
       0,    60,    61,   935,  1304,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1625,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2377,  2006,  2377,     0,     0,  1625,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1625,     0,     0,     0,  1625,
       0,     0,     0,     0,  1625,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,   584,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,  2377,   357,     0,    91,  1625,    93,    94,    95,    96,
      97,    98,   585,    99,   100,   101,   358,   586,     0,   103,
     104,   105,   106,   587,   588,     0,   108,   109,   110,     0,
     111,   589,   590,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,   591,   375,
     376,   592,   593,   594,   595,   596,   597,   598,   377,   378,
     379,   129,   380,   381,   382,   131,   132,   133,   134,     0,
     599,   383,   384,     0,   385,   600,   601,   386,   602,   135,
     388,   603,   389,   390,   391,   392,   139,   604,   605,   393,
     394,   395,   606,   396,   397,   142,   398,   607,   399,   400,
     145,   401,   608,   609,   610,   611,   402,   403,   404,   405,
     406,   148,   149,   407,   612,   408,   613,   409,     0,   410,
     411,   412,   614,   615,   616,   413,   414,   415,   416,   617,
     417,   418,   618,   419,   619,   420,   421,   422,   155,   423,
       0,   157,   620,   424,   425,   159,   621,   426,   622,   427,
     160,   623,   161,   428,     0,   429,   624,   625,   430,   626,
     431,   432,   164,   433,   434,   435,   627,   436,   437,   438,
     439,   628,   165,   166,   629,   440,   441,   442,   630,   168,
     631,   169,   632,     0,   170,   171,   443,   172,   444,   445,
     446,   447,   448,   633,   173,   449,   174,   634,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   179,   180,   181,   635,   463,   464,   465,   466,   182,
     636,   467,   468,   184,   469,   637,   185,   186,   470,   471,
     638,   639,   472,   640,   641,   642,   473,   474,   643,   644,
     187,   188,   189,   190,   475,   476,   477,     0,   191,   192,
     478,   479,   645,   480,   481,   482,   483,   484,   485,   194,
     486,   646,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   199,   498,   201,   499,   500,   501,   502,
     503,   504,     0,   647,   505,   506,   507,   648,   508,   205,
     509,   510,   207,   511,   208,   649,   512,   513,   514,   515,
     516,   517,   518,   519,   210,   520,   650,   521,   522,   523,
     524,   651,   211,   212,   652,   526,   653,   527,   213,   528,
     214,   654,   529,   530,   531,   532,   533,   655,   656,   534,
     535,   536,   537,   538,   657,   658,   539,   540,   541,   221,
     542,   222,   543,     0,   659,   660,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,     0,     0,    79,
      80,    81,     0,     0,    83,    84,     0,    85,    86,    87,
       0,     0,     0,    90,    91,     0,    93,    94,    95,    96,
      97,    98,   661,    99,   100,   101,     0,     0,     0,   103,
     104,   105,   106,     0,   107,     0,   108,   109,   110,     0,
     111,   112,   113,   114,     0,     0,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,     0,     0,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   148,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,   166,     0,     0,     0,     0,     0,   168,
       0,   169,     0,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     0,   173,     0,   174,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,     0,   184,     0,     0,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,   190,     0,     0,     0,     0,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,   207,     0,   208,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,     0,     0,     0,
       0,     0,   211,   212,     0,     0,     0,     0,   213,     0,
     214,     0,     0,     0,     0,     0,     0,   217,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   221,
       0,   222,     0,     0,     0,     0,     0,     0,     0,    79,
      80,    81,     0,   223,    83,    84,   224,    85,    86,    87,
       0,     0,     0,    90,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,     0,     0,     0,   103,
     104,   105,   106,  2119,   107,     0,   108,   109,   110,     0,
     111,   112,   113,   114,     0,     0,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,     0,     0,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   148,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,   166,     0,     0,     0,     0,     0,   168,
       0,   169,     0,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     0,   173,     0,   174,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,     0,   184,     0,     0,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,   190,     0,     0,     0,     0,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,   207,     0,   208,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,     0,     0,     0,
       0,     0,   211,   212,     0,     0,     0,     0,   213,     0,
     214,     0,     0,     0,     0,     0,     0,   217,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   221,
       0,   222,     0,     0,     0,     0,    78,     0,     0,    79,
      80,    81,    82,   223,    83,    84,   224,    85,    86,    87,
      88,     0,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   102,     0,     0,   103,
     104,   105,   106,  2121,   107,     0,   108,   109,   110,     0,
     111,   112,   113,   114,   115,   116,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,   123,
       0,   124,     0,     0,     0,     0,     0,     0,     0,     0,
     125,   126,   127,     0,     0,     0,     0,     0,     0,     0,
     128,   129,     0,     0,   130,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,   136,     0,   137,   138,   139,     0,     0,   140,
     141,     0,     0,     0,     0,   142,   143,   144,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,   146,     0,
     147,   148,   149,   150,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,   153,     0,     0,     0,     0,   154,   155,   156,
       0,   157,     0,   158,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,   162,     0,   163,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,   166,     0,     0,   167,     0,     0,   168,
       0,   169,     0,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     0,   173,     0,   174,     0,   175,   176,
       0,     0,   177,     0,     0,     0,     0,     0,     0,   178,
       0,   179,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,   183,   184,     0,     0,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,   190,     0,     0,     0,     0,   191,   192,
       0,   193,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,   195,     0,   196,     0,     0,     0,   197,     0,
       0,     0,   198,   199,   200,   201,     0,     0,   202,     0,
       0,     0,     0,   203,     0,     0,     0,     0,   204,   205,
       0,   206,   207,     0,   208,    78,     0,   209,     0,     0,
       0,    82,     0,     0,   210,     0,     0,     0,     0,    88,
       0,    89,   211,   212,    92,     0,     0,     0,   213,     0,
     214,     0,   215,     0,   216,   102,     0,   217,     0,     0,
     218,     0,   219,     0,     0,     0,   220,     0,     0,   221,
       0,   222,     0,   115,   116,     0,     0,     0,     0,     0,
       0,     0,     0,   223,     0,     0,   224,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,     0,     0,     0,     0,     0,     0,   225,   125,
     126,   127,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   878,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   136,     0,   137,   138,     0,     0,     0,   140,   141,
       0,     0,     0,     0,     0,   143,   144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   146,     0,   147,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,   153,     0,     0,     0,     0,   154,     0,   156,     0,
       0,     0,   158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   162,     0,   163,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   175,   176,     0,
       0,   177,     0,     0,     0,     0,     0,     0,   178,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     193,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,     0,
       0,   198,     0,   200,     0,     0,     0,   202,     0,     0,
       0,     0,   203,     0,     0,     0,     0,   204,     0,     0,
     206,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   215,     0,   216,     0,     0,     0,     0,     0,   218,
       0,   219,     0,     0,     0,   220,   584,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     585,    99,   100,   101,   358,   586,     0,   103,   104,   105,
     106,   587,   588,     0,   108,   109,   110,   225,   111,   589,
     590,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,  2081,   375,   376,     0,
       0,     0,     0,  1119,     0,     0,   377,   378,   379,   129,
     380,   381,   382,   131,  1120,   133,  1121,  1122,     0,   383,
     384,     0,   385,  1123,  1124,   386,  1125,  1126,   388,     0,
     389,   390,   391,   392,  1127,     0,     0,   393,   394,   395,
       0,   396,   397,  1128,   398,     0,   399,   400,   145,   401,
    1129,  1130,  1131,  1132,   402,   403,   404,   405,   406,  1133,
    1134,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,  2082,     0,   413,  1135,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,  1136,   423,     0,  1137,
    1138,   424,   425,  1139,     0,   426,     0,   427,   160,     0,
     161,   428,     0,   429,     0,     0,   430,     0,   431,   432,
     164,   433,   434,   435,     0,   436,   437,   438,   439,     0,
     165,   166,     0,   440,   441,   442,  1140,  1141,     0,  1142,
       0,     0,   170,   171,   443,   172,   444,   445,   446,   447,
     448,     0,   173,   449,   174,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,  1143,
     180,  1144,   709,   463,   464,   465,   466,   182,  1145,   467,
     468,   184,   469,  1146,  1147,  1148,   470,   471,     0,     0,
     472,   710,     0,     0,  1149,   474,     0,     0,   187,   188,
     189,  1150,   475,   476,   477,     0,  1151,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,  1152,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,   199,   498,  1153,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,  1154,   508,   205,   509,   510,
     207,   511,  1155,     0,   512,   513,   514,   515,   516,   517,
     518,   519,  1156,   520,     0,   521,   522,   523,   524,     0,
    1157,  1158,     0,   526,     0,   527,  1159,   528,  1160,  1161,
     529,   530,   531,   532,   533,     0,  1162,   534,   535,   536,
     537,   538,  1163,     0,   539,   540,   541,  1164,   542,   222,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,    49,  1165,   224,   550,     0,     0,  1166,  1167,
      52,  1168,    53,     0,     0,     0,     0,  1169,  1170,  2083,
       0,  1172,  1173,     0,     0,     0,  1174,  2084,   584,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   585,    99,   100,   101,   358,   586,     0,   103,
     104,   105,   106,   587,   588,     0,   108,   109,   110,     0,
     111,   589,   590,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,  1119,     0,     0,   377,   378,
     379,   129,   380,   381,   382,   131,  1120,   133,  1121,  1122,
       0,   383,   384,     0,   385,  1123,  1124,   386,  1125,  1126,
     388,     0,   389,   390,   391,   392,  1127,     0,     0,   393,
     394,   395,     0,   396,   397,  1128,   398,     0,   399,   400,
     145,   401,  1129,  1130,  1131,  1132,   402,   403,   404,   405,
     406,  1133,  1134,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,  1135,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,  1136,   423,
       0,  1137,  1138,   424,   425,  1139,     0,   426,     0,   427,
     160,     0,   161,   428,     0,   429,     0,     0,   430,     0,
     431,   432,   164,   433,   434,   435,     0,   436,   437,   438,
     439,     0,   165,   166,     0,   440,   441,   442,  1140,  1141,
       0,  1142,     0,     0,   170,   171,   443,   172,   444,   445,
     446,   447,   448,     0,   173,   449,   174,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,  1143,   180,  1144,   709,   463,   464,   465,   466,   182,
    1145,   467,   468,   184,   469,  1146,  1147,  1148,   470,   471,
       0,     0,   472,   710,     0,     0,  1149,   474,     0,     0,
     187,   188,   189,  1150,   475,   476,   477,     0,  1151,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,  1152,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   199,   498,  1153,   499,   500,   501,   502,
     503,   504,     0,     0,   505,   506,   507,  1154,   508,   205,
     509,   510,   207,   511,  1155,     0,   512,   513,   514,   515,
     516,   517,   518,   519,  1156,   520,     0,   521,   522,   523,
     524,     0,  1157,  1158,     0,   526,     0,   527,  1159,   528,
    1160,  1161,   529,   530,   531,   532,   533,     0,  1162,   534,
     535,   536,   537,   538,  1163,     0,   539,   540,   541,  1164,
     542,   222,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,    49,  1165,   224,   550,     0,     0,
    1166,  1167,    52,  1168,    53,     0,     0,     0,     0,  1169,
    1170,     0,     0,  1172,  1173,     0,     0,     0,  1174,  2008,
      79,    80,    81,   355,     0,    83,    84,     0,    85,    86,
      87,   356,     0,   357,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   358,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   359,   360,     0,     0,     0,
     361,   362,     0,     0,     0,     0,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,     0,   365,     0,   366,
     367,     0,   368,   369,   370,   371,   372,   373,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
     378,   379,     0,   380,   381,   382,     0,   132,     0,   134,
       0,     0,   383,   384,     0,   385,     0,     0,   386,   387,
     135,   388,     0,   389,   390,   391,   392,   139,     0,     0,
     393,   394,   395,     0,   396,   397,   142,   398,     0,   399,
     400,     0,   401,     0,     0,     0,     0,   402,   403,   404,
     405,   406,   148,   149,   407,     0,   408,     0,   409,     0,
     410,   411,   412,     0,     0,     0,   413,   414,   415,   416,
       0,   417,   418,     0,   419,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   424,   425,   159,     0,   426,     0,
     427,     0,     0,     0,   428,     0,   429,     0,     0,   430,
       0,   431,   432,     0,   433,   434,   435,     0,   436,   437,
     438,   439,     0,     0,   166,     0,   440,   441,   442,     0,
     168,     0,   169,     0,     0,     0,     0,   443,     0,   444,
     445,   446,   447,   448,     0,     0,   449,     0,     0,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   179,     0,   181,     0,   463,   464,   465,   466,
     182,     0,   467,   468,     0,   469,     0,   185,   186,   470,
     471,     0,     0,   472,     0,     0,     0,   473,   474,     0,
       0,   187,     0,     0,   190,   475,   476,   477,     0,   191,
     192,   478,   479,     0,   480,   481,   482,   483,   484,   485,
     194,   486,     0,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,     0,   498,   201,   499,   500,   501,
     502,   503,   504,     0,     0,   505,   506,   507,     0,   508,
     205,   509,   510,     0,   511,   208,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   210,   520,     0,   521,   522,
     523,   524,     0,   211,   212,     0,   526,     0,   527,   213,
     528,   214,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,     0,  3036,   539,   540,   541,
     221,   542,     0,   543,     4,     0,     0,   544,   545,   546,
     547,   548,   549,     0,   223,     0,     0,   224,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     0,
       0,     0,     0,     0,     0,     0,     0, -1185,     0,     7,
       8, -1185,     0,     0,     0,     0,     0,    10,    11,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    39,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    40,     0,     0,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,    48,
      49,     0,    50,     0,     0,     0,     0,     0,    52,     0,
      53,    54,     0,     0,     0,    55,    56,    57,    58,    59,
       0,     0,    60,    61,   935,  1740,   584,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     585,    99,   100,   101,   358,   586,     0,   103,   104,   105,
     106,   587,   588,     0,   108,   109,   110,     0,   111,   589,
     590,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,     0,   375,   376,     0,
       0,     0,     0,  1119,     0,     0,   377,   378,   379,   129,
     380,   381,   382,   131,  1120,   133,  1121,  1122,  2018,   383,
     384,     0,   385,  1123,  1124,   386,  1125,  1126,   388,     0,
     389,   390,   391,   392,  1127,     0,     0,   393,   394,   395,
       0,   396,   397,  1128,   398,     0,   399,   400,   145,   401,
    1129,  1130,  1131,  1132,   402,   403,   404,   405,   406,  1133,
    1134,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,  1135,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,  1136,   423,     0,  1137,
    1138,   424,   425,  1139,     0,   426,     0,   427,   160,  2019,
     161,   428,     0,   429,     0,     0,   430,     0,   431,   432,
     164,   433,   434,   435,     0,   436,   437,   438,   439,     0,
     165,   166,     0,   440,   441,   442,  1140,  1141,     0,  1142,
       0,     0,   170,   171,   443,   172,   444,   445,   446,   447,
     448,  2020,   173,   449,   174,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,  1143,
     180,  1144,   709,   463,   464,   465,   466,   182,  1145,   467,
     468,   184,   469,  1146,  1147,  1148,   470,   471,     0,     0,
     472,   710,     0,     0,  1149,   474,     0,     0,   187,   188,
     189,  1150,   475,   476,   477,     0,  1151,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,  1152,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,   199,   498,  1153,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,  1154,   508,   205,   509,   510,
     207,   511,  1155,     0,   512,   513,   514,   515,   516,   517,
     518,   519,  1156,   520,     0,   521,   522,   523,   524,     0,
    1157,  1158,     0,   526,  2021,   527,  1159,   528,  1160,  1161,
     529,   530,   531,   532,   533,     0,  1162,   534,   535,   536,
     537,   538,  1163,     0,   539,   540,   541,  1164,   542,   222,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,    49,  1165,   224,   550,     0,     0,  1166,  1167,
      52,  1168,    53,     0,     0,     0,     0,  1169,  1170,     0,
       0,  1172,  1173,     0,     0,     0,  1174,   584,    79,    80,
      81,   355,     0,    83,    84,     0,    85,    86,    87,   356,
       0,   357,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   585,    99,   100,   101,   358,   586,     0,   103,   104,
     105,   106,   587,   588,     0,   108,   109,   110,     0,   111,
     589,   590,   114,   359,   360,     0,     0,     0,   361,   362,
       0,     0,     0,     0,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,     0,   365,     0,   366,   367,     0,
     368,   369,   370,   371,   372,   373,   374,     0,   375,   376,
       0,     0,     0,     0,  1119,     0,     0,   377,   378,   379,
     129,   380,   381,   382,   131,  1120,   133,  1121,  1122,     0,
     383,   384,     0,   385,  1123,  1124,   386,  1125,  1126,   388,
       0,   389,   390,   391,   392,  1127,     0,     0,   393,   394,
     395,     0,   396,   397,  1128,   398,     0,   399,   400,   145,
     401,  1129,  1130,  1131,  1132,   402,   403,   404,   405,   406,
    1133,  1134,   407,     0,   408,     0,   409,     0,   410,   411,
     412,     0,     0,     0,   413,  1135,   415,   416,     0,   417,
     418,     0,   419,     0,   420,   421,   422,  1136,   423,     0,
    1137,  1138,   424,   425,  1139,     0,   426,     0,   427,   160,
       0,   161,   428,     0,   429,     0,     0,   430,     0,   431,
     432,   164,   433,   434,   435,     0,   436,   437,   438,   439,
       0,   165,   166,     0,   440,   441,   442,  1140,  1141,     0,
    1142,     0,     0,   170,   171,   443,   172,   444,   445,   446,
     447,   448,     0,   173,   449,   174,     0,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
    1143,   180,  1144,   709,   463,   464,   465,   466,   182,  1145,
     467,   468,   184,   469,  1146,  1147,  1148,   470,   471,     0,
       0,   472,   710,     0,     0,  1149,   474,     0,     0,   187,
     188,   189,  1150,   475,   476,   477,     0,  1151,   192,   478,
     479,     0,   480,   481,   482,   483,   484,   485,  1152,   486,
       0,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   497,   199,   498,  1153,   499,   500,   501,   502,   503,
     504,     0,     0,   505,   506,   507,  1154,   508,   205,   509,
     510,   207,   511,  1155,     0,   512,   513,   514,   515,   516,
     517,   518,   519,  1156,   520,     0,   521,   522,   523,   524,
       0,  1157,  1158,     0,   526,     0,   527,  1159,   528,  1160,
    1161,   529,   530,   531,   532,   533,     0,  1162,   534,   535,
     536,   537,   538,  1163,     0,   539,   540,   541,  1164,   542,
     222,   543,     0,     0,     0,   544,   545,   546,   547,   548,
     549,     0,   223,    49,  1165,   224,   550,     0,     0,  1166,
    1167,    52,  1168,    53,     0,     0,     0,     0,  1169,  1170,
    1171,     0,  1172,  1173,     0,     0,     0,  1174,   584,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   585,    99,   100,   101,   358,   586,     0,   103,
     104,   105,   106,   587,   588,     0,   108,   109,   110,     0,
     111,   589,   590,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,  1119,     0,     0,   377,   378,
     379,   129,   380,   381,   382,   131,  1120,   133,  1121,  1122,
       0,   383,   384,     0,   385,  1123,  1124,   386,  1125,  1126,
     388,     0,   389,   390,   391,   392,  1127,     0,     0,   393,
     394,   395,     0,   396,   397,  1128,   398,     0,   399,   400,
     145,   401,  1129,  1130,  1131,  1132,   402,   403,   404,   405,
     406,  1133,  1134,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,  1135,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,  1136,   423,
       0,  1137,  1138,   424,   425,  1139,     0,   426,     0,   427,
     160,     0,   161,   428,     0,   429,     0,     0,   430,     0,
     431,   432,   164,   433,   434,   435,     0,   436,   437,   438,
     439,     0,   165,   166,     0,   440,   441,   442,  1140,  1141,
       0,  1142,     0,     0,   170,   171,   443,   172,   444,   445,
     446,   447,   448,     0,   173,   449,   174,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,  1143,   180,  1144,   709,   463,   464,   465,   466,   182,
    1145,   467,   468,   184,   469,  1146,  1147,  1148,   470,   471,
       0,     0,   472,   710,     0,     0,  1149,   474,     0,     0,
     187,   188,   189,  1150,   475,   476,   477,     0,  1151,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,  1152,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   199,   498,  1153,   499,   500,   501,   502,
     503,   504,     0,   203,   505,   506,   507,  1154,   508,   205,
     509,   510,   207,   511,  1155,     0,   512,   513,   514,   515,
     516,   517,   518,   519,  1156,   520,     0,   521,   522,   523,
     524,     0,  1157,  1158,     0,   526,     0,   527,  1159,   528,
    1160,  1161,   529,   530,   531,   532,   533,     0,  1162,   534,
     535,   536,   537,   538,  1163,     0,   539,   540,   541,  1164,
     542,   222,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,    49,  1165,   224,   550,     0,     0,
    1166,  1167,    52,  1168,    53,     0,     0,     0,     0,  1169,
    1170,     0,     0,  1172,  1173,     0,     0,     0,  1174,   584,
      79,    80,    81,   355,     0,    83,    84,     0,    85,    86,
      87,   356,     0,   357,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   585,    99,   100,   101,   358,   586,     0,
     103,   104,   105,   106,   587,   588,     0,   108,   109,   110,
       0,   111,   589,   590,   114,   359,   360,     0,     0,     0,
     361,   362,     0,     0,     0,     0,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,     0,   365,     0,   366,
     367,     0,   368,   369,   370,   371,   372,   373,   374,  1697,
     375,   376,     0,     0,     0,     0,  1119,     0,     0,   377,
     378,   379,   129,   380,   381,   382,   131,  1120,   133,  1121,
    1122,     0,   383,   384,     0,   385,  1123,  1124,   386,  1125,
    1126,   388,     0,   389,   390,   391,   392,  1127,     0,     0,
     393,   394,   395,     0,   396,   397,  1128,   398,     0,   399,
     400,   145,   401,  1129,  1130,  1131,  1132,   402,   403,   404,
     405,   406,  1133,  1134,   407,     0,   408,     0,   409,     0,
     410,   411,   412,     0,     0,     0,   413,  1135,   415,   416,
       0,   417,   418,     0,   419,     0,   420,   421,   422,  1136,
     423,     0,  1137,  1138,   424,   425,  1139,     0,   426,     0,
     427,   160,     0,   161,   428,     0,   429,     0,     0,   430,
       0,   431,   432,   164,   433,   434,   435,     0,   436,   437,
     438,   439,     0,   165,   166,     0,   440,   441,   442,  1140,
    1141,     0,  1142,     0,     0,   170,   171,   443,   172,   444,
     445,   446,   447,   448,     0,   173,   449,   174,     0,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,  1143,   180,  1144,   709,   463,   464,   465,   466,
     182,  1145,   467,   468,   184,   469,  1146,  1147,  1148,   470,
     471,     0,     0,   472,   710,     0,     0,  1149,   474,     0,
       0,   187,   188,   189,  1150,   475,   476,   477,     0,  1151,
     192,   478,   479,     0,   480,   481,   482,   483,   484,   485,
    1152,   486,     0,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,   199,   498,  1153,   499,   500,   501,
     502,   503,   504,     0,     0,   505,   506,   507,  1154,   508,
     205,   509,   510,   207,   511,  1155,     0,   512,   513,   514,
     515,   516,   517,   518,   519,  1156,   520,     0,   521,   522,
     523,   524,     0,  1157,  1158,     0,   526,     0,   527,  1159,
     528,  1160,  1161,   529,   530,   531,   532,   533,     0,  1162,
     534,   535,   536,   537,   538,  1163,     0,   539,   540,   541,
    1164,   542,   222,   543,     0,     0,     0,   544,   545,   546,
     547,   548,   549,     0,   223,    49,  1165,   224,   550,     0,
       0,  1166,  1167,    52,  1168,    53,     0,     0,     0,     0,
    1169,  1170,     0,     0,  1172,  1173,     0,     0,     0,  1174,
     584,    79,    80,    81,   355,     0,    83,    84,     0,    85,
      86,    87,   356,     0,   357,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   585,    99,   100,   101,   358,   586,
       0,   103,   104,   105,   106,   587,   588,     0,   108,   109,
     110,     0,   111,   589,   590,   114,   359,   360,     0,     0,
       0,   361,   362,     0,     0,     0,     0,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,     0,   365,     0,
     366,   367,     0,   368,   369,   370,   371,   372,   373,   374,
       0,   375,   376,     0,     0,     0,     0,  1119,     0,     0,
     377,   378,   379,   129,   380,   381,   382,   131,  1120,   133,
    1121,  1122,     0,   383,   384,     0,   385,  1123,  1124,   386,
    1125,  1126,   388,     0,   389,   390,   391,   392,  1127,     0,
       0,   393,   394,   395,     0,   396,   397,  1128,   398,     0,
     399,   400,   145,   401,  1129,  1130,  1131,  1132,   402,   403,
     404,   405,   406,  1133,  1134,   407,     0,   408,     0,   409,
       0,   410,   411,   412,     0,     0,     0,   413,  1135,   415,
     416,     0,   417,   418,     0,   419,     0,   420,   421,   422,
    1136,   423,     0,  1137,  1138,   424,   425,  1139,     0,   426,
       0,   427,   160,     0,   161,   428,     0,   429,     0,     0,
     430,     0,   431,   432,   164,   433,   434,   435,     0,   436,
     437,   438,   439,     0,   165,   166,     0,   440,   441,   442,
    1140,  1141,     0,  1142,     0,     0,   170,   171,   443,   172,
     444,   445,   446,   447,   448,     0,   173,   449,   174,     0,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,  1143,   180,  1144,   709,   463,   464,   465,
     466,   182,  1145,   467,   468,   184,   469,  1146,  1147,  1148,
     470,   471,     0,     0,   472,   710,     0,     0,  1149,   474,
       0,     0,   187,   188,   189,  1150,   475,   476,   477,     0,
    1151,   192,   478,   479,     0,   480,   481,   482,   483,   484,
     485,  1152,   486,     0,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,   199,   498,  1153,   499,   500,
     501,   502,   503,   504,     0,     0,   505,   506,   507,  1154,
     508,   205,   509,   510,   207,   511,  1155,     0,   512,   513,
     514,   515,   516,   517,   518,   519,  1156,   520,     0,   521,
     522,   523,   524,     0,  1157,  1158,     0,   526,     0,   527,
    1159,   528,  1160,  1161,   529,   530,   531,   532,   533,     0,
    1162,   534,   535,   536,   537,   538,  1163,     0,   539,   540,
     541,  1164,   542,   222,   543,     0,     0,     0,   544,   545,
     546,   547,   548,   549,     0,   223,    49,  1165,   224,   550,
       0,     0,  1166,  1167,    52,  1168,    53,     0,     0,     0,
       0,  1169,  1170,     0,     0,  1172,  1173,     0,  1536,     0,
    1174,   584,    79,    80,    81,   355,     0,    83,    84,     0,
      85,    86,    87,   356,     0,   357,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   585,    99,   100,   101,   358,
     586,     0,   103,   104,   105,   106,   587,   588,     0,   108,
     109,   110,     0,   111,   589,   590,   114,   359,   360,     0,
       0,     0,   361,   362,     0,     0,     0,     0,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,     0,   365,
       0,   366,   367,     0,   368,   369,   370,   371,   372,   373,
     374,     0,   375,   376,     0,     0,     0,     0,  1119,     0,
       0,   377,   378,   379,   129,   380,   381,   382,   131,  1120,
     133,  1121,  1122,     0,   383,   384,     0,   385,  1123,  1124,
     386,  1125,  1126,   388,     0,   389,   390,   391,   392,  1127,
       0,     0,   393,   394,   395,     0,   396,   397,  1128,   398,
       0,   399,   400,   145,   401,  1129,  1130,  1131,  1132,   402,
     403,   404,   405,   406,  1133,  1134,   407,  2317,   408,     0,
     409,     0,   410,   411,   412,     0,     0,     0,   413,  1135,
     415,   416,     0,   417,   418,     0,   419,     0,   420,   421,
     422,  1136,   423,     0,  1137,  1138,   424,   425,  1139,     0,
     426,     0,   427,   160,     0,   161,   428,     0,   429,     0,
       0,   430,     0,   431,   432,   164,   433,   434,   435,     0,
     436,   437,   438,   439,     0,   165,   166,     0,   440,   441,
     442,  1140,  1141,     0,  1142,     0,     0,   170,   171,   443,
     172,   444,   445,   446,   447,   448,     0,   173,   449,   174,
       0,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,  1143,   180,  1144,   709,   463,   464,
     465,   466,   182,  1145,   467,   468,   184,   469,  1146,  1147,
    1148,   470,   471,     0,     0,   472,   710,     0,     0,  1149,
     474,     0,     0,   187,   188,   189,  1150,   475,   476,   477,
       0,  1151,   192,   478,   479,     0,   480,   481,   482,   483,
     484,   485,  1152,   486,     0,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   497,   199,   498,  1153,   499,
     500,   501,   502,   503,   504,     0,     0,   505,   506,   507,
    1154,   508,   205,   509,   510,   207,   511,  1155,     0,   512,
     513,   514,   515,   516,   517,   518,   519,  1156,   520,     0,
     521,   522,   523,   524,     0,  1157,  1158,     0,   526,     0,
     527,  1159,   528,  1160,  1161,   529,   530,   531,   532,   533,
       0,  1162,   534,   535,   536,   537,   538,  1163,     0,   539,
     540,   541,  1164,   542,   222,   543,     0,     0,     0,   544,
     545,   546,   547,   548,   549,     0,   223,    49,  1165,   224,
     550,     0,     0,  1166,  1167,    52,  1168,    53,     0,     0,
       0,     0,  1169,  1170,     0,     0,  1172,  1173,     0,     0,
       0,  1174,   584,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   585,    99,   100,   101,
     358,   586,     0,   103,   104,   105,   106,   587,   588,     0,
     108,   109,   110,     0,   111,   589,   590,   114,   359,   360,
       0,     0,     0,   361,   362,     0,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
     365,     0,   366,   367,     0,   368,   369,   370,   371,   372,
     373,   374,     0,   375,   376,     0,     0,     0,     0,  1119,
       0,     0,   377,   378,   379,   129,   380,   381,   382,   131,
    1120,   133,  1121,  1122,     0,   383,   384,     0,   385,  1123,
    1124,   386,  1125,  1126,   388,     0,   389,   390,   391,   392,
    1127,     0,     0,   393,   394,   395,     0,   396,   397,  1128,
     398,     0,   399,   400,   145,   401,  1129,  1130,  1131,  1132,
     402,   403,   404,   405,   406,  1133,  1134,   407,     0,   408,
       0,   409,     0,   410,   411,   412,     0,     0,     0,   413,
    1135,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,  1136,   423,     0,  1137,  1138,   424,   425,  1139,
       0,   426,     0,   427,   160,  2019,   161,   428,     0,   429,
       0,     0,   430,     0,   431,   432,   164,   433,   434,   435,
       0,   436,   437,   438,   439,     0,   165,   166,     0,   440,
     441,   442,  1140,  1141,     0,  1142,     0,     0,   170,   171,
     443,   172,   444,   445,   446,   447,   448,     0,   173,   449,
     174,     0,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,  1143,   180,  1144,   709,   463,
     464,   465,   466,   182,  1145,   467,   468,   184,   469,  1146,
    1147,  1148,   470,   471,     0,     0,   472,   710,     0,     0,
    1149,   474,     0,     0,   187,   188,   189,  1150,   475,   476,
     477,     0,  1151,   192,   478,   479,     0,   480,   481,   482,
     483,   484,   485,  1152,   486,     0,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,   199,   498,  1153,
     499,   500,   501,   502,   503,   504,     0,     0,   505,   506,
     507,  1154,   508,   205,   509,   510,   207,   511,  1155,     0,
     512,   513,   514,   515,   516,   517,   518,   519,  1156,   520,
       0,   521,   522,   523,   524,     0,  1157,  1158,     0,   526,
       0,   527,  1159,   528,  1160,  1161,   529,   530,   531,   532,
     533,     0,  1162,   534,   535,   536,   537,   538,  1163,     0,
     539,   540,   541,  1164,   542,   222,   543,     0,     0,     0,
     544,   545,   546,   547,   548,   549,     0,   223,    49,  1165,
     224,   550,     0,     0,  1166,  1167,    52,  1168,    53,     0,
       0,     0,     0,  1169,  1170,     0,     0,  1172,  1173,     0,
       0,     0,  1174,   584,    79,    80,    81,   355,     0,    83,
      84,     0,    85,    86,    87,   356,     0,   357,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   585,    99,   100,
     101,   358,   586,     0,   103,   104,   105,   106,   587,   588,
       0,   108,   109,   110,     0,   111,   589,   590,   114,   359,
     360,     0,     0,     0,   361,   362,     0,     0,     0,     0,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,   365,     0,   366,   367,     0,   368,   369,   370,   371,
     372,   373,   374,     0,   375,   376,     0,     0,     0,     0,
    1119,     0,     0,   377,   378,   379,   129,   380,   381,   382,
     131,  1120,   133,  1121,  1122,     0,   383,   384,     0,   385,
    1123,  1124,   386,  1125,  1126,   388,     0,   389,   390,   391,
     392,  1127,     0,     0,   393,   394,   395,     0,   396,   397,
    1128,   398,     0,   399,   400,   145,   401,  1129,  1130,  1131,
    1132,   402,   403,   404,   405,   406,  1133,  1134,   407,  2730,
     408,     0,   409,     0,   410,   411,   412,     0,     0,     0,
     413,  1135,   415,   416,     0,   417,   418,     0,   419,     0,
     420,   421,   422,  1136,   423,     0,  1137,  1138,   424,   425,
    1139,     0,   426,     0,   427,   160,     0,   161,   428,     0,
     429,     0,     0,   430,     0,   431,   432,   164,   433,   434,
     435,     0,   436,   437,   438,   439,     0,   165,   166,     0,
     440,   441,   442,  1140,  1141,     0,  1142,     0,     0,   170,
     171,   443,   172,   444,   445,   446,   447,   448,     0,   173,
     449,   174,     0,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,  1143,   180,  1144,   709,
     463,   464,   465,   466,   182,  1145,   467,   468,   184,   469,
    1146,  1147,  1148,   470,   471,     0,     0,   472,   710,     0,
       0,  1149,   474,     0,     0,   187,   188,   189,  1150,   475,
     476,   477,     0,  1151,   192,   478,   479,     0,   480,   481,
     482,   483,   484,   485,  1152,   486,     0,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   497,   199,   498,
    1153,   499,   500,   501,   502,   503,   504,     0,     0,   505,
     506,   507,  1154,   508,   205,   509,   510,   207,   511,  1155,
       0,   512,   513,   514,   515,   516,   517,   518,   519,  1156,
     520,     0,   521,   522,   523,   524,     0,  1157,  1158,     0,
     526,     0,   527,  1159,   528,  1160,  1161,   529,   530,   531,
     532,   533,     0,  1162,   534,   535,   536,   537,   538,  1163,
       0,   539,   540,   541,  1164,   542,   222,   543,     0,     0,
       0,   544,   545,   546,   547,   548,   549,     0,   223,    49,
    1165,   224,   550,     0,     0,  1166,  1167,    52,  1168,    53,
       0,     0,     0,     0,  1169,  1170,     0,     0,  1172,  1173,
       0,     0,     0,  1174,   584,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   585,    99,
     100,   101,   358,   586,     0,   103,   104,   105,   106,   587,
     588,     0,   108,   109,   110,     0,   111,   589,   590,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,  1119,     0,     0,   377,   378,   379,   129,   380,   381,
     382,   131,  1120,   133,  1121,  1122,     0,   383,   384,     0,
     385,  1123,  1124,   386,  1125,  1126,   388,     0,   389,   390,
     391,   392,  1127,     0,     0,   393,   394,   395,     0,   396,
     397,  1128,   398,     0,   399,   400,   145,   401,  1129,  1130,
    1131,  1132,   402,   403,   404,   405,   406,  1133,  1134,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,  1135,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,  1136,   423,     0,  1137,  1138,   424,
     425,  1139,     0,   426,     0,   427,   160,     0,   161,   428,
       0,   429,     0,     0,   430,     0,   431,   432,   164,   433,
     434,   435,     0,   436,   437,   438,   439,     0,   165,   166,
       0,   440,   441,   442,  1140,  1141,     0,  1142,     0,     0,
     170,   171,   443,   172,   444,   445,   446,   447,   448,     0,
     173,   449,   174,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,  1143,   180,  1144,
     709,   463,   464,   465,   466,   182,  1145,   467,   468,   184,
     469,  1146,  1147,  1148,   470,   471,     0,     0,   472,   710,
       0,     0,  1149,   474,     0,     0,   187,   188,   189,  1150,
     475,   476,   477,     0,  1151,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,  1152,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,   199,
     498,  1153,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,  1154,   508,   205,   509,   510,   207,   511,
    1155,     0,   512,   513,   514,   515,   516,   517,   518,   519,
    1156,   520,     0,   521,   522,   523,   524,     0,  1157,  1158,
       0,   526,     0,   527,  1159,   528,  1160,  1161,   529,   530,
     531,   532,   533,     0,  1162,   534,   535,   536,   537,   538,
    1163,     0,   539,   540,   541,  1164,   542,   222,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
      49,  1165,   224,   550,     0,     0,  1166,  1167,    52,  1168,
      53,     0,     0,     0,     0,  1169,  1170,     0,     0,  1172,
    1173,     0,     0,     0,  1174,   584,    79,    80,    81,   355,
       0,    83,    84,     0,    85,    86,    87,   356,     0,   357,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   585,
      99,   100,   101,   358,   586,     0,   103,   104,   105,   106,
     587,   588,     0,   108,   109,   110,     0,   111,   589,   590,
     114,   359,   360,     0,     0,     0,   361,   362,     0,     0,
       0,     0,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,     0,   365,     0,   366,   367,     0,   368,   369,
     370,   371,   372,   373,   374,     0,   375,   376,     0,     0,
       0,     0,  1119,     0,     0,   377,   378,   379,   129,   380,
     381,   382,   131,  1120,   133,  1121,  1122,     0,   383,   384,
       0,   385,  1123,  1124,   386,  1125,  1126,   388,     0,   389,
     390,   391,   392,  1127,     0,     0,   393,   394,   395,     0,
     396,   397,  1128,   398,     0,   399,   400,   145,   401,  1129,
    1130,  1131,  1132,   402,   403,   404,   405,   406,  1133,  1134,
     407,     0,   408,     0,   409,     0,   410,   411,   412,     0,
       0,     0,   413,  1135,   415,   416,     0,   417,   418,     0,
     419,     0,   420,   421,   422,  1136,   423,     0,  1137,  1138,
     424,   425,  1139,     0,   426,     0,   427,   160,     0,   161,
     428,     0,   429,     0,     0,   430,     0,   431,   432,   164,
     433,   434,   435,     0,   436,   437,   438,   439,     0,   165,
     166,     0,   440,   441,   442,  1140,  1141,     0,  1142,     0,
       0,   170,   171,   443,   172,   444,   445,   446,   447,   448,
       0,   173,   449,   174,     0,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,  1143,   180,
    1144,   709,   463,   464,   465,   466,   182,     0,   467,   468,
     184,   469,  1146,  1147,  1148,   470,   471,     0,     0,   472,
     710,     0,     0,  1149,   474,     0,     0,   187,   188,   189,
    1150,   475,   476,   477,     0,  1151,   192,   478,   479,     0,
     480,   481,   482,   483,   484,   485,  1152,   486,     0,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
     199,   498,  1153,   499,   500,   501,   502,   503,   504,     0,
       0,   505,   506,   507,  1154,   508,   205,   509,   510,   207,
     511,  1155,     0,   512,   513,   514,   515,   516,   517,   518,
     519,  1156,   520,     0,   521,   522,   523,   524,     0,  1157,
    1158,     0,   526,     0,   527,  1159,   528,  1160,  1161,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,  1163,     0,   539,   540,   541,  1164,   542,   222,   543,
       0,     0,     0,   544,   545,   546,   547,   548,   549,     0,
     223,    49,  1165,   224,   550,     0,     0,  1166,  1167,    52,
    1168,    53,     0,     0,     0,     0,     0,  2001,     0,     0,
    2002,  2003,     0,     0,     0,  1174,   584,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     585,    99,   100,   101,   358,   586,     0,   103,   104,   105,
     106,   587,   588,     0,   108,   109,   110,     0,   111,   589,
     590,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,     0,   375,   376,     0,
       0,     0,     0,  1119,     0,     0,   377,   378,   379,   129,
     380,   381,   382,     0,  1120,   133,  1121,  1122,     0,   383,
     384,     0,   385,  1123,  1124,   386,  1125,  1126,   388,     0,
     389,   390,   391,   392,  1127,     0,     0,   393,   394,   395,
       0,   396,   397,  1128,   398,     0,   399,   400,   145,   401,
    1129,  1130,  1131,  1132,   402,   403,   404,   405,   406,  1133,
    1134,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,  1135,   415,   416,     0,   417,   418,
       0,     0,     0,   420,   421,   422,  1136,   423,     0,  1137,
    1138,   424,   425,  1139,     0,   426,     0,   427,   160,     0,
     161,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
     165,   166,     0,   440,   441,   442,  1140,  1141,     0,  1142,
       0,     0,   170,   171,   443,   172,   444,   445,   446,   447,
     448,     0,   173,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,  1143,
     180,  1144,   709,   463,   464,   465,   466,   182,     0,   467,
     468,   184,   469,  1146,  1147,  1148,   470,   471,     0,     0,
     472,   710,     0,     0,  1149,   474,     0,     0,   187,   188,
     189,  1150,   475,   476,   477,     0,  1151,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,  1152,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,   199,   498,  1153,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,  1154,   508,   205,   509,   510,
       0,   511,  1155,     0,   512,   513,   514,   515,   516,   517,
     518,   519,  1156,   520,     0,   521,   522,   523,   524,     0,
    1157,  1158,     0,   526,     0,   527,  1159,   528,  1160,  1161,
     529,   530,   531,   532,   533,     0,  1162,   534,   535,   536,
     537,   538,  1163,     0,   539,   540,   541,  1164,   542,   222,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,    49,  1165,   224,   550,     0,     0,  1166,  1167,
      52,  1168,    53,     0,     0,     0,     0,  1169,  1170,     0,
       0,  1172,  1173,     0,     0,     0,  1174,   584,    79,    80,
      81,   355,     0,    83,    84,     0,    85,    86,    87,   356,
       0,   357,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   585,    99,   100,   101,   358,   586,     0,   103,   104,
     105,   106,   587,   588,     0,   108,   109,   110,     0,   111,
     589,   590,   114,   359,   360,     0,     0,     0,   361,   362,
       0,     0,     0,     0,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,     0,   365,     0,   366,   367,     0,
     368,   369,   370,   371,   372,   373,   374,     0,   375,   376,
       0,     0,     0,     0,  1119,     0,     0,   377,   378,   379,
     129,   380,   381,   382,   131,  1120,   133,  1121,  1122,     0,
     383,   384,     0,   385,  1123,  1124,   386,  1125,  1126,   388,
       0,   389,   390,   391,   392,  1127,     0,     0,   393,   394,
     395,     0,   396,   397,  1128,   398,     0,   399,   400,   145,
     401,  1129,  1130,  1131,  1132,   402,   403,   404,   405,   406,
    1133,  1134,   407,     0,   408,     0,   409,     0,   410,   411,
     412,     0,     0,     0,   413,  1135,   415,   416,     0,   417,
     418,     0,   419,     0,   420,   421,   422,  1136,   423,     0,
    1137,  1138,   424,   425,  1139,     0,   426,     0,   427,   160,
       0,   161,   428,     0,   429,     0,     0,   430,     0,   431,
     432,   164,   433,   434,   435,     0,   436,   437,   438,   439,
       0,   165,   166,     0,   440,   441,   442,  1140,  1141,     0,
    1142,     0,     0,   170,   171,   443,   172,   444,   445,   446,
     447,   448,     0,   173,   449,   174,     0,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
    1143,   180,  1144,   709,   463,   464,   465,   466,   182,     0,
     467,   468,   184,   469,  1146,  1147,  1148,   470,   471,     0,
       0,   472,   710,     0,     0,   473,   474,     0,     0,   187,
     188,   189,  1150,   475,   476,   477,     0,  1151,   192,   478,
     479,     0,   480,   481,   482,   483,   484,   485,  1152,   486,
       0,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   497,   199,   498,  1153,   499,   500,   501,   502,   503,
     504,     0,     0,   505,   506,   507,  1154,   508,   205,   509,
     510,   207,   511,  1155,     0,   512,   513,   514,   515,   516,
     517,   518,   519,  1156,   520,     0,   521,   522,   523,   524,
       0,  1157,  1158,     0,   526,     0,   527,  1159,   528,  1160,
    1161,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,  1163,     0,   539,   540,   541,  1164,   542,
     222,   543,     0,     0,     0,   544,   545,   546,   547,   548,
     549,     0,   223,    49,     0,   224,   550,     0,     0,  1166,
    1167,    52,  1168,    53,   584,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,  1174,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   585,    99,
     100,   101,   358,   586,     0,   103,   104,   105,   106,   587,
     588,     0,   108,   109,   110,     0,   111,   589,   590,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,  1119,     0,     0,   377,   378,   379,   129,   380,   381,
     382,     0,  1120,   133,  1121,  1122,     0,   383,   384,     0,
     385,  1123,  1124,   386,  1125,  1126,   388,     0,   389,   390,
     391,   392,  1127,     0,     0,   393,   394,   395,     0,   396,
     397,  1128,   398,     0,   399,   400,   145,   401,  1129,  1130,
    1131,  1132,   402,   403,   404,   405,   406,  1133,  1134,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,  1135,   415,   416,     0,   417,   418,     0,     0,
       0,   420,   421,   422,  1136,   423,     0,  1137,  1138,   424,
     425,  1139,     0,   426,     0,   427,   160,     0,   161,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,   165,   166,
       0,   440,   441,   442,  1140,  1141,     0,  1142,     0,     0,
     170,   171,   443,   172,   444,   445,   446,   447,   448,     0,
     173,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,  1143,   180,  1144,
     709,   463,   464,   465,   466,   182,     0,   467,   468,   184,
     469,  1146,  1147,  1148,   470,   471,     0,     0,   472,   710,
       0,     0,     0,   474,     0,     0,   187,   188,   189,  1150,
     475,   476,   477,     0,  1151,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,  1152,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,   199,
     498,  1153,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,  1154,   508,   205,   509,   510,     0,   511,
    1155,     0,   512,   513,   514,   515,   516,   517,   518,   519,
    1156,   520,     0,   521,   522,   523,   524,     0,  1157,  1158,
       0,   526,     0,   527,  1159,   528,  1160,  1161,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
    1163,     0,   539,   540,   541,  1164,   542,   222,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
      49,     0,   224,   550,     0,     0,  1166,  1167,    52,  1168,
      53,     0,     0,     0,     0,     0,  2001,     0,     0,  2002,
    2003,     0,     0,     0,  1174,   584,    79,    80,    81,   355,
       0,    83,    84,     0,    85,    86,    87,   356,     0,   357,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   585,
      99,   100,   101,   358,   586,     0,   103,   104,   105,   106,
     587,   588,     0,   108,   109,   110,     0,   111,   589,   590,
     114,   359,   360,     0,     0,     0,   361,   362,     0,     0,
       0,     0,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,     0,   365,     0,   366,   367,     0,   368,   369,
     370,   371,   372,   373,   374, -1094,   375,   376,     0,     0,
       0, -1094,  1119,     0,     0,   377,   378,   379,   129,   380,
     381,   382,     0,  1120,   133,  1121,  1122,     0,   383,   384,
       0,   385,  1123,  1124,   386,  1125,  1126,   388,     0,   389,
     390,   391,   392,  1127,     0,     0,   393,   394,   395,     0,
     396,   397,  1128,   398,     0,   399,   400,   145,   401,  1129,
    1130,  1131,  1132,   402,   403,   404,   405,   406,  1133,  1134,
     407,     0,   408,     0,   409,     0,   410,   411,   412,     0,
       0,     0,   413,  1135,   415,   416,     0,   417,   418,     0,
       0,     0,   420,   421,   422,  1136,   423,     0,  1137,  1138,
     424,   425,  1139,     0,   426,     0,   427,   160,     0,   161,
     428,     0,   429,     0,     0,   430,     0,   431,   432,     0,
     433,   434,   435,     0,   436,   437,   438,   439,     0,   165,
     166,     0,   440,   441,   442,  1140,  1141,     0,  1142,     0,
       0,     0,     0,   443,   172,   444,   445,   446,   447,   448,
       0,   173,   449,     0,     0,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,  1143,   180,
    1144,   709,   463,   464,   465,   466,   182,     0,   467,   468,
       0,   469,  1146,  1147,  1148,   470,   471,     0,     0,   472,
     710,     0,     0,     0,   474,     0,     0,   187,   188,   189,
    1150,   475,   476,   477,     0,  1151,   192,   478,   479,     0,
     480,   481,   482,   483,   484,   485,  1152,   486,     0,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
     199,   498,  1153,   499,   500,   501,   502,   503,   504,     0,
       0,   505,   506,   507,  1154,   508,   205,   509,   510,     0,
     511,  1155, -1094,   512,   513,   514,   515,   516,   517,   518,
     519,  1156,   520,     0,   521,   522,   523,   524,     0,  1157,
    1158,     0,   526,     0,   527,  1159,   528,  1160,  1161,   529,
     530,   531,   532,   533,     0,  1162,   534,   535,   536,   537,
     538,  1163,     0,   539,   540,   541,  1164,   542,   222,   543,
       0,     0,     0,   544,   545,   546,   547,   548,   549,     0,
     223,    49,     0,   224,   550,     0,     0,  1166,  1167,    52,
    1168,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1173,     0,     0,     0,  1174,   584,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     585,    99,   100,   101,   358,   586,     0,   103,   104,   105,
     106,   587,   588,     0,   108,   109,   110,     0,   111,   589,
     590,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374, -1095,   375,   376,     0,
       0,     0, -1095,  1119,     0,     0,   377,   378,   379,   129,
     380,   381,   382,     0,  1120,   133,  1121,  1122,     0,   383,
     384,     0,   385,  1123,  1124,   386,  1125,  1126,   388,     0,
     389,   390,   391,   392,  1127,     0,     0,   393,   394,   395,
       0,   396,   397,  1128,   398,     0,   399,   400,   145,   401,
    1129,  1130,  1131,  1132,   402,   403,   404,   405,   406,  1133,
    1134,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,  1135,   415,   416,     0,   417,   418,
       0,     0,     0,   420,   421,   422,  1136,   423,     0,  1137,
    1138,   424,   425,  1139,     0,   426,     0,   427,   160,     0,
     161,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
     165,   166,     0,   440,   441,   442,  1140,  1141,     0,  1142,
       0,     0,     0,     0,   443,   172,   444,   445,   446,   447,
     448,     0,   173,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,  1143,
     180,  1144,   709,   463,   464,   465,   466,   182,     0,   467,
     468,     0,   469,  1146,  1147,  1148,   470,   471,     0,     0,
     472,   710,     0,     0,     0,   474,     0,     0,   187,   188,
     189,  1150,   475,   476,   477,     0,  1151,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,  1152,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,   199,   498,  1153,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,  1154,   508,   205,   509,   510,
       0,   511,  1155, -1095,   512,   513,   514,   515,   516,   517,
     518,   519,  1156,   520,     0,   521,   522,   523,   524,     0,
    1157,  1158,     0,   526,     0,   527,  1159,   528,  1160,  1161,
     529,   530,   531,   532,   533,     0,  1162,   534,   535,   536,
     537,   538,  1163,     0,   539,   540,   541,  1164,   542,   222,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,    49,     0,   224,   550,     0,     0,  1166,  1167,
      52,  1168,    53,   584,    79,    80,    81,   355,     0,    83,
      84,     0,    85,    86,    87,   356,  1174,   357,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   585,    99,   100,
     101,   358,   586,     0,   103,   104,   105,   106,   587,   588,
       0,   108,   109,   110,     0,   111,   589,   590,   114,   359,
     360,     0,     0,     0,   361,   362,     0,     0,     0,     0,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,   365,     0,   366,   367,     0,   368,   369,   370,   371,
     372,   373,   374,     0,   375,   376,     0,     0,     0,     0,
    1119,     0,     0,   377,   378,   379,   129,   380,   381,   382,
       0,  1120,   133,  1121,  1122,     0,   383,   384,     0,   385,
    1123,  1124,   386,  1125,  1126,   388,     0,   389,   390,   391,
     392,  1127,     0,     0,   393,   394,   395,     0,   396,   397,
    1128,   398,     0,   399,   400,   145,   401,  1129,  1130,  1131,
    1132,   402,   403,   404,   405,   406,  1133,  1134,   407,     0,
     408,     0,   409,     0,   410,   411,   412,     0,     0,     0,
     413,  1135,   415,   416,     0,   417,   418,     0,     0,     0,
     420,   421,   422,  1136,   423,     0,  1137,  1138,   424,   425,
    1139,     0,   426,     0,   427,   160,     0,   161,   428,     0,
     429,     0,     0,   430,     0,   431,   432,     0,   433,   434,
     435,     0,   436,   437,   438,   439,     0,   165,   166,     0,
     440,   441,   442,  1140,  1141,     0,  1142,     0,     0,     0,
       0,   443,   172,   444,   445,   446,   447,   448,     0,   173,
     449,     0,     0,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,  1143,   180,  1144,   709,
     463,   464,   465,   466,   182,     0,   467,   468,     0,   469,
       0,  1147,  1148,   470,   471,     0,     0,   472,   710,     0,
       0,     0,   474,     0,     0,   187,   188,   189,  1150,   475,
     476,   477,     0,  1151,   192,   478,   479,     0,   480,   481,
     482,   483,   484,   485,  1152,   486,     0,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   497,   199,   498,
    1153,   499,   500,   501,   502,   503,   504,     0,     0,   505,
     506,   507,  1154,   508,   205,   509,   510,     0,   511,  1155,
       0,   512,   513,   514,   515,   516,   517,   518,   519,  1156,
     520,     0,   521,   522,   523,   524,     0,  1157,  1158,     0,
     526,     0,   527,  1159,   528,  1160,  1161,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,  1163,
       0,   539,   540,   541,  1164,   542,   222,   543,     0,     0,
       0,   544,   545,   546,   547,   548,   549,     0,   223,    49,
       0,   224,   550,     0,     0,  1166,  1167,    52,  1168,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2003,
       0,     0,     0,  1174,   584,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   585,    99,
     100,   101,   358,   586,     0,   103,   104,   105,   106,   587,
     588,     0,   108,   109,   110,     0,   111,   589,   590,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,  1119,     0,     0,   377,   378,   379,   129,   380,   381,
     382,     0,  1120,   133,  1121,  1122,     0,   383,   384,     0,
     385,  1123,  1124,   386,  1125,  1126,   388,     0,   389,   390,
     391,   392,  1127,     0,     0,   393,   394,   395,     0,   396,
     397,  1128,   398,     0,   399,   400,   145,   401,  1129,  1130,
    1131,  1132,   402,   403,   404,   405,   406,  1133,  1134,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,  1135,   415,   416,     0,   417,   418,     0,     0,
       0,   420,   421,   422,  1136,   423,     0,  1137,  1138,   424,
     425,  1139,     0,   426,     0,   427,   160,     0,   161,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,   165,   166,
       0,   440,   441,   442,  1140,  1141,     0,  1142,     0,     0,
       0,     0,   443,   172,   444,   445,   446,   447,   448,     0,
     173,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,  1143,   180,  1144,
     709,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,  1147,  1148,   470,   471,     0,     0,   472,   710,
       0,     0,     0,   474,     0,     0,   187,   188,   189,  1150,
     475,   476,   477,     0,  1151,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,  1152,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,   199,
     498,  1153,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,  1154,   508,   205,   509,   510,     0,   511,
    1155,     0,   512,   513,   514,   515,   516,   517,   518,   519,
    1156,   520,     0,   521,   522,   523,   524,     0,  1157,  1158,
       0,   526,     0,   527,  1159,   528,  1160,  1161,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
    1163,     0,   539,   540,   541,  1164,   542,   222,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
      49,     0,   224,   550,     0,     0,  1166,  1167,    52,  1168,
      53,     0,    79,    80,    81,   355,     0,    83,    84,     0,
      85,    86,    87,   356,  1174,   357,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   358,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   359,   360,     0,
       0,     0,   361,   362,     0,     0,     0,     0,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,     0,   365,
       0,   366,   367,     0,   368,   369,   370,   371,   372,   373,
     374,     0,   375,   376,     0,     0,     0,     0,     0,  2702,
       0,   377,   378,   379,     0,   380,   381,   382,     0,   132,
       0,   134,     0,     0,   383,   384,     0,   385,     0,     0,
     386,   387,   135,   388,     0,   389,   390,   391,   392,   139,
       0,     0,   393,   394,   395,     0,   396,   397,   142,   398,
       0,   399,   400,     0,   401,     0,     0,     0,     0,   402,
     403,   404,   405,   406,   148,   149,   407,     0,   408,     0,
     409,     0,   410,   411,   412,     0,     0,     0,   413,   414,
     415,   416,     0,   417,   418,     0,   419,  -777,   420,   421,
     422,   155,   423,     0,   157,     0,   424,   425,   159,  -777,
     426,     0,   427,     0,     0,     0,   428,     0,   429,     0,
       0,   430,     0,   431,   432,     0,   433,   434,   435,     0,
     436,   437,   438,   439,     0,     0,   166,     0,   440,   441,
     442,     0,   168,  -777,   169,     0,     0,     0,     0,   443,
       0,   444,   445,   446,   447,   448,     0,     0,   449,     0,
    -777,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   179,     0,   181,     0,   463,   464,
     465,   466,   182,     0,   467,   468,     0,   469,     0,   185,
     186,   470,   471,     0,  -777,   472,     0,     0,     0,   473,
     474,     0,  -777,   187,     0,     0,   190,   475,   476,   477,
       0,   191,   192,   478,   479,     0,   480,   481,   482,   483,
     484,   485,   194,   486,     0,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   497,     0,   498,   201,   499,
     500,   501,   502,   503,   504,     0,     0,   505,   506,   507,
       0,   508,   205,   509,   510,     0,   511,   208,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   210,   520,     0,
     521,   522,   523,   524,     0,   211,   212,     0,   526,     0,
     527,   213,   528,   214,     0,   529,   530,   531,   532,   533,
    -777,     0,   534,   535,   536,   537,   538,     0,     0,   539,
     540,   541,   221,   542,     0,   543,     0,     0,     4,   544,
     545,   546,   547,   548,   549,     0,   223,     0,     0,   224,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1250,     7,     8,     0,     0,     0,     0,     0,
       0,    10,    11,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,    49,     0,    50,     0,     0,     0,
       0,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,     0,     0,    60,    61,   935,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   358,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,   378,
     379,   129,   380,   381,   382,   131,   132,   133,   134,     0,
       0,   383,   384,     0,   385,     0,  1124,   386,   387,   135,
     388,     0,   389,   390,   391,   392,  1127,     0,     0,   393,
     394,   395,     0,   396,   397,  1128,   398,     0,   399,   400,
     145,   401,  1129,  1130,  1131,  1132,   402,   403,   404,   405,
     406,   148,   149,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   155,   423,
       0,  1137,     0,   424,   425,   159,     0,   426,     0,   427,
     160,     0,   161,   428,     0,   429,     0,     0,   430,     0,
     431,   432,   164,   433,   434,   435,     0,   436,   437,   438,
     439,     0,   165,   166,     0,   440,   441,   442,     0,   168,
       0,   169,     0,     0,   170,   171,   443,   172,   444,   445,
     446,   447,   448,     0,   173,   449,   174,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   179,   180,   181,   709,   463,   464,   465,   466,   182,
       0,   467,   468,   184,   469,     0,  1147,   186,   470,   471,
       0,     0,   472,   710,     0,   871,   473,   474,     0,     0,
     187,   188,   189,  1150,   475,   476,   477,     0,  1151,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,   194,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   199,   498,   201,   499,   500,   501,   502,
     503,   504,     0,   203,   505,   506,   507,  1154,   508,   205,
     509,   510,   207,   511,   208,     0,   512,   513,   514,   515,
     516,   517,   518,   519,  1156,   520,     0,   521,   522,   523,
     524,     0,   211,   212,     0,   526,     0,   527,  1159,   528,
    1160,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,  1163,     0,   539,   540,   541,   221,
     542,   222,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,     0,     0,     0,
       0,     0,    79,    80,    81,   355,     0,    83,    84,     0,
      85,    86,    87,   356,     0,   357,     0,    91,  2430,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   358,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   359,   360,     0,
       0,     0,   361,   362,     0,     0,     0,     0,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,     0,   365,
       0,   366,   367,     0,   368,   369,   370,   371,   372,   373,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,   378,   379,   129,   380,   381,   382,   131,   132,
     133,   134,     0,     0,   383,   384,     0,   385,     0,  1124,
     386,   387,   135,   388,     0,   389,   390,   391,   392,  1127,
       0,     0,   393,   394,   395,     0,   396,   397,  1128,   398,
       0,   399,   400,   145,   401,  1129,  1130,  1131,  1132,   402,
     403,   404,   405,   406,   148,   149,   407,     0,   408,     0,
     409,     0,   410,   411,   412,     0,     0,     0,   413,   414,
     415,   416,     0,   417,   418,     0,   419,     0,   420,   421,
     422,   155,   423,     0,  1137,     0,   424,   425,   159,     0,
     426,     0,   427,   160,     0,   161,   428,     0,   429,     0,
       0,   430,     0,   431,   432,   164,   433,   434,   435,     0,
     436,   437,   438,   439,     0,   165,   166,     0,   440,   441,
     442,     0,   168,     0,   169,     0,     0,   170,   171,   443,
     172,   444,   445,   446,   447,   448,     0,   173,   449,   174,
       0,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   179,   180,   181,   709,   463,   464,
     465,   466,   182,     0,   467,   468,   184,   469,     0,  1147,
     186,   470,   471,     0,     0,   472,   710,     0,   871,   473,
     474,     0,     0,   187,   188,   189,  1150,   475,   476,   477,
       0,  1151,   192,   478,   479,     0,   480,   481,   482,   483,
     484,   485,   194,   486,     0,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   497,   199,   498,   201,   499,
     500,   501,   502,   503,   504,     0,     0,   505,   506,   507,
    1154,   508,   205,   509,   510,   207,   511,   208,     0,   512,
     513,   514,   515,   516,   517,   518,   519,  1156,   520,     0,
     521,   522,   523,   524,     0,   211,   212,     0,   526,     0,
     527,  1159,   528,  1160,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,  1163,     0,   539,
     540,   541,   221,   542,   222,   543,     0,     0,     0,   544,
     545,   546,   547,   548,   549,     0,   223,     0,     0,   224,
       0,     0,     0,     0,     0,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,  2430,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,   129,   380,   381,
     382,   131,   132,   133,   134,     0,     0,   383,   384,     0,
     385,     0,  1124,   386,   387,   135,   388,     0,   389,   390,
     391,   392,  1127,     0,     0,   393,   394,   395,     0,   396,
     397,  1128,   398,     0,   399,   400,   145,   401,  1129,  1130,
    1131,  1132,   402,   403,   404,   405,   406,   148,   149,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,  1137,     0,   424,
     425,   159,     0,   426,     0,   427,   160,     0,   161,   428,
       0,   429,     0,     0,   430,     0,   431,   432,   164,   433,
     434,   435,     0,   436,   437,   438,   439,     0,   165,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
     170,   171,   443,   172,   444,   445,   446,   447,   448,     0,
     173,   449,   174,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,   180,   181,
     709,   463,   464,   465,   466,   182,     0,   467,   468,   184,
     469,     0,  1147,   186,   470,   471,     0,     0,   472,   710,
       0,     0,   473,   474,     0,     0,   187,   188,   189,  1150,
     475,   476,   477,     0,  1151,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,   199,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,  1154,   508,   205,   509,   510,   207,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
    1156,   520,     0,   521,   522,   523,   524,     0,   211,   212,
       0,   526,     0,   527,  1159,   528,  1160,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
    1163,     0,   539,   540,   541,   221,   542,   222,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,     0,     0,     0,     0,     0,    79,    80,
      81,   355,     0,    83,    84,     0,    85,    86,    87,   356,
       0,   357,     0,    91,  2951,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   358,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   359,   360,     0,     0,     0,   361,   362,
       0,     0,     0,     0,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,     0,   365,     0,   366,   367,     0,
     368,   369,   370,   371,   372,   373,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,   378,   379,
       0,   380,   381,   382,     0,   132,     0,   134,     0,     0,
     383,   384,     0,   385,     0,     0,   386,   387,   135,   388,
       0,   389,   390,   391,   392,   139,     0,     0,   393,   394,
     395,     0,   396,   397,   142,   398,     0,   399,   400,     0,
     401,     0,     0,     0,     0,   402,   403,   404,   405,   406,
     148,   149,   407,     0,   408,     0,   409,     0,   410,   411,
     412,     0,     0,     0,   413,   414,   415,   416,     0,   417,
     418,     0,   419,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   424,   425,   159,     0,   426,     0,   427,     0,
       0,     0,   428,     0,   429,     0,     0,   430,     0,   431,
     432,     0,   433,   434,   435,     0,   436,   437,   438,   439,
       0,     0,   166,     0,   440,   441,   442,     0,   168,     0,
     169,     0,     0,     0,     0,   443,     0,   444,   445,   446,
     447,   448,     0,     0,   449,     0,     0,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     179,     0,   181,     0,   463,   464,   465,   466,   182,     0,
     467,   468,     0,   469,     0,   185,   186,   470,   471,     0,
       0,   472,     0,     0,     0,   473,   474,     0,     0,   187,
       0,     0,   190,   475,   476,   477,     0,   191,   192,   478,
     479,     0,   480,   481,   482,   483,   484,   485,   194,   486,
       0,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   497,     0,   498,   201,   499,   500,   501,   502,   503,
     504,     0,     0,   505,   506,   507,     0,   508,   205,   509,
     510,     0,   511,   208,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   210,   520,     0,   521,   522,   523,   524,
       0,   211,   212,     0,   526,     0,   527,   213,   528,   214,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,     0,     0,   539,   540,   541,   221,   542,
       0,   543,     0,     0,     0,   544,   545,   546,   547,   548,
     549,     0,   223,    49,     0,   224,   550,     0,     0,     0,
       0,    52,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2240,  2241,    79,    80,
      81,   355,     0,    83,    84,     0,    85,    86,    87,   356,
       0,   357,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   358,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   359,   360,     0,     0,     0,   361,   362,
       0,     0,     0,     0,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,     0,   365,     0,   366,   367,     0,
     368,   369,   370,   371,   372,   373,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,   378,   379,
       0,   380,   381,   382,     0,   132,     0,   134,     0,     0,
     383,   384,     0,   385,     0,     0,   386,   387,   135,   388,
       0,   389,   390,   391,   392,   139,     0,     0,   393,   394,
     395,     0,   396,   397,   142,   398,     0,   399,   400,     0,
     401,     0,     0,     0,     0,   402,   403,   404,   405,   406,
     148,   149,   407,     0,   408,     0,   409,     0,   410,   411,
     412,     0,     0,     0,   413,   414,   415,   416,     0,   417,
     418,     0,   419,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   424,   425,   159,     0,   426,     0,   427,     0,
       0,     0,   428,     0,   429,     0,     0,   430,     0,   431,
     432,     0,   433,   434,   435,     0,   436,   437,   438,   439,
       0,     0,   166,     0,   440,   441,   442,     0,   168,     0,
     169,     0,     0,     0,     0,   443,     0,   444,   445,   446,
     447,   448,     0,     0,   449,     0,     0,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     179,     0,   181,     0,   463,   464,   465,   466,   182,     0,
     467,   468,     0,   469,     0,   185,   186,   470,   471,     0,
       0,   472,     0,     0,     0,   473,   474,     0,     0,   187,
       0,     0,   190,   475,   476,   477,     0,   191,   192,   478,
     479,     0,   480,   481,   482,   483,   484,   485,   194,   486,
       0,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   497,     0,   498,   201,   499,   500,   501,   502,   503,
     504,     0,     0,   505,   506,   507,     0,   508,   205,   509,
     510,     0,   511,   208,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   210,   520,     0,   521,   522,   523,   524,
       0,   211,   212,     0,   526,     0,   527,   213,   528,   214,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,     0,     0,   539,   540,   541,   221,   542,
       0,   543,     0,     0,     0,   544,   545,   546,   547,   548,
     549,     0,   223,    49,     0,   224,   550,     0,     0,     0,
       0,    52,     0,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,  2241,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     358,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   359,   360,
       0,     0,     0,   361,   362,     0,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
     365,     0,   366,   367,     0,   368,   369,   370,   371,   372,
     373,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,   378,   379,     0,   380,   381,   382,     0,
     132,     0,   134,     0,     0,   383,   384,     0,   385,     0,
       0,   386,   387,   135,   388,     0,   389,   390,   391,   392,
     139,     0,     0,   393,   394,   395,     0,   396,   397,   142,
     398,     0,   399,   400,     0,   401,     0,     0,     0,     0,
     402,   403,   404,   405,   406,   148,   149,   407,     0,   408,
       0,   409,     0,   410,   411,   412,     0,     0,     0,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   424,   425,   159,
       0,   426,     0,   427,     0,     0,     0,   428,     0,   429,
       0,     0,   430,     0,   431,   432,     0,   433,   434,   435,
       0,   436,   437,   438,   439,     0,     0,   166,     0,   440,
     441,   442,     0,   168,     0,   169,     0,     0,     0,     0,
     443,     0,   444,   445,   446,   447,   448,     0,     0,   449,
       0,     0,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   179,     0,   181,   709,   463,
     464,   465,   466,   182,     0,   467,   468,     0,   469,     0,
     185,   186,   470,   471,     0,     0,   472,   710,     0,     0,
     473,   474,     0,     0,   187,     0,     0,   190,   475,   476,
     477,     0,   191,   192,   478,   479,     0,   480,   481,   482,
     483,   484,   485,   194,   486,     0,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,     0,   498,   201,
     499,   500,   501,   502,   503,   504,     0,     0,   505,   506,
     507,     0,   508,   205,   509,   510,     0,   511,   208,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   210,   520,
       0,   521,   522,   523,   524,     0,   211,   212,     0,   526,
       0,   527,   213,   528,   214,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,     0,     0,
     539,   540,   541,   221,   542,     0,   543,     0,     0,     0,
     544,   545,   546,   547,   548,   549,     0,   223,     0,     0,
     224,     0,     0,     0,     0,     0,    79,    80,    81,   355,
       0,    83,    84,     0,    85,    86,    87,   356,     0,   357,
       0,    91,  1244,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   358,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   359,   360,     0,     0,     0,   361,   362,     0,     0,
       0,     0,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,     0,   365,     0,   366,   367,     0,   368,   369,
     370,   371,   372,   373,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,   378,   379,     0,   380,
     381,   382,     0,   132,     0,   134,     0,     0,   383,   384,
       0,   385,     0,     0,   386,   387,   135,   388,     0,   389,
     390,   391,   392,   139,     0,     0,   393,   394,   395,     0,
     396,   397,   142,   398,     0,   399,   400,     0,   401,     0,
       0,     0,     0,   402,   403,   404,   405,   406,   148,   149,
     407,     0,   408,     0,   409,     0,   410,   411,   412,     0,
       0,     0,   413,   414,   415,   416,     0,   417,   418,     0,
     419,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     424,   425,   159,     0,   426,     0,   427,     0,     0,     0,
     428,     0,   429,     0,     0,   430,     0,   431,   432,     0,
     433,   434,   435,     0,   436,   437,   438,   439,     0,     0,
     166,     0,   440,   441,   442,     0,   168,     0,   169,     0,
       0,     0,     0,   443,     0,   444,   445,   446,   447,   448,
       0,     0,   449,     0,     0,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   179,     0,
     181,     0,   463,   464,   465,   466,   182,     0,   467,   468,
       0,   469,     0,   185,   186,   470,   471,     0,     0,   472,
       0,     0,     0,   473,   474,     0,     0,   187,     0,     0,
     190,   475,   476,   477,     0,   191,   192,   478,   479,     0,
     480,   481,   482,   483,   484,   485,   194,   486,     0,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
       0,   498,   201,   499,   500,   501,   502,   503,   504,     0,
     203,   505,   506,   507,     0,   508,   205,   509,   510,     0,
     511,   208,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   210,   520,     0,   521,   522,   523,   524,     0,   211,
     212,     0,   526,     0,   527,   213,   528,   214,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,     0,     0,   539,   540,   541,   221,   542,     0,   543,
       0,     0,     0,   544,   545,   546,   547,   548,   549,     0,
     223,     0,     0,   224,   550,     0,     0,     0,     0,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,   225,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   358,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,   378,
     379,     0,   380,   381,   382,     0,   132,     0,   134,     0,
       0,   383,   384,     0,   385,     0,     0,   386,   387,   135,
     388,     0,   389,   390,   391,   392,   139,     0,     0,   393,
     394,   395,     0,   396,   397,   142,   398,     0,   399,   400,
       0,   401,     0,     0,     0,     0,   402,   403,   404,   405,
     406,   148,   149,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   424,   425,   159,     0,   426,     0,   427,
       0,     0,     0,   428,     0,   429,     0,     0,   430,     0,
     431,   432,     0,   433,   434,   435,     0,   436,   437,   438,
     439,     0,     0,   166,     0,   440,   441,   442,     0,   168,
       0,   169,     0,     0,     0,     0,   443,     0,   444,   445,
     446,   447,   448,     0,     0,   449,     0,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   179,     0,   181,     0,   463,   464,   465,   466,   182,
       0,   467,   468,     0,   469,     0,   185,   186,   470,   471,
       0,     0,   472,     0,     0,     0,   473,   474,     0,     0,
     187,     0,     0,   190,   475,   476,   477,     0,   191,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,   194,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,     0,   498,   201,   499,   500,   501,   502,
     503,   504,     0,   203,   505,   506,   507,     0,   508,   205,
     509,   510,     0,   511,   208,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   210,   520,     0,   521,   522,   523,
     524,     0,   211,   212,     0,   526,     0,   527,   213,   528,
     214,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,     0,     0,   539,   540,   541,   221,
     542,     0,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,     0,     0,     0,
       0,     0,    79,    80,    81,   355,     0,    83,    84,     0,
      85,    86,    87,   356,     0,   357,     0,    91,   225,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   358,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   359,   360,     0,
       0,     0,   361,   362,     0,     0,     0,     0,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,     0,   365,
       0,   366,   367,     0,   368,   369,   370,   371,   372,   373,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,   378,   379,     0,   380,   381,   382,     0,   132,
       0,   134,     0,     0,   383,   384,     0,   385,     0,     0,
     386,   387,   135,   388,     0,   389,   390,   391,   392,   139,
       0,     0,   393,   394,   395,     0,   396,   397,   142,   398,
       0,   399,   400,     0,   401,     0,     0,     0,     0,   402,
     403,   404,   405,   406,   148,   149,   407,     0,   408,     0,
     409,     0,   410,   411,   412,     0,     0,     0,   413,   414,
     415,   416,     0,   417,   418,     0,   419,     0,   420,   421,
     422,   155,   423,     0,   157,     0,   424,   425,   159,     0,
     426,     0,   427,     0,     0,     0,   428,     0,   429,     0,
       0,   430,     0,   431,   432,     0,   433,   434,   435,     0,
     436,   437,   438,   439,     0,     0,   166,     0,   440,   441,
     442,     0,   168,     0,   169,     0,     0,     0,     0,   443,
       0,   444,   445,   446,   447,   448,     0,     0,   449,     0,
       0,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   179,     0,   181,     0,   463,   464,
     465,   466,   182,     0,   467,   468,     0,   469,     0,   185,
     186,   470,   471,     0,     0,   472,     0,     0,     0,   473,
     474,     0,     0,   187,     0,     0,   190,   475,   476,   477,
       0,   191,   192,   478,   479,     0,   480,   481,   482,   483,
     484,   485,   194,   486,     0,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   497,     0,   498,   201,   499,
     500,   501,   502,   503,   504,     0,     0,   505,   506,   507,
       0,   508,   205,   509,   510,     0,   511,   208,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   210,   520,     0,
     521,   522,   523,   524,     0,   211,   212,     0,   526,     0,
     527,   213,   528,   214,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,     0,     0,   539,
     540,   541,   221,   542,     0,   543,     0,     0,     0,   544,
     545,   546,   547,   548,   549,     0,   223,     0,     0,   224,
       0,     0,     0,     0,     0,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,  1680,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
       0,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,     0,
       0,     0,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   211,   212,
       0,   526,     0,   527,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,     0,     0,     0,     0,   584,    79,    80,
      81,   355,     0,    83,    84,     0,    85,    86,    87,   356,
       0,   357,     0,    91,  2882,    93,    94,    95,    96,    97,
      98,   585,    99,   100,   101,   358,   586,     0,   103,   104,
     105,   106,   587,   588,     0,   108,   109,   110,     0,   111,
     589,   590,   114,   359,   360,     0,     0,     0,   361,   362,
       0,     0,     0,     0,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,     0,   365,     0,   366,   367,     0,
     368,   369,   370,   371,   372,   373,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,   378,   379,
       0,   380,   381,   382,     0,  1404,     0,  1405,  1122,     0,
     383,   384,     0,   385,     0,     0,   386,  1406,  1407,   388,
       0,   389,   390,   391,   392,     0,     0,     0,   393,   394,
     395,     0,   396,   397,     0,   398,     0,   399,   400,     0,
     401,     0,     0,     0,     0,   402,   403,   404,   405,   406,
    1408,  1409,   407,     0,   408,     0,   409,     0,   410,   411,
     412,     0,     0,     0,   413,  1135,   415,   416,     0,   417,
     418,     0,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,   424,   425,  1410,     0,   426,     0,   427,     0,
       0,     0,   428,     0,   429,     0,     0,   430,     0,   431,
     432,     0,   433,   434,   435,     0,   436,   437,   438,   439,
       0,     0,     0,     0,   440,   441,   442,  1140,  1411,     0,
    1412,     0,     0,     0,     0,   443,     0,   444,   445,   446,
     447,   448,     0,     0,   449,     0,     0,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
    1413,     0,  1414,     0,   463,   464,   465,   466,     0,     0,
     467,   468,     0,   469,     0,     0,  1415,   470,   471,     0,
       0,   472,     0,     0,     0,  2539,   474,     0,     0,     0,
       0,     0,     0,   475,   476,   477,     0,     0,     0,   478,
     479,     0,   480,   481,   482,   483,   484,   485,  1416,   486,
       0,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   497,     0,   498,     0,   499,   500,   501,   502,   503,
     504,     0,     0,   505,   506,   507,     0,   508,  1417,   509,
     510,     0,   511,  1418,     0,   512,   513,   514,   515,   516,
     517,   518,   519,     0,   520,     0,   521,   522,   523,   524,
       0,  1419,  1420,     0,   526,     0,   527,     0,   528,     0,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,     0,     0,   539,   540,   541,  1421,   542,
       0,   543,     0,     0,     0,   544,   545,   546,   547,   548,
     549,     0,   223,    49,   981,   224,   550,     0,     0,     0,
       0,    52,     0,    53,   982,   983,   984,     0,   985,  2540,
     987,   988,   989,   990,    79,    80,    81,   355,     0,    83,
      84,     0,    85,    86,    87,   356,     0,   357,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   358,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   359,
     360,     0,     0,     0,   361,   362,     0,     0,     0,     0,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,   365,     0,   366,   367,     0,   368,   369,   370,   371,
     372,   373,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,   378,   379,     0,   380,   381,   382,
       0,   132,     0,   134,     0,     0,   383,   384,     0,   385,
       0,     0,   386,   387,   135,   388,     0,   389,   980,   391,
     392,   139,     0,     0,   393,   394,   395,     0,   396,   397,
     142,   398,     0,   399,   400,     0,   401,     0,     0,     0,
       0,   402,   403,   404,   405,   406,   148,   149,   407,     0,
     408,     0,   409,     0,   410,   411,   412,     0,     0,     0,
     413,   414,   415,   416,     0,   417,   418,     0,   419,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   424,   425,
     159,     0,   426,     0,   427,     0,     0,     0,   428,     0,
     429,     0,     0,   430,     0,   431,   432,     0,   433,   434,
     435,     0,   436,   437,   438,   439,     0,     0,   166,     0,
     440,   441,   442,     0,   168,     0,   169,     0,     0,     0,
       0,   443,     0,   444,   445,   446,   447,   448,     0,     0,
     449,     0,     0,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   179,     0,   181,     0,
     463,   464,   465,   466,   182,     0,   467,   468,     0,   469,
       0,   185,   186,   470,   471,     0,     0,   472,     0,     0,
       0,   473,   474,     0,     0,   187,     0,     0,   190,   475,
     476,   477,     0,   191,   192,   478,   479,     0,   480,   481,
     482,   483,   484,   485,   194,   486,     0,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   497,     0,   498,
     201,   499,   500,   501,   502,   503,   504,     0,     0,   505,
     506,   507,     0,   508,   205,   509,   510,     0,   511,   208,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   210,
     520,     0,   521,   522,   523,   524,     0,   211,   212,     0,
     526,     0,   527,   213,   528,   214,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,     0,
       0,   539,   540,   541,   221,   542,     0,   543,     0,     0,
       0,   544,   545,   546,   547,   548,   549,     0,   223,     0,
     981,   224,     0,     0,     0,     0,     0,     0,     0,     0,
     982,   983,   984,     0,   985,   986,   987,   988,   989,   990,
      79,    80,    81,   355,     0,    83,    84,     0,    85,    86,
      87,   356,     0,   357,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   358,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   359,   360,     0,     0,     0,
     361,   362,     0,     0,     0,     0,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,     0,   365,     0,   366,
     367,     0,   368,   369,   370,   371,   372,   373,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
     378,   379,     0,   380,   381,   382,     0,   132,     0,   134,
       0,     0,   383,   384,     0,   385,     0,     0,   386,   387,
     135,   388,     0,   389,   390,   391,   392,   139,     0,     0,
     393,   394,   395,     0,   396,   397,   142,   398,     0,   399,
     400,     0,   401,     0,     0,     0,     0,   402,   403,   404,
     405,   406,   148,   149,   407,     0,   408,     0,   409,     0,
     410,   411,   412,     0,     0,     0,   413,   414,   415,   416,
       0,   417,   418,     0,   419,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   424,   425,   159,     0,   426,     0,
     427,     0,     0,     0,   428,     0,   429,     0,     0,   430,
       0,   431,   432,     0,   433,   434,   435,     0,   436,   437,
     438,   439,     0,     0,   166,     0,   440,   441,   442,     0,
     168,     0,   169,     0,     0,     0,     0,   443,     0,   444,
     445,   446,   447,   448,     0,     0,   449,     0,     0,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   179,     0,   181,     0,   463,   464,   465,   466,
     182,     0,   467,   468,     0,   469,     0,   185,   186,   470,
     471,     0,     0,   472,     0,     0,     0,   473,   474,     0,
       0,   187,     0,     0,   190,   475,   476,   477,     0,   191,
     192,   478,   479,     0,   480,   481,   482,   483,   484,   485,
     194,   486,     0,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,     0,   498,   201,   499,   500,   501,
     502,   503,   504,     0,     0,   505,   506,   507,     0,   508,
     205,   509,   510,     0,   511,   208,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   210,   520,     0,   521,   522,
     523,   524,     0,   211,   212,     0,   526,     0,   527,   213,
     528,   214,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,     0,     0,   539,   540,   541,
     221,   542,     0,   543,     0,     0,     0,   544,   545,   546,
     547,   548,   549,     0,   223,     0,   981,   224,     0,     0,
       0,     0,     0,     0,     0,     0,   982,   983,   984,     0,
     985,   986,   987,   988,   989,   990,   584,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     585,    99,   100,   101,   358,   586,     0,   103,   104,   105,
     106,   587,   588,     0,   108,   109,   110,     0,   111,   589,
     590,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,   591,   375,   376,   592,
     593,   594,   595,   596,   597,   598,   377,   378,   379,   129,
     380,   381,   382,   131,   132,   133,   134,     0,   599,   383,
     384,     0,   385,   600,   601,   386,   602,   135,   388,   603,
     389,   390,   391,   392,   139,   604,   605,   393,   394,   395,
     606,   396,   397,   142,   398,   607,   399,   400,   145,   401,
     608,   609,   610,   611,   402,   403,   404,   405,   406,   148,
     149,   407,   612,   408,   613,   409,     0,   410,   411,   412,
     614,   615,   616,   413,   414,   415,   416,   617,   417,   418,
     618,   419,   619,   420,   421,   422,   155,   423,     0,   157,
     620,   424,   425,   159,   621,   426,   622,   427,   160,   623,
     161,   428,     0,   429,   624,   625,   430,   626,   431,   432,
     164,   433,   434,   435,   627,   436,   437,   438,   439,   628,
     165,   166,   629,   440,   441,   442,   630,   168,   631,   169,
     632,     0,   170,   171,   443,   172,   444,   445,   446,   447,
     448,   633,   173,   449,   174,   634,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   179,
     180,   181,   635,   463,   464,   465,   466,   182,   636,   467,
     468,   184,   469,   637,   185,   186,   470,   471,   638,   639,
     472,   640,   641,   642,   473,   474,   643,   644,   187,   188,
     189,   190,   475,   476,   477,     0,   191,   192,   478,   479,
     645,   480,   481,   482,   483,   484,   485,   194,   486,   646,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,   199,   498,   201,   499,   500,   501,   502,   503,   504,
       0,   647,   505,   506,   507,   648,   508,   205,   509,   510,
     207,   511,   208,   649,   512,   513,   514,   515,   516,   517,
     518,   519,   210,   520,   650,   521,   522,   523,   524,   651,
     211,   212,   652,   526,   653,   527,   213,   528,   214,   654,
     529,   530,   531,   532,   533,   655,   656,   534,   535,   536,
     537,   538,   657,   658,   539,   540,   541,   221,   542,   222,
     543,     0,   659,   660,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,     0,   584,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,  1384,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     585,    99,   100,   101,   358,   586,     0,   103,   104,   105,
     106,   587,   588,     0,   108,   109,   110,     0,   111,   589,
     590,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     380,   381,   382,     0,  1404,     0,  1405,  1122,     0,   383,
     384,     0,   385,     0,     0,   386,  1406,  1407,   388,     0,
     389,   390,   391,   392,     0,     0,     0,   393,   394,   395,
       0,   396,   397,     0,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,  1408,
    1409,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,  1135,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,   424,   425,  1410,     0,   426,     0,   427,     0,     0,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
       0,     0,     0,   440,   441,   442,  1140,  1411,     0,  1412,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,  1413,
       0,  1414,     0,   463,   464,   465,   466,     0,     0,   467,
     468,     0,   469,     0,     0,  1415,   470,   471,     0,     0,
     472,     0,     0,     0,   473,   474,     0,     0,     0,     0,
       0,     0,   475,   476,   477,     0,     0,     0,   478,   479,
       0,   480,   481,   482,   483,   484,   485,  1416,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,     0,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,     0,   508,  1417,   509,   510,
       0,   511,  1418,     0,   512,   513,   514,   515,   516,   517,
     518,   519,     0,   520,     0,   521,   522,   523,   524,     0,
    1419,  1420,     0,   526,     0,   527,     0,   528,     0,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,     0,   539,   540,   541,  1421,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,  1750,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
     709,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,   710,
       0,     0,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   211,   212,
       0,   526,     0,   527,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,   869,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     358,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   359,   360,
       0,     0,     0,   361,   362,     0,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
     365,     0,   366,   367,     0,   368,   369,   370,   371,   372,
     373,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,   378,   379,     0,   380,   381,   382,     0,
     132,     0,   134,     0,     0,   383,   384,     0,   385,     0,
       0,   386,   387,   135,   388,     0,   389,   390,   391,   392,
     139,     0,     0,   393,   394,   395,     0,   396,   397,   142,
     398,     0,   399,   400,     0,   401,     0,     0,     0,     0,
     402,   403,   404,   405,   406,   148,   149,   407,  1664,   408,
       0,   409,     0,   410,   411,   412,     0,     0,     0,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   155,   423,     0,   157,  1665,   424,   425,   159,
       0,   426,     0,   427,     0,     0,     0,   428,     0,   429,
       0,     0,   430,     0,   431,   432,     0,   433,   434,   435,
       0,   436,   437,   438,   439,     0,     0,   166,     0,   440,
     441,   442,     0,   168,     0,   169,     0,     0,     0,     0,
     443,     0,   444,   445,   446,   447,   448,     0,     0,   449,
       0,     0,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   179,     0,   181,     0,   463,
     464,   465,   466,   182,     0,   467,   468,     0,   469,     0,
     185,   186,   470,   471,  1666,     0,   472,     0,  1667,     0,
     473,   474,     0,     0,   187,     0,     0,   190,   475,   476,
     477,     0,   191,   192,   478,   479,     0,   480,   481,   482,
     483,   484,   485,   194,   486,     0,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,     0,   498,   201,
     499,   500,   501,   502,   503,   504,     0,     0,   505,   506,
     507,     0,   508,   205,   509,   510,     0,   511,   208,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   210,   520,
       0,   521,   522,   523,   524,     0,   211,   212,     0,   526,
       0,   527,   213,   528,   214,  1668,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,     0,     0,
     539,   540,   541,   221,   542,     0,   543,     0,     0,     0,
     544,   545,   546,   547,   548,   549,     0,   223,    49,     0,
     224,   550,     0,     0,     0,     0,    52,     0,    53,     0,
      79,    80,    81,   355,  1279,    83,    84,     0,    85,    86,
      87,   356,     0,   357,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   358,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   359,   360,     0,     0,     0,
     361,   362,     0,     0,     0,     0,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,     0,   365,     0,   366,
     367,     0,   368,   369,   370,   371,   372,   373,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
     378,   379,     0,   380,   381,   382,     0,   132,     0,   134,
       0,     0,   383,   384,     0,   385,     0,     0,   386,   387,
     135,   388,     0,   389,   390,   391,   392,   139,     0,     0,
     393,   394,   395,     0,   396,   397,   142,   398,     0,   399,
     400,     0,   401,     0,     0,     0,     0,   402,   403,   404,
     405,   406,   148,   149,   407,     0,   408,     0,   409,     0,
     410,   411,   412,     0,     0,     0,   413,   414,   415,   416,
       0,   417,   418,     0,   419,     0,   420,   421,   422,   155,
     423,     0,   157,  1665,   424,   425,   159,     0,   426,     0,
     427,     0,     0,     0,   428,     0,   429,     0,     0,   430,
       0,   431,   432,     0,   433,   434,   435,     0,   436,   437,
     438,   439,     0,     0,   166,     0,   440,   441,   442,     0,
     168,     0,   169,     0,     0,     0,     0,   443,     0,   444,
     445,   446,   447,   448,     0,     0,   449,     0,     0,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   179,     0,   181,     0,   463,   464,   465,   466,
     182,     0,   467,   468,     0,   469,     0,   185,   186,   470,
     471,  1666,     0,   472,     0,  1667,     0,   473,   474,     0,
       0,   187,     0,     0,   190,   475,   476,   477,     0,   191,
     192,   478,   479,     0,   480,   481,   482,   483,   484,   485,
     194,   486,     0,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,     0,   498,   201,   499,   500,   501,
     502,   503,   504,     0,     0,   505,   506,   507,     0,   508,
     205,   509,   510,     0,   511,   208,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   210,   520,     0,   521,   522,
     523,   524,     0,   211,   212,     0,   526,     0,   527,   213,
     528,   214,  1668,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,     0,     0,   539,   540,   541,
     221,   542,     0,   543,     0,     0,     0,   544,   545,   546,
     547,   548,   549,     0,   223,    49,     0,   224,   550,     0,
       0,     0,     0,    52,     0,    53,     0,    79,    80,    81,
     355,  1279,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   358,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     782,   370,   371,   372,   373,   374,   783,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     784,   381,   382,     0,   132,     0,   134,     0,     0,   383,
     384,     0,   385,     0,     0,   386,   387,   135,   388,     0,
     389,   390,   391,   392,   139,     0,     0,   393,   394,   395,
       0,   396,   397,   142,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,   148,
     149,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,   414,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   424,   785,   159,     0,   426,     0,   786,     0,   787,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,   788,   436,   437,   438,   439,     0,
       0,   166,     0,   440,   441,   442,     0,   168,     0,   169,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     789,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   179,
       0,   181,     0,   790,   464,   465,   466,   182,     0,   467,
     468,     0,   469,     0,   185,   186,   470,   471,     0,     0,
     472,     0,     0,     0,   473,   474,     0,     0,   187,     0,
       0,   190,   475,   476,   477,     0,   191,   192,   478,   479,
       0,   791,   481,   482,   483,   484,   485,   194,   486,     0,
     487,   792,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,   201,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,     0,   508,   205,   509,   510,
       0,   511,   208,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   210,   520,     0,   521,   522,   523,   524,     0,
     211,   212,     0,   526,     0,   527,   213,   528,   214,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,     0,   539,   540,   541,   221,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,   550,    79,    80,    81,   355,
      52,    83,    84,     0,    85,    86,    87,   356,   793,   357,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   358,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   359,   360,     0,     0,     0,   361,   362,     0,     0,
       0,     0,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,     0,   365,     0,   366,   367,     0,   368,   782,
     370,   371,   372,   373,   374,   783,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,   378,   379,     0,   784,
     381,   382,     0,   132,     0,   134,     0,     0,   383,   384,
       0,   385,     0,     0,   386,   387,   135,   388,     0,   389,
     390,   391,   392,   139,     0,     0,   393,   394,   395,     0,
     396,   397,   142,   398,     0,   399,   400,     0,   401,     0,
       0,     0,     0,   402,   403,   404,   405,   406,   148,   149,
     407,     0,   408,     0,   409,     0,   410,   411,   412,     0,
       0,     0,   413,   414,   415,   416,     0,   417,   418,     0,
     419,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     424,   785,   159,     0,   426,     0,   786,     0,     0,     0,
     428,     0,   429,     0,     0,   430,     0,   431,   432,     0,
     433,   434,   435,     0,   436,   437,   438,   439,     0,     0,
     166,     0,   440,   441,   442,     0,   168,     0,   169,     0,
       0,     0,     0,   443,     0,   444,   445,   446,   447,   789,
       0,     0,   449,     0,     0,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   179,     0,
     181,     0,   790,   464,   465,   466,   182,     0,   467,   468,
       0,   469,     0,   185,   186,   470,   471,     0,     0,   472,
       0,     0,     0,   473,   474,     0,     0,   187,     0,     0,
     190,   475,   476,   477,     0,   191,   192,   478,   479,     0,
     791,   481,   482,   483,   484,   485,   194,   486,     0,   487,
     792,   489,   490,   491,   492,   493,   494,   495,   496,   497,
       0,   498,   201,   499,   500,   501,   502,   503,   504,     0,
       0,   505,   506,   507,     0,   508,   205,   509,   510,     0,
     511,   208,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   210,   520,     0,   521,   522,   523,   524,     0,   211,
     212,     0,   526,     0,   527,   213,   528,   214,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,     0,     0,   539,   540,   541,   221,   542,     0,   543,
       0,     0,     0,   544,   545,   546,   547,   548,   549,     0,
     223,     0,     0,   224,   550,    79,    80,    81,   355,    52,
      83,    84,     0,    85,    86,    87,   356,   793,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
     573,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
       0,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,     0,
       0,     0,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   211,   212,
    1217,   526,     0,   527,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
      49,     0,   224,   550,    79,    80,    81,   355,     0,    83,
      84,  1218,    85,    86,    87,   356,     0,   357,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   358,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   359,
     360,     0,     0,     0,   361,   362,     0,     0,     0,     0,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,   365,     0,   366,   367,     0,   368,   369,   370,   371,
     372,   373,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,   378,   379,     0,   380,   381,   382,
       0,   132,     0,   134,     0,     0,   383,   384,     0,   385,
       0,     0,   386,   387,   135,   388,     0,   389,   390,   391,
     392,   139,     0,     0,   393,   394,   395,     0,   396,   397,
     142,   398,     0,   399,   400,     0,   401,     0,     0,     0,
       0,   402,   403,   404,   405,   406,   148,   149,   407,     0,
     408,     0,   409,     0,   410,   411,   412,     0,     0,     0,
     413,   414,   415,   416,     0,   417,   418,     0,   419,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   424,   425,
     159,     0,   426,     0,   427,     0,     0,     0,   428,     0,
     429,     0,     0,   430,     0,   431,   432,     0,   433,   434,
     435,     0,   436,   437,   438,   439,     0,     0,   166,     0,
     440,   441,   442,     0,   168,     0,   169,     0,     0,     0,
       0,   443,     0,   444,   445,   446,   447,   448,     0,     0,
     449,     0,     0,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   179,     0,   181,     0,
     463,   464,   465,   466,   182,     0,   467,   468,     0,   469,
       0,   185,   186,   470,   471,     0,     0,   472,     0,     0,
       0,   473,   474,     0,     0,   187,     0,     0,   190,   475,
     476,   477,     0,   191,   192,   478,   479,     0,   480,   481,
     482,   483,   484,   485,   194,   486,     0,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   497,     0,   498,
     201,   499,   500,   501,   502,   503,   504,     0,     0,   505,
     506,   507,     0,   508,   205,   509,   510,     0,   511,   208,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   210,
     520,     0,   521,   522,   523,   524,     0,   211,   212,     0,
     526,     0,   527,   213,   528,   214,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,     0,
       0,   539,   540,   541,   221,   542,     0,   543,     0,     0,
       0,   544,   545,   546,   547,   548,   549,     0,   223,    49,
       0,   224,   550,     0,     0,  1166,  1167,    52,     0,    53,
      79,    80,    81,   355,     0,    83,    84,     0,    85,    86,
      87,   356,     0,   357,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   358,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   359,   360,     0,     0,     0,
     361,   362,     0,     0,     0,     0,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,     0,   365,     0,   366,
     367,     0,   368,   369,   370,   371,   372,   373,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
     378,   379,     0,   380,   381,   382,     0,   132,     0,   134,
       0,     0,   383,   384,     0,   385,     0,     0,   386,   387,
     135,   388,     0,   389,   390,   391,   392,   139,     0,     0,
     393,   394,   395,     0,   396,   397,   142,   398,     0,   399,
     400,     0,   401,     0,     0,     0,     0,   402,   403,   404,
     405,   406,   148,   149,   407,     0,   408,     0,   409,     0,
     410,   411,   412,     0,     0,     0,   413,   414,   415,   416,
       0,   417,   418,     0,   419,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   424,   425,   159,     0,   426,     0,
     427,     0,     0,     0,   428,     0,   429,     0,     0,   430,
       0,   431,   432,     0,   433,   434,   435,     0,   436,   437,
     438,   439,     0,     0,   166,     0,   440,   441,   442,     0,
     168,     0,   169,     0,     0,     0,     0,   443,     0,   444,
     445,   446,   447,   448,     0,     0,   449,     0,     0,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   179,     0,   181,     0,   463,   464,   465,   466,
     182,     0,   467,   468,     0,   469,     0,   185,   186,   470,
     471,     0,     0,   472,     0,     0,     0,   473,   474,     0,
       0,   187,     0,     0,   190,   475,   476,   477,     0,   191,
     192,   478,   479,     0,   480,   481,   482,   483,   484,   485,
     194,   486,     0,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,     0,   498,   201,   499,   500,   501,
     502,   503,   504,     0,     0,   505,   506,   507,     0,   508,
     205,   509,   510,     0,   511,   208,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   210,   520,     0,   521,   522,
     523,   524,     0,   211,   212,     0,   526,     0,   527,   213,
     528,   214,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,     0,     0,   539,   540,   541,
     221,   542,     0,   543,     0,     0,     0,   544,   545,   546,
     547,   548,   549,     0,   223,     0,     0,   224,     0,   848,
    1298,    79,    80,    81,   355,   849,    83,    84,     0,    85,
      86,    87,   356,   850,   357,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   358,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   359,   360,     0,     0,
       0,   361,   362,     0,     0,     0,     0,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,     0,   365,     0,
     366,   367,     0,   368,   369,   370,   371,   372,   373,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,   378,   379,     0,   380,   381,   382,     0,   132,     0,
     134,     0,     0,   383,   384,     0,   385,     0,     0,   386,
     387,   135,   388,     0,   389,   390,   391,   392,   139,     0,
       0,   393,   394,   395,     0,   851,   397,   142,   398,     0,
     399,   400,     0,   401,     0,     0,     0,     0,   402,   403,
     404,   405,   406,   148,   149,   407,     0,   408,     0,   409,
       0,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,     0,   417,   418,     0,   419,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   424,   425,   159,     0,   426,
       0,   427,     0,     0,     0,   428,     0,   429,     0,     0,
     430,     0,   431,   432,     0,   433,   434,   435,     0,   436,
     437,   438,   439,     0,     0,   166,     0,   440,   441,   442,
       0,   168,     0,   169,     0,     0,     0,     0,   443,     0,
     444,   445,   446,   447,   448,     0,     0,   449,     0,     0,
     450,   451,   852,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   853,   179,     0,   181,     0,   463,   464,   465,
     466,   182,     0,   467,   468,     0,   469,     0,   185,   186,
     470,   471,     0,     0,   472,     0,     0,     0,   473,   474,
       0,     0,   187,     0,     0,   190,   475,   476,   477,     0,
     191,   192,   478,   479,     0,   480,   481,   482,   483,   484,
     485,   194,   486,     0,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,     0,   498,   201,   499,   500,
     501,   502,   503,   504,     0,     0,   505,   506,   854,     0,
     508,   205,   509,   510,     0,   511,   208,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   210,   520,     0,   521,
     522,   523,   524,     0,   855,   212,     0,   526,     0,   856,
     213,   528,   214,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,     0,     0,   539,   540,
     541,   221,   542,     0,   543,     0,     0,     0,   544,   545,
     546,   547,   548,   549,     0,   223,     0,     0,   224,    79,
      80,    81,     0,     0,    83,    84,     0,    85,    86,    87,
       0,     0,     0,    90,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,     0,     0,     0,   103,
     104,   105,   106,     0,   107,     0,   108,   109,   110, -1298,
     111,   112,   113,   114,     0,     0,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,   123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,     0,     0,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   148,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,   166,     0,     0,     0,     0,     0,   168,
       0,   169,     0,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     0,   173,     0,   174,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,     0,   184,     0,     0,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,   190,     0,     0,     0,     0,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,   207,     0,   208,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,     0,     0,     0,
       0,     0,   211,   212,     0,     0,     0,     0,   213,     0,
     214,     0,     0,     0,     0,     0,     0,   217,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   221,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   223,     0,     0,   224,     0,   346,    79,
      80,    81,     0,     0,    83,    84,     0,    85,    86,    87,
       0,     0,     0,    90,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,     0,     0,     0,   103,
     104,   105,   106,     0,   107,     0,   108,   109,   110, -1299,
     111,   112,   113,   114,     0,     0,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,   123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,     0,     0,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   148,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   165,   166,     0,     0,     0,     0,     0,   168,
       0,   169,     0,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     0,   173,     0,   174,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,     0,   184,     0,     0,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,   190,     0,     0,     0,     0,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,   207,     0,   208,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,     0,     0,     0,
       0,     0,   211,   212,     0,     0,     0,     0,   213,     0,
     214,     0,     0,     0,     0,     0,     0,   217,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   221,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   223,     0,     0,   224,     0,   914,   584,
      79,    80,    81,   355,     0,    83,    84,     0,    85,    86,
      87,   356,     0,   357,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   585,    99,   100,   101,   358,   586,     0,
     103,   104,   105,   106,   587,   588,     0,   108,   109,   110,
       0,   111,   589,   590,   114,   359,   360,     0,     0,     0,
     361,   362,     0,     0,     0,     0,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,     0,   365,     0,   366,
     367,     0,   368,   369,   370,   371,   372,   373,   374,   591,
     375,   376,   592,   593,   594,   595,   596,   597,   598,   377,
     378,   379,   129,   380,   381,   382,   131,   132,   133,   134,
       0,   599,   383,   384,     0,   385,   600,   601,   386,   602,
     135,   388,   603,   389,   390,   391,   392,   139,   604,   605,
     393,   394,   395,   606,   396,   397,   142,   398,   607,   399,
     400,   145,   401,   608,   609,   610,   611,   402,   403,   404,
     405,   406,   148,   149,   407,   612,   408,   613,   409,     0,
     410,   411,   412,   614,   615,   616,   413,   414,   415,   416,
     617,   417,   418,   618,   419,   619,   420,   421,   422,   155,
     423,     0,   157,   620,   424,   425,   159,   621,   426,   622,
     427,   160,   623,   161,   428,     0,   429,   624,   625,   430,
     626,   431,   432,   164,   433,   434,   435,   627,   436,   437,
     438,   439,   628,   165,   166,   629,   440,   441,   442,   630,
     168,   631,   169,   632,     0,   170,   171,   443,   172,   444,
     445,   446,   447,   448,   633,   173,   449,   174,   634,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   179,   180,   181,   635,   463,   464,   465,   466,
     182,   636,   467,   468,   184,   469,   637,   185,   186,   470,
     471,   638,   639,   472,   640,   641,   642,   473,   474,   643,
     644,   187,   188,   189,   190,   475,   476,   477,     0,   191,
     192,   478,   479,   645,   480,   481,   482,   483,   484,   485,
     194,   486,   646,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,   199,   498,   201,   499,   500,   501,
     502,   503,   504,     0,   647,   505,   506,   507,   648,   508,
     205,   509,   510,   207,   511,   208,   649,   512,   513,   514,
     515,   516,   517,   518,   519,   210,   520,   650,   521,   522,
     523,   524,   651,   211,   212,   652,   526,   653,   527,   213,
     528,   214,   654,   529,   530,   531,   532,   533,   655,   656,
     534,   535,   536,   537,   538,   657,   658,   539,   540,   541,
     221,   542,   222,   543,     0,   659,   660,   544,   545,   546,
     547,   548,   549,     0,   223,     0,     0,   224,   584,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   585,    99,   100,   101,   358,   586,     0,   103,
     104,   105,   106,   587,   588,     0,   108,   109,   110,     0,
     111,   589,   590,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,   378,
     379,   129,   380,   381,   382,   131,  1404,   133,  1405,  1122,
       0,   383,   384,     0,   385,     0,     0,   386,  1406,  1407,
     388,     0,   389,   390,   391,   392,     0,     0,     0,   393,
     394,   395,     0,   396,   397,     0,   398,     0,   399,   400,
     145,   401,     0,     0,     0,     0,   402,   403,   404,   405,
     406,  1408,  1409,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,  1135,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,   424,   425,  1410,     0,   426,     0,   427,
     160,     0,   161,   428,     0,   429,     0,     0,   430,     0,
     431,   432,   164,   433,   434,   435,     0,   436,   437,   438,
     439,     0,   165,     0,     0,   440,   441,   442,  1140,  1411,
       0,  1412,     0,     0,   170,   171,   443,   172,   444,   445,
     446,   447,   448,     0,   173,   449,   174,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,  1413,   180,  1414,     0,   463,   464,   465,   466,     0,
       0,   467,   468,   184,   469,     0,     0,  1415,   470,   471,
       0,     0,   472,     0,     0,     0,   473,   474,     0,     0,
       0,   188,   189,     0,   475,   476,   477,     0,     0,     0,
     478,   479,     0,   480,   481,   482,   483,   484,   485,  1416,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   199,   498,     0,   499,   500,   501,   502,
     503,   504,     0,     0,   505,   506,   507,     0,   508,  1417,
     509,   510,   207,   511,  1418,     0,   512,   513,   514,   515,
     516,   517,   518,   519,     0,   520,     0,   521,   522,   523,
     524,     0,  1419,  1420,     0,   526,     0,   527,     0,   528,
       0,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,     0,     0,   539,   540,   541,  1421,
     542,   222,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,    79,    80,    81,
     355,     0,    83,    84,   571,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   358,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,   572,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     380,   381,   382,     0,   132,     0,   134,     0,     0,   383,
     384,     0,   385,     0,     0,   386,   387,   135,   388,     0,
     389,   390,   391,   392,   139,     0,     0,   393,   394,   395,
       0,   396,   397,   142,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,   148,
     149,   407,   573,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,   414,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   424,   425,   159,     0,   426,     0,   427,     0,     0,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
       0,   166,     0,   440,   441,   442,     0,   168,     0,   169,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   179,
       0,   181,     0,   463,   464,   465,   466,   182,     0,   467,
     468,     0,   469,     0,   185,   186,   470,   471,     0,     0,
     472,     0,     0,     0,   473,   474,     0,     0,   187,     0,
       0,   190,   475,   476,   477,     0,   191,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,   194,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,   201,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,     0,   508,   205,   509,   510,
       0,   511,   208,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   210,   520,     0,   521,   522,   523,   524,     0,
     211,   212,     0,   526,     0,   527,   213,   528,   214,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,     0,   539,   540,   541,   221,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,    49,     0,   224,   550,    79,    80,    81,   355,
       0,    83,    84,     0,    85,    86,    87,   356,     0,   357,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   358,     0,     0,   103,   104,   105,   106,
       0,     0,  1310,   108,   109,   110,     0,   111,     0,     0,
     114,   359,   360,     0,     0,     0,   361,   362,     0,     0,
       0,     0,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,     0,   365,     0,   366,   367,     0,   368,   369,
     370,   371,   372,   373,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,   378,   379,     0,   380,
     381,   382,     0,   132,     0,   134,     0,     0,   383,   384,
       0,   385,     0,     0,   386,   387,   135,   388,     0,   389,
     390,   391,   392,   139,     0,     0,   393,   394,   395,     0,
     396,   397,   142,   398,     0,   399,   400,     0,   401,     0,
       0,     0,     0,   402,   403,   404,   405,   406,   148,   149,
     407,     0,   408,     0,   409,     0,   410,   411,   412,     0,
       0,     0,   413,   414,   415,   416,     0,   417,   418,     0,
     419,     0,   420,   421,   422,   155,   423,     0,   157,     0,
     424,   425,   159,     0,   426,     0,   427,     0,     0,     0,
     428,     0,  2071,     0,     0,   430,     0,   431,   432,     0,
     433,   434,   435,     0,   436,   437,   438,   439,     0,     0,
     166,     0,   440,   441,   442,     0,   168,     0,   169,     0,
       0,     0,     0,   443,     0,   444,   445,   446,   447,   448,
       0,     0,   449,     0,     0,   450,   451,  2072,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   179,     0,
     181,   709,   463,   464,   465,   466,   182,     0,   467,   468,
       0,   469,     0,   185,   186,   470,   471,     0,     0,   472,
     710,     0,     0,   473,   474,     0,     0,   187,     0,     0,
     190,   475,   476,   477,     0,   191,   192,   478,   479,     0,
     480,   481,   482,   483,   484,   485,   194,   486,     0,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
       0,   498,   201,   499,   500,   501,   502,   503,   504,     0,
       0,   505,   506,   507,     0,   508,   205,   509,   510,     0,
     511,   208,     0,   512,   513,   514,   515,   516,   517,   518,
     519,   210,   520,  2073,   521,  2074,   523,  2075,     0,   211,
     212,     0,   526,     0,   527,   213,   528,   214,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,     0,     0,   539,   540,   541,   221,   542,     0,   543,
       0,     0,     0,   544,   545,   546,   547,   548,   549,     0,
     223,     0,     0,   224,   550,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
       0,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,     0,
       0,     0,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   211,   212,
     525,   526,     0,   527,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
      49,     0,   224,   550,    79,    80,    81,   355,     0,    83,
      84,     0,    85,    86,    87,   356,     0,   357,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   358,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   359,
     360,     0,     0,     0,   361,   362,     0,     0,     0,     0,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,   365,     0,   366,   367,     0,   368,   369,   370,   371,
     372,   373,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,   378,   379,     0,   380,   381,   382,
       0,   132,     0,   134,     0,     0,   383,   384,     0,   385,
       0,     0,   386,   387,   135,   388,     0,   389,   390,   391,
     392,   139,     0,     0,   393,   394,   395,     0,   396,   397,
     142,   398,     0,   399,   400,     0,   401,     0,     0,     0,
       0,   402,   403,   404,   405,   406,   148,   149,   407,   923,
     408,     0,   409,     0,   410,   411,   412,     0,     0,     0,
     413,   414,   415,   416,     0,   417,   418,     0,   419,     0,
     420,   421,   422,   155,   423,     0,   157,     0,   424,   425,
     159,     0,   426,     0,   427,     0,     0,     0,   428,     0,
     429,     0,     0,   430,     0,   431,   432,     0,   433,   434,
     435,     0,   436,   437,   438,   439,     0,     0,   166,     0,
     440,   441,   442,     0,   168,     0,   169,     0,     0,     0,
       0,   443,     0,   444,   445,   446,   447,   448,     0,     0,
     449,     0,     0,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   179,     0,   181,     0,
     463,   464,   465,   466,   182,     0,   467,   468,     0,   469,
       0,   185,   186,   470,   471,     0,     0,   472,     0,     0,
       0,   473,   474,     0,     0,   187,     0,     0,   190,   475,
     476,   477,     0,   191,   192,   478,   479,     0,   480,   481,
     482,   483,   484,   485,   194,   486,     0,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   497,     0,   498,
     201,   499,   500,   501,   502,   503,   504,     0,     0,   505,
     506,   507,     0,   508,   205,   509,   510,     0,   511,   208,
       0,   512,   513,   514,   515,   516,   517,   518,   519,   210,
     520,     0,   521,   522,   523,   524,     0,   211,   212,     0,
     526,     0,   527,   213,   528,   214,     0,   529,   530,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,     0,
       0,   539,   540,   541,   221,   542,     0,   543,     0,     0,
       0,   544,   545,   546,   547,   548,   549,     0,   223,    49,
       0,   224,   550,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     358,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   359,   360,
       0,     0,     0,   361,   362,     0,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
     365,     0,   366,   367,     0,   368,   369,   370,   371,   372,
     373,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,   378,   379,     0,   380,   381,   382,     0,
     132,     0,   134,     0,     0,   383,   384,     0,   385,     0,
       0,   386,   387,   135,   388,     0,   389,   390,   391,   392,
     139,     0,     0,   393,   394,   395,     0,   396,   397,   142,
     398,     0,   399,   400,     0,   401,     0,     0,     0,     0,
     402,   403,   404,   405,   406,   148,   149,   407,   573,   408,
       0,   409,     0,   410,   411,   412,     0,     0,     0,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   424,   425,   159,
       0,   426,     0,   427,     0,     0,     0,   428,     0,   429,
       0,     0,   430,     0,   431,   432,     0,   433,   434,   435,
       0,   436,   437,   438,   439,     0,     0,   166,     0,   440,
     441,   442,     0,   168,     0,   169,     0,     0,     0,     0,
     443,     0,   444,   445,   446,   447,   448,     0,     0,   449,
       0,     0,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   179,     0,   181,     0,   463,
     464,   465,   466,   182,     0,   467,   468,     0,   469,     0,
     185,   186,   470,   471,     0,     0,   472,     0,     0,     0,
     473,   474,     0,     0,   187,     0,     0,   190,   475,   476,
     477,     0,   191,   192,   478,   479,     0,   480,   481,   482,
     483,   484,   485,   194,   486,     0,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,     0,   498,   201,
     499,   500,   501,   502,   503,   504,     0,     0,   505,   506,
     507,     0,   508,   205,   509,   510,     0,   511,   208,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   210,   520,
       0,   521,   522,   523,   524,     0,   211,   212,     0,   526,
       0,   527,   213,   528,   214,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,     0,     0,
     539,   540,   541,   221,   542,     0,   543,     0,     0,     0,
     544,   545,   546,   547,   548,   549,     0,   223,    49,     0,
     224,   550,    79,    80,    81,   355,     0,    83,    84,     0,
      85,    86,    87,   356,     0,   357,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   358,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   359,   360,     0,
       0,     0,   361,   362,     0,     0,     0,     0,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,     0,   365,
       0,   366,   367,     0,   368,   369,   370,   371,   372,   373,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,   378,   379,     0,   380,   381,   382,     0,   132,
       0,   134,     0,     0,   383,   384,     0,   385,     0,     0,
     386,   387,   135,   388,     0,   389,   390,   391,   392,   139,
       0,     0,   393,   394,   395,     0,   396,   397,   142,   398,
       0,   399,   400,     0,   401,     0,     0,     0,     0,   402,
     403,   404,   405,   406,   148,   149,   407,  1653,   408,     0,
     409,     0,   410,   411,   412,     0,     0,     0,   413,   414,
     415,   416,     0,   417,   418,     0,   419,     0,   420,   421,
     422,   155,   423,     0,   157,     0,   424,   425,   159,     0,
     426,     0,   427,     0,     0,     0,   428,     0,   429,     0,
       0,   430,     0,   431,   432,     0,   433,   434,   435,     0,
     436,   437,   438,   439,     0,     0,   166,     0,   440,   441,
     442,     0,   168,     0,   169,     0,     0,     0,     0,   443,
       0,   444,   445,   446,   447,   448,     0,     0,   449,     0,
       0,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   179,     0,   181,     0,   463,   464,
     465,   466,   182,     0,   467,   468,     0,   469,     0,   185,
     186,   470,   471,     0,     0,   472,     0,     0,     0,   473,
     474,     0,     0,   187,     0,     0,   190,   475,   476,   477,
       0,   191,   192,   478,   479,     0,   480,   481,   482,   483,
     484,   485,   194,   486,     0,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   497,     0,   498,   201,   499,
     500,   501,   502,   503,   504,     0,     0,   505,   506,   507,
       0,   508,   205,   509,   510,     0,   511,   208,     0,   512,
     513,   514,   515,   516,   517,   518,   519,   210,   520,     0,
     521,   522,   523,   524,     0,   211,   212,     0,   526,     0,
     527,   213,   528,   214,     0,   529,   530,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,     0,     0,   539,
     540,   541,   221,   542,     0,   543,     0,     0,     0,   544,
     545,   546,   547,   548,   549,     0,   223,    49,     0,   224,
     550,    79,    80,    81,   355,     0,    83,    84,     0,    85,
      86,    87,   356,     0,   357,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   358,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   359,   360,     0,     0,
       0,   361,   362,     0,     0,     0,     0,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,     0,   365,     0,
     366,   367,     0,   368,   369,   370,   371,   372,   373,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,   378,   379,     0,   380,   381,   382,     0,   132,     0,
     134,     0,     0,   383,   384,     0,   385,     0,     0,   386,
     387,   135,   388,     0,   389,   390,   391,   392,   139,     0,
       0,   393,   394,   395,     0,   396,   397,   142,   398,     0,
     399,   400,     0,   401,     0,     0,     0,     0,   402,   403,
     404,   405,   406,   148,   149,   407,     0,   408,     0,   409,
       0,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,     0,   417,   418,     0,   419,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   424,   425,   159,     0,   426,
       0,   427,     0,     0,     0,   428,     0,   429,     0,     0,
     430,     0,   431,   432,     0,   433,   434,   435,     0,   436,
     437,   438,   439,     0,     0,   166,     0,   440,   441,   442,
       0,   168,     0,   169,     0,     0,     0,     0,   443,     0,
     444,   445,   446,   447,   448,     0,     0,   449,     0,     0,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   179,     0,   181,     0,   463,   464,   465,
     466,   182,     0,   467,   468,     0,   469,     0,   185,   186,
     470,   471,     0,     0,   472,     0,     0,     0,   473,   474,
       0,     0,   187,     0,     0,   190,   475,   476,   477,     0,
     191,   192,   478,   479,     0,   480,   481,   482,   483,   484,
     485,   194,   486,     0,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,     0,   498,   201,   499,   500,
     501,   502,   503,   504,     0,     0,   505,   506,   507,     0,
     508,   205,   509,   510,     0,   511,   208,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   210,   520,     0,   521,
     522,   523,   524,     0,   211,   212,     0,   526,     0,   527,
     213,   528,   214,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,     0,     0,   539,   540,
     541,   221,   542,     0,   543,     0,     0,     0,   544,   545,
     546,   547,   548,   549,     0,   223,    49,     0,   224,   550,
      79,    80,    81,   355,     0,    83,    84,     0,    85,    86,
      87,   356,   747,   357,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   358,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   359,   360,     0,     0,     0,
     361,   362,     0,     0,     0,     0,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,     0,   365,     0,   366,
     367,     0,   368,   369,   370,   371,   372,   373,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
     378,   379,     0,   380,   381,   382,     0,   132,     0,   134,
       0,     0,   383,   384,     0,   385,     0,     0,   386,   387,
     135,   388,     0,   389,   390,   391,   392,   139,     0,     0,
     393,   394,   395,     0,   396,   397,   142,   398,     0,   399,
     400,     0,   401,     0,     0,     0,     0,   402,   403,   404,
     405,   406,   148,   149,   407,     0,   408,     0,   409,     0,
     410,   411,   412,     0,     0,     0,   413,   414,   415,   416,
       0,   417,   418,     0,   419,     0,   420,   421,   422,   155,
     423,     0,   157,     0,   424,   425,   159,     0,   426,     0,
     427,     0,     0,     0,   428,     0,   429,     0,     0,   430,
       0,   431,   432,     0,   433,   434,   435,     0,   436,   437,
     438,   439,     0,     0,   166,     0,   440,   441,   442,     0,
     168,     0,   169,     0,     0,     0,     0,   443,     0,   444,
     445,   446,   447,   448,     0,     0,   449,     0,     0,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   179,     0,   181,     0,   463,   464,   465,   466,
     182,     0,   467,   468,     0,   469,     0,   185,   186,   470,
     471,     0,     0,   472,     0,     0,     0,   473,   474,     0,
       0,   187,     0,     0,   190,   475,   476,   477,     0,   191,
     192,   478,   748,     0,   480,   481,   482,   483,   484,   485,
     194,   486,     0,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,     0,   498,   201,   499,   500,   501,
     502,   503,   504,     0,     0,   505,   506,   507,     0,   508,
     205,   509,   510,     0,   511,   208,     0,   512,   513,   514,
     515,   516,   517,   518,   519,   210,   520,     0,   521,   522,
     523,   524,     0,   211,   212,     0,   526,     0,   527,   213,
     528,   214,     0,   529,   530,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,     0,     0,   539,   540,   541,
     221,   542,     0,   543,     0,     0,     0,   544,   545,   546,
     547,   548,   549,     0,   223,     0,     0,   224,   550,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   358,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,   378,
     379,     0,   380,   381,   382,     0,   132,     0,   134,     0,
       0,   383,   384,     0,   385,     0,     0,   386,   387,   135,
     388,     0,   389,   390,   391,   392,   139,     0,     0,   393,
     394,   395,     0,   396,   397,   142,   398,     0,   399,   400,
       0,   401,     0,     0,     0,     0,   402,   403,   404,   405,
     406,   148,   149,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   424,   425,   159,     0,   426,     0,   427,
       0,     0,     0,   428,     0,   429,     0,     0,   430,     0,
     431,   432,     0,   778,   434,   435,     0,   436,   437,   438,
     439,     0,     0,   166,     0,   440,   441,   442,     0,   168,
       0,   169,     0,     0,     0,     0,   443,     0,   444,   445,
     446,   447,   448,     0,     0,   449,     0,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   179,     0,   181,     0,   463,   464,   465,   466,   182,
       0,   467,   468,     0,   469,     0,   185,   186,   470,   471,
       0,     0,   472,     0,     0,     0,   473,   474,     0,     0,
     187,     0,     0,   190,   475,   476,   477,     0,   191,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,   194,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,     0,   498,   201,   499,   500,   501,   502,
     503,   504,     0,     0,   505,   506,   507,     0,   508,   205,
     509,   510,     0,   511,   208,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   210,   520,     0,   521,   522,   523,
     524,     0,   211,   212,     0,   526,     0,   527,   213,   528,
     214,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,     0,     0,   539,   540,   541,   221,
     542,     0,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,   550,    79,    80,
      81,   355,     0,    83,    84,     0,    85,    86,    87,   356,
       0,   357,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   358,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   359,   360,     0,     0,     0,   361,   362,
       0,     0,     0,     0,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,     0,   365,     0,   366,   367,     0,
     368,   369,   370,   371,   372,   373,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,   378,   379,
       0,   380,   381,   382,     0,   132,     0,   134,     0,     0,
     383,   384,     0,   385,     0,     0,   386,   387,   135,   388,
       0,   389,   390,   391,   392,   139,     0,     0,   393,   394,
     395,     0,   396,   397,   142,   398,     0,   399,   400,     0,
     401,     0,     0,     0,     0,   402,   403,   404,   405,   406,
     148,   149,   407,     0,   408,     0,   409,     0,   410,   411,
     412,     0,     0,     0,   413,   414,   415,   416,     0,   417,
     418,     0,   419,     0,   420,   421,   422,   155,   423,     0,
     157,     0,   424,   425,   159,     0,   426,     0,   427,     0,
       0,     0,   428,     0,   429,     0,     0,   430,     0,   431,
     432,     0,   433,   434,   435,     0,   436,   437,   438,   439,
       0,     0,   166,     0,   440,   441,   442,     0,   168,     0,
     169,     0,     0,     0,     0,   443,     0,   444,   445,   446,
     447,   448,     0,     0,   449,     0,     0,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     179,     0,   181,     0,   463,   464,   465,   466,   182,     0,
     467,   468,     0,   469,     0,   185,   186,   470,   471,     0,
       0,   472,     0,     0,     0,   473,   474,     0,     0,   187,
       0,     0,   190,   475,   476,   477,     0,   191,   192,   478,
     479,     0,   480,   481,   482,   483,   484,   485,   194,   486,
       0,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   497,     0,   498,   201,   499,   500,   501,   502,   503,
     504,     0,     0,   505,   506,   507,     0,   508,   205,   509,
     510,     0,   511,   208,     0,   512,   513,   514,   515,   516,
     517,   518,   519,   210,   520,     0,   521,   522,   523,   524,
       0,   211,   212,     0,   526,     0,   527,   213,   528,   214,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,     0,     0,   539,   540,   541,   221,   542,
       0,   543,     0,     0,     0,   544,   545,   546,   547,   548,
     549,     0,   223,     0,     0,   224,   550,   584,    79,    80,
      81,   355,     0,    83,    84,     0,    85,    86,    87,   356,
       0,   357,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   585,    99,   100,   101,   358,   586,     0,   103,   104,
     105,   106,   587,   588,     0,   108,   109,   110,     0,   111,
     589,   590,   114,   359,   360,     0,     0,     0,   361,   362,
       0,     0,     0,     0,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,     0,   365,     0,   366,   367,     0,
     368,   369,   370,   371,   372,   373,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,   378,   379,
       0,   380,   381,   382,     0,  1404,     0,  1405,  1122,     0,
     383,   384,     0,   385,     0,     0,   386,  1406,  1407,   388,
       0,   389,   390,   391,   392,     0,     0,     0,   393,   394,
     395,     0,   396,   397,     0,   398,     0,   399,   400,     0,
     401,     0,     0,     0,     0,   402,   403,   404,   405,   406,
    1408,  1409,   407,     0,   408,     0,   409,     0,   410,   411,
     412,     0,     0,     0,   413,  1135,   415,   416,     0,   417,
     418,     0,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,   424,   425,  1410,     0,   426,     0,   427,     0,
       0,     0,   428,     0,   429,     0,     0,   430,     0,   431,
     432,     0,   433,   434,   435,     0,   436,   437,   438,   439,
       0,     0,     0,     0,   440,   441,   442,  1140,  1411,     0,
    1412,     0,     0,     0,     0,   443,     0,   444,   445,   446,
     447,   448,     0,     0,   449,     0,     0,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
    1413,     0,  1414,     0,   463,   464,   465,   466,  1791,     0,
     467,   468,     0,   469,     0,     0,  1415,   470,   471,     0,
       0,   472,     0,     0,     0,   473,   474,     0,     0,     0,
       0,     0,     0,   475,   476,   477,     0,     0,     0,   478,
     479,     0,   480,   481,   482,   483,   484,   485,  1416,   486,
       0,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   497,     0,   498,     0,   499,   500,   501,   502,   503,
     504,     0,     0,   505,   506,   507,     0,   508,  1417,   509,
     510,     0,   511,  1418,     0,   512,   513,   514,   515,   516,
     517,   518,   519,     0,   520,     0,   521,   522,   523,   524,
       0,  1419,  1420,     0,   526,     0,   527,     0,   528,     0,
       0,   529,   530,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,     0,     0,   539,   540,   541,  1421,   542,
       0,   543,     0,     0,     0,   544,   545,   546,   547,   548,
     549,     0,   223,     0,     0,   224,   584,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     585,    99,   100,   101,   358,   586,     0,   103,   104,   105,
     106,   587,   588,     0,   108,   109,   110,     0,   111,   589,
     590,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     380,   381,   382,     0,  1404,     0,  1405,  1122,     0,   383,
     384,     0,   385,     0,     0,   386,  1406,  1407,   388,     0,
     389,   390,   391,   392,     0,     0,     0,   393,   394,   395,
       0,   396,   397,     0,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,  1408,
    1409,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,  1135,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,   424,   425,  1410,     0,   426,     0,   427,     0,     0,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
       0,     0,     0,   440,   441,   442,  1140,  1411,     0,  1412,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,  1413,
       0,  1414,     0,   463,   464,   465,   466,  2509,     0,   467,
     468,     0,   469,     0,     0,  1415,   470,   471,     0,     0,
     472,     0,     0,     0,   473,   474,     0,     0,     0,     0,
       0,     0,   475,   476,   477,     0,     0,     0,   478,   479,
       0,   480,   481,   482,   483,   484,   485,  1416,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,     0,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,     0,   508,  1417,   509,   510,
       0,   511,  1418,     0,   512,   513,   514,   515,   516,   517,
     518,   519,     0,   520,     0,   521,   522,   523,   524,     0,
    1419,  1420,     0,   526,     0,   527,     0,   528,     0,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,     0,   539,   540,   541,  1421,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,   584,    79,    80,    81,   355,
       0,    83,    84,     0,    85,    86,    87,   356,     0,   357,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   585,
      99,   100,   101,   358,   586,     0,   103,   104,   105,   106,
     587,   588,     0,   108,   109,   110,     0,   111,   589,   590,
     114,   359,   360,     0,     0,     0,   361,   362,     0,     0,
       0,     0,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,     0,   365,     0,   366,   367,     0,   368,   369,
     370,   371,   372,   373,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,   378,   379,     0,   380,
     381,   382,     0,  1404,     0,  1405,  1122,     0,   383,   384,
       0,   385,     0,     0,   386,  1406,  1407,   388,     0,   389,
     390,   391,   392,     0,     0,     0,   393,   394,   395,     0,
     396,   397,     0,   398,     0,   399,   400,     0,   401,     0,
       0,     0,     0,   402,   403,   404,   405,   406,  1408,  1409,
     407,     0,   408,     0,   409,     0,   410,   411,   412,     0,
       0,     0,   413,  1135,   415,   416,     0,   417,   418,     0,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
     424,   425,  1410,     0,   426,     0,   427,     0,     0,     0,
     428,     0,   429,     0,     0,   430,     0,   431,   432,     0,
     433,   434,   435,     0,   436,   437,   438,   439,     0,     0,
       0,     0,   440,   441,   442,  1140,  1411,     0,  1412,     0,
       0,     0,     0,   443,     0,   444,   445,   446,   447,   448,
       0,     0,   449,     0,     0,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,  1413,     0,
    1414,     0,   463,   464,   465,   466,     0,     0,   467,   468,
       0,   469,     0,     0,  1415,   470,   471,     0,     0,   472,
       0,     0,     0,   473,   474,     0,     0,     0,     0,     0,
       0,   475,   476,   477,     0,     0,     0,   478,   479,     0,
     480,   481,   482,   483,   484,   485,  1416,   486,     0,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
       0,   498,     0,   499,   500,   501,   502,   503,   504,     0,
       0,   505,   506,   507,     0,   508,  1417,   509,   510,     0,
     511,  1418,     0,   512,   513,   514,   515,   516,   517,   518,
     519,     0,   520,     0,   521,   522,   523,   524,     0,  1419,
    1420,     0,   526,     0,   527,     0,   528,     0,     0,   529,
     530,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,     0,     0,   539,   540,   541,  1421,   542,     0,   543,
       0,     0,     0,   544,   545,   546,   547,   548,   549,     0,
     223,     0,     0,   224,   584,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   585,    99,
     100,   101,   358,   586,     0,   103,   104,   105,   106,   587,
     588,     0,   108,   109,   110,     0,   111,   589,   590,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,  1404,     0,  1405,  1122,     0,   383,   384,     0,
     385,     0,     0,   386,  1406,  1407,   388,     0,   389,   390,
     391,   392,     0,     0,     0,   393,   394,   395,     0,   396,
     397,     0,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,  1408,  1409,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,  1135,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,   424,
     425,  1410,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,     0,
       0,   440,   441,   442,  1140,  1411,     0,  1412,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,  1413,     0,  1414,
       0,   463,   464,   465,   466,     0,     0,   467,   468,     0,
     469,     0,     0,  1415,   470,   471,     0,     0,   472,     0,
       0,     0,   473,   474,     0,     0,     0,     0,     0,     0,
     475,   476,   477,     0,     0,     0,   478,   479,     0,   480,
     481,   482,   483,   484,   485,  1416,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,     0,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,     0,   509,   510,     0,   511,
    1418,     0,   512,   513,   514,   515,   516,   517,   518,   519,
       0,   520,     0,   521,   522,   523,   524,     0,  1419,  1420,
       0,   526,     0,   527,     0,   528,     0,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,  1421,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     358,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   359,   360,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   368,   369,   370,   371,   372,
     373,   374,   591,   375,   376,   592,   593,   594,   595,   596,
     597,   598,   377,   378,   379,   129,   380,   381,   382,   131,
     132,   133,   134,     0,   599,   383,   384,     0,   385,   600,
     601,   386,     0,   135,   388,   603,   389,   390,   391,   392,
     139,   604,   605,   393,   394,   395,   606,   396,   397,   142,
     398,   607,   399,   400,   145,   401,   608,   609,   610,   611,
     402,   403,   404,     0,   406,   148,   149,   407,   612,   408,
     613,   409,     0,   410,   411,   412,   614,   615,   616,   413,
     414,   415,   416,   617,   417,   418,   618,   419,   619,   420,
     421,   422,   155,   423,     0,   157,   620,   424,   425,   159,
     621,   426,   622,   427,   160,   623,   161,   428,     0,   429,
     624,   625,   430,   626,   431,     0,   164,   433,   434,   435,
     627,   436,   437,   438,   439,   628,   165,   166,     0,   440,
     441,   442,     0,   168,   631,   169,   632,     0,   170,   171,
     443,   172,   444,   445,   446,   447,   448,   633,   173,   449,
     174,   634,   450,   451,   452,   453,   454,   455,   456,     0,
     458,   459,     0,   461,   462,   179,   180,   181,   635,   463,
     464,   465,   466,   182,   636,   467,   468,   184,   469,   637,
     185,   186,   470,   471,   638,   639,   472,   640,   641,   642,
     473,   474,   643,   644,   187,   188,   189,   190,   475,   476,
     477,     0,   191,   192,   478,   479,   645,   480,   481,   482,
     483,   484,   485,   194,   486,   646,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,   199,   498,   201,
     499,   500,   501,   502,   503,     0,     0,   647,   505,   506,
     507,   648,   508,   205,   509,   510,   207,   511,   208,   649,
     512,   513,   514,   515,   516,   517,   518,   519,   210,   520,
     650,   521,   522,   523,   524,   651,   211,   212,     0,   526,
     653,   527,   213,   528,   214,   654,   529,   530,   531,   532,
     533,     0,   656,   534,   535,   536,   537,   538,   657,   658,
     539,   540,   541,   221,   542,   222,   543,     0,   659,   660,
     544,   545,   546,   547,     0,   549,     0,   223,     0,     0,
     224,    79,    80,    81,   355,     0,    83,    84,     0,    85,
      86,    87,   356,     0,   357,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   358,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   359,   360,     0,     0,
       0,   361,   362,     0,     0,     0,     0,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,     0,   365,     0,
     366,   367,     0,   368,   369,   370,   371,   372,   373,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,   378,   379,   129,   380,   381,   382,   131,   132,   133,
     134,     0,     0,   383,   384,     0,   385,     0,     0,   386,
     387,   135,   388,     0,   389,   390,   391,   392,   139,     0,
       0,   393,   394,   395,     0,   396,   397,   142,   398,     0,
     399,   400,   145,   401,     0,     0,     0,     0,   402,   403,
     404,   405,   406,   148,   149,   407,     0,   408,     0,   409,
       0,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,     0,   417,   418,     0,   419,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   424,   425,   159,     0,   426,
       0,   427,   160,     0,   161,   428,     0,   429,     0,     0,
     430,     0,   431,   432,   164,   433,   434,   435,     0,   436,
     437,   438,   439,     0,   165,   166,     0,   440,   441,   442,
       0,   168,     0,   169,     0,     0,   170,   171,   443,   172,
     444,   445,   446,   447,   448,     0,   173,   449,   174,     0,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   179,   180,   181,   709,   463,   464,   465,
     466,   182,     0,   467,   468,   184,   469,     0,   185,   186,
     470,   471,     0,     0,   472,   710,     0,     0,   473,   474,
       0,     0,   187,   188,   189,   190,   475,   476,   477,     0,
     191,   192,   478,   479,     0,   480,   481,   482,   483,   484,
     485,   194,   486,     0,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,   199,   498,   201,   499,   500,
     501,   502,   503,   504,     0,     0,   505,   506,   507,     0,
     508,   205,   509,   510,   207,   511,   208,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   210,   520,     0,   521,
     522,   523,   524,     0,   211,   212,     0,   526,     0,   527,
     213,   528,   214,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,     0,     0,   539,   540,
     541,   221,   542,   222,   543,     0,     0,     0,   544,   545,
     546,   547,   548,   549,     0,   223,     0,     0,   224,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   358,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,   378,
     379,     0,   380,   381,   382,     0,   132,     0,   134,     0,
       0,   383,   384,     0,   385,     0,     0,   386,   387,   135,
     388,  1760,   389,   390,   391,   392,   139,     0,     0,   393,
     394,   395,  1761,   396,   397,   142,   398,     0,   399,   400,
       0,   401,     0,     0,     0,     0,   402,   403,   404,   405,
     406,   148,   149,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   424,   425,   159,     0,   426,  1762,   427,
       0,     0,     0,   428,     0,   429,     0,     0,   430,     0,
     431,   432,     0,   433,   434,   435,     0,   436,   437,   438,
     439,     0,     0,   166,     0,   440,   441,   442,     0,   168,
       0,   169,     0,     0,     0,     0,   443,     0,   444,   445,
     446,   447,   448,     0,     0,   449,  2271,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   179,     0,   181,     0,   463,   464,   465,   466,   182,
       0,   467,   468,     0,   469,     0,   185,   186,   470,   471,
       0,     0,   472,     0,     0,     0,   473,   474,     0,     0,
     187,     0,     0,   190,   475,   476,   477,     0,   191,   192,
     478,   479,  1763,   480,   481,   482,   483,   484,   485,   194,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,     0,   498,   201,   499,   500,   501,   502,
     503,   504,     0,     0,   505,   506,   507,     0,   508,   205,
     509,   510,     0,   511,   208,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   210,   520,     0,   521,   522,   523,
     524,     0,   211,   212,     0,   526,     0,   527,   213,   528,
     214,     0,   529,   530,   531,   532,   533,     0,  1764,   534,
     535,   536,   537,   538,     0,     0,   539,   540,   541,   221,
     542,     0,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   358,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,     0,   375,   376,   126,
     127,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     380,   381,   382,     0,   132,     0,   134,     0,     0,   383,
     384,     0,   385,     0,     0,   386,   387,   135,   388,     0,
     389,   390,   391,   392,   139,     0,     0,   393,   394,   395,
       0,   396,   397,   142,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,   148,
     149,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,   414,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   424,   425,   159,     0,   426,     0,   427,     0,     0,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
       0,   166,     0,   440,   441,   442,     0,   168,     0,   169,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   179,
       0,   181,   709,   463,   464,   465,   466,   182,     0,   467,
     468,     0,   469,     0,   185,   186,   470,   471,     0,     0,
     472,   710,     0,     0,   473,   474,     0,     0,   187,     0,
       0,   190,   475,   476,   477,     0,   191,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,   194,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,   201,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,     0,   508,   205,   509,   510,
       0,   511,   208,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   210,   520,     0,   521,   522,   523,   524,     0,
     211,   212,     0,   526,     0,   527,   213,   528,   214,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,     0,   539,   540,   541,   221,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
     709,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,   710,
       0,   871,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   211,   212,
       0,   526,     0,   527,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     358,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   359,   360,
       0,     0,     0,   361,   362,     0,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
     365,     0,   366,   367,     0,   368,   369,   370,   371,   372,
     373,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,   378,   379,     0,   380,   381,   382,     0,
     132,     0,   134,     0,     0,   383,   384,     0,   385,     0,
       0,   386,   387,   135,   388,     0,   389,   390,   391,   392,
     139,     0,     0,   393,   394,   395,     0,   396,   397,   142,
     398,     0,   399,   400,     0,   401,     0,     0,     0,     0,
     402,   403,  1508,   405,   406,   148,   149,   407,     0,   408,
       0,   409,     0,   410,   411,   412,     0,     0,     0,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   424,   425,   159,
       0,   426,     0,   427,     0,     0,     0,  1509,     0,   429,
       0,     0,   430,     0,   431,   432,     0,   433,   434,   435,
       0,   436,   437,   438,   439,     0,     0,   166,     0,   440,
     441,   442,     0,   168,     0,   169,     0,     0,     0,     0,
     443,     0,   444,   445,  1510,   447,   448,     0,     0,   449,
       0,     0,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   179,     0,   181,   709,   463,
     464,   465,   466,   182,     0,   467,   468,     0,   469,     0,
     185,   186,   470,   471,     0,     0,   472,   710,     0,     0,
     473,   474,     0,     0,   187,     0,     0,   190,   475,   476,
     477,     0,   191,   192,   478,   479,     0,   480,   481,   482,
     483,   484,   485,   194,   486,     0,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,     0,   498,   201,
     499,   500,   501,  1511,   503,   504,     0,     0,   505,   506,
     507,     0,   508,   205,   509,   510,     0,   511,   208,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   210,   520,
    1512,  1513,   522,   523,   524,     0,   211,   212,     0,   526,
       0,   527,   213,   528,   214,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,     0,     0,
     539,   540,   541,   221,   542,     0,   543,     0,     0,     0,
     544,   545,   546,   547,   548,   549,     0,   223,     0,     0,
     224,    79,    80,    81,   355,     0,    83,    84,     0,    85,
      86,    87,   356,     0,   357,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   358,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   359,   360,     0,     0,
       0,   361,   362,     0,     0,     0,     0,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,     0,   365,     0,
     366,   367,     0,   368,   369,   370,   371,   372,   373,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,   378,   379,     0,   380,   381,   382,     0,   132,     0,
     134,     0,     0,   383,   384,     0,   385,     0,     0,   386,
     387,   135,   388,     0,   389,   390,   391,   392,   139,     0,
       0,   393,   394,   395,     0,   396,   397,   142,   398,     0,
     399,   400,     0,   401,     0,     0,     0,     0,   402,   403,
     404,   405,   406,   148,   149,   407,     0,   408,     0,   409,
       0,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,     0,   417,   418,     0,   419,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   424,   425,   159,     0,   426,
       0,   427,     0,     0,     0,   428,     0,   429,     0,     0,
     430,     0,   431,   432,     0,   433,   434,   435,     0,   436,
     437,   438,   439,     0,     0,   166,     0,   440,   441,   442,
       0,   168,     0,   169,     0,     0,     0,     0,   443,     0,
     444,   445,   446,   447,   448,     0,     0,   449,     0,     0,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   179,     0,   181,   709,   463,   464,   465,
     466,   182,     0,   467,   468,     0,   469,     0,   185,   186,
     470,   471,     0,     0,   472,   710,     0,     0,   473,   474,
       0,     0,   187,     0,     0,   190,   475,   476,   477,     0,
     191,   192,   478,   479,     0,   480,   481,   482,   483,   484,
     485,   194,   486,     0,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,     0,   498,   201,   499,   500,
     501,   502,   503,   504,     0,     0,   505,   506,   507,     0,
     508,   205,   509,   510,     0,   511,   208,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   210,   520,     0,   521,
     522,   523,   524,     0,   211,   212,     0,   526,     0,   527,
     213,   528,   214,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,     0,     0,   539,   540,
     541,   221,   542,     0,   543,     0,     0,     0,   544,   545,
     546,   547,   548,   549,     0,   223,     0,     0,   224,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   358,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,   378,
     379,     0,   380,   381,   382,     0,   132,     0,   134,     0,
       0,   383,   384,     0,   385,     0,     0,   386,   387,   135,
     388,     0,   389,   390,   391,   392,   139,     0,     0,   393,
     394,   395,     0,   396,   397,   142,   398,     0,   399,   400,
       0,   401,     0,     0,     0,     0,   402,   403,   404,   405,
     406,   148,   149,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   424,   425,   159,     0,   426,     0,   427,
       0,   787,     0,   428,     0,   429,     0,     0,   430,     0,
     431,   432,     0,   433,   434,   435,   788,   436,   437,   438,
     439,     0,     0,   166,     0,   440,   441,   442,     0,   168,
       0,   169,     0,     0,     0,     0,   443,     0,   444,   445,
     446,   447,   448,     0,     0,   449,     0,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   179,     0,   181,     0,   463,   464,   465,   466,   182,
       0,   467,   468,     0,   469,     0,   185,   186,   470,   471,
       0,     0,   472,     0,     0,     0,   473,   474,     0,     0,
     187,     0,     0,   190,   475,   476,   477,     0,   191,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,   194,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,     0,   498,   201,   499,   500,   501,   502,
     503,   504,     0,     0,   505,   506,   507,     0,   508,   205,
     509,   510,     0,   511,   208,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   210,   520,     0,   521,   522,   523,
     524,     0,   211,   212,     0,   526,     0,   527,   213,   528,
     214,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,     0,     0,   539,   540,   541,   221,
     542,     0,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   358,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,   836,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     380,   381,   382,     0,   132,     0,   134,     0,     0,   383,
     384,     0,   385,     0,     0,   386,   387,   135,   388,     0,
     389,   390,   391,   392,   139,     0,     0,   393,   394,   395,
       0,   396,   397,   142,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,   148,
     149,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,   414,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   424,   425,   159,     0,   426,     0,   427,     0,     0,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
       0,   166,     0,   440,   441,   442,     0,   168,     0,   169,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   179,
       0,   181,     0,   463,   464,   465,   466,   182,     0,   467,
     468,     0,   469,     0,   185,   186,   470,   471,     0,     0,
     472,     0,     0,     0,   473,   474,     0,     0,   187,     0,
       0,   190,   475,   476,   477,     0,   191,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,   194,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,   201,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   837,     0,   508,   205,   509,   510,
       0,   511,   208,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   210,   520,     0,   521,   522,   523,   524,     0,
     838,   212,     0,   526,     0,   839,   213,   528,   214,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,     0,   539,   540,   541,   221,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,   860,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
       0,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,     0,
       0,     0,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   861,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   862,   212,
       0,   526,     0,   863,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     358,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   359,   360,
       0,     0,     0,   361,   362,     0,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
     365,     0,   366,   367,     0,   368,   369,   370,   371,   372,
     373,   374,  1221,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,   378,   379,     0,   380,   381,   382,     0,
     132,     0,   134,     0,     0,   383,   384,     0,   385,     0,
       0,   386,   387,   135,   388,     0,   389,   390,   391,   392,
     139,     0,     0,   393,   394,   395,     0,   396,   397,   142,
     398,     0,   399,   400,     0,   401,     0,     0,     0,     0,
     402,   403,   404,   405,   406,   148,   149,   407,     0,   408,
       0,   409,     0,   410,   411,   412,     0,     0,     0,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   424,   425,   159,
       0,   426,     0,   427,     0,     0,     0,   428,     0,   429,
       0,     0,   430,     0,   431,   432,     0,   433,   434,   435,
       0,   436,   437,   438,   439,     0,     0,   166,     0,   440,
     441,   442,     0,   168,     0,   169,     0,     0,     0,     0,
     443,     0,   444,   445,   446,   447,   448,     0,     0,   449,
       0,     0,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   179,     0,   181,     0,   463,
     464,   465,   466,   182,     0,   467,   468,     0,   469,     0,
     185,   186,   470,   471,     0,     0,   472,     0,     0,     0,
     473,   474,     0,     0,   187,     0,     0,   190,   475,   476,
     477,     0,   191,   192,   478,   479,     0,   480,   481,   482,
     483,   484,   485,   194,   486,     0,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,     0,   498,   201,
     499,   500,   501,   502,   503,   504,     0,     0,   505,   506,
     507,     0,   508,   205,   509,   510,     0,   511,   208,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   210,   520,
       0,   521,   522,   523,   524,     0,   211,   212,     0,   526,
       0,   527,   213,   528,   214,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,     0,     0,
     539,   540,   541,   221,   542,     0,   543,     0,     0,     0,
     544,   545,   546,   547,   548,   549,     0,   223,     0,     0,
     224,    79,    80,    81,   355,     0,    83,    84,     0,    85,
      86,    87,   356,     0,   357,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   358,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   359,   360,     0,     0,
       0,   361,   362,     0,     0,     0,     0,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,     0,   365,     0,
     366,   367,     0,   368,   369,   370,   371,   372,   373,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,   378,   379,  1230,   380,   381,   382,     0,   132,     0,
     134,     0,     0,   383,   384,     0,   385,     0,     0,   386,
     387,   135,  1231,     0,   389,   390,   391,   392,   139,     0,
       0,   393,   394,   395,     0,   396,   397,   142,   398,     0,
     399,   400,     0,   401,     0,     0,     0,     0,   402,   403,
     404,   405,   406,   148,   149,   407,     0,   408,     0,   409,
       0,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,     0,   417,   418,     0,   419,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   424,   425,   159,     0,   426,
       0,   427,     0,     0,     0,   428,     0,   429,     0,     0,
     430,     0,   431,   432,     0,   433,   434,   435,     0,   436,
     437,   438,   439,     0,     0,   166,     0,   440,   441,   442,
       0,   168,     0,   169,     0,     0,     0,     0,   443,     0,
     444,   445,   446,   447,   448,     0,     0,   449,     0,     0,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   853,   179,     0,   181,     0,   463,   464,   465,
     466,   182,     0,   467,   468,     0,   469,     0,   185,   186,
     470,   471,     0,     0,   472,     0,     0,     0,   473,   474,
       0,     0,   187,     0,     0,   190,   475,   476,   477,     0,
     191,   192,   478,   479,     0,   480,   481,   482,   483,   484,
     485,   194,   486,     0,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,     0,   498,   201,   499,   500,
     501,   502,   503,   504,     0,     0,   505,   506,  1225,     0,
     508,   205,   509,   510,     0,   511,   208,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   210,   520,     0,   521,
     522,   523,   524,     0,   855,   212,     0,   526,     0,   856,
     213,   528,   214,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,     0,     0,   539,   540,
     541,   221,   542,     0,   543,     0,     0,     0,   544,   545,
     546,   547,   548,   549,     0,   223,     0,     0,   224,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   358,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,   378,
     379,     0,   380,   381,   382,     0,   132,     0,   134,     0,
       0,   383,   384,     0,   385,     0,     0,   386,   387,   135,
     388,     0,   389,   390,   391,   392,   139,     0,     0,   393,
     394,   395,     0,   396,   397,   142,   398,     0,   399,   400,
       0,   401,     0,     0,     0,     0,   402,   403,   404,   405,
     406,   148,   149,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   424,   425,   159,     0,   426,     0,   427,
       0,     0,     0,   428,     0,   429,     0,  2313,   430,     0,
     431,   432,     0,   433,   434,   435,     0,   436,   437,   438,
     439,     0,     0,   166,     0,   440,   441,   442,     0,   168,
       0,   169,     0,     0,     0,     0,   443,     0,   444,   445,
     446,   447,   448,     0,     0,   449,     0,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   179,     0,   181,     0,   463,   464,   465,   466,   182,
       0,   467,   468,     0,   469,     0,   185,   186,   470,   471,
       0,     0,   472,     0,     0,     0,   473,   474,     0,     0,
     187,     0,     0,   190,   475,   476,   477,     0,   191,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,   194,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,     0,   498,   201,   499,   500,   501,   502,
     503,   504,     0,     0,   505,   506,   507,     0,   508,   205,
     509,   510,     0,   511,   208,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   210,   520,     0,   521,   522,   523,
     524,     0,   211,   212,     0,   526,     0,   527,   213,   528,
     214,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,     0,     0,   539,   540,   541,   221,
     542,     0,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   358,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     380,   381,   382,     0,   132,     0,   134,     0,     0,   383,
     384,     0,   385,     0,     0,   386,   387,   135,   388,     0,
     389,   390,   391,   392,   139,     0,     0,   393,   394,   395,
       0,   396,   397,   142,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,   148,
     149,   407,  2567,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,   414,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   424,   425,   159,     0,   426,     0,   427,     0,     0,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
       0,   166,     0,   440,   441,   442,     0,   168,     0,   169,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   179,
       0,   181,     0,   463,   464,   465,   466,   182,     0,   467,
     468,     0,   469,     0,   185,   186,   470,   471,     0,     0,
     472,     0,     0,     0,   473,   474,     0,     0,   187,     0,
       0,   190,   475,   476,   477,     0,   191,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,   194,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,   201,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,     0,   508,   205,   509,   510,
       0,   511,   208,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   210,   520,     0,   521,   522,   523,   524,     0,
     211,   212,     0,   526,     0,   527,   213,   528,   214,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,     0,   539,   540,   541,   221,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
    2569,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
       0,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,     0,
       0,     0,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   211,   212,
       0,   526,     0,   527,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     358,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   359,   360,
       0,     0,     0,   361,   362,     0,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
     365,     0,   366,   367,     0,   368,   369,   370,   371,   372,
     373,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,   378,   379,     0,   380,   381,   382,     0,
     132,     0,   134,     0,     0,   383,   384,     0,   385,     0,
       0,   386,   387,   135,   388,     0,   389,   390,   391,   392,
     139,     0,     0,   393,   394,   395,     0,   396,   397,   142,
     398,     0,   399,   400,     0,   401,     0,     0,     0,     0,
     402,   403,   404,   405,   406,   148,   149,   407,  2571,   408,
       0,   409,     0,   410,   411,   412,     0,     0,     0,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   424,   425,   159,
       0,   426,     0,   427,     0,     0,     0,   428,     0,   429,
       0,     0,   430,     0,   431,   432,     0,   433,   434,   435,
       0,   436,   437,   438,   439,     0,     0,   166,     0,   440,
     441,   442,     0,   168,     0,   169,     0,     0,     0,     0,
     443,     0,   444,   445,   446,   447,   448,     0,     0,   449,
       0,     0,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   179,     0,   181,     0,   463,
     464,   465,   466,   182,     0,   467,   468,     0,   469,     0,
     185,   186,   470,   471,     0,     0,   472,     0,     0,     0,
     473,   474,     0,     0,   187,     0,     0,   190,   475,   476,
     477,     0,   191,   192,   478,   479,     0,   480,   481,   482,
     483,   484,   485,   194,   486,     0,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,     0,   498,   201,
     499,   500,   501,   502,   503,   504,     0,     0,   505,   506,
     507,     0,   508,   205,   509,   510,     0,   511,   208,     0,
     512,   513,   514,   515,   516,   517,   518,   519,   210,   520,
       0,   521,   522,   523,   524,     0,   211,   212,     0,   526,
       0,   527,   213,   528,   214,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,     0,     0,
     539,   540,   541,   221,   542,     0,   543,     0,     0,     0,
     544,   545,   546,   547,   548,   549,     0,   223,     0,     0,
     224,    79,    80,    81,   355,     0,    83,    84,     0,    85,
      86,    87,   356,     0,   357,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   358,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   359,   360,     0,     0,
       0,   361,   362,     0,     0,     0,     0,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,     0,   365,     0,
     366,   367,     0,   368,   369,   370,   371,   372,   373,   374,
       0,   375,   376,     0,     0,     0,     0,     0,  2702,     0,
     377,   378,   379,     0,   380,   381,   382,     0,   132,     0,
     134,     0,     0,   383,   384,     0,   385,     0,     0,   386,
     387,   135,   388,     0,   389,   390,   391,   392,   139,     0,
       0,   393,   394,   395,     0,   396,   397,   142,   398,     0,
     399,   400,     0,   401,     0,     0,     0,     0,   402,   403,
     404,   405,   406,   148,   149,   407,     0,   408,     0,   409,
       0,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,     0,   417,   418,     0,   419,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   424,   425,   159,     0,   426,
       0,   427,     0,     0,     0,   428,     0,   429,     0,     0,
     430,     0,   431,   432,     0,   433,   434,   435,     0,   436,
     437,   438,   439,     0,     0,   166,     0,   440,   441,   442,
       0,   168,     0,   169,     0,     0,     0,     0,   443,     0,
     444,   445,   446,   447,   448,     0,     0,   449,     0,     0,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   179,     0,   181,     0,   463,   464,   465,
     466,   182,     0,   467,   468,     0,   469,     0,   185,   186,
     470,   471,     0,     0,   472,     0,     0,     0,   473,   474,
       0,     0,   187,     0,     0,   190,   475,   476,   477,     0,
     191,   192,   478,   479,     0,   480,   481,   482,   483,   484,
     485,   194,   486,     0,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,     0,   498,   201,   499,   500,
     501,   502,   503,   504,     0,     0,   505,   506,   507,     0,
     508,   205,   509,   510,     0,   511,   208,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   210,   520,     0,   521,
     522,   523,   524,     0,   211,   212,     0,   526,     0,   527,
     213,   528,   214,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,     0,     0,   539,   540,
     541,   221,   542,     0,   543,     0,     0,     0,   544,   545,
     546,   547,   548,   549,     0,   223,     0,     0,   224,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   358,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,  2716,     0,   377,   378,
     379,     0,   380,   381,   382,     0,   132,     0,   134,     0,
       0,   383,   384,     0,   385,     0,     0,   386,   387,   135,
     388,     0,   389,   390,   391,   392,   139,     0,     0,   393,
     394,   395,     0,   396,   397,   142,   398,     0,   399,   400,
       0,   401,     0,     0,     0,     0,   402,   403,   404,   405,
     406,   148,   149,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   424,   425,   159,     0,   426,     0,   427,
       0,     0,     0,   428,     0,   429,     0,     0,   430,     0,
     431,   432,     0,   433,   434,   435,     0,   436,   437,   438,
     439,     0,     0,   166,     0,   440,   441,   442,     0,   168,
       0,   169,     0,     0,     0,     0,   443,     0,   444,   445,
     446,   447,   448,     0,     0,   449,     0,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   179,     0,   181,     0,   463,   464,   465,   466,   182,
       0,   467,   468,     0,   469,     0,   185,   186,   470,   471,
       0,     0,   472,     0,     0,     0,   473,   474,     0,     0,
     187,     0,     0,   190,   475,   476,   477,     0,   191,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,   194,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,     0,   498,   201,   499,   500,   501,   502,
     503,   504,     0,     0,   505,   506,   507,     0,   508,   205,
     509,   510,     0,   511,   208,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   210,   520,     0,   521,   522,   523,
     524,     0,   211,   212,     0,   526,     0,   527,   213,   528,
     214,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,     0,     0,   539,   540,   541,   221,
     542,     0,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,    79,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   358,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     380,   381,   382,     0,   132,     0,   134,     0,     0,   383,
     384,     0,   385,     0,     0,   386,   387,   135,   388,     0,
     389,   390,   391,   392,   139,     0,     0,   393,   394,   395,
       0,   396,   397,   142,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,   148,
     149,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,   414,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   424,   425,   159,     0,   426,     0,   427,     0,     0,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
       0,   166,     0,   440,   441,   442,     0,   168,     0,   169,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   179,
       0,   181,     0,   463,   464,   465,   466,   182,     0,   467,
     468,     0,   469,     0,   185,   186,   470,   471,     0,     0,
     472,     0,     0,     0,   473,   474,     0,     0,   187,     0,
       0,   190,   475,   476,   477,     0,   191,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,   194,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,   201,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,     0,   508,   205,   509,   510,
       0,   511,   208,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   210,   520,     0,   521,   522,   523,   524,     0,
     211,   212,     0,   526,     0,   527,   213,   528,   214,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,  3036,   539,   540,   541,   221,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
       0,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,     0,
       0,     0,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,   501,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   211,   212,
       0,   526,     0,   527,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,    79,    80,    81,   355,     0,    83,    84,
       0,    85,    86,    87,   356,     0,   357,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     358,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   359,   360,
       0,     0,     0,   361,   362,     0,     0,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
     365,     0,   366,   367,     0,   368,   369,   370,   371,   372,
     373,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,   378,   379,     0,   380,   381,   382,     0,
     132,     0,   134,     0,     0,   383,   384,     0,   385,     0,
       0,   386,   387,   135,   388,     0,   389,   390,   391,   392,
     139,     0,     0,   393,   394,   395,     0,   396,   397,   142,
     398,     0,   399,   400,     0,   401,     0,     0,     0,     0,
     402,   403,   404,   405,   406,   148,   149,   407,     0,   408,
       0,   409,     0,   410,   411,   412,     0,     0,     0,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   155,   423,     0,   157,     0,   424,   425,   159,
       0,   426,     0,   427,     0,     0,     0,   428,     0,   429,
       0,     0,   430,     0,   431,   432,     0,   433,   434,   435,
       0,   436,   437,   438,   439,     0,     0,   166,     0,   440,
     441,   442,     0,   168,     0,   169,     0,     0,     0,     0,
     443,     0,   444,   445,   446,   447,   448,     0,     0,   449,
       0,     0,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   179,     0,   181,     0,   463,
     464,   465,   466,   182,     0,   467,   468,     0,   469,     0,
     185,   186,   470,   471,     0,     0,   472,     0,     0,     0,
     473,   474,     0,     0,   187,     0,     0,   190,   475,   476,
     477,     0,   191,   192,   478,   479,     0,   480,   481,   482,
     483,   484,   485,   194,   486,     0,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,     0,   498,   201,
     499,   500,   501,   502,   503,   504,     0,     0,   505,   506,
     507,     0,   508,   205,   509,   510,     0,   511,   208,     0,
     512,   513,   752,   515,   516,   517,   518,   519,   210,   520,
       0,   521,   522,   523,   524,     0,   211,   212,     0,   526,
       0,   527,   213,   528,   214,     0,   529,   530,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,     0,     0,
     539,   540,   541,   221,   542,     0,   543,     0,     0,     0,
     544,   545,   546,   547,   548,   549,     0,   223,     0,     0,
     224,    79,    80,    81,   355,     0,    83,    84,     0,    85,
      86,    87,   356,     0,   357,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   358,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   359,   360,     0,     0,
       0,   361,   362,     0,     0,     0,     0,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,     0,   365,     0,
     366,   367,     0,   368,   369,   370,   371,   372,   373,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,   378,   379,     0,   380,   381,   382,     0,   132,     0,
     134,     0,     0,   383,   384,     0,   385,     0,     0,   386,
     387,   135,   388,     0,   389,   390,   391,   392,   139,     0,
       0,   393,   394,   395,     0,   396,   397,   142,   398,     0,
     399,   400,     0,   401,     0,     0,     0,     0,   402,   403,
     404,   405,   406,   148,   149,   407,     0,   408,     0,   409,
       0,   410,   411,   412,     0,     0,     0,   413,   414,   415,
     416,     0,   417,   418,     0,   419,     0,   420,   421,   422,
     155,   423,     0,   157,     0,   424,   425,   159,     0,   426,
       0,   427,     0,     0,     0,   428,     0,   429,     0,     0,
     430,     0,   431,   432,     0,   433,   434,   435,     0,   436,
     437,   438,   439,     0,     0,   166,     0,   440,   441,   442,
       0,   168,     0,   169,     0,     0,     0,     0,   443,     0,
     444,   445,   446,   447,   448,     0,     0,   449,     0,     0,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   179,     0,   181,     0,   463,   464,   465,
     466,   182,     0,   467,   468,     0,   469,     0,   185,   186,
     470,   471,     0,     0,   472,     0,     0,     0,   473,   474,
       0,     0,   187,     0,     0,   190,   475,   476,   477,     0,
     191,   192,   478,   479,     0,   480,   481,   482,   483,   484,
     485,   194,   486,     0,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,     0,   498,   201,   499,   500,
     834,   502,   503,   504,     0,     0,   505,   506,   507,     0,
     508,   205,   509,   510,     0,   511,   208,     0,   512,   513,
     514,   515,   516,   517,   518,   519,   210,   520,     0,   521,
     522,   523,   524,     0,   211,   212,     0,   526,     0,   527,
     213,   528,   214,     0,   529,   530,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,     0,     0,   539,   540,
     541,   221,   542,     0,   543,     0,     0,     0,   544,   545,
     546,   547,   548,   549,     0,   223,     0,     0,   224,    79,
      80,    81,   355,     0,    83,    84,     0,    85,    86,    87,
     356,     0,   357,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   358,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   359,   360,     0,     0,     0,   361,
     362,     0,     0,     0,     0,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   365,     0,   366,   367,
       0,   368,   369,   370,   371,   372,   373,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,   378,
     379,     0,   380,   381,   382,     0,   132,     0,   134,     0,
       0,   383,   384,     0,   385,     0,     0,   386,   387,   135,
     388,     0,   389,   390,   391,   392,   139,     0,     0,   393,
     394,   395,     0,   396,   397,   142,   398,     0,   399,   400,
       0,   401,     0,     0,     0,     0,   402,   403,   404,   405,
     406,   148,   149,   407,     0,   408,     0,   409,     0,   410,
     411,   412,     0,     0,     0,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   155,   423,
       0,   157,     0,   424,   425,   159,     0,   426,     0,   427,
       0,     0,     0,   428,     0,   429,     0,     0,   430,     0,
     431,   432,     0,   433,   434,   435,     0,   436,   437,   438,
     439,     0,     0,   166,     0,   440,   441,   442,     0,   168,
       0,   169,     0,     0,     0,     0,   443,     0,   444,   445,
     446,   447,   448,     0,     0,   449,     0,     0,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     853,   179,     0,   181,     0,   463,   464,   465,   466,   182,
       0,   467,   468,     0,   469,     0,   185,   186,   470,   471,
       0,     0,   472,     0,     0,     0,   473,   474,     0,     0,
     187,     0,     0,   190,   475,   476,   477,     0,   191,   192,
     478,   479,     0,   480,   481,   482,   483,   484,   485,   194,
     486,     0,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,     0,   498,   201,   499,   500,   501,   502,
     503,   504,     0,     0,   505,   506,  1225,     0,   508,   205,
     509,   510,     0,   511,   208,     0,   512,   513,   514,   515,
     516,   517,   518,   519,   210,   520,     0,   521,   522,   523,
     524,     0,   855,   212,     0,   526,     0,   856,   213,   528,
     214,     0,   529,   530,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,     0,     0,   539,   540,   541,   221,
     542,     0,   543,     0,     0,     0,   544,   545,   546,   547,
     548,   549,     0,   223,     0,     0,   224,  1323,    80,    81,
     355,     0,    83,    84,     0,    85,    86,    87,   356,     0,
     357,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   358,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   359,   360,     0,     0,     0,   361,   362,     0,
       0,     0,     0,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,   365,     0,   366,   367,     0,   368,
     369,   370,   371,   372,   373,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,   378,   379,     0,
     380,   381,   382,     0,   132,     0,   134,     0,     0,   383,
     384,     0,   385,     0,     0,   386,   387,   135,   388,     0,
     389,   390,   391,   392,   139,     0,     0,   393,   394,   395,
       0,   396,   397,   142,   398,     0,   399,   400,     0,   401,
       0,     0,     0,     0,   402,   403,   404,   405,   406,   148,
     149,   407,     0,   408,     0,   409,     0,   410,   411,   412,
       0,     0,     0,   413,   414,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,   155,   423,     0,   157,
       0,   424,   425,   159,     0,   426,     0,   427,     0,     0,
       0,   428,     0,   429,     0,     0,   430,     0,   431,   432,
       0,   433,   434,   435,     0,   436,   437,   438,   439,     0,
       0,   166,     0,   440,   441,   442,     0,   168,     0,   169,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,   449,     0,     0,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   179,
       0,   181,     0,   463,   464,   465,   466,   182,     0,   467,
     468,     0,   469,     0,   185,   186,   470,   471,     0,     0,
     472,     0,     0,     0,   473,   474,     0,     0,   187,     0,
       0,   190,   475,   476,   477,     0,   191,   192,   478,   479,
       0,   480,   481,   482,   483,   484,   485,   194,   486,     0,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,     0,   498,   201,   499,   500,   501,   502,   503,   504,
       0,     0,   505,   506,   507,     0,   508,   205,   509,   510,
       0,   511,   208,     0,   512,   513,   514,   515,   516,   517,
     518,   519,   210,   520,     0,   521,   522,   523,   524,     0,
     211,   212,     0,   526,     0,   527,   213,   528,   214,     0,
     529,   530,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,     0,     0,   539,   540,   541,   221,   542,     0,
     543,     0,     0,     0,   544,   545,   546,   547,   548,   549,
       0,   223,     0,     0,   224,    79,    80,    81,   355,     0,
      83,    84,     0,    85,    86,    87,   356,     0,   357,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   358,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     359,   360,     0,     0,     0,   361,   362,     0,     0,     0,
       0,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,     0,   365,     0,   366,   367,     0,   368,   369,   370,
     371,   372,   373,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,   378,   379,     0,   380,   381,
     382,     0,   132,     0,   134,     0,     0,   383,   384,     0,
     385,     0,     0,   386,   387,   135,   388,     0,   389,   390,
     391,   392,   139,     0,     0,   393,   394,   395,     0,   396,
     397,   142,   398,     0,   399,   400,     0,   401,     0,     0,
       0,     0,   402,   403,   404,   405,   406,   148,   149,   407,
       0,   408,     0,   409,     0,   410,   411,   412,     0,     0,
       0,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   155,   423,     0,   157,     0,   424,
     425,   159,     0,   426,     0,   427,     0,     0,     0,   428,
       0,   429,     0,     0,   430,     0,   431,   432,     0,   433,
     434,   435,     0,   436,   437,   438,   439,     0,     0,   166,
       0,   440,   441,   442,     0,   168,     0,   169,     0,     0,
       0,     0,   443,     0,   444,   445,   446,   447,   448,     0,
       0,   449,     0,     0,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   179,     0,   181,
       0,   463,   464,   465,   466,   182,     0,   467,   468,     0,
     469,     0,   185,   186,   470,   471,     0,     0,   472,     0,
       0,     0,   473,   474,     0,     0,   187,     0,     0,   190,
     475,   476,   477,     0,   191,   192,   478,   479,     0,   480,
     481,   482,   483,   484,   485,   194,   486,     0,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   497,     0,
     498,   201,   499,   500,  1533,   502,   503,   504,     0,     0,
     505,   506,   507,     0,   508,   205,   509,   510,     0,   511,
     208,     0,   512,   513,   514,   515,   516,   517,   518,   519,
     210,   520,     0,   521,   522,   523,   524,     0,   211,   212,
       0,   526,     0,   527,   213,   528,   214,     0,   529,   530,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
       0,     0,   539,   540,   541,   221,   542,     0,   543,     0,
       0,     0,   544,   545,   546,   547,   548,   549,     0,   223,
       0,     0,   224,    79,    80,    81,     0,     0,    83,    84,
       0,    85,    86,    87,     0,     0,     0,    90,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
       0,     0,     0,   103,   104,   105,   106,     0,   107,     0,
     108,   109,   110,     0,   111,   112,   113,   114,     0,     0,
       0,     0,     0,   117,   118,     0,     0,     0,     0,   119,
       0,     0,     0,     0,     0,     0,     0,     0,   120,     0,
     121,     0,   122,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   129,     0,     0,     0,   131,
     132,   133,   134,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   135,     0,     0,     0,     0,     0,     0,
     139,     0,     0,     0,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,   145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   148,   149,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,     0,     0,   157,     0,     0,     0,   159,
       0,     0,     0,     0,   160,     0,   161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   165,   166,     0,     0,
       0,     0,     0,   168,     0,   169,     0,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,     0,   173,     0,
     174,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,     0,     0,   182,     0,     0,     0,   184,     0,     0,
     185,   186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   187,   188,   189,   190,     0,     0,
       0,     0,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   199,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,   207,     0,   208,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,     0,     0,     0,     0,     0,   211,   212,     0,     0,
       0,     0,   213,     0,   214,     0,     0,     0,     0,     0,
       0,   217,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   221,     0,   222,     0,     0,     0,     0,
       0,     0,     0,    79,    80,    81,     0,   223,    83,    84,
     224,    85,    86,    87,     0,     0,     0,    90,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
       0,     0,     0,   103,   104,   105,   106,     0,   107,     0,
     108,   109,   110,     0,   111,   112,   113,   114,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   129,     0,     0,     0,   131,
     132,   133,   134,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   135,     0,     0,     0,     0,     0,     0,
     139,     0,     0,     0,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,   145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   148,   149,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,     0,     0,   157,     0,     0,     0,   159,
       0,     0,     0,     0,   160,     0,   161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   165,   166,     0,     0,
       0,     0,     0,   168,     0,   169,     0,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,     0,   173,     0,
     174,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,     0,     0,   182,     0,     0,     0,   184,     0,     0,
     185,   186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   187,   188,   189,   190,     0,     0,
       0,     0,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   199,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,   207,     0,   208,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,     0,     0,     0,     0,     0,   211,   212,     0,     0,
       0,     0,   213,     0,   214,     0,     0,     0,     0,     0,
       0,   217,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   221,     0,   222,    79,    80,    81,     0,
       0,    83,    84,     0,    85,    86,    87,   223,     0,     0,
     224,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,     0,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
       0,     0,   131,   132,   133,   134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   135,     0,     0,     0,
       0,     0,     0,   139,     0,     0,     0,     0,     0,     0,
       0,     0,   142,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   148,   149,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,     0,     0,   157,     0,
       0,     0,   159,     0,     0,     0,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   165,
     166,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
       0,   173,     0,   174,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   179,   180,
     181,     0,     0,     0,     0,     0,   182,     0,     0,     0,
     184,     0,     0,   185,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
     190,     0,     0,     0,     0,   191,   192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     199,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,   207,
       0,   208,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,     0,     0,     0,     0,     0,   211,
     212,     0,     0,     0,     0,   213,     0,   214,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   221,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     223,     0,     0,   224
};

static const short yycheck[] =
{
       2,   154,   697,    74,   158,    74,   825,   851,  1045,  1070,
     225,   711,  1478,  1174,  1051,    77,    90,   962,   690,   689,
     692,  1006,  1460,   693,   178,  1433,  1309,   681,   856,    74,
    1644,   703,  1355,  1571,    90,   730,    74,  1435,   112,   128,
     193,    82,   943,   691,   692,   747,    90,    74,   147,   215,
     720,    90,  1476,  1158,   726,   154,   112,   146,  1482,    90,
       2,  1923,   219,   909,    74,  1603,   738,  1448,   112,   764,
      74,  2146,  1536,   112,   694,  1448,   724,  2080,  1448,  1448,
    1710,   112,  1448,  1448,   704,   755,  1803,  1804,   943,  2311,
    2430,   761,  2266,   781,   193,     2,  2435,  2436,  2101,   852,
     802,   854,  1782,  1783,   776,  1331,  2079,  1683,   728,   849,
    1085,   759,    25,  1085,  1779,  1745,   926,   927,  1851,  1749,
     740,  1474,    26,  1095,  1096,  1125,  1126,   918,    77,   943,
      42,   938,    93,   116,    85,   176,  2789,   111,   683,    92,
      77,   111,   762,   217,  1144,   134,    77,    50,   850,    92,
     116,   151,   150,   773,   225,   226,   158,   226,  1134,   661,
      97,   217,   116,    42,   158,    80,   151,  2383,   146,   104,
     128,   203,    77,   217,   150,    82,   178,   118,   217,   125,
     156,    74,    89,   151,    77,    85,   217,    74,   129,  2929,
    1598,   118,    97,  2741,   297,    85,   262,    90,   281,   226,
     188,    91,  1882,   223,   193,    85,  2955,   272,   143,    74,
      92,    91,    77,   219,   219,    82,   226,   153,    93,   112,
     198,   128,   226,  1195,  1374,    90,    77,   190,   156,   137,
    1860,   156,   156,    77,   122,   134,   188,   213,   154,   146,
    2788,   112,    85,   257,   185,    85,  1569,   112,   223,  1234,
      92,    91,  1197,   151,   219,   354,   281,   172,   185,   221,
     166,  3117,   962,   320,   242,   394,   311,   245,   219,   176,
     399,   391,    77,   311,   394,   295,    74,   212,     0,    77,
     294,   189,    77,   414,   200,   213,   348,   416,   213,   257,
     421,   351,    90,   151,   193,   415,    43,   164,    45,   146,
     325,   209,    97,  3159,   111,   151,   351,  1457,   980,   271,
     273,  1011,   415,   351,   112,  1420,   224,   160,   253,   219,
     295,   386,   219,   231,   217,   391,   262,  1022,   394,  3185,
    1391,   259,  1233,   307,   417,   320,  3085,   307,    82,   226,
     318,   249,   402,  1013,   320,   219,   217,    92,   289,  1019,
     219,   198,   217,   219,  2902,  1009,   354,  2219,   415,  1603,
      92,    29,   289,   351,   262,  2705,   372,   372,   336,  2709,
     221,   339,  1044,  2713,  1535,  1536,   339,    77,   372,  1955,
    1846,   269,   317,  2241,  1056,  1546,  1547,   385,  1058,   421,
     375,   391,   320,   369,   394,   242,  1381,   312,   245,   399,
    1072,   421,   310,  1464,   362,   351,  1406,  1407,  3061,   387,
    3150,  1572,   327,  1574,  1414,   960,   221,   348,   311,   217,
     164,  2496,  2497,   377,   365,   391,   221,   416,   394,   418,
     415,  2647,   415,  1409,   936,   302,   525,   391,   365,   415,
     394,   369,   332,   394,   369,   369,   311,   421,   399,   415,
    2026,   421,   332,   418,   415,   348,   407,  2430,   351,   372,
     413,   415,   411,  2001,  2002,  2003,  2096,   418,  2006,   421,
     413,   318,  1633,  1264,   411,   381,  2090,  1217,  1218,  1293,
    1290,   389,   394,   348,  2217,  2218,   351,   415,  1841,  2154,
     394,   394,   332,  2226,   394,  1286,   409,  1197,  1305,   399,
     307,  1925,  1926,   408,   409,   410,   411,   407,   383,   384,
     257,  2049,   391,   311,  1489,   394,  1488,   416,   418,   418,
     399,   221,   401,  2099,   421,  1497,   145,  2207,   407,  2868,
    1756,   413,  2872,   391,   416,   417,   394,  2877,   695,   421,
     387,  2881,   266,   700,   418,   391,  1392,   215,   394,   418,
     348,   156,   418,   351,    86,   406,   407,   408,   409,   410,
     411,  1249,  1562,  1563,   408,   409,   410,   411,   415,   266,
       8,   413,   418,   273,   416,   417,    14,    15,    16,   421,
      29,   325,  1335,   172,   146,    77,    34,   206,    26,    27,
      28,   268,    30,    31,    32,   748,   151,   754,    36,    37,
      38,   406,   407,   408,   409,   410,   411,   681,   213,   716,
    2240,   406,   407,   408,   409,   410,   411,   164,   525,   102,
    1373,   190,  2796,   153,   172,   681,   794,  1327,   782,   151,
     784,   156,   786,   337,   338,   742,   198,   681,   792,   793,
     685,   129,   681,   109,   153,  2985,   118,   685,   747,   748,
     681,   393,   394,   125,    77,   111,   198,   129,   826,   661,
    1355,    88,    89,   151,  1508,   156,  1510,  1511,   413,  1513,
     354,   416,   417,   164,   137,   295,   421,  1331,   144,   778,
     242,   413,   214,   245,   416,   417,  2094,   391,   213,   421,
     394,   415,   392,  1512,  2552,  2553,  2554,  2555,  2556,   208,
     242,   385,   257,   802,  2926,   155,   406,   407,   408,   409,
     410,   411,   342,   185,    18,   320,   199,    29,   415,   661,
     203,  1393,    77,  2147,   343,  1397,   189,   257,    40,   221,
     203,  2054,  2705,   258,   259,   257,  2709,   210,   327,   205,
    2713,   371,    97,  2605,   421,   314,   209,  1401,   257,   369,
     233,   850,   189,   281,   661,   171,   318,  2001,  2002,  2003,
    2158,   224,  2006,   211,   369,   171,   215,   183,   231,   257,
     220,  2195,  2196,   242,   302,   241,   318,   243,   325,   327,
     782,   273,   784,   167,   786,    12,   249,   253,   681,  2358,
     792,   793,   685,   867,   234,   320,   287,   253,   221,  2532,
    2533,   217,    77,   115,   277,  2049,   120,   320,   271,   271,
     379,   217,   853,  1485,   361,  2384,   681,   289,   234,  2536,
     685,   104,    97,    50,   118,   387,  2364,  1447,   268,  2367,
    2368,  2369,  2370,  2371,  2372,  2373,  2374,  2375,  2376,  1509,
     306,  1685,  2815,  1744,   369,   282,   329,   310,   286,   318,
     273,   307,   268,   415,   238,   160,   302,   151,  2019,   305,
     276,  1481,   375,   134,  2402,  2403,   221,   222,   334,   325,
     276,   203,  2336,  2297,  1569,  2299,  2300,  2038,   210,   325,
    2261,   188,  1728,   681,  1945,   926,   927,   685,  2261,  1744,
     415,  2261,  2261,   365,    18,  2261,  2261,   281,   154,  2872,
     392,   155,   415,   215,  2877,   260,   144,   909,  2881,   372,
     402,   403,   404,    77,   406,   407,   408,   409,   410,   411,
    2081,  2082,   193,   361,   416,   312,   389,  2557,  2882,   154,
    2884,    98,  1632,   935,   936,  1009,   938,   383,   104,   219,
     351,   943,   849,   416,   200,   277,   853,  1601,   364,   321,
     117,  1797,   257,  1009,  1800,  1801,   189,   183,   364,  1174,
     344,   266,   346,   257,   146,  1009,   220,   909,   262,   392,
    1009,   343,  3034,   160,   867,   200,   209,   143,  1009,   402,
     403,   404,   369,   406,   407,   408,   409,   410,   411,   383,
    3065,   224,   179,   935,   936,   289,   938,   343,   231,   183,
     416,   943,   867,   241,   298,   243,   417,    57,   234,  1108,
     242,   422,  2985,   245,   173,  1086,   198,  1086,  3080,   926,
     927,  2754,   193,  2756,  2757,    75,  3101,   421,   935,   936,
     377,   938,   104,  1104,  2988,  1104,   943,  2575,  1079,   203,
     312,  1743,   268,  3046,   391,   204,   212,   394,  1119,   189,
     234,   406,   407,   408,   409,   410,   411,   221,   321,  1086,
     242,   354,  3035,   335,    83,  1136,   138,   418,   415,   867,
     257,   365,   383,   384,  2936,   262,  1086,   310,   392,   266,
     343,   100,  1086,  3086,   268,   157,   318,   253,   402,   403,
     404,  1162,   406,   407,   408,   409,   410,   411,   170,  1337,
     416,    82,  1756,  1174,   415,   421,    87,   383,   384,   273,
    1758,  2725,   184,   281,   391,   391,  1009,   394,   394,   418,
    2364,  1359,   421,  2367,  2368,  2369,  2370,  2371,  2372,  2373,
    2374,  2375,  2376,  1753,   302,  1176,   318,  1757,   415,   415,
     972,   122,   378,     5,  1009,   402,  1187,  1301,  2686,   281,
    2558,   317,  1772,   134,   414,   419,   413,   325,    77,  2403,
     417,   421,  1782,  1783,  1784,  1785,   295,    29,    82,  1001,
     302,   358,  1079,    87,   303,  1795,  1848,  1849,    40,   366,
      46,   118,  2915,   164,  1255,  1256,   281,  1258,   418,  1230,
     262,  2615,   129,   322,  1268,   383,   384,   269,  1818,  1288,
    2483,  1821,  1822,   391,   281,  2603,   394,   302,   122,  2633,
     305,  1009,  1268,  1370,   151,   281,   153,   413,   418,   415,
     134,   417,   294,   120,  1268,   302,   188,   415,   392,   392,
     325,  1233,  1934,  1235,  2395,  1237,   302,   124,   402,   403,
     404,   203,   406,   407,   408,   409,   410,   411,   391,  1290,
     164,   394,  1326,   115,   141,   394,   410,  1331,   383,   384,
     399,   423,  1882,   417,  2092,   281,   153,  2111,  2676,  1176,
     419,   208,   415,   179,  1319,  1331,  2018,  1279,  2020,  2021,
    1187,  1319,   391,  2388,  2389,   394,   302,  1331,   281,   416,
     415,  1233,  1331,  1235,   421,  1237,   135,   136,   394,  1301,
    1331,   163,   221,  1305,  1519,   391,   415,  1309,   394,   302,
    1217,  1218,  2850,   200,  2852,  1131,  1132,   416,   372,   394,
     257,   302,   421,  1230,   399,   262,  1233,  1401,  1235,   415,
    1237,  2575,   407,  2234,   416,   416,  2182,  1279,  1154,   421,
     421,   151,  2188,  2189,   325,  1401,   416,  1163,   408,   409,
     410,   421,   289,   215,   273,   391,   262,  1401,   394,  2054,
     266,   298,  1401,  1305,   203,   391,    21,  1309,   394,   416,
    1401,   120,    77,   394,   421,  1268,  1269,  1270,   399,   415,
     401,  1288,  2820,  1290,   391,   215,   407,   394,   391,   415,
    1392,   394,    97,    39,  1548,   413,  1550,   102,  1305,   417,
    1554,   271,  1309,  1268,  1269,  1270,  1560,   391,   218,  2732,
     394,   325,   415,  1567,  2109,   254,   255,   125,   271,  1460,
     782,   129,   784,  1577,   786,  1579,  1319,   237,   365,   415,
     792,   415,    77,  1326,  2972,   267,   356,   390,  1331,   271,
     393,  1595,  2686,  1597,   283,    90,   391,   413,  1519,   394,
    1392,   417,   358,   391,  1319,   421,   394,   416,   304,     7,
     366,  1326,   421,    11,  3005,  3006,  1331,  3008,   292,  3010,
    1268,  1269,  1270,   392,   131,    23,    24,   415,   391,  2464,
    2128,   394,   415,   402,   403,   404,  2894,   406,   407,   408,
     409,   410,   411,  2438,   206,   392,    44,   416,   203,    47,
     219,   418,  1504,   342,   421,   402,   403,   404,  1401,   406,
     407,   408,   409,   410,   411,   416,   221,   222,  1559,   291,
     421,  1319,   391,   227,   416,   394,   416,  1601,  1326,   421,
     399,   421,   401,  1331,  1605,   374,  1401,   416,   407,  2234,
     420,   421,   421,  2163,   416,  1601,  1548,   391,  1550,   421,
     394,   416,  1554,  1460,    82,   260,   421,  1601,  1560,   188,
     391,    89,  1601,   394,    92,  1567,   416,   416,   273,   271,
    1601,   421,   421,   416,   102,  1577,   221,  1579,   421,  2233,
     390,   391,   391,   393,   394,   394,   345,  2207,   347,   399,
     399,   401,   401,  1595,   416,  1597,   416,   407,   407,   421,
     128,   421,   416,  1401,   115,   116,  2850,   421,  2852,   137,
     138,   416,   416,   161,   420,   421,   421,   421,   146,   147,
    1661,   421,   150,   345,   416,   347,   154,   416,   273,   421,
     158,   418,   421,  1678,   421,   406,   407,   408,   409,   410,
    1678,  2311,  1644,   392,  1743,   416,   413,    98,   415,  1711,
     178,  1713,  1559,   402,   403,   404,   388,   406,   407,   408,
     409,   410,   411,   223,   418,   193,   416,   421,   196,   197,
     416,   421,  2344,   351,   202,   421,   204,  1831,   206,   416,
     271,   416,  1756,   416,   421,   146,   421,   392,   421,   416,
     416,   274,   416,  1734,   421,   421,    77,   421,   383,   384,
    1756,   406,   407,   408,   409,   410,   411,  3173,  1601,    90,
     416,   399,  1756,   401,  1868,   421,   416,  1756,    77,  1360,
     388,   421,  1363,  1364,  2885,  1756,  1728,  1881,  2972,   383,
     384,   406,   407,   408,   409,   410,  1601,   198,  2438,   414,
    1255,  1256,  1744,  1258,  1746,    98,  1748,   392,  1873,  1874,
    1875,  1876,  1255,  1256,  1661,  1258,   388,   402,   403,   404,
     223,   406,   407,   408,   409,   410,   411,   345,   345,   347,
     347,   325,   416,   416,   418,   418,   884,  2710,   886,  2712,
      77,   242,   383,   384,   245,  1678,  1728,   408,   129,   383,
     384,  2113,  2114,    90,   187,  1797,   416,   416,  1800,  1801,
      97,   418,  1744,  1601,  1746,   102,  1748,   928,   929,    92,
      85,   408,   108,  1678,  1855,  3138,   273,  1971,  1711,   102,
    1713,   419,   351,  2038,   419,   215,   354,  1734,   351,  1831,
     351,   351,   351,   169,    93,  1934,   108,  1744,   423,  1746,
     221,  1748,   372,   215,   221,   351,  1711,   415,  1713,   415,
     415,   192,   415,   415,   137,  1797,   417,   318,  1800,  1801,
     281,  1863,   221,  1756,   147,   206,  1868,   150,  1909,   415,
     302,   154,   415,   417,   271,   158,   281,   418,   232,  1881,
    1678,   265,   415,   227,   383,   118,   383,    93,   415,   383,
      98,  1756,   273,    98,   281,   178,   237,   383,   227,   382,
     415,   415,   199,   271,   271,    93,   203,   184,  2074,  2075,
     193,   421,   232,  1711,   273,  1713,   183,   415,   421,   271,
     415,   286,   110,  1830,   221,   222,   387,  2964,   415,   390,
     391,   415,   393,   394,   275,   392,   233,   415,   415,  2093,
    1847,   415,   415,   415,  1851,   402,   403,   404,  1855,   406,
     407,   408,   409,   410,   411,   415,  1863,   415,  1756,   415,
     257,   415,   415,   260,    93,   415,   415,  2038,   415,  1971,
     415,   232,   221,   415,   183,   408,   273,   215,   275,   318,
    2051,   245,   421,   150,    42,   371,   417,    18,  1895,   177,
     415,   421,   415,   415,   351,   351,   351,   525,   417,  2070,
     351,   351,  1909,   351,   345,   371,   347,   371,  2079,   351,
     344,   392,   421,   201,   351,   356,   351,   125,   351,  2719,
     351,   402,   403,   404,   365,   406,   407,   408,   409,   410,
     411,   271,   329,   392,   372,   352,   421,  2732,   379,   227,
     351,   569,   570,   351,   403,   404,   351,   406,   407,   408,
     409,   410,   411,   351,   384,   415,   271,   415,   221,   269,
      93,   377,    83,   151,   238,   183,   415,   271,   415,   415,
     415,   354,   415,    93,   317,   415,    93,   372,    18,   402,
     351,   375,   261,   349,   349,  2239,    77,   415,  2090,   421,
     381,  2093,   349,  2095,  3155,   392,   421,   421,   416,   421,
     415,   325,   415,   415,   351,   402,   403,   404,   188,   406,
     407,   408,   409,   410,   411,   421,  2736,   402,   354,   421,
     308,   217,   421,  2743,   421,  2745,  2945,   416,   272,   266,
     234,   319,   413,    39,  2978,   409,   416,   416,   225,   415,
     225,   262,   415,  2296,  2988,   333,   262,   416,   351,   351,
     108,   421,   340,  2095,   343,   302,   194,   391,   421,  2233,
     295,   368,   690,   691,   692,    93,   694,   221,   696,   697,
     698,   221,   372,   701,   702,   703,   704,  2233,   221,   402,
    2182,   413,   351,   351,   402,   183,  2188,  2189,  2095,  2233,
     271,   275,   380,   721,  2233,  2349,   724,  2296,   726,   195,
     728,  2355,  2233,   308,   732,   733,  2421,    93,   736,  3053,
     738,  2252,   740,   197,   197,  2430,   183,   416,   416,   747,
     748,    12,  2293,   188,  2293,  2296,   421,  2296,   756,   244,
     416,   759,  2234,   416,   762,   416,   188,  2239,   766,  2241,
    2182,   416,   770,   771,   416,   773,  2188,  2189,   776,  2251,
    2321,   416,  2321,   188,   416,   421,  2926,  2423,  2424,  2425,
    2426,   416,   388,   388,   416,   416,   794,   416,   796,   388,
     416,   416,   415,   351,   802,   415,   418,   416,  2950,   402,
     416,    35,   416,   421,   416,   418,   569,   570,    77,   281,
     351,   415,  2234,   415,   351,   221,   416,   221,   413,   416,
     245,    90,   830,  2210,   416,   416,   834,   271,    97,   361,
    2217,  2218,   379,   102,   415,   421,   416,   351,   269,  2226,
      85,   849,   850,   851,   852,   269,   854,  2234,   372,   271,
     416,   421,   402,   172,  2241,   172,   413,   416,   169,   188,
    2233,   183,    77,   416,  2251,  2252,    93,  2349,   416,   116,
    2421,   416,   415,  2355,   416,   421,   194,   421,   351,  2430,
    2401,   402,   402,   110,  3036,   416,   415,   392,  2233,   134,
     351,   351,   351,   351,   221,   221,   221,   416,   158,   414,
     183,   225,   372,   415,   275,   207,    93,    93,   415,   193,
     226,   156,   415,  2547,   416,   188,   266,   416,   926,   927,
     416,   415,   930,   416,   416,   416,   415,   224,   224,   174,
     199,   278,   415,   696,   203,   698,   108,   196,   701,   702,
     415,   262,   361,   951,   372,   221,   954,   262,   153,   957,
     177,   208,   221,   222,   190,  2233,   188,   414,   721,   190,
     206,   372,   165,  3138,   233,   174,   416,   152,   213,   152,
     733,   188,   980,   736,   201,   415,   271,   319,   351,   183,
     262,   274,   415,   224,   747,   748,   415,  3137,   257,   415,
     298,   260,    93,   756,   262,   416,   240,   269,   344,   293,
     227,  2483,   269,   766,   273,   271,   275,   770,   771,   421,
     262,   416,   415,   271,  2401,  1023,    96,   183,   271,  1027,
    3170,  1035,    93,  1031,   127,   262,   165,   211,  1036,   262,
     344,   794,   271,   796,   415,   211,  1044,   161,   421,   802,
     134,   271,   312,   156,   421,   174,   369,    81,  1056,  1057,
    2601,  1059,  2601,   298,  1068,   293,   415,   313,  2540,   313,
     329,  2483,   156,   416,  1072,  2547,   226,   830,   297,   314,
    2552,  2553,  2554,  2555,  2556,   320,  1885,  1443,  1237,  2095,
     174,   308,  1817,  2604,  1788,  2192,  1094,   850,  1886,  2593,
    2596,  1808,   319,  2782,  2514,  2143,  2483,  2610,  3098,  1107,
     345,  3128,   347,  3076,  3075,  3107,   333,  2942,  3026,  1117,
    2598,   356,  1871,   340,  1458,  2749,  3185,  3159,  2540,   213,
    2767,  2766,  2233,   392,   369,   370,  3140,  1445,  3186,   178,
    1103,   842,  2331,   402,   403,   404,  1532,   406,   407,   408,
     409,   410,   411,  2624,  3035,  2532,  2533,  1886,  2288,  2153,
    2826,  3012,   421,   380,  2705,  1110,   383,  3149,  2709,   865,
    3184,  1684,  2713,  1877,   156,  2552,  2553,  2554,  2555,  2556,
    2322,  1086,  2106,  1263,  1932,  2115,  1262,  1681,  2618,  2430,
    2711,  2986,  2591,  2400,  1417,  2682,  2051,  2234,   951,  1629,
    1973,   954,  3059,   933,   957,  2729,  2100,  2841,  1057,  2627,
    1737,  1303,  1734,  1270,   298,  2726,    74,   312,  1108,  1217,
    1218,   665,  1709,   961,   929,  1744,  1940,  2604,  2089,  1233,
     314,  1941,  1230,  2724,  1216,  2619,   320,  1235,  1236,  1237,
    2620,  2468,  1779,  1268,  1748,   347,  1935,  1503,  1246,   935,
    2761,     2,    -1,  2725,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   345,    -1,   347,    -1,    -1,    -1,   138,    -1,    -1,
    1023,    -1,   356,    -1,  1027,    -1,    -1,  2749,  1031,    -1,
      -1,    -1,    -1,  1036,    -1,   369,   370,    -1,    -1,    -1,
    1288,    -1,  1290,    -1,    -1,    -1,    -1,    -1,    -1,  2810,
      -1,    -1,    -1,    -1,   175,  2816,  1059,    -1,    -1,  2820,
      -1,    -1,   183,  2725,   134,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1321,  1328,    -1,    -1,    -1,    -1,    -1,
      -1,  2872,    -1,    -1,    -1,    77,  2877,  1335,    -1,    -1,
    2881,  1094,    -1,    -1,    -1,    -1,    -1,   218,  2725,  2726,
    1354,   171,    -1,    -1,  1107,    97,    -1,  1355,    -1,    -1,
     102,    -1,    -1,   183,    -1,    -1,    -1,    -1,   188,    -1,
      -1,    -1,    -1,   193,   194,  1373,   196,  2754,    -1,  2756,
    2757,    -1,    -1,    77,  2761,    -1,  1390,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1393,    90,   217,    -1,  1397,
      -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,  1417,   234,    -1,    -1,  2889,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,  2968,    -1,  2968,
      -1,    -1,    -1,  2810,    -1,    -1,    -1,    -1,  1442,  2816,
      97,    -1,    -1,  2820,  2985,   102,    -1,    -1,   268,  1447,
      -1,  1449,    -1,    -1,    -1,    -1,   276,   199,    -1,    -1,
      -1,   203,  1460,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1474,    -1,    -1,    -1,  1478,    -1,  3161,  2889,    -1,   221,
     222,    -1,    -1,  1481,    -1,    -1,    -1,  1485,  3112,  3113,
      -1,   233,  1490,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,   203,
    1508,    -1,  1510,  1511,    -1,  1513,    -1,    -1,   260,    -1,
      -1,  1519,    -1,   343,    -1,    -1,    -1,   221,   222,  3040,
      -1,   273,    -1,    -1,    -1,  1533,    -1,    -1,  2915,   233,
      -1,    -1,   199,    -1,   364,    -1,   203,    -1,    -1,    -1,
      -1,  3062,    -1,    -1,    -1,  3066,    -1,    -1,    -1,    -1,
      -1,    -1,   382,   257,   221,   222,   260,    -1,  1321,    -1,
      -1,  1569,    -1,    -1,    -1,    -1,   233,    -1,    -1,   273,
      -1,   275,    -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,    -1,    -1,   413,    -1,  1599,   416,   417,   418,    -1,
      -1,    -1,    -1,   260,    -1,    -1,    -1,    -1,  3149,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,    -1,    -1,
    3161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      82,    -1,    -1,    -1,    -1,   329,  1634,    89,    -1,    -1,
    3112,  3113,    -1,  3184,    -1,    -1,    -1,    -1,    -1,    -1,
     392,    -1,    -1,  1651,    -1,    -1,    -1,    -1,    -1,    -1,
     402,   403,   404,  3040,   406,   407,   408,   409,   410,   411,
      -1,    -1,   329,    -1,    -1,    -1,   128,    -1,    -1,    -1,
      -1,    -1,  1680,    -1,    -1,  3062,  3063,  1685,    -1,  3066,
    3067,    -1,    -1,    -1,   146,   147,  1449,    -1,   392,    -1,
      -1,    -1,   154,    -1,    -1,    -1,   158,    -1,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,    -1,
     414,    -1,    -1,    -1,   176,    -1,   178,    -1,    -1,   423,
      -1,    -1,    -1,    -1,    -1,   392,  1734,  1490,    -1,  1737,
      -1,   193,    -1,    -1,    -1,  1743,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,  1753,  1754,    -1,    -1,  1757,
    1758,    -1,    -1,  1761,    -1,    -1,    -1,    -1,    -1,  1767,
      -1,    -1,    -1,    -1,  1772,  1779,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1782,  1783,  1784,  1785,  1786,  1787,
      -1,  1789,  1790,    -1,    -1,    -1,    -1,  1795,  1796,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1808,  1809,  1810,    -1,  1812,  1813,  1814,  1815,    -1,    -1,
    1818,  1819,    -1,  1821,  1822,    -1,    -1,    77,   699,  1035,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1841,    -1,    -1,
      90,    -1,  1846,    -1,    -1,    -1,    -1,    97,   719,    -1,
    1848,  1849,   102,    -1,    -1,    -1,    -1,  1861,    -1,    -1,
      -1,    -1,  1068,    -1,    -1,  1863,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1634,    -1,    -1,  1882,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1651,    -1,
      -1,    -1,   354,  1901,    -1,    -1,    -1,    -1,  1906,    -1,
      -1,    -1,    -1,    -1,    -1,  1913,    -1,  1921,    -1,    -1,
      77,    -1,    -1,    -1,    -1,  1923,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,  1934,    -1,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,   819,   199,
      -1,    -1,  1950,   203,   825,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   833,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   221,   222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1035,   233,    -1,    -1,    -1,    -1,    -1,    -1,
    1743,    -1,    -1,    -1,    -1,   866,    -1,    -1,    -1,    -1,
     871,  1754,    84,    -1,    -1,    -1,    -1,   257,  1761,    -1,
     260,   882,    -1,    95,  1767,  1068,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,
    2028,   113,    -1,  1786,  1787,    -1,  1789,    -1,    -1,    -1,
      -1,    -1,   199,  1796,    -1,    -1,   203,    -1,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,  2054,  1810,    -1,  1812,
      -1,  1814,  1815,   145,   221,   222,  1819,    -1,    -1,    -1,
      -1,    -1,    -1,   525,    -1,    -1,   233,    -1,    -1,   329,
     162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2095,    -1,    -1,
     257,    -1,  2100,   260,    -1,    -1,    -1,    -1,   190,    -1,
      -1,    -1,   194,  2111,    -1,    -1,   273,    -1,   275,    -1,
      -1,    -1,  1328,    -1,   206,    -1,    -1,    -1,    -1,    -1,
    2128,   583,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1012,   392,    -1,    -1,    -1,    -1,    -1,  2146,    -1,
    2154,    -1,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,    -1,    -1,   414,  2163,  2164,    -1,    -1,    -1,
      -1,  2175,   329,  2177,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1934,  1053,  1054,  1390,    -1,    -1,  2191,    -1,  1060,
      -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2207,
     292,    -1,  2216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2219,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2234,  1102,   314,    -1,   316,   392,  1442,    -1,    -1,   321,
      -1,    -1,    -1,  2241,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,  2253,  2254,  2255,    -1,   416,
      -1,   343,   344,    -1,    -1,  2269,    -1,  1035,  1474,    -1,
      -1,    -1,    -1,    -1,   356,  1328,  2280,    -1,    -1,   361,
      -1,    -1,    -1,    -1,  2288,    -1,    -1,  2285,    -1,   371,
      -1,    -1,    -1,    -1,    -1,   747,   748,   379,  2296,    -1,
    1068,  1354,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2313,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2322,    -1,   778,    -1,    -1,    -1,
     782,    -1,   784,  2331,   786,    -1,    -1,  1390,  2342,    -1,
     792,   793,    -1,    -1,    -1,    -1,  2344,    -1,    -1,    -1,
     802,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2363,
      -1,    -1,    84,    -1,  1417,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1244,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    97,  2390,    -1,    -1,  1442,
     102,   113,    -1,  1599,    -1,    -1,    -1,   849,   850,    -1,
      -1,   853,    -1,   125,    -1,    -1,    -1,    -1,  2412,   131,
      -1,  2164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1474,    -1,   145,    -1,  1478,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2431,    -1,    -1,  1035,  2435,  2436,    -1,
     162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   909,   170,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   190,  1068,
      -1,    -1,    -1,    -1,   926,   927,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   206,    -1,    -1,   199,    -1,    -1,
      -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,  2496,  2497,
    2253,  2254,  2255,    -1,    -1,    -1,   228,    -1,    -1,   221,
     222,    -1,    -1,  2517,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   233,    -1,  2521,  2522,    77,    -1,    -1,    -1,    -1,
      -1,    -1,  2285,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    -1,  2296,    -1,    97,  1599,    -1,   260,    -1,
     102,   273,    -1,    -1,  2552,  2553,  2554,  2555,  2556,    -1,
    1328,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     292,    -1,    -1,  1779,    -1,    -1,  2574,    -1,    -1,    -1,
      -1,    -1,  2586,    -1,    -1,    -1,  1354,    -1,    -1,    -1,
      -1,    -1,   314,  2591,   316,  2593,    -1,    -1,  2596,   321,
    2598,    -1,    -1,    -1,    -1,    -1,    -1,  2605,  1479,  1480,
      -1,    -1,  2610,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,   343,  1390,    -1,    -1,    -1,  2624,  1079,    -1,    -1,
     134,    -1,    -1,    -1,   356,  1841,    -1,    -1,    -1,   361,
      -1,  1512,    -1,    -1,    -1,  1097,    -1,   199,  1100,  1417,
      -1,   203,  1523,    -1,    -1,  1861,  1108,   379,    -1,    -1,
      -1,  1532,    -1,    -1,    -1,    -1,    -1,   171,    -1,   221,
     222,    -1,    -1,    -1,  1442,    -1,    -1,    -1,  2682,   183,
     392,   233,    -1,    -1,   188,    -1,    -1,    -1,    -1,   193,
     194,    -1,   196,    -1,   406,   407,   408,   409,   410,   411,
      -1,  2699,    -1,    -1,  2702,   257,  1474,    -1,   260,    -1,
    1478,    -1,    -1,   217,    -1,  1921,    -1,    -1,  2716,    -1,
      -1,   273,    -1,   275,  1176,    -1,  1779,    -1,    -1,  1328,
     234,  2729,    -1,    -1,  2732,  1187,  2734,    -1,  2736,  2737,
      -1,    -1,    -1,    -1,    -1,  2743,  2744,  2745,    -1,    -1,
      -1,    -1,  2750,    -1,    -1,  1354,    -1,  1628,    -1,    -1,
      -1,  1213,    -1,    -1,   268,  1217,  1218,    -1,  2521,  2522,
      -1,    -1,   276,    -1,    -1,    -1,    -1,   329,  1230,    -1,
      -1,  1233,    -1,  1235,    -1,  1237,    -1,    -1,  1841,    -1,
      -1,  1390,    -1,  1846,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1861,    -1,
      -1,    -1,    -1,  1684,    -1,    -1,    -1,  2815,  1417,    -1,
      -1,  2574,  2820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1599,    -1,    -1,    -1,    -1,  1288,    -1,  1290,   343,
     392,    -1,    -1,  1442,    -1,    -1,    -1,    -1,    -1,  1301,
     402,   403,   404,  2857,   406,   407,   408,   409,   410,   411,
     364,    -1,    -1,    -1,   416,    -1,    -1,    -1,  1921,    -1,
    2868,    -1,  2870,    -1,    -1,  1474,    -1,    -1,   382,  1478,
      -1,    -1,    -1,    -1,  2882,    -1,  2884,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1035,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,
      -1,    -1,   416,   417,   418,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    74,  1068,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2936,  2937,
    1392,    -1,    89,    90,    -1,    -1,    -1,    -1,  2154,    -1,
      -1,    -1,  2950,    -1,    -1,    -1,  2954,  2955,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,    -1,    -1,  2175,
      -1,  2177,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2978,   128,    -1,    -1,  2737,  2191,  2990,    -1,    -1,    -1,
    2988,  2744,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   146,
    1599,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1460,    -1,
    2216,  1779,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3020,    -1,    -1,    -1,    -1,  3025,  2234,    -1,
      -1,    -1,    -1,    -1,  1905,    -1,    -1,  3035,  3036,  1910,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1503,  1504,    -1,    -1,  3053,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2269,    -1,    -1,    -1,  3065,    -1,    84,
     217,    -1,    -1,  1841,  2280,    -1,    -1,    -1,  1846,    -1,
      -1,    -1,  2288,    -1,    -1,  3083,    -1,  3085,    -1,    -1,
      -1,    -1,    -1,  1861,    -1,    -1,  1548,    -1,  1550,    -1,
      -1,  2154,  1554,  3101,    -1,    -1,    -1,  1559,  1560,    -1,
    3114,    -1,    77,    -1,    -1,  1567,   131,    -1,    -1,  3117,
      -1,    -1,  2175,    -1,  2177,  1577,    -1,  1579,    -1,    -1,
     145,    -1,    97,    -1,    -1,    -1,  2342,   102,  2191,    -1,
    3138,    -1,    -1,  1595,    -1,  1597,    -1,   162,    -1,    -1,
      -1,    -1,    -1,  1921,    -1,    -1,    -1,  2363,    -1,    -1,
      -1,  3159,    -1,  2216,   311,    -1,    -1,    -1,    -1,  3173,
      -1,    -1,    -1,    -1,    -1,   190,  1628,    -1,    -1,   194,
    1779,  2234,  1634,    -1,  2390,    -1,    -1,  3185,  1328,    -1,
      -1,   206,  1644,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   348,  2073,    -1,   351,    -1,  2412,    -1,    -1,  1661,
      -1,    -1,   227,    -1,  1354,    -1,  2269,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2280,    -1,    -1,
      -1,    -1,    -1,    -1,   199,  2288,    -1,    -1,   203,    -1,
      -1,    -1,  1841,    -1,    -1,    -1,    -1,  1846,    -1,    -1,
    1390,    -1,    -1,    -1,    -1,    -1,   221,   222,   273,    -1,
      -1,    -1,  1861,    -1,    -1,    -1,    -1,  3020,   233,    -1,
      -1,    -1,  3025,    -1,    -1,    -1,  1728,  1417,    -1,    -1,
      -1,    -1,  1734,    -1,    -1,    -1,    -1,    -1,    -1,  2342,
      -1,  1743,   257,    -1,    -1,   260,    -1,    -1,    -1,    -1,
      -1,   316,  1442,    -1,    -1,    -1,   321,    -1,   273,    -1,
    2363,  2517,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1921,    -1,    -1,    -1,    -1,    -1,   343,   344,
    3083,    -1,    -1,    -1,  1474,    -1,    -1,  2390,  1478,    -1,
      -1,   356,    -1,    -1,    -1,  1797,   361,    -1,  1800,  1801,
      -1,    -1,    -1,    -1,    -1,    -1,   371,    -1,    -1,  2412,
      -1,    -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   525,  1831,
    2586,    -1,    -1,    -1,    -1,    -1,  2154,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2265,  1847,    -1,    -1,    -1,  1851,
    2271,    -1,    -1,  1855,    -1,    -1,    -1,  2175,    -1,  2177,
      -1,  1863,    -1,    -1,    -1,    -1,  1868,    -1,    -1,    -1,
      -1,    -1,    -1,  2191,    -1,    -1,    -1,   392,    -1,  1881,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,    -1,  2216,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1909,    -1,  1599,
      -1,    -1,    -1,    -1,  2517,    -1,  2234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2682,    -1,    -1,    -1,
      -1,    -1,  1934,  1935,    -1,    -1,  1938,    -1,  1940,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2280,    -1,    -1,    -1,    -1,    -1,    -1,  1971,
    2288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2586,   681,    -1,    -1,    -1,   685,    -1,
      -1,    -1,   689,    -1,    -1,    -1,   693,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2154,    -1,  2428,  2429,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   720,  2342,    -1,  2175,    -1,  2177,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2191,    -1,    -1,  2363,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    -1,   752,    -1,    -1,   755,    -1,
      -1,    -1,    -1,    90,   761,    -1,    -1,  2216,    -1,    -1,
      97,    -1,  2390,    -1,    -1,   102,    -1,    -1,    -1,  2682,
      -1,    -1,    77,    -1,    -1,  2234,    -1,    -1,  2090,  1779,
      -1,  2093,    -1,  2095,  2412,    90,    -1,    -1,    -1,    -1,
      -1,  2857,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2280,    -1,    -1,    -1,    -1,    -1,    -1,  2559,  2288,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     847,  1841,   849,    -1,    -1,    -1,  1846,    -1,    -1,    -1,
    2581,    -1,    -1,    -1,    -1,    -1,  2587,    -1,    -1,    -1,
     867,  1861,   199,    -1,    -1,    -1,   203,    -1,    -1,    -1,
    2182,    -1,    -1,    -1,    -1,    -1,  2188,  2189,    -1,    -1,
      -1,    -1,    -1,  2342,   221,   222,    -1,    -1,    -1,  2517,
      -1,    -1,    -1,    -1,   199,    -1,   233,    -1,   203,    -1,
      -1,    -1,    -1,    -1,  2363,  2217,  2218,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2226,    -1,   221,   222,    -1,    -1,
     257,  1921,  2234,   260,  2990,    -1,    -1,  2239,   233,  2241,
      -1,  2390,    -1,    -1,    -1,    -1,   273,    -1,   275,  2251,
    2252,    -1,    -1,    -1,  2857,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   257,  2412,    -1,   260,    -1,    -1,  2586,    -1,
      -1,    -1,  2693,  2694,  2695,  2696,    -1,    -1,   273,    -1,
     275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2296,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,  1008,  1009,    -1,    -1,    -1,  1013,    -1,    -1,    -1,
      -1,    -1,  1019,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    -1,    -1,    -1,   329,   102,    -1,    -1,  1035,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2349,    -1,    -1,
      -1,    -1,    -1,  2355,    -1,    -1,    -1,    -1,  3114,    -1,
      -1,  1058,    -1,    -1,  2682,   392,    -1,    -1,  2517,    -1,
      -1,  1068,    -1,    -1,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,    -1,    -1,  2990,    -1,   416,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,  2401,
      -1,    -1,    -1,    77,    -1,    -1,    -1,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,    -1,    -1,    -1,
      -1,   416,    -1,    97,    -1,    -1,  1123,    -1,   102,    -1,
      -1,    -1,   199,    -1,    -1,    -1,   203,  2586,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1145,    -1,
      -1,    -1,    -1,    -1,   221,   222,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2154,    -1,   233,    -1,    -1,    -1,
      -1,    -1,  1169,  1170,    -1,  1172,  1173,  1174,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2175,    -1,  2177,    -1,    -1,
     257,    -1,    -1,   260,    -1,  1192,   170,    -1,    -1,    -1,
      -1,  2191,    -1,    -1,    -1,    -1,   273,  2928,   275,    -1,
      -1,  3114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1217,  1218,    -1,    -1,  2945,   199,  2216,    -1,    -1,   203,
    2532,  2533,    -1,  2682,    -1,    -1,  1233,    -1,    -1,  2857,
      -1,    -1,    -1,    -1,  2234,  2547,  2967,   221,   222,    -1,
    2552,  2553,  2554,  2555,  2556,    -1,    -1,    -1,    -1,   233,
    1257,    -1,   329,  1260,  1261,    -1,    -1,    -1,    -1,    -1,
    3173,  1268,  1269,  1270,    -1,    -1,    -1,    -1,  2999,  2269,
      -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,    -1,
    2280,  1288,    -1,    -1,    -1,    -1,    -1,    -1,  2288,   273,
      -1,    -1,  2604,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2619,    -1,    -1,
      -1,    -1,  1319,    -1,    -1,   392,    -1,    -1,    -1,  1326,
      -1,  1328,    -1,    -1,  1331,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,  1035,    77,    -1,    -1,   416,
      -1,    -1,  2342,    -1,    -1,   329,    -1,  1354,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,  2990,  2363,    -1,    -1,    -1,    -1,  1068,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1390,    -1,    -1,    -1,    -1,    -1,    -1,
    2390,    -1,    -1,    -1,  1401,    -1,    -1,    -1,  2857,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,
    1417,    -1,  2412,  2725,  2726,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1442,    -1,  2749,    -1,    -1,
      -1,    -1,  2754,    -1,  2756,  2757,    -1,    -1,    -1,  2761,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,
      -1,    -1,   203,    -1,    -1,  1472,    -1,  1474,    -1,    -1,
      -1,  1478,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     221,   222,    -1,    -1,    -1,    -1,  3114,    -1,    -1,    -1,
      -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,  2810,    -1,
      -1,    -1,  1509,    -1,  2816,    -1,    -1,    -1,  2820,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   257,  2517,    -1,   260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1535,  1536,
      -1,  2990,   273,    -1,   275,    -1,  1543,    -1,    -1,  1546,
    1547,    -1,    -1,    -1,    -1,  3173,    -1,    -1,    -1,    90,
      -1,    -1,  1559,    -1,    -1,    -1,    -1,    77,    -1,  1566,
      -1,    -1,    -1,  1570,  1571,  1572,    -1,  1574,    -1,    -1,
      90,   112,    -1,    -1,  1581,  1582,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,  2586,    -1,   329,    -1,
      -1,    -1,  1599,  1600,  1601,    -1,  1603,  1604,    -1,    -1,
      -1,  1608,    -1,  2915,    -1,  1612,    -1,    -1,  1615,  1616,
    1617,  1618,  1619,  1620,  1621,  1622,  1623,    -1,  1625,    -1,
      -1,    -1,  1629,    -1,    -1,    -1,  1633,    -1,  1328,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,    -1,    -1,  1354,  3114,    -1,    -1,    -1,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,  1678,    77,    -1,    -1,   416,   217,    -1,    -1,   199,
      -1,    -1,  2682,   203,    -1,    -1,    -1,    -1,    -1,    -1,
    1390,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,   221,   222,    -1,  1711,    -1,  1713,    -1,    -1,    -1,
      -1,    -1,    -1,   233,  3173,    -1,    -1,  1417,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3040,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,   257,    -1,    -1,
     260,    -1,  1442,    -1,    -1,    -1,    -1,    -1,    -1,  1756,
    3062,    -1,    -1,   273,  3066,   275,    97,    -1,    -1,    -1,
      -1,   102,    -1,  1770,    -1,   170,    -1,    -1,    -1,    -1,
      -1,    77,  1779,    -1,  1474,    -1,    -1,    -1,  1478,    -1,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    -1,   199,    -1,   102,    -1,   203,    -1,
    3112,  3113,    -1,    -1,    -1,  3117,    -1,    -1,    -1,   329,
      -1,    -1,    -1,    -1,    -1,    -1,   221,   222,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,   170,
      -1,    -1,    -1,  1840,  1841,    -1,    -1,    -1,    -1,  1846,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3159,    -1,    -1,
      -1,    -1,  1859,    -1,  1861,   260,    -1,  2857,   199,    -1,
      -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,   273,    -1,
      -1,    -1,   392,  3185,    -1,    -1,    -1,    -1,    -1,    -1,
     221,   222,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,   233,   199,    -1,    -1,   416,   203,    -1,  1599,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1921,   221,   222,    -1,    -1,   260,
      -1,    -1,    -1,    -1,   329,    -1,    -1,   233,    -1,    -1,
      -1,    -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1952,    -1,    -1,    -1,    -1,
      -1,   257,    -1,    -1,   260,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1972,    -1,   273,    -1,   275,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   329,    -1,
    2990,    -1,    -1,    -1,  2001,  2002,  2003,    -1,    -1,  2006,
      -1,   406,   407,   408,   409,   410,   411,    -1,    -1,    -1,
      -1,  2018,  2019,  2020,  2021,    -1,    -1,    -1,    -1,    -1,
    2027,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2038,    -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,
      -1,    -1,  2049,  2050,    -1,  2052,    -1,    -1,    -1,  2056,
      -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,  2079,   175,  2081,  2082,    -1,    -1,    -1,  1779,
      -1,   183,    -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   402,   403,   404,  2106,
     406,   407,   408,   409,   410,   411,  2113,  2114,  2115,    -1,
     416,    -1,    -1,    -1,  3114,    -1,   218,   219,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2142,    -1,    -1,    -1,    -1,
     681,  1841,    -1,    -1,    -1,    -1,  1846,  2154,   689,    -1,
      -1,    -1,   693,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1861,    -1,    -1,    -1,    -1,    -1,    -1,  2175,    -1,
    2177,    -1,    -1,  3173,    -1,    77,    -1,    -1,    -1,   720,
      -1,    -1,    -1,    -1,  2191,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2216,
      -1,    -1,    -1,    -1,   755,    -1,    -1,    -1,    -1,    -1,
     761,  1921,    -1,    -1,    -1,    -1,  2233,  2234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   159,    -1,    -1,
      -1,    -1,  2269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2280,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,   199,    -1,    -1,
      -1,   203,    -1,    -1,  2311,    -1,   847,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   221,
     222,    -1,    -1,    -1,    -1,    -1,  2333,    -1,    -1,    -1,
      -1,   233,  2339,    -1,    -1,  2342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2351,    -1,  2353,    -1,    -1,    -1,
    2357,    -1,    -1,    -1,    -1,   257,  2363,  2364,   260,    -1,
    2367,  2368,  2369,  2370,  2371,  2372,  2373,  2374,  2375,  2376,
      -1,   273,    -1,   275,  2381,  2382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2390,    -1,    -1,   170,    -1,  2395,    -1,
      -1,    -1,    -1,    -1,    -1,  2402,  2403,  2404,    -1,  2406,
      -1,    -1,    -1,    -1,    -1,  2412,  2413,    -1,    -1,    77,
      -1,  2418,    -1,    -1,  2421,   199,    -1,    -1,    -1,   203,
      -1,    -1,    90,  2430,    -1,    -1,    -1,   329,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,   221,   222,    -1,
      -1,    -1,    -1,    82,    -1,    -1,    -1,    -1,    -1,   233,
      -1,    -1,    -1,    -1,  2154,    -1,    -1,    -1,    -1,    -1,
    1035,    -1,    -1,    -1,    -1,    -1,  2473,  1008,  1009,    -1,
     372,    -1,  1013,    -1,    -1,  2175,   260,  2177,  1019,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     392,  2191,    -1,  1068,  1035,    -1,    -1,    -1,    -1,    -1,
     402,   403,   404,    -1,   406,   407,   408,   409,   410,   411,
    2517,    -1,    -1,    -1,    -1,   183,  2216,  1058,    -1,   158,
     188,    -1,    -1,    -1,    -1,    -1,    -1,  1068,    -1,    -1,
      -1,   199,    -1,    -1,  2234,   203,    -1,   176,    -1,   178,
      -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   221,   222,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   233,    -1,    -1,  2575,  2269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2586,
    2280,    -1,  1123,    -1,    -1,    -1,    -1,   689,  2288,   257,
      -1,   693,   260,   695,    -1,    -1,    -1,   699,   700,    -1,
      -1,    -1,    -1,    -1,  1145,   273,    -1,   275,   392,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   719,   720,    -1,
    2627,    -1,   406,   407,   408,   409,   410,   411,  1169,  1170,
    2637,  1172,  1173,  1174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1192,   754,   755,    -1,    -1,    -1,    -1,    -1,   761,
      -1,   329,    -1,  2363,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2682,    -1,    -1,    -1,  2686,
    2687,  2688,    -1,    -1,  2691,    -1,    -1,    -1,    -1,    -1,
    2390,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2705,    -1,
      -1,    -1,  2709,    -1,    -1,    -1,  2713,    -1,    -1,    -1,
      -1,    -1,  2412,    -1,    -1,    -1,  1257,   819,    -1,  1260,
    1261,    -1,    -1,   825,   392,    -1,    -1,    -1,    -1,    -1,
      -1,   833,    -1,    -1,   402,   403,   404,    -1,   406,   407,
     408,   409,   410,   411,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1328,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   866,    -1,    -1,    -1,    -1,   871,
      -1,    77,    -1,    -1,  2781,    -1,    -1,    -1,    -1,  1354,
     882,    -1,    -1,    -1,    -1,    -1,    -1,  1328,    -1,    -1,
    1331,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2815,    -1,
      -1,    -1,    -1,  1354,    -1,  1390,    -1,  2517,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2841,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1417,  2850,    -1,  2852,    -1,    -1,    -1,  1390,
    2857,    -1,    -1,    -1,  2861,    -1,    -1,    -1,    -1,    -1,
    1401,    -1,    -1,    -1,   170,  2872,    -1,  1442,    -1,    -1,
    2877,    -1,    -1,    -1,  2881,    -1,  1417,    -1,  2885,  2886,
      -1,    -1,    -1,    -1,    -1,    -1,  2586,    -1,  2895,    -1,
      -1,    -1,    -1,   199,    -1,    -1,    -1,   203,    -1,  1474,
      -1,  1442,    -1,  1478,    -1,  2912,    -1,    -1,    -1,    -1,
    1012,  1013,    -1,    -1,    -1,   221,   222,  1019,    -1,  2926,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,    -1,    -1,
      -1,  1472,    -1,  1474,    -1,    -1,    -1,  1478,    -1,    -1,
      -1,    -1,    -1,    -1,  2951,    -1,    -1,    -1,    -1,    -1,
      -1,  1053,  1054,    -1,   260,    -1,  1058,    -1,  1060,    -1,
      -1,    -1,    -1,    -1,    -1,  2972,    -1,   273,  1509,    -1,
      -1,    -1,    -1,    -1,  2981,    -1,    -1,    -1,  2985,    -1,
      -1,    -1,  2682,  2990,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1535,  1536,    77,    -1,    -1,    -1,
    1102,    -1,  1543,    -1,    -1,  1546,  1547,    -1,    -1,    90,
      -1,    -1,    93,    -1,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,   329,  1599,  1566,    -1,    -1,  3035,  1570,
    1571,  1572,    -1,  1574,    -1,    -1,    -1,    -1,    -1,    -1,
    1581,  1582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3059,    -1,    -1,    -1,    -1,    -1,  1599,  1600,
    1601,    -1,  1603,  1604,    -1,    -1,    -1,  1608,    -1,    -1,
      -1,  1612,    -1,    -1,  1615,  1616,  1617,  1618,  1619,  1620,
    1621,  1622,  1623,    -1,  1625,    -1,   392,    -1,  1629,    -1,
      -1,    -1,  1633,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,  3114,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,
      -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     221,   222,  1244,   782,    -1,   784,    -1,   786,    -1,    -1,
      -1,    -1,   233,   792,   793,    -1,    -1,  2857,    -1,    -1,
      -1,    -1,    -1,  3170,    -1,    -1,  3173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,   260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    93,  1779,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,   853,  1756,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1770,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,  1779,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,  1841,    -1,  1370,    -1,
     909,  1846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1861,   926,   927,    -1,
    2990,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1840,
    1841,    -1,    -1,    -1,   943,  1846,    -1,    -1,    -1,   199,
      -1,   392,    -1,   203,    -1,    -1,    -1,    -1,  1859,    -1,
    1861,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,   221,   222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   233,    -1,    -1,  1921,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,
      -1,    -1,    -1,   203,    -1,    -1,    -1,   257,    -1,    -1,
     260,    -1,    -1,    -1,    -1,    -1,    -1,  1479,  1480,    -1,
    1921,   221,   222,   273,    -1,   275,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1509,    -1,    -1,
    1512,  1952,    -1,    -1,  3114,    -1,    -1,   257,    -1,    -1,
     260,  1523,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1532,  1972,    -1,   273,    -1,   275,    -1,    -1,    -1,   329,
    1079,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2001,  2002,  2003,    -1,    -1,  2006,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3173,    -1,    -1,    -1,  2018,  2019,  2020,
    2021,    -1,    -1,    -1,    -1,    -1,  2027,    -1,    -1,   329,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2038,    -1,    -1,
      -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,  2049,  2050,
      -1,  2052,   402,   403,   404,  2056,   406,   407,   408,   409,
     410,   411,    -1,    -1,    -1,    -1,  1628,    -1,    -1,    -1,
      -1,    -1,   372,    -1,    -1,    -1,    -1,  1176,  2079,    -1,
    2081,  2082,    -1,    -1,    -1,    -1,    -1,    -1,  1187,    -1,
      -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   402,   403,   404,  2106,   406,   407,   408,   409,
     410,   411,  2113,  2114,  2115,  1035,    -1,    -1,    -1,  2154,
      -1,    -1,  1684,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1230,    -1,    -1,  1233,    -1,  1235,    -1,  1237,    -1,
    2175,  2142,  2177,    -1,    -1,    -1,    -1,    -1,  1068,    -1,
      -1,    -1,    -1,  2154,    -1,    -1,  2191,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2175,    -1,  2177,    -1,    -1,    -1,
      -1,  2216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2191,  1290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2234,
      -1,    -1,  1301,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2216,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2233,  2234,  2269,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2280,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2280,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2288,    -1,    -1,
      -1,    -1,    -1,  1392,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2342,    -1,    -1,
    2311,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2363,    -1,
      -1,    -1,  2333,    -1,    -1,    -1,    -1,    -1,  2339,    -1,
      -1,  2342,    -1,  1905,    -1,    -1,    -1,    -1,  1910,    -1,
    2351,    -1,  2353,    -1,    -1,  2390,  2357,    -1,    -1,    -1,
      -1,  1460,  2363,  2364,    -1,    -1,  2367,  2368,  2369,  2370,
    2371,  2372,  2373,  2374,  2375,  2376,    -1,  2412,    -1,    -1,
    2381,  2382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2390,
      -1,    -1,    -1,    -1,  2395,    -1,    -1,    -1,    -1,    -1,
      -1,  2402,  2403,  2404,    -1,  2406,    -1,    -1,  1328,    -1,
      -1,  2412,  2413,    -1,    -1,    -1,    -1,  2418,    -1,    -1,
    2421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2430,
      -1,    -1,    -1,    -1,  1354,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1548,
      -1,  1550,    -1,    -1,    -1,  1554,    -1,    -1,    -1,   689,
    1559,  1560,    -1,   693,    -1,    -1,    77,    -1,  1567,    -1,
    1390,    -1,  2473,    -1,    -1,    -1,    -1,    -1,  1577,    90,
    1579,    -1,  2517,    -1,    -1,    -1,    97,    -1,    -1,    -1,
     720,   102,    -1,    -1,    -1,    -1,  1595,  1417,  1597,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2073,    -1,    -1,    -1,    -1,  2517,  2079,    -1,    -1,
      -1,    -1,  1442,    -1,    -1,   755,    -1,    -1,    -1,    -1,
      -1,   761,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2586,    -1,    -1,  1474,    -1,    -1,    -1,  1478,    -1,
      -1,    -1,  1661,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    -1,    -1,  2575,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,  2586,    -1,    -1,   199,    -1,
      -1,    97,   203,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     221,   222,    -1,    -1,    -1,    -1,    -1,   847,    -1,    -1,
      -1,    -1,   233,    -1,    -1,    -1,  2627,    -1,    -1,  1728,
      -1,    -1,    -1,    -1,    -1,  1734,  2637,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1744,   257,  2682,    -1,   260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   284,    -1,    -1,    -1,    -1,    -1,  1599,
      -1,  2682,    -1,    -1,    -1,  2686,  2687,  2688,    -1,    -1,
    2691,    -1,    -1,   199,    -1,    -1,    -1,   203,  1797,    -1,
      -1,  1800,  1801,  2265,  2705,  1035,    -1,    -1,  2709,  2271,
      -1,    -1,  2713,    -1,    -1,   221,   222,    -1,   329,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,    -1,    -1,
      -1,    -1,  1831,    -1,    -1,    -1,    -1,    -1,  1068,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1847,  2311,
      -1,   257,  1851,    -1,   260,    -1,  1855,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1863,    -1,    -1,   273,    -1,  1868,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1008,    -1,
    2781,   392,  1881,  1013,    -1,    -1,    -1,    -1,    -1,  1019,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,    -1,  1035,    -1,    -1,    -1,    -1,
    1909,    -1,    -1,    -1,  2815,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2857,   329,    -1,    -1,    -1,    -1,  1058,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1068,    -1,
    2841,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2850,
      -1,  2852,    -1,    -1,    -1,    -1,  2857,    -1,    -1,  1779,
    2861,    -1,    -1,    -1,    -1,    -1,  2428,  2429,  2430,    -1,
      -1,  2872,  1971,    -1,    -1,    -1,  2877,    -1,    -1,    -1,
    2881,    -1,    -1,    -1,  2885,  2886,   392,    -1,    -1,    -1,
      -1,    -1,    -1,  1123,  2895,    -1,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,    -1,    -1,    -1,
      -1,  2912,    -1,    -1,    -1,  1145,    -1,    -1,    -1,    -1,
      -1,  1841,    -1,    -1,    -1,  2926,  1846,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1169,
    1170,  1861,  1172,  1173,  1174,    -1,    -1,    -1,    -1,    -1,
    2951,    -1,    -1,    -1,    -1,  2990,    -1,    -1,    -1,    -1,
      -1,    -1,  1192,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2972,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2981,    -1,    -1,    -1,  2985,    -1,    -1,    -1,    -1,  2990,
      -1,    -1,    -1,    -1,  2093,    -1,  2095,  2559,  1328,    -1,
      -1,  1921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2581,
      -1,    -1,    -1,    -1,  1354,  2587,    -1,  1257,    -1,    -1,
    1260,  1261,    -1,    -1,  3035,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3059,    -1,
    1390,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3114,
      -1,    -1,    -1,  2182,    -1,    -1,    -1,  1417,    -1,  2188,
    2189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1328,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1442,  3114,    -1,    -1,    -1,    -1,  2217,  2218,
      -1,    -1,    -1,    -1,  1354,    -1,    -1,  2226,    -1,    -1,
      -1,  2693,  2694,  2695,  2696,  2234,  3137,    -1,  3173,    -1,
    2239,    -1,  2241,  2705,  1474,    -1,    -1,  2709,  1478,    -1,
      -1,  2713,  2251,  2252,    -1,    -1,    -1,    -1,    -1,    -1,
    1390,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3170,
      -1,    -1,  3173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1417,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1442,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2154,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1472,    -1,  1474,    -1,    -1,    -1,  1478,    -1,
    2349,    -1,    -1,  2815,    -1,  2175,  2355,  2177,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1599,
      -1,  2191,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1509,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2216,    -1,    -1,    -1,
      -1,    -1,  2401,    -1,    -1,  1535,  1536,    -1,    -1,    -1,
    2872,    -1,    -1,  1543,  2234,  2877,  1546,  1547,    -1,  2881,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1566,    -1,    -1,    -1,
    1570,  1571,  1572,    -1,  1574,    -1,    -1,    -1,    -1,  2269,
      -1,  1581,  1582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2280,    -1,    -1,    -1,  2926,    -1,  2928,    -1,  2288,  1599,
    1600,    -1,    -1,  1603,  1604,    -1,    -1,    -1,  1608,    -1,
      -1,    -1,  1612,  2945,    -1,  1615,  1616,  1617,  1618,  1619,
    1620,  1621,  1622,  1623,    -1,  1625,    -1,    -1,    -1,  1629,
      77,    -1,    -1,  1633,    -1,  2967,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    93,    -1,    -1,    -1,
      97,    -1,  2342,  2985,    -1,   102,    77,    -1,    -1,    -1,
      -1,    -1,    -1,  2532,  2533,    -1,    -1,  2999,    -1,    90,
      -1,    -1,    -1,  2363,    -1,    -1,    97,    -1,  2547,  1779,
      -1,   102,    -1,  2552,  2553,  2554,  2555,  2556,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2390,    -1,    -1,  3035,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2412,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2604,    -1,    -1,    -1,    -1,
      -1,  1841,    -1,    -1,    -1,    -1,  1846,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,    -1,
      -1,  1861,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,
    1770,    -1,    -1,    -1,   221,   222,    -1,    -1,   199,  1779,
      -1,    -1,   203,    -1,    -1,    -1,   233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     221,   222,    -1,    -1,    -1,  3137,    -1,    -1,    -1,    -1,
     257,    -1,   233,   260,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1921,    -1,    -1,    -1,    -1,   273,  2517,   275,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,  3170,   260,
    1840,  1841,    -1,    -1,    -1,    -1,  1846,    -1,    -1,    -1,
      -1,    -1,   273,    -1,   275,    -1,    -1,  2726,    -1,  1859,
      -1,  1861,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2749,    -1,   329,    -1,    -1,  2754,    -1,  2756,  2757,    -1,
      -1,    -1,  2761,    -1,    -1,    -1,  2586,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2810,    -1,    -1,    -1,   392,    -1,  2816,    -1,    -1,
      -1,  2820,  1952,    -1,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,    -1,    -1,    -1,    -1,    -1,
      -1,   392,  1972,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,    -1,  2682,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2001,  2002,  2003,    -1,    -1,  2006,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2018,  2019,
    2020,  2021,    -1,    -1,    -1,    -1,    -1,  2027,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2038,    -1,
      -1,    -1,    84,    -1,    -1,    -1,  2915,    -1,    -1,  2049,
    2050,    -1,  2052,    95,  2154,    -1,  2056,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   113,    -1,    -1,    -1,  2175,    -1,  2177,    -1,  2079,
      -1,  2081,  2082,    -1,    -1,    -1,    -1,   129,    -1,   131,
      -1,  2191,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   145,    -1,    -1,  2106,    -1,    -1,   151,
      -1,    -1,    -1,  2113,  2114,  2115,  2216,    -1,    -1,    -1,
     162,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2234,    -1,    -1,    -1,    -1,    90,
      -1,    -1,  2142,    -1,    -1,    -1,    97,    -1,    -1,    -1,
     192,   102,   194,    -1,  2154,   689,    -1,    -1,    -1,   693,
      -1,    -1,    -1,    -1,   206,    -1,    -1,  2857,    -1,  2269,
      -1,  3040,    -1,    -1,    -1,  2175,    -1,  2177,    -1,    -1,
    2280,    -1,    -1,    -1,    -1,   227,   720,    -1,  2288,    -1,
      -1,  2191,    -1,  3062,    -1,   237,    -1,  3066,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2216,    -1,    -1,    -1,
      -1,   755,    -1,    -1,    -1,    -1,    -1,   761,    -1,    -1,
      -1,   273,    -1,   275,  2234,    -1,    -1,    -1,    -1,    -1,
      77,    -1,  2342,  3112,  3113,    -1,    -1,    -1,   199,    -1,
     292,    -1,   203,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    -1,    -1,  2363,    -1,   102,    -1,    -1,    -1,  2269,
     221,   222,    -1,    -1,   316,    -1,    -1,    -1,    -1,   321,
    2280,    -1,   233,    -1,    -1,    -1,    -1,    -1,  2288,    -1,
    2390,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2990,   343,   344,   345,    -1,   347,   257,    -1,    -1,   260,
      -1,  2311,  2412,   847,   356,    -1,    -1,    -1,   360,   361,
      -1,    -1,   273,   365,   275,    -1,    -1,    -1,    -1,   371,
      -1,    -1,    -1,  2333,    -1,    -1,    -1,    -1,    -1,  2339,
      -1,    -1,  2342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2351,    -1,  2353,    -1,    -1,    -1,  2357,    -1,    -1,
      -1,    -1,   199,  2363,  2364,    -1,   203,  2367,  2368,  2369,
    2370,  2371,  2372,  2373,  2374,  2375,  2376,    -1,   329,    -1,
      -1,  2381,  2382,    -1,   221,   222,    -1,    -1,    -1,    -1,
    2390,    -1,    -1,    -1,    -1,  2395,   233,   348,    -1,    -1,
      -1,    -1,  2402,  2403,  2404,    -1,  2406,    -1,    -1,    -1,
      -1,    -1,  2412,  2413,    -1,    -1,    -1,  2517,  2418,   847,
     257,  2421,    -1,   260,  3114,    -1,    -1,    -1,    -1,    -1,
    2430,    -1,    -1,    -1,    -1,    -1,   273,    -1,   275,    -1,
      -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2473,  1008,    -1,    -1,    -1,    -1,  1013,
      -1,    -1,    -1,  3173,    -1,  1019,  2586,    -1,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1035,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2517,    -1,    -1,
      -1,    -1,    -1,    -1,  1058,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1068,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,  2575,    -1,    -1,    -1,    -1,
    1008,    -1,  2682,    -1,    -1,    -1,  2586,    -1,    -1,  1123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2627,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1169,  1170,  2637,  1172,  1173,
    1174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1192,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2682,    -1,    -1,    -1,  2686,  2687,  2688,    -1,
      -1,  2691,    -1,    -1,    -1,  1123,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2705,    -1,    -1,    -1,  2709,
      -1,    -1,    -1,  2713,    -1,    -1,    -1,  1145,    -1,    -1,
      -1,    -1,    -1,  1257,    -1,    -1,  1260,  1261,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1169,  1170,    -1,  1172,  1173,  1174,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2857,    -1,    -1,
      -1,    -1,    -1,    -1,  1192,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2781,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1328,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2815,    -1,    -1,    -1,    -1,
    1354,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1257,
      -1,    -1,  1260,  1261,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2841,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2850,    -1,  2852,    -1,    -1,    -1,  1390,  2857,    -1,    -1,
      -1,  2861,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2872,    -1,    -1,    -1,    -1,  2877,    -1,    -1,
      -1,  2881,    -1,  1417,    -1,  2885,  2886,    -1,    -1,    -1,
    2990,    -1,    -1,    -1,    -1,  2895,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1442,    -1,
      -1,    -1,  2912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2926,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1472,    -1,
    1474,    -1,    -1,    -1,  1478,    -1,    -1,    -1,    -1,    -1,
      -1,  2951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2972,    -1,    -1,  1509,    -1,    -1,    -1,    -1,
      -1,  2981,    -1,    -1,    -1,  2985,    -1,    -1,    -1,    -1,
    2990,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1535,  1536,    -1,    -1,    -1,    -1,    -1,    -1,  1543,
      -1,    -1,  1546,  1547,  3114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1566,    -1,    -1,  3035,  1570,  1571,  1572,    -1,
    1574,    -1,    -1,    -1,  1472,    -1,    -1,  1581,  1582,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3059,
      -1,    -1,    -1,    -1,    -1,  1599,  1600,    -1,    -1,  1603,
    1604,    -1,    -1,  3173,  1608,    -1,    -1,    -1,  1612,    -1,
      -1,  1615,  1616,  1617,  1618,  1619,  1620,  1621,  1622,  1623,
      -1,  1625,    -1,    -1,    -1,  1629,    -1,    -1,    -1,  1633,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3114,  1543,    -1,    -1,    -1,  1547,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3137,  1566,    -1,
      -1,    -1,  1570,    -1,    -1,    -1,  1574,    -1,    -1,    -1,
      -1,    -1,    -1,  1581,  1582,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3170,    -1,  1600,  3173,    -1,    -1,  1604,    -1,    -1,    -1,
    1608,    -1,    -1,    -1,  1612,    -1,    -1,  1615,  1616,  1617,
    1618,  1619,  1620,  1621,  1622,  1623,    -1,  1625,    -1,    -1,
      -1,  1629,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1770,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1779,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1840,  1841,    -1,    -1,
      -1,    -1,  1846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1859,    -1,  1861,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1770,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1921,    -1,    -1,
      -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,
      -1,    -1,  1840,    -1,    -1,    -1,    -1,    29,  1952,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    40,    41,
      -1,  1859,    -1,    -1,    -1,    -1,    48,    49,  1972,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    -1,  2001,  2002,  2003,
      -1,    -1,  2006,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2018,  2019,  2020,  2021,    -1,    -1,
      -1,    -1,    -1,  2027,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   115,  2038,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2049,  2050,    -1,  2052,    -1,
      -1,    -1,  2056,    -1,  1952,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1972,  2079,    -1,  2081,  2082,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     182,    -1,  2106,    -1,    -1,    -1,    -1,    -1,    -1,  2113,
    2114,  2115,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
    2018,    -1,  2020,  2021,    -1,    -1,    -1,    -1,    -1,  2027,
      -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,  2142,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2154,    -1,  2050,    -1,  2052,    -1,    -1,    -1,  2056,    -1,
     242,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2175,    -1,  2177,    -1,    -1,    -1,    -1,    -1,    -1,
     262,    -1,    -1,    -1,    -1,    -1,    -1,  2191,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2106,    -1,
      -1,    -1,  2216,    -1,    -1,  2113,  2114,  2115,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2234,    -1,    -1,    -1,    -1,    -1,   318,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2142,    -1,    -1,    -1,    -1,    -1,
      -1,  1188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2269,    -1,    -1,    -1,   351,
      -1,    -1,    -1,    -1,    -1,    -1,  2280,    -1,    -1,    -1,
      -1,    -1,   364,    -1,  2288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   376,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,  2311,   390,   391,
      -1,   393,    -1,    -1,    -1,    -1,    -1,   399,    -1,   401,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,  2333,
      -1,   413,   414,   415,    -1,  2339,    -1,   419,  2342,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2351,    -1,  2353,
      -1,    -1,    -1,  2357,    -1,    -1,    -1,    -1,    -1,  2363,
    2364,    -1,    -1,  2367,  2368,  2369,  2370,  2371,  2372,  2373,
    2374,  2375,  2376,    -1,    -1,    -1,    -1,  2381,  2382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2390,    -1,    -1,    -1,
      -1,  2395,    -1,    -1,    -1,    -1,    -1,    -1,  2402,  2403,
    2404,    -1,  2406,    -1,    -1,    -1,    -1,    -1,  2412,  2413,
      -1,    -1,    -1,    -1,  2418,    -1,    -1,  2421,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2430,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2333,    -1,    -1,    -1,    -1,
      -1,  2339,    -1,    -1,    -1,    -1,  1383,    -1,    -1,    -1,
      -1,    -1,    -1,  2351,    -1,  2353,    -1,    -1,    -1,  2357,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2473,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2381,  2382,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2404,    -1,  2406,    -1,
      -1,    -1,    -1,  2517,    -1,  2413,    -1,    -1,    -1,    -1,
    2418,    -1,    -1,  2421,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2575,    -1,    -1,    -1,  2473,    -1,    -1,    -1,    -1,
      -1,    -1,  2586,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1541,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2627,    -1,    -1,    -1,    -1,  1565,    -1,
      -1,    -1,    -1,  2637,  1571,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1586,
    1587,  1588,  1589,    -1,  1591,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1603,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2682,    -1,
      -1,    -1,  2686,  2687,  2688,    -1,    -1,  2691,    -1,    -1,
    1627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2705,    -1,    -1,    -1,  2709,    -1,    -1,    -1,  2713,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2627,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2637,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1693,    -1,    -1,    -1,
      -1,    -1,  1699,    -1,  1701,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2781,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2687,
    2688,    -1,    -1,  2691,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2815,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2841,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2850,    -1,  2852,    -1,
      -1,    -1,    -1,  2857,    -1,    -1,    -1,  2861,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2872,    -1,
      -1,    -1,    -1,  2877,    -1,    -1,    -1,  2881,    -1,    -1,
      -1,  2885,  2886,  2781,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2895,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2912,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2926,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2841,    -1,    -1,    -1,  2951,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2861,    -1,    -1,    -1,    -1,  2972,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2981,    -1,    -1,
      -1,  2985,  1919,    -1,    -1,    -1,  2990,    -1,  2886,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2895,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2912,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1966,
      -1,  3035,    -1,    -1,    -1,    -1,    -1,    -1,  1975,    -1,
    1977,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2951,    -1,  3059,    -1,    -1,    -1,  1996,
      -1,    -1,  1999,    -1,  2001,  2002,  2003,  2004,    -1,  2006,
      -1,    -1,    -1,  2010,    -1,    -1,    -1,    -1,    -1,    -1,
    2017,    -1,    -1,  2981,    -1,  2022,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2033,    -1,    -1,  2036,
    2037,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3114,  2048,  2049,    -1,    -1,    -1,    -1,    -1,  2055,    -1,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2065,  2066,
      -1,    -1,    -1,  3137,    -1,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,
      -1,  3059,    -1,    -1,    -1,    -1,  3170,    -1,    -1,  3173,
      40,    41,    -1,    -1,    -1,    -1,    46,    -1,    48,    49,
      -1,    -1,    -1,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    -1,    -1,
      -1,    -1,  2149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2214,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   242,    -1,    -1,   245,    -1,    -1,    -1,    -1,
      -1,  2318,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2360,  2361,  2362,    -1,  2364,    -1,    -1,
    2367,  2368,  2369,  2370,  2371,  2372,  2373,  2374,  2375,  2376,
      -1,  2378,    -1,    -1,    -1,    -1,    -1,    -1,   318,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2398,    -1,    -1,    -1,    -1,  2403,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2414,  2415,    -1,
    2417,   351,    -1,  2420,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
     390,   391,    -1,   393,    -1,   395,    -1,    -1,    -1,   399,
      -1,   401,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,   416,    -1,   418,   419,
     420,   421,    -1,     5,    -1,    -1,    -1,  2494,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    40,    41,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2575,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2634,    -1,    -1,
      -1,  2638,    -1,    -1,    -1,    -1,  2643,  2644,    -1,  2646,
      -1,    -1,  2649,    -1,    -1,    -1,  2653,  2654,  2655,  2656,
    2657,  2658,  2659,  2660,  2661,  2662,  2663,  2664,    -1,    -1,
     182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2678,  2679,    -1,  2681,    -1,   198,    -1,  2685,  2686,
      -1,    -1,  2689,    -1,    -1,  2692,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     242,    -1,    -1,   245,  2731,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2783,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   318,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
      -1,    -1,    -1,    -1,    -1,    -1,  2843,    -1,    -1,    -1,
      -1,    -1,   364,  2850,    -1,  2852,    -1,    -1,    -1,    -1,
      -1,  2858,  2859,  2860,   376,  2862,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,   390,   391,
      -1,   393,    -1,    -1,    -1,    -1,    -1,   399,    -1,   401,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,    -1,
      -1,   413,   414,   415,   416,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2930,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2971,  2972,  2973,    -1,    -1,  2976,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2992,    -1,    -1,    -1,  2996,
      -1,    -1,    -1,    -1,  3001,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3033,    -1,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,  3048,    19,    -1,    21,  3052,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,    -1,
     107,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,    -1,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,    -1,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,     6,
       7,     8,    -1,    -1,    11,    12,    -1,    14,    15,    16,
      -1,    -1,    -1,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,   419,    30,    31,    32,    -1,    -1,    -1,    36,
      37,    38,    39,    -1,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    -1,    -1,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,
      -1,   178,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   209,   210,    -1,    -1,    -1,    -1,    -1,   216,
      -1,   218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,    -1,    -1,   260,    -1,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     277,   278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,
      -1,    -1,   329,    -1,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,
     357,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,
      -1,   378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,    -1,   390,    11,    12,   393,    14,    15,    16,
      -1,    -1,    -1,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    -1,    -1,    -1,    36,
      37,    38,    39,   420,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    -1,    -1,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,
      -1,   178,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   209,   210,    -1,    -1,    -1,    -1,    -1,   216,
      -1,   218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,    -1,    -1,   260,    -1,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     277,   278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,
      -1,    -1,   329,    -1,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,
     357,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,
      -1,   378,    -1,    -1,    -1,    -1,     3,    -1,    -1,     6,
       7,     8,     9,   390,    11,    12,   393,    14,    15,    16,
      17,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,   420,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    88,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    -1,    -1,   101,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,   119,    -1,   121,   122,   123,    -1,    -1,   126,
     127,    -1,    -1,    -1,    -1,   132,   133,   134,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   145,    -1,
     147,   148,   149,   150,    -1,    -1,    -1,    -1,    -1,   156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,    -1,    -1,    -1,    -1,   174,   175,   176,
      -1,   178,    -1,   180,    -1,   182,    -1,    -1,    -1,    -1,
     187,    -1,   189,    -1,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   209,   210,    -1,    -1,   213,    -1,    -1,   216,
      -1,   218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,   233,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,    -1,    -1,    -1,    -1,   246,
      -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     277,   278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,
      -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
      -1,    -1,   299,    -1,   301,    -1,    -1,    -1,   305,    -1,
      -1,    -1,   309,   310,   311,   312,    -1,    -1,   315,    -1,
      -1,    -1,    -1,   320,    -1,    -1,    -1,    -1,   325,   326,
      -1,   328,   329,    -1,   331,     3,    -1,   334,    -1,    -1,
      -1,     9,    -1,    -1,   341,    -1,    -1,    -1,    -1,    17,
      -1,    19,   349,   350,    22,    -1,    -1,    -1,   355,    -1,
     357,    -1,   359,    -1,   361,    33,    -1,   364,    -1,    -1,
     367,    -1,   369,    -1,    -1,    -1,   373,    -1,    -1,   376,
      -1,   378,    -1,    51,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   390,    -1,    -1,   393,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   415,    87,
      88,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   119,    -1,   121,   122,    -1,    -1,    -1,   126,   127,
      -1,    -1,    -1,    -1,    -1,   133,   134,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   145,    -1,   147,
      -1,    -1,   150,    -1,    -1,    -1,    -1,    -1,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,    -1,    -1,    -1,    -1,   174,    -1,   176,    -1,
      -1,    -1,   180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,    -1,
      -1,   239,    -1,    -1,    -1,    -1,    -1,    -1,   246,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   299,    -1,   301,    -1,    -1,    -1,   305,    -1,    -1,
      -1,   309,    -1,   311,    -1,    -1,    -1,   315,    -1,    -1,
      -1,    -1,   320,    -1,    -1,    -1,    -1,   325,    -1,    -1,
     328,    -1,    -1,    -1,    -1,    -1,   334,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   359,    -1,   361,    -1,    -1,    -1,    -1,    -1,   367,
      -1,   369,    -1,    -1,    -1,   373,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,   415,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,   160,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,    -1,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,   233,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,   392,   393,   394,    -1,    -1,   397,   398,
     399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,   408,
      -1,   410,   411,    -1,    -1,    -1,   415,   416,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,   392,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,
     407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,   416,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,    -1,   379,     5,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,    20,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,    -1,    40,
      41,   417,    -1,    -1,    -1,    -1,    -1,    48,    49,    -1,
      -1,    -1,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   242,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   318,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   376,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,   390,
     391,    -1,   393,    -1,    -1,    -1,    -1,    -1,   399,    -1,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
      -1,    -1,   413,   414,   415,   416,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,   392,   393,   394,    -1,    -1,   397,   398,
     399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,    -1,
      -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,   209,   210,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
     228,   229,    -1,   231,   232,   233,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,
     408,    -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,   392,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,
     407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,
     406,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,    -1,   231,   232,   233,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,   392,   393,   394,
      -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,
      -1,   406,   407,    -1,    -1,   410,   411,    -1,   413,    -1,
     415,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,
      -1,    -1,   406,   407,    -1,    -1,   410,   411,    -1,    -1,
      -1,   415,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,   210,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,    -1,    -1,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,   392,
     393,   394,    -1,    -1,   397,   398,   399,   400,   401,    -1,
      -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,    -1,
      -1,    -1,   415,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,   210,    -1,
     212,   213,   214,   215,   216,    -1,   218,    -1,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,    -1,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,   400,   401,
      -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,
      -1,    -1,    -1,   415,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,   215,   216,    -1,   218,    -1,    -1,
     221,   222,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,   392,   393,   394,    -1,    -1,   397,   398,   399,   400,
     401,    -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,
     411,    -1,    -1,    -1,   415,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
     400,   401,    -1,    -1,    -1,    -1,    -1,   407,    -1,    -1,
     410,   411,    -1,    -1,    -1,   415,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,    -1,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,    -1,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,    -1,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,    -1,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,   392,   393,   394,    -1,    -1,   397,   398,
     399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,    -1,
      -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,   209,   210,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
     228,   229,    -1,   231,   232,   233,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,   397,
     398,   399,   400,   401,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,   415,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,    -1,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,   215,   216,    -1,   218,    -1,    -1,
     221,   222,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,    -1,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,    -1,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,    -1,    -1,   397,   398,   399,   400,
     401,    -1,    -1,    -1,    -1,    -1,   407,    -1,    -1,   410,
     411,    -1,    -1,    -1,   415,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    91,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,    -1,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
      -1,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,   262,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,    -1,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,    -1,    -1,   397,   398,   399,
     400,   401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   411,    -1,    -1,    -1,   415,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    91,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,    -1,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,    -1,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,    -1,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,   262,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,    -1,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,    -1,    -1,   397,   398,
     399,   400,   401,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,   415,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
      -1,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,    -1,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,   210,    -1,
     212,   213,   214,   215,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,    -1,   274,    -1,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,    -1,    -1,   397,   398,   399,   400,   401,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   411,
      -1,    -1,    -1,   415,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,    -1,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,   215,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,    -1,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,    -1,    -1,   397,   398,   399,   400,
     401,    -1,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,   415,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    93,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,   171,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,   183,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,   217,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,   268,   269,    -1,    -1,    -1,   273,
     274,    -1,   276,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,     5,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
      -1,    -1,    -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   416,    40,    41,    -1,    -1,    -1,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   242,    -1,    -1,   245,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   318,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,   390,   391,    -1,   393,    -1,    -1,    -1,
      -1,    -1,   399,    -1,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,    -1,    -1,   413,   414,   415,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
      -1,   258,   259,   260,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,   272,   273,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,    -1,
      -1,    -1,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,   415,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,   108,   109,    -1,   111,    -1,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,    -1,   258,   259,   260,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,   272,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,   415,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
     221,   222,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,    -1,   258,   259,   260,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,   415,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,    -1,
      -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   414,   415,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,    -1,
      -1,   399,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,   415,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   415,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
     320,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   415,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,   320,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,    -1,
      -1,    -1,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,   415,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,   415,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,    -1,    -1,    -1,    -1,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,   415,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,   106,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,   127,
     128,    -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,    -1,   176,    -1,
      -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,    -1,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,    -1,    -1,
     258,   259,    -1,   261,    -1,    -1,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,   281,   282,   283,    -1,    -1,    -1,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,    -1,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,    -1,   356,    -1,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,
      -1,   399,    -1,   401,   402,   403,   404,    -1,   406,   407,
     408,   409,   410,   411,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     402,   403,   404,    -1,   406,   407,   408,   409,   410,   411,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,    -1,   107,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,    -1,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,    -1,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,    -1,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,   408,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,   106,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,    -1,    -1,    -1,   126,   127,   128,
      -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,    -1,   176,    -1,    -1,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,    -1,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,    -1,    -1,   258,
     259,    -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,   281,   282,   283,    -1,    -1,    -1,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,    -1,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,    -1,   356,    -1,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,   408,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,   408,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,    -1,    -1,    -1,    -1,   399,    -1,   401,    -1,
       6,     7,     8,     9,   407,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,    -1,
      -1,    -1,    -1,   399,    -1,   401,    -1,     6,     7,     8,
       9,   407,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,   188,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,   203,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,     6,     7,     8,     9,
     399,    11,    12,    -1,    14,    15,    16,    17,   407,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,     6,     7,     8,     9,   399,
      11,    12,    -1,    14,    15,    16,    17,   407,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
     351,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,     6,     7,     8,     9,    -1,    11,
      12,   402,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,    -1,    -1,   397,   398,   399,    -1,   401,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,     4,
     396,     6,     7,     8,     9,    10,    11,    12,    -1,    14,
      15,    16,    17,    18,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,    -1,    -1,    11,    12,    -1,    14,    15,    16,
      -1,    -1,    -1,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    -1,    -1,    -1,    36,
      37,    38,    39,    -1,    41,    -1,    43,    44,    45,    46,
      47,    48,    49,    50,    -1,    -1,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,
      -1,   178,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   209,   210,    -1,    -1,    -1,    -1,    -1,   216,
      -1,   218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,    -1,    -1,   260,    -1,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     277,   278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,
      -1,    -1,   329,    -1,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,
     357,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,
      -1,   378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   390,    -1,    -1,   393,    -1,   395,     6,
       7,     8,    -1,    -1,    11,    12,    -1,    14,    15,    16,
      -1,    -1,    -1,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    -1,    -1,    -1,    36,
      37,    38,    39,    -1,    41,    -1,    43,    44,    45,    46,
      47,    48,    49,    50,    -1,    -1,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   148,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,
      -1,   178,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   209,   210,    -1,    -1,    -1,    -1,    -1,   216,
      -1,   218,    -1,    -1,   221,   222,    -1,   224,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,    -1,    -1,   260,    -1,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     277,   278,   279,   280,    -1,    -1,    -1,    -1,   285,   286,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   310,    -1,   312,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,
      -1,    -1,   329,    -1,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   349,   350,    -1,    -1,    -1,    -1,   355,    -1,
     357,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,
      -1,   378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   390,    -1,    -1,   393,    -1,   395,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,   107,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,    -1,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,    -1,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,
     127,   128,    -1,   130,   131,    -1,   133,    -1,   135,   136,
     137,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,    -1,   176,
      -1,    -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,    -1,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,    -1,   252,   253,   254,   255,    -1,
      -1,   258,   259,   260,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
      -1,   278,   279,    -1,   281,   282,   283,    -1,    -1,    -1,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,    -1,   356,
      -1,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    13,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    42,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
     351,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,    -1,   393,   394,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    18,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,   106,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,   127,
     128,    -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,    -1,   176,    -1,
      -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,    -1,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,    -1,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,   281,   282,   283,    -1,    -1,    -1,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,    -1,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,    -1,   356,    -1,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,   106,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,    -1,    -1,    -1,   126,   127,   128,
      -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,    -1,   176,    -1,    -1,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,    -1,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,   281,   282,   283,    -1,    -1,    -1,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,    -1,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,    -1,   356,    -1,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,   106,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,
     130,   131,    -1,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,    -1,   176,    -1,    -1,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
      -1,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,    -1,    -1,   258,   259,
      -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,   281,   282,   283,    -1,    -1,    -1,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,    -1,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,    -1,   356,    -1,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,   106,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,
     131,    -1,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,    -1,   176,    -1,    -1,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,    -1,
      -1,   212,   213,   214,   215,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,    -1,    -1,   258,   259,    -1,
     261,    -1,    -1,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
     281,   282,   283,    -1,    -1,    -1,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,    -1,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,    -1,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,    -1,   356,    -1,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,   107,   108,   109,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,   190,    -1,   192,
     193,   194,   195,   196,   197,    -1,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,    -1,
     243,   244,    -1,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,    -1,    -1,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,    -1,   381,   382,
     383,   384,   385,   386,    -1,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,    -1,   231,   232,   233,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,    -1,   258,   259,   260,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,   329,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,   129,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,   185,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    88,
      89,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,   251,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,   272,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,   188,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,   203,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,   194,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    93,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,    -1,   393,     6,     7,     8,    -1,    -1,    11,    12,
      -1,    14,    15,    16,    -1,    -1,    -1,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      -1,    -1,    -1,    36,    37,    38,    39,    -1,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    -1,    -1,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   148,   149,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   175,    -1,    -1,   178,    -1,    -1,    -1,   182,
      -1,    -1,    -1,    -1,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   209,   210,    -1,    -1,
      -1,    -1,    -1,   216,    -1,   218,    -1,    -1,   221,   222,
      -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   248,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   277,   278,   279,   280,    -1,    -1,
      -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,   312,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   349,   350,    -1,    -1,
      -1,    -1,   355,    -1,   357,    -1,    -1,    -1,    -1,    -1,
      -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   376,    -1,   378,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,    -1,   390,    11,    12,
     393,    14,    15,    16,    -1,    -1,    -1,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      -1,    -1,    -1,    36,    37,    38,    39,    -1,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,
     103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   148,   149,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   175,    -1,    -1,   178,    -1,    -1,    -1,   182,
      -1,    -1,    -1,    -1,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   209,   210,    -1,    -1,
      -1,    -1,    -1,   216,    -1,   218,    -1,    -1,   221,   222,
      -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   248,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   277,   278,   279,   280,    -1,    -1,
      -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,   312,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   349,   350,    -1,    -1,
      -1,    -1,   355,    -1,   357,    -1,    -1,    -1,    -1,    -1,
      -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   376,    -1,   378,     6,     7,     8,    -1,
      -1,    11,    12,    -1,    14,    15,    16,   390,    -1,    -1,
     393,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    -1,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,
      -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,   149,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,    -1,
      -1,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,
     210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   218,    -1,
      -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,
     260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,   279,
     280,    -1,    -1,    -1,    -1,   285,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,   329,
      -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,
     350,    -1,    -1,    -1,    -1,   355,    -1,   357,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,   378,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,    -1,    -1,   393
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   425,   426,     0,     5,    20,    29,    40,    41,    46,
      48,    49,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,   115,   182,   198,   215,
     242,   245,   262,   318,   351,   364,   376,   387,   390,   391,
     393,   395,   399,   401,   402,   406,   407,   408,   409,   410,
     413,   414,   415,   416,   418,   419,   420,   421,   427,   785,
     786,   789,   824,   826,   923,   936,   937,   825,     3,     6,
       7,     8,     9,    11,    12,    14,    15,    16,    17,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    30,
      31,    32,    33,    36,    37,    38,    39,    41,    43,    44,
      45,    47,    48,    49,    50,    51,    52,    56,    57,    62,
      71,    73,    75,    76,    78,    87,    88,    89,    97,    98,
     101,   102,   103,   104,   105,   116,   119,   121,   122,   123,
     126,   127,   132,   133,   134,   137,   145,   147,   148,   149,
     150,   156,   164,   169,   174,   175,   176,   178,   180,   182,
     187,   189,   191,   193,   199,   209,   210,   213,   216,   218,
     221,   222,   224,   231,   233,   235,   236,   239,   246,   248,
     249,   250,   256,   259,   260,   263,   264,   277,   278,   279,
     280,   285,   286,   288,   296,   299,   301,   305,   309,   310,
     311,   312,   315,   320,   325,   326,   328,   329,   331,   334,
     341,   349,   350,   355,   357,   359,   361,   364,   367,   369,
     373,   376,   378,   390,   393,   415,   428,   429,   430,   432,
     433,   434,   438,   441,   442,   443,   447,   458,   459,   460,
     463,   464,   472,   473,   482,   509,   515,   516,   520,   524,
     526,   528,   529,   542,   543,   544,   545,   551,   556,   557,
     562,   563,   567,   570,   571,   582,   588,   601,   602,   604,
     607,   609,   610,   613,   615,   616,   624,   625,   626,   627,
     628,   633,   634,   635,   639,   640,   641,   642,   644,   645,
     646,   647,   648,   653,   656,   660,   661,   665,   666,   669,
     670,   671,   672,   673,   801,   814,   815,   816,   817,   818,
     831,   836,   837,   838,   839,   840,   842,   844,   846,   847,
     848,   849,   851,   856,   857,   860,   865,   866,   875,   876,
     878,   879,   880,   883,   887,   890,   894,   896,   897,   900,
     902,   905,   913,   919,   920,   930,   395,   828,   829,   831,
     833,   836,   839,   842,    18,     9,    17,    19,    33,    51,
      52,    56,    57,    62,    71,    73,    75,    76,    78,    79,
      80,    81,    82,    83,    84,    86,    87,    95,    96,    97,
      99,   100,   101,   108,   109,   111,   114,   115,   117,   119,
     120,   121,   122,   126,   127,   128,   130,   131,   133,   135,
     136,   138,   143,   144,   145,   146,   147,   150,   152,   154,
     156,   157,   158,   162,   163,   164,   165,   167,   168,   170,
     172,   173,   174,   176,   180,   181,   184,   186,   190,   192,
     195,   197,   198,   200,   201,   202,   204,   205,   206,   207,
     212,   213,   214,   223,   225,   226,   227,   228,   229,   232,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   252,   253,   254,   255,   258,   259,   261,
     265,   266,   269,   273,   274,   281,   282,   283,   287,   288,
     290,   291,   292,   293,   294,   295,   297,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   311,   313,
     314,   315,   316,   317,   318,   321,   322,   323,   325,   327,
     328,   330,   333,   334,   335,   336,   337,   338,   339,   340,
     342,   344,   345,   346,   347,   351,   352,   354,   356,   359,
     360,   361,   362,   363,   366,   367,   368,   369,   370,   373,
     374,   375,   377,   379,   383,   384,   385,   386,   387,   388,
     394,   789,   794,   799,   810,   811,   904,   905,   906,   909,
     915,   916,   917,   918,   919,   927,   929,   930,    34,   211,
     877,    13,    85,   151,   778,   789,   802,   803,   812,   858,
     859,   909,   929,   930,     5,    29,    34,    40,    41,    48,
      49,    85,    88,    89,    90,    91,    92,    93,    94,   107,
     112,   113,   115,   118,   124,   125,   129,   134,   139,   140,
     141,   142,   151,   153,   159,   160,   161,   166,   169,   171,
     179,   183,   185,   188,   193,   194,   196,   203,   208,   211,
     215,   217,   219,   230,   234,   251,   257,   262,   267,   268,
     270,   271,   272,   275,   276,   289,   298,   320,   324,   332,
     343,   348,   351,   353,   358,   364,   365,   371,   372,   381,
     382,   419,   841,   906,   907,   908,   912,   913,   914,   915,
     917,   918,   921,   777,   909,   777,   908,    29,    40,   115,
     215,   901,    43,    45,   257,   832,   354,   385,   629,    84,
     131,   145,   162,   190,   194,   206,   227,   273,   316,   321,
     343,   344,   356,   361,   371,   802,   150,   629,   777,   251,
     270,   773,   775,   781,   800,   909,   271,   629,   104,   478,
      84,    95,   113,   129,   145,   151,   162,   192,   194,   237,
     273,   275,   316,   344,   345,   347,   356,   360,   361,   365,
     371,   483,   521,   554,   583,   589,   802,    18,   288,   777,
     812,   864,   335,   777,   188,    84,    95,   113,   131,   145,
     162,   190,   194,   206,   273,   292,   314,   316,   321,   343,
     344,   356,   361,   371,   379,   525,   558,   629,   200,   864,
     648,   655,    79,    85,    99,   181,   186,   188,   203,   229,
     252,   290,   300,   407,   564,   565,   566,   777,   785,   790,
     791,   927,    18,    85,   134,   156,   174,   213,   298,   314,
     320,   345,   347,   356,   369,   370,   572,   573,   574,   219,
     775,   909,   782,   794,   343,   676,   564,   777,   775,   864,
     145,   206,   343,   611,   315,   909,    85,   323,   349,   354,
     909,   193,   579,   629,   909,    85,   160,   678,     4,    10,
      18,   130,   237,   247,   323,   349,   354,   448,   449,   909,
      85,   323,   349,   354,   909,   354,   676,   898,   908,   408,
     775,   272,   700,   775,   189,   650,   670,   671,   101,   429,
     418,   378,   649,   171,   217,   276,   364,   679,   680,   839,
     842,   838,   820,   418,   843,   845,     5,    29,    40,   115,
     163,   215,   850,   146,   198,   242,   245,   318,   387,   415,
     729,   823,   827,   923,   395,   831,   833,   839,   835,   418,
     777,   812,   931,   151,   802,    25,   372,   409,   777,   777,
     392,   804,   805,   423,   929,   415,   419,   932,   933,   934,
     935,   937,   841,   372,   867,   868,   869,    29,   215,   215,
     912,     7,    11,    23,    24,    44,    47,   161,   903,   903,
      21,   839,   773,   783,   904,   911,   915,   916,   920,   930,
     560,   909,   778,   560,   778,   909,   783,   799,   700,   777,
     120,   392,   402,   403,   404,   406,   407,   408,   409,   410,
     411,   606,   736,   737,   909,   777,   775,   700,   777,   777,
     560,   799,    39,   223,   295,   630,   631,   632,   413,   417,
     761,   762,   271,    84,   113,   125,   131,   145,   162,   190,
     206,   228,   273,   314,   316,   321,   343,   356,   361,   379,
     525,   568,   775,   783,   777,   415,   356,   778,   560,   345,
     347,   799,   345,   347,   120,   736,   304,   444,   909,   777,
     777,   560,   799,   321,   343,   525,   131,   206,   190,   314,
     379,   931,   864,   930,   667,   700,   783,   777,   415,   778,
     783,   799,   120,   736,   777,   777,   777,   437,   799,   227,
     559,   560,   393,   812,   863,   861,   649,   565,    85,   565,
      85,   565,   565,   790,   566,   777,   777,   219,   870,   872,
     931,   291,   271,   421,   775,   774,   775,   566,   188,   777,
     775,   909,    98,   388,   223,   274,   572,   351,   271,    92,
     103,   105,   106,   112,   113,   115,   116,   123,   132,   139,
     140,   141,   142,   148,   149,   163,   175,   178,   179,   182,
     215,   216,   218,   248,   250,   257,   262,   263,   264,   273,
     280,   285,   296,   312,   324,   331,   341,   349,   350,   355,
     357,   358,   365,   371,   376,   392,   397,   398,   400,   406,
     407,   408,   410,   411,   415,   670,   709,   710,   711,   716,
     717,   718,   720,   721,   722,   723,   726,   727,   730,   732,
     733,   734,   738,   755,   760,   765,   766,   773,   783,   784,
     785,   786,   787,   788,   789,   798,   904,   907,   910,   915,
     916,   926,   927,   929,   930,   351,   402,   351,   402,   859,
     931,    85,   461,   776,   777,   323,   448,   151,   456,   794,
      98,   117,   448,   388,   631,   351,   417,   422,    98,   388,
     223,   632,   775,   913,   415,   775,   325,   408,   187,   651,
     416,   416,   418,   775,    85,   677,   677,   108,   677,   183,
     234,   268,   683,   689,   819,   408,   852,   853,   855,   419,
     419,    29,   215,   215,   351,   351,   351,   351,   351,   407,
     785,   786,   796,   821,   927,   169,   834,   852,    93,   808,
     108,   811,   811,   372,   869,   219,   869,   870,   396,   806,
     909,   423,   807,   804,   416,   933,   934,   932,   420,   421,
      42,   789,   796,   797,   871,   873,   874,   926,   215,   221,
     777,   351,   777,     6,   777,   903,   855,   762,   415,   281,
     302,   417,   561,   281,   302,   325,   459,    82,   164,   325,
     469,   281,   415,   590,    82,   164,   302,   281,   302,   325,
     467,   468,   302,   560,   415,   417,   281,   302,   517,    82,
      87,   122,   134,   164,   302,   325,   465,   466,   281,   302,
     271,   281,   302,   325,   383,   435,   459,   418,   232,   272,
     386,   421,   630,   730,   408,   780,   912,   761,   775,   783,
     415,   783,   265,   120,   736,   777,   777,   227,   777,   383,
     479,   415,   547,   118,   103,   105,   115,   116,   148,   149,
     182,   216,   218,   248,   250,   264,   296,   326,   331,   349,
     350,   376,   705,   708,   710,   711,   715,   717,   718,   719,
     721,   722,   726,   727,   904,   910,   915,   916,   930,   777,
     383,    93,   643,   383,   439,   560,   547,    98,   445,   281,
     527,    83,   100,   530,    93,   547,   383,   431,   775,   775,
     227,   560,   781,   909,   783,   777,   775,   104,   143,   212,
     253,   317,   382,   702,   415,   705,   590,   560,   415,   271,
     271,   421,   794,   111,   307,   421,   470,   862,   868,   872,
     150,   654,   656,   660,   665,   666,   669,   777,   872,   872,
     871,   922,   925,   929,    50,   881,   882,   929,   145,   190,
     227,   316,   343,   344,   575,   774,   574,   151,   375,   415,
     657,   669,   203,   421,   662,   777,   863,   184,   612,   612,
     232,   183,   271,   315,   909,   415,   413,   670,   745,   377,
     724,   730,   759,   415,   724,   724,   415,   415,   415,   764,
     415,   764,   415,   764,   415,   714,   714,   286,   670,   415,
     415,   712,   115,   116,   724,   730,   415,   415,   713,   415,
     415,   415,   415,   764,   415,   383,   384,   415,   728,   415,
     728,   415,   415,   670,   764,   763,   730,   730,   730,   730,
     670,   730,   741,   794,   116,   415,   725,   415,   794,    77,
      90,    93,    97,   102,   199,   203,   221,   222,   233,   257,
     260,   273,   275,   329,   392,   402,   403,   404,   406,   407,
     408,   409,   410,   411,   736,   738,   740,   730,   219,   421,
     674,   872,   762,   415,    26,   928,   929,   267,   271,   895,
     895,   859,   859,    12,    50,   884,   885,   886,   154,   200,
     462,   421,   117,   151,   457,   794,   909,    93,   151,   237,
     455,   727,   797,   930,   151,   179,   267,   271,   358,   450,
     451,   453,   454,   797,   909,   909,   450,   232,   221,   775,
     415,   767,   770,   909,   649,   415,   652,   670,   672,   673,
     672,   681,   682,   730,   672,   295,   369,    85,   685,   730,
     686,   730,   689,   690,   683,   684,   852,   408,   418,   421,
     914,   830,   833,   830,   215,   146,   198,   242,   318,   242,
     318,   318,   245,   242,   245,   318,   785,   786,   421,   822,
     150,   852,   418,   802,   371,   809,   811,   417,   790,   807,
     416,   420,   935,    18,   421,   839,   415,   777,   415,   913,
     408,   603,   705,   351,   351,   780,   417,   351,   351,   448,
     118,   129,   185,   289,   365,   494,   495,   129,   151,   257,
     151,   257,   351,   203,   210,   277,   416,   591,   592,   593,
     281,   302,   371,   371,   351,   351,   351,   344,   421,   351,
     372,   256,   605,   705,   606,   351,   351,   109,   144,   205,
     241,   243,   253,   306,   334,   518,   125,   494,   614,   614,
     271,   352,   129,   614,   351,   614,   384,   421,   351,   351,
     700,   351,   351,   448,   435,   135,   136,   203,   254,   255,
     283,   342,   374,   436,   295,   303,   322,   452,   630,   414,
     423,   415,   705,   590,   796,   560,   415,   221,   271,   271,
     560,   221,   269,   188,   351,   474,   548,   549,   912,   415,
     708,    93,    92,   413,   706,   146,   245,   387,   415,   729,
     561,    83,   167,   238,   281,   344,   346,   636,   637,   705,
     439,   342,   371,   440,   554,   799,   134,   446,   482,   515,
     529,   570,   582,   633,   777,   238,   156,   213,   369,   531,
     532,   415,   546,   435,   517,   266,   415,   512,   457,   183,
     271,   590,    93,   415,   496,   383,   384,   668,   317,   730,
     603,    93,   470,   372,   605,   775,   775,   799,   470,   560,
     872,   868,   777,   872,    18,   421,   928,   785,   792,   929,
     421,   402,   776,   580,   581,   783,   776,   776,   774,   776,
     351,   375,   415,   658,   659,   909,    80,   172,   312,   327,
     663,   775,   261,   664,   575,   909,   730,   741,   741,   744,
     745,   415,   381,   756,   757,   730,   741,   730,   741,   416,
     790,   790,   790,   146,   198,   242,   245,   318,   387,   742,
     746,   794,   930,   790,   724,   724,   730,   790,   606,   730,
     747,   407,   410,   411,   731,   732,   738,   749,   416,   741,
     730,   741,   750,   349,   349,   790,   790,   730,   107,   188,
     230,   353,   730,   741,   753,   761,   416,   421,   325,   790,
     790,   729,   705,   730,   912,   349,   731,   730,   415,   670,
     754,   160,   179,   257,   262,   266,   358,   366,   730,   102,
     199,   203,   233,   329,   415,   730,   351,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,    85,    91,   332,
     735,   192,   237,   343,   345,   347,   675,   775,   766,   188,
     692,    85,   160,   408,   416,   741,   777,   929,   792,   421,
     402,   777,   354,   415,   794,   421,   839,   416,   768,   909,
     421,   692,   763,   647,   775,   776,   421,    94,   159,   372,
     272,   266,   691,   268,   421,   234,   418,   853,   706,   420,
     833,   420,   796,   416,    39,   418,   810,   806,   409,   931,
     873,   706,   924,   934,   924,   706,   416,   799,   777,   780,
     799,   778,   415,   777,   225,   225,   415,   777,   262,   730,
     262,   799,   416,   421,   595,   597,   705,   904,   910,   911,
     915,   916,   930,   351,   351,   437,   437,   799,   799,   777,
     777,   468,   777,   779,   909,   421,   416,   421,   799,   777,
     796,   108,   519,   796,   796,   144,   241,   243,   431,   431,
     487,   909,   909,   777,   343,   777,   909,   777,   777,   122,
     269,   466,   799,   777,   302,   799,   799,   194,   789,   790,
     368,   128,   362,   295,   730,   603,    93,   221,   221,   372,
     605,   262,   569,   794,   560,   560,   221,   569,   337,   338,
     475,   794,   416,   421,   402,   730,    92,   706,   705,   413,
     414,   415,   707,   789,   790,   909,   351,   351,   790,   531,
     402,   638,   638,   638,   638,   638,   637,   488,   790,   437,
     183,   445,   483,   589,   789,   271,   275,   703,   704,   909,
     775,   233,   484,   485,   486,   487,   492,   494,   513,   514,
     909,    93,   383,   384,   511,   195,   794,   775,   308,   617,
     497,   498,   909,    93,   197,   197,   183,   416,   705,   779,
     416,   470,   470,   667,   931,   925,   888,   889,   929,   882,
     886,   421,   590,   194,   576,   577,   909,   151,   730,   771,
     772,   416,   421,   763,   172,   327,   172,   327,   312,   369,
     244,   188,   416,   421,   414,   414,   421,   790,   730,   166,
     757,   758,    93,   416,   372,   416,   416,   416,   416,   421,
     416,   188,   416,   421,   416,   421,   416,   284,   748,   416,
     731,   731,   731,    77,   203,   221,   273,   392,   402,   403,
     404,   406,   407,   408,   409,   410,   411,   738,   731,   416,
     416,   183,   188,   751,   752,   416,   388,   388,   416,   416,
      93,   753,   741,   753,   753,   188,   416,   763,   730,   909,
     416,   416,   388,    90,   170,   741,   188,   179,   262,   266,
     358,   366,   415,   170,   731,   730,   754,   730,   351,   606,
     730,   415,   670,   345,   347,   345,   347,   775,   676,   676,
     415,   670,   693,   694,   695,   700,   701,   733,   773,   702,
     741,   741,   416,   416,     8,    14,    15,    16,    26,    27,
      28,    30,    31,    32,    36,    37,    38,   286,   361,   891,
     892,   893,   885,   792,   631,   790,   729,   453,   706,   416,
     763,   770,   702,   402,   416,   682,   273,   736,   739,   776,
     686,   686,   685,   402,   854,   418,   778,    35,   899,   416,
     416,   418,   281,   302,   730,   495,   415,   415,   497,   470,
     592,   597,   561,   799,   777,   281,   302,   705,   281,   256,
     705,   796,   796,   796,   705,   164,   325,   361,   469,   470,
     470,   351,   351,   437,   789,   414,   416,   705,   569,   569,
     779,   416,   221,   221,   569,   372,   480,   481,   549,   273,
     407,   550,   596,   597,   739,   797,   416,   413,   416,   790,
     706,   707,   406,   407,   408,   409,   410,   414,   416,   271,
     151,   785,   789,   795,   927,   151,   794,   151,   777,   151,
     777,   151,   777,   118,   129,   151,   153,   208,   257,   262,
     289,   298,   365,   489,   490,   491,   361,   343,   775,   532,
     416,   421,   705,   415,   775,   416,   421,   416,   421,   269,
     269,   510,   522,   777,   351,   372,   584,   596,   271,   416,
     421,   669,   669,   864,   470,   416,   470,   470,   143,   421,
     402,   581,   909,   383,   421,   578,   416,   421,   375,   669,
     659,   172,   172,   576,   730,   745,   416,   348,   730,   169,
     705,   560,   790,   730,   730,   790,   730,   751,   705,   731,
     160,   257,   266,   731,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   730,   730,   752,   751,   728,   728,   705,
     416,   416,   416,   741,   416,   725,   794,   732,   731,   730,
     416,   730,   415,   705,   743,   730,    90,   170,   170,   730,
     416,   170,   730,   676,   676,   676,   676,   775,   775,   670,
     694,   695,    93,   696,   909,   421,   137,   189,   209,   224,
     231,   249,   310,   389,   697,   696,    93,   696,   909,   762,
     194,   687,   416,   416,   421,   402,   416,   899,   402,   421,
     151,   730,   415,   935,   392,   813,   351,   351,   416,   497,
     497,   416,   410,   351,   351,   351,   488,   257,   257,   336,
     339,   705,   777,   777,   221,   416,   221,   221,   569,   569,
     431,   158,   153,   208,   257,   539,   540,   541,   790,   383,
     384,   414,   416,   707,   707,   707,   707,   707,   706,   729,
     775,   415,   777,   731,   154,   200,   153,   262,   225,   775,
     372,   508,   705,   775,   183,   533,   275,   704,   484,   173,
     204,   493,   207,   504,   486,   514,   909,    93,    93,   669,
     226,   523,   561,   794,   779,   415,    93,   110,   177,   201,
     227,   308,   319,   333,   340,   380,   598,   599,   156,   213,
     320,   369,   622,   498,   470,   668,   889,   893,   193,   577,
     772,   415,   470,   730,   416,   416,   416,   416,   416,   752,
     188,   266,   415,   416,   729,   743,   416,   421,   731,   730,
     730,   170,   730,   416,   775,   775,   775,   775,   416,   909,
     415,   694,   224,   278,   698,   694,   698,   224,   697,   698,
     694,   224,   415,   909,   415,   108,   196,   688,   892,   407,
     786,   789,   792,   793,   794,   415,   768,   606,   909,   799,
     777,   416,   416,   508,   361,   799,   777,   799,   262,   262,
     790,   909,   372,   471,   569,   221,   569,   569,   476,   794,
     154,   200,   153,   541,   540,   414,   190,   190,   188,   538,
     730,   257,   490,   508,   496,   206,   372,   415,   165,   534,
     174,   532,   416,   152,   152,   415,   383,   384,   505,   794,
     188,   415,   585,   586,   733,   909,   594,   794,   271,   319,
     457,   262,   155,   220,   383,   599,   600,   351,   183,   274,
     771,   731,   415,   731,   416,   705,   730,   696,   415,   776,
     694,   271,   372,   699,   694,   224,   694,   703,   415,   703,
     909,   741,   730,   785,   786,   729,   730,   769,   416,   298,
     508,   730,   569,   104,   138,   157,   170,   184,   262,   269,
     294,   477,   581,    93,   608,   775,   539,   416,   240,   499,
     344,   779,   312,   335,   535,   293,   505,   774,   269,   269,
     271,   506,   560,   730,   416,   421,   372,   560,   587,   587,
     421,   262,   155,   220,   271,   547,   775,   416,   731,   416,
     776,   416,   730,   415,   694,   699,   416,   703,   416,   421,
     416,   775,   643,   643,   257,   294,   643,   643,   608,    96,
     183,   189,   282,   271,   500,   501,   502,   777,    93,   777,
     506,   416,   127,   344,   507,   416,   507,   586,   560,   794,
     211,   262,   702,   416,   416,   776,   416,   769,   496,   794,
     789,   262,   497,   794,   789,   165,   156,   369,   271,   502,
     271,   501,   190,   273,   339,   552,   553,   415,   507,   156,
     164,   287,   777,   587,   702,   211,   161,   416,   499,   497,
     312,   111,   253,   307,   325,   503,   503,   790,   790,   705,
     421,   536,   537,   798,   909,   313,   313,    86,   214,   623,
     500,   174,    81,   151,   262,   783,   606,   553,   416,   421,
     258,   415,   618,   620,   625,   656,   660,   665,   669,   539,
     293,   590,   297,   415,   555,   537,   619,   620,   621,   670,
     671,   783,   605,   416,   418,   415,   416,   621,   536,   555,
     416
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 597 "preproc.y"
    { connection = NULL; }
    break;

  case 7:
#line 600 "preproc.y"
    {
			fprintf(yyout, "%s", yyvsp[0].str);
                        free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 9:
#line 606 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 10:
#line 607 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 11:
#line 608 "preproc.y"
    { braces_open++; fputs("{", yyout); }
    break;

  case 12:
#line 609 "preproc.y"
    { remove_typedefs(braces_open); remove_variables(braces_open--); fputs("}", yyout); }
    break;

  case 13:
#line 613 "preproc.y"
    {
			connection = yyvsp[0].str;
			/*
			 *	Do we have a variable as connection target?
			 *	Remove the variable from the variable
			 *	list or else it will be used twice
			 */
			if (argsinsert != NULL)
				argsinsert = NULL;
		}
    break;

  case 14:
#line 624 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 15:
#line 625 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 16:
#line 626 "preproc.y"
    