.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE TRIGGER" "l" "2001-09-13" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TRIGGER \- define a new trigger
.SH SYNOPSIS
.sp
.nf
CREATE TRIGGER \fIname\fR { BEFORE | AFTER } { \fIevent\fR [OR ...] }
    ON \fItable\fR FOR EACH { ROW | STATEMENT }
    EXECUTE PROCEDURE \fIfunc\fR ( \fIarguments\fR )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name to give the new trigger.
.TP
\fB\fItable\fB\fR
The name of an existing table.
.TP
\fB\fIevent\fB\fR
One of INSERT, DELETE or UPDATE.
.TP
\fB\fIfunc\fB\fR
A user-supplied function.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
This message is returned if the trigger is successfully created.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE TRIGGER\fR will enter a new trigger into the current
data base. The trigger will be associated with the relation
\fItable\fR and will execute
the specified function \fIfunc\fR.
.PP
The trigger can be specified to fire either before BEFORE the
operation is attempted on a tuple (before constraints
are checked and the \fBINSERT\fR, \fBUPDATE\fR or
\fBDELETE\fR is attempted) or
AFTER the operation has been attempted (e.g., after constraints
are checked and the \fBINSERT\fR,
\fBUPDATE\fR or \fBDELETE\fR has
completed). If the
trigger fires before the event, the trigger may
skip the operation for the current tuple, or change the tuple
being inserted (for \fBINSERT\fR and
\fBUPDATE\fR operations only). If
the trigger fires after the event, all changes, including the
last insertion, update, or deletion, are ``visible'' to the trigger.
.PP
Refer to the chapters on SPI and Triggers in the
\fIPostgreSQL Programmer's Guide\fR for more
information.
.SH "NOTES"
.PP
To create a trigger on a table, the user must have the
TRIGGER privilege on the table.
.PP
As of the current release, STATEMENT triggers are not implemented.
.PP
Refer to the \fBdrop_trigger\fR(l) command for
information on how to remove triggers.
.SH "EXAMPLES"
.PP
Check if the specified distributor code exists in the distributors
table before appending or updating a row in the table films:
.sp
.nf
CREATE TRIGGER if_dist_exists
    BEFORE INSERT OR UPDATE ON films FOR EACH ROW
    EXECUTE PROCEDURE check_primary_key ('did', 'distributors', 'did');
.sp
.fi
.PP
Before cancelling a distributor or updating its code, remove every
reference to the table films:
.sp
.nf
CREATE TRIGGER if_film_exists 
    BEFORE DELETE OR UPDATE ON distributors FOR EACH ROW
    EXECUTE PROCEDURE check_foreign_key (1, 'CASCADE', 'did', 'films', 'did');
.sp
.fi
.PP
The second example can also be done by using a foreign key,
constraint as in:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40),
    CONSTRAINT if_film_exists
    FOREIGN KEY(did) REFERENCES films
    ON UPDATE CASCADE ON DELETE CASCADE  
);
.sp
.fi
.SH "COMPATIBILITY"
.TP
\fBSQL92\fR
There is no \fBCREATE TRIGGER\fR statement in SQL92.
.TP
\fBSQL99\fR
The \fBCREATE TRIGGER\fR statement in
PostgreSQL implements a subset of the
SQL99 standard. The following functionality is missing:
.RS
.TP 0.2i
\(bu
SQL99 allows triggers to fire on updates to specific columns
(e.g., AFTER UPDATE OF col1, col2).
.TP 0.2i
\(bu
SQL99 allows you to define aliases for the ``old''
and ``new'' rows or tables for use in the definiton
of the triggered action (e.g., CREATE TRIGGER ... ON
tablename REFERENCING OLD ROW AS somename NEW ROW AS
othername ...). Since
PostgreSQL allows trigger
procedures to be written in any number of user-defined
languages, access to the data is handled in a
language-specific way.
.TP 0.2i
\(bu
PostgreSQL only has row-level
triggers, no statement-level triggers.
.TP 0.2i
\(bu
PostgreSQL only allows the
execution of a stored procedure for the triggered action.
SQL99 allows the execution of a number of other SQL commands,
such as \fBCREATE TABLE\fR as triggered action.
This limitation is not hard to work around by creating a
stored procedure that executes these commands.
.RE
.PP
.SH "SEE ALSO"
\fBcreate_function\fR(l), \fBdrop_trigger\fR(l), \fIPostgreSQL Programmer's Guide\fR

