.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_FUNCTION" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
CREATE FUNCTION \- Defines a new function
.SH SYNOPSIS
.sp
.nf
CREATE FUNCTION \fIname\fR ( [ \fIftype\fR [, ...] ] )
    RETURNS \fIrtype\fR
    AS \fIdefinition\fR   
    LANGUAGE '\fIlangname\fR'
    [ WITH ( \fIattribute\fR [, ...] ) ]
CREATE FUNCTION \fIname\fR ( [ \fIftype\fR [, ...] ] )
    RETURNS \fIrtype\fR
    AS \fIobj_file\fR , \fIlink_symbol\fR  
    LANGUAGE 'C'
    [ WITH ( \fIattribute\fR [, ...] ) ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a function to create.
.TP
\fB\fIftype\fB\fR
The data type of function arguments.
The input types may be base or complex types, or
\fIopaque\fR.
opaque indicates that the function
accepts arguments of an invalid type such as \fBchar *\fR.
.TP
\fB\fIrtype\fB\fR
The return data type.
The output type may be specified as a base type, complex type, 
setof \fItype\fR,
or opaque.
The setof
modifier indicates that the function will return a set of items,
rather than a single item.
.TP
\fB\fIattribute\fB\fR
An optional piece of information about the function, used for
optimization. The only attribute currently supported is
iscachable.
iscachable indicates that the function always
returns the same result when given the same input values (i.e.,
it does not do database lookups or otherwise use information not
directly present in its parameter list). The optimizer uses
iscachable to know whether it is safe to
pre-evaluate a call of the function.
.TP
\fB\fIdefinition\fB\fR
A string defining the function; the meaning depends on the language.
It may be an internal function name, the path to an object file,
an SQL query, or text in a procedural language.
.TP
\fB\fIobj_file\fB , \fIlink_symbol\fB\fR
This form of the \fBAS\fR clause is used for
dynamically-linked, C language functions when the function name in
the C language source code is not the same as the name of the SQL
function. The string \fIobj_file\fR is the name of the file
containing the dynamically loadable object, and \fIlink_symbol\fR, is the object's link
symbol which is the same as the name of the function in the C
language source code.
.TP
\fB\fIlangname\fB\fR
may be 'C', 'sql',
\&'internal'
or '\fIplname\fR',
where '\fIplname\fR'
is the name of a created procedural language. See
\fBcreate_language\fR(l)
for details.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
This is returned if the command completes successfully.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE FUNCTION\fR allows a
Postgres user
to register a function
with a database. Subsequently, this user is considered the
owner of the function.
.SS "NOTES"
.PP
Refer to the chapter in the
\fIPostgreSQL Programmer's Guide\fR
on the topic of extending
Postgres via functions 
for further information on writing external functions.
.PP
Use \fBDROP FUNCTION\fR
to remove user-defined functions.
.PP
Postgres allows function "overloading";
that is, the same name can be used for several different functions
so long as they have distinct argument types. This facility must
be used with caution for internal and
C-language functions, however. 
.PP
The full SQL92 type syntax is allowed for
input arguments and return value. However, some details of the
type specification (e.g. the precision field for
\fBnumeric\fR types) are the responsibility of the
underlying function implementation and are silently swallowed
(e.g. not recognized or
enforced) by the \fBCREATE FUNCTION\fR command.
.PP
Two internal
functions cannot have the same C name without causing
errors at link time. To get around that, give them different C names
(for example, use the argument types as part of the C names), then
specify those names in the AS clause of \fBCREATE FUNCTION\fR.
If the AS clause is left empty then \fBCREATE FUNCTION\fR
assumes the C name of the function is the same as the SQL name.
.PP
When overloading SQL functions with C-language functions, give
each C-language instance of the function a distinct name, and use
the alternative form of the \fBAS\fR clause in the
\fBCREATE FUNCTION\fR syntax to ensure that
overloaded SQL functions names are resolved to the correct
dynamically linked objects.
.PP
A C function cannot return a set of values.
.SH "USAGE"
.PP
To create a simple SQL function:
.sp
.nf
CREATE FUNCTION one() RETURNS int4
    AS 'SELECT 1 AS RESULT'
    LANGUAGE 'sql';
SELECT one() AS answer;

     answer 
--------
      1
    
   
.sp
.fi
.PP
This example creates a C function by calling a routine from a user-created
shared library. This particular routine calculates a check
digit and returns TRUE if the check digit in the function parameters
is correct. It is intended for use in a CHECK contraint.
.sp
.nf
CREATE FUNCTION ean_checkdigit(bpchar, bpchar) RETURNS bool
    AS '/usr1/proj/bray/sql/funcs.so' LANGUAGE 'c';
    
CREATE TABLE product (
    id        char(8) PRIMARY KEY,
    eanprefix char(8) CHECK (eanprefix ~ '[0-9]{2}-[0-9]{5}')
                      REFERENCES brandname(ean_prefix),
    eancode   char(6) CHECK (eancode ~ '[0-9]{6}'),
    CONSTRAINT ean    CHECK (ean_checkdigit(eanprefix, eancode))
);
  
.sp
.fi
.PP
This example creates a function that does type conversion between the
user defined type complex, and the internal type point. The
function is implemented by a dynamically loaded object that was
compiled from C source. For Postgres to
find a type conversion function automatically, the sql function has
to have the same name as the return type, and overloading is
unavoidable. The function name is overloaded by using the second
form of the \fBAS\fR clause in the SQL definition
.sp
.nf
CREATE FUNCTION point(complex) RETURNS point
    AS '/home/bernie/pgsql/lib/complex.so', 'complex_to_point'
    LANGUAGE 'c';
  
.sp
.fi
.PP
The C decalaration of the function is:
.sp
.nf
Point * complex_to_point (Complex *z)
{
	Point *p;

	p = (Point *) palloc(sizeof(Point));
	p->x = z->x;
	p->y = z->y;
		
	return p;
}
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE FUNCTION\fR is
a Postgres language extension.
.SS "SQL/PSM"
.PP
.sp
.RS
.B "Note:"
PSM stands for Persistent Stored Modules. It is a procedural
language and it was originally hoped that PSM would be ratified
as an official standard by late 1996. As of mid-1998, this
has not yet happened, but it is hoped that PSM will
eventually become a standard.
.RE
.sp
SQL/PSM \fBCREATE FUNCTION\fR has the following syntax:
.sp
.nf
CREATE FUNCTION \fIname\fR
    ( [ [ IN | OUT | INOUT ] \fItype\fR [, ...] ] )
     RETURNS \fIrtype\fR
     LANGUAGE '\fIlangname\fR'
     ESPECIFIC \fIroutine\fR
     \fISQL-statement\fR
    
.sp
.fi
