/*
 * Written by Alexei V. Galatenko <agalat@castle.nmd.msu.ru>
 */

#include <unistd.h>
#include <grp.h>
#include <sys/types.h>

#include <pniam.h>

pniam_result_t set_groups (pniam_item_list_t *list)
{
    pniam_item_t *item;
    int val;

    item = pniam_item_list_find (list, "GID");
    if ((item == NULL)||(item->data == NULL))
        return PNIAM_SYSERR;
    val = setgid (*((gid_t *)(item->data)));
    if (val == -1)
        return PNIAM_SYSERR;

    item = pniam_item_list_find (list, "SUP_GROUPS");
    if ((item == NULL)||(item->data == NULL))
        return PNIAM_SYSERR;
    if (item->len > 0) {
        val = setgroups (item->len/sizeof (gid_t), 
			(const gid_t *)(item->data));
        if (val == -1)
            return PNIAM_SYSERR; 
    }
    return PNIAM_OK;  
}
