// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, FwIsoResource};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    /// An object to initiate requests and listen events of isochronous resource allocation/deallocation
    /// by one shot.
    ///
    /// The [`FwIsoResourceOnce`][crate::FwIsoResourceOnce] is an object to initiate requests and listen events of isochronous
    /// resource allocation/deallocation by file descriptor owned internally. The allocated resource
    /// is left even if this object is destroyed, thus application is responsible for deallocation.
    ///
    /// # Implements
    ///
    /// [`FwIsoResourceOnceExt`][trait@crate::prelude::FwIsoResourceOnceExt], [`FwIsoResourceExt`][trait@crate::prelude::FwIsoResourceExt]
    #[doc(alias = "HinokoFwIsoResourceOnce")]
    pub struct FwIsoResourceOnce(Object<ffi::HinokoFwIsoResourceOnce, ffi::HinokoFwIsoResourceOnceClass>) @implements FwIsoResource;

    match fn {
        type_ => || ffi::hinoko_fw_iso_resource_once_get_type(),
    }
}

impl FwIsoResourceOnce {
    pub const NONE: Option<&'static FwIsoResourceOnce> = None;

    /// Allocate and return an instance of [`FwIsoResourceOnce`][crate::FwIsoResourceOnce].
    ///
    /// # Returns
    ///
    /// A [`FwIsoResourceOnce`][crate::FwIsoResourceOnce].
    #[doc(alias = "hinoko_fw_iso_resource_once_new")]
    pub fn new() -> FwIsoResourceOnce {
        unsafe { from_glib_full(ffi::hinoko_fw_iso_resource_once_new()) }
    }
}

impl Default for FwIsoResourceOnce {
    fn default() -> Self {
        Self::new()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::FwIsoResourceOnce>> Sealed for T {}
}

/// Trait containing all [`struct@FwIsoResourceOnce`] methods.
///
/// # Implementors
///
/// [`FwIsoResourceOnce`][struct@crate::FwIsoResourceOnce]
pub trait FwIsoResourceOnceExt: IsA<FwIsoResourceOnce> + sealed::Sealed + 'static {
    /// Initiate deallocation of isochronous resource without any wait. When the
    /// deallocation finishes, [`deallocated`][struct@crate::FwIsoResource#deallocated] signal is emit to notify the result,
    /// channel, and bandwidth.
    /// ## `channel`
    /// The channel number to be deallocated.
    /// ## `bandwidth`
    /// The amount of bandwidth to be deallocated.
    ///
    /// # Returns
    ///
    /// TRUE if the overall operation finishes successfully, otherwise FALSE.
    #[doc(alias = "hinoko_fw_iso_resource_once_deallocate")]
    fn deallocate(&self, channel: u32, bandwidth: u32) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::hinoko_fw_iso_resource_once_deallocate(
                self.as_ref().to_glib_none().0,
                channel,
                bandwidth,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    /// Initiate deallocation of isochronous resource and wait for [`deallocated`][struct@crate::FwIsoResource#deallocated]
    /// signal.
    /// ## `channel`
    /// The channel number to be deallocated.
    /// ## `bandwidth`
    /// The amount of bandwidth to be deallocated.
    /// ## `timeout_ms`
    /// The timeout to wait for deallocated event.
    ///
    /// # Returns
    ///
    /// TRUE if the overall operation finishes successfully, otherwise FALSE.
    #[doc(alias = "hinoko_fw_iso_resource_once_deallocate_wait")]
    fn deallocate_wait(
        &self,
        channel: u32,
        bandwidth: u32,
        timeout_ms: u32,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::hinoko_fw_iso_resource_once_deallocate_wait(
                self.as_ref().to_glib_none().0,
                channel,
                bandwidth,
                timeout_ms,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl<O: IsA<FwIsoResourceOnce>> FwIsoResourceOnceExt for O {}
