/*
 * OMAP54xx Power Management register bits
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_PRM_REGBITS_54XX_H
#define __ARCH_ARM_MACH_OMAP2_PRM_REGBITS_54XX_H

/* Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP */
#define OMAP54XX_ABBOFF_ACT_SHIFT						1
#define OMAP54XX_ABBOFF_ACT_WIDTH						0x1
#define OMAP54XX_ABBOFF_ACT_MASK						(1 << 1)

/* Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP */
#define OMAP54XX_ABBOFF_SLEEP_SHIFT						2
#define OMAP54XX_ABBOFF_SLEEP_WIDTH						0x1
#define OMAP54XX_ABBOFF_SLEEP_MASK						(1 << 2)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_ABB_MM_DONE_EN_SHIFT						31
#define OMAP54XX_ABB_MM_DONE_EN_WIDTH						0x1
#define OMAP54XX_ABB_MM_DONE_EN_MASK						(1 << 31)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_ABB_MM_DONE_ST_SHIFT						31
#define OMAP54XX_ABB_MM_DONE_ST_WIDTH						0x1
#define OMAP54XX_ABB_MM_DONE_ST_MASK						(1 << 31)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP54XX_ABB_MPU_DONE_EN_SHIFT						7
#define OMAP54XX_ABB_MPU_DONE_EN_WIDTH						0x1
#define OMAP54XX_ABB_MPU_DONE_EN_MASK						(1 << 7)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP54XX_ABB_MPU_DONE_ST_SHIFT						7
#define OMAP54XX_ABB_MPU_DONE_ST_WIDTH						0x1
#define OMAP54XX_ABB_MPU_DONE_ST_MASK						(1 << 7)

/* Used by PRM_ABBLDO_MM_SETUP, PRM_ABBLDO_MPU_SETUP */
#define OMAP54XX_ACTIVE_FBB_SEL_SHIFT						2
#define OMAP54XX_ACTIVE_FBB_SEL_WIDTH						0x1
#define OMAP54XX_ACTIVE_FBB_SEL_MASK						(1 << 2)

/* Used by PM_ABE_PWRSTCTRL */
#define OMAP54XX_AESSMEM_ONSTATE_SHIFT						16
#define OMAP54XX_AESSMEM_ONSTATE_WIDTH						0x2
#define OMAP54XX_AESSMEM_ONSTATE_MASK						(0x3 << 16)

/* Used by PM_ABE_PWRSTCTRL */
#define OMAP54XX_AESSMEM_RETSTATE_SHIFT						8
#define OMAP54XX_AESSMEM_RETSTATE_WIDTH						0x1
#define OMAP54XX_AESSMEM_RETSTATE_MASK						(1 << 8)

/* Used by PM_ABE_PWRSTST */
#define OMAP54XX_AESSMEM_STATEST_SHIFT						4
#define OMAP54XX_AESSMEM_STATEST_WIDTH						0x2
#define OMAP54XX_AESSMEM_STATEST_MASK						(0x3 << 4)

/* Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP */
#define OMAP54XX_AIPOFF_SHIFT							8
#define OMAP54XX_AIPOFF_WIDTH							0x1
#define OMAP54XX_AIPOFF_MASK							(1 << 8)

/* Used by PRM_VOLTCTRL */
#define OMAP54XX_AUTO_CTRL_VDD_CORE_L_SHIFT					0
#define OMAP54XX_AUTO_CTRL_VDD_CORE_L_WIDTH					0x2
#define OMAP54XX_AUTO_CTRL_VDD_CORE_L_MASK					(0x3 << 0)

/* Used by PRM_VOLTCTRL */
#define OMAP54XX_AUTO_CTRL_VDD_MM_L_SHIFT					4
#define OMAP54XX_AUTO_CTRL_VDD_MM_L_WIDTH					0x2
#define OMAP54XX_AUTO_CTRL_VDD_MM_L_MASK					(0x3 << 4)

/* Used by PRM_VOLTCTRL */
#define OMAP54XX_AUTO_CTRL_VDD_MPU_L_SHIFT					2
#define OMAP54XX_AUTO_CTRL_VDD_MPU_L_WIDTH					0x2
#define OMAP54XX_AUTO_CTRL_VDD_MPU_L_MASK					(0x3 << 2)

/* Used by PRM_VC_BYPASS_ERRST */
#define OMAP54XX_BYPS_RA_ERR_SHIFT						1
#define OMAP54XX_BYPS_RA_ERR_WIDTH						0x1
#define OMAP54XX_BYPS_RA_ERR_MASK						(1 << 1)

/* Used by PRM_VC_BYPASS_ERRST */
#define OMAP54XX_BYPS_SA_ERR_SHIFT						0
#define OMAP54XX_BYPS_SA_ERR_WIDTH						0x1
#define OMAP54XX_BYPS_SA_ERR_MASK						(1 << 0)

/* Used by PRM_VC_BYPASS_ERRST */
#define OMAP54XX_BYPS_TIMEOUT_ERR_SHIFT						2
#define OMAP54XX_BYPS_TIMEOUT_ERR_WIDTH						0x1
#define OMAP54XX_BYPS_TIMEOUT_ERR_MASK						(1 << 2)

/* Used by PRM_RSTST */
#define OMAP54XX_C2C_RST_SHIFT							10
#define OMAP54XX_C2C_RST_WIDTH							0x1
#define OMAP54XX_C2C_RST_MASK							(1 << 10)

/* Used by PM_CAM_PWRSTCTRL */
#define OMAP54XX_CAM_MEM_ONSTATE_SHIFT						16
#define OMAP54XX_CAM_MEM_ONSTATE_WIDTH						0x2
#define OMAP54XX_CAM_MEM_ONSTATE_MASK						(0x3 << 16)

/* Used by PM_CAM_PWRSTST */
#define OMAP54XX_CAM_MEM_STATEST_SHIFT						4
#define OMAP54XX_CAM_MEM_STATEST_WIDTH						0x2
#define OMAP54XX_CAM_MEM_STATEST_MASK						(0x3 << 4)

/* Used by PRM_CLKREQCTRL */
#define OMAP54XX_CLKREQ_COND_SHIFT						0
#define OMAP54XX_CLKREQ_COND_WIDTH						0x3
#define OMAP54XX_CLKREQ_COND_MASK						(0x7 << 0)

/* Used by PRM_VC_SMPS_CORE_CONFIG */
#define OMAP54XX_CMDRA_VDD_CORE_L_SHIFT						16
#define OMAP54XX_CMDRA_VDD_CORE_L_WIDTH						0x8
#define OMAP54XX_CMDRA_VDD_CORE_L_MASK						(0xff << 16)

/* Used by PRM_VC_SMPS_MM_CONFIG */
#define OMAP54XX_CMDRA_VDD_MM_L_SHIFT						16
#define OMAP54XX_CMDRA_VDD_MM_L_WIDTH						0x8
#define OMAP54XX_CMDRA_VDD_MM_L_MASK						(0xff << 16)

/* Used by PRM_VC_SMPS_MPU_CONFIG */
#define OMAP54XX_CMDRA_VDD_MPU_L_SHIFT						16
#define OMAP54XX_CMDRA_VDD_MPU_L_WIDTH						0x8
#define OMAP54XX_CMDRA_VDD_MPU_L_MASK						(0xff << 16)

/* Used by PRM_VC_SMPS_CORE_CONFIG */
#define OMAP54XX_CMD_VDD_CORE_L_SHIFT						28
#define OMAP54XX_CMD_VDD_CORE_L_WIDTH						0x1
#define OMAP54XX_CMD_VDD_CORE_L_MASK						(1 << 28)

/* Used by PRM_VC_SMPS_MM_CONFIG */
#define OMAP54XX_CMD_VDD_MM_L_SHIFT						28
#define OMAP54XX_CMD_VDD_MM_L_WIDTH						0x1
#define OMAP54XX_CMD_VDD_MM_L_MASK						(1 << 28)

/* Used by PRM_VC_SMPS_MPU_CONFIG */
#define OMAP54XX_CMD_VDD_MPU_L_SHIFT						28
#define OMAP54XX_CMD_VDD_MPU_L_WIDTH						0x1
#define OMAP54XX_CMD_VDD_MPU_L_MASK						(1 << 28)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_CORE_OCMRAM_ONSTATE_SHIFT					18
#define OMAP54XX_CORE_OCMRAM_ONSTATE_WIDTH					0x2
#define OMAP54XX_CORE_OCMRAM_ONSTATE_MASK					(0x3 << 18)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_CORE_OCMRAM_RETSTATE_SHIFT					9
#define OMAP54XX_CORE_OCMRAM_RETSTATE_WIDTH					0x1
#define OMAP54XX_CORE_OCMRAM_RETSTATE_MASK					(1 << 9)

/* Used by PM_CORE_PWRSTST */
#define OMAP54XX_CORE_OCMRAM_STATEST_SHIFT					6
#define OMAP54XX_CORE_OCMRAM_STATEST_WIDTH					0x2
#define OMAP54XX_CORE_OCMRAM_STATEST_MASK					(0x3 << 6)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_CORE_OTHER_BANK_ONSTATE_SHIFT					16
#define OMAP54XX_CORE_OTHER_BANK_ONSTATE_WIDTH					0x2
#define OMAP54XX_CORE_OTHER_BANK_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_CORE_OTHER_BANK_RETSTATE_SHIFT					8
#define OMAP54XX_CORE_OTHER_BANK_RETSTATE_WIDTH					0x1
#define OMAP54XX_CORE_OTHER_BANK_RETSTATE_MASK					(1 << 8)

/* Used by PM_CORE_PWRSTST */
#define OMAP54XX_CORE_OTHER_BANK_STATEST_SHIFT					4
#define OMAP54XX_CORE_OTHER_BANK_STATEST_WIDTH					0x2
#define OMAP54XX_CORE_OTHER_BANK_STATEST_MASK					(0x3 << 4)

/* Used by REVISION_PRM */
#define OMAP54XX_CUSTOM_SHIFT							6
#define OMAP54XX_CUSTOM_WIDTH							0x2
#define OMAP54XX_CUSTOM_MASK							(0x3 << 6)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP54XX_DATA_SHIFT							16
#define OMAP54XX_DATA_WIDTH							0x8
#define OMAP54XX_DATA_MASK							(0xff << 16)

/* Used by PRM_DEBUG_CORE_RET_TRANS */
#define OMAP54XX_PRM_DEBUG_OUT_SHIFT						0
#define OMAP54XX_PRM_DEBUG_OUT_WIDTH						0x1c
#define OMAP54XX_PRM_DEBUG_OUT_MASK						(0xfffffff << 0)

/* Renamed from DEBUG_OUT Used by PRM_DEBUG_MM_RET_TRANS */
#define OMAP54XX_DEBUG_OUT_0_9_SHIFT						0
#define OMAP54XX_DEBUG_OUT_0_9_WIDTH						0xa
#define OMAP54XX_DEBUG_OUT_0_9_MASK						(0x3ff << 0)

/* Renamed from DEBUG_OUT Used by PRM_DEBUG_MPU_RET_TRANS */
#define OMAP54XX_DEBUG_OUT_0_6_SHIFT						0
#define OMAP54XX_DEBUG_OUT_0_6_WIDTH						0x7
#define OMAP54XX_DEBUG_OUT_0_6_MASK						(0x7f << 0)

/* Renamed from DEBUG_OUT Used by PRM_DEBUG_OFF_TRANS */
#define OMAP54XX_DEBUG_OUT_0_31_SHIFT						0
#define OMAP54XX_DEBUG_OUT_0_31_WIDTH						0x20
#define OMAP54XX_DEBUG_OUT_0_31_MASK						(0xffffffff << 0)

/* Renamed from DEBUG_OUT Used by PRM_DEBUG_WKUPAON_FD_TRANS */
#define OMAP54XX_DEBUG_OUT_0_11_SHIFT						0
#define OMAP54XX_DEBUG_OUT_0_11_WIDTH						0xc
#define OMAP54XX_DEBUG_OUT_0_11_MASK						(0xfff << 0)

/* Used by PRM_DEVICE_OFF_CTRL */
#define OMAP54XX_DEVICE_OFF_ENABLE_SHIFT					0
#define OMAP54XX_DEVICE_OFF_ENABLE_WIDTH					0x1
#define OMAP54XX_DEVICE_OFF_ENABLE_MASK						(1 << 0)

/* Used by PRM_VC_CFG_I2C_MODE */
#define OMAP54XX_DFILTEREN_SHIFT						6
#define OMAP54XX_DFILTEREN_WIDTH						0x1
#define OMAP54XX_DFILTEREN_MASK							(1 << 6)

/* Used by PRM_IRQENABLE_DSP, PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_DPLL_ABE_RECAL_EN_SHIFT					4
#define OMAP54XX_DPLL_ABE_RECAL_EN_WIDTH					0x1
#define OMAP54XX_DPLL_ABE_RECAL_EN_MASK						(1 << 4)

/* Used by PRM_IRQSTATUS_DSP, PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_DPLL_ABE_RECAL_ST_SHIFT					4
#define OMAP54XX_DPLL_ABE_RECAL_ST_WIDTH					0x1
#define OMAP54XX_DPLL_ABE_RECAL_ST_MASK						(1 << 4)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_DPLL_CORE_RECAL_EN_SHIFT					0
#define OMAP54XX_DPLL_CORE_RECAL_EN_WIDTH					0x1
#define OMAP54XX_DPLL_CORE_RECAL_EN_MASK					(1 << 0)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_DPLL_CORE_RECAL_ST_SHIFT					0
#define OMAP54XX_DPLL_CORE_RECAL_ST_WIDTH					0x1
#define OMAP54XX_DPLL_CORE_RECAL_ST_MASK					(1 << 0)

/* Used by PRM_IRQENABLE_DSP, PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_DPLL_IVA_RECAL_EN_SHIFT					2
#define OMAP54XX_DPLL_IVA_RECAL_EN_WIDTH					0x1
#define OMAP54XX_DPLL_IVA_RECAL_EN_MASK						(1 << 2)

/* Used by PRM_IRQSTATUS_DSP, PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_DPLL_IVA_RECAL_ST_SHIFT					2
#define OMAP54XX_DPLL_IVA_RECAL_ST_WIDTH					0x1
#define OMAP54XX_DPLL_IVA_RECAL_ST_MASK						(1 << 2)

/* Used by PRM_IRQENABLE_MPU */
#define OMAP54XX_DPLL_MPU_RECAL_EN_SHIFT					1
#define OMAP54XX_DPLL_MPU_RECAL_EN_WIDTH					0x1
#define OMAP54XX_DPLL_MPU_RECAL_EN_MASK						(1 << 1)

/* Used by PRM_IRQSTATUS_MPU */
#define OMAP54XX_DPLL_MPU_RECAL_ST_SHIFT					1
#define OMAP54XX_DPLL_MPU_RECAL_ST_WIDTH					0x1
#define OMAP54XX_DPLL_MPU_RECAL_ST_MASK						(1 << 1)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_DPLL_PER_RECAL_EN_SHIFT					3
#define OMAP54XX_DPLL_PER_RECAL_EN_WIDTH					0x1
#define OMAP54XX_DPLL_PER_RECAL_EN_MASK						(1 << 3)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_DPLL_PER_RECAL_ST_SHIFT					3
#define OMAP54XX_DPLL_PER_RECAL_ST_WIDTH					0x1
#define OMAP54XX_DPLL_PER_RECAL_ST_MASK						(1 << 3)

/* Used by PM_DSP_PWRSTCTRL */
#define OMAP54XX_DSP_EDMA_ONSTATE_SHIFT						20
#define OMAP54XX_DSP_EDMA_ONSTATE_WIDTH						0x2
#define OMAP54XX_DSP_EDMA_ONSTATE_MASK						(0x3 << 20)

/* Used by PM_DSP_PWRSTCTRL */
#define OMAP54XX_DSP_EDMA_RETSTATE_SHIFT					10
#define OMAP54XX_DSP_EDMA_RETSTATE_WIDTH					0x1
#define OMAP54XX_DSP_EDMA_RETSTATE_MASK						(1 << 10)

/* Used by PM_DSP_PWRSTST */
#define OMAP54XX_DSP_EDMA_STATEST_SHIFT						8
#define OMAP54XX_DSP_EDMA_STATEST_WIDTH						0x2
#define OMAP54XX_DSP_EDMA_STATEST_MASK						(0x3 << 8)

/* Used by PM_DSP_PWRSTCTRL */
#define OMAP54XX_DSP_L1_ONSTATE_SHIFT						16
#define OMAP54XX_DSP_L1_ONSTATE_WIDTH						0x2
#define OMAP54XX_DSP_L1_ONSTATE_MASK						(0x3 << 16)

/* Used by PM_DSP_PWRSTCTRL */
#define OMAP54XX_DSP_L1_RETSTATE_SHIFT						8
#define OMAP54XX_DSP_L1_RETSTATE_WIDTH						0x1
#define OMAP54XX_DSP_L1_RETSTATE_MASK						(1 << 8)

/* Used by PM_DSP_PWRSTST */
#define OMAP54XX_DSP_L1_STATEST_SHIFT						4
#define OMAP54XX_DSP_L1_STATEST_WIDTH						0x2
#define OMAP54XX_DSP_L1_STATEST_MASK						(0x3 << 4)

/* Used by PM_DSP_PWRSTCTRL */
#define OMAP54XX_DSP_L2_ONSTATE_SHIFT						18
#define OMAP54XX_DSP_L2_ONSTATE_WIDTH						0x2
#define OMAP54XX_DSP_L2_ONSTATE_MASK						(0x3 << 18)

/* Used by PM_DSP_PWRSTCTRL */
#define OMAP54XX_DSP_L2_RETSTATE_SHIFT						9
#define OMAP54XX_DSP_L2_RETSTATE_WIDTH						0x1
#define OMAP54XX_DSP_L2_RETSTATE_MASK						(1 << 9)

/* Used by PM_DSP_PWRSTST */
#define OMAP54XX_DSP_L2_STATEST_SHIFT						6
#define OMAP54XX_DSP_L2_STATEST_WIDTH						0x2
#define OMAP54XX_DSP_L2_STATEST_MASK						(0x3 << 6)

/* Used by PM_DSS_PWRSTCTRL */
#define OMAP54XX_DSS_MEM_ONSTATE_SHIFT						16
#define OMAP54XX_DSS_MEM_ONSTATE_WIDTH						0x2
#define OMAP54XX_DSS_MEM_ONSTATE_MASK						(0x3 << 16)

/* Used by PM_DSS_PWRSTCTRL */
#define OMAP54XX_DSS_MEM_RETSTATE_SHIFT						8
#define OMAP54XX_DSS_MEM_RETSTATE_WIDTH						0x1
#define OMAP54XX_DSS_MEM_RETSTATE_MASK						(1 << 8)

/* Used by PM_DSS_PWRSTST */
#define OMAP54XX_DSS_MEM_STATEST_SHIFT						4
#define OMAP54XX_DSS_MEM_STATEST_WIDTH						0x2
#define OMAP54XX_DSS_MEM_STATEST_MASK						(0x3 << 4)

/* Used by PRM_DEVICE_OFF_CTRL */
#define OMAP54XX_EMIF1_OFFWKUP_DISABLE_SHIFT					8
#define OMAP54XX_EMIF1_OFFWKUP_DISABLE_WIDTH					0x1
#define OMAP54XX_EMIF1_OFFWKUP_DISABLE_MASK					(1 << 8)

/* Used by PRM_DEVICE_OFF_CTRL */
#define OMAP54XX_EMIF2_OFFWKUP_DISABLE_SHIFT					9
#define OMAP54XX_EMIF2_OFFWKUP_DISABLE_WIDTH					0x1
#define OMAP54XX_EMIF2_OFFWKUP_DISABLE_MASK					(1 << 9)

/* Used by PM_EMU_PWRSTCTRL */
#define OMAP54XX_EMU_BANK_ONSTATE_SHIFT						16
#define OMAP54XX_EMU_BANK_ONSTATE_WIDTH						0x2
#define OMAP54XX_EMU_BANK_ONSTATE_MASK						(0x3 << 16)

/* Used by PM_EMU_PWRSTST */
#define OMAP54XX_EMU_BANK_STATEST_SHIFT						4
#define OMAP54XX_EMU_BANK_STATEST_WIDTH						0x2
#define OMAP54XX_EMU_BANK_STATEST_MASK						(0x3 << 4)

/*
 * Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP,
 * PRM_SRAM_WKUP_SETUP
 */
#define OMAP54XX_ENABLE_RTA_SHIFT						0
#define OMAP54XX_ENABLE_RTA_WIDTH						0x1
#define OMAP54XX_ENABLE_RTA_MASK						(1 << 0)

/* Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP */
#define OMAP54XX_ENFUNC1_SHIFT							3
#define OMAP54XX_ENFUNC1_WIDTH							0x1
#define OMAP54XX_ENFUNC1_MASK							(1 << 3)

/* Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP */
#define OMAP54XX_ENFUNC2_SHIFT							4
#define OMAP54XX_ENFUNC2_WIDTH							0x1
#define OMAP54XX_ENFUNC2_MASK							(1 << 4)

/* Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP */
#define OMAP54XX_ENFUNC3_SHIFT							5
#define OMAP54XX_ENFUNC3_WIDTH							0x1
#define OMAP54XX_ENFUNC3_MASK							(1 << 5)

/* Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP */
#define OMAP54XX_ENFUNC4_SHIFT							6
#define OMAP54XX_ENFUNC4_WIDTH							0x1
#define OMAP54XX_ENFUNC4_MASK							(1 << 6)

/* Used by PRM_SLDO_CORE_SETUP, PRM_SLDO_MM_SETUP, PRM_SLDO_MPU_SETUP */
#define OMAP54XX_ENFUNC5_SHIFT							7
#define OMAP54XX_ENFUNC5_WIDTH							0x1
#define OMAP54XX_ENFUNC5_MASK							(1 << 7)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_MM_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP54XX_ERRORGAIN_SHIFT						16
#define OMAP54XX_ERRORGAIN_WIDTH						0x8
#define OMAP54XX_ERRORGAIN_MASK							(0xff << 16)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_MM_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP54XX_ERROROFFSET_SHIFT						24
#define OMAP54XX_ERROROFFSET_WIDTH						0x8
#define OMAP54XX_ERROROFFSET_MASK						(0xff << 24)

/* Used by PRM_RSTST */
#define OMAP54XX_EXTERNAL_WARM_RST_SHIFT					5
#define OMAP54XX_EXTERNAL_WARM_RST_WIDTH					0x1
#define OMAP54XX_EXTERNAL_WARM_RST_MASK						(1 << 5)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_MM_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP54XX_FORCEUPDATE_SHIFT						1
#define OMAP54XX_FORCEUPDATE_WIDTH						0x1
#define OMAP54XX_FORCEUPDATE_MASK						(1 << 1)

/* Used by PRM_VP_CORE_VOLTAGE, PRM_VP_MM_VOLTAGE, PRM_VP_MPU_VOLTAGE */
#define OMAP54XX_FORCEUPDATEWAIT_SHIFT						8
#define OMAP54XX_FORCEUPDATEWAIT_WIDTH						0x18
#define OMAP54XX_FORCEUPDATEWAIT_MASK						(0xffffff << 8)

/* Used by PRM_IRQENABLE_DSP, PRM_IRQENABLE_IPU */
#define OMAP54XX_FORCEWKUP_EN_SHIFT						10
#define OMAP54XX_FORCEWKUP_EN_WIDTH						0x1
#define OMAP54XX_FORCEWKUP_EN_MASK						(1 << 10)

/* Used by PRM_IRQSTATUS_DSP, PRM_IRQSTATUS_IPU */
#define OMAP54XX_FORCEWKUP_ST_SHIFT						10
#define OMAP54XX_FORCEWKUP_ST_WIDTH						0x1
#define OMAP54XX_FORCEWKUP_ST_MASK						(1 << 10)

/* Used by REVISION_PRM */
#define OMAP54XX_FUNC_SHIFT							16
#define OMAP54XX_FUNC_WIDTH							0xc
#define OMAP54XX_FUNC_MASK							(0xfff << 16)

/* Used by PRM_RSTST */
#define OMAP54XX_GLOBAL_COLD_RST_SHIFT						0
#define OMAP54XX_GLOBAL_COLD_RST_WIDTH						0x1
#define OMAP54XX_GLOBAL_COLD_RST_MASK						(1 << 0)

/* Used by PRM_RSTST */
#define OMAP54XX_GLOBAL_WARM_SW_RST_SHIFT					1
#define OMAP54XX_GLOBAL_WARM_SW_RST_WIDTH					0x1
#define OMAP54XX_GLOBAL_WARM_SW_RST_MASK					(1 << 1)

/* Used by PRM_IO_PMCTRL */
#define OMAP54XX_GLOBAL_WUEN_SHIFT						16
#define OMAP54XX_GLOBAL_WUEN_WIDTH						0x1
#define OMAP54XX_GLOBAL_WUEN_MASK						(1 << 16)

/* Used by PM_GPU_PWRSTCTRL */
#define OMAP54XX_GPU_MEM_ONSTATE_SHIFT						16
#define OMAP54XX_GPU_MEM_ONSTATE_WIDTH						0x2
#define OMAP54XX_GPU_MEM_ONSTATE_MASK						(0x3 << 16)

/* Used by PM_GPU_PWRSTST */
#define OMAP54XX_GPU_MEM_STATEST_SHIFT						4
#define OMAP54XX_GPU_MEM_STATEST_WIDTH						0x2
#define OMAP54XX_GPU_MEM_STATEST_MASK						(0x3 << 4)

/* Used by PRM_VC_CFG_I2C_MODE */
#define OMAP54XX_HSMCODE_SHIFT							0
#define OMAP54XX_HSMCODE_WIDTH							0x3
#define OMAP54XX_HSMCODE_MASK							(0x7 << 0)

/* Used by PRM_VC_CFG_I2C_MODE */
#define OMAP54XX_HSMODEEN_SHIFT							3
#define OMAP54XX_HSMODEEN_WIDTH							0x1
#define OMAP54XX_HSMODEEN_MASK							(1 << 3)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP54XX_HSSCLH_SHIFT							16
#define OMAP54XX_HSSCLH_WIDTH							0x8
#define OMAP54XX_HSSCLH_MASK							(0xff << 16)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP54XX_HSSCLL_SHIFT							24
#define OMAP54XX_HSSCLL_WIDTH							0x8
#define OMAP54XX_HSSCLL_MASK							(0xff << 24)

/* Used by PM_IVA_PWRSTCTRL */
#define OMAP54XX_HWA_MEM_ONSTATE_SHIFT						16
#define OMAP54XX_HWA_MEM_ONSTATE_WIDTH						0x2
#define OMAP54XX_HWA_MEM_ONSTATE_MASK						(0x3 << 16)

/* Used by PM_IVA_PWRSTCTRL */
#define OMAP54XX_HWA_MEM_RETSTATE_SHIFT						8
#define OMAP54XX_HWA_MEM_RETSTATE_WIDTH						0x1
#define OMAP54XX_HWA_MEM_RETSTATE_MASK						(1 << 8)

/* Used by PM_IVA_PWRSTST */
#define OMAP54XX_HWA_MEM_STATEST_SHIFT						4
#define OMAP54XX_HWA_MEM_STATEST_WIDTH						0x2
#define OMAP54XX_HWA_MEM_STATEST_MASK						(0x3 << 4)

/* Used by PRM_RSTST */
#define OMAP54XX_ICEPICK_RST_SHIFT						9
#define OMAP54XX_ICEPICK_RST_WIDTH						0x1
#define OMAP54XX_ICEPICK_RST_MASK						(1 << 9)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_MM_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP54XX_INITVDD_SHIFT							2
#define OMAP54XX_INITVDD_WIDTH							0x1
#define OMAP54XX_INITVDD_MASK							(1 << 2)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_MM_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP54XX_INITVOLTAGE_SHIFT						8
#define OMAP54XX_INITVOLTAGE_WIDTH						0x8
#define OMAP54XX_INITVOLTAGE_MASK						(0xff << 8)

/*
 * Used by PM_ABE_PWRSTST, PM_CAM_PWRSTST, PM_CORE_PWRSTST,
 * PM_CUSTEFUSE_PWRSTST, PM_DSP_PWRSTST, PM_DSS_PWRSTST, PM_EMU_PWRSTST,
 * PM_GPU_PWRSTST, PM_IVA_PWRSTST, PM_L3INIT_PWRSTST, PM_MPU_PWRSTST,
 * PRM_VOLTST_MM, PRM_VOLTST_MPU
 */
#define OMAP54XX_INTRANSITION_SHIFT						20
#define OMAP54XX_INTRANSITION_WIDTH						0x1
#define OMAP54XX_INTRANSITION_MASK						(1 << 20)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_IO_EN_SHIFT							9
#define OMAP54XX_IO_EN_WIDTH							0x1
#define OMAP54XX_IO_EN_MASK							(1 << 9)

/* Used by PRM_IO_PMCTRL */
#define OMAP54XX_IO_ON_STATUS_SHIFT						5
#define OMAP54XX_IO_ON_STATUS_WIDTH						0x1
#define OMAP54XX_IO_ON_STATUS_MASK						(1 << 5)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_IO_ST_SHIFT							9
#define OMAP54XX_IO_ST_WIDTH							0x1
#define OMAP54XX_IO_ST_MASK							(1 << 9)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_IPU_L2RAM_ONSTATE_SHIFT					20
#define OMAP54XX_IPU_L2RAM_ONSTATE_WIDTH					0x2
#define OMAP54XX_IPU_L2RAM_ONSTATE_MASK						(0x3 << 20)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_IPU_L2RAM_RETSTATE_SHIFT					10
#define OMAP54XX_IPU_L2RAM_RETSTATE_WIDTH					0x1
#define OMAP54XX_IPU_L2RAM_RETSTATE_MASK					(1 << 10)

/* Used by PM_CORE_PWRSTST */
#define OMAP54XX_IPU_L2RAM_STATEST_SHIFT					8
#define OMAP54XX_IPU_L2RAM_STATEST_WIDTH					0x2
#define OMAP54XX_IPU_L2RAM_STATEST_MASK						(0x3 << 8)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_IPU_UNICACHE_ONSTATE_SHIFT					22
#define OMAP54XX_IPU_UNICACHE_ONSTATE_WIDTH					0x2
#define OMAP54XX_IPU_UNICACHE_ONSTATE_MASK					(0x3 << 22)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_IPU_UNICACHE_RETSTATE_SHIFT					11
#define OMAP54XX_IPU_UNICACHE_RETSTATE_WIDTH					0x1
#define OMAP54XX_IPU_UNICACHE_RETSTATE_MASK					(1 << 11)

/* Used by PM_CORE_PWRSTST */
#define OMAP54XX_IPU_UNICACHE_STATEST_SHIFT					10
#define OMAP54XX_IPU_UNICACHE_STATEST_WIDTH					0x2
#define OMAP54XX_IPU_UNICACHE_STATEST_MASK					(0x3 << 10)

/* Used by PRM_IO_PMCTRL */
#define OMAP54XX_ISOCLK_OVERRIDE_SHIFT						0
#define OMAP54XX_ISOCLK_OVERRIDE_WIDTH						0x1
#define OMAP54XX_ISOCLK_OVERRIDE_MASK						(1 << 0)

/* Used by PRM_IO_PMCTRL */
#define OMAP54XX_ISOCLK_STATUS_SHIFT						1
#define OMAP54XX_ISOCLK_STATUS_WIDTH						0x1
#define OMAP54XX_ISOCLK_STATUS_MASK						(1 << 1)

/* Used by PRM_IO_PMCTRL */
#define OMAP54XX_ISOOVR_EXTEND_SHIFT						4
#define OMAP54XX_ISOOVR_EXTEND_WIDTH						0x1
#define OMAP54XX_ISOOVR_EXTEND_MASK						(1 << 4)

/* Used by PRM_IO_COUNT */
#define OMAP54XX_ISO_2_ON_TIME_SHIFT						0
#define OMAP54XX_ISO_2_ON_TIME_WIDTH						0x8
#define OMAP54XX_ISO_2_ON_TIME_MASK						(0xff << 0)

/* Used by PM_L3INIT_PWRSTCTRL */
#define OMAP54XX_L3INIT_BANK1_ONSTATE_SHIFT					16
#define OMAP54XX_L3INIT_BANK1_ONSTATE_WIDTH					0x2
#define OMAP54XX_L3INIT_BANK1_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_L3INIT_PWRSTCTRL */
#define OMAP54XX_L3INIT_BANK1_RETSTATE_SHIFT					8
#define OMAP54XX_L3INIT_BANK1_RETSTATE_WIDTH					0x1
#define OMAP54XX_L3INIT_BANK1_RETSTATE_MASK					(1 << 8)

/* Used by PM_L3INIT_PWRSTST */
#define OMAP54XX_L3INIT_BANK1_STATEST_SHIFT					4
#define OMAP54XX_L3INIT_BANK1_STATEST_WIDTH					0x2
#define OMAP54XX_L3INIT_BANK1_STATEST_MASK					(0x3 << 4)

/* Used by PM_L3INIT_PWRSTCTRL */
#define OMAP54XX_L3INIT_BANK2_ONSTATE_SHIFT					18
#define OMAP54XX_L3INIT_BANK2_ONSTATE_WIDTH					0x2
#define OMAP54XX_L3INIT_BANK2_ONSTATE_MASK					(0x3 << 18)

/* Used by PM_L3INIT_PWRSTCTRL */
#define OMAP54XX_L3INIT_BANK2_RETSTATE_SHIFT					9
#define OMAP54XX_L3INIT_BANK2_RETSTATE_WIDTH					0x1
#define OMAP54XX_L3INIT_BANK2_RETSTATE_MASK					(1 << 9)

/* Used by PM_L3INIT_PWRSTST */
#define OMAP54XX_L3INIT_BANK2_STATEST_SHIFT					6
#define OMAP54XX_L3INIT_BANK2_STATEST_WIDTH					0x2
#define OMAP54XX_L3INIT_BANK2_STATEST_MASK					(0x3 << 6)

/*
 * Used by PM_ABE_PWRSTST, PM_CAM_PWRSTST, PM_CORE_PWRSTST,
 * PM_CUSTEFUSE_PWRSTST, PM_DSP_PWRSTST, PM_DSS_PWRSTST, PM_EMU_PWRSTST,
 * PM_GPU_PWRSTST, PM_IVA_PWRSTST, PM_L3INIT_PWRSTST, PM_MPU_PWRSTST
 */
#define OMAP54XX_LASTPOWERSTATEENTERED_SHIFT					24
#define OMAP54XX_LASTPOWERSTATEENTERED_WIDTH					0x2
#define OMAP54XX_LASTPOWERSTATEENTERED_MASK					(0x3 << 24)

/* Used by PRM_RSTST */
#define OMAP54XX_LLI_RST_SHIFT							14
#define OMAP54XX_LLI_RST_WIDTH							0x1
#define OMAP54XX_LLI_RST_MASK							(1 << 14)

/*
 * Used by PM_ABE_PWRSTCTRL, PM_CORE_PWRSTCTRL, PM_DSP_PWRSTCTRL,
 * PM_DSS_PWRSTCTRL, PM_IVA_PWRSTCTRL, PM_L3INIT_PWRSTCTRL, PM_MPU_PWRSTCTRL
 */
#define OMAP54XX_LOGICRETSTATE_SHIFT						2
#define OMAP54XX_LOGICRETSTATE_WIDTH						0x1
#define OMAP54XX_LOGICRETSTATE_MASK						(1 << 2)

/*
 * Used by PM_ABE_PWRSTST, PM_CAM_PWRSTST, PM_CORE_PWRSTST,
 * PM_CUSTEFUSE_PWRSTST, PM_DSP_PWRSTST, PM_DSS_PWRSTST, PM_EMU_PWRSTST,
 * PM_GPU_PWRSTST, PM_IVA_PWRSTST, PM_L3INIT_PWRSTST, PM_MPU_PWRSTST
 */
#define OMAP54XX_LOGICSTATEST_SHIFT						2
#define OMAP54XX_LOGICSTATEST_WIDTH						0x1
#define OMAP54XX_LOGICSTATEST_MASK						(1 << 2)

/*
 * Used by RM_ABE_AESS_CONTEXT, RM_ABE_DMIC_CONTEXT, RM_ABE_MCASP_CONTEXT,
 * RM_ABE_MCBSP1_CONTEXT, RM_ABE_MCBSP2_CONTEXT, RM_ABE_MCBSP3_CONTEXT,
 * RM_ABE_MCPDM_CONTEXT, RM_ABE_SLIMBUS1_CONTEXT, RM_ABE_TIMER5_CONTEXT,
 * RM_ABE_TIMER6_CONTEXT, RM_ABE_TIMER7_CONTEXT, RM_ABE_TIMER8_CONTEXT,
 * RM_ABE_WD_TIMER3_CONTEXT, RM_C2C_C2C_CONTEXT, RM_C2C_C2C_OCP_FW_CONTEXT,
 * RM_CAM_CAL_CONTEXT, RM_CAM_FDIF_CONTEXT, RM_CAM_ISS_CONTEXT,
 * RM_COREAON_SMARTREFLEX_CORE_CONTEXT, RM_COREAON_SMARTREFLEX_MM_CONTEXT,
 * RM_COREAON_SMARTREFLEX_MPU_CONTEXT, RM_CUSTEFUSE_EFUSE_CTRL_CUST_CONTEXT,
 * RM_DSP_DSP_CONTEXT, RM_DSS_BB2D_CONTEXT, RM_DSS_DSS_CONTEXT,
 * RM_EMIF_DMM_CONTEXT, RM_EMIF_EMIF1_CONTEXT, RM_EMIF_EMIF2_CONTEXT,
 * RM_EMIF_EMIF_DLL_CONTEXT, RM_EMIF_EMIF_OCP_FW_CONTEXT,
 * RM_EMU_DEBUGSS_CONTEXT, RM_GPU_GPU_CONTEXT, RM_IPU_IPU_CONTEXT,
 * RM_IVA_IVA_CONTEXT, RM_IVA_SL2_CONTEXT, RM_L3INIT_IEEE1500_2_OCP_CONTEXT,
 * RM_L3INIT_OCP2SCP1_CONTEXT, RM_L3INIT_OCP2SCP3_CONTEXT,
 * RM_L3INIT_SATA_CONTEXT, RM_L3INIT_UNIPRO2_CONTEXT,
 * RM_L3INSTR_L3_INSTR_CONTEXT, RM_L3INSTR_L3_MAIN_3_CONTEXT,
 * RM_L3INSTR_OCP_WP_NOC_CONTEXT, RM_L3MAIN1_L3_MAIN_1_CONTEXT,
 * RM_L3MAIN2_L3_MAIN_2_CONTEXT, RM_L3MAIN2_OCMC_RAM_CONTEXT,
 * RM_L4CFG_L4_CFG_CONTEXT, RM_L4CFG_OCP2SCP2_CONTEXT,
 * RM_L4CFG_SAR_ROM_CONTEXT, RM_L4PER_ELM_CONTEXT, RM_L4PER_HDQ1W_CONTEXT,
 * RM_L4PER_I2C2_CONTEXT, RM_L4PER_I2C3_CONTEXT, RM_L4PER_I2C4_CONTEXT,
 * RM_L4PER_I2C5_CONTEXT, RM_L4PER_L4_PER_CONTEXT, RM_L4PER_MCSPI1_CONTEXT,
 * RM_L4PER_MCSPI2_CONTEXT, RM_L4PER_MCSPI3_CONTEXT, RM_L4PER_MCSPI4_CONTEXT,
 * RM_L4PER_MMC3_CONTEXT, RM_L4PER_MMC4_CONTEXT, RM_L4PER_MMC5_CONTEXT,
 * RM_L4PER_TIMER10_CONTEXT, RM_L4PER_TIMER11_CONTEXT, RM_L4PER_TIMER2_CONTEXT,
 * RM_L4PER_TIMER3_CONTEXT, RM_L4PER_TIMER4_CONTEXT, RM_L4PER_TIMER9_CONTEXT,
 * RM_L4SEC_FPKA_CONTEXT, RM_MIPIEXT_LLI_CONTEXT,
 * RM_MIPIEXT_LLI_OCP_FW_CONTEXT, RM_MIPIEXT_MPHY_CONTEXT, RM_MPU_MPU_CONTEXT,
 * RM_WKUPAON_COUNTER_32K_CONTEXT, RM_WKUPAON_GPIO1_CONTEXT,
 * RM_WKUPAON_KBD_CONTEXT, RM_WKUPAON_L4_WKUP_CONTEXT,
 * RM_WKUPAON_SAR_RAM_CONTEXT, RM_WKUPAON_TIMER12_CONTEXT,
 * RM_WKUPAON_TIMER1_CONTEXT, RM_WKUPAON_WD_TIMER1_CONTEXT,
 * RM_WKUPAON_WD_TIMER2_CONTEXT
 */
#define OMAP54XX_LOSTCONTEXT_DFF_SHIFT						0
#define OMAP54XX_LOSTCONTEXT_DFF_WIDTH						0x1
#define OMAP54XX_LOSTCONTEXT_DFF_MASK						(1 << 0)

/*
 * Used by RM_C2C_C2C_CONTEXT, RM_C2C_C2C_OCP_FW_CONTEXT,
 * RM_C2C_MODEM_ICR_CONTEXT, RM_DMA_DMA_SYSTEM_CONTEXT, RM_DSP_DSP_CONTEXT,
 * RM_DSS_DSS_CONTEXT, RM_EMIF_DMM_CONTEXT, RM_EMIF_EMIF1_CONTEXT,
 * RM_EMIF_EMIF2_CONTEXT, RM_EMIF_EMIF_OCP_FW_CONTEXT, RM_IPU_IPU_CONTEXT,
 * RM_L3INIT_HSI_CONTEXT, RM_L3INIT_MMC1_CONTEXT, RM_L3INIT_MMC2_CONTEXT,
 * RM_L3INIT_USB_HOST_HS_CONTEXT, RM_L3INIT_USB_OTG_SS_CONTEXT,
 * RM_L3INIT_USB_TLL_HS_CONTEXT, RM_L3INSTR_L3_MAIN_3_CONTEXT,
 * RM_L3INSTR_OCP_WP_NOC_CONTEXT, RM_L3MAIN1_L3_MAIN_1_CONTEXT,
 * RM_L3MAIN2_GPMC_CONTEXT, RM_L3MAIN2_L3_MAIN_2_CONTEXT,
 * RM_L4CFG_L4_CFG_CONTEXT, RM_L4CFG_MAILBOX_CONTEXT,
 * RM_L4CFG_SPINLOCK_CONTEXT, RM_L4PER_GPIO2_CONTEXT, RM_L4PER_GPIO3_CONTEXT,
 * RM_L4PER_GPIO4_CONTEXT, RM_L4PER_GPIO5_CONTEXT, RM_L4PER_GPIO6_CONTEXT,
 * RM_L4PER_GPIO7_CONTEXT, RM_L4PER_GPIO8_CONTEXT, RM_L4PER_I2C1_CONTEXT,
 * RM_L4PER_L4_PER_CONTEXT, RM_L4PER_UART1_CONTEXT, RM_L4PER_UART2_CONTEXT,
 * RM_L4PER_UART3_CONTEXT, RM_L4PER_UART4_CONTEXT, RM_L4PER_UART5_CONTEXT,
 * RM_L4PER_UART6_CONTEXT, RM_L4SEC_AES1_CONTEXT, RM_L4SEC_AES2_CONTEXT,
 * RM_L4SEC_DES3DES_CONTEXT, RM_L4SEC_DMA_CRYPTO_CONTEXT, RM_L4SEC_RNG_CONTEXT,
 * RM_L4SEC_SHA2MD5_CONTEXT, RM_MIPIEXT_LLI_CONTEXT,
 * RM_MIPIEXT_LLI_OCP_FW_CONTEXT, RM_MIPIEXT_MPHY_CONTEXT, RM_MPU_MPU_CONTEXT
 */
#define OMAP54XX_LOSTCONTEXT_RFF_SHIFT						1
#define OMAP54XX_LOSTCONTEXT_RFF_WIDTH						0x1
#define OMAP54XX_LOSTCONTEXT_RFF_MASK						(1 << 1)

/* Used by RM_ABE_AESS_CONTEXT */
#define OMAP54XX_LOSTMEM_AESSMEM_SHIFT						8
#define OMAP54XX_LOSTMEM_AESSMEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_AESSMEM_MASK						(1 << 8)

/* Used by RM_CAM_CAL_CONTEXT */
#define OMAP54XX_LOSTMEM_CAL_MEM_SHIFT						8
#define OMAP54XX_LOSTMEM_CAL_MEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_CAL_MEM_MASK						(1 << 8)

/* Used by RM_CAM_FDIF_CONTEXT, RM_CAM_ISS_CONTEXT */
#define OMAP54XX_LOSTMEM_CAM_MEM_SHIFT						8
#define OMAP54XX_LOSTMEM_CAM_MEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_CAM_MEM_MASK						(1 << 8)

/* Used by RM_EMIF_DMM_CONTEXT */
#define OMAP54XX_LOSTMEM_CORE_NRET_BANK_SHIFT					9
#define OMAP54XX_LOSTMEM_CORE_NRET_BANK_WIDTH					0x1
#define OMAP54XX_LOSTMEM_CORE_NRET_BANK_MASK					(1 << 9)

/* Renamed from LOSTMEM_CORE_NRET_BANK Used by RM_L3INSTR_OCP_WP_NOC_CONTEXT */
#define OMAP54XX_LOSTMEM_CORE_NRET_BANK_8_8_SHIFT				8
#define OMAP54XX_LOSTMEM_CORE_NRET_BANK_8_8_WIDTH				0x1
#define OMAP54XX_LOSTMEM_CORE_NRET_BANK_8_8_MASK				(1 << 8)

/* Used by RM_L3MAIN2_OCMC_RAM_CONTEXT */
#define OMAP54XX_LOSTMEM_CORE_OCMRAM_SHIFT					8
#define OMAP54XX_LOSTMEM_CORE_OCMRAM_WIDTH					0x1
#define OMAP54XX_LOSTMEM_CORE_OCMRAM_MASK					(1 << 8)

/* Used by RM_DMA_DMA_SYSTEM_CONTEXT, RM_EMIF_DMM_CONTEXT */
#define OMAP54XX_LOSTMEM_CORE_OTHER_BANK_SHIFT					8
#define OMAP54XX_LOSTMEM_CORE_OTHER_BANK_WIDTH					0x1
#define OMAP54XX_LOSTMEM_CORE_OTHER_BANK_MASK					(1 << 8)

/* Used by RM_DSP_DSP_CONTEXT */
#define OMAP54XX_LOSTMEM_DSP_EDMA_SHIFT						10
#define OMAP54XX_LOSTMEM_DSP_EDMA_WIDTH						0x1
#define OMAP54XX_LOSTMEM_DSP_EDMA_MASK						(1 << 10)

/* Used by RM_DSP_DSP_CONTEXT */
#define OMAP54XX_LOSTMEM_DSP_L1_SHIFT						8
#define OMAP54XX_LOSTMEM_DSP_L1_WIDTH						0x1
#define OMAP54XX_LOSTMEM_DSP_L1_MASK						(1 << 8)

/* Used by RM_DSP_DSP_CONTEXT */
#define OMAP54XX_LOSTMEM_DSP_L2_SHIFT						9
#define OMAP54XX_LOSTMEM_DSP_L2_WIDTH						0x1
#define OMAP54XX_LOSTMEM_DSP_L2_MASK						(1 << 9)

/* Used by RM_DSS_BB2D_CONTEXT, RM_DSS_DSS_CONTEXT */
#define OMAP54XX_LOSTMEM_DSS_MEM_SHIFT						8
#define OMAP54XX_LOSTMEM_DSS_MEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_DSS_MEM_MASK						(1 << 8)

/* Used by RM_EMU_DEBUGSS_CONTEXT */
#define OMAP54XX_LOSTMEM_EMU_BANK_SHIFT						8
#define OMAP54XX_LOSTMEM_EMU_BANK_WIDTH						0x1
#define OMAP54XX_LOSTMEM_EMU_BANK_MASK						(1 << 8)

/* Used by RM_GPU_GPU_CONTEXT */
#define OMAP54XX_LOSTMEM_GPU_MEM_SHIFT						8
#define OMAP54XX_LOSTMEM_GPU_MEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_GPU_MEM_MASK						(1 << 8)

/* Used by RM_IVA_IVA_CONTEXT */
#define OMAP54XX_LOSTMEM_HWA_MEM_SHIFT						10
#define OMAP54XX_LOSTMEM_HWA_MEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_HWA_MEM_MASK						(1 << 10)

/* Used by RM_IPU_IPU_CONTEXT */
#define OMAP54XX_LOSTMEM_IPU_L2RAM_SHIFT					9
#define OMAP54XX_LOSTMEM_IPU_L2RAM_WIDTH					0x1
#define OMAP54XX_LOSTMEM_IPU_L2RAM_MASK						(1 << 9)

/* Used by RM_IPU_IPU_CONTEXT */
#define OMAP54XX_LOSTMEM_IPU_UNICACHE_SHIFT					8
#define OMAP54XX_LOSTMEM_IPU_UNICACHE_WIDTH					0x1
#define OMAP54XX_LOSTMEM_IPU_UNICACHE_MASK					(1 << 8)

/*
 * Used by RM_L3INIT_HSI_CONTEXT, RM_L3INIT_MMC1_CONTEXT,
 * RM_L3INIT_MMC2_CONTEXT, RM_L3INIT_SATA_CONTEXT, RM_L3INIT_UNIPRO2_CONTEXT,
 * RM_L3INIT_USB_OTG_SS_CONTEXT
 */
#define OMAP54XX_LOSTMEM_L3INIT_BANK1_SHIFT					8
#define OMAP54XX_LOSTMEM_L3INIT_BANK1_WIDTH					0x1
#define OMAP54XX_LOSTMEM_L3INIT_BANK1_MASK					(1 << 8)

/* Used by RM_MPU_MPU_CONTEXT */
#define OMAP54XX_LOSTMEM_MPU_L2_SHIFT						9
#define OMAP54XX_LOSTMEM_MPU_L2_WIDTH						0x1
#define OMAP54XX_LOSTMEM_MPU_L2_MASK						(1 << 9)

/* Used by RM_MPU_MPU_CONTEXT */
#define OMAP54XX_LOSTMEM_MPU_RAM_SHIFT						10
#define OMAP54XX_LOSTMEM_MPU_RAM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_MPU_RAM_MASK						(1 << 10)

/*
 * Used by RM_L4PER_MMC3_CONTEXT, RM_L4PER_MMC4_CONTEXT, RM_L4PER_MMC5_CONTEXT,
 * RM_L4SEC_FPKA_CONTEXT
 */
#define OMAP54XX_LOSTMEM_NONRETAINED_BANK_SHIFT					8
#define OMAP54XX_LOSTMEM_NONRETAINED_BANK_WIDTH					0x1
#define OMAP54XX_LOSTMEM_NONRETAINED_BANK_MASK					(1 << 8)

/*
 * Used by RM_ABE_DMIC_CONTEXT, RM_ABE_MCBSP1_CONTEXT, RM_ABE_MCBSP2_CONTEXT,
 * RM_ABE_MCBSP3_CONTEXT, RM_ABE_MCPDM_CONTEXT, RM_ABE_SLIMBUS1_CONTEXT
 */
#define OMAP54XX_LOSTMEM_PERIHPMEM_SHIFT					8
#define OMAP54XX_LOSTMEM_PERIHPMEM_WIDTH					0x1
#define OMAP54XX_LOSTMEM_PERIHPMEM_MASK						(1 << 8)

/*
 * Used by RM_L4PER_UART1_CONTEXT, RM_L4PER_UART2_CONTEXT,
 * RM_L4PER_UART3_CONTEXT, RM_L4PER_UART4_CONTEXT, RM_L4PER_UART5_CONTEXT,
 * RM_L4PER_UART6_CONTEXT, RM_L4SEC_DMA_CRYPTO_CONTEXT
 */
#define OMAP54XX_LOSTMEM_RETAINED_BANK_SHIFT					8
#define OMAP54XX_LOSTMEM_RETAINED_BANK_WIDTH					0x1
#define OMAP54XX_LOSTMEM_RETAINED_BANK_MASK					(1 << 8)

/* Used by RM_IVA_SL2_CONTEXT */
#define OMAP54XX_LOSTMEM_SL2_MEM_SHIFT						8
#define OMAP54XX_LOSTMEM_SL2_MEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_SL2_MEM_MASK						(1 << 8)

/* Used by RM_IVA_IVA_CONTEXT */
#define OMAP54XX_LOSTMEM_TCM1_MEM_SHIFT						8
#define OMAP54XX_LOSTMEM_TCM1_MEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_TCM1_MEM_MASK						(1 << 8)

/* Used by RM_IVA_IVA_CONTEXT */
#define OMAP54XX_LOSTMEM_TCM2_MEM_SHIFT						9
#define OMAP54XX_LOSTMEM_TCM2_MEM_WIDTH						0x1
#define OMAP54XX_LOSTMEM_TCM2_MEM_MASK						(1 << 9)

/* Used by RM_WKUPAON_SAR_RAM_CONTEXT */
#define OMAP54XX_LOSTMEM_WKUP_BANK_SHIFT					8
#define OMAP54XX_LOSTMEM_WKUP_BANK_WIDTH					0x1
#define OMAP54XX_LOSTMEM_WKUP_BANK_MASK						(1 << 8)

/*
 * Used by PM_ABE_PWRSTCTRL, PM_CAM_PWRSTCTRL, PM_CORE_PWRSTCTRL,
 * PM_CUSTEFUSE_PWRSTCTRL, PM_DSP_PWRSTCTRL, PM_DSS_PWRSTCTRL,
 * PM_GPU_PWRSTCTRL, PM_IVA_PWRSTCTRL, PM_L3INIT_PWRSTCTRL, PM_MPU_PWRSTCTRL
 */
#define OMAP54XX_LOWPOWERSTATECHANGE_SHIFT					4
#define OMAP54XX_LOWPOWERSTATECHANGE_WIDTH					0x1
#define OMAP54XX_LOWPOWERSTATECHANGE_MASK					(1 << 4)

/* Used by PRM_DEBUG_TRANS_CFG */
#define OMAP54XX_MODE_SHIFT							0
#define OMAP54XX_MODE_WIDTH							0x2
#define OMAP54XX_MODE_MASK							(0x3 << 0)

/* Used by PRM_MODEM_IF_CTRL */
#define OMAP54XX_MODEM_SHUTDOWN_IRQ_SHIFT					9
#define OMAP54XX_MODEM_SHUTDOWN_IRQ_WIDTH					0x1
#define OMAP54XX_MODEM_SHUTDOWN_IRQ_MASK					(1 << 9)

/* Used by PRM_MODEM_IF_CTRL */
#define OMAP54XX_MODEM_WAKE_IRQ_SHIFT						8
#define OMAP54XX_MODEM_WAKE_IRQ_WIDTH						0x1
#define OMAP54XX_MODEM_WAKE_IRQ_MASK						(1 << 8)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP54XX_MPU_L2_ONSTATE_SHIFT						18
#define OMAP54XX_MPU_L2_ONSTATE_WIDTH						0x2
#define OMAP54XX_MPU_L2_ONSTATE_MASK						(0x3 << 18)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP54XX_MPU_L2_RETSTATE_SHIFT						9
#define OMAP54XX_MPU_L2_RETSTATE_WIDTH						0x1
#define OMAP54XX_MPU_L2_RETSTATE_MASK						(1 << 9)

/* Used by PM_MPU_PWRSTST */
#define OMAP54XX_MPU_L2_STATEST_SHIFT						6
#define OMAP54XX_MPU_L2_STATEST_WIDTH						0x2
#define OMAP54XX_MPU_L2_STATEST_MASK						(0x3 << 6)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP54XX_MPU_RAM_ONSTATE_SHIFT						20
#define OMAP54XX_MPU_RAM_ONSTATE_WIDTH						0x2
#define OMAP54XX_MPU_RAM_ONSTATE_MASK						(0x3 << 20)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP54XX_MPU_RAM_RETSTATE_SHIFT						10
#define OMAP54XX_MPU_RAM_RETSTATE_WIDTH						0x1
#define OMAP54XX_MPU_RAM_RETSTATE_MASK						(1 << 10)

/* Used by PM_MPU_PWRSTST */
#define OMAP54XX_MPU_RAM_STATEST_SHIFT						8
#define OMAP54XX_MPU_RAM_STATEST_WIDTH						0x2
#define OMAP54XX_MPU_RAM_STATEST_MASK						(0x3 << 8)

/* Used by PRM_RSTST */
#define OMAP54XX_MPU_SECURITY_VIOL_RST_SHIFT					2
#define OMAP54XX_MPU_SECURITY_VIOL_RST_WIDTH					0x1
#define OMAP54XX_MPU_SECURITY_VIOL_RST_MASK					(1 << 2)

/* Used by PRM_RSTST */
#define OMAP54XX_MPU_WDT_RST_SHIFT						3
#define OMAP54XX_MPU_WDT_RST_WIDTH						0x1
#define OMAP54XX_MPU_WDT_RST_MASK						(1 << 3)

/* Used by PRM_ABBLDO_MM_SETUP, PRM_ABBLDO_MPU_SETUP */
#define OMAP54XX_NOCAP_SHIFT							4
#define OMAP54XX_NOCAP_WIDTH							0x1
#define OMAP54XX_NOCAP_MASK							(1 << 4)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_OCP_NRET_BANK_ONSTATE_SHIFT					24
#define OMAP54XX_OCP_NRET_BANK_ONSTATE_WIDTH					0x2
#define OMAP54XX_OCP_NRET_BANK_ONSTATE_MASK					(0x3 << 24)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP54XX_OCP_NRET_BANK_RETSTATE_SHIFT					12
#define OMAP54XX_OCP_NRET_BANK_RETSTATE_WIDTH					0x1
#define OMAP54XX_OCP_NRET_BANK_RETSTATE_MASK					(1 << 12)

/* Used by PM_CORE_PWRSTST */
#define OMAP54XX_OCP_NRET_BANK_STATEST_SHIFT					12
#define OMAP54XX_OCP_NRET_BANK_STATEST_WIDTH					0x2
#define OMAP54XX_OCP_NRET_BANK_STATEST_MASK					(0x3 << 12)

/*
 * Used by PRM_VC_VAL_CMD_VDD_CORE_L, PRM_VC_VAL_CMD_VDD_MM_L,
 * PRM_VC_VAL_CMD_VDD_MPU_L
 */
#define OMAP54XX_OFF_SHIFT							0
#define OMAP54XX_OFF_WIDTH							0x8
#define OMAP54XX_OFF_MASK							(0xff << 0)

/*
 * Used by PRM_VC_VAL_CMD_VDD_CORE_L, PRM_VC_VAL_CMD_VDD_MM_L,
 * PRM_VC_VAL_CMD_VDD_MPU_L
 */
#define OMAP54XX_ON_SHIFT							24
#define OMAP54XX_ON_WIDTH							0x8
#define OMAP54XX_ON_MASK							(0xff << 24)

/*
 * Used by PRM_VC_VAL_CMD_VDD_CORE_L, PRM_VC_VAL_CMD_VDD_MM_L,
 * PRM_VC_VAL_CMD_VDD_MPU_L
 */
#define OMAP54XX_ONLP_SHIFT							16
#define OMAP54XX_ONLP_WIDTH							0x8
#define OMAP54XX_ONLP_MASK							(0xff << 16)

/* Used by PRM_ABBLDO_MM_CTRL, PRM_ABBLDO_MPU_CTRL */
#define OMAP54XX_OPP_CHANGE_SHIFT						2
#define OMAP54XX_OPP_CHANGE_WIDTH						0x1
#define OMAP54XX_OPP_CHANGE_MASK						(1 << 2)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP54XX_OPP_CHANGE_EMIF_LVL_SHIFT					25
#define OMAP54XX_OPP_CHANGE_EMIF_LVL_WIDTH					0x1
#define OMAP54XX_OPP_CHANGE_EMIF_LVL_MASK					(1 << 25)

/* Used by PRM_ABBLDO_MM_CTRL, PRM_ABBLDO_MPU_CTRL */
#define OMAP54XX_OPP_SEL_SHIFT							0
#define OMAP54XX_OPP_SEL_WIDTH							0x2
#define OMAP54XX_OPP_SEL_MASK							(0x3 << 0)

/* Used by PRM_DEBUG_OUT */
#define OMAP54XX_OUTPUT_SHIFT							0
#define OMAP54XX_OUTPUT_WIDTH							0x20
#define OMAP54XX_OUTPUT_MASK							(0xffffffff << 0)

/* Used by PRM_SRAM_COUNT */
#define OMAP54XX_PCHARGECNT_VALUE_SHIFT						0
#define OMAP54XX_PCHARGECNT_VALUE_WIDTH						0x6
#define OMAP54XX_PCHARGECNT_VALUE_MASK						(0x3f << 0)

/* Used by PRM_PSCON_COUNT */
#define OMAP54XX_PCHARGE_TIME_SHIFT						0
#define OMAP54XX_PCHARGE_TIME_WIDTH						0x8
#define OMAP54XX_PCHARGE_TIME_MASK						(0xff << 0)

/* Used by PM_ABE_PWRSTCTRL */
#define OMAP54XX_PERIPHMEM_ONSTATE_SHIFT					20
#define OMAP54XX_PERIPHMEM_ONSTATE_WIDTH					0x2
#define OMAP54XX_PERIPHMEM_ONSTATE_MASK						(0x3 << 20)

/* Used by PM_ABE_PWRSTCTRL */
#define OMAP54XX_PERIPHMEM_RETSTATE_SHIFT					10
#define OMAP54XX_PERIPHMEM_RETSTATE_WIDTH					0x1
#define OMAP54XX_PERIPHMEM_RETSTATE_MASK					(1 << 10)

/* Used by PM_ABE_PWRSTST */
#define OMAP54XX_PERIPHMEM_STATEST_SHIFT					8
#define OMAP54XX_PERIPHMEM_STATEST_WIDTH					0x2
#define OMAP54XX_PERIPHMEM_STATEST_MASK						(0x3 << 8)

/* Used by PRM_PHASE1_CNDP */
#define OMAP54XX_PHASE1_CNDP_SHIFT						0
#define OMAP54XX_PHASE1_CNDP_WIDTH						0x20
#define OMAP54XX_PHASE1_CNDP_MASK						(0xffffffff << 0)

/* Used by PRM_PHASE2A_CNDP */
#define OMAP54XX_PHASE2A_CNDP_SHIFT						0
#define OMAP54XX_PHASE2A_CNDP_WIDTH						0x20
#define OMAP54XX_PHASE2A_CNDP_MASK						(0xffffffff << 0)

/* Used by PRM_PHASE2B_CNDP */
#define OMAP54XX_PHASE2B_CNDP_SHIFT						0
#define OMAP54XX_PHASE2B_CNDP_WIDTH						0x20
#define OMAP54XX_PHASE2B_CNDP_MASK						(0xffffffff << 0)

/* Used by PRM_PSCON_COUNT */
#define OMAP54XX_PONOUT_2_PGOODIN_TIME_SHIFT					8
#define OMAP54XX_PONOUT_2_PGOODIN_TIME_WIDTH					0x8
#define OMAP54XX_PONOUT_2_PGOODIN_TIME_MASK					(0xff << 8)

/*
 * Used by PM_ABE_PWRSTCTRL, PM_CAM_PWRSTCTRL, PM_CORE_PWRSTCTRL,
 * PM_CUSTEFUSE_PWRSTCTRL, PM_DSP_PWRSTCTRL, PM_DSS_PWRSTCTRL,
 * PM_EMU_PWRSTCTRL, PM_GPU_PWRSTCTRL, PM_IVA_PWRSTCTRL, PM_L3INIT_PWRSTCTRL,
 * PM_MPU_PWRSTCTRL
 */
#define OMAP54XX_POWERSTATE_SHIFT						0
#define OMAP54XX_POWERSTATE_WIDTH						0x2
#define OMAP54XX_POWERSTATE_MASK						(0x3 << 0)

/*
 * Used by PM_ABE_PWRSTST, PM_CAM_PWRSTST, PM_CORE_PWRSTST,
 * PM_CUSTEFUSE_PWRSTST, PM_DSP_PWRSTST, PM_DSS_PWRSTST, PM_EMU_PWRSTST,
 * PM_GPU_PWRSTST, PM_IVA_PWRSTST, PM_L3INIT_PWRSTST, PM_MPU_PWRSTST
 */
#define OMAP54XX_POWERSTATEST_SHIFT						0
#define OMAP54XX_POWERSTATEST_WIDTH						0x2
#define OMAP54XX_POWERSTATEST_MASK						(0x3 << 0)

/* Used by PRM_PWRREQCTRL */
#define OMAP54XX_PWRREQ_COND_SHIFT						0
#define OMAP54XX_PWRREQ_COND_WIDTH						0x2
#define OMAP54XX_PWRREQ_COND_MASK						(0x3 << 0)

/* Used by PRM_VC_SMPS_CORE_CONFIG */
#define OMAP54XX_RACEN_VDD_CORE_L_SHIFT						27
#define OMAP54XX_RACEN_VDD_CORE_L_WIDTH						0x1
#define OMAP54XX_RACEN_VDD_CORE_L_MASK						(1 << 27)

/* Used by PRM_VC_SMPS_MM_CONFIG */
#define OMAP54XX_RACEN_VDD_MM_L_SHIFT						27
#define OMAP54XX_RACEN_VDD_MM_L_WIDTH						0x1
#define OMAP54XX_RACEN_VDD_MM_L_MASK						(1 << 27)

/* Used by PRM_VC_SMPS_MPU_CONFIG */
#define OMAP54XX_RACEN_VDD_MPU_L_SHIFT						27
#define OMAP54XX_RACEN_VDD_MPU_L_WIDTH						0x1
#define OMAP54XX_RACEN_VDD_MPU_L_MASK						(1 << 27)

/* Used by PRM_VC_SMPS_CORE_CONFIG */
#define OMAP54XX_RAC_VDD_CORE_L_SHIFT						26
#define OMAP54XX_RAC_VDD_CORE_L_WIDTH						0x1
#define OMAP54XX_RAC_VDD_CORE_L_MASK						(1 << 26)

/* Used by PRM_VC_SMPS_MM_CONFIG */
#define OMAP54XX_RAC_VDD_MM_L_SHIFT						26
#define OMAP54XX_RAC_VDD_MM_L_WIDTH						0x1
#define OMAP54XX_RAC_VDD_MM_L_MASK						(1 << 26)

/* Used by PRM_VC_SMPS_MPU_CONFIG */
#define OMAP54XX_RAC_VDD_MPU_L_SHIFT						26
#define OMAP54XX_RAC_VDD_MPU_L_WIDTH						0x1
#define OMAP54XX_RAC_VDD_MPU_L_MASK						(1 << 26)

/*
 * Used by PRM_VOLTSETUP_CORE_OFF, PRM_VOLTSETUP_CORE_RET_SLEEP,
 * PRM_VOLTSETUP_MM_OFF, PRM_VOLTSETUP_MM_RET_SLEEP, PRM_VOLTSETUP_MPU_OFF,
 * PRM_VOLTSETUP_MPU_RET_SLEEP
 */
#define OMAP54XX_RAMP_DOWN_COUNT_SHIFT						16
#define OMAP54XX_RAMP_DOWN_COUNT_WIDTH						0x6
#define OMAP54XX_RAMP_DOWN_COUNT_MASK						(0x3f << 16)

/*
 * Used by PRM_VOLTSETUP_CORE_OFF, PRM_VOLTSETUP_CORE_RET_SLEEP,
 * PRM_VOLTSETUP_MM_OFF, PRM_VOLTSETUP_MM_RET_SLEEP, PRM_VOLTSETUP_MPU_OFF,
 * PRM_VOLTSETUP_MPU_RET_SLEEP
 */
#define OMAP54XX_RAMP_DOWN_PRESCAL_SHIFT					24
#define OMAP54XX_RAMP_DOWN_PRESCAL_WIDTH					0x2
#define OMAP54XX_RAMP_DOWN_PRESCAL_MASK						(0x3 << 24)

/*
 * Used by PRM_VOLTSETUP_CORE_OFF, PRM_VOLTSETUP_CORE_RET_SLEEP,
 * PRM_VOLTSETUP_MM_OFF, PRM_VOLTSETUP_MM_RET_SLEEP, PRM_VOLTSETUP_MPU_OFF,
 * PRM_VOLTSETUP_MPU_RET_SLEEP
 */
#define OMAP54XX_RAMP_UP_COUNT_SHIFT						0
#define OMAP54XX_RAMP_UP_COUNT_WIDTH						0x6
#define OMAP54XX_RAMP_UP_COUNT_MASK						(0x3f << 0)

/*
 * Used by PRM_VOLTSETUP_CORE_OFF, PRM_VOLTSETUP_CORE_RET_SLEEP,
 * PRM_VOLTSETUP_MM_OFF, PRM_VOLTSETUP_MM_RET_SLEEP, PRM_VOLTSETUP_MPU_OFF,
 * PRM_VOLTSETUP_MPU_RET_SLEEP
 */
#define OMAP54XX_RAMP_UP_PRESCAL_SHIFT						8
#define OMAP54XX_RAMP_UP_PRESCAL_WIDTH						0x2
#define OMAP54XX_RAMP_UP_PRESCAL_MASK						(0x3 << 8)

/* Used by PRM_VC_SMPS_CORE_CONFIG */
#define OMAP54XX_RAV_VDD_CORE_L_SHIFT						25
#define OMAP54XX_RAV_VDD_CORE_L_WIDTH						0x1
#define OMAP54XX_RAV_VDD_CORE_L_MASK						(1 << 25)

/* Used by PRM_VC_SMPS_MM_CONFIG */
#define OMAP54XX_RAV_VDD_MM_L_SHIFT						25
#define OMAP54XX_RAV_VDD_MM_L_WIDTH						0x1
#define OMAP54XX_RAV_VDD_MM_L_MASK						(1 << 25)

/* Used by PRM_VC_SMPS_MPU_CONFIG */
#define OMAP54XX_RAV_VDD_MPU_L_SHIFT						25
#define OMAP54XX_RAV_VDD_MPU_L_WIDTH						0x1
#define OMAP54XX_RAV_VDD_MPU_L_MASK						(1 << 25)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP54XX_REGADDR_SHIFT							8
#define OMAP54XX_REGADDR_WIDTH							0x8
#define OMAP54XX_REGADDR_MASK							(0xff << 8)

/*
 * Used by PRM_VC_VAL_CMD_VDD_CORE_L, PRM_VC_VAL_CMD_VDD_MM_L,
 * PRM_VC_VAL_CMD_VDD_MPU_L
 */
#define OMAP54XX_RET_SHIFT							8
#define OMAP54XX_RET_WIDTH							0x8
#define OMAP54XX_RET_MASK							(0xff << 8)

/* Used by PRM_SLDO_CORE_CTRL, PRM_SLDO_MM_CTRL, PRM_SLDO_MPU_CTRL */
#define OMAP54XX_RETMODE_ENABLE_SHIFT						0
#define OMAP54XX_RETMODE_ENABLE_WIDTH						0x1
#define OMAP54XX_RETMODE_ENABLE_MASK						(1 << 0)

/* Used by PRM_RSTTIME */
#define OMAP54XX_RSTTIME1_SHIFT							0
#define OMAP54XX_RSTTIME1_WIDTH							0xa
#define OMAP54XX_RSTTIME1_MASK							(0x3ff << 0)

/* Used by PRM_RSTTIME */
#define OMAP54XX_RSTTIME2_SHIFT							10
#define OMAP54XX_RSTTIME2_WIDTH							0x5
#define OMAP54XX_RSTTIME2_MASK							(0x1f << 10)

/* Used by RM_IPU_RSTCTRL, RM_IPU_RSTST */
#define OMAP54XX_RST_CPU0_SHIFT							0
#define OMAP54XX_RST_CPU0_WIDTH							0x1
#define OMAP54XX_RST_CPU0_MASK							(1 << 0)

/* Used by RM_IPU_RSTCTRL, RM_IPU_RSTST */
#define OMAP54XX_RST_CPU1_SHIFT							1
#define OMAP54XX_RST_CPU1_WIDTH							0x1
#define OMAP54XX_RST_CPU1_MASK							(1 << 1)

/* Used by RM_DSP_RSTCTRL, RM_DSP_RSTST */
#define OMAP54XX_RST_DSP_SHIFT							0
#define OMAP54XX_RST_DSP_WIDTH							0x1
#define OMAP54XX_RST_DSP_MASK							(1 << 0)

/* Used by RM_DSP_RSTST */
#define OMAP54XX_RST_DSP_EMU_SHIFT						2
#define OMAP54XX_RST_DSP_EMU_WIDTH						0x1
#define OMAP54XX_RST_DSP_EMU_MASK						(1 << 2)

/* Used by RM_DSP_RSTST */
#define OMAP54XX_RST_DSP_EMU_REQ_SHIFT						3
#define OMAP54XX_RST_DSP_EMU_REQ_WIDTH						0x1
#define OMAP54XX_RST_DSP_EMU_REQ_MASK						(1 << 3)

/* Used by RM_DSP_RSTCTRL, RM_DSP_RSTST */
#define OMAP54XX_RST_DSP_MMU_CACHE_SHIFT					1
#define OMAP54XX_RST_DSP_MMU_CACHE_WIDTH					0x1
#define OMAP54XX_RST_DSP_MMU_CACHE_MASK						(1 << 1)

/* Used by RM_IPU_RSTST */
#define OMAP54XX_RST_EMULATION_CPU0_SHIFT					3
#define OMAP54XX_RST_EMULATION_CPU0_WIDTH					0x1
#define OMAP54XX_RST_EMULATION_CPU0_MASK					(1 << 3)

/* Used by RM_IPU_RSTST */
#define OMAP54XX_RST_EMULATION_CPU1_SHIFT					4
#define OMAP54XX_RST_EMULATION_CPU1_WIDTH					0x1
#define OMAP54XX_RST_EMULATION_CPU1_MASK					(1 << 4)

/* Used by RM_IVA_RSTST */
#define OMAP54XX_RST_EMULATION_SEQ1_SHIFT					3
#define OMAP54XX_RST_EMULATION_SEQ1_WIDTH					0x1
#define OMAP54XX_RST_EMULATION_SEQ1_MASK					(1 << 3)

/* Used by RM_IVA_RSTST */
#define OMAP54XX_RST_EMULATION_SEQ2_SHIFT					4
#define OMAP54XX_RST_EMULATION_SEQ2_WIDTH					0x1
#define OMAP54XX_RST_EMULATION_SEQ2_MASK					(1 << 4)

/* Used by PRM_RSTCTRL */
#define OMAP54XX_RST_GLOBAL_COLD_SW_SHIFT					1
#define OMAP54XX_RST_GLOBAL_COLD_SW_WIDTH					0x1
#define OMAP54XX_RST_GLOBAL_COLD_SW_MASK					(1 << 1)

/* Used by PRM_RSTCTRL */
#define OMAP54XX_RST_GLOBAL_WARM_SW_SHIFT					0
#define OMAP54XX_RST_GLOBAL_WARM_SW_WIDTH					0x1
#define OMAP54XX_RST_GLOBAL_WARM_SW_MASK					(1 << 0)

/* Used by RM_IPU_RSTST */
#define OMAP54XX_RST_ICECRUSHER_CPU0_SHIFT					5
#define OMAP54XX_RST_ICECRUSHER_CPU0_WIDTH					0x1
#define OMAP54XX_RST_ICECRUSHER_CPU0_MASK					(1 << 5)

/* Used by RM_IPU_RSTST */
#define OMAP54XX_RST_ICECRUSHER_CPU1_SHIFT					6
#define OMAP54XX_RST_ICECRUSHER_CPU1_WIDTH					0x1
#define OMAP54XX_RST_ICECRUSHER_CPU1_MASK					(1 << 6)

/* Used by RM_IVA_RSTST */
#define OMAP54XX_RST_ICECRUSHER_SEQ1_SHIFT					5
#define OMAP54XX_RST_ICECRUSHER_SEQ1_WIDTH					0x1
#define OMAP54XX_RST_ICECRUSHER_SEQ1_MASK					(1 << 5)

/* Used by RM_IVA_RSTST */
#define OMAP54XX_RST_ICECRUSHER_SEQ2_SHIFT					6
#define OMAP54XX_RST_ICECRUSHER_SEQ2_WIDTH					0x1
#define OMAP54XX_RST_ICECRUSHER_SEQ2_MASK					(1 << 6)

/* Used by RM_IPU_RSTCTRL, RM_IPU_RSTST */
#define OMAP54XX_RST_IPU_MMU_CACHE_SHIFT					2
#define OMAP54XX_RST_IPU_MMU_CACHE_WIDTH					0x1
#define OMAP54XX_RST_IPU_MMU_CACHE_MASK						(1 << 2)

/* Used by RM_IVA_RSTCTRL, RM_IVA_RSTST */
#define OMAP54XX_RST_LOGIC_SHIFT						2
#define OMAP54XX_RST_LOGIC_WIDTH						0x1
#define OMAP54XX_RST_LOGIC_MASK							(1 << 2)

/* Used by RM_IVA_RSTCTRL, RM_IVA_RSTST */
#define OMAP54XX_RST_SEQ1_SHIFT							0
#define OMAP54XX_RST_SEQ1_WIDTH							0x1
#define OMAP54XX_RST_SEQ1_MASK							(1 << 0)

/* Used by RM_IVA_RSTCTRL, RM_IVA_RSTST */
#define OMAP54XX_RST_SEQ2_SHIFT							1
#define OMAP54XX_RST_SEQ2_WIDTH							0x1
#define OMAP54XX_RST_SEQ2_MASK							(1 << 1)

/* Used by REVISION_PRM */
#define OMAP54XX_R_RTL_SHIFT							11
#define OMAP54XX_R_RTL_WIDTH							0x5
#define OMAP54XX_R_RTL_MASK							(0x1f << 11)

/* Used by PRM_VC_SMPS_CORE_CONFIG */
#define OMAP54XX_SA_VDD_CORE_L_SHIFT						0
#define OMAP54XX_SA_VDD_CORE_L_WIDTH						0x7
#define OMAP54XX_SA_VDD_CORE_L_MASK						(0x7f << 0)

/* Used by PRM_VC_SMPS_MM_CONFIG */
#define OMAP54XX_SA_VDD_MM_L_SHIFT						0
#define OMAP54XX_SA_VDD_MM_L_WIDTH						0x7
#define OMAP54XX_SA_VDD_MM_L_MASK						(0x7f << 0)

/* Used by PRM_VC_SMPS_MPU_CONFIG */
#define OMAP54XX_SA_VDD_MPU_L_SHIFT						0
#define OMAP54XX_SA_VDD_MPU_L_WIDTH						0x7
#define OMAP54XX_SA_VDD_MPU_L_MASK						(0x7f << 0)

/* Used by REVISION_PRM */
#define OMAP54XX_SCHEME_SHIFT							30
#define OMAP54XX_SCHEME_WIDTH							0x2
#define OMAP54XX_SCHEME_MASK							(0x3 << 30)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP54XX_SCLH_SHIFT							0
#define OMAP54XX_SCLH_WIDTH							0x8
#define OMAP54XX_SCLH_MASK							(0xff << 0)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP54XX_SCLL_SHIFT							8
#define OMAP54XX_SCLL_WIDTH							0x8
#define OMAP54XX_SCLL_MASK							(0xff << 8)

/* Used by PRM_RSTST */
#define OMAP54XX_SECURE_WDT_RST_SHIFT						4
#define OMAP54XX_SECURE_WDT_RST_WIDTH						0x1
#define OMAP54XX_SECURE_WDT_RST_MASK						(1 << 4)

/* Used by PRM_VC_SMPS_CORE_CONFIG */
#define OMAP54XX_SEL_SA_VDD_CORE_L_SHIFT					24
#define OMAP54XX_SEL_SA_VDD_CORE_L_WIDTH					0x1
#define OMAP54XX_SEL_SA_VDD_CORE_L_MASK						(1 << 24)

/* Used by PRM_VC_SMPS_MM_CONFIG */
#define OMAP54XX_SEL_SA_VDD_MM_L_SHIFT						24
#define OMAP54XX_SEL_SA_VDD_MM_L_WIDTH						0x1
#define OMAP54XX_SEL_SA_VDD_MM_L_MASK						(1 << 24)

/* Used by PRM_VC_SMPS_MPU_CONFIG */
#define OMAP54XX_SEL_SA_VDD_MPU_L_SHIFT						24
#define OMAP54XX_SEL_SA_VDD_MPU_L_WIDTH						0x1
#define OMAP54XX_SEL_SA_VDD_MPU_L_MASK						(1 << 24)

/* Used by PM_IVA_PWRSTCTRL */
#define OMAP54XX_SL2_MEM_ONSTATE_SHIFT						18
#define OMAP54XX_SL2_MEM_ONSTATE_WIDTH						0x2
#define OMAP54XX_SL2_MEM_ONSTATE_MASK						(0x3 << 18)

/* Used by PM_IVA_PWRSTCTRL */
#define OMAP54XX_SL2_MEM_RETSTATE_SHIFT						9
#define OMAP54XX_SL2_MEM_RETSTATE_WIDTH						0x1
#define OMAP54XX_SL2_MEM_RETSTATE_MASK						(1 << 9)

/* Used by PM_IVA_PWRSTST */
#define OMAP54XX_SL2_MEM_STATEST_SHIFT						6
#define OMAP54XX_SL2_MEM_STATEST_WIDTH						0x2
#define OMAP54XX_SL2_MEM_STATEST_MASK						(0x3 << 6)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP54XX_SLAVEADDR_SHIFT						0
#define OMAP54XX_SLAVEADDR_WIDTH						0x7
#define OMAP54XX_SLAVEADDR_MASK							(0x7f << 0)

/* Used by PRM_SRAM_COUNT */
#define OMAP54XX_SLPCNT_VALUE_SHIFT						16
#define OMAP54XX_SLPCNT_VALUE_WIDTH						0x8
#define OMAP54XX_SLPCNT_VALUE_MASK						(0xff << 16)

/* Used by PRM_VP_CORE_VSTEPMAX, PRM_VP_MM_VSTEPMAX, PRM_VP_MPU_VSTEPMAX */
#define OMAP54XX_SMPSWAITTIMEMAX_SHIFT						8
#define OMAP54XX_SMPSWAITTIMEMAX_WIDTH						0x10
#define OMAP54XX_SMPSWAITTIMEMAX_MASK						(0xffff << 8)

/* Used by PRM_VP_CORE_VSTEPMIN, PRM_VP_MM_VSTEPMIN, PRM_VP_MPU_VSTEPMIN */
#define OMAP54XX_SMPSWAITTIMEMIN_SHIFT						8
#define OMAP54XX_SMPSWAITTIMEMIN_WIDTH						0x10
#define OMAP54XX_SMPSWAITTIMEMIN_MASK						(0xffff << 8)

/* Used by PRM_VC_CORE_ERRST */
#define OMAP54XX_SMPS_RA_ERR_CORE_SHIFT						1
#define OMAP54XX_SMPS_RA_ERR_CORE_WIDTH						0x1
#define OMAP54XX_SMPS_RA_ERR_CORE_MASK						(1 << 1)

/* Used by PRM_VC_MM_ERRST */
#define OMAP54XX_SMPS_RA_ERR_MM_SHIFT						1
#define OMAP54XX_SMPS_RA_ERR_MM_WIDTH						0x1
#define OMAP54XX_SMPS_RA_ERR_MM_MASK						(1 << 1)

/* Used by PRM_VC_MPU_ERRST */
#define OMAP54XX_SMPS_RA_ERR_MPU_SHIFT						1
#define OMAP54XX_SMPS_RA_ERR_MPU_WIDTH						0x1
#define OMAP54XX_SMPS_RA_ERR_MPU_MASK						(1 << 1)

/* Used by PRM_VC_CORE_ERRST */
#define OMAP54XX_SMPS_SA_ERR_CORE_SHIFT						0
#define OMAP54XX_SMPS_SA_ERR_CORE_WIDTH						0x1
#define OMAP54XX_SMPS_SA_ERR_CORE_MASK						(1 << 0)

/* Used by PRM_VC_MM_ERRST */
#define OMAP54XX_SMPS_SA_ERR_MM_SHIFT						0
#define OMAP54XX_SMPS_SA_ERR_MM_WIDTH						0x1
#define OMAP54XX_SMPS_SA_ERR_MM_MASK						(1 << 0)

/* Used by PRM_VC_MPU_ERRST */
#define OMAP54XX_SMPS_SA_ERR_MPU_SHIFT						0
#define OMAP54XX_SMPS_SA_ERR_MPU_WIDTH						0x1
#define OMAP54XX_SMPS_SA_ERR_MPU_MASK						(1 << 0)

/* Used by PRM_VC_CORE_ERRST */
#define OMAP54XX_SMPS_TIMEOUT_ERR_CORE_SHIFT					2
#define OMAP54XX_SMPS_TIMEOUT_ERR_CORE_WIDTH					0x1
#define OMAP54XX_SMPS_TIMEOUT_ERR_CORE_MASK					(1 << 2)

/* Used by PRM_VC_MM_ERRST */
#define OMAP54XX_SMPS_TIMEOUT_ERR_MM_SHIFT					2
#define OMAP54XX_SMPS_TIMEOUT_ERR_MM_WIDTH					0x1
#define OMAP54XX_SMPS_TIMEOUT_ERR_MM_MASK					(1 << 2)

/* Used by PRM_VC_MPU_ERRST */
#define OMAP54XX_SMPS_TIMEOUT_ERR_MPU_SHIFT					2
#define OMAP54XX_SMPS_TIMEOUT_ERR_MPU_WIDTH					0x1
#define OMAP54XX_SMPS_TIMEOUT_ERR_MPU_MASK					(1 << 2)

/* Used by PRM_ABBLDO_MM_SETUP, PRM_ABBLDO_MPU_SETUP */
#define OMAP54XX_SR2EN_SHIFT							0
#define OMAP54XX_SR2EN_WIDTH							0x1
#define OMAP54XX_SR2EN_MASK							(1 << 0)

/* Used by PRM_ABBLDO_MM_CTRL, PRM_ABBLDO_MPU_CTRL */
#define OMAP54XX_SR2_IN_TRANSITION_SHIFT					6
#define OMAP54XX_SR2_IN_TRANSITION_WIDTH					0x1
#define OMAP54XX_SR2_IN_TRANSITION_MASK						(1 << 6)

/* Used by PRM_ABBLDO_MM_CTRL, PRM_ABBLDO_MPU_CTRL */
#define OMAP54XX_SR2_STATUS_SHIFT						3
#define OMAP54XX_SR2_STATUS_WIDTH						0x2
#define OMAP54XX_SR2_STATUS_MASK						(0x3 << 3)

/* Used by PRM_ABBLDO_MM_SETUP, PRM_ABBLDO_MPU_SETUP */
#define OMAP54XX_SR2_WTCNT_VALUE_SHIFT						8
#define OMAP54XX_SR2_WTCNT_VALUE_WIDTH						0x8
#define OMAP54XX_SR2_WTCNT_VALUE_MASK						(0xff << 8)

/* Used by PRM_SLDO_CORE_CTRL, PRM_SLDO_MM_CTRL, PRM_SLDO_MPU_CTRL */
#define OMAP54XX_SRAMLDO_STATUS_SHIFT						8
#define OMAP54XX_SRAMLDO_STATUS_WIDTH						0x1
#define OMAP54XX_SRAMLDO_STATUS_MASK						(1 << 8)

/* Used by PRM_SLDO_CORE_CTRL, PRM_SLDO_MM_CTRL, PRM_SLDO_MPU_CTRL */
#define OMAP54XX_SRAM_IN_TRANSITION_SHIFT					9
#define OMAP54XX_SRAM_IN_TRANSITION_WIDTH					0x1
#define OMAP54XX_SRAM_IN_TRANSITION_MASK					(1 << 9)

/* Used by PRM_VC_CFG_I2C_MODE */
#define OMAP54XX_SRMODEEN_SHIFT							4
#define OMAP54XX_SRMODEEN_WIDTH							0x1
#define OMAP54XX_SRMODEEN_MASK							(1 << 4)

/* Used by PRM_VOLTSETUP_WARMRESET */
#define OMAP54XX_STABLE_COUNT_SHIFT						0
#define OMAP54XX_STABLE_COUNT_WIDTH						0x6
#define OMAP54XX_STABLE_COUNT_MASK						(0x3f << 0)

/* Used by PRM_VOLTSETUP_WARMRESET */
#define OMAP54XX_STABLE_PRESCAL_SHIFT						8
#define OMAP54XX_STABLE_PRESCAL_WIDTH						0x2
#define OMAP54XX_STABLE_PRESCAL_MASK						(0x3 << 8)

/* Used by PRM_BANDGAP_SETUP */
#define OMAP54XX_STARTUP_COUNT_SHIFT						0
#define OMAP54XX_STARTUP_COUNT_WIDTH						0x8
#define OMAP54XX_STARTUP_COUNT_MASK						(0xff << 0)

/* Renamed from STARTUP_COUNT Used by PRM_SRAM_COUNT */
#define OMAP54XX_STARTUP_COUNT_24_31_SHIFT					24
#define OMAP54XX_STARTUP_COUNT_24_31_WIDTH					0x8
#define OMAP54XX_STARTUP_COUNT_24_31_MASK					(0xff << 24)

/* Used by PM_IVA_PWRSTCTRL */
#define OMAP54XX_TCM1_MEM_ONSTATE_SHIFT						20
#define OMAP54XX_TCM1_MEM_ONSTATE_WIDTH						0x2
#define OMAP54XX_TCM1_MEM_ONSTATE_MASK						(0x3 << 20)

/* Used by PM_IVA_PWRSTCTRL */
#define OMAP54XX_TCM1_MEM_RETSTATE_SHIFT					10
#define OMAP54XX_TCM1_MEM_RETSTATE_WIDTH					0x1
#define OMAP54XX_TCM1_MEM_RETSTATE_MASK						(1 << 10)

/* Used by PM_IVA_PWRSTST */
#define OMAP54XX_TCM1_MEM_STATEST_SHIFT						8
#define OMAP54XX_TCM1_MEM_STATEST_WIDTH						0x2
#define OMAP54XX_TCM1_MEM_STATEST_MASK						(0x3 << 8)

/* Used by PM_IVA_PWRSTCTRL */
#define OMAP54XX_TCM2_MEM_ONSTATE_SHIFT						22
#define OMAP54XX_TCM2_MEM_ONSTATE_WIDTH						0x2
#define OMAP54XX_TCM2_MEM_ONSTATE_MASK						(0x3 << 22)

/* Used by PM_IVA_PWRSTCTRL */
#define OMAP54XX_TCM2_MEM_RETSTATE_SHIFT					11
#define OMAP54XX_TCM2_MEM_RETSTATE_WIDTH					0x1
#define OMAP54XX_TCM2_MEM_RETSTATE_MASK						(1 << 11)

/* Used by PM_IVA_PWRSTST */
#define OMAP54XX_TCM2_MEM_STATEST_SHIFT						10
#define OMAP54XX_TCM2_MEM_STATEST_WIDTH						0x2
#define OMAP54XX_TCM2_MEM_STATEST_MASK						(0x3 << 10)

/* Used by PRM_VP_CORE_VLIMITTO, PRM_VP_MM_VLIMITTO, PRM_VP_MPU_VLIMITTO */
#define OMAP54XX_TIMEOUT_SHIFT							0
#define OMAP54XX_TIMEOUT_WIDTH							0x10
#define OMAP54XX_TIMEOUT_MASK							(0xffff << 0)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_MM_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP54XX_TIMEOUTEN_SHIFT						3
#define OMAP54XX_TIMEOUTEN_WIDTH						0x1
#define OMAP54XX_TIMEOUTEN_MASK							(1 << 3)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_TRANSITION_EN_SHIFT						8
#define OMAP54XX_TRANSITION_EN_WIDTH						0x1
#define OMAP54XX_TRANSITION_EN_MASK						(1 << 8)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_TRANSITION_ST_SHIFT						8
#define OMAP54XX_TRANSITION_ST_WIDTH						0x1
#define OMAP54XX_TRANSITION_ST_MASK						(1 << 8)

/* Used by PRM_DEBUG_TRANS_CFG */
#define OMAP54XX_TRIGGER_CLEAR_SHIFT						2
#define OMAP54XX_TRIGGER_CLEAR_WIDTH						0x1
#define OMAP54XX_TRIGGER_CLEAR_MASK						(1 << 2)

/* Used by PRM_RSTST */
#define OMAP54XX_TSHUT_CORE_RST_SHIFT						13
#define OMAP54XX_TSHUT_CORE_RST_WIDTH						0x1
#define OMAP54XX_TSHUT_CORE_RST_MASK						(1 << 13)

/* Used by PRM_RSTST */
#define OMAP54XX_TSHUT_MM_RST_SHIFT						12
#define OMAP54XX_TSHUT_MM_RST_WIDTH						0x1
#define OMAP54XX_TSHUT_MM_RST_MASK						(1 << 12)

/* Used by PRM_RSTST */
#define OMAP54XX_TSHUT_MPU_RST_SHIFT						11
#define OMAP54XX_TSHUT_MPU_RST_WIDTH						0x1
#define OMAP54XX_TSHUT_MPU_RST_MASK						(1 << 11)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP54XX_VALID_SHIFT							24
#define OMAP54XX_VALID_WIDTH							0x1
#define OMAP54XX_VALID_MASK							(1 << 24)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VC_BYPASSACK_EN_SHIFT						14
#define OMAP54XX_VC_BYPASSACK_EN_WIDTH						0x1
#define OMAP54XX_VC_BYPASSACK_EN_MASK						(1 << 14)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VC_BYPASSACK_ST_SHIFT						14
#define OMAP54XX_VC_BYPASSACK_ST_WIDTH						0x1
#define OMAP54XX_VC_BYPASSACK_ST_MASK						(1 << 14)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VC_CORE_VPACK_EN_SHIFT						22
#define OMAP54XX_VC_CORE_VPACK_EN_WIDTH						0x1
#define OMAP54XX_VC_CORE_VPACK_EN_MASK						(1 << 22)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VC_CORE_VPACK_ST_SHIFT						22
#define OMAP54XX_VC_CORE_VPACK_ST_WIDTH						0x1
#define OMAP54XX_VC_CORE_VPACK_ST_MASK						(1 << 22)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VC_MM_VPACK_EN_SHIFT						30
#define OMAP54XX_VC_MM_VPACK_EN_WIDTH						0x1
#define OMAP54XX_VC_MM_VPACK_EN_MASK						(1 << 30)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VC_MM_VPACK_ST_SHIFT						30
#define OMAP54XX_VC_MM_VPACK_ST_WIDTH						0x1
#define OMAP54XX_VC_MM_VPACK_ST_MASK						(1 << 30)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP54XX_VC_MPU_VPACK_EN_SHIFT						6
#define OMAP54XX_VC_MPU_VPACK_EN_WIDTH						0x1
#define OMAP54XX_VC_MPU_VPACK_EN_MASK						(1 << 6)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP54XX_VC_MPU_VPACK_ST_SHIFT						6
#define OMAP54XX_VC_MPU_VPACK_ST_WIDTH						0x1
#define OMAP54XX_VC_MPU_VPACK_ST_MASK						(1 << 6)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VC_RAERR_EN_SHIFT						12
#define OMAP54XX_VC_RAERR_EN_WIDTH						0x1
#define OMAP54XX_VC_RAERR_EN_MASK						(1 << 12)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VC_RAERR_ST_SHIFT						12
#define OMAP54XX_VC_RAERR_ST_WIDTH						0x1
#define OMAP54XX_VC_RAERR_ST_MASK						(1 << 12)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VC_SAERR_EN_SHIFT						11
#define OMAP54XX_VC_SAERR_EN_WIDTH						0x1
#define OMAP54XX_VC_SAERR_EN_MASK						(1 << 11)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VC_SAERR_ST_SHIFT						11
#define OMAP54XX_VC_SAERR_ST_WIDTH						0x1
#define OMAP54XX_VC_SAERR_ST_MASK						(1 << 11)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VC_TOERR_EN_SHIFT						13
#define OMAP54XX_VC_TOERR_EN_WIDTH						0x1
#define OMAP54XX_VC_TOERR_EN_MASK						(1 << 13)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VC_TOERR_ST_SHIFT						13
#define OMAP54XX_VC_TOERR_ST_WIDTH						0x1
#define OMAP54XX_VC_TOERR_ST_MASK						(1 << 13)

/* Used by PRM_VP_CORE_VLIMITTO, PRM_VP_MM_VLIMITTO, PRM_VP_MPU_VLIMITTO */
#define OMAP54XX_VDDMAX_SHIFT							24
#define OMAP54XX_VDDMAX_WIDTH							0x8
#define OMAP54XX_VDDMAX_MASK							(0xff << 24)

/* Used by PRM_VP_CORE_VLIMITTO, PRM_VP_MM_VLIMITTO, PRM_VP_MPU_VLIMITTO */
#define OMAP54XX_VDDMIN_SHIFT							16
#define OMAP54XX_VDDMIN_WIDTH							0x8
#define OMAP54XX_VDDMIN_MASK							(0xff << 16)

/* Used by PRM_VOLTCTRL */
#define OMAP54XX_VDD_CORE_I2C_DISABLE_SHIFT					12
#define OMAP54XX_VDD_CORE_I2C_DISABLE_WIDTH					0x1
#define OMAP54XX_VDD_CORE_I2C_DISABLE_MASK					(1 << 12)

/* Used by PRM_RSTST */
#define OMAP54XX_VDD_CORE_VOLT_MGR_RST_SHIFT					8
#define OMAP54XX_VDD_CORE_VOLT_MGR_RST_WIDTH					0x1
#define OMAP54XX_VDD_CORE_VOLT_MGR_RST_MASK					(1 << 8)

/* Used by PRM_VOLTCTRL */
#define OMAP54XX_VDD_MM_I2C_DISABLE_SHIFT					14
#define OMAP54XX_VDD_MM_I2C_DISABLE_WIDTH					0x1
#define OMAP54XX_VDD_MM_I2C_DISABLE_MASK					(1 << 14)

/* Used by PRM_VOLTCTRL */
#define OMAP54XX_VDD_MM_PRESENCE_SHIFT						9
#define OMAP54XX_VDD_MM_PRESENCE_WIDTH						0x1
#define OMAP54XX_VDD_MM_PRESENCE_MASK						(1 << 9)

/* Used by PRM_RSTST */
#define OMAP54XX_VDD_MM_VOLT_MGR_RST_SHIFT					7
#define OMAP54XX_VDD_MM_VOLT_MGR_RST_WIDTH					0x1
#define OMAP54XX_VDD_MM_VOLT_MGR_RST_MASK					(1 << 7)

/* Used by PRM_VOLTCTRL */
#define OMAP54XX_VDD_MPU_I2C_DISABLE_SHIFT					13
#define OMAP54XX_VDD_MPU_I2C_DISABLE_WIDTH					0x1
#define OMAP54XX_VDD_MPU_I2C_DISABLE_MASK					(1 << 13)

/* Used by PRM_VOLTCTRL */
#define OMAP54XX_VDD_MPU_PRESENCE_SHIFT						8
#define OMAP54XX_VDD_MPU_PRESENCE_WIDTH						0x1
#define OMAP54XX_VDD_MPU_PRESENCE_MASK						(1 << 8)

/* Used by PRM_RSTST */
#define OMAP54XX_VDD_MPU_VOLT_MGR_RST_SHIFT					6
#define OMAP54XX_VDD_MPU_VOLT_MGR_RST_WIDTH					0x1
#define OMAP54XX_VDD_MPU_VOLT_MGR_RST_MASK					(1 << 6)

/* Used by PRM_VC_CORE_ERRST */
#define OMAP54XX_VFSM_RA_ERR_CORE_SHIFT						4
#define OMAP54XX_VFSM_RA_ERR_CORE_WIDTH						0x1
#define OMAP54XX_VFSM_RA_ERR_CORE_MASK						(1 << 4)

/* Used by PRM_VC_MM_ERRST */
#define OMAP54XX_VFSM_RA_ERR_MM_SHIFT						4
#define OMAP54XX_VFSM_RA_ERR_MM_WIDTH						0x1
#define OMAP54XX_VFSM_RA_ERR_MM_MASK						(1 << 4)

/* Used by PRM_VC_MPU_ERRST */
#define OMAP54XX_VFSM_RA_ERR_MPU_SHIFT						4
#define OMAP54XX_VFSM_RA_ERR_MPU_WIDTH						0x1
#define OMAP54XX_VFSM_RA_ERR_MPU_MASK						(1 << 4)

/* Used by PRM_VC_CORE_ERRST */
#define OMAP54XX_VFSM_SA_ERR_CORE_SHIFT						3
#define OMAP54XX_VFSM_SA_ERR_CORE_WIDTH						0x1
#define OMAP54XX_VFSM_SA_ERR_CORE_MASK						(1 << 3)

/* Used by PRM_VC_MM_ERRST */
#define OMAP54XX_VFSM_SA_ERR_MM_SHIFT						3
#define OMAP54XX_VFSM_SA_ERR_MM_WIDTH						0x1
#define OMAP54XX_VFSM_SA_ERR_MM_MASK						(1 << 3)

/* Used by PRM_VC_MPU_ERRST */
#define OMAP54XX_VFSM_SA_ERR_MPU_SHIFT						3
#define OMAP54XX_VFSM_SA_ERR_MPU_WIDTH						0x1
#define OMAP54XX_VFSM_SA_ERR_MPU_MASK						(1 << 3)

/* Used by PRM_VC_CORE_ERRST */
#define OMAP54XX_VFSM_TIMEOUT_ERR_CORE_SHIFT					5
#define OMAP54XX_VFSM_TIMEOUT_ERR_CORE_WIDTH					0x1
#define OMAP54XX_VFSM_TIMEOUT_ERR_CORE_MASK					(1 << 5)

/* Used by PRM_VC_MM_ERRST */
#define OMAP54XX_VFSM_TIMEOUT_ERR_MM_SHIFT					5
#define OMAP54XX_VFSM_TIMEOUT_ERR_MM_WIDTH					0x1
#define OMAP54XX_VFSM_TIMEOUT_ERR_MM_MASK					(1 << 5)

/* Used by PRM_VC_MPU_ERRST */
#define OMAP54XX_VFSM_TIMEOUT_ERR_MPU_SHIFT					5
#define OMAP54XX_VFSM_TIMEOUT_ERR_MPU_WIDTH					0x1
#define OMAP54XX_VFSM_TIMEOUT_ERR_MPU_MASK					(1 << 5)

/* Used by PRM_VC_SMPS_CORE_CONFIG */
#define OMAP54XX_VOLRA_VDD_CORE_L_SHIFT						8
#define OMAP54XX_VOLRA_VDD_CORE_L_WIDTH						0x8
#define OMAP54XX_VOLRA_VDD_CORE_L_MASK						(0xff << 8)

/* Used by PRM_VC_SMPS_MM_CONFIG */
#define OMAP54XX_VOLRA_VDD_MM_L_SHIFT						8
#define OMAP54XX_VOLRA_VDD_MM_L_WIDTH						0x8
#define OMAP54XX_VOLRA_VDD_MM_L_MASK						(0xff << 8)

/* Used by PRM_VC_SMPS_MPU_CONFIG */
#define OMAP54XX_VOLRA_VDD_MPU_L_SHIFT						8
#define OMAP54XX_VOLRA_VDD_MPU_L_WIDTH						0x8
#define OMAP54XX_VOLRA_VDD_MPU_L_MASK						(0xff << 8)

/* Used by PRM_VOLTST_MM, PRM_VOLTST_MPU */
#define OMAP54XX_VOLTSTATEST_SHIFT						0
#define OMAP54XX_VOLTSTATEST_WIDTH						0x2
#define OMAP54XX_VOLTSTATEST_MASK						(0x3 << 0)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_MM_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP54XX_VPENABLE_SHIFT							0
#define OMAP54XX_VPENABLE_WIDTH							0x1
#define OMAP54XX_VPENABLE_MASK							(1 << 0)

/* Used by PRM_VP_CORE_STATUS, PRM_VP_MM_STATUS, PRM_VP_MPU_STATUS */
#define OMAP54XX_VPINIDLE_SHIFT							0
#define OMAP54XX_VPINIDLE_WIDTH							0x1
#define OMAP54XX_VPINIDLE_MASK							(1 << 0)

/* Used by PRM_VP_CORE_VOLTAGE, PRM_VP_MM_VOLTAGE, PRM_VP_MPU_VOLTAGE */
#define OMAP54XX_VPVOLTAGE_SHIFT						0
#define OMAP54XX_VPVOLTAGE_WIDTH						0x8
#define OMAP54XX_VPVOLTAGE_MASK							(0xff << 0)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_CORE_EQVALUE_EN_SHIFT					20
#define OMAP54XX_VP_CORE_EQVALUE_EN_WIDTH					0x1
#define OMAP54XX_VP_CORE_EQVALUE_EN_MASK					(1 << 20)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_CORE_EQVALUE_ST_SHIFT					20
#define OMAP54XX_VP_CORE_EQVALUE_ST_WIDTH					0x1
#define OMAP54XX_VP_CORE_EQVALUE_ST_MASK					(1 << 20)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_CORE_MAXVDD_EN_SHIFT					18
#define OMAP54XX_VP_CORE_MAXVDD_EN_WIDTH					0x1
#define OMAP54XX_VP_CORE_MAXVDD_EN_MASK						(1 << 18)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_CORE_MAXVDD_ST_SHIFT					18
#define OMAP54XX_VP_CORE_MAXVDD_ST_WIDTH					0x1
#define OMAP54XX_VP_CORE_MAXVDD_ST_MASK						(1 << 18)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_CORE_MINVDD_EN_SHIFT					17
#define OMAP54XX_VP_CORE_MINVDD_EN_WIDTH					0x1
#define OMAP54XX_VP_CORE_MINVDD_EN_MASK						(1 << 17)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_CORE_MINVDD_ST_SHIFT					17
#define OMAP54XX_VP_CORE_MINVDD_ST_WIDTH					0x1
#define OMAP54XX_VP_CORE_MINVDD_ST_MASK						(1 << 17)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_CORE_NOSMPSACK_EN_SHIFT					19
#define OMAP54XX_VP_CORE_NOSMPSACK_EN_WIDTH					0x1
#define OMAP54XX_VP_CORE_NOSMPSACK_EN_MASK					(1 << 19)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_CORE_NOSMPSACK_ST_SHIFT					19
#define OMAP54XX_VP_CORE_NOSMPSACK_ST_WIDTH					0x1
#define OMAP54XX_VP_CORE_NOSMPSACK_ST_MASK					(1 << 19)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_CORE_OPPCHANGEDONE_EN_SHIFT					16
#define OMAP54XX_VP_CORE_OPPCHANGEDONE_EN_WIDTH					0x1
#define OMAP54XX_VP_CORE_OPPCHANGEDONE_EN_MASK					(1 << 16)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_CORE_OPPCHANGEDONE_ST_SHIFT					16
#define OMAP54XX_VP_CORE_OPPCHANGEDONE_ST_WIDTH					0x1
#define OMAP54XX_VP_CORE_OPPCHANGEDONE_ST_MASK					(1 << 16)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_CORE_TRANXDONE_EN_SHIFT					21
#define OMAP54XX_VP_CORE_TRANXDONE_EN_WIDTH					0x1
#define OMAP54XX_VP_CORE_TRANXDONE_EN_MASK					(1 << 21)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_CORE_TRANXDONE_ST_SHIFT					21
#define OMAP54XX_VP_CORE_TRANXDONE_ST_WIDTH					0x1
#define OMAP54XX_VP_CORE_TRANXDONE_ST_MASK					(1 << 21)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_MM_EQVALUE_EN_SHIFT						28
#define OMAP54XX_VP_MM_EQVALUE_EN_WIDTH						0x1
#define OMAP54XX_VP_MM_EQVALUE_EN_MASK						(1 << 28)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_MM_EQVALUE_ST_SHIFT						28
#define OMAP54XX_VP_MM_EQVALUE_ST_WIDTH						0x1
#define OMAP54XX_VP_MM_EQVALUE_ST_MASK						(1 << 28)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_MM_MAXVDD_EN_SHIFT						26
#define OMAP54XX_VP_MM_MAXVDD_EN_WIDTH						0x1
#define OMAP54XX_VP_MM_MAXVDD_EN_MASK						(1 << 26)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_MM_MAXVDD_ST_SHIFT						26
#define OMAP54XX_VP_MM_MAXVDD_ST_WIDTH						0x1
#define OMAP54XX_VP_MM_MAXVDD_ST_MASK						(1 << 26)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_MM_MINVDD_EN_SHIFT						25
#define OMAP54XX_VP_MM_MINVDD_EN_WIDTH						0x1
#define OMAP54XX_VP_MM_MINVDD_EN_MASK						(1 << 25)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_MM_MINVDD_ST_SHIFT						25
#define OMAP54XX_VP_MM_MINVDD_ST_WIDTH						0x1
#define OMAP54XX_VP_MM_MINVDD_ST_MASK						(1 << 25)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_MM_NOSMPSACK_EN_SHIFT					27
#define OMAP54XX_VP_MM_NOSMPSACK_EN_WIDTH					0x1
#define OMAP54XX_VP_MM_NOSMPSACK_EN_MASK					(1 << 27)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_MM_NOSMPSACK_ST_SHIFT					27
#define OMAP54XX_VP_MM_NOSMPSACK_ST_WIDTH					0x1
#define OMAP54XX_VP_MM_NOSMPSACK_ST_MASK					(1 << 27)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_MM_OPPCHANGEDONE_EN_SHIFT					24
#define OMAP54XX_VP_MM_OPPCHANGEDONE_EN_WIDTH					0x1
#define OMAP54XX_VP_MM_OPPCHANGEDONE_EN_MASK					(1 << 24)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_MM_OPPCHANGEDONE_ST_SHIFT					24
#define OMAP54XX_VP_MM_OPPCHANGEDONE_ST_WIDTH					0x1
#define OMAP54XX_VP_MM_OPPCHANGEDONE_ST_MASK					(1 << 24)

/* Used by PRM_IRQENABLE_IPU, PRM_IRQENABLE_MPU */
#define OMAP54XX_VP_MM_TRANXDONE_EN_SHIFT					29
#define OMAP54XX_VP_MM_TRANXDONE_EN_WIDTH					0x1
#define OMAP54XX_VP_MM_TRANXDONE_EN_MASK					(1 << 29)

/* Used by PRM_IRQSTATUS_IPU, PRM_IRQSTATUS_MPU */
#define OMAP54XX_VP_MM_TRANXDONE_ST_SHIFT					29
#define OMAP54XX_VP_MM_TRANXDONE_ST_WIDTH					0x1
#define OMAP54XX_VP_MM_TRANXDONE_ST_MASK					(1 << 29)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP54XX_VP_MPU_EQVALUE_EN_SHIFT					4
#define OMAP54XX_VP_MPU_EQVALUE_EN_WIDTH					0x1
#define OMAP54XX_VP_MPU_EQVALUE_EN_MASK						(1 << 4)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP54XX_VP_MPU_EQVALUE_ST_SHIFT					4
#define OMAP54XX_VP_MPU_EQVALUE_ST_WIDTH					0x1
#define OMAP54XX_VP_MPU_EQVALUE_ST_MASK						(1 << 4)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP54XX_VP_MPU_MAXVDD_EN_SHIFT						2
#define OMAP54XX_VP_MPU_MAXVDD_EN_WIDTH						0x1
#define OMAP54XX_VP_MPU_MAXVDD_EN_MASK						(1 << 2)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP54XX_VP_MPU_MAXVDD_ST_SHIFT						2
#define OMAP54XX_VP_MPU_MAXVDD_ST_WIDTH						0x1
#define OMAP54XX_VP_MPU_MAXVDD_ST_MASK						(1 << 2)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP54XX_VP_MPU_MINVDD_EN_SHIFT						1
#define OMAP54XX_VP_MPU_MINVDD_EN_WIDTH						0x1
#define OMAP54XX_VP_MPU_MINVDD_EN_MASK						(1 << 1)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP54XX_VP_MPU_MINVDD_ST_SHIFT						1
#define OMAP54XX_VP_MPU_MINVDD_ST_WIDTH						0x1
#define OMAP54XX_VP_MPU_MINVDD_ST_MASK						(1 << 1)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP54XX_VP_MPU_NOSMPSACK_EN_SHIFT					3
#define OMAP54XX_VP_MPU_NOSMPSACK_EN_WIDTH					0x1
#define OMAP54XX_VP_MPU_NOSMPSACK_EN_MASK					(1 << 3)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP54XX_VP_MPU_NOSMPSACK_ST_SHIFT					3
#define OMAP54XX_VP_MPU_NOSMPSACK_ST_WIDTH					0x1
#define OMAP54XX_VP_MPU_NOSMPSACK_ST_MASK					(1 << 3)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP54XX_VP_MPU_OPPCHANGEDONE_EN_SHIFT					0
#define OMAP54XX_VP_MPU_OPPCHANGEDONE_EN_WIDTH					0x1
#define OMAP54XX_VP_MPU_OPPCHANGEDONE_EN_MASK					(1 << 0)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP54XX_VP_MPU_OPPCHANGEDONE_ST_SHIFT					0
#define OMAP54XX_VP_MPU_OPPCHANGEDONE_ST_WIDTH					0x1
#define OMAP54XX_VP_MPU_OPPCHANGEDONE_ST_MASK					(1 << 0)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP54XX_VP_MPU_TRANXDONE_EN_SHIFT					5
#define OMAP54XX_VP_MPU_TRANXDONE_EN_WIDTH					0x1
#define OMAP54XX_VP_MPU_TRANXDONE_EN_MASK					(1 << 5)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP54XX_VP_MPU_TRANXDONE_ST_SHIFT					5
#define OMAP54XX_VP_MPU_TRANXDONE_ST_WIDTH					0x1
#define OMAP54XX_VP_MPU_TRANXDONE_ST_MASK					(1 << 5)

/* Used by PRM_SRAM_COUNT */
#define OMAP54XX_VSETUPCNT_VALUE_SHIFT						8
#define OMAP54XX_VSETUPCNT_VALUE_WIDTH						0x8
#define OMAP54XX_VSETUPCNT_VALUE_MASK						(0xff << 8)

/* Used by PRM_VP_CORE_VSTEPMAX, PRM_VP_MM_VSTEPMAX, PRM_VP_MPU_VSTEPMAX */
#define OMAP54XX_VSTEPMAX_SHIFT							0
#define OMAP54XX_VSTEPMAX_WIDTH							0x8
#define OMAP54XX_VSTEPMAX_MASK							(0xff << 0)

/* Used by PRM_VP_CORE_VSTEPMIN, PRM_VP_MM_VSTEPMIN, PRM_VP_MPU_VSTEPMIN */
#define OMAP54XX_VSTEPMIN_SHIFT							0
#define OMAP54XX_VSTEPMIN_WIDTH							0x8
#define OMAP54XX_VSTEPMIN_MASK							(0xff << 0)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DISPC_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_DISPC_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DISPC_DSP_MASK						(1 << 2)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DISPC_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_DISPC_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DISPC_IPU_MASK						(1 << 1)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DISPC_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_DISPC_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DISPC_MPU_MASK						(1 << 0)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DISPC_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_DISPC_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DISPC_SDMA_MASK					(1 << 3)

/* Used by PM_ABE_DMIC_WKDEP */
#define OMAP54XX_WKUPDEP_DMIC_DMA_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_DMIC_DMA_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DMIC_DMA_DSP_MASK					(1 << 6)

/* Used by PM_ABE_DMIC_WKDEP */
#define OMAP54XX_WKUPDEP_DMIC_DMA_SDMA_SHIFT					7
#define OMAP54XX_WKUPDEP_DMIC_DMA_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DMIC_DMA_SDMA_MASK					(1 << 7)

/* Used by PM_ABE_DMIC_WKDEP */
#define OMAP54XX_WKUPDEP_DMIC_IRQ_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_DMIC_IRQ_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DMIC_IRQ_DSP_MASK					(1 << 2)

/* Used by PM_ABE_DMIC_WKDEP */
#define OMAP54XX_WKUPDEP_DMIC_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_DMIC_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DMIC_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_A_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_DSI1_A_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_A_DSP_MASK					(1 << 6)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_A_IPU_SHIFT					5
#define OMAP54XX_WKUPDEP_DSI1_A_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_A_IPU_MASK					(1 << 5)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_A_MPU_SHIFT					4
#define OMAP54XX_WKUPDEP_DSI1_A_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_A_MPU_MASK					(1 << 4)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_A_SDMA_SHIFT					7
#define OMAP54XX_WKUPDEP_DSI1_A_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_A_SDMA_MASK					(1 << 7)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_B_DSP_SHIFT					10
#define OMAP54XX_WKUPDEP_DSI1_B_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_B_DSP_MASK					(1 << 10)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_B_IPU_SHIFT					9
#define OMAP54XX_WKUPDEP_DSI1_B_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_B_IPU_MASK					(1 << 9)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_B_MPU_SHIFT					8
#define OMAP54XX_WKUPDEP_DSI1_B_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_B_MPU_MASK					(1 << 8)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_B_SDMA_SHIFT					11
#define OMAP54XX_WKUPDEP_DSI1_B_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_B_SDMA_MASK					(1 << 11)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_C_DSP_SHIFT					17
#define OMAP54XX_WKUPDEP_DSI1_C_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_C_DSP_MASK					(1 << 17)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_C_IPU_SHIFT					16
#define OMAP54XX_WKUPDEP_DSI1_C_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_C_IPU_MASK					(1 << 16)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_C_MPU_SHIFT					15
#define OMAP54XX_WKUPDEP_DSI1_C_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_C_MPU_MASK					(1 << 15)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_DSI1_C_SDMA_SHIFT					18
#define OMAP54XX_WKUPDEP_DSI1_C_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_DSI1_C_SDMA_MASK					(1 << 18)

/* Used by PM_WKUPAON_GPIO1_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO1_IRQ1_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_GPIO1_IRQ1_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO1_IRQ1_IPU_MASK					(1 << 1)

/* Used by PM_WKUPAON_GPIO1_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO1_IRQ1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_GPIO1_IRQ1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO1_IRQ1_MPU_MASK					(1 << 0)

/* Used by PM_WKUPAON_GPIO1_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO1_IRQ2_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_GPIO1_IRQ2_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO1_IRQ2_DSP_MASK					(1 << 6)

/* Used by PM_L4PER_GPIO2_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO2_IRQ1_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_GPIO2_IRQ1_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO2_IRQ1_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_GPIO2_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO2_IRQ1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_GPIO2_IRQ1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO2_IRQ1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_GPIO2_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO2_IRQ2_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_GPIO2_IRQ2_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO2_IRQ2_DSP_MASK					(1 << 6)

/* Used by PM_L4PER_GPIO3_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO3_IRQ1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_GPIO3_IRQ1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO3_IRQ1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_GPIO3_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO3_IRQ2_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_GPIO3_IRQ2_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO3_IRQ2_DSP_MASK					(1 << 6)

/* Used by PM_L4PER_GPIO4_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO4_IRQ1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_GPIO4_IRQ1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO4_IRQ1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_GPIO4_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO4_IRQ2_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_GPIO4_IRQ2_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO4_IRQ2_DSP_MASK					(1 << 6)

/* Used by PM_L4PER_GPIO5_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO5_IRQ1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_GPIO5_IRQ1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO5_IRQ1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_GPIO5_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO5_IRQ2_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_GPIO5_IRQ2_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO5_IRQ2_DSP_MASK					(1 << 6)

/* Used by PM_L4PER_GPIO6_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO6_IRQ1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_GPIO6_IRQ1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO6_IRQ1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_GPIO6_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO6_IRQ2_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_GPIO6_IRQ2_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO6_IRQ2_DSP_MASK					(1 << 6)

/* Used by PM_L4PER_GPIO7_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO7_IRQ1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_GPIO7_IRQ1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO7_IRQ1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_GPIO8_WKDEP */
#define OMAP54XX_WKUPDEP_GPIO8_IRQ1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_GPIO8_IRQ1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_GPIO8_IRQ1_MPU_MASK					(1 << 0)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_HDMIDMA_SDMA_SHIFT					19
#define OMAP54XX_WKUPDEP_HDMIDMA_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_HDMIDMA_SDMA_MASK					(1 << 19)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_HDMIIRQ_DSP_SHIFT					14
#define OMAP54XX_WKUPDEP_HDMIIRQ_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_HDMIIRQ_DSP_MASK					(1 << 14)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_HDMIIRQ_IPU_SHIFT					13
#define OMAP54XX_WKUPDEP_HDMIIRQ_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_HDMIIRQ_IPU_MASK					(1 << 13)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP54XX_WKUPDEP_HDMIIRQ_MPU_SHIFT					12
#define OMAP54XX_WKUPDEP_HDMIIRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_HDMIIRQ_MPU_MASK					(1 << 12)

/* Used by PM_L3INIT_HSI_WKDEP */
#define OMAP54XX_WKUPDEP_HSI_DSP_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_HSI_DSP_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_HSI_DSP_DSP_MASK					(1 << 6)

/* Used by PM_L3INIT_HSI_WKDEP */
#define OMAP54XX_WKUPDEP_HSI_MCU_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_HSI_MCU_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_HSI_MCU_IPU_MASK					(1 << 1)

/* Used by PM_L3INIT_HSI_WKDEP */
#define OMAP54XX_WKUPDEP_HSI_MCU_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_HSI_MCU_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_HSI_MCU_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_I2C1_WKDEP */
#define OMAP54XX_WKUPDEP_I2C1_DMA_SDMA_SHIFT					7
#define OMAP54XX_WKUPDEP_I2C1_DMA_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C1_DMA_SDMA_MASK					(1 << 7)

/* Used by PM_L4PER_I2C1_WKDEP */
#define OMAP54XX_WKUPDEP_I2C1_IRQ_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_I2C1_IRQ_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C1_IRQ_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_I2C1_WKDEP */
#define OMAP54XX_WKUPDEP_I2C1_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_I2C1_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C1_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_I2C2_WKDEP */
#define OMAP54XX_WKUPDEP_I2C2_DMA_SDMA_SHIFT					7
#define OMAP54XX_WKUPDEP_I2C2_DMA_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C2_DMA_SDMA_MASK					(1 << 7)

/* Used by PM_L4PER_I2C2_WKDEP */
#define OMAP54XX_WKUPDEP_I2C2_IRQ_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_I2C2_IRQ_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C2_IRQ_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_I2C2_WKDEP */
#define OMAP54XX_WKUPDEP_I2C2_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_I2C2_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C2_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_I2C3_WKDEP */
#define OMAP54XX_WKUPDEP_I2C3_DMA_SDMA_SHIFT					7
#define OMAP54XX_WKUPDEP_I2C3_DMA_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C3_DMA_SDMA_MASK					(1 << 7)

/* Used by PM_L4PER_I2C3_WKDEP */
#define OMAP54XX_WKUPDEP_I2C3_IRQ_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_I2C3_IRQ_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C3_IRQ_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_I2C3_WKDEP */
#define OMAP54XX_WKUPDEP_I2C3_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_I2C3_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C3_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_I2C4_WKDEP */
#define OMAP54XX_WKUPDEP_I2C4_DMA_SDMA_SHIFT					7
#define OMAP54XX_WKUPDEP_I2C4_DMA_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C4_DMA_SDMA_MASK					(1 << 7)

/* Used by PM_L4PER_I2C4_WKDEP */
#define OMAP54XX_WKUPDEP_I2C4_IRQ_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_I2C4_IRQ_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C4_IRQ_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_I2C4_WKDEP */
#define OMAP54XX_WKUPDEP_I2C4_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_I2C4_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C4_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_I2C5_WKDEP */
#define OMAP54XX_WKUPDEP_I2C5_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_I2C5_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_I2C5_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_WKUPAON_KBD_WKDEP */
#define OMAP54XX_WKUPDEP_KBD_MPU_SHIFT						0
#define OMAP54XX_WKUPDEP_KBD_MPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_KBD_MPU_MASK						(1 << 0)

/* Used by PM_ABE_MCASP_WKDEP */
#define OMAP54XX_WKUPDEP_MCASP_DMA_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_MCASP_DMA_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCASP_DMA_DSP_MASK					(1 << 6)

/* Used by PM_ABE_MCASP_WKDEP */
#define OMAP54XX_WKUPDEP_MCASP_DMA_SDMA_SHIFT					7
#define OMAP54XX_WKUPDEP_MCASP_DMA_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCASP_DMA_SDMA_MASK					(1 << 7)

/* Used by PM_ABE_MCASP_WKDEP */
#define OMAP54XX_WKUPDEP_MCASP_IRQ_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_MCASP_IRQ_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCASP_IRQ_DSP_MASK					(1 << 2)

/* Used by PM_ABE_MCASP_WKDEP */
#define OMAP54XX_WKUPDEP_MCASP_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCASP_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCASP_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_ABE_MCBSP1_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP1_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_MCBSP1_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP1_DSP_MASK					(1 << 2)

/* Used by PM_ABE_MCBSP1_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCBSP1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP1_MPU_MASK					(1 << 0)

/* Used by PM_ABE_MCBSP1_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP1_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MCBSP1_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP1_SDMA_MASK					(1 << 3)

/* Used by PM_ABE_MCBSP2_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP2_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_MCBSP2_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP2_DSP_MASK					(1 << 2)

/* Used by PM_ABE_MCBSP2_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP2_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCBSP2_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP2_MPU_MASK					(1 << 0)

/* Used by PM_ABE_MCBSP2_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP2_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MCBSP2_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP2_SDMA_MASK					(1 << 3)

/* Used by PM_ABE_MCBSP3_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP3_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_MCBSP3_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP3_DSP_MASK					(1 << 2)

/* Used by PM_ABE_MCBSP3_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP3_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCBSP3_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP3_MPU_MASK					(1 << 0)

/* Used by PM_ABE_MCBSP3_WKDEP */
#define OMAP54XX_WKUPDEP_MCBSP3_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MCBSP3_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCBSP3_SDMA_MASK					(1 << 3)

/* Used by PM_ABE_MCPDM_WKDEP */
#define OMAP54XX_WKUPDEP_MCPDM_DMA_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_MCPDM_DMA_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCPDM_DMA_DSP_MASK					(1 << 6)

/* Used by PM_ABE_MCPDM_WKDEP */
#define OMAP54XX_WKUPDEP_MCPDM_DMA_SDMA_SHIFT					7
#define OMAP54XX_WKUPDEP_MCPDM_DMA_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCPDM_DMA_SDMA_MASK					(1 << 7)

/* Used by PM_ABE_MCPDM_WKDEP */
#define OMAP54XX_WKUPDEP_MCPDM_IRQ_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_MCPDM_IRQ_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCPDM_IRQ_DSP_MASK					(1 << 2)

/* Used by PM_ABE_MCPDM_WKDEP */
#define OMAP54XX_WKUPDEP_MCPDM_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCPDM_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCPDM_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_MCSPI1_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI1_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_MCSPI1_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI1_DSP_MASK					(1 << 2)

/* Used by PM_L4PER_MCSPI1_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI1_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_MCSPI1_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI1_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_MCSPI1_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCSPI1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_MCSPI1_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI1_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MCSPI1_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI1_SDMA_MASK					(1 << 3)

/* Used by PM_L4PER_MCSPI2_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI2_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_MCSPI2_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI2_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_MCSPI2_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI2_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCSPI2_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI2_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_MCSPI2_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI2_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MCSPI2_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI2_SDMA_MASK					(1 << 3)

/* Used by PM_L4PER_MCSPI3_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI3_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCSPI3_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI3_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_MCSPI3_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI3_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MCSPI3_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI3_SDMA_MASK					(1 << 3)

/* Used by PM_L4PER_MCSPI4_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI4_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_MCSPI4_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI4_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_MCSPI4_WKDEP */
#define OMAP54XX_WKUPDEP_MCSPI4_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MCSPI4_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MCSPI4_SDMA_MASK					(1 << 3)

/* Used by PM_L3INIT_MMC1_WKDEP */
#define OMAP54XX_WKUPDEP_MMC1_DSP_SHIFT						2
#define OMAP54XX_WKUPDEP_MMC1_DSP_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC1_DSP_MASK						(1 << 2)

/* Used by PM_L3INIT_MMC1_WKDEP */
#define OMAP54XX_WKUPDEP_MMC1_IPU_SHIFT						1
#define OMAP54XX_WKUPDEP_MMC1_IPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC1_IPU_MASK						(1 << 1)

/* Used by PM_L3INIT_MMC1_WKDEP */
#define OMAP54XX_WKUPDEP_MMC1_MPU_SHIFT						0
#define OMAP54XX_WKUPDEP_MMC1_MPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC1_MPU_MASK						(1 << 0)

/* Used by PM_L3INIT_MMC1_WKDEP */
#define OMAP54XX_WKUPDEP_MMC1_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MMC1_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MMC1_SDMA_MASK						(1 << 3)

/* Used by PM_L3INIT_MMC2_WKDEP */
#define OMAP54XX_WKUPDEP_MMC2_DSP_SHIFT						2
#define OMAP54XX_WKUPDEP_MMC2_DSP_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC2_DSP_MASK						(1 << 2)

/* Used by PM_L3INIT_MMC2_WKDEP */
#define OMAP54XX_WKUPDEP_MMC2_IPU_SHIFT						1
#define OMAP54XX_WKUPDEP_MMC2_IPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC2_IPU_MASK						(1 << 1)

/* Used by PM_L3INIT_MMC2_WKDEP */
#define OMAP54XX_WKUPDEP_MMC2_MPU_SHIFT						0
#define OMAP54XX_WKUPDEP_MMC2_MPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC2_MPU_MASK						(1 << 0)

/* Used by PM_L3INIT_MMC2_WKDEP */
#define OMAP54XX_WKUPDEP_MMC2_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MMC2_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MMC2_SDMA_MASK						(1 << 3)

/* Used by PM_L4PER_MMC3_WKDEP */
#define OMAP54XX_WKUPDEP_MMC3_IPU_SHIFT						1
#define OMAP54XX_WKUPDEP_MMC3_IPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC3_IPU_MASK						(1 << 1)

/* Used by PM_L4PER_MMC3_WKDEP */
#define OMAP54XX_WKUPDEP_MMC3_MPU_SHIFT						0
#define OMAP54XX_WKUPDEP_MMC3_MPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC3_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_MMC3_WKDEP */
#define OMAP54XX_WKUPDEP_MMC3_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MMC3_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MMC3_SDMA_MASK						(1 << 3)

/* Used by PM_L4PER_MMC4_WKDEP */
#define OMAP54XX_WKUPDEP_MMC4_MPU_SHIFT						0
#define OMAP54XX_WKUPDEP_MMC4_MPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC4_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_MMC4_WKDEP */
#define OMAP54XX_WKUPDEP_MMC4_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MMC4_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MMC4_SDMA_MASK						(1 << 3)

/* Used by PM_L4PER_MMC5_WKDEP */
#define OMAP54XX_WKUPDEP_MMC5_MPU_SHIFT						0
#define OMAP54XX_WKUPDEP_MMC5_MPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_MMC5_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_MMC5_WKDEP */
#define OMAP54XX_WKUPDEP_MMC5_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_MMC5_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_MMC5_SDMA_MASK						(1 << 3)

/* Used by PM_L3INIT_SATA_WKDEP */
#define OMAP54XX_WKUPDEP_SATA_MPU_SHIFT						0
#define OMAP54XX_WKUPDEP_SATA_MPU_WIDTH						0x1
#define OMAP54XX_WKUPDEP_SATA_MPU_MASK						(1 << 0)

/* Used by PM_ABE_SLIMBUS1_WKDEP */
#define OMAP54XX_WKUPDEP_SLIMBUS1_DMA_DSP_SHIFT					6
#define OMAP54XX_WKUPDEP_SLIMBUS1_DMA_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_SLIMBUS1_DMA_DSP_MASK					(1 << 6)

/* Used by PM_ABE_SLIMBUS1_WKDEP */
#define OMAP54XX_WKUPDEP_SLIMBUS1_DMA_SDMA_SHIFT				7
#define OMAP54XX_WKUPDEP_SLIMBUS1_DMA_SDMA_WIDTH				0x1
#define OMAP54XX_WKUPDEP_SLIMBUS1_DMA_SDMA_MASK					(1 << 7)

/* Used by PM_ABE_SLIMBUS1_WKDEP */
#define OMAP54XX_WKUPDEP_SLIMBUS1_IRQ_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_SLIMBUS1_IRQ_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_SLIMBUS1_IRQ_DSP_MASK					(1 << 2)

/* Used by PM_ABE_SLIMBUS1_WKDEP */
#define OMAP54XX_WKUPDEP_SLIMBUS1_IRQ_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_SLIMBUS1_IRQ_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_SLIMBUS1_IRQ_MPU_MASK					(1 << 0)

/* Used by PM_COREAON_SMARTREFLEX_CORE_WKDEP */
#define OMAP54XX_WKUPDEP_SMARTREFLEX_CORE_IPU_SHIFT				1
#define OMAP54XX_WKUPDEP_SMARTREFLEX_CORE_IPU_WIDTH				0x1
#define OMAP54XX_WKUPDEP_SMARTREFLEX_CORE_IPU_MASK				(1 << 1)

/* Used by PM_COREAON_SMARTREFLEX_CORE_WKDEP */
#define OMAP54XX_WKUPDEP_SMARTREFLEX_CORE_MPU_SHIFT				0
#define OMAP54XX_WKUPDEP_SMARTREFLEX_CORE_MPU_WIDTH				0x1
#define OMAP54XX_WKUPDEP_SMARTREFLEX_CORE_MPU_MASK				(1 << 0)

/* Used by PM_COREAON_SMARTREFLEX_MM_WKDEP */
#define OMAP54XX_WKUPDEP_SMARTREFLEX_MM_MPU_SHIFT				0
#define OMAP54XX_WKUPDEP_SMARTREFLEX_MM_MPU_WIDTH				0x1
#define OMAP54XX_WKUPDEP_SMARTREFLEX_MM_MPU_MASK				(1 << 0)

/* Used by PM_COREAON_SMARTREFLEX_MPU_WKDEP */
#define OMAP54XX_WKUPDEP_SMARTREFLEX_MPU_MPU_SHIFT				0
#define OMAP54XX_WKUPDEP_SMARTREFLEX_MPU_MPU_WIDTH				0x1
#define OMAP54XX_WKUPDEP_SMARTREFLEX_MPU_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_TIMER10_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER10_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER10_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER10_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_TIMER11_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER11_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_TIMER11_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER11_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_TIMER11_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER11_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER11_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER11_MPU_MASK					(1 << 0)

/* Used by PM_WKUPAON_TIMER12_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER12_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER12_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER12_MPU_MASK					(1 << 0)

/* Used by PM_WKUPAON_TIMER1_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_TIMER2_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER2_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER2_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER2_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_TIMER3_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER3_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_TIMER3_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER3_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_TIMER3_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER3_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER3_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER3_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_TIMER4_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER4_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_TIMER4_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER4_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_TIMER4_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER4_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER4_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER4_MPU_MASK					(1 << 0)

/* Used by PM_ABE_TIMER5_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER5_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_TIMER5_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER5_DSP_MASK					(1 << 2)

/* Used by PM_ABE_TIMER5_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER5_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER5_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER5_MPU_MASK					(1 << 0)

/* Used by PM_ABE_TIMER6_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER6_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_TIMER6_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER6_DSP_MASK					(1 << 2)

/* Used by PM_ABE_TIMER6_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER6_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER6_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER6_MPU_MASK					(1 << 0)

/* Used by PM_ABE_TIMER7_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER7_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_TIMER7_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER7_DSP_MASK					(1 << 2)

/* Used by PM_ABE_TIMER7_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER7_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER7_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER7_MPU_MASK					(1 << 0)

/* Used by PM_ABE_TIMER8_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER8_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_TIMER8_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER8_DSP_MASK					(1 << 2)

/* Used by PM_ABE_TIMER8_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER8_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER8_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER8_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_TIMER9_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER9_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_TIMER9_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER9_IPU_MASK					(1 << 1)

/* Used by PM_L4PER_TIMER9_WKDEP */
#define OMAP54XX_WKUPDEP_TIMER9_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_TIMER9_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_TIMER9_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_UART1_WKDEP */
#define OMAP54XX_WKUPDEP_UART1_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_UART1_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART1_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_UART1_WKDEP */
#define OMAP54XX_WKUPDEP_UART1_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_UART1_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART1_SDMA_MASK					(1 << 3)

/* Used by PM_L4PER_UART2_WKDEP */
#define OMAP54XX_WKUPDEP_UART2_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_UART2_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART2_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_UART2_WKDEP */
#define OMAP54XX_WKUPDEP_UART2_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_UART2_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART2_SDMA_MASK					(1 << 3)

/* Used by PM_L4PER_UART3_WKDEP */
#define OMAP54XX_WKUPDEP_UART3_DSP_SHIFT					2
#define OMAP54XX_WKUPDEP_UART3_DSP_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART3_DSP_MASK						(1 << 2)

/* Used by PM_L4PER_UART3_WKDEP */
#define OMAP54XX_WKUPDEP_UART3_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_UART3_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART3_IPU_MASK						(1 << 1)

/* Used by PM_L4PER_UART3_WKDEP */
#define OMAP54XX_WKUPDEP_UART3_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_UART3_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART3_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_UART3_WKDEP */
#define OMAP54XX_WKUPDEP_UART3_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_UART3_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART3_SDMA_MASK					(1 << 3)

/* Used by PM_L4PER_UART4_WKDEP */
#define OMAP54XX_WKUPDEP_UART4_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_UART4_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART4_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_UART4_WKDEP */
#define OMAP54XX_WKUPDEP_UART4_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_UART4_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART4_SDMA_MASK					(1 << 3)

/* Used by PM_L4PER_UART5_WKDEP */
#define OMAP54XX_WKUPDEP_UART5_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_UART5_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART5_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_UART5_WKDEP */
#define OMAP54XX_WKUPDEP_UART5_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_UART5_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART5_SDMA_MASK					(1 << 3)

/* Used by PM_L4PER_UART6_WKDEP */
#define OMAP54XX_WKUPDEP_UART6_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_UART6_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART6_MPU_MASK						(1 << 0)

/* Used by PM_L4PER_UART6_WKDEP */
#define OMAP54XX_WKUPDEP_UART6_SDMA_SHIFT					3
#define OMAP54XX_WKUPDEP_UART6_SDMA_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UART6_SDMA_MASK					(1 << 3)

/* Used by PM_L3INIT_UNIPRO2_WKDEP */
#define OMAP54XX_WKUPDEP_UNIPRO2_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_UNIPRO2_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_UNIPRO2_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_USB_HOST_HS_WKDEP */
#define OMAP54XX_WKUPDEP_USB_HOST_HS_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_USB_HOST_HS_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_USB_HOST_HS_IPU_MASK					(1 << 1)

/* Used by PM_L3INIT_USB_HOST_HS_WKDEP */
#define OMAP54XX_WKUPDEP_USB_HOST_HS_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_USB_HOST_HS_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_USB_HOST_HS_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_USB_OTG_SS_WKDEP */
#define OMAP54XX_WKUPDEP_USB_OTG_SS_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_USB_OTG_SS_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_USB_OTG_SS_IPU_MASK					(1 << 1)

/* Used by PM_L3INIT_USB_OTG_SS_WKDEP */
#define OMAP54XX_WKUPDEP_USB_OTG_SS_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_USB_OTG_SS_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_USB_OTG_SS_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_USB_TLL_HS_WKDEP */
#define OMAP54XX_WKUPDEP_USB_TLL_HS_IPU_SHIFT					1
#define OMAP54XX_WKUPDEP_USB_TLL_HS_IPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_USB_TLL_HS_IPU_MASK					(1 << 1)

/* Used by PM_L3INIT_USB_TLL_HS_WKDEP */
#define OMAP54XX_WKUPDEP_USB_TLL_HS_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_USB_TLL_HS_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_USB_TLL_HS_MPU_MASK					(1 << 0)

/* Used by PM_WKUPAON_WD_TIMER2_WKDEP */
#define OMAP54XX_WKUPDEP_WD_TIMER2_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_WD_TIMER2_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_WD_TIMER2_MPU_MASK					(1 << 0)

/* Used by PM_ABE_WD_TIMER3_WKDEP */
#define OMAP54XX_WKUPDEP_WD_TIMER3_MPU_SHIFT					0
#define OMAP54XX_WKUPDEP_WD_TIMER3_MPU_WIDTH					0x1
#define OMAP54XX_WKUPDEP_WD_TIMER3_MPU_MASK					(1 << 0)

/* Used by PRM_IO_PMCTRL */
#define OMAP54XX_WUCLK_CTRL_SHIFT						8
#define OMAP54XX_WUCLK_CTRL_WIDTH						0x1
#define OMAP54XX_WUCLK_CTRL_MASK						(1 << 8)

/* Used by PRM_IO_PMCTRL */
#define OMAP54XX_WUCLK_STATUS_SHIFT						9
#define OMAP54XX_WUCLK_STATUS_WIDTH						0x1
#define OMAP54XX_WUCLK_STATUS_MASK						(1 << 9)

/* Used by REVISION_PRM */
#define OMAP54XX_X_MAJOR_SHIFT							8
#define OMAP54XX_X_MAJOR_WIDTH							0x3
#define OMAP54XX_X_MAJOR_MASK							(0x7 << 8)

/* Used by REVISION_PRM */
#define OMAP54XX_Y_MINOR_SHIFT							0
#define OMAP54XX_Y_MINOR_WIDTH							0x6
#define OMAP54XX_Y_MINOR_MASK							(0x3f << 0)
#endif
