/*
 * OMAP44xx MUX registers and bitfields
 *
 * Copyright (C) 2009-2010 Texas Instruments, Inc.
 *
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_MUX_44XX_H
#define __ARCH_ARM_MACH_OMAP2_MUX_44XX_H

#define OMAP4_MUX(M0, mux_value)					\
{									\
	.reg_offset	= (OMAP4_CTRL_MODULE_PAD_##M0##_OFFSET),	\
	.value		= (mux_value),					\
}

/* ctrl_module_pad_core base address */
#define OMAP4_CTRL_MODULE_PAD_CORE_MUX_PBASE			0x4a100000

/* ctrl_module_pad_core registers offset */
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD0_OFFSET			0x0040
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD1_OFFSET			0x0042
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD2_OFFSET			0x0044
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD3_OFFSET			0x0046
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD4_OFFSET			0x0048
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD5_OFFSET			0x004a
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD6_OFFSET			0x004c
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD7_OFFSET			0x004e
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD8_OFFSET			0x0050
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD9_OFFSET			0x0052
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD10_OFFSET			0x0054
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD11_OFFSET			0x0056
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD12_OFFSET			0x0058
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD13_OFFSET			0x005a
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD14_OFFSET			0x005c
#define OMAP4_CTRL_MODULE_PAD_GPMC_AD15_OFFSET			0x005e
#define OMAP4_CTRL_MODULE_PAD_GPMC_A16_OFFSET			0x0060
#define OMAP4_CTRL_MODULE_PAD_GPMC_A17_OFFSET			0x0062
#define OMAP4_CTRL_MODULE_PAD_GPMC_A18_OFFSET			0x0064
#define OMAP4_CTRL_MODULE_PAD_GPMC_A19_OFFSET			0x0066
#define OMAP4_CTRL_MODULE_PAD_GPMC_A20_OFFSET			0x0068
#define OMAP4_CTRL_MODULE_PAD_GPMC_A21_OFFSET			0x006a
#define OMAP4_CTRL_MODULE_PAD_GPMC_A22_OFFSET			0x006c
#define OMAP4_CTRL_MODULE_PAD_GPMC_A23_OFFSET			0x006e
#define OMAP4_CTRL_MODULE_PAD_GPMC_A24_OFFSET			0x0070
#define OMAP4_CTRL_MODULE_PAD_GPMC_A25_OFFSET			0x0072
#define OMAP4_CTRL_MODULE_PAD_GPMC_NCS0_OFFSET			0x0074
#define OMAP4_CTRL_MODULE_PAD_GPMC_NCS1_OFFSET			0x0076
#define OMAP4_CTRL_MODULE_PAD_GPMC_NCS2_OFFSET			0x0078
#define OMAP4_CTRL_MODULE_PAD_GPMC_NCS3_OFFSET			0x007a
#define OMAP4_CTRL_MODULE_PAD_GPMC_NWP_OFFSET			0x007c
#define OMAP4_CTRL_MODULE_PAD_GPMC_CLK_OFFSET			0x007e
#define OMAP4_CTRL_MODULE_PAD_GPMC_NADV_ALE_OFFSET		0x0080
#define OMAP4_CTRL_MODULE_PAD_GPMC_NOE_OFFSET			0x0082
#define OMAP4_CTRL_MODULE_PAD_GPMC_NWE_OFFSET			0x0084
#define OMAP4_CTRL_MODULE_PAD_GPMC_NBE0_CLE_OFFSET		0x0086
#define OMAP4_CTRL_MODULE_PAD_GPMC_NBE1_OFFSET			0x0088
#define OMAP4_CTRL_MODULE_PAD_GPMC_WAIT0_OFFSET			0x008a
#define OMAP4_CTRL_MODULE_PAD_GPMC_WAIT1_OFFSET			0x008c
#define OMAP4_CTRL_MODULE_PAD_C2C_DATA11_OFFSET			0x008e
#define OMAP4_CTRL_MODULE_PAD_C2C_DATA12_OFFSET			0x0090
#define OMAP4_CTRL_MODULE_PAD_C2C_DATA13_OFFSET			0x0092
#define OMAP4_CTRL_MODULE_PAD_C2C_DATA14_OFFSET			0x0094
#define OMAP4_CTRL_MODULE_PAD_C2C_DATA15_OFFSET			0x0096
#define OMAP4_CTRL_MODULE_PAD_HDMI_HPD_OFFSET			0x0098
#define OMAP4_CTRL_MODULE_PAD_HDMI_CEC_OFFSET			0x009a
#define OMAP4_CTRL_MODULE_PAD_HDMI_DDC_SCL_OFFSET		0x009c
#define OMAP4_CTRL_MODULE_PAD_HDMI_DDC_SDA_OFFSET		0x009e
#define OMAP4_CTRL_MODULE_PAD_CSI21_DX0_OFFSET			0x00a0
#define OMAP4_CTRL_MODULE_PAD_CSI21_DY0_OFFSET			0x00a2
#define OMAP4_CTRL_MODULE_PAD_CSI21_DX1_OFFSET			0x00a4
#define OMAP4_CTRL_MODULE_PAD_CSI21_DY1_OFFSET			0x00a6
#define OMAP4_CTRL_MODULE_PAD_CSI21_DX2_OFFSET			0x00a8
#define OMAP4_CTRL_MODULE_PAD_CSI21_DY2_OFFSET			0x00aa
#define OMAP4_CTRL_MODULE_PAD_CSI21_DX3_OFFSET			0x00ac
#define OMAP4_CTRL_MODULE_PAD_CSI21_DY3_OFFSET			0x00ae
#define OMAP4_CTRL_MODULE_PAD_CSI21_DX4_OFFSET			0x00b0
#define OMAP4_CTRL_MODULE_PAD_CSI21_DY4_OFFSET			0x00b2
#define OMAP4_CTRL_MODULE_PAD_CSI22_DX0_OFFSET			0x00b4
#define OMAP4_CTRL_MODULE_PAD_CSI22_DY0_OFFSET			0x00b6
#define OMAP4_CTRL_MODULE_PAD_CSI22_DX1_OFFSET			0x00b8
#define OMAP4_CTRL_MODULE_PAD_CSI22_DY1_OFFSET			0x00ba
#define OMAP4_CTRL_MODULE_PAD_CAM_SHUTTER_OFFSET		0x00bc
#define OMAP4_CTRL_MODULE_PAD_CAM_STROBE_OFFSET			0x00be
#define OMAP4_CTRL_MODULE_PAD_CAM_GLOBALRESET_OFFSET		0x00c0
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_CLK_OFFSET		0x00c2
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_STP_OFFSET		0x00c4
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DIR_OFFSET		0x00c6
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_NXT_OFFSET		0x00c8
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DAT0_OFFSET		0x00ca
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DAT1_OFFSET		0x00cc
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DAT2_OFFSET		0x00ce
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DAT3_OFFSET		0x00d0
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DAT4_OFFSET		0x00d2
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DAT5_OFFSET		0x00d4
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DAT6_OFFSET		0x00d6
#define OMAP4_CTRL_MODULE_PAD_USBB1_ULPITLL_DAT7_OFFSET		0x00d8
#define OMAP4_CTRL_MODULE_PAD_USBB1_HSIC_DATA_OFFSET		0x00da
#define OMAP4_CTRL_MODULE_PAD_USBB1_HSIC_STROBE_OFFSET		0x00dc
#define OMAP4_CTRL_MODULE_PAD_USBC1_ICUSB_DP_OFFSET		0x00de
#define OMAP4_CTRL_MODULE_PAD_USBC1_ICUSB_DM_OFFSET		0x00e0
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_CLK_OFFSET			0x00e2
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_CMD_OFFSET			0x00e4
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_DAT0_OFFSET		0x00e6
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_DAT1_OFFSET		0x00e8
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_DAT2_OFFSET		0x00ea
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_DAT3_OFFSET		0x00ec
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_DAT4_OFFSET		0x00ee
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_DAT5_OFFSET		0x00f0
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_DAT6_OFFSET		0x00f2
#define OMAP4_CTRL_MODULE_PAD_SDMMC1_DAT7_OFFSET		0x00f4
#define OMAP4_CTRL_MODULE_PAD_ABE_MCBSP2_CLKX_OFFSET		0x00f6
#define OMAP4_CTRL_MODULE_PAD_ABE_MCBSP2_DR_OFFSET		0x00f8
#define OMAP4_CTRL_MODULE_PAD_ABE_MCBSP2_DX_OFFSET		0x00fa
#define OMAP4_CTRL_MODULE_PAD_ABE_MCBSP2_FSX_OFFSET		0x00fc
#define OMAP4_CTRL_MODULE_PAD_ABE_MCBSP1_CLKX_OFFSET		0x00fe
#define OMAP4_CTRL_MODULE_PAD_ABE_MCBSP1_DR_OFFSET		0x0100
#define OMAP4_CTRL_MODULE_PAD_ABE_MCBSP1_DX_OFFSET		0x0102
#define OMAP4_CTRL_MODULE_PAD_ABE_MCBSP1_FSX_OFFSET		0x0104
#define OMAP4_CTRL_MODULE_PAD_ABE_PDM_UL_DATA_OFFSET		0x0106
#define OMAP4_CTRL_MODULE_PAD_ABE_PDM_DL_DATA_OFFSET		0x0108
#define OMAP4_CTRL_MODULE_PAD_ABE_PDM_FRAME_OFFSET		0x010a
#define OMAP4_CTRL_MODULE_PAD_ABE_PDM_LB_CLK_OFFSET		0x010c
#define OMAP4_CTRL_MODULE_PAD_ABE_CLKS_OFFSET			0x010e
#define OMAP4_CTRL_MODULE_PAD_ABE_DMIC_CLK1_OFFSET		0x0110
#define OMAP4_CTRL_MODULE_PAD_ABE_DMIC_DIN1_OFFSET		0x0112
#define OMAP4_CTRL_MODULE_PAD_ABE_DMIC_DIN2_OFFSET		0x0114
#define OMAP4_CTRL_MODULE_PAD_ABE_DMIC_DIN3_OFFSET		0x0116
#define OMAP4_CTRL_MODULE_PAD_UART2_CTS_OFFSET			0x0118
#define OMAP4_CTRL_MODULE_PAD_UART2_RTS_OFFSET			0x011a
#define OMAP4_CTRL_MODULE_PAD_UART2_RX_OFFSET			0x011c
#define OMAP4_CTRL_MODULE_PAD_UART2_TX_OFFSET			0x011e
#define OMAP4_CTRL_MODULE_PAD_HDQ_SIO_OFFSET			0x0120
#define OMAP4_CTRL_MODULE_PAD_I2C1_SCL_OFFSET			0x0122
#define OMAP4_CTRL_MODULE_PAD_I2C1_SDA_OFFSET			0x0124
#define OMAP4_CTRL_MODULE_PAD_I2C2_SCL_OFFSET			0x0126
#define OMAP4_CTRL_MODULE_PAD_I2C2_SDA_OFFSET			0x0128
#define OMAP4_CTRL_MODULE_PAD_I2C3_SCL_OFFSET			0x012a
#define OMAP4_CTRL_MODULE_PAD_I2C3_SDA_OFFSET			0x012c
#define OMAP4_CTRL_MODULE_PAD_I2C4_SCL_OFFSET			0x012e
#define OMAP4_CTRL_MODULE_PAD_I2C4_SDA_OFFSET			0x0130
#define OMAP4_CTRL_MODULE_PAD_MCSPI1_CLK_OFFSET			0x0132
#define OMAP4_CTRL_MODULE_PAD_MCSPI1_SOMI_OFFSET		0x0134
#define OMAP4_CTRL_MODULE_PAD_MCSPI1_SIMO_OFFSET		0x0136
#define OMAP4_CTRL_MODULE_PAD_MCSPI1_CS0_OFFSET			0x0138
#define OMAP4_CTRL_MODULE_PAD_MCSPI1_CS1_OFFSET			0x013a
#define OMAP4_CTRL_MODULE_PAD_MCSPI1_CS2_OFFSET			0x013c
#define OMAP4_CTRL_MODULE_PAD_MCSPI1_CS3_OFFSET			0x013e
#define OMAP4_CTRL_MODULE_PAD_UART3_CTS_RCTX_OFFSET		0x0140
#define OMAP4_CTRL_MODULE_PAD_UART3_RTS_SD_OFFSET		0x0142
#define OMAP4_CTRL_MODULE_PAD_UART3_RX_IRRX_OFFSET		0x0144
#define OMAP4_CTRL_MODULE_PAD_UART3_TX_IRTX_OFFSET		0x0146
#define OMAP4_CTRL_MODULE_PAD_SDMMC5_CLK_OFFSET			0x0148
#define OMAP4_CTRL_MODULE_PAD_SDMMC5_CMD_OFFSET			0x014a
#define OMAP4_CTRL_MODULE_PAD_SDMMC5_DAT0_OFFSET		0x014c
#define OMAP4_CTRL_MODULE_PAD_SDMMC5_DAT1_OFFSET		0x014e
#define OMAP4_CTRL_MODULE_PAD_SDMMC5_DAT2_OFFSET		0x0150
#define OMAP4_CTRL_MODULE_PAD_SDMMC5_DAT3_OFFSET		0x0152
#define OMAP4_CTRL_MODULE_PAD_MCSPI4_CLK_OFFSET			0x0154
#define OMAP4_CTRL_MODULE_PAD_MCSPI4_SIMO_OFFSET		0x0156
#define OMAP4_CTRL_MODULE_PAD_MCSPI4_SOMI_OFFSET		0x0158
#define OMAP4_CTRL_MODULE_PAD_MCSPI4_CS0_OFFSET			0x015a
#define OMAP4_CTRL_MODULE_PAD_UART4_RX_OFFSET			0x015c
#define OMAP4_CTRL_MODULE_PAD_UART4_TX_OFFSET			0x015e
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_CLK_OFFSET		0x0160
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_STP_OFFSET		0x0162
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DIR_OFFSET		0x0164
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_NXT_OFFSET		0x0166
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DAT0_OFFSET		0x0168
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DAT1_OFFSET		0x016a
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DAT2_OFFSET		0x016c
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DAT3_OFFSET		0x016e
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DAT4_OFFSET		0x0170
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DAT5_OFFSET		0x0172
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DAT6_OFFSET		0x0174
#define OMAP4_CTRL_MODULE_PAD_USBB2_ULPITLL_DAT7_OFFSET		0x0176
#define OMAP4_CTRL_MODULE_PAD_USBB2_HSIC_DATA_OFFSET		0x0178
#define OMAP4_CTRL_MODULE_PAD_USBB2_HSIC_STROBE_OFFSET		0x017a
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_TX0_OFFSET			0x017c
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_TY0_OFFSET			0x017e
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_TX1_OFFSET			0x0180
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_TY1_OFFSET			0x0182
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_TX2_OFFSET			0x0184
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_TY2_OFFSET			0x0186
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_RX0_OFFSET			0x0188
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_RY0_OFFSET			0x018a
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_RX1_OFFSET			0x018c
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_RY1_OFFSET			0x018e
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_RX2_OFFSET			0x0190
#define OMAP4_CTRL_MODULE_PAD_UNIPRO_RY2_OFFSET			0x0192
#define OMAP4_CTRL_MODULE_PAD_USBA0_OTG_CE_OFFSET		0x0194
#define OMAP4_CTRL_MODULE_PAD_USBA0_OTG_DP_OFFSET		0x0196
#define OMAP4_CTRL_MODULE_PAD_USBA0_OTG_DM_OFFSET		0x0198
#define OMAP4_CTRL_MODULE_PAD_FREF_CLK1_OUT_OFFSET		0x019a
#define OMAP4_CTRL_MODULE_PAD_FREF_CLK2_OUT_OFFSET		0x019c
#define OMAP4_CTRL_MODULE_PAD_SYS_NIRQ1_OFFSET			0x019e
#define OMAP4_CTRL_MODULE_PAD_SYS_NIRQ2_OFFSET			0x01a0
#define OMAP4_CTRL_MODULE_PAD_SYS_BOOT0_OFFSET			0x01a2
#define OMAP4_CTRL_MODULE_PAD_SYS_BOOT1_OFFSET			0x01a4
#define OMAP4_CTRL_MODULE_PAD_SYS_BOOT2_OFFSET			0x01a6
#define OMAP4_CTRL_MODULE_PAD_SYS_BOOT3_OFFSET			0x01a8
#define OMAP4_CTRL_MODULE_PAD_SYS_BOOT4_OFFSET			0x01aa
#define OMAP4_CTRL_MODULE_PAD_SYS_BOOT5_OFFSET			0x01ac
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU0_OFFSET			0x01ae
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU1_OFFSET			0x01b0
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU2_OFFSET			0x01b2
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU3_OFFSET			0x01b4
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU4_OFFSET			0x01b6
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU5_OFFSET			0x01b8
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU6_OFFSET			0x01ba
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU7_OFFSET			0x01bc
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU8_OFFSET			0x01be
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU9_OFFSET			0x01c0
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU10_OFFSET			0x01c2
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU11_OFFSET			0x01c4
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU12_OFFSET			0x01c6
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU13_OFFSET			0x01c8
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU14_OFFSET			0x01ca
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU15_OFFSET			0x01cc
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU16_OFFSET			0x01ce
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU17_OFFSET			0x01d0
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU18_OFFSET			0x01d2
#define OMAP4_CTRL_MODULE_PAD_DPM_EMU19_OFFSET			0x01d4

/* ES2.0 only */
#define OMAP4_CTRL_MODULE_PAD_GPMC_WAIT2_OFFSET			0x008e
#define OMAP4_CTRL_MODULE_PAD_GPMC_NCS4_OFFSET			0x0090
#define OMAP4_CTRL_MODULE_PAD_GPMC_NCS5_OFFSET			0x0092
#define OMAP4_CTRL_MODULE_PAD_GPMC_NCS6_OFFSET			0x0094
#define OMAP4_CTRL_MODULE_PAD_GPMC_NCS7_OFFSET			0x0096

#define OMAP4_CTRL_MODULE_PAD_KPD_COL3_OFFSET			0x017c
#define OMAP4_CTRL_MODULE_PAD_KPD_COL4_OFFSET			0x017e
#define OMAP4_CTRL_MODULE_PAD_KPD_COL5_OFFSET			0x0180
#define OMAP4_CTRL_MODULE_PAD_KPD_COL0_OFFSET			0x0182
#define OMAP4_CTRL_MODULE_PAD_KPD_COL1_OFFSET			0x0184
#define OMAP4_CTRL_MODULE_PAD_KPD_COL2_OFFSET			0x0186
#define OMAP4_CTRL_MODULE_PAD_KPD_ROW3_OFFSET			0x0188
#define OMAP4_CTRL_MODULE_PAD_KPD_ROW4_OFFSET			0x018a
#define OMAP4_CTRL_MODULE_PAD_KPD_ROW5_OFFSET			0x018c
#define OMAP4_CTRL_MODULE_PAD_KPD_ROW0_OFFSET			0x018e
#define OMAP4_CTRL_MODULE_PAD_KPD_ROW1_OFFSET			0x0190
#define OMAP4_CTRL_MODULE_PAD_KPD_ROW2_OFFSET			0x0192


#define OMAP4_CTRL_MODULE_PAD_CORE_MUX_SIZE			\
		(OMAP4_CTRL_MODULE_PAD_DPM_EMU19_OFFSET		\
		 - OMAP4_CTRL_MODULE_PAD_GPMC_AD0_OFFSET + 2)

/* ctrl_module_pad_wkup base address */
#define OMAP4_CTRL_MODULE_PAD_WKUP_MUX_PBASE			0x4a31e000

/* ctrl_module_pad_wkup registers offset */
#define OMAP4_CTRL_MODULE_PAD_SIM_IO_OFFSET			0x0040
#define OMAP4_CTRL_MODULE_PAD_SIM_CLK_OFFSET			0x0042
#define OMAP4_CTRL_MODULE_PAD_SIM_RESET_OFFSET			0x0044
#define OMAP4_CTRL_MODULE_PAD_SIM_CD_OFFSET			0x0046
#define OMAP4_CTRL_MODULE_PAD_SIM_PWRCTRL_OFFSET		0x0048
#define OMAP4_CTRL_MODULE_PAD_SR_SCL_OFFSET			0x004a
#define OMAP4_CTRL_MODULE_PAD_SR_SDA_OFFSET			0x004c
#define OMAP4_CTRL_MODULE_PAD_FREF_XTAL_IN_OFFSET		0x004e
#define OMAP4_CTRL_MODULE_PAD_FREF_SLICER_IN_OFFSET		0x0050
#define OMAP4_CTRL_MODULE_PAD_FREF_CLK_IOREQ_OFFSET		0x0052
#define OMAP4_CTRL_MODULE_PAD_FREF_CLK0_OUT_OFFSET		0x0054
#define OMAP4_CTRL_MODULE_PAD_FREF_CLK3_REQ_OFFSET		0x0056
#define OMAP4_CTRL_MODULE_PAD_FREF_CLK3_OUT_OFFSET		0x0058
#define OMAP4_CTRL_MODULE_PAD_FREF_CLK4_REQ_OFFSET		0x005a
#define OMAP4_CTRL_MODULE_PAD_FREF_CLK4_OUT_OFFSET		0x005c
#define OMAP4_CTRL_MODULE_PAD_SYS_32K_OFFSET			0x005e
#define OMAP4_CTRL_MODULE_PAD_SYS_NRESPWRON_OFFSET		0x0060
#define OMAP4_CTRL_MODULE_PAD_SYS_NRESWARM_OFFSET		0x0062
#define OMAP4_CTRL_MODULE_PAD_SYS_PWR_REQ_OFFSET		0x0064
#define OMAP4_CTRL_MODULE_PAD_SYS_PWRON_RESET_OUT_OFFSET	0x0066
#define OMAP4_CTRL_MODULE_PAD_SYS_BOOT6_OFFSET			0x0068
#define OMAP4_CTRL_MODULE_PAD_SYS_BOOT7_OFFSET			0x006a
#define OMAP4_CTRL_MODULE_PAD_JTAG_NTRST_OFFSET			0x006c
#define OMAP4_CTRL_MODULE_PAD_JTAG_TCK_OFFSET			0x006e
#define OMAP4_CTRL_MODULE_PAD_JTAG_RTCK_OFFSET			0x0070
#define OMAP4_CTRL_MODULE_PAD_JTAG_TMS_TMSC_OFFSET		0x0072
#define OMAP4_CTRL_MODULE_PAD_JTAG_TDI_OFFSET			0x0074
#define OMAP4_CTRL_MODULE_PAD_JTAG_TDO_OFFSET			0x0076

#define OMAP4_CTRL_MODULE_PAD_WKUP_MUX_SIZE			\
		(OMAP4_CTRL_MODULE_PAD_JTAG_TDO_OFFSET		\
		 - OMAP4_CTRL_MODULE_PAD_SIM_IO_OFFSET + 2)

#endif
