/*
 * Copyright (c) 1996, 2003 VIA Networking Technologies, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *
 * File: baseband.c
 *
 * Purpose: Implement functions to access baseband
 *
 * Author: Yiching Chen
 *
 * Date: May 20, 2004
 *
 * Functions:
 *
 * Revision History:
 *
 */

#include "firmware.h"
#include "control.h"
#include "rndis.h"

/*---------------------  Static Definitions -------------------------*/

static int          msglevel                =MSG_LEVEL_INFO;
//static int          msglevel                =MSG_LEVEL_DEBUG;
/*---------------------  Static Classes  ----------------------------*/

/*---------------------  Static Variables  --------------------------*/

/*---------------------  Static Functions  --------------------------*/

/*---------------------  Export Variables  --------------------------*/

/*
 *  This is firmware version 1.51
 */
#define FIRMWARE_VERSION        0x133

const BYTE abyFirmware[] = {

0x02, 0x35, 0x62, 0x02, 0x3B, 0xED, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x02, 0x3E, 0x21, 0xD2, 0x04,
0x90, 0x06, 0x24, 0x74, 0x08, 0xF0, 0x90, 0x06, 0x21, 0xE0, 0x90, 0x45, 0x39, 0xF0, 0xE0, 0x90,
0x06, 0x21, 0xF0, 0x90, 0x06, 0x10, 0xE0, 0x54, 0x60, 0x60, 0x03, 0x02, 0x1A, 0xE9, 0xA3, 0xE0,
0x12, 0x28, 0x7E, 0x18, 0x15, 0x00, 0x18, 0xF6, 0x01, 0x19, 0xD1, 0x03, 0x16, 0x79, 0x05, 0x12,
0x52, 0x06, 0x17, 0xE5, 0x08, 0x16, 0xAF, 0x09, 0x17, 0x33, 0x0A, 0x17, 0x91, 0x0B, 0x00, 0x00,
0x1A, 0xE1, 0x90, 0x06, 0x17, 0xE0, 0xFE, 0x90, 0x06, 0x16, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x31,
0xF0, 0xED, 0xA3, 0xF0, 0x90, 0x10, 0x3D, 0x74, 0x05, 0xF0, 0x90, 0x06, 0x24, 0x74, 0x08, 0xF0,
0x90, 0x06, 0x13, 0xE0, 0x24, 0xFE, 0x60, 0x47, 0x14, 0x70, 0x03, 0x02, 0x14, 0x79, 0x24, 0xFD,
0x60, 0x25, 0x14, 0x70, 0x03, 0x02, 0x13, 0x9C, 0x24, 0x06, 0x60, 0x03, 0x02, 0x16, 0x54, 0x7B,
0x01, 0x7A, 0x10, 0x79, 0x8B, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90, 0x10, 0x4C, 0xE4, 0xF0,
0xA3, 0x74, 0x12, 0xF0, 0x02, 0x16, 0x5C, 0x7B, 0x01, 0x7A, 0x10, 0x79, 0x81, 0x90, 0x10, 0x46,
0x12, 0x27, 0xBA, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0x74, 0x0A, 0xF0, 0x02, 0x16, 0x5C, 0x7B,
0x01, 0x7A, 0x10, 0x79, 0x51, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90, 0x10, 0x52, 0x74, 0x02,
0xF0, 0x90, 0x10, 0x54, 0xE0, 0xFE, 0x90, 0x10, 0x53, 0xE0, 0xFD, 0xEE, 0x90, 0x10, 0x4C, 0xF0,
0xED, 0xA3, 0xF0, 0x30, 0x06, 0x5A, 0xE0, 0xFD, 0x24, 0x47, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5,
0x83, 0xE4, 0xF0, 0x74, 0x48, 0x2D, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x02, 0xF0,
0x74, 0x4E, 0x2D, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x74, 0x4F, 0x2D, 0xF5,
0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x02, 0xF0, 0x90, 0x10, 0x98, 0xE0, 0xFE, 0x90, 0x10,
0x97, 0xE0, 0xFB, 0xEE, 0xEB, 0xC3, 0x94, 0x20, 0xEE, 0x94, 0x01, 0x40, 0x03, 0x02, 0x16, 0x5C,
0x74, 0x50, 0x2D, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x01, 0xF0, 0x02, 0x16, 0x5C,
0x90, 0x10, 0x4D, 0xE0, 0xFD, 0x24, 0x47, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x40,
0xF0, 0x74, 0x48, 0x2D, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x74, 0x4E, 0x2D,
0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x40, 0xF0, 0x74, 0x4F, 0x2D, 0xF5, 0x82, 0xE4,
0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x90, 0x10, 0x98, 0xE0, 0xFE, 0x90, 0x10, 0x97, 0xE0, 0xFB,
0xEE, 0xEB, 0xC3, 0x94, 0x20, 0xEE, 0x94, 0x01, 0x40, 0x03, 0x02, 0x16, 0x5C, 0x74, 0x50, 0x2D,
0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x02, 0x16, 0x5C, 0x7B, 0x01, 0x7A, 0x10,
0x79, 0x51, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90, 0x10, 0x52, 0x74, 0x07, 0xF0, 0x90, 0x10,
0x54, 0xE0, 0xFE, 0x90, 0x10, 0x53, 0xE0, 0xFD, 0xEE, 0x90, 0x10, 0x4C, 0xF0, 0xED, 0xA3, 0xF0,
0x30, 0x06, 0x59, 0xE0, 0xFD, 0x24, 0x47, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x40,
0xF0, 0x74, 0x48, 0x2D, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x74, 0x4E, 0x2D,
0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x40, 0xF0, 0x74, 0x4F, 0x2D, 0xF5, 0x82, 0xE4,
0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x90, 0x10, 0x98, 0xE0, 0xFE, 0x90, 0x10, 0x97, 0xE0, 0xFB,
0xEE, 0xEB, 0xC3, 0x94, 0x20, 0xEE, 0x94, 0x01, 0x40, 0x03, 0x02, 0x16, 0x5C, 0x74, 0x50, 0x2D,
0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x02, 0x16, 0x5C, 0x90, 0x10, 0x4D, 0xE0,
0xFD, 0x24, 0x47, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x74, 0x48, 0x2D, 0xF5,
0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x02, 0xF0, 0x74, 0x4E, 0x2D, 0xF5, 0x82, 0xE4, 0x34,
0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x74, 0x4F, 0x2D, 0xF5, 0x82, 0xE4, 0x34, 0x10, 0xF5, 0x83, 0x74,
0x02, 0xF0, 0x90, 0x10, 0x98, 0xE0, 0xFE, 0x90, 0x10, 0x97, 0xE0, 0xFB, 0xEE, 0xEB, 0xC3, 0x94,
0x20, 0xEE, 0x94, 0x01, 0x40, 0x03, 0x02, 0x16, 0x5C, 0x74, 0x50, 0x2D, 0xF5, 0x82, 0xE4, 0x34,
0x10, 0xF5, 0x83, 0x74, 0x01, 0xF0, 0x02, 0x16, 0x5C, 0x90, 0x06, 0x12, 0xE0, 0x14, 0x60, 0x2F,
0x14, 0x70, 0x03, 0x02, 0x15, 0x34, 0x14, 0x70, 0x03, 0x02, 0x15, 0xD5, 0x24, 0x03, 0x60, 0x03,
0x02, 0x16, 0x4C, 0x7B, 0x01, 0x7A, 0x43, 0x79, 0x1A, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90,
0x43, 0x1A, 0xE0, 0xFF, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0xEF, 0xF0, 0x02, 0x16, 0x5C, 0x90,
0x10, 0x98, 0xE0, 0xFE, 0x90, 0x10, 0x97, 0xE0, 0xFD, 0xEE, 0xED, 0xC3, 0x94, 0x20, 0xEE, 0x94,
0x01, 0x50, 0x1C, 0x7B, 0x01, 0x7A, 0x10, 0x79, 0x14, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90,
0x10, 0x14, 0xE0, 0xFF, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0xEF, 0xF0, 0x02, 0x16, 0x5C, 0x90,
0x10, 0x3C, 0xE0, 0xC3, 0x94, 0x01, 0x50, 0x08, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22,
0x90, 0x10, 0x0D, 0xE0, 0x20, 0xE0, 0x1C, 0x7B, 0x01, 0x7A, 0x10, 0x79, 0x14, 0x90, 0x10, 0x46,
0x12, 0x27, 0xBA, 0x90, 0x10, 0x14, 0xE0, 0xFF, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0xEF, 0xF0,
0x02, 0x16, 0x5C, 0x90, 0x10, 0x2E, 0x12, 0x27, 0x9A, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90,
0x10, 0x2E, 0x12, 0x27, 0x9A, 0x12, 0x26, 0x36, 0xFF, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0xEF,
0xF0, 0x02, 0x16, 0x5C, 0x90, 0x10, 0x98, 0xE0, 0xFE, 0x90, 0x10, 0x97, 0xE0, 0xFD, 0xEE, 0xED,
0xC3, 0x94, 0x20, 0xEE, 0x94, 0x01, 0x50, 0x33, 0x90, 0x10, 0x99, 0xE0, 0x70, 0x0C, 0xA3, 0xE0,
0x70, 0x08, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x10, 0x2E, 0x12, 0x27, 0x9A,
0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90, 0x10, 0x2E, 0x12, 0x27, 0x9A, 0x12, 0x26, 0x36, 0xFF,
0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0xEF, 0xF0, 0x02, 0x16, 0x5C, 0x90, 0x10, 0x3C, 0xE0, 0xC3,
0x94, 0x02, 0x50, 0x08, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x10, 0x0D, 0xE0,
0x20, 0xE0, 0x21, 0x90, 0x10, 0x2E, 0x12, 0x27, 0x9A, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90,
0x10, 0x2E, 0x12, 0x27, 0x9A, 0x12, 0x26, 0x36, 0xFF, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0xEF,
0xF0, 0x02, 0x16, 0x5C, 0x90, 0x10, 0x31, 0x12, 0x27, 0x9A, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA,
0x90, 0x10, 0x31, 0x12, 0x27, 0x9A, 0x12, 0x26, 0x36, 0xFF, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3,
0xEF, 0xF0, 0x02, 0x16, 0x5C, 0x90, 0x10, 0x98, 0xE0, 0xFE, 0x90, 0x10, 0x97, 0xE0, 0xFD, 0xEE,
0xED, 0xC3, 0x94, 0x20, 0xEE, 0x94, 0x01, 0x50, 0x32, 0x90, 0x10, 0x99, 0xE0, 0x60, 0x04, 0xA3,
0xE0, 0x70, 0x08, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x10, 0x31, 0x12, 0x27,
0x9A, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90, 0x10, 0x31, 0x12, 0x27, 0x9A, 0x12, 0x26, 0x36,
0xFF, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0xEF, 0xF0, 0x80, 0x41, 0x90, 0x10, 0x3C, 0xE0, 0xC3,
0x94, 0x03, 0x50, 0x08, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x10, 0x31, 0x12,
0x27, 0x9A, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90, 0x10, 0x31, 0x12, 0x27, 0x9A, 0x12, 0x26,
0x36, 0xFF, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0xEF, 0xF0, 0x80, 0x10, 0x90, 0x06, 0x22, 0xE0,
0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x45, 0x31, 0xE0,
0xFE, 0xA3, 0xE0, 0xFF, 0xD3, 0x90, 0x10, 0x4D, 0xE0, 0x9F, 0x90, 0x10, 0x4C, 0xE0, 0x9E, 0x40,
0x05, 0xEE, 0xF0, 0xA3, 0xEF, 0xF0, 0x02, 0x33, 0xF6, 0x90, 0x06, 0x12, 0xE0, 0x90, 0x10, 0x3E,
0xF0, 0x90, 0x10, 0x3D, 0x74, 0x04, 0xF0, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74, 0x08,
0xF0, 0xA3, 0xF0, 0x90, 0x10, 0x3E, 0xE0, 0xFF, 0x44, 0x80, 0x90, 0x06, 0x06, 0xF0, 0xEF, 0x70,
0x07, 0x90, 0x10, 0x38, 0x74, 0x07, 0xF0, 0x22, 0x90, 0x10, 0x38, 0x74, 0x0F, 0xF0, 0x22, 0x90,
0x06, 0x13, 0xE0, 0xFE, 0x90, 0x06, 0x12, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x35, 0xF0, 0xED, 0xA3,
0xF0, 0x90, 0x45, 0x35, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x64, 0x01, 0x4E, 0x60, 0x0C, 0xEF, 0x4E,
0x60, 0x08, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x12, 0xE0, 0x90, 0x10,
0x3A, 0xF0, 0x90, 0x10, 0x3D, 0x74, 0x08, 0xF0, 0x90, 0x06, 0x08, 0x74, 0x02, 0xF0, 0xA3, 0x04,
0xF0, 0xA3, 0x74, 0x01, 0xF0, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3,
0xF0, 0x90, 0x10, 0x3A, 0xE0, 0x70, 0x0D, 0x90, 0x10, 0x38, 0x74, 0x0F, 0xF0, 0x90, 0x06, 0x07,
0x74, 0x02, 0xF0, 0x22, 0x90, 0x10, 0x38, 0x74, 0x1F, 0xF0, 0x90, 0x06, 0x07, 0xE0, 0x44, 0x1C,
0xF0, 0x90, 0x06, 0x0B, 0x74, 0x70, 0xF0, 0xE4, 0x90, 0x10, 0x34, 0xF0, 0xA3, 0xF0, 0xA3, 0xF0,
0xA3, 0xF0, 0x22, 0x90, 0x10, 0x38, 0xE0, 0x64, 0x1F, 0x70, 0x4E, 0x90, 0x06, 0x15, 0xE0, 0xFE,
0x90, 0x06, 0x14, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x33, 0xF0, 0xED, 0xA3, 0xF0, 0x90, 0x10, 0x55,
0xE0, 0xFF, 0xC3, 0x90, 0x45, 0x34, 0xE0, 0x9F, 0x90, 0x45, 0x33, 0xE0, 0x94, 0x00, 0x50, 0x21,
0xE4, 0x90, 0x06, 0x60, 0xF0, 0x90, 0x10, 0x3D, 0x74, 0x09, 0xF0, 0xE4, 0x90, 0x10, 0x4C, 0xF0,
0xA3, 0xF0, 0xC2, 0x04, 0x90, 0x06, 0x23, 0x74, 0x81, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0,
0x22, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0,
0x22, 0x90, 0x06, 0x13, 0xE0, 0xFE, 0x90, 0x06, 0x12, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x35, 0xF0,
0xED, 0xA3, 0xF0, 0x90, 0x06, 0x15, 0xE0, 0xFE, 0x90, 0x06, 0x14, 0xE0, 0xFD, 0xEE, 0x90, 0x45,
0x33, 0xF0, 0xED, 0xA3, 0xF0, 0xA3, 0xE0, 0x70, 0x02, 0xA3, 0xE0, 0x70, 0x13, 0x90, 0x10, 0x55,
0xE0, 0xFF, 0xC3, 0x90, 0x45, 0x34, 0xE0, 0x9F, 0x90, 0x45, 0x33, 0xE0, 0x94, 0x00, 0x40, 0x08,
0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74,
0x08, 0xF0, 0xA3, 0xF0, 0x22, 0x90, 0x10, 0x38, 0xE0, 0xB4, 0x1F, 0x08, 0x90, 0x06, 0x60, 0x74,
0x01, 0xF0, 0x80, 0x05, 0xE4, 0x90, 0x06, 0x60, 0xF0, 0x90, 0x10, 0x3D, 0x74, 0x07, 0xF0, 0xE4,
0x90, 0x10, 0x4C, 0xF0, 0xA3, 0xF0, 0xC2, 0x04, 0x90, 0x06, 0x23, 0x74, 0x81, 0xF0, 0xA3, 0x74,
0x08, 0xF0, 0xA3, 0xF0, 0x22, 0x90, 0x06, 0x10, 0xE0, 0x24, 0x7F, 0x60, 0x14, 0x14, 0x60, 0x4E,
0x24, 0x02, 0x60, 0x03, 0x02, 0x18, 0xD2, 0xE4, 0x90, 0x06, 0x60, 0xF0, 0xA3, 0xF0, 0x02, 0x18,
0xDA, 0x90, 0x06, 0x15, 0xE0, 0xFE, 0x90, 0x06, 0x14, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x33, 0xF0,
0xED, 0xA3, 0xF0, 0x90, 0x10, 0x55, 0xE0, 0xFF, 0xC3, 0x90, 0x45, 0x34, 0xE0, 0x9F, 0x90, 0x45,
0x33, 0xE0, 0x94, 0x00, 0x50, 0x07, 0x90, 0x10, 0x38, 0xE0, 0xB4, 0x0F, 0x08, 0x90, 0x06, 0x22,
0xE0, 0x44, 0x08, 0xF0, 0x22, 0xE4, 0x90, 0x06, 0x60, 0xF0, 0xA3, 0xF0, 0x80, 0x6C, 0x90, 0x06,
0x15, 0xE0, 0xFE, 0x90, 0x06, 0x14, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x33, 0xF0, 0xED, 0xA3, 0xF0,
0x90, 0x45, 0x33, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x64, 0x81, 0x4E, 0x60, 0x0C, 0xEF, 0x64, 0x82,
0x4E, 0x60, 0x06, 0xEF, 0x64, 0x03, 0x4E, 0x70, 0x0B, 0x90, 0x10, 0x38, 0xE0, 0xB4, 0x0F, 0x0C,
0xEF, 0x4E, 0x60, 0x08, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x7E, 0x00, 0xEF, 0x54,
0x7F, 0x24, 0x34, 0xF5, 0x82, 0xEE, 0x34, 0x10, 0xF5, 0x83, 0xE0, 0xB4, 0x01, 0x08, 0x90, 0x06,
0x60, 0x74, 0x01, 0xF0, 0x80, 0x05, 0xE4, 0x90, 0x06, 0x60, 0xF0, 0xE4, 0x90, 0x06, 0x61, 0xF0,
0x80, 0x08, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x10, 0x3D, 0x74, 0x01, 0xF0,
0xE4, 0x90, 0x10, 0x4C, 0xF0, 0xA3, 0xF0, 0xC2, 0x04, 0x90, 0x06, 0x23, 0x74, 0x82, 0xF0, 0xA3,
0x74, 0x08, 0xF0, 0xA3, 0xF0, 0x22, 0x90, 0x06, 0x10, 0xE0, 0x24, 0xFE, 0x60, 0x03, 0x02, 0x19,
0xBA, 0x90, 0x06, 0x15, 0xE0, 0xFE, 0x90, 0x06, 0x14, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x33, 0xF0,
0xED, 0xA3, 0xF0, 0x90, 0x06, 0x13, 0xE0, 0xFE, 0x90, 0x06, 0x12, 0xE0, 0xFD, 0xEE, 0x90, 0x45,
0x35, 0xF0, 0xED, 0xA3, 0xF0, 0x90, 0x10, 0x38, 0xE0, 0xF9, 0x64, 0x1F, 0x70, 0x76, 0x90, 0x45,
0x33, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x64, 0x81, 0x4E, 0x70, 0x19, 0x90, 0x06, 0x0B, 0xE0, 0x54,
0xFB, 0xF0, 0x7C, 0x00, 0xEF, 0x54, 0x7F, 0x24, 0x34, 0xF5, 0x82, 0xEC, 0x34, 0x10, 0xF5, 0x83,
0xE4, 0xF0, 0x80, 0x6E, 0xEF, 0x64, 0x82, 0x4E, 0x70, 0x1C, 0x90, 0x06, 0x0B, 0xE0, 0x54, 0xFE,
0xF0, 0x7E, 0x00, 0x90, 0x45, 0x34, 0xE0, 0x54, 0x7F, 0x24, 0x34, 0xF5, 0x82, 0xEE, 0x34, 0x10,
0xF5, 0x83, 0xE4, 0xF0, 0x80, 0x4C, 0x90, 0x45, 0x33, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x64, 0x03,
0x4E, 0x70, 0x19, 0x90, 0x06, 0x0B, 0xE0, 0x54, 0xFD, 0xF0, 0x7E, 0x00, 0xEF, 0x54, 0x7F, 0x24,
0x34, 0xF5, 0x82, 0xEE, 0x34, 0x10, 0xF5, 0x83, 0xE4, 0xF0, 0x80, 0x26, 0x90, 0x06, 0x22, 0xE0,
0x44, 0x08, 0xF0, 0x22, 0xE9, 0xB4, 0x0F, 0x1A, 0x90, 0x45, 0x33, 0xE0, 0x70, 0x02, 0xA3, 0xE0,
0x60, 0x10, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08,
0xF0, 0x22, 0xC2, 0x04, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0,
0x22, 0x90, 0x06, 0x10, 0xE0, 0x24, 0xFE, 0x60, 0x44, 0x24, 0x02, 0x60, 0x03, 0x02, 0x1A, 0xCA,
0x90, 0x06, 0x13, 0xE0, 0xFE, 0x90, 0x06, 0x12, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x35, 0xF0, 0xED,
0xA3, 0xF0, 0x90, 0x45, 0x35, 0xE0, 0x70, 0x04, 0xA3, 0xE0, 0x64, 0x02, 0x70, 0x17, 0x90, 0x06,
0x14, 0xE0, 0x70, 0x11, 0x90, 0x10, 0x3D, 0x74, 0x0F, 0xF0, 0x90, 0x06, 0x15, 0xE0, 0x90, 0x10,
0x50, 0xF0, 0x02, 0x1A, 0xD2, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x15,
0xE0, 0xFE, 0x90, 0x06, 0x14, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x33, 0xF0, 0xED, 0xA3, 0xF0, 0x90,
0x06, 0x13, 0xE0, 0xFE, 0x90, 0x06, 0x12, 0xE0, 0xFD, 0xEE, 0x90, 0x45, 0x35, 0xF0, 0xED, 0xA3,
0xF0, 0x90, 0x10, 0x38, 0xE0, 0x64, 0x1F, 0x70, 0x79, 0x90, 0x45, 0x33, 0xE0, 0xFE, 0xA3, 0xE0,
0xFF, 0x64, 0x81, 0x4E, 0x70, 0x1A, 0x90, 0x06, 0x0B, 0xE0, 0x44, 0x04, 0xF0, 0x7C, 0x00, 0xEF,
0x54, 0x7F, 0x24, 0x34, 0xF5, 0x82, 0xEC, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x01, 0xF0, 0x80, 0x62,
0xEF, 0x64, 0x82, 0x4E, 0x70, 0x1D, 0x90, 0x06, 0x0B, 0xE0, 0x44, 0x01, 0xF0, 0x7E, 0x00, 0x90,
0x45, 0x34, 0xE0, 0x54, 0x7F, 0x24, 0x34, 0xF5, 0x82, 0xEE, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x01,
0xF0, 0x80, 0x3F, 0x90, 0x45, 0x33, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x64, 0x03, 0x4E, 0x70, 0x1A,
0x90, 0x06, 0x0B, 0xE0, 0x44, 0x02, 0xF0, 0x7E, 0x00, 0xEF, 0x54, 0x7F, 0x24, 0x34, 0xF5, 0x82,
0xEE, 0x34, 0x10, 0xF5, 0x83, 0x74, 0x01, 0xF0, 0x80, 0x18, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08,
0xF0, 0x22, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08,
0xF0, 0x22, 0xC2, 0x04, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0,
0x22, 0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x10, 0xE0, 0x64, 0x40, 0x60,
0x03, 0x02, 0x1C, 0xA2, 0xE0, 0x90, 0x43, 0x1E, 0xF0, 0x90, 0x06, 0x11, 0xE0, 0x90, 0x43, 0x1F,
0xF0, 0x90, 0x06, 0x13, 0xE0, 0xFE, 0x90, 0x06, 0x12, 0xE0, 0xFD, 0xEE, 0x90, 0x43, 0x20, 0xF0,
0xED, 0xA3, 0xF0, 0x90, 0x06, 0x15, 0xE0, 0xFE, 0x90, 0x06, 0x14, 0xE0, 0xFD, 0xEE, 0x90, 0x43,
0x22, 0xF0, 0xED, 0xA3, 0xF0, 0x90, 0x06, 0x17, 0xE0, 0xFE, 0x90, 0x06, 0x16, 0xE0, 0xFD, 0xEE,
0x90, 0x43, 0x24, 0xF0, 0xED, 0xA3, 0xF0, 0xE4, 0x90, 0x10, 0x44, 0xF0, 0xA3, 0xF0, 0x90, 0x43,
0x24, 0xE0, 0xFF, 0xA3, 0xE0, 0x90, 0x10, 0x42, 0xCF, 0xF0, 0xA3, 0xEF, 0xF0, 0x90, 0x43, 0x1F,
0xE0, 0x12, 0x28, 0x7E, 0x1B, 0x70, 0x00, 0x1B, 0xE6, 0x01, 0x1B, 0x79, 0x07, 0x1B, 0x8F, 0x0B,
0x1B, 0xAF, 0x0C, 0x1B, 0xC9, 0x10, 0x1B, 0xD9, 0x12, 0x1B, 0xFE, 0x13, 0x00, 0x00, 0x1C, 0x6A,
0x90, 0x10, 0x3D, 0x74, 0x0B, 0xF0, 0x02, 0x1C, 0x8E, 0x90, 0x10, 0x3D, 0x74, 0x0B, 0xF0, 0x12,
0x3D, 0x31, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0, 0x22, 0x90,
0x10, 0x3D, 0x74, 0x0B, 0xF0, 0x90, 0x43, 0x21, 0xE0, 0xFF, 0x90, 0x45, 0x45, 0xE0, 0xFD, 0x12,
0x39, 0xB4, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0, 0x22, 0x90,
0x45, 0x45, 0xE0, 0xFF, 0x90, 0x06, 0x12, 0xE0, 0xFD, 0x12, 0x39, 0x2D, 0x90, 0x06, 0x23, 0x74,
0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0, 0x22, 0x12, 0x3E, 0x03, 0x90, 0x06, 0x23, 0x74,
0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0, 0x22, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3,
0x74, 0x08, 0xF0, 0xA3, 0xF0, 0x22, 0x90, 0x10, 0x3D, 0x74, 0x10, 0xF0, 0x90, 0x06, 0x23, 0x74,
0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0, 0x12, 0x3D, 0xBA, 0x02, 0x1C, 0x8E, 0x90, 0x06,
0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0xA3, 0xF0, 0x90, 0x04, 0x7A, 0xE0, 0x90, 0x45,
0x39, 0xF0, 0xE0, 0x54, 0x7F, 0xF0, 0x44, 0x80, 0xF0, 0x90, 0x04, 0x7A, 0xF0, 0x7D, 0x17, 0x7F,
0x0C, 0x12, 0x3D, 0x00, 0x7D, 0xB9, 0x7F, 0x0D, 0x12, 0x3D, 0x00, 0x90, 0x04, 0x54, 0x74, 0x01,
0xF0, 0xE4, 0x90, 0x04, 0x78, 0xF0, 0xA3, 0xF0, 0x90, 0x06, 0x20, 0x74, 0x20, 0xF0, 0x90, 0x04,
0x59, 0x74, 0x10, 0xF0, 0xE4, 0x90, 0x06, 0x05, 0xF0, 0x90, 0x06, 0x07, 0x74, 0x03, 0xF0, 0x75,
0xA8, 0x81, 0x43, 0x87, 0x01, 0x90, 0x06, 0x20, 0x74, 0x21, 0xF0, 0x90, 0x04, 0x58, 0x74, 0x14,
0xF0, 0xA3, 0x74, 0x50, 0xF0, 0x43, 0xA8, 0x81, 0x80, 0x24, 0x90, 0x10, 0x3D, 0x74, 0x0D, 0xF0,
0x7B, 0x01, 0x7A, 0x43, 0x79, 0x26, 0x90, 0x10, 0x3F, 0x12, 0x27, 0xBA, 0x90, 0x06, 0x17, 0xE0,
0xFE, 0x90, 0x06, 0x16, 0xE0, 0xFD, 0xEE, 0x90, 0x10, 0x42, 0xF0, 0xED, 0xA3, 0xF0, 0xE4, 0x90,
0x06, 0x24, 0xF0, 0x90, 0x06, 0x23, 0x74, 0xC0, 0xF0, 0x90, 0x06, 0x25, 0x74, 0x08, 0xF0, 0xC2,
0x04, 0x22, 0x90, 0x06, 0x10, 0xE0, 0x64, 0xC0, 0x60, 0x03, 0x02, 0x1E, 0x86, 0xE0, 0x90, 0x43,
0x1E, 0xF0, 0x90, 0x06, 0x11, 0xE0, 0x90, 0x43, 0x1F, 0xF0, 0x90, 0x06, 0x13, 0xE0, 0xFE, 0x90,
0x06, 0x12, 0xE0, 0xFD, 0xEE, 0x90, 0x43, 0x20, 0xF0, 0xED, 0xA3, 0xF0, 0x90, 0x06, 0x15, 0xE0,
0xFE, 0x90, 0x06, 0x14, 0xE0, 0xFD, 0xEE, 0x90, 0x43, 0x22, 0xF0, 0xED, 0xA3, 0xF0, 0x90, 0x06,
0x17, 0xE0, 0xFE, 0x90, 0x06, 0x16, 0xE0, 0xFD, 0xEE, 0x90, 0x43, 0x24, 0xF0, 0xED, 0xA3, 0xF0,
0x90, 0x43, 0x24, 0xE0, 0xFF, 0xA3, 0xE0, 0x90, 0x10, 0x4C, 0xCF, 0xF0, 0xA3, 0xEF, 0xF0, 0x90,
0x43, 0x1F, 0xE0, 0x24, 0xFA, 0x70, 0x03, 0x02, 0x1E, 0x58, 0x24, 0x05, 0x60, 0x03, 0x02, 0x1E,
0x6F, 0x90, 0x43, 0x22, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xEE, 0x60, 0x03, 0x02, 0x1E, 0x50, 0xEF,
0x24, 0xFE, 0x70, 0x03, 0x02, 0x1D, 0xCD, 0x14, 0x60, 0x31, 0x14, 0x60, 0x4E, 0x24, 0xFC, 0x70,
0x03, 0x02, 0x1E, 0x1A, 0x24, 0x07, 0x60, 0x03, 0x02, 0x1E, 0x50, 0x7B, 0x01, 0x7A, 0x00, 0x79,
0x00, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90, 0x43, 0x20, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x90,
0x10, 0x47, 0xEE, 0x8F, 0xF0, 0x12, 0x26, 0xB0, 0x02, 0x1E, 0x77, 0x7B, 0x01, 0x7A, 0x04, 0x79,
0x00, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0x90, 0x43, 0x20, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x90,
0x10, 0x47, 0xEE, 0x8F, 0xF0, 0x12, 0x26, 0xB0, 0x02, 0x1E, 0x77, 0x7B, 0x01, 0x7A, 0x43, 0x79,
0x26, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0xE4, 0x90, 0x45, 0x37, 0xF0, 0xA3, 0xF0, 0x90, 0x43,
0x24, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xC3, 0x90, 0x45, 0x38, 0xE0, 0x9F, 0x90, 0x45, 0x37, 0xE0,
0x9E, 0x40, 0x03, 0x02, 0x1E, 0x77, 0xA3, 0xE0, 0xFF, 0x90, 0x43, 0x21, 0xE0, 0x2F, 0xFF, 0x12,
0x3B, 0x25, 0x90, 0x45, 0x38, 0xE0, 0x24, 0x26, 0xF5, 0x82, 0xE4, 0x34, 0x43, 0xF5, 0x83, 0xEF,
0xF0, 0x90, 0x45, 0x37, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0, 0x80, 0xC1, 0x7B, 0x01, 0x7A,
0x43, 0x79, 0x26, 0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0xE4, 0x90, 0x45, 0x37, 0xF0, 0xA3, 0xF0,
0x90, 0x43, 0x24, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xC3, 0x90, 0x45, 0x38, 0xE0, 0x9F, 0x90, 0x45,
0x37, 0xE0, 0x9E, 0x40, 0x03, 0x02, 0x1E, 0x77, 0xA3, 0xE0, 0xFE, 0x90, 0x43, 0x21, 0xE0, 0x2E,
0xFF, 0x74, 0x26, 0x2E, 0xF9, 0xE4, 0x34, 0x43, 0xFA, 0x7B, 0x01, 0x12, 0x3C, 0xCD, 0x90, 0x45,
0x37, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0, 0x80, 0xC6, 0x7B, 0x01, 0x7A, 0x43, 0x79, 0x26,
0x90, 0x10, 0x46, 0x12, 0x27, 0xBA, 0xD3, 0x90, 0x43, 0x25, 0xE0, 0x94, 0x02, 0x90, 0x43, 0x24,
0xE0, 0x94, 0x00, 0x40, 0x0F, 0xE4, 0xF0, 0xA3, 0x74, 0x02, 0xF0, 0x90, 0x10, 0x4C, 0xE4, 0xF0,
0xA3, 0x74, 0x02, 0xF0, 0x90, 0x43, 0x26, 0x74, 0x33, 0xF0, 0xA3, 0x74, 0x01, 0xF0, 0x80, 0x27,
0x90, 0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x7B, 0x01, 0x7A, 0x44, 0x79, 0x2E, 0x90, 0x10,
0x46, 0x12, 0x27, 0xBA, 0x90, 0x10, 0x4C, 0xE4, 0xF0, 0xA3, 0x74, 0x0A, 0xF0, 0x80, 0x08, 0x90,
0x06, 0x22, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x24, 0x74, 0x08, 0xF0, 0x12, 0x33, 0xF6,
0x90, 0x10, 0x3D, 0x74, 0x0C, 0xF0, 0x22, 0xD2, 0x00, 0x90, 0x43, 0x1F, 0xE0, 0x12, 0x28, 0x7E,
0x1E, 0xAF, 0x04, 0x1F, 0xB1, 0x05, 0x1F, 0xC4, 0x08, 0x20, 0xE2, 0x09, 0x21, 0x37, 0x0A, 0x21,
0xE9, 0x0D, 0x22, 0x7F, 0x0E, 0x22, 0xB1, 0x0F, 0x23, 0x3B, 0x11, 0x00, 0x00, 0x23, 0x4F, 0x90,
0x43, 0x22, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xEE, 0x60, 0x03, 0x02, 0x23, 0x4F, 0xEF, 0x24, 0xFE,
0x70, 0x03, 0x02, 0x1F, 0x7D, 0x14, 0x60, 0x4B, 0x14, 0x70, 0x03, 0x02, 0x1F, 0x51, 0x24, 0x03,
0x60, 0x03, 0x02, 0x23, 0x4F, 0x90, 0x43, 0x21, 0xE0, 0xFF, 0x24, 0x00, 0xF5, 0x82, 0xE4, 0x34,
0x00, 0xF5, 0x83, 0xC0, 0x83, 0xC0, 0x82, 0xE0, 0xFE, 0x90, 0x43, 0x27, 0xE0, 0xF4, 0xFD, 0xEE,
0x5D, 0xD0, 0x82, 0xD0, 0x83, 0xF0, 0x74, 0x00, 0x2F, 0xF5, 0x82, 0xE4, 0x34, 0x00, 0xF5, 0x83,
0xC0, 0x83, 0xC0, 0x82, 0xE0, 0xFF, 0x90, 0x43, 0x26, 0xE0, 0xFE, 0xEF, 0x4E, 0xD0, 0x82, 0xD0,
0x83, 0xF0, 0x22, 0x90, 0x43, 0x21, 0xE0, 0xFF, 0x24, 0x00, 0xF5, 0x82, 0xE4, 0x34, 0x04, 0xF5,
0x83, 0xC0, 0x83, 0xC0, 0x82, 0xE0, 0xFE, 0x90, 0x43, 0x27, 0xE0, 0xF4, 0xFD, 0xEE, 0x5D, 0xD0,
0x82, 0xD0, 0x83, 0xF0, 0x74, 0x00, 0x2F, 0xF5, 0x82, 0xE4, 0x34, 0x04, 0xF5, 0x83, 0xC0, 0x83,
0xC0, 0x82, 0xE0, 0xFF, 0x90, 0x43, 0x26, 0xE0, 0xFE, 0xEF, 0x4E, 0xD0, 0x82, 0xD0, 0x83, 0xF0,
0x22, 0x90, 0x43, 0x21, 0xE0, 0xFF, 0x12, 0x3B, 0x25, 0x90, 0x45, 0x37, 0xEF, 0xF0, 0x90, 0x43,
0x27, 0xE0, 0xF4, 0x5F, 0xFF, 0x90, 0x45, 0x37, 0xF0, 0xFE, 0x90, 0x43, 0x21, 0xE0, 0xFF, 0x90,
0x43, 0x26, 0xE0, 0x4E, 0xFD, 0x12, 0x3A, 0x33, 0x72, 0x00, 0x92, 0x00, 0x22, 0x90, 0x43, 0x21,
0xE0, 0xFF, 0x7B, 0x01, 0x7A, 0x45, 0x79, 0x37, 0x12, 0x3C, 0xCD, 0x90, 0x45, 0x37, 0xE0, 0xFF,
0x90, 0x43, 0x27, 0xE0, 0xF4, 0xFE, 0xEF, 0x5E, 0xFF, 0x90, 0x45, 0x37, 0xF0, 0xFE, 0x90, 0x43,
0x21, 0xE0, 0xFF, 0x90, 0x43, 0x26, 0xE0, 0x4E, 0xFD, 0x12, 0x3D, 0x00, 0x72, 0x00, 0x92, 0x00,
0x22, 0x7B, 0x01, 0x7A, 0x44, 0x79, 0x2E, 0x90, 0x45, 0x3B, 0x12, 0x27, 0xBA, 0x7A, 0x43, 0x79,
0x26, 0x02, 0x2A, 0xF6, 0x90, 0x43, 0x21, 0xE0, 0xFD, 0x90, 0x04, 0xBC, 0xF0, 0x90, 0x43, 0x20,
0xE0, 0xFA, 0xA3, 0xE0, 0xFB, 0xEA, 0x90, 0x04, 0xBD, 0xF0, 0x90, 0x43, 0x26, 0xE0, 0x90, 0x04,
0xC0, 0xF0, 0x90, 0x43, 0x27, 0xE0, 0x90, 0x04, 0xC1, 0xF0, 0x90, 0x43, 0x28, 0xE0, 0x90, 0x04,
0xC2, 0xF0, 0x90, 0x43, 0x29, 0xE0, 0x90, 0x04, 0xC3, 0xF0, 0x90, 0x04, 0xBE, 0x74, 0x01, 0xF0,
0xED, 0x04, 0x90, 0x04, 0xBC, 0xF0, 0xEB, 0x24, 0x01, 0xE4, 0x3A, 0xA3, 0xF0, 0x90, 0x43, 0x2A,
0xE0, 0x90, 0x04, 0xC0, 0xF0, 0x90, 0x43, 0x2B, 0xE0, 0x90, 0x04, 0xC1, 0xF0, 0x90, 0x43, 0x2C,
0xE0, 0x90, 0x04, 0xC2, 0xF0, 0x90, 0x43, 0x2D, 0xE0, 0x90, 0x04, 0xC3, 0xF0, 0x90, 0x04, 0xBE,
0x74, 0x01, 0xF0, 0xE4, 0x90, 0x45, 0x35, 0xF0, 0xA3, 0xF0, 0x90, 0x45, 0x35, 0xE0, 0xFE, 0xA3,
0xE0, 0xFF, 0xC3, 0x94, 0x04, 0xEE, 0x64, 0x80, 0x94, 0x80, 0x40, 0x03, 0x02, 0x23, 0x4F, 0x90,
0x43, 0x21, 0xE0, 0x24, 0x02, 0xFD, 0x90, 0x45, 0x36, 0xE0, 0xF9, 0x2D, 0xFD, 0x90, 0x43, 0x23,
0xE0, 0x25, 0xE0, 0x25, 0xE0, 0x2D, 0x90, 0x04, 0xBC, 0xF0, 0x90, 0x43, 0x21, 0xE0, 0x24, 0x02,
0xFD, 0x90, 0x43, 0x20, 0xE0, 0x34, 0x00, 0xCD, 0x2F, 0xCD, 0x3E, 0xFC, 0x90, 0x43, 0x22, 0xE0,
0xFE, 0xA3, 0xE0, 0x78, 0x02, 0xC3, 0x33, 0xCE, 0x33, 0xCE, 0xD8, 0xF9, 0x2D, 0xEC, 0x3E, 0x90,
0x04, 0xBD, 0xF0, 0x75, 0xF0, 0x04, 0xE9, 0x90, 0x43, 0x2E, 0x12, 0x27, 0x8E, 0xE0, 0x90, 0x04,
0xC0, 0xF0, 0x75, 0xF0, 0x04, 0xE9, 0x90, 0x43, 0x2F, 0x12, 0x27, 0x8E, 0xE0, 0x90, 0x04, 0xC1,
0xF0, 0x75, 0xF0, 0x04, 0xE9, 0x90, 0x43, 0x30, 0x12, 0x27, 0x8E, 0xE0, 0x90, 0x04, 0xC2, 0xF0,
0x75, 0xF0, 0x04, 0xE9, 0x90, 0x43, 0x31, 0x12, 0x27, 0x8E, 0xE0, 0x90, 0x04, 0xC3, 0xF0, 0x90,
0x04, 0xBE, 0x74, 0x01, 0xF0, 0x90, 0x45, 0x35, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0, 0x02,
0x20, 0x3A, 0xE4, 0x90, 0x04, 0xBD, 0xF0, 0x90, 0x04, 0xC0, 0xF0, 0xA3, 0xF0, 0xA3, 0xF0, 0xA3,
0xF0, 0x90, 0x45, 0x35, 0xF0, 0xA3, 0xF0, 0x90, 0x43, 0x24, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xC3,
0x90, 0x45, 0x36, 0xE0, 0x9F, 0x90, 0x45, 0x35, 0xE0, 0x9E, 0x40, 0x03, 0x02, 0x23, 0x4F, 0xA3,
0xE0, 0x24, 0x26, 0xF5, 0x82, 0xE4, 0x34, 0x43, 0xF5, 0x83, 0xE0, 0x75, 0xF0, 0x16, 0xA4, 0x24,
0x20, 0x90, 0x04, 0xBC, 0xF0, 0x90, 0x04, 0xBE, 0x74, 0x01, 0xF0, 0x90, 0x45, 0x35, 0xE4, 0x75,
0xF0, 0x01, 0x12, 0x26, 0xB0, 0x80, 0xC0, 0xE4, 0x90, 0x45, 0x35, 0xF0, 0xA3, 0xF0, 0xFD, 0xFC,
0x90, 0x43, 0x24, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xC3, 0x90, 0x45, 0x36, 0xE0, 0x9F, 0x90, 0x45,
0x35, 0xE0, 0x9E, 0x40, 0x03, 0x02, 0x23, 0x4F, 0x90, 0x43, 0x21, 0xE0, 0x2D, 0x90, 0x04, 0xBC,
0xF0, 0x90, 0x43, 0x21, 0xE0, 0x2D, 0x90, 0x43, 0x20, 0xE0, 0x3C, 0x90, 0x04, 0xBD, 0xF0, 0x90,
0x45, 0x35, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xC6, 0xFE, 0x74, 0x26, 0x25, 0xF0, 0xF5, 0x82,
0x74, 0x43, 0x3E, 0xF5, 0x83, 0xE0, 0x90, 0x04, 0xC0, 0xF0, 0x90, 0x45, 0x35, 0xE4, 0x75, 0xF0,
0x01, 0x12, 0x26, 0xC6, 0xFE, 0x74, 0x26, 0x25, 0xF0, 0xF5, 0x82, 0x74, 0x43, 0x3E, 0xF5, 0x83,
0xE0, 0x90, 0x04, 0xC1, 0xF0, 0x90, 0x45, 0x35, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xC6, 0xFE,
0x74, 0x26, 0x25, 0xF0, 0xF5, 0x82, 0x74, 0x43, 0x3E, 0xF5, 0x83, 0xE0, 0x90, 0x04, 0xC2, 0xF0,
0x90, 0x45, 0x35, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xC6, 0xFE, 0x74, 0x26, 0x25, 0xF0, 0xF5,
0x82, 0x74, 0x43, 0x3E, 0xF5, 0x83, 0xE0, 0x90, 0x04, 0xC3, 0xF0, 0x90, 0x04, 0xBE, 0x74, 0x01,
0xF0, 0x0D, 0xBD, 0x00, 0x01, 0x0C, 0x02, 0x21, 0x40, 0x90, 0x43, 0x20, 0xE0, 0xFE, 0xA3, 0xE0,
0xFF, 0x64, 0x05, 0x4E, 0x70, 0x40, 0x90, 0x45, 0x35, 0xF0, 0xA3, 0xF0, 0x90, 0x45, 0x36, 0xE0,
0xFD, 0x24, 0x26, 0xF5, 0x82, 0xE4, 0x34, 0x43, 0xF5, 0x83, 0xE0, 0xFC, 0x74, 0x40, 0x2D, 0xF5,
0x82, 0xE4, 0x34, 0x04, 0xF5, 0x83, 0xEC, 0xF0, 0x90, 0x45, 0x35, 0xE4, 0x75, 0xF0, 0x01, 0x12,
0x26, 0xB0, 0x90, 0x45, 0x35, 0xE0, 0x70, 0x04, 0xA3, 0xE0, 0x64, 0x08, 0x70, 0xCE, 0x90, 0x04,
0x48, 0xE0, 0x44, 0x04, 0xF0, 0x22, 0xEF, 0x64, 0x06, 0x4E, 0x60, 0x03, 0x02, 0x23, 0x4F, 0x90,
0x45, 0x35, 0xF0, 0xA3, 0xF0, 0x90, 0x45, 0x36, 0xE0, 0xFF, 0x24, 0x26, 0xF5, 0x82, 0xE4, 0x34,
0x43, 0xF5, 0x83, 0xE0, 0xFE, 0x74, 0x38, 0x2F, 0xF5, 0x82, 0xE4, 0x34, 0x04, 0xF5, 0x83, 0xEE,
0xF0, 0x90, 0x45, 0x35, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0, 0x90, 0x45, 0x35, 0xE0, 0x70,
0x04, 0xA3, 0xE0, 0x64, 0x08, 0x70, 0xCE, 0x90, 0x04, 0x48, 0xE0, 0x44, 0x08, 0xF0, 0x22, 0x90,
0x43, 0x26, 0xE0, 0x90, 0x04, 0x22, 0xF0, 0x90, 0x43, 0x27, 0xE0, 0x90, 0x04, 0x23, 0xF0, 0x90,
0x43, 0x28, 0xE0, 0x90, 0x04, 0x24, 0xF0, 0x90, 0x43, 0x29, 0xE0, 0x90, 0x04, 0x25, 0xF0, 0x90,
0x43, 0x2A, 0xE0, 0x90, 0x04, 0x28, 0xF0, 0x90, 0x43, 0x2B, 0xE0, 0xFD, 0x7F, 0x0A, 0x02, 0x3D,
0x00, 0x90, 0x43, 0x26, 0xE0, 0x90, 0x04, 0x22, 0xF0, 0x90, 0x43, 0x27, 0xE0, 0x90, 0x04, 0x23,
0xF0, 0x90, 0x43, 0x28, 0xE0, 0x90, 0x04, 0x24, 0xF0, 0x90, 0x43, 0x29, 0xE0, 0x90, 0x04, 0x25,
0xF0, 0x90, 0x43, 0x2A, 0xE0, 0x90, 0x04, 0x28, 0xF0, 0x90, 0x43, 0x2B, 0xE0, 0xFD, 0x7F, 0x0A,
0x12, 0x3D, 0x00, 0x90, 0x43, 0x2C, 0xE0, 0xFD, 0x7F, 0x88, 0x12, 0x3D, 0x00, 0x90, 0x04, 0x4C,
0xE0, 0x54, 0xFC, 0xF0, 0xE0, 0xFF, 0x90, 0x43, 0x2D, 0xE0, 0xFE, 0xEF, 0x4E, 0x90, 0x04, 0x4C,
0xF0, 0xE4, 0x90, 0x45, 0x35, 0xF0, 0xA3, 0xF0, 0x90, 0x45, 0x36, 0xE0, 0xFF, 0x24, 0x2E, 0xF5,
0x82, 0xE4, 0x34, 0x43, 0xF5, 0x83, 0xE0, 0xFE, 0x74, 0xDC, 0x2F, 0xF5, 0x82, 0xE4, 0x34, 0x04,
0xF5, 0x83, 0xEE, 0xF0, 0x90, 0x45, 0x35, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0, 0x90, 0x45,
0x35, 0xE0, 0x70, 0x04, 0xA3, 0xE0, 0x64, 0x22, 0x70, 0xCE, 0x22, 0x90, 0x43, 0x26, 0xE0, 0xFF,
0xA3, 0xE0, 0xFD, 0xA3, 0xE0, 0xFB, 0xA3, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x12, 0x3C, 0x90, 0x22,
0x90, 0x06, 0x30, 0x74, 0x70, 0xF0, 0x90, 0x06, 0x31, 0x74, 0xA0, 0xF0, 0xE0, 0x90, 0x06, 0x35,
0xF0, 0x90, 0x06, 0x36, 0x74, 0xC0, 0xF0, 0x90, 0x06, 0x37, 0x74, 0x08, 0xF0, 0xE4, 0x90, 0x45,
0x46, 0xF0, 0xA3, 0xF0, 0xC2, 0x05, 0x90, 0x06, 0x20, 0x74, 0x21, 0xF0, 0x90, 0x04, 0x58, 0x74,
0x14, 0xF0, 0xA3, 0x74, 0x50, 0xF0, 0x12, 0x3C, 0x43, 0x75, 0xA8, 0x81, 0x90, 0x06, 0x05, 0x74,
0x04, 0xF0, 0x90, 0x06, 0x0F, 0xE0, 0x30, 0xE4, 0x04, 0xD2, 0x06, 0x80, 0x02, 0xC2, 0x06, 0xE4,
0x90, 0x43, 0x19, 0xF0, 0x20, 0x05, 0x03, 0x02, 0x25, 0xFB, 0xC2, 0x05, 0x90, 0x10, 0x39, 0xE0,
0xFF, 0x20, 0xE5, 0x03, 0x02, 0x24, 0xCD, 0x54, 0xDF, 0xF0, 0x90, 0x06, 0x0E, 0xE0, 0x20, 0xE0,
0x03, 0x02, 0x24, 0x4D, 0x7D, 0x17, 0x7F, 0x0C, 0x12, 0x3D, 0x00, 0x7D, 0xB9, 0x7F, 0x0D, 0x12,
0x3D, 0x00, 0x90, 0x04, 0x54, 0x74, 0x01, 0xF0, 0xE4, 0x90, 0x45, 0x2F, 0xF0, 0xA3, 0xF0, 0x90,
0x04, 0x54, 0xE0, 0x30, 0xE0, 0x16, 0x90, 0x45, 0x2F, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0,
0x90, 0x45, 0x2F, 0xE0, 0xB4, 0x07, 0xE8, 0xA3, 0xE0, 0xB4, 0xFF, 0xE3, 0xE4, 0x90, 0x04, 0x78,
0xF0, 0xA3, 0x74, 0x11, 0xF0, 0x90, 0x06, 0x0E, 0xE0, 0x54, 0x01, 0xF0, 0x90, 0x06, 0x30, 0x74,
0x70, 0xF0, 0x90, 0x06, 0x31, 0x74, 0xA0, 0xF0, 0xE0, 0x90, 0x06, 0x35, 0xF0, 0x90, 0x06, 0x36,
0x74, 0xC0, 0xF0, 0x90, 0x06, 0x37, 0x74, 0x08, 0xF0, 0x90, 0x06, 0x38, 0x74, 0x03, 0xF0, 0x90,
0x06, 0x01, 0xE0, 0x44, 0x20, 0xF0, 0x90, 0x06, 0x07, 0x74, 0x02, 0xF0, 0x90, 0x10, 0x38, 0x74,
0x07, 0xF0, 0x90, 0x06, 0x0E, 0xE0, 0x30, 0xE1, 0x04, 0xE0, 0x54, 0x02, 0xF0, 0x90, 0x06, 0x0E,
0xE0, 0x30, 0xE3, 0x11, 0xE0, 0x54, 0x08, 0xF0, 0x90, 0x06, 0x0F, 0xE0, 0x30, 0xE4, 0x04, 0xD2,
0x06, 0x80, 0x02, 0xC2, 0x06, 0x90, 0x06, 0x0E, 0xE0, 0x30, 0xE2, 0x0A, 0xE0, 0x54, 0x04, 0xF0,
0x90, 0x04, 0x79, 0x74, 0x11, 0xF0, 0x90, 0x06, 0x0E, 0xE0, 0x30, 0xE1, 0x50, 0xE0, 0x20, 0xE0,
0x4C, 0x7D, 0x17, 0x7F, 0x0C, 0x12, 0x3D, 0x00, 0x7D, 0xB9, 0x7F, 0x0D, 0x12, 0x3D, 0x00, 0x90,
0x04, 0x54, 0x74, 0x01, 0xF0, 0xE4, 0x90, 0x04, 0x78, 0xF0, 0xA3, 0xF0, 0x90, 0x06, 0x0E, 0xE0,
0x54, 0x02, 0xF0, 0x90, 0x06, 0x20, 0x74, 0x20, 0xF0, 0xE4, 0x90, 0x04, 0x58, 0xF0, 0x90, 0x06,
0x07, 0x74, 0x03, 0xF0, 0x90, 0x04, 0x7A, 0xE0, 0x90, 0x45, 0x2E, 0xF0, 0xE0, 0x54, 0xF9, 0xF0,
0x44, 0x02, 0xF0, 0x90, 0x04, 0x7A, 0xF0, 0x43, 0xA8, 0x81, 0x43, 0x87, 0x01, 0x90, 0x10, 0x39,
0xE0, 0x30, 0xE0, 0x22, 0x90, 0x06, 0x24, 0xE0, 0x30, 0xE4, 0x05, 0x12, 0x12, 0x0E, 0x80, 0x0F,
0x90, 0x06, 0x24, 0xE0, 0x30, 0xE3, 0x05, 0x12, 0x34, 0xB9, 0x80, 0x03, 0x12, 0x28, 0xF4, 0x90,
0x10, 0x39, 0xE0, 0x54, 0xFE, 0xF0, 0x90, 0x45, 0x46, 0xE0, 0x54, 0x14, 0x70, 0x09, 0xA3, 0xE0,
0xFF, 0x20, 0xE6, 0x03, 0x30, 0xE3, 0x4F, 0x7B, 0x01, 0x7A, 0x06, 0x79, 0x40, 0x12, 0x33, 0x2B,
0x90, 0x45, 0x46, 0xE0, 0xFF, 0x90, 0x06, 0x48, 0xF0, 0x90, 0x45, 0x47, 0xE0, 0x90, 0x06, 0x49,
0xF0, 0x90, 0x04, 0x2C, 0xE0, 0x90, 0x06, 0x4A, 0xF0, 0x90, 0x04, 0x2D, 0xE0, 0x90, 0x06, 0x4B,
0xF0, 0x90, 0x04, 0x2E, 0xE0, 0x90, 0x06, 0x4C, 0xF0, 0x90, 0x04, 0x2F, 0xE0, 0x90, 0x06, 0x4D,
0xF0, 0x90, 0x06, 0x3F, 0x74, 0x01, 0xF0, 0xEF, 0x54, 0xEB, 0x90, 0x45, 0x46, 0xF0, 0xA3, 0xE0,
0x54, 0xBF, 0xF0, 0x54, 0xF7, 0xF0, 0x90, 0x45, 0x47, 0xE0, 0xFF, 0x20, 0xE4, 0x03, 0x02, 0x25,
0xE8, 0x90, 0x04, 0x7A, 0xE0, 0x54, 0xDF, 0xF0, 0xE0, 0x90, 0x45, 0x2E, 0xF0, 0xE0, 0x20, 0xE6,
0x54, 0x90, 0x04, 0x7A, 0xE0, 0x90, 0x45, 0x2E, 0xF0, 0xE0, 0x54, 0x7F, 0xF0, 0x44, 0x80, 0xF0,
0x90, 0x04, 0x7A, 0xF0, 0xEF, 0x54, 0xEF, 0x90, 0x45, 0x47, 0xF0, 0x7D, 0x17, 0x7F, 0x0C, 0x12,
0x3D, 0x00, 0x7D, 0xB9, 0x7F, 0x0D, 0x12, 0x3D, 0x00, 0x90, 0x04, 0x54, 0x74, 0x01, 0xF0, 0xE4,
0x90, 0x04, 0x78, 0xF0, 0xA3, 0xF0, 0x90, 0x06, 0x20, 0x74, 0x20, 0xF0, 0x90, 0x04, 0x59, 0x74,
0x10, 0xF0, 0xE4, 0x90, 0x06, 0x05, 0xF0, 0x90, 0x06, 0x07, 0x74, 0x03, 0xF0, 0x75, 0xA8, 0x81,
0x43, 0x87, 0x01, 0x80, 0x23, 0x90, 0x04, 0x7A, 0xE0, 0x90, 0x45, 0x2E, 0xF0, 0xE0, 0x54, 0x7F,
0xF0, 0x90, 0x04, 0x7A, 0xF0, 0x90, 0x10, 0x38, 0x74, 0x07, 0xF0, 0x90, 0x06, 0x05, 0x74, 0x04,
0xF0, 0x90, 0x45, 0x47, 0xE0, 0x54, 0xEF, 0xF0, 0x90, 0x06, 0x20, 0x74, 0x21, 0xF0, 0x90, 0x04,
0x58, 0x74, 0x14, 0xF0, 0xA3, 0x74, 0x50, 0xF0, 0x43, 0xA8, 0x81, 0x90, 0x43, 0x19, 0xE0, 0x64,
0x01, 0x60, 0x03, 0x02, 0x23, 0xA4, 0xF0, 0x90, 0x06, 0x24, 0xE0, 0x30, 0xE3, 0x03, 0x02, 0x23,
0xA4, 0x90, 0x06, 0x25, 0xE0, 0x54, 0xF7, 0xF0, 0x30, 0x04, 0x07, 0xE4, 0x90, 0x06, 0x23, 0xF0,
0x80, 0x06, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0x90, 0x06, 0x24, 0x74, 0x08, 0xF0, 0x90, 0x06,
0x25, 0xF0, 0x02, 0x23, 0xA4, 0x22, 0xBB, 0x01, 0x06, 0x89, 0x82, 0x8A, 0x83, 0xE0, 0x22, 0x50,
0x02, 0xE7, 0x22, 0xBB, 0xFE, 0x02, 0xE3, 0x22, 0x89, 0x82, 0x8A, 0x83, 0xE4, 0x93, 0x22, 0xBB,
0x01, 0x0C, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE0, 0x22, 0x50, 0x06,
0xE9, 0x25, 0x82, 0xF8, 0xE6, 0x22, 0xBB, 0xFE, 0x06, 0xE9, 0x25, 0x82, 0xF8, 0xE2, 0x22, 0xE5,
0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE4, 0x93, 0x22, 0xBB, 0x01, 0x06, 0x89,
0x82, 0x8A, 0x83, 0xF0, 0x22, 0x50, 0x02, 0xF7, 0x22, 0xBB, 0xFE, 0x01, 0xF3, 0x22, 0xF8, 0xBB,
0x01, 0x0D, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE8, 0xF0, 0x22, 0x50,
0x06, 0xE9, 0x25, 0x82, 0xC8, 0xF6, 0x22, 0xBB, 0xFE, 0x05, 0xE9, 0x25, 0x82, 0xC8, 0xF2, 0x22,
0xC5, 0xF0, 0xF8, 0xA3, 0xE0, 0x28, 0xF0, 0xC5, 0xF0, 0xF8, 0xE5, 0x82, 0x15, 0x82, 0x70, 0x02,
0x15, 0x83, 0xE0, 0x38, 0xF0, 0x22, 0xA3, 0xF8, 0xE0, 0xC5, 0xF0, 0x25, 0xF0, 0xF0, 0xE5, 0x82,
0x15, 0x82, 0x70, 0x02, 0x15, 0x83, 0xE0, 0xC8, 0x38, 0xF0, 0xE8, 0x22, 0xBB, 0x01, 0x10, 0xE5,
0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE0, 0xF5, 0xF0, 0xA3, 0xE0, 0x22, 0x50,
0x09, 0xE9, 0x25, 0x82, 0xF8, 0x86, 0xF0, 0x08, 0xE6, 0x22, 0xBB, 0xFE, 0x0A, 0xE9, 0x25, 0x82,
0xF8, 0xE2, 0xF5, 0xF0, 0x08, 0xE2, 0x22, 0xE5, 0x83, 0x2A, 0xF5, 0x83, 0xE9, 0x93, 0xF5, 0xF0,
0xA3, 0xE9, 0x93, 0x22, 0xBB, 0x01, 0x0D, 0xC5, 0x82, 0x29, 0xC5, 0x82, 0xC5, 0x83, 0x3A, 0xC5,
0x83, 0x02, 0x26, 0xB0, 0x50, 0x11, 0xC5, 0x82, 0x29, 0xF8, 0x08, 0xE5, 0xF0, 0x26, 0xF6, 0x18,
0xF5, 0xF0, 0xE5, 0x82, 0x36, 0xF6, 0x22, 0xBB, 0xFE, 0x11, 0xC5, 0x82, 0x29, 0xF8, 0x08, 0xE2,
0x25, 0xF0, 0xF5, 0xF0, 0xF2, 0x18, 0xE2, 0x35, 0x82, 0xF2, 0x22, 0xF8, 0xE5, 0x82, 0x29, 0xF5,
0x82, 0xE5, 0x83, 0x2A, 0xF5, 0x83, 0x74, 0x01, 0x93, 0x25, 0xF0, 0xF5, 0xF0, 0xE4, 0x93, 0x38,
0x22, 0xF8, 0xBB, 0x01, 0x11, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE8,
0xF0, 0xE5, 0xF0, 0xA3, 0xF0, 0x22, 0x50, 0x09, 0xE9, 0x25, 0x82, 0xC8, 0xF6, 0x08, 0xA6, 0xF0,
0x22, 0xBB, 0xFE, 0x09, 0xE9, 0x25, 0x82, 0xC8, 0xF2, 0xE5, 0xF0, 0x08, 0xF2, 0x22, 0xA4, 0x25,
0x82, 0xF5, 0x82, 0xE5, 0xF0, 0x35, 0x83, 0xF5, 0x83, 0x22, 0xE0, 0xFB, 0xA3, 0xE0, 0xFA, 0xA3,
0xE0, 0xF9, 0x22, 0xF8, 0xE0, 0xFB, 0xA3, 0xA3, 0xE0, 0xF9, 0x25, 0xF0, 0xF0, 0xE5, 0x82, 0x15,
0x82, 0x70, 0x02, 0x15, 0x83, 0xE0, 0xFA, 0x38, 0xF0, 0x22, 0xEB, 0xF0, 0xA3, 0xEA, 0xF0, 0xA3,
0xE9, 0xF0, 0x22, 0xBB, 0x01, 0x0D, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83,
0x02, 0x27, 0x9A, 0x50, 0x07, 0xE9, 0x25, 0x82, 0xF8, 0x02, 0x28, 0xA4, 0xBB, 0xFE, 0x07, 0xE9,
0x25, 0x82, 0xF8, 0x02, 0x28, 0xC6, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83,
0x02, 0x28, 0xE8, 0xBB, 0x01, 0x0D, 0xC5, 0x82, 0x29, 0xC5, 0x82, 0xC5, 0x83, 0x3A, 0xC5, 0x83,
0x02, 0x27, 0xA3, 0x50, 0x08, 0xF8, 0xE9, 0x25, 0x82, 0xC8, 0x02, 0x28, 0xAD, 0xBB, 0xFE, 0x08,
0xF8, 0xE9, 0x25, 0x82, 0xC8, 0x02, 0x28, 0xCF, 0xC5, 0x82, 0x29, 0xC5, 0x82, 0xC5, 0x83, 0x3A,
0xC5, 0x83, 0x02, 0x28, 0xE8, 0xBB, 0x01, 0x20, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A,
0xF5, 0x83, 0xD0, 0xF0, 0xD0, 0xE0, 0xF8, 0xD0, 0xE0, 0xF9, 0xD0, 0xE0, 0xFA, 0xD0, 0xE0, 0xFB,
0xE8, 0xC0, 0xE0, 0xC0, 0xF0, 0x02, 0x27, 0xBA, 0x50, 0x18, 0xE9, 0x25, 0x82, 0xF8, 0xD0, 0x83,
0xD0, 0x82, 0xD0, 0xE0, 0xF9, 0xD0, 0xE0, 0xFA, 0xD0, 0xE0, 0xFB, 0xC0, 0x82, 0xC0, 0x83, 0x02,
0x28, 0xBD, 0xBB, 0xFE, 0x18, 0xE9, 0x25, 0x82, 0xF8, 0xD0, 0x83, 0xD0, 0x82, 0xD0, 0xE0, 0xF9,
0xD0, 0xE0, 0xFA, 0xD0, 0xE0, 0xFB, 0xC0, 0x82, 0xC0, 0x83, 0x02, 0x28, 0xDF, 0x22, 0xD0, 0x83,
0xD0, 0x82, 0xF8, 0xE4, 0x93, 0x70, 0x12, 0x74, 0x01, 0x93, 0x70, 0x0D, 0xA3, 0xA3, 0x93, 0xF8,
0x74, 0x01, 0x93, 0xF5, 0x82, 0x88, 0x83, 0xE4, 0x73, 0x74, 0x02, 0x93, 0x68, 0x60, 0xEF, 0xA3,
0xA3, 0xA3, 0x80, 0xDF, 0xE6, 0xFB, 0x08, 0xE6, 0xFA, 0x08, 0xE6, 0xF9, 0x22, 0xFA, 0xE6, 0xFB,
0x08, 0x08, 0xE6, 0xF9, 0x25, 0xF0, 0xF6, 0x18, 0xE6, 0xCA, 0x3A, 0xF6, 0x22, 0xEB, 0xF6, 0x08,
0xEA, 0xF6, 0x08, 0xE9, 0xF6, 0x22, 0xE2, 0xFB, 0x08, 0xE2, 0xFA, 0x08, 0xE2, 0xF9, 0x22, 0xFA,
0xE2, 0xFB, 0x08, 0x08, 0xE2, 0xF9, 0x25, 0xF0, 0xF2, 0x18, 0xE2, 0xCA, 0x3A, 0xF2, 0x22, 0xEB,
0xF2, 0x08, 0xEA, 0xF2, 0x08, 0xE9, 0xF2, 0x22, 0xE4, 0x93, 0xFB, 0x74, 0x01, 0x93, 0xFA, 0x74,
0x02, 0x93, 0xF9, 0x22, 0x90, 0x06, 0x23, 0xE0, 0x54, 0x7F, 0xFF, 0xC3, 0x74, 0x40, 0x9F, 0x90,
0x45, 0x31, 0xF0, 0xE4, 0xA3, 0xF0, 0x90, 0x10, 0x3D, 0xE0, 0x64, 0x0B, 0x60, 0x03, 0x02, 0x2A,
0x60, 0x90, 0x10, 0x44, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x90, 0x43, 0x21, 0xE0, 0x2F, 0x90, 0x45,
0x34, 0xF0, 0x90, 0x43, 0x20, 0xE0, 0x3E, 0x90, 0x45, 0x33, 0xF0, 0x90, 0x45, 0x31, 0xE0, 0x70,
0x03, 0x02, 0x2A, 0xA6, 0x14, 0xF0, 0x90, 0x43, 0x22, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xEE, 0x60,
0x03, 0x02, 0x2A, 0x57, 0xEF, 0x12, 0x28, 0x7E, 0x29, 0x6A, 0x01, 0x29, 0x94, 0x02, 0x29, 0xB5,
0x03, 0x29, 0xDE, 0x04, 0x29, 0xFE, 0x07, 0x2A, 0x31, 0x09, 0x2A, 0x31, 0x0A, 0x2A, 0x31, 0x0B,
0x2A, 0x31, 0x0C, 0x2A, 0x31, 0x0D, 0x00, 0x00, 0x2A, 0x57, 0x90, 0x45, 0x32, 0xE0, 0x24, 0x60,
0xF5, 0x82, 0xE4, 0x34, 0x06, 0xF5, 0x83, 0xE0, 0xFF, 0x90, 0x45, 0x33, 0xE4, 0x75, 0xF0, 0x01,
0x12, 0x26, 0xC6, 0xFC, 0x74, 0x00, 0x25, 0xF0, 0xF5, 0x82, 0x74, 0x00, 0x3C, 0xF5, 0x83, 0xEF,
0xF0, 0x02, 0x2A, 0x57, 0x90, 0x45, 0x33, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xC6, 0xAF, 0xF0,
0x90, 0x45, 0x32, 0xE0, 0x24, 0x60, 0xF5, 0x82, 0xE4, 0x34, 0x06, 0xF5, 0x83, 0xE0, 0xFD, 0x12,
0x3D, 0x00, 0x02, 0x2A, 0x57, 0x90, 0x45, 0x32, 0xE0, 0x24, 0x60, 0xF5, 0x82, 0xE4, 0x34, 0x06,
0xF5, 0x83, 0xE0, 0xFF, 0x90, 0x45, 0x33, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xC6, 0xFC, 0x74,
0x00, 0x25, 0xF0, 0xF5, 0x82, 0x74, 0x04, 0x3C, 0xF5, 0x83, 0xEF, 0xF0, 0x80, 0x79, 0x90, 0x45,
0x33, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xC6, 0xAF, 0xF0, 0x90, 0x45, 0x32, 0xE0, 0x24, 0x60,
0xF5, 0x82, 0xE4, 0x34, 0x06, 0xF5, 0x83, 0xE0, 0xFD, 0x12, 0x3A, 0x33, 0x80, 0x59, 0x90, 0x45,
0x32, 0xE0, 0x24, 0x60, 0xF5, 0x82, 0xE4, 0x34, 0x06, 0xF5, 0x83, 0xE0, 0xFD, 0x7F, 0xF1, 0x12,
0x3D, 0x00, 0x90, 0x45, 0x34, 0xE0, 0x44, 0x80, 0xFD, 0x7F, 0xF0, 0x12, 0x3D, 0x00, 0x90, 0x45,
0x33, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xC6, 0xAD, 0xF0, 0x7F, 0xF0, 0x12, 0x3D, 0x00, 0x80,
0x26, 0x90, 0x43, 0x22, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0x90, 0x45, 0x33, 0xE4, 0x75, 0xF0, 0x01,
0x12, 0x26, 0xC6, 0xAD, 0xF0, 0x90, 0x45, 0x32, 0xE0, 0x24, 0x60, 0xF5, 0x82, 0xE4, 0x34, 0x06,
0xF5, 0x83, 0xE0, 0xFB, 0x12, 0x3A, 0xAE, 0x90, 0x45, 0x32, 0xE0, 0x04, 0xF0, 0x02, 0x29, 0x2B,
0x90, 0x10, 0x3D, 0xE0, 0xFF, 0xB4, 0x0D, 0x2D, 0x90, 0x45, 0x31, 0xE0, 0x60, 0x38, 0xA3, 0xE0,
0xFE, 0x04, 0xF0, 0x74, 0x60, 0x2E, 0xF5, 0x82, 0xE4, 0x34, 0x06, 0xF5, 0x83, 0xE0, 0xFE, 0x90,
0x10, 0x3F, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27, 0xA3, 0xEE, 0x12, 0x26, 0x7C, 0x90, 0x45, 0x31,
0xE0, 0x14, 0xF0, 0x80, 0xD3, 0xEF, 0xB4, 0x0C, 0x07, 0xC2, 0x8C, 0xE4, 0x90, 0x43, 0x19, 0xF0,
0xE4, 0x90, 0x10, 0x3D, 0xF0, 0x22, 0x30, 0x04, 0x0A, 0xC2, 0x04, 0x90, 0x06, 0x23, 0x74, 0xC0,
0xF0, 0x80, 0x08, 0xD2, 0x04, 0x90, 0x06, 0x23, 0x74, 0x40, 0xF0, 0x90, 0x45, 0x32, 0xE0, 0xFF,
0x90, 0x10, 0x44, 0xE4, 0x8F, 0xF0, 0x12, 0x26, 0xB0, 0x90, 0x10, 0x42, 0xE0, 0xFE, 0xA3, 0xE0,
0xFF, 0xA3, 0xE0, 0xB5, 0x06, 0x19, 0xA3, 0xE0, 0xB5, 0x07, 0x14, 0x90, 0x10, 0x3D, 0xE0, 0xB4,
0x0D, 0x03, 0x12, 0x1E, 0x87, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xA3, 0x74, 0x08, 0xF0, 0x90,
0x06, 0x25, 0x74, 0x08, 0xF0, 0x22, 0x90, 0x45, 0x38, 0x12, 0x27, 0xBA, 0x12, 0x26, 0x36, 0x60,
0x03, 0x02, 0x2B, 0x8F, 0x7F, 0x1C, 0x12, 0x3B, 0x25, 0x90, 0x45, 0x3B, 0x12, 0x27, 0x9A, 0x90,
0x00, 0x08, 0xEF, 0x12, 0x26, 0x8E, 0x7F, 0x1D, 0x12, 0x3B, 0x25, 0x90, 0x45, 0x3B, 0x12, 0x27,
0x9A, 0x90, 0x00, 0x09, 0xEF, 0x12, 0x26, 0x8E, 0x7F, 0x1B, 0x12, 0x3B, 0x25, 0x90, 0x45, 0x3B,
0x12, 0x27, 0x9A, 0x90, 0x00, 0x07, 0xEF, 0x12, 0x26, 0x8E, 0xE9, 0x24, 0x07, 0xF9, 0xE4, 0x3A,
0xFA, 0x12, 0x26, 0x36, 0x54, 0x7F, 0x12, 0x26, 0x7C, 0x90, 0x45, 0x3B, 0x12, 0x27, 0x9A, 0x90,
0x00, 0x07, 0x12, 0x26, 0x4F, 0x90, 0x45, 0x45, 0xF0, 0x90, 0x04, 0x2B, 0x74, 0xFF, 0xF0, 0x12,
0x3C, 0x43, 0x90, 0x45, 0x3B, 0x12, 0x27, 0x9A, 0x90, 0x00, 0x07, 0x12, 0x26, 0x4F, 0xFF, 0x12,
0x3D, 0x62, 0x90, 0x45, 0x3B, 0x12, 0x27, 0x9A, 0x90, 0x00, 0x08, 0x12, 0x26, 0x4F, 0xFD, 0x90,
0x40, 0xC0, 0xF0, 0x90, 0x00, 0x07, 0x12, 0x26, 0x4F, 0xFF, 0x12, 0x39, 0x2D, 0x80, 0x1B, 0x12,
0x3D, 0xE2, 0x90, 0x04, 0x54, 0xE0, 0x54, 0xFB, 0xF0, 0x90, 0x06, 0x38, 0x74, 0x03, 0xF0, 0x12,
0x3D, 0x31, 0x90, 0x04, 0x48, 0x74, 0x02, 0xF0, 0x14, 0xF0, 0xE4, 0xFF, 0xFE, 0x74, 0xC4, 0x2F,
0xF5, 0x82, 0xE4, 0x34, 0x04, 0xF5, 0x83, 0xE0, 0xFD, 0x90, 0x45, 0x3B, 0x12, 0x27, 0x9A, 0xE9,
0x24, 0x01, 0xF9, 0xE4, 0x3A, 0xFA, 0xE9, 0x2F, 0xF9, 0xEA, 0x3E, 0xFA, 0xED, 0x12, 0x26, 0x7C,
0x0F, 0xBF, 0x00, 0x01, 0x0E, 0xEF, 0x64, 0x06, 0x4E, 0x70, 0xD2, 0x90, 0x45, 0x38, 0x12, 0x27,
0x9A, 0x90, 0x00, 0x01, 0x12, 0x26, 0x4F, 0x60, 0x31, 0xE4, 0xFE, 0xFF, 0x90, 0x45, 0x38, 0x12,
0x27, 0x9A, 0xE9, 0x24, 0x02, 0xF9, 0xE4, 0x3A, 0xFA, 0xE9, 0x2F, 0xF9, 0xEA, 0x3E, 0xFA, 0x12,
0x26, 0x36, 0xFD, 0x74, 0xC4, 0x2F, 0xF5, 0x82, 0xE4, 0x34, 0x04, 0xF5, 0x83, 0xED, 0xF0, 0x0F,
0xBF, 0x00, 0x01, 0x0E, 0xEF, 0x64, 0x06, 0x4E, 0x70, 0xD2, 0x90, 0x45, 0x38, 0x12, 0x27, 0x9A,
0x90, 0x00, 0x08, 0x12, 0x26, 0x4F, 0x90, 0x04, 0x21, 0xF0, 0x90, 0x00, 0x09, 0x12, 0x26, 0x4F,
0x90, 0x04, 0x20, 0xF0, 0x90, 0x04, 0x50, 0xE0, 0x44, 0x82, 0xF0, 0x90, 0x04, 0x54, 0x74, 0x0E,
0xF0, 0x90, 0x45, 0x3B, 0x12, 0x27, 0x9A, 0xE4, 0x12, 0x26, 0x7C, 0xD3, 0x22, 0xAC, 0x07, 0xAA,
0x05, 0xD2, 0x03, 0x90, 0x04, 0x78, 0xE0, 0x54, 0xFE, 0xF0, 0xEC, 0xD3, 0x94, 0x0E, 0x40, 0x03,
0x02, 0x2C, 0xFA, 0xEA, 0x94, 0x0E, 0x50, 0x03, 0x02, 0x2C, 0xFA, 0x90, 0x40, 0xC9, 0xE0, 0xFD,
0x90, 0x40, 0xC8, 0xE0, 0xFB, 0x90, 0x40, 0xC7, 0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03, 0x90,
0x40, 0xCC, 0xE0, 0xFD, 0x90, 0x40, 0xCB, 0xE0, 0xFB, 0x90, 0x40, 0xCA, 0x12, 0x3C, 0x89, 0x82,
0x03, 0x92, 0x03, 0x90, 0x40, 0xD2, 0xE0, 0xFD, 0x90, 0x40, 0xD1, 0xE0, 0xFB, 0x90, 0x40, 0xD0,
0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03, 0x90, 0x40, 0xD8, 0xE0, 0xFD, 0x90, 0x40, 0xD7, 0xE0,
0xFB, 0x90, 0x40, 0xD6, 0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03, 0x90, 0x40, 0xE1, 0xE0, 0xFD,
0x90, 0x40, 0xE0, 0xE0, 0xFB, 0x90, 0x40, 0xDF, 0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03, 0x90,
0x40, 0xE7, 0xE0, 0xFD, 0x90, 0x40, 0xE6, 0xE0, 0xFB, 0x90, 0x40, 0xE5, 0x12, 0x3C, 0x89, 0x82,
0x03, 0x92, 0x03, 0x90, 0x40, 0xF0, 0xE0, 0xFD, 0x90, 0x40, 0xEF, 0xE0, 0xFB, 0x90, 0x40, 0xEE,
0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03, 0x02, 0x2D, 0x98, 0xEC, 0xD3, 0x94, 0x0E, 0x50, 0x03,
0x02, 0x2D, 0x98, 0xEA, 0xD3, 0x94, 0x0E, 0x40, 0x03, 0x02, 0x2D, 0x98, 0x90, 0x42, 0xF1, 0xE0,
0xFD, 0x90, 0x42, 0xF0, 0xE0, 0xFB, 0x90, 0x42, 0xEF, 0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03,
0x90, 0x42, 0xF4, 0xE0, 0xFD, 0x90, 0x42, 0xF3, 0xE0, 0xFB, 0x90, 0x42, 0xF2, 0x12, 0x3C, 0x89,
0x82, 0x03, 0x92, 0x03, 0x90, 0x42, 0xFA, 0xE0, 0xFD, 0x90, 0x42, 0xF9, 0xE0, 0xFB, 0x90, 0x42,
0xF8, 0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03, 0x90, 0x43, 0x00, 0xE0, 0xFD, 0x90, 0x42, 0xFF,
0xE0, 0xFB, 0x90, 0x42, 0xFE, 0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03, 0x90, 0x43, 0x09, 0xE0,
0xFD, 0x90, 0x43, 0x08, 0xE0, 0xFB, 0x90, 0x43, 0x07, 0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03,
0x90, 0x43, 0x0F, 0xE0, 0xFD, 0x90, 0x43, 0x0E, 0xE0, 0xFB, 0x90, 0x43, 0x0D, 0x12, 0x3C, 0x89,
0x82, 0x03, 0x92, 0x03, 0x90, 0x43, 0x18, 0xE0, 0xFD, 0x90, 0x43, 0x17, 0xE0, 0xFB, 0x90, 0x43,
0x16, 0x12, 0x3C, 0x89, 0x82, 0x03, 0x92, 0x03, 0x90, 0x04, 0x78, 0xE0, 0x44, 0x01, 0xF0, 0xA2,
0x03, 0x22, 0xAC, 0x07, 0xAA, 0x05, 0xD2, 0x03, 0xEC, 0xD3, 0x94, 0x0E, 0x40, 0x03, 0x02, 0x2E,
0x43, 0xEA, 0x94, 0x0E, 0x50, 0x03, 0x02, 0x2E, 0x43, 0x90, 0x40, 0xC9, 0xE0, 0xFD, 0x90, 0x40,
0xC8, 0xE0, 0xFB, 0x90, 0x40, 0xC7, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90,
0x82, 0x03, 0x92, 0x03, 0x90, 0x40, 0xD8, 0xE0, 0xFD, 0x90, 0x40, 0xD7, 0xE0, 0xFB, 0x90, 0x40,
0xD6, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x03, 0x92, 0x03, 0x90,
0x40, 0xDE, 0xE0, 0xFD, 0x90, 0x40, 0xDD, 0xE0, 0xFB, 0x90, 0x40, 0xDC, 0xE0, 0x90, 0x45, 0x44,
0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x03, 0x92, 0x03, 0x90, 0x40, 0xE7, 0xE0, 0xFD, 0x90,
0x40, 0xE6, 0xE0, 0xFB, 0x90, 0x40, 0xE5, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C,
0x90, 0x82, 0x03, 0x92, 0x03, 0x90, 0x40, 0xED, 0xE0, 0xFD, 0x90, 0x40, 0xEC, 0xE0, 0xFB, 0x90,
0x40, 0xEB, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x03, 0x92, 0x03,
0x02, 0x2E, 0xDC, 0xEC, 0xD3, 0x94, 0x0E, 0x50, 0x03, 0x02, 0x2E, 0xDC, 0xEA, 0xD3, 0x94, 0x0E,
0x40, 0x03, 0x02, 0x2E, 0xDC, 0x90, 0x42, 0xF1, 0xE0, 0xFD, 0x90, 0x42, 0xF0, 0xE0, 0xFB, 0x90,
0x42, 0xEF, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x03, 0x92, 0x03,
0x90, 0x43, 0x00, 0xE0, 0xFD, 0x90, 0x42, 0xFF, 0xE0, 0xFB, 0x90, 0x42, 0xFE, 0xE0, 0x90, 0x45,
0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x03, 0x92, 0x03, 0x90, 0x43, 0x06, 0xE0, 0xFD,
0x90, 0x43, 0x05, 0xE0, 0xFB, 0x90, 0x43, 0x04, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12,
0x3C, 0x90, 0x82, 0x03, 0x92, 0x03, 0x90, 0x43, 0x0F, 0xE0, 0xFD, 0x90, 0x43, 0x0E, 0xE0, 0xFB,
0x90, 0x43, 0x0D, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x03, 0x92,
0x03, 0x90, 0x43, 0x15, 0xE0, 0xFD, 0x90, 0x43, 0x14, 0xE0, 0xFB, 0x90, 0x43, 0x13, 0xE0, 0x90,
0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x03, 0x92, 0x03, 0xA2, 0x03, 0x22, 0x90,
0x45, 0x40, 0xEF, 0xF0, 0xD2, 0x02, 0x90, 0x40, 0xC0, 0xE0, 0xFF, 0x90, 0x45, 0x40, 0xE0, 0xFD,
0x12, 0x2D, 0xA2, 0x82, 0x02, 0x92, 0x02, 0x90, 0x45, 0x40, 0xE0, 0xFC, 0xD3, 0x94, 0x0E, 0x50,
0x10, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0x7B, 0x8A, 0x7D, 0xF1, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x80,
0x3A, 0xEC, 0xD3, 0x94, 0x28, 0x50, 0x10, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0x7B, 0x8B, 0x7D, 0xF1,
0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x80, 0x24, 0xEC, 0xD3, 0x94, 0x33, 0x50, 0x10, 0xE4, 0x90, 0x45,
0x44, 0xF0, 0x7B, 0x8B, 0x7D, 0xB1, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x80, 0x0E, 0xE4, 0x90, 0x45,
0x44, 0xF0, 0x7B, 0x8B, 0x7D, 0x91, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x90, 0x45, 0x40, 0xE0, 0xFF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0xF0, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0xFD, 0xEF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0xEF, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0xFB, 0xEF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0xEE, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0x90, 0x45,
0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0x90, 0x45, 0x40, 0xE0, 0xFF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0x98, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0xFD, 0xEF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0x97, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0xFB, 0xEF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0x96, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0x90, 0x45,
0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0x90, 0x45, 0x40, 0xE0, 0xFF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0x40, 0xF5, 0x82, 0xE4, 0x34, 0x42, 0xF5, 0x83, 0xE0, 0xFD, 0xEF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0x3F, 0xF5, 0x82, 0xE4, 0x34, 0x42, 0xF5, 0x83, 0xE0, 0xFB, 0xEF,
0x75, 0xF0, 0x03, 0xA4, 0x24, 0x3E, 0xF5, 0x82, 0xE4, 0x34, 0x42, 0xF5, 0x83, 0xE0, 0x90, 0x45,
0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0xE4, 0x90, 0x45, 0x44, 0xF0,
0xFB, 0xFD, 0x7F, 0xC8, 0x12, 0x3D, 0x90, 0xA2, 0x02, 0x22, 0xD2, 0x01, 0xE4, 0x90, 0x04, 0x78,
0xF0, 0xA3, 0x74, 0x13, 0xF0, 0x7B, 0x01, 0x7A, 0x45, 0x79, 0x40, 0x7F, 0x0D, 0x12, 0x3C, 0xCD,
0x90, 0x45, 0x40, 0xE0, 0x54, 0xFE, 0xFF, 0xF0, 0xFD, 0x7F, 0x0D, 0x12, 0x3D, 0x00, 0xE4, 0x90,
0x45, 0x3E, 0xF0, 0xA3, 0xF0, 0x90, 0x45, 0x3E, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xC3, 0x94, 0x10,
0xEE, 0x64, 0x80, 0x94, 0x80, 0x50, 0x57, 0x90, 0x42, 0xEB, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27,
0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0xFD, 0x90, 0x42, 0xEA, 0x75,
0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0,
0xFB, 0x90, 0x42, 0xE9, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4,
0x25, 0x83, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x01,
0x92, 0x01, 0x90, 0x45, 0x3E, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0, 0x80, 0x97, 0x90, 0x04,
0x78, 0x74, 0x01, 0xF0, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F, 0x96, 0x12, 0x3D, 0x90,
0x90, 0x45, 0x44, 0x74, 0x9A, 0xF0, 0x7B, 0xBA, 0x7D, 0x8F, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82,
0x01, 0x92, 0x01, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F, 0x1E, 0x12, 0x3D, 0x90, 0x90,
0x45, 0x44, 0x74, 0x3A, 0xF0, 0x7B, 0xBA, 0x7D, 0x8F, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x01,
0x92, 0x01, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F, 0x1E, 0x12, 0x3D, 0x90, 0x90, 0x43,
0x18, 0xE0, 0xFD, 0x90, 0x43, 0x17, 0xE0, 0xFB, 0x90, 0x43, 0x16, 0xE0, 0x90, 0x45, 0x44, 0xF0,
0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x01, 0x92, 0x01, 0x90, 0x04, 0x79, 0x74, 0x13, 0xF0, 0x90,
0x04, 0x78, 0x74, 0x05, 0xF0, 0x7B, 0x01, 0x7A, 0x45, 0x79, 0x40, 0x7F, 0x0D, 0x12, 0x3C, 0xCD,
0x90, 0x45, 0x40, 0xE0, 0x44, 0x01, 0xFF, 0xF0, 0xFD, 0x7F, 0x0D, 0x12, 0x3D, 0x00, 0x90, 0x04,
0x62, 0x74, 0xC0, 0xF0, 0xA2, 0x01, 0x22, 0xD2, 0x01, 0xE4, 0x90, 0x04, 0x78, 0xF0, 0xA3, 0x74,
0x13, 0xF0, 0xE4, 0x90, 0x45, 0x3E, 0xF0, 0xA3, 0xF0, 0x90, 0x45, 0x3E, 0xE0, 0xFE, 0xA3, 0xE0,
0xFF, 0xC3, 0x94, 0x0F, 0xEE, 0x64, 0x80, 0x94, 0x80, 0x50, 0x57, 0x90, 0x42, 0xEB, 0x75, 0xF0,
0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0xFD,
0x90, 0x42, 0xEA, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25,
0x83, 0xF5, 0x83, 0xE0, 0xFB, 0x90, 0x42, 0xE9, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE,
0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12,
0x3C, 0x90, 0x82, 0x01, 0x92, 0x01, 0x90, 0x45, 0x3E, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0,
0x80, 0x97, 0x90, 0x04, 0x78, 0x74, 0x01, 0xF0, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F,
0x96, 0x12, 0x3D, 0x90, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0x7B, 0xD8, 0x7D, 0x0F, 0x7F, 0xB9, 0x12,
0x3C, 0x90, 0x82, 0x01, 0x92, 0x01, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F, 0x1E, 0x12,
0x3D, 0x90, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0x7B, 0x78, 0x7D, 0x0F, 0x7F, 0xB9, 0x12, 0x3C, 0x90,
0x82, 0x01, 0x92, 0x01, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F, 0x1E, 0x12, 0x3D, 0x90,
0x90, 0x43, 0x15, 0xE0, 0xFD, 0x90, 0x43, 0x14, 0xE0, 0xFB, 0x90, 0x43, 0x13, 0xE0, 0x90, 0x45,
0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x01, 0x92, 0x01, 0x90, 0x04, 0x78, 0x74, 0x05,
0xF0, 0x90, 0x04, 0x62, 0x74, 0xC0, 0xF0, 0xA2, 0x01, 0x22, 0x90, 0x45, 0x40, 0xEF, 0xF0, 0xD2,
0x02, 0x90, 0x04, 0x78, 0xE0, 0x54, 0xFE, 0xF0, 0x90, 0x45, 0x40, 0xE0, 0xFF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0xF0, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0xFD, 0xEF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0xEF, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0xFB, 0xEF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0xEE, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F,
0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0x90, 0x45, 0x40, 0xE0, 0xFF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0x98, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0xFD, 0xEF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0x97, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0xFB, 0xEF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0x96, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F,
0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0x90, 0x45, 0x40, 0xE0, 0xFF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0x40, 0xF5, 0x82, 0xE4, 0x34, 0x42, 0xF5, 0x83, 0xE0, 0xFD, 0xEF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0x3F, 0xF5, 0x82, 0xE4, 0x34, 0x42, 0xF5, 0x83, 0xE0, 0xFB, 0xEF, 0x75, 0xF0, 0x03,
0xA4, 0x24, 0x3E, 0xF5, 0x82, 0xE4, 0x34, 0x42, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F,
0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0x90, 0x04, 0x78, 0xE0, 0x44, 0x01, 0xF0, 0xE4,
0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F, 0xC8, 0x12, 0x3D, 0x90, 0x90, 0x40, 0xC0, 0xE0, 0xFF,
0x90, 0x45, 0x40, 0xE0, 0xFD, 0x12, 0x2C, 0x4D, 0xA2, 0x02, 0x22, 0x90, 0x45, 0x31, 0x12, 0x27,
0xBA, 0xE4, 0xFF, 0x90, 0x04, 0x48, 0xE0, 0x44, 0x10, 0xF0, 0xE4, 0xFD, 0xFC, 0x90, 0x04, 0x48,
0xE0, 0xFF, 0x30, 0xE4, 0x0B, 0x0D, 0xBD, 0x00, 0x01, 0x0C, 0xBC, 0x07, 0xF0, 0xBD, 0xFF, 0xED,
0xAE, 0x04, 0xAF, 0x05, 0xBE, 0x07, 0x05, 0xBF, 0xFF, 0x02, 0xC3, 0x22, 0x90, 0x04, 0x30, 0xE0,
0xFF, 0x90, 0x45, 0x31, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27, 0xA3, 0xEF, 0x12, 0x26, 0x7C, 0x90,
0x04, 0x31, 0xE0, 0xFF, 0x90, 0x45, 0x31, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27, 0xA3, 0xEF, 0x12,
0x26, 0x7C, 0x90, 0x04, 0x32, 0xE0, 0xFF, 0x90, 0x45, 0x31, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27,
0xA3, 0xEF, 0x12, 0x26, 0x7C, 0x90, 0x04, 0x33, 0xE0, 0xFF, 0x90, 0x45, 0x31, 0xE4, 0x75, 0xF0,
0x01, 0x12, 0x27, 0xA3, 0xEF, 0x12, 0x26, 0x7C, 0x90, 0x04, 0x34, 0xE0, 0xFF, 0x90, 0x45, 0x31,
0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27, 0xA3, 0xEF, 0x12, 0x26, 0x7C, 0x90, 0x04, 0x35, 0xE0, 0xFF,
0x90, 0x45, 0x31, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27, 0xA3, 0xEF, 0x12, 0x26, 0x7C, 0x90, 0x04,
0x36, 0xE0, 0xFF, 0x90, 0x45, 0x31, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27, 0xA3, 0xEF, 0x12, 0x26,
0x7C, 0x90, 0x04, 0x37, 0xE0, 0xFF, 0x90, 0x45, 0x31, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27, 0xA3,
0xEF, 0x12, 0x26, 0x7C, 0xD3, 0x22, 0x7B, 0x01, 0x7A, 0x10, 0x79, 0x34, 0x90, 0x45, 0x3A, 0x12,
0x27, 0xBA, 0x90, 0x45, 0x3A, 0x12, 0x27, 0x9A, 0x90, 0x00, 0x12, 0x12, 0x27, 0xC3, 0xC0, 0x03,
0xC0, 0x02, 0xC0, 0x01, 0x90, 0x45, 0x3A, 0x12, 0x27, 0x9A, 0x90, 0x00, 0x15, 0x12, 0x28, 0x25,
0x90, 0x45, 0x3A, 0x12, 0x27, 0x9A, 0x90, 0x00, 0x18, 0x12, 0x26, 0xDC, 0xFF, 0x90, 0x00, 0x1A,
0xE5, 0xF0, 0x8F, 0xF0, 0x12, 0x27, 0x61, 0xE4, 0xFF, 0xEF, 0xC3, 0x94, 0x40, 0x50, 0x44, 0x90,
0x45, 0x3A, 0x12, 0x27, 0x9A, 0x90, 0x00, 0x18, 0x12, 0x26, 0xDC, 0xD3, 0x94, 0x00, 0xE5, 0xF0,
0x94, 0x00, 0x40, 0x2F, 0x90, 0x00, 0x12, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x27, 0xF3, 0x12, 0x26,
0x36, 0xFE, 0xAD, 0x07, 0x0F, 0x74, 0x60, 0x2D, 0xF5, 0x82, 0xE4, 0x34, 0x06, 0xF5, 0x83, 0xEE,
0xF0, 0x90, 0x45, 0x3A, 0x12, 0x27, 0x9A, 0x90, 0x00, 0x18, 0x74, 0xFF, 0xF5, 0xF0, 0x12, 0x27,
0x14, 0x80, 0xB6, 0xEF, 0x70, 0x17, 0x90, 0x06, 0x23, 0x74, 0x80, 0xF0, 0xE4, 0xA3, 0xF0, 0x90,
0x10, 0x3D, 0xE0, 0xB4, 0x0C, 0x1C, 0x12, 0x3E, 0x36, 0xD2, 0x8C, 0x80, 0x15, 0x30, 0x04, 0x0B,
0xC2, 0x04, 0xEF, 0x44, 0x80, 0x90, 0x06, 0x23, 0xF0, 0x80, 0x07, 0xD2, 0x04, 0x90, 0x06, 0x23,
0xEF, 0xF0, 0x90, 0x06, 0x25, 0x74, 0x08, 0xF0, 0x22, 0x90, 0x06, 0x25, 0xE0, 0x30, 0xE0, 0x2F,
0x90, 0x10, 0x3D, 0xE0, 0x24, 0xFB, 0x70, 0x1D, 0x90, 0x10, 0x49, 0x12, 0x27, 0x9A, 0x90, 0x10,
0x46, 0x12, 0x27, 0xBA, 0x90, 0x10, 0x4E, 0xE0, 0xFF, 0xA3, 0xE0, 0x90, 0x10, 0x4C, 0xCF, 0xF0,
0xA3, 0xEF, 0xF0, 0x80, 0x07, 0xE4, 0x90, 0x10, 0x4C, 0xF0, 0xA3, 0xF0, 0x02, 0x33, 0xF6, 0x90,
0x10, 0x3D, 0xE0, 0x12, 0x28, 0x7E, 0x35, 0x12, 0x01, 0x35, 0x12, 0x05, 0x35, 0x12, 0x07, 0x35,
0x12, 0x09, 0x35, 0x15, 0x0B, 0x35, 0x12, 0x0C, 0x35, 0x1B, 0x0D, 0x35, 0x21, 0x0F, 0x00, 0x00,
0x35, 0x5C, 0x02, 0x33, 0xF6, 0xE4, 0x90, 0x10, 0x3D, 0xF0, 0x22, 0xE4, 0x90, 0x10, 0x3D, 0xF0,
0x22, 0x90, 0x10, 0x50, 0xE0, 0xFF, 0xB4, 0x01, 0x07, 0x90, 0x06, 0x07, 0x74, 0x20, 0xF0, 0x22,
0xEF, 0xB4, 0x02, 0x07, 0x90, 0x06, 0x07, 0x74, 0x40, 0xF0, 0x22, 0xEF, 0xB4, 0x03, 0x07, 0x90,
0x06, 0x07, 0x74, 0x60, 0xF0, 0x22, 0xEF, 0xB4, 0x04, 0x07, 0x90, 0x06, 0x07, 0x74, 0x80, 0xF0,
0x22, 0xEF, 0xB4, 0x05, 0x0C, 0x90, 0x06, 0x07, 0x74, 0xA0, 0xF0, 0x22, 0xE4, 0x90, 0x10, 0x3D,
0xF0, 0x22, 0x78, 0x7F, 0xE4, 0xF6, 0xD8, 0xFD, 0x75, 0x81, 0x20, 0x02, 0x35, 0xA9, 0x02, 0x23,
0x50, 0xE4, 0x93, 0xA3, 0xF8, 0xE4, 0x93, 0xA3, 0x40, 0x03, 0xF6, 0x80, 0x01, 0xF2, 0x08, 0xDF,
0xF4, 0x80, 0x29, 0xE4, 0x93, 0xA3, 0xF8, 0x54, 0x07, 0x24, 0x0C, 0xC8, 0xC3, 0x33, 0xC4, 0x54,
0x0F, 0x44, 0x20, 0xC8, 0x83, 0x40, 0x04, 0xF4, 0x56, 0x80, 0x01, 0x46, 0xF6, 0xDF, 0xE4, 0x80,
0x0B, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x90, 0x3E, 0x45, 0xE4, 0x7E, 0x01, 0x93,
0x60, 0xBC, 0xA3, 0xFF, 0x54, 0x3F, 0x30, 0xE5, 0x09, 0x54, 0x1F, 0xFE, 0xE4, 0x93, 0xA3, 0x60,
0x01, 0x0E, 0xCF, 0x54, 0xC0, 0x25, 0xE0, 0x60, 0xA8, 0x40, 0xB8, 0xE4, 0x93, 0xA3, 0xFA, 0xE4,
0x93, 0xA3, 0xF8, 0xE4, 0x93, 0xA3, 0xC8, 0xC5, 0x82, 0xC8, 0xCA, 0xC5, 0x83, 0xCA, 0xF0, 0xA3,
0xC8, 0xC5, 0x82, 0xC8, 0xCA, 0xC5, 0x83, 0xCA, 0xDF, 0xE9, 0xDE, 0xE7, 0x80, 0xBE, 0xAC, 0x07,
0xD2, 0x02, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0xF0, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83,
0xE0, 0xFD, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0xEF, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83,
0xE0, 0xFB, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0xEE, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83,
0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0xEC, 0x75,
0xF0, 0x03, 0xA4, 0x24, 0x98, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0xFD, 0xEC, 0x75,
0xF0, 0x03, 0xA4, 0x24, 0x97, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0xFB, 0xEC, 0x75,
0xF0, 0x03, 0xA4, 0x24, 0x96, 0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44,
0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB,
0xFD, 0x7F, 0xC8, 0x12, 0x3D, 0x90, 0xA2, 0x02, 0x22, 0xAC, 0x07, 0xD2, 0x02, 0xEC, 0x75, 0xF0,
0x03, 0xA4, 0x24, 0xF0, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0xFD, 0xEC, 0x75, 0xF0,
0x03, 0xA4, 0x24, 0xEF, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0xFB, 0xEC, 0x75, 0xF0,
0x03, 0xA4, 0x24, 0xEE, 0xF5, 0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0,
0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0x98,
0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0xFD, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0x97,
0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0xFB, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0x96,
0xF5, 0x82, 0xE4, 0x34, 0x41, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C,
0x90, 0x82, 0x02, 0x92, 0x02, 0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F, 0xC8, 0x12, 0x3D,
0x90, 0xA2, 0x02, 0x22, 0xAC, 0x07, 0xD2, 0x02, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0xF0, 0xF5,
0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0xFD, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0xEF, 0xF5,
0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0xFB, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0xEE, 0xF5,
0x82, 0xE4, 0x34, 0x40, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90,
0x82, 0x02, 0x92, 0x02, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0x98, 0xF5, 0x82, 0xE4, 0x34, 0x41,
0xF5, 0x83, 0xE0, 0xFD, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0x97, 0xF5, 0x82, 0xE4, 0x34, 0x41,
0xF5, 0x83, 0xE0, 0xFB, 0xEC, 0x75, 0xF0, 0x03, 0xA4, 0x24, 0x96, 0xF5, 0x82, 0xE4, 0x34, 0x41,
0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x02, 0x92, 0x02,
0xE4, 0x90, 0x45, 0x44, 0xF0, 0xFB, 0xFD, 0x7F, 0xC8, 0x12, 0x3D, 0x90, 0xA2, 0x02, 0x22, 0xD2,
0x01, 0xE4, 0x90, 0x04, 0x78, 0xF0, 0xA3, 0x74, 0x1B, 0xF0, 0x90, 0x04, 0x78, 0x74, 0x05, 0xF0,
0xE4, 0x90, 0x45, 0x3E, 0xF0, 0xA3, 0xF0, 0x90, 0x45, 0x3E, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xC3,
0x94, 0x0B, 0xEE, 0x64, 0x80, 0x94, 0x80, 0x50, 0x57, 0x90, 0x42, 0xEB, 0x75, 0xF0, 0x03, 0xEF,
0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0xFD, 0x90, 0x42,
0xEA, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5,
0x83, 0xE0, 0xFB, 0x90, 0x42, 0xE9, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0,
0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90,
0x82, 0x01, 0x92, 0x01, 0x90, 0x45, 0x3E, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0, 0x80, 0x97,
0x90, 0x04, 0x62, 0x74, 0xC0, 0xF0, 0xA2, 0x01, 0x22, 0xD2, 0x01, 0xE4, 0x90, 0x04, 0x78, 0xF0,
0xA3, 0x74, 0x1B, 0xF0, 0x90, 0x04, 0x78, 0x74, 0x05, 0xF0, 0xE4, 0x90, 0x45, 0x3E, 0xF0, 0xA3,
0xF0, 0x90, 0x45, 0x3E, 0xE0, 0xFE, 0xA3, 0xE0, 0xFF, 0xC3, 0x94, 0x0D, 0xEE, 0x64, 0x80, 0x94,
0x80, 0x50, 0x57, 0x90, 0x42, 0xEB, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0,
0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0xFD, 0x90, 0x42, 0xEA, 0x75, 0xF0, 0x03, 0xEF, 0x12,
0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0xFB, 0x90, 0x42, 0xE9,
0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83,
0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9, 0x12, 0x3C, 0x90, 0x82, 0x01, 0x92, 0x01, 0x90, 0x45,
0x3E, 0xE4, 0x75, 0xF0, 0x01, 0x12, 0x26, 0xB0, 0x80, 0x97, 0x90, 0x04, 0x62, 0x74, 0xC0, 0xF0,
0xA2, 0x01, 0x22, 0xD2, 0x01, 0xE4, 0x90, 0x04, 0x78, 0xF0, 0xA3, 0x74, 0x1B, 0xF0, 0x90, 0x04,
0x78, 0x74, 0x05, 0xF0, 0xE4, 0x90, 0x45, 0x3E, 0xF0, 0xA3, 0xF0, 0x90, 0x45, 0x3E, 0xE0, 0xFE,
0xA3, 0xE0, 0xFF, 0xC3, 0x94, 0x0F, 0xEE, 0x64, 0x80, 0x94, 0x80, 0x50, 0x57, 0x90, 0x42, 0xEB,
0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83,
0xE0, 0xFD, 0x90, 0x42, 0xEA, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27, 0x8E, 0xEE, 0x75, 0xF0, 0x03,
0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0xFB, 0x90, 0x42, 0xE9, 0x75, 0xF0, 0x03, 0xEF, 0x12, 0x27,
0x8E, 0xEE, 0x75, 0xF0, 0x03, 0xA4, 0x25, 0x83, 0xF5, 0x83, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F,
0xB9, 0x12, 0x3C, 0x90, 0x82, 0x01, 0x92, 0x01, 0x90, 0x45, 0x3E, 0xE4, 0x75, 0xF0, 0x01, 0x12,
0x26, 0xB0, 0x80, 0x97, 0x90, 0x04, 0x62, 0x74, 0xC0, 0xF0, 0xA2, 0x01, 0x22, 0x90, 0x45, 0x3E,
0xED, 0xF0, 0xD2, 0x01, 0x90, 0x04, 0x57, 0xE0, 0x90, 0x45, 0x3F, 0xF0, 0x90, 0x04, 0x57, 0xE0,
0x54, 0xFE, 0xF0, 0xEF, 0x12, 0x28, 0x7E, 0x39, 0x60, 0x03, 0x39, 0x78, 0x09, 0x39, 0x6C, 0x0A,
0x39, 0x78, 0x0C, 0x39, 0x84, 0x0D, 0x39, 0x60, 0x0E, 0x39, 0x90, 0x0F, 0x00, 0x00, 0x39, 0x9C,
0x90, 0x45, 0x3E, 0xE0, 0xFF, 0x12, 0x35, 0xEE, 0x92, 0x01, 0x80, 0x32, 0x90, 0x45, 0x3E, 0xE0,
0xFF, 0x12, 0x32, 0x3A, 0x92, 0x01, 0x80, 0x26, 0x90, 0x45, 0x3E, 0xE0, 0xFF, 0x12, 0x36, 0x79,
0x92, 0x01, 0x80, 0x1A, 0x90, 0x45, 0x3E, 0xE0, 0xFF, 0x12, 0x37, 0x04, 0x92, 0x01, 0x80, 0x0E,
0x90, 0x45, 0x3E, 0xE0, 0xFF, 0x12, 0x2E, 0xDF, 0x92, 0x01, 0x80, 0x02, 0xC2, 0x01, 0x12, 0x3D,
0xE2, 0x90, 0x45, 0x3F, 0xE0, 0x90, 0x04, 0x57, 0xF0, 0x90, 0x45, 0x3E, 0xE0, 0x90, 0x40, 0xC0,
0xF0, 0xA2, 0x01, 0x22, 0xAC, 0x07, 0xE4, 0x90, 0x45, 0x3A, 0xF0, 0xA3, 0xF0, 0xD2, 0x00, 0x7D,
0x03, 0xEC, 0x70, 0x13, 0x12, 0x3C, 0xC5, 0x90, 0x45, 0x3B, 0xE0, 0x54, 0xF9, 0xFF, 0xF0, 0xFD,
0x7F, 0x09, 0x12, 0x3D, 0x00, 0x80, 0x59, 0xEC, 0xB4, 0x01, 0x16, 0x12, 0x3C, 0xC5, 0x90, 0x45,
0x3B, 0xE0, 0x54, 0xFD, 0xF0, 0x44, 0x04, 0xFF, 0xF0, 0xFD, 0x7F, 0x09, 0x12, 0x3D, 0x00, 0x80,
0x3F, 0xEC, 0xB4, 0x02, 0x1B, 0x7B, 0x01, 0x7A, 0x45, 0x79, 0x3A, 0x7F, 0x0A, 0x12, 0x3C, 0xCD,
0x90, 0x45, 0x3A, 0xE0, 0x54, 0xFC, 0xFF, 0xF0, 0xFD, 0x7F, 0x0A, 0x12, 0x3D, 0x00, 0x80, 0x20,
0xEC, 0xB4, 0x03, 0x1C, 0x7B, 0x01, 0x7A, 0x45, 0x79, 0x3A, 0x7F, 0x0A, 0x12, 0x3C, 0xCD, 0x90,
0x45, 0x3A, 0xE0, 0x54, 0xFE, 0xF0, 0x44, 0x02, 0xFF, 0xF0, 0xFD, 0x7F, 0x0A, 0x12, 0x3D, 0x00,
0xA2, 0x00, 0x22, 0x90, 0x45, 0x38, 0xEF, 0xF0, 0xA3, 0xED, 0xF0, 0x90, 0x04, 0x0B, 0xE0, 0xF9,
0x54, 0xFB, 0xF0, 0xE4, 0xFF, 0xFE, 0x90, 0x04, 0x09, 0x74, 0x50, 0xF0, 0x90, 0x45, 0x38, 0xE0,
0x90, 0x04, 0x0A, 0xF0, 0x90, 0x45, 0x39, 0xE0, 0x90, 0x04, 0x0E, 0xF0, 0x90, 0x04, 0x08, 0x74,
0x80, 0xF0, 0xE4, 0xFD, 0xFC, 0x90, 0x04, 0x08, 0xE0, 0x90, 0x45, 0x3A, 0xF0, 0xE0, 0x54, 0x03,
0x70, 0x0B, 0x0D, 0xBD, 0x00, 0x01, 0x0C, 0xBC, 0x07, 0xEB, 0xBD, 0xFF, 0xE8, 0xC3, 0xED, 0x94,
0xFF, 0xEC, 0x94, 0x07, 0x50, 0x07, 0x90, 0x45, 0x3A, 0xE0, 0x30, 0xE1, 0x0B, 0x0F, 0xBF, 0x00,
0x01, 0x0E, 0xBE, 0x07, 0xB1, 0xBF, 0xFF, 0xAE, 0xBE, 0x07, 0x0A, 0xBF, 0xFF, 0x07, 0x90, 0x04,
0x0B, 0xE9, 0xF0, 0xC3, 0x22, 0xAF, 0x01, 0x90, 0x04, 0x0B, 0xE9, 0xF0, 0xD3, 0x22, 0x90, 0x45,
0x35, 0xED, 0xF0, 0xA3, 0xEB, 0xF0, 0xEE, 0x70, 0x56, 0xEF, 0x24, 0xF6, 0x60, 0x1B, 0x14, 0x60,
0x26, 0x14, 0x60, 0x31, 0x14, 0x60, 0x3C, 0x24, 0x04, 0x70, 0x44, 0x7B, 0x01, 0x7A, 0x42, 0x79,
0xE9, 0x90, 0x45, 0x37, 0x12, 0x27, 0xBA, 0x80, 0x36, 0x7B, 0x01, 0x7A, 0x40, 0x79, 0xC1, 0x90,
0x45, 0x37, 0x12, 0x27, 0xBA, 0x80, 0x28, 0x7B, 0x01, 0x7A, 0x40, 0x79, 0xF1, 0x90, 0x45, 0x37,
0x12, 0x27, 0xBA, 0x80, 0x1A, 0x7B, 0x01, 0x7A, 0x41, 0x79, 0x99, 0x90, 0x45, 0x37, 0x12, 0x27,
0xBA, 0x80, 0x0C, 0x7B, 0x01, 0x7A, 0x42, 0x79, 0x41, 0x90, 0x45, 0x37, 0x12, 0x27, 0xBA, 0x90,
0x45, 0x36, 0xE0, 0xFF, 0xA3, 0x12, 0x27, 0x9A, 0x90, 0x45, 0x35, 0xE0, 0xF5, 0x82, 0x75, 0x83,
0x00, 0xEF, 0x02, 0x26, 0x8E, 0x90, 0x45, 0x3F, 0xEF, 0xF0, 0xA3, 0x74, 0xFF, 0xF0, 0x90, 0x04,
0x0B, 0xE0, 0x90, 0x45, 0x41, 0xF0, 0xE4, 0xFF, 0xFE, 0x90, 0x04, 0x09, 0x74, 0x50, 0xF0, 0x90,
0x45, 0x3F, 0xE0, 0x90, 0x04, 0x0A, 0xF0, 0x90, 0x04, 0x08, 0x74, 0x40, 0xF0, 0xE4, 0xFD, 0xFC,
0x90, 0x04, 0x08, 0xE0, 0xF9, 0x54, 0x03, 0x70, 0x0B, 0x0D, 0xBD, 0x00, 0x01, 0x0C, 0xBC, 0x07,
0xEF, 0xBD, 0xFF, 0xEC, 0xC3, 0xED, 0x94, 0xFF, 0xEC, 0x94, 0x07, 0x50, 0x04, 0xE9, 0x30, 0xE1,
0x0B, 0x0F, 0xBF, 0x00, 0x01, 0x0E, 0xBE, 0x07, 0xC0, 0xBF, 0xFF, 0xBD, 0x90, 0x04, 0x0C, 0xE0,
0x90, 0x45, 0x40, 0xF0, 0xA3, 0xE0, 0x90, 0x04, 0x0B, 0xF0, 0x90, 0x45, 0x40, 0xE0, 0xFF, 0x22,
0xE4, 0xFE, 0xEF, 0x30, 0xE5, 0x11, 0xE4, 0xFC, 0xFD, 0x7C, 0x08, 0x90, 0x04, 0xD4, 0xE4, 0xF0,
0xA3, 0xDC, 0xFC, 0x7C, 0x00, 0x7D, 0x08, 0xEF, 0x54, 0xC0, 0x60, 0x12, 0xE4, 0xFC, 0xFD, 0x7C,
0x08, 0x90, 0x04, 0xD4, 0x74, 0xFF, 0xF0, 0xA3, 0xDC, 0xFC, 0x7C, 0x00, 0x7D, 0x08, 0xEF, 0x30,
0xE6, 0x07, 0xEE, 0x44, 0x78, 0xFE, 0x54, 0xFE, 0xFE, 0xEF, 0x54, 0x88, 0x60, 0x04, 0xEE, 0x44,
0x08, 0xFE, 0xEF, 0x30, 0xE4, 0x04, 0xEE, 0x44, 0x10, 0xFE, 0xEF, 0x30, 0xE1, 0x04, 0xEE, 0x44,
0x02, 0xFE, 0x90, 0x04, 0x56, 0xE0, 0xFF, 0x6E, 0x60, 0x02, 0xEE, 0xF0, 0x22, 0xC0, 0xE0, 0xC0,
0x83, 0xC0, 0x82, 0xC0, 0xD0, 0x75, 0xD0, 0x00, 0xC0, 0x07, 0xD2, 0x05, 0x53, 0xA8, 0xFE, 0x90,
0x06, 0x20, 0xE4, 0xF0, 0x90, 0x04, 0x58, 0xF0, 0xA3, 0xF0, 0x90, 0x06, 0x21, 0xE0, 0xFF, 0x90,
0x10, 0x39, 0xE0, 0x4F, 0xF0, 0x90, 0x06, 0x21, 0xEF, 0xF0, 0x90, 0x04, 0x5C, 0xE0, 0xFF, 0x90,
0x45, 0x46, 0xE0, 0x4F, 0xF0, 0x90, 0x04, 0x5C, 0xEF, 0xF0, 0xA3, 0xE0, 0xFF, 0x90, 0x45, 0x47,
0xE0, 0x4F, 0xF0, 0x90, 0x04, 0x5D, 0xEF, 0xF0, 0xD0, 0x07, 0xD0, 0xD0, 0xD0, 0x82, 0xD0, 0x83,
0xD0, 0xE0, 0x32, 0x90, 0x04, 0x79, 0x74, 0x11, 0xF0, 0x12, 0x3D, 0x31, 0xE4, 0x90, 0x45, 0x3E,
0xF0, 0x90, 0x45, 0x3E, 0xE0, 0xFF, 0xC3, 0x94, 0x06, 0x50, 0x1A, 0x12, 0x3B, 0x25, 0x90, 0x45,
0x3E, 0xE0, 0x24, 0xC4, 0xF5, 0x82, 0xE4, 0x34, 0x04, 0xF5, 0x83, 0xEF, 0xF0, 0x90, 0x45, 0x3E,
0xE0, 0x04, 0xF0, 0x80, 0xDC, 0x90, 0x04, 0x48, 0x74, 0x02, 0xF0, 0x14, 0xF0, 0x7F, 0x30, 0x12,
0x3B, 0x90, 0x90, 0x04, 0x54, 0x74, 0x02, 0xF0, 0x22, 0xE0, 0x90, 0x45, 0x44, 0xF0, 0x7F, 0xB9,
0x90, 0x04, 0x71, 0xED, 0xF0, 0xA3, 0xEB, 0xF0, 0x90, 0x45, 0x44, 0xE0, 0x90, 0x04, 0x73, 0xF0,
0x90, 0x04, 0x70, 0xEF, 0xF0, 0xE4, 0xFF, 0xFE, 0x90, 0x04, 0x70, 0xE0, 0xFD, 0x20, 0xE2, 0x0B,
0x0F, 0xBF, 0x00, 0x01, 0x0E, 0xBE, 0x07, 0xF0, 0xBF, 0xFF, 0xED, 0xBE, 0x07, 0x05, 0xBF, 0xFF,
0x02, 0xC3, 0x22, 0xD3, 0x22, 0x7B, 0x01, 0x7A, 0x45, 0x79, 0x3B, 0x7F, 0x09, 0x90, 0x04, 0x6E,
0xEF, 0xF0, 0x90, 0x04, 0x6C, 0xE0, 0x44, 0x02, 0xF0, 0xE4, 0xFF, 0xFE, 0x90, 0x04, 0x6C, 0xE0,
0xFD, 0x20, 0xE2, 0x0B, 0x0F, 0xBF, 0x00, 0x01, 0x0E, 0xBE, 0x07, 0xF0, 0xBF, 0xFF, 0xED, 0x90,
0x04, 0x6F, 0xE0, 0x12, 0x26, 0x7C, 0xBE, 0x07, 0x05, 0xBF, 0xFF, 0x02, 0xC3, 0x22, 0xD3, 0x22,
0x90, 0x04, 0x6E, 0xEF, 0xF0, 0x90, 0x04, 0x6F, 0xED, 0xF0, 0x90, 0x04, 0x6C, 0xE0, 0x44, 0x01,
0xF0, 0xE4, 0xFF, 0xFE, 0x90, 0x04, 0x6C, 0xE0, 0xFD, 0x20, 0xE2, 0x0B, 0x0F, 0xBF, 0x00, 0x01,
0x0E, 0xBE, 0x07, 0xF0, 0xBF, 0xFF, 0xED, 0xBE, 0x07, 0x05, 0xBF, 0xFF, 0x02, 0xC3, 0x22, 0xD3,
0x22, 0x90, 0x04, 0x54, 0x74, 0x01, 0xF0, 0xE4, 0xFF, 0xFE, 0x90, 0x04, 0x54, 0xE0, 0xFD, 0x30,
0xE0, 0x0B, 0x0F, 0xBF, 0x00, 0x01, 0x0E, 0xBE, 0x07, 0xF0, 0xBF, 0xFF, 0xED, 0xBE, 0x07, 0x05,
0xBF, 0xFF, 0x02, 0xC3, 0x22, 0x90, 0x06, 0x38, 0xE0, 0x44, 0x02, 0xF0, 0xE0, 0x44, 0x01, 0xF0,
0xD3, 0x22, 0xEF, 0x12, 0x28, 0x7E, 0x3D, 0x7F, 0x03, 0x3D, 0x85, 0x09, 0x3D, 0x82, 0x0A, 0x3D,
0x85, 0x0C, 0x3D, 0x88, 0x0D, 0x3D, 0x7F, 0x0E, 0x3D, 0x8B, 0x0F, 0x00, 0x00, 0x3D, 0x8E, 0x02,
0x31, 0x47, 0x02, 0x30, 0x1A, 0x02, 0x37, 0x8F, 0x02, 0x38, 0x19, 0x02, 0x38, 0xA3, 0xC3, 0x22,
0x90, 0x04, 0x1C, 0xEF, 0xF0, 0xA3, 0xED, 0xF0, 0xA3, 0xEB, 0xF0, 0x90, 0x45, 0x44, 0xE0, 0x90,
0x04, 0x1F, 0xF0, 0x90, 0x04, 0x18, 0x74, 0x03, 0xF0, 0x90, 0x04, 0x18, 0xE0, 0xFF, 0x60, 0x04,
0xEF, 0x30, 0xE2, 0xF5, 0xE4, 0x90, 0x04, 0x18, 0xF0, 0x22, 0x7F, 0xFF, 0x90, 0x04, 0x14, 0xE0,
0xFF, 0x14, 0x60, 0x0E, 0x14, 0x60, 0x0F, 0x14, 0x60, 0x10, 0x24, 0x03, 0x70, 0x10, 0x02, 0x0B,
0xBE, 0x22, 0x02, 0x0B, 0xB5, 0x22, 0x02, 0x0B, 0xAE, 0x22, 0x02, 0x0B, 0xEF, 0x22, 0x02, 0x00,
0x00, 0x22, 0xD2, 0x02, 0x7D, 0x40, 0x7F, 0x50, 0x12, 0x3D, 0x00, 0xE4, 0xFD, 0x7F, 0x50, 0x12,
0x3D, 0x00, 0x7D, 0x01, 0x7F, 0x9C, 0x12, 0x3D, 0x00, 0xE4, 0xFD, 0x7F, 0x9C, 0x12, 0x3D, 0x00,
0xA2, 0x02, 0x22, 0x90, 0x04, 0x61, 0xE0, 0x54, 0xFE, 0xF0, 0xE4, 0xFF, 0xFE, 0x90, 0x04, 0x61,
0xE0, 0xFD, 0x20, 0xE5, 0x0B, 0x0F, 0xBF, 0x00, 0x01, 0x0E, 0xBE, 0x07, 0xF0, 0xBF, 0xFF, 0xED,
0x22, 0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xC2, 0x8C, 0x90, 0x43, 0x19, 0x74, 0x01, 0xF0, 0xD0,
0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32, 0xC2, 0x8C, 0x75, 0x89, 0x01, 0x75, 0x8C, 0xF9, 0x75, 0x8A,
0x7E, 0x43, 0xA8, 0x02, 0x22, 0x44, 0x43, 0x1A, 0x04, 0x03, 0x09, 0x04, 0x00,
};

/*---------------------  Export Functions  --------------------------*/


BOOL
FIRMWAREbDownload(
     PSDevice pDevice
    )
{
    NDIS_STATUS NdisStatus;
    PBYTE       pBuffer = NULL;
    WORD        wLength;
    int         ii;

    DBG_PRT(MSG_LEVEL_DEBUG, KERN_INFO"---->Download firmware\n");
    spin_unlock_irq(&pDevice->lock);
    pBuffer = kmalloc(sizeof(abyFirmware), GFP_KERNEL);
    if (pBuffer != NULL) {

        for (ii=0;ii<sizeof(abyFirmware);ii++)
            pBuffer[ii] = abyFirmware[ii];

        for (ii=0;ii<sizeof(abyFirmware);ii+=0x400) {

            if ((sizeof(abyFirmware) - ii) < 0x400)
                wLength = (sizeof(abyFirmware) - ii);
            else
                wLength = 0x400;

            NdisStatus = CONTROLnsRequestOutAsyn(pDevice,
                                            0,
                                            0x1200+ii,
                                            0x0000,
                                            wLength,
                                            &(pBuffer[ii])
                                            );

            DBG_PRT(MSG_LEVEL_DEBUG, KERN_INFO"Download firmware...%d %zu\n", ii, sizeof(abyFirmware));
            if (NdisStatus != STATUS_SUCCESS) {
                if (pBuffer)
                    kfree(pBuffer);
                spin_lock_irq(&pDevice->lock);
                return (FALSE);
            }
        }
    }

    if (pBuffer)
        kfree(pBuffer);

    spin_lock_irq(&pDevice->lock);
    return (TRUE);
}

BOOL
FIRMWAREbBrach2Sram(
     PSDevice pDevice
    )
{
    NDIS_STATUS NdisStatus;

    DBG_PRT(MSG_LEVEL_DEBUG, KERN_INFO"---->Branch to Sram\n");

    NdisStatus = CONTROLnsRequestOut(pDevice,
                                    1,
                                    0x1200,
                                    0x0000,
                                    0,
                                    NULL
                                    );

    if (NdisStatus != STATUS_SUCCESS) {
        return (FALSE);
    } else {
        return (TRUE);
    }
}


BOOL
FIRMWAREbCheckVersion(
     PSDevice pDevice
    )
{
    NTSTATUS                ntStatus;

    ntStatus = CONTROLnsRequestIn(pDevice,
                                    MESSAGE_TYPE_READ,
                                    0,
                                    MESSAGE_REQUEST_VERSION,
                                    2,
                                    (PBYTE) &(pDevice->wFirmwareVersion));

    DBG_PRT(MSG_LEVEL_DEBUG, KERN_INFO"Firmware Version [%04x]\n", pDevice->wFirmwareVersion);
    if (ntStatus != STATUS_SUCCESS) {
        DBG_PRT(MSG_LEVEL_DEBUG, KERN_INFO"Firmware Invalid.\n");
        return FALSE;
    }
    if (pDevice->wFirmwareVersion == 0xFFFF) {
        DBG_PRT(MSG_LEVEL_DEBUG, KERN_INFO"In Loader.\n");
        return FALSE;
    }
    DBG_PRT(MSG_LEVEL_DEBUG, KERN_INFO"Firmware Version [%04x]\n", pDevice->wFirmwareVersion);
    if (pDevice->wFirmwareVersion != FIRMWARE_VERSION) {
        // branch to loader for download new firmware
        FIRMWAREbBrach2Sram(pDevice);
        return FALSE;
    }
    return TRUE;
}
