
/* Comments and changes marked with "TW" by Thomas Winischhofer <thomas@winischhofer.net> */

typedef struct _SiS300_StStruct
{
	UCHAR St_ModeID;
	USHORT St_ModeFlag;
	UCHAR St_StTableIndex;
	UCHAR St_CRT2CRTC;
	UCHAR St_ResInfo;
	UCHAR VB_StTVFlickerIndex;
	UCHAR VB_StTVEdgeIndex;
	UCHAR VB_StTVYFilterIndex;
} SiS300_StStruct;
SiS300_StStruct  SiS300_SModeIDTable[]=
{
	{0x01,0x9208,0x01,0x00,0x00,0x00,0x00,0x00},
	{0x01,0x1210,0x14,0x01,0x01,0x00,0x00,0x00},
	{0x01,0x1010,0x17,0x02,0x02,0x00,0x00,0x00},
	{0x03,0x8208,0x03,0x00,0x00,0x00,0x00,0x00},
	{0x03,0x0210,0x16,0x01,0x01,0x00,0x00,0x00},
	{0x03,0x0010,0x18,0x02,0x02,0x00,0x00,0x00},
	{0x05,0x9209,0x05,0x00,0x00,0x00,0x00,0x00},
	{0x06,0x8209,0x06,0x00,0x00,0x00,0x00,0x00},
	{0x07,0x0000,0x07,0x03,0x03,0x00,0x00,0x00},
	{0x07,0x0000,0x19,0x02,0x02,0x00,0x00,0x00},
	{0x0d,0x920a,0x0d,0x00,0x00,0x00,0x00,0x00},
	{0x0e,0x820a,0x0e,0x00,0x00,0x00,0x00,0x00},
	{0x0f,0x0202,0x11,0x01,0x01,0x00,0x00,0x00},
	{0x10,0x0212,0x12,0x01,0x01,0x00,0x00,0x00},
	{0x11,0x0212,0x1a,0x04,0x04,0x00,0x00,0x00},
	{0x12,0x0212,0x1b,0x04,0x04,0x00,0x00,0x00},
	{0x13,0x021b,0x1c,0x00,0x00,0x00,0x00,0x00},
	/* {0x12,0x0210,0x18,0x00,0x00,0x00,0x00,0x00}, */  /* <--- Different in BIOS */
	{0x12,0x0010,0x18,0x02,0x02,0x00,0x00,0x00},
	{0x12,0x0210,0x18,0x01,0x01,0x00,0x00,0x00},
	{0xff,0,0,0,0,0,0,0}
};

typedef struct _SiS300_StandTableStruct
{
	UCHAR CRT_COLS;
	UCHAR ROWS;
	UCHAR CHAR_HEIGHT;
	USHORT CRT_LEN;
	UCHAR SR[4];
	UCHAR MISC;
	UCHAR CRTC[0x19];
	UCHAR ATTR[0x14];
	UCHAR GRC[9];
} SiS300_StandTableStruct;

SiS300_StandTableStruct  SiS300_StandTable[]=
{ /* TW: @ 0x38d4 in BIOS */
 {0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff} },
 {0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff} },
 {0x50,0x18,0x08,0x4000,
  {0x01,0x01,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xc2,
   0xff},
  {0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x01,0x00,0x01,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0x00,
   0xff} },
 {0x50,0x18,0x0e,0x1000,
  {0x00,0x03,0x00,0x03},
  0xa6,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0d,0x63,0xba,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff} },
/* MDA_DAC*/
 {0x00,0x00,0x00,0x0000,
  {0x00,0x00,0x00,0x15},
  0x15,
  {0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x00,0x00,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15},
  {0x15,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f} },
/* CGA_DAC*/
 {0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x00},
  0x10,
  {0x04,0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x10,
   0x04},
  {0x14,0x01,0x11,0x09,0x15,0x00,0x10,0x04,
   0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,0x2e,
   0x3e,0x2b,0x3b,0x2f},
  {0x3f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f} },
/* EGA_DAC*/
 {0x00,0x10,0x04,0x0114,
  {0x11,0x05,0x15,0x20},
  0x30,
  {0x24,0x34,0x21,0x31,0x25,0x35,0x08,0x18,
   0x0c,0x1c,0x09,0x19,0x0d,0x1d,0x28,0x38,
   0x2c,0x3c,0x29,0x39,0x2d,0x3d,0x02,0x12,
   0x06},
  {0x16,0x03,0x13,0x07,0x17,0x22,0x32,0x26,
   0x36,0x23,0x33,0x27,0x37,0x0a,0x1a,0x0e,
   0x1e,0x0b,0x1b,0x0f},
  {0x1f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f} },
/* VGA_DAC*/
 {0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x2a},
  0x3a,
  {0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x05,
   0x08,0x0b,0x0e,0x11,0x14,0x18,0x1c,0x20,
   0x24,0x28,0x2d,0x32,0x38,0x3f,0x00,0x10,
   0x1f},
  {0x2f,0x3f,0x1f,0x27,0x2f,0x37,0x3f,0x2d,
   0x31,0x36,0x3a,0x3f,0x00,0x07,0x0e,0x15,
   0x1c,0x0e,0x11,0x15},
  {0x18,0x1c,0x14,0x16,0x18,0x1a,0x1c,0x00,
   0x04} },
 {0x08,0x0c,0x10,0x0a08,
  {0x0c,0x0e,0x10,0x0b},
  0x0c,
  {0x0d,0x0f,0x10,0x10,0x01,0x08,0x00,0x00,
   0x00,0x00,0x01,0x00,0x02,0x02,0x01,0x00,
   0x04,0x04,0x01,0x00,0x05,0x02,0x05,0x00,
   0x06},
  {0x01,0x06,0x05,0x06,0x00,0x08,0x01,0x08,
   0x00,0x07,0x02,0x07,0x06,0x07,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00} },
 {0x28,0x18,0x08,0x2000,
  {0x09,0x0f,0x00,0x06},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0x80,0xbf,0x1f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff} },
 {0x50,0x18,0x08,0x4000,
  {0x01,0x0f,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff} },
 {0x00,0x00,0x00,0x0000,	/* TW: Standtable for VGA modes */
  {0x01,0x0f,0x00,0x0e},	/*    (identical to BIOS) */
  0x23,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x40,0xe7,0x04,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x01,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff} },
 {0x4a,0x36,0x00,0x00c0,
  {0x00,0x00,0x00,0x00},
  0x00,
  {0x00,0x00,0x00,0x00,0x00,0x00,0x66,0x3a,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x1a,0x00,0x57,0x39,0x00,0xc0,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00} },
 {0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa2,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0f,0x63,0xba,0xe3,
   0xff},
  {0x00,0x08,0x00,0x00,0x18,0x18,0x00,0x00,
   0x00,0x08,0x00,0x00,0x00,0x18,0x00,0x00,
   0x0b,0x00,0x05,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,
   0xff} },
 {0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0f,0x63,0xba,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff} },
 {0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x28,0x18,0x10,0x0800,
  {0x08,0x03,0x00,0x02},
  0x67,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x67,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x66,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x0f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff} },
 {0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x00,0xe7,0x04,0xc3,
   0xff},
  {0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x01,
   0xff} },
 {0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x00,0xe7,0x04,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff} },
 {0x28,0x18,0x08,0x2000,
  {0x01,0x0f,0x00,0x0e},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x40,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x41,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff} }
};

typedef struct _SiS300_ExtStruct
{
	UCHAR Ext_ModeID;
	USHORT Ext_ModeFlag;
	USHORT Ext_ModeInfo;
	USHORT Ext_Point;
	USHORT Ext_VESAID;
	UCHAR Ext_VESAMEMSize;
	UCHAR Ext_RESINFO;
	UCHAR VB_ExtTVFlickerIndex;
	UCHAR VB_ExtTVEdgeIndex;
	UCHAR VB_ExtTVYFilterIndex;
	UCHAR REFindex;
} SiS300_ExtStruct;

SiS300_ExtStruct  SiS300_EModeIDTable[]=
{ /* TW: Table is identical to BIOS */		/* TW: BIOS offset to Ext2Struct: */
 {0x6a,0x2212,0x47,0x3563,0x0102,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */
 {0x2e,0x0a1b,0x36,0x3539,0x0101,0x08,0x06,0x00,0x00,0x00,0x08},  /* 37c3 */ /* 8bpp bug? */
 /* {0x2e,0x021b,0x36,0x3539,0x0101,0x08,0x06,0x00,0x00,0x00,0x08},  */ /* 37c3 */
 {0x2f,0x021b,0x35,0x3532,0x0100,0x08,0x05,0x00,0x00,0x00,0x10},  /* 37bc */
 {0x30,0x2a1b,0x47,0x3563,0x0103,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */ /* 8bpp bug? */
 /* {0x30,0x221b,0x47,0x3563,0x0103,0x08,0x07,0x00,0x00,0x00,0x00}, */ /* 37ed */
 {0x31,0x0a1b,0xad,0x3630,0x0000,0x08,0x0c,0x00,0x00,0x00,0x11},  /* 38ba */
 {0x32,0x2a1b,0xae,0x3637,0x0000,0x08,0x0d,0x00,0x00,0x00,0x12},  /* 38c1 */
 {0x33,0x0a1d,0xad,0x3630,0x0000,0x08,0x0c,0x00,0x00,0x00,0x11},  /* 38ba */
 {0x34,0x2a1d,0xae,0x3637,0x0000,0x08,0x0d,0x00,0x00,0x00,0x12},  /* 38c1 */
 {0x35,0x0a1f,0xad,0x3630,0x0000,0x08,0x0c,0x00,0x00,0x00,0x11},  /* 38ba */
 {0x36,0x2a1f,0xae,0x3637,0x0000,0x08,0x0d,0x00,0x00,0x00,0x12},  /* 38c1 */
 {0x37,0x0212,0x58,0x358d,0x0104,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */
 {0x38,0x0a1b,0x58,0x358d,0x0105,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */ /* 8bpp bug? */
 /* {0x38,0x021b,0x58,0x358d,0x0105,0x08,0x08,0x00,0x00,0x00,0x13}, */ /* 3817 */
 {0x3a,0x0e3b,0x69,0x35be,0x0107,0x08,0x09,0x00,0x00,0x00,0x1a},  /* 3848 */ /* 8bpp bug? */
 /* {0x3a,0x063b,0x69,0x35be,0x0107,0x08,0x09,0x00,0x00,0x00,0x1a}, */ /* 3848 */
 {0x3c,0x063b,0x7a,0x35d4,0x0130,0x08,0x0a,0x00,0x00,0x00,0x1e},  /* 385e */
 {0x3d,0x067d,0x7a,0x35d4,0x0131,0x08,0x0a,0x00,0x00,0x00,0x1e},  /* 385e */
 {0x40,0x921c,0x00,0x3516,0x010d,0x08,0x00,0x00,0x00,0x00,0x23},  /* 37a0 */
 {0x41,0x921d,0x00,0x3516,0x010e,0x08,0x00,0x00,0x00,0x00,0x23},  /* 37a0 */
 {0x43,0x0a1c,0x36,0x3539,0x0110,0x08,0x06,0x00,0x00,0x00,0x08},  /* 37c3 */
 {0x44,0x0a1d,0x36,0x3539,0x0111,0x08,0x06,0x00,0x00,0x00,0x08},  /* 37c3 */
 {0x46,0x2a1c,0x47,0x3563,0x0113,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */
 {0x47,0x2a1d,0x47,0x3563,0x0114,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */
 {0x49,0x0a3c,0x58,0x358d,0x0116,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */
 {0x4a,0x0a3d,0x58,0x358d,0x0117,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */
 {0x4c,0x0e7c,0x69,0x35be,0x0119,0x08,0x09,0x00,0x00,0x00,0x1a},  /* 3848 */
 {0x4d,0x0e7d,0x69,0x35be,0x011a,0x08,0x09,0x00,0x00,0x00,0x1a},  /* 3848 */
 {0x50,0x921b,0x01,0x351d,0x0132,0x08,0x01,0x00,0x00,0x00,0x24},  /* 37a7 */
 {0x51,0x921b,0x13,0x3524,0x0133,0x08,0x03,0x00,0x00,0x00,0x25},  /* 37ae */
 {0x52,0x921b,0x24,0x352b,0x0134,0x08,0x04,0x00,0x00,0x00,0x26},  /* 37b5 */
 {0x56,0x921d,0x01,0x351d,0x0135,0x08,0x01,0x00,0x00,0x00,0x24},  /* 37a7 */
 {0x57,0x921d,0x13,0x3524,0x0136,0x08,0x03,0x00,0x00,0x00,0x25},  /* 37ae */
 {0x58,0x921d,0x24,0x352b,0x0137,0x08,0x04,0x00,0x00,0x00,0x26},  /* 37b5 */
 {0x59,0x921b,0x00,0x3516,0x0138,0x08,0x00,0x00,0x00,0x00,0x23},  /* 37a0 */
 {0x5d,0x021d,0x35,0x3532,0x0139,0x08,0x05,0x00,0x00,0x00,0x10},  /* 37bc */
 {0x62,0x0a3f,0x36,0x3539,0x013a,0x08,0x06,0x00,0x00,0x00,0x08},  /* 37c3 */
 {0x63,0x2a3f,0x47,0x3563,0x013b,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */
 {0x64,0x0a7f,0x58,0x358d,0x013c,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */
 {0x65,0x0eff,0x69,0x35be,0x013d,0x08,0x09,0x00,0x00,0x00,0x1a},  /* 3848 */
 {0x66,0x06ff,0x7a,0x35d4,0x013e,0x08,0x0a,0x00,0x00,0x00,0x1e},  /* 385e */
 {0x68,0x067b,0x8b,0x35ef,0x013f,0x08,0x0b,0x00,0x00,0x00,0x27},  /* 3879 */
 {0x69,0x06fd,0x8b,0x35ef,0x0140,0x08,0x0b,0x00,0x00,0x00,0x27},  /* 3879 */
 {0x6b,0x07ff,0x8b,0x35ef,0x0000,0x10,0x0b,0x00,0x00,0x00,0x27},  /* 3879 */
 {0x6c,0x067b,0x9c,0x35f6,0x0000,0x08,0x0c,0x00,0x00,0x00,0x28},  /* 3880 */
 {0x6d,0x06fd,0x9c,0x35f6,0x0000,0x10,0x0c,0x00,0x00,0x00,0x28},  /* 3880 */
 {0x6e,0x0e3b,0x6f,0x35b2,0x0000,0x08,0x0e,0x00,0x00,0x00,0x29},  /* 383c */
 {0x6f,0x0e7d,0x6f,0x35b2,0x0000,0x08,0x0e,0x00,0x00,0x00,0x29},  /* 383c */
 {0x7b,0x0eff,0x6f,0x35b2,0x0000,0x08,0x0e,0x00,0x00,0x00,0x29},  /* 383c */
 {0x7c,0x221b,0xb3,0x363e,0x0000,0x08,0x0f,0x00,0x00,0x00,0x2b},  /* 38c8 */
 {0x7d,0x221d,0xb3,0x363e,0x0000,0x08,0x0f,0x00,0x00,0x00,0x2b},  /* 38c8 */
 {0x7e,0x223f,0xb3,0x363e,0x0000,0x08,0x0f,0x00,0x00,0x00,0x2b},  /* 38c8 */
 {0xff,0x0000,0x00,0x0000,0xffff,0x00,0x00,0x00,0x00,0x00,0x00}
};

typedef struct _SiS300_Ext2Struct
{
	USHORT Ext_InfoFlag;
	UCHAR Ext_CRT1CRTC;  /* TW: Index in SiS300_CRT1Table */
	UCHAR Ext_CRTVCLK;
	UCHAR Ext_CRT2CRTC;  /* TW: Index in LCD Paneltype arrays (&3f) */
	UCHAR  ModeID;
	USHORT XRes;
	USHORT YRes;
	USHORT ROM_OFFSET;
} SiS300_Ext2Struct;

SiS300_Ext2Struct  SiS300_RefIndex[]=
{ /* TW: Don't ever insert anything here, table is indexed */
 {0x085f,0x0d,0x03,0x05,0x6a, 800, 600,0x3563},
 {0x0467,0x0e,0x44,0x05,0x6a, 800, 600,0x3568},
 {0x0067,0x4f,0x07,0x48,0x6a, 800, 600,0x356d},
 {0x0067,0x10,0x06,0x8b,0x6a, 800, 600,0x3572},
 {0x0147,0x11,0x08,0x00,0x6a, 800, 600,0x3577},
 {0x0147,0x12,0x0c,0x00,0x6a, 800, 600,0x357c},
 {0x0047,0x51,0x4e,0x00,0x6a, 800, 600,0x3581},
 {0x0047,0x11,0x13,0x00,0x6a, 800, 600,0x3586},
 {0xc85f,0x05,0x00,0x04,0x2e, 640, 480,0x3539},
 {0xc067,0x06,0x02,0x04,0x2e, 640, 480,0x353e},
 {0xc067,0x07,0x02,0x47,0x2e, 640, 480,0x3543},
 {0xc067,0x08,0x03,0x8a,0x2e, 640, 480,0x3548},
 {0xc047,0x09,0x05,0x00,0x2e, 640, 480,0x354d},
 {0xc047,0x0a,0x08,0x00,0x2e, 640, 480,0x3552},
 {0xc047,0x0b,0x0a,0x00,0x2e, 640, 480,0x3557},
 {0xc047,0x0c,0x10,0x00,0x2e, 640, 480,0x355c},
 {0x487f,0x04,0x00,0x00,0x2f, 640, 400,0x3532},
 {0xc00f,0x31,0x01,0x06,0x31,2048,1536,0x3630},
 {0x000f,0x32,0x03,0x06,0x32, 720, 480,0x3637},
 {0x0187,0x15,0x05,0x00,0x37,1024, 768,0x358d},
 /* {0xc877,0x16,0x09,0x06,0x37,1024, 768,0x3592}, <--- different in BIOS */
 {0xc077,0x16,0x09,0x06,0x37,1024, 768,0x3592},
 {0xc067,0x97,0x0b,0x49,0x37,1024, 768,0x3597},
 {0x0267,0x18,0x0d,0x00,0x37,1024, 768,0x359c},
 {0x0047,0x59,0x11,0x8c,0x37,1024, 768,0x35a1},
 {0x0047,0x1a,0x52,0x00,0x37,1024, 768,0x35a6},
 {0x0047,0x5b,0x16,0x00,0x37,1024, 768,0x35ab},
 {0x0387,0x5c,0x4d,0x00,0x3a,1280,1024,0x35be},
 {0x0077,0x1d,0x14,0x07,0x3a,1280,1024,0x35c3},
 {0x0047,0x1e,0x17,0x00,0x3a,1280,1024,0x35c8},
 {0x0007,0x1f,0x98,0x00,0x3a,1280,1024,0x35cd},
 {0x0007,0x60,0x59,0x00,0x3c,1600,1200,0x35d4},
 {0x0007,0x21,0x5a,0x00,0x3c,1600,1200,0x35d9},
 {0x0007,0x22,0x1b,0x00,0x3c,1600,1200,0x35de},
 {0x0007,0x63,0x1d,0x00,0x3c,1600,1200,0x35e3},
 {0x0007,0x24,0x1e,0x00,0x3c,1600,1200,0x35e8},
 /* TW: No 1600x1200 LCD mode? */
 {0x407f,0x00,0x00,0x00,0x40, 320, 200,0x3516},
 {0xc07f,0x01,0x00,0x04,0x50, 320, 240,0x351d},
 {0x0077,0x02,0x04,0x05,0x51, 400, 300,0x3524},
 {0xc077,0x03,0x09,0x06,0x52, 512, 384,0x352b},
 {0x8207,0x25,0x1f,0x00,0x68,1920,1440,0x35ef},
 {0x0007,0x26,0x20,0x00,0x6c,2048,1536,0x35f6},
 {0x0027,0x27,0x14,0x08,0x6e, 720, 576,0x35b2},
 {0x0027,0x27,0x14,0x08,0x6e, 720, 576,0x35b7},
 /* TW: 1280x960 identical to BIOS */
 /* TW:              v--- I doubt this - no CRT2? */
 {0x00df,0x33,0x28,0x00,0x7c,1280, 960,0x363e},
 {0xc05f,0x34,0x28,0x00,0x7c,1280, 960,0x3643},
#if 0
 /* TW: The LCD modes for 1280x960 are missing! */
 /*     Values guessed! */
 {0x00a7,0x33,0x28,0x08,0x7c,1280, 960,0xDEAD},  /* Do we need an interlace mode? */
 {0xc027,0x34,0x28,0x08,0x7c,1280, 960,0xBEEF},
 /* TW:    |         |---- This is either 0x07 or 0x08  */
#endif /*  +---- Same as for the non-interlace mode */
 {0xffff,0,0,0,0,0,0,0}
};

/* TW: These entries are contained in the BIOS but missing in table above: (resolution unknown) */
#if 0
 /* at 0x3887: (not indexed by EModeIDTable in BIOS either) */
 {0x0057,0x28,0x27,0x08,... }
 {0x0047,0x29,0x06,0x08,... }
 {0x0047,0x2a,0x08,0x08,... } /* table end */
 /* at 0x3898: (not indexed by EModeIDTable in BIOS either)*/
 {0x0057,0x2b,0x09,0x09,... }
 {0x0047,0x2c,0x0d,0x09,... }
 {0x0047,0x2d,0x11,0x09,... } /* table end */
 /* at 0x38a9: (not indexed by EModeIDTable in BIOS either) */
 {0x0057,0x2e,0x14,0x0a,... }
 {0x0047,0x2f,0x17,0x0a,... }
 {0x0047,0x30,0x18,0x0a,... } /* table end */
#endif

/*add for 300 oem util*/
typedef struct _SiS_VBModeIDTableStruct
{
	UCHAR  ModeID;
	UCHAR  VB_TVDelayIndex;
	UCHAR  VB_TVFlickerIndex;
	UCHAR  VB_TVPhaseIndex;
	UCHAR  VB_TVYFilterIndex;
	UCHAR  VB_LCDDelayIndex;
	UCHAR  _VB_LCDHIndex;
	UCHAR  _VB_LCDVIndex;
}SiS_VBModeIDTableStruct;

SiS_VBModeIDTableStruct  SiS300_VBModeIDTable[]=
{
	{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01},
	{0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x02},
	{0x03,0x00,0x00,0x00,0x02,0x00,0x02,0x00},
	{0x03,0x00,0x00,0x00,0x02,0x00,0x02,0x01},
	{0x03,0x00,0x00,0x00,0x03,0x00,0x03,0x02},
	{0x05,0x00,0x00,0x01,0x04,0x00,0x00,0x00},
	{0x06,0x00,0x00,0x01,0x05,0x00,0x02,0x00},
	{0x07,0x00,0x00,0x00,0x03,0x00,0x03,0x01},
	{0x07,0x00,0x00,0x00,0x03,0x00,0x03,0x02},
	{0x0d,0x00,0x00,0x01,0x04,0x00,0x00,0x00},
	{0x0e,0x00,0x00,0x01,0x05,0x00,0x02,0x00},
	{0x0f,0x00,0x00,0x01,0x05,0x00,0x02,0x01},
	{0x10,0x00,0x00,0x01,0x05,0x00,0x02,0x01},
	{0x11,0x00,0x00,0x01,0x05,0x00,0x02,0x03},
	{0x12,0x00,0x00,0x01,0x05,0x00,0x02,0x03},
	{0x13,0x00,0x00,0x01,0x04,0x00,0x04,0x00},
	{0x6a,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x2e,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x2f,0x00,0x00,0x01,0x05,0x00,0x06,0x06},
	{0x30,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x31,0x00,0x00,0x01,0x06,0x00,0x00,0x00},
	{0x32,0x00,0x00,0x01,0x06,0x00,0x00,0x00},
	{0x37,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x38,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x3a,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x40,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x41,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x43,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x44,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x46,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x47,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x49,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x4a,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x4c,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x4d,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x50,0x00,0x00,0x01,0x04,0x00,0x05,0x07},
	{0x51,0x00,0x00,0x01,0x07,0x00,0x07,0x09},
	{0x52,0x00,0x00,0x01,0x00,0x00,0x09,0x0b},
	{0x56,0x00,0x00,0x01,0x04,0x00,0x05,0x07},
	{0x57,0x00,0x00,0x01,0x07,0x00,0x07,0x09},
	{0x58,0x00,0x00,0x01,0x00,0x00,0x09,0x0b},
	{0x59,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x5d,0x00,0x00,0x01,0x07,0x00,0x06,0x06},
	{0x62,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x63,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x64,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x65,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x6e,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x6f,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x7b,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d}
};
/*end*/

/* TW: The following table is (now) identical to BIOS */
typedef struct _SiS300_CRT1TableStruct
{
	UCHAR CR[17];
} SiS300_CRT1TableStruct;

SiS300_CRT1TableStruct  SiS300_CRT1Table[]=
{ /* at 0x4014 in BIOS */
 {{0x2d,0x27,0x28,0x90,/*0x2b*/ 0x2c,0x80,0xbf,0x1f,  /* <--- was different to BIOS */
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x00,
  0x00}},
 {{0x2d,0x27,0x28,0x90,/*0x2b*/ 0x2c,0x80,0x0b,0x3e,  /* <--- was different to BIOS */
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x00,
  0x00}},
 {{0x3d,0x31,0x31,0x81,0x37,0x1f,0x72,0xf0,
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x05,
  0x01}},
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
  0x01}},
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x05,
  0x00}},
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
  0x00}},
 {{0x63,0x4f,0x50,0x86,0x56,0x9b,0x06,0x3e,
  0xe8,0x8b,0xdf,0xe7,0xff,0x10,0x00,0x01,
  0x00}},
 {{0x64,0x4f,0x4f,0x88,0x55,0x9d,0xf2,0x1f,
  0xe0,0x83,0xdf,0xdf,0xf3,0x10,0x00,0x01,
  0x00}},
 {{0x63,0x4f,0x4f,0x87,0x5a,0x81,0xfb,0x1f,
  0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x05,
  0x00}},
 {{0x66,0x4f,0x4f,0x86,0x56,0x9e,0x03,0x3e,
  0xe4,0x87,0xdf,0xdf,0x04,0x00,0x00,0x01,
  0x00}},
 {{0x6c,0x4f,0x4f,0x83,0x59,0x9e,0x00,0x3e,    /* 10 */
  0xe5,0x8d,0xdf,0xdf,0x01,0x00,0x00,0x01,
  0x00}},
 {{0x63,0x4f,0x4f,0x87,0x56,0x9d,0xfb,0x1f,
  0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x01,
  0x00}},
 {{0x65,0x4f,0x4f,0x89,0x57,0x9f,0xfb,0x1f,
  0xe6,0x8a,0xe5,0xe5,0xfc,0x00,0x00,0x01,
  0x00}},
 {{0x7b,0x63,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
  0x58,0x8a,0x57,0x57,0x70,0x20,0x00,0x05,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xf0,
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x06,
  0x01}},
 {{0x7d,0x63,0x63,0x81,0x6e,0x1d,0x98,0xf0,
  0x7c,0x82,0x57,0x57,0x99,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xf0,
  0x58,0x8b,0x57,0x57,0x70,0x20,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6b,0x13,0x75,0xf0,
  0x58,0x8b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x8c,0x63,0x63,0x87,0x72,0x16,0x7e,0xf0,
  0x59,0x8d,0x57,0x57,0x7f,0x00,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6c,0x14,0x75,0xe0,
  0x58,0x0b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6c,0x14,0x75,0xe0,   /* 20 */
  0x58,0x0b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x99,0x7f,0x7f,0x9d,0x84,0x1a,0x96,0x1f,
  0x7f,0x83,0x7f,0x7f,0x97,0x10,0x00,0x02,
  0x00}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}},
 {{0xa1,0x7f,0x7f,0x85,0x86,0x97,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf5,
  0x00,0x83,0xff,0xff,0x1f,0x10,0x00,0x02,
  0x01}},
 {{0xa7,0x7f,0x7f,0x8b,0x89,0x95,0x26,0xf5,
  0x00,0x83,0xff,0xff,0x27,0x10,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x83,0x93,0x1e,0xf5,
  0x00,0x84,0xff,0xff,0x1f,0x10,0x00,0x02,
  0x01}},
 {{0xa2,0x7f,0x7f,0x86,0x84,0x94,0x37,0xf5,
  0x0b,0x82,0xff,0xff,0x38,0x10,0x00,0x02,
  0x01}},
 {{0xcf,0x9f,0x9f,0x93,0xb2,0x01,0x14,0xba,
  0x00,0x83,0xff,0xff,0x15,0x00,0x00,0x03,
  0x00}},
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0x5a,
  0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0x5a,  /* 30 */
  0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
  0x01}},
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0x5a,
  0x00,0x83,0xff,0xff,0x2f,0x09,0x00,0x07,
  0x01}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,  /* 36: 1600x1200x85Hz */
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x3f,0xef,0xef,0x83,0xfd,0x1a,0xda,0x1f,  /* 37: 1920x1440x60Hz */
  0xa0,0x84,0x9f,0x9f,0xdb,0x1f,0x01,0x01,
  0x00}},  /* TW: TEST, should be 0x30? */
 {{0x55,0xff,0xff,0x99,0x0d,0x0c,0x3e,0xba,
  0x00,0x84,0xff,0xff,0x3f,0x0f,0x41,0x05,
  0x00}},
 {{0xdc,0x9f,0x9f,0x00,0xab,0x19,0xe6,0xef,
  0xc0,0xc3,0xbf,0xbf,0xe7,0x10,0x00,0x07,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xba,
  0x27,0x8b,0xdf,0xdf,0x73,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xba,
  0x26,0x89,0xdf,0xdf,0x6f,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x82,0x6b,0x13,0x75,0xba,
  0x29,0x8c,0xdf,0xdf,0x75,0x00,0x00,0x06,
  0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf1,
  0xaf,0x85,0x3f,0x3f,0x25,0x30,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf1,
  0xad,0x81,0x3f,0x3f,0x1f,0x30,0x00,0x02,
  0x01}},
 {{0xa7,0x7f,0x7f,0x88,0x89,0x15,0x26,0xf1,
  0xb1,0x85,0x3f,0x3f,0x27,0x30,0x00,0x02,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0xc4,
  0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0xd4,
  0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
  0x01}},
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0xd4,
  0x7d,0x81,0xcf,0xcf,0x2f,0x21,0x00,0x07,
  0x01}},
 {{0x6b,0x59,0x59,0x8f,0x5e,0x8c,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
  0x00}},
 {{0x7b,0x59,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
  0x58,0x8a,0x3f,0x57,0x70,0x20,0x00,0x05,
  0x01}},
 {{0x86,0x6a,0x6a,0x8a,0x74,0x06,0x8c,0x15,	/* 1280x960 */
  0x4f,0x83,0xef,0xef,0x8d,0x30,0x00,0x02,
  0x00}},
 {{0x81,0x6a,0x6a,0x85,0x70,0x00,0x0f,0x3e,	/* 1280x960 */
  0xeb,0x8e,0xdf,0xdf,0x10,0x00,0x00,0x02,
  0x00}}
  /* end @ 0x4399 */
};

typedef struct _SiS300_MCLKDataStruct
{
	UCHAR SR28,SR29,SR2A;
	USHORT CLOCK;
} SiS300_MCLKDataStruct;

SiS300_MCLKDataStruct  SiS300_MCLKData[]=
{ /* TW: at 0x54 in BIOS */
	{ 0x5a,0x64,0x80, 66},
	{ 0xb3,0x45,0x80, 83},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x22,0x80,133},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100}
};

typedef struct _SiS300_ECLKDataStruct
{
	UCHAR SR2E,SR2F,SR30;
	USHORT CLOCK;
} SiS300_ECLKDataStruct;

SiS300_ECLKDataStruct  SiS300_ECLKData[]=
{ /* TW: at 0x7c in BIOS */
	{ 0x54,0x43,0x80,100},
	{ 0x53,0x43,0x80,100},
	{ 0x55,0x43,0x80,100},
	{ 0x52,0x43,0x80,100},
	{ 0x3f,0x42,0x80,100},
	{ 0x54,0x43,0x80,100},
	{ 0x54,0x43,0x80,100},
	{ 0x54,0x43,0x80,100}
};

typedef struct _SiS300_VCLKDataStruct
{
	UCHAR SR2B,SR2C;
	USHORT CLOCK;
} SiS300_VCLKDataStruct;

SiS300_VCLKDataStruct  SiS300_VCLKData[]=
{ /* TW: At 0x484e in BIOS */
	{ 0x1b,0xe1, 25},
	{ 0x4e,0xe4, 28},
	{ 0x57,0xe4, 32},
	{ 0xc3,0xc8, 36},
	{ 0x42,0xc3, 40},
	{ 0x5d,0xc4, 45},
	{ 0x52,0x65, 50},
	{ 0x53,0x65, 50},
	{ 0x6d,0x66, 56},
	{ 0x5a,0x64, 65},
	{ 0x46,0x44, 68},
	{ 0x3e,0x43, 75},
	{ 0x6d,0x46, 76},
	{ 0x41,0x43, 79},
	{ 0x31,0x42, 79},
	{ 0x46,0x25, 85},
	{ 0x78,0x29, 87},
	{ 0x62,0x44, 95},
	{ 0x2b,0x22,105},
	{ 0x49,0x24,106},
	{ 0xc3,0x28,108},
	{ 0x3c,0x23,109},
	{ 0xf7,0x2c,132},
	{ 0xd4,0x28,136},
	{ 0x41,0x05,158},
	{ 0x43,0x05,162},
	{ 0xe1,0x0f,175},
	{ 0xfc,0x12,189},
	{ 0xde,0x26,194},
	{ 0x54,0x05,203},
	{ 0x3f,0x03,230},
	{ 0x30,0x02,234},  /* 0x1f - 1920x1440 */
	{ 0x24,0x01,266},  /* 0x20 - 2048x1536 */
	{ 0x52,0x2a, 54},
	{ 0x52,0x6a, 27},
	{ 0x62,0x24, 70},
	{ 0x62,0x64, 70},
	{ 0xa8,0x4c, 30},
	{ 0x20,0x26, 33},
	{ 0x31,0xc2, 39},
	{ 0xbf,0xc8, 35},  /* 0x28 - 1280x960 ??? that can't be right */
	{ 0x60,0x36, 30},
	{ 0x40,0x4a, 28},
	{ 0x9f,0x46, 44},
	{ 0x97,0x2c, 26},
	{ 0x44,0xe4, 25},
	{ 0x7e,0x32, 47},
	{ 0x8a,0x24, 31},
	{ 0x97,0x2c, 26},
	{ 0xce,0x3c, 39},
	{ 0x52,0x4a, 36},
	{ 0x34,0x61, 95},
	{ 0x78,0x27,108},
	{ 0xce,0x25,189},  /* TW: This was missing */
	{ 0xff,0x1b,6625}
};

/* TW: at 0x377d in BIOS */
UCHAR SiS300_ScreenOffset[]=
{
	0x14,0x19,0x20,0x28,0x32,0x40,0x50,
        0x64,0x78,0x80,0x2d,0x35,0xff
};

typedef struct _SiS300_StResInfoStruct
{
	USHORT HTotal;
	USHORT VTotal;
} SiS300_StResInfoStruct;

SiS300_StResInfoStruct  SiS300_StResInfo[]=
{
	{ 640,400},
	{ 640,350},
	{ 720,400},
	{ 720,350},
	{ 640,480}
};

typedef struct _SiS300_ModeResInfoStruct
{
	USHORT HTotal;
	USHORT VTotal;
	UCHAR  XChar;
	UCHAR  YChar;
} SiS300_ModeResInfoStruct;

SiS300_ModeResInfoStruct  SiS300_ModeResInfo[]=
{ /* TW: At 0x5957 in BIOS */
	{  320, 200, 8, 8},
	{  320, 240, 8, 8},
	{  320, 400, 8, 8},
	{  400, 300, 8, 8},
	{  512, 384, 8, 8},
	{  640, 400, 8,16},
	{  640, 480, 8,16},
	{  800, 600, 8,16},
	{ 1024, 768, 8,16},
	{ 1280,1024, 8,16},
	{ 1600,1200, 8,16},
	{ 1920,1440, 8,16},
	{ 2048,1536, 8,16},   /* TW: this was missing here, wasn't it? (not in BIOS) */
	{  720, 480, 8,16},   /*     (otherwise RESINFO index is wrong!) */
	{  720, 576, 8,16},
	{ 1280, 960, 8,16}
};

UCHAR SiS300_OutputSelect =0x40;
UCHAR SiS300_SoftSetting = 30;
UCHAR SiS300_SR07=0x10;
UCHAR SiS300_SR15[8][4]={
	{0x1,0x9,0xa3,0x0},
	{0x43,0x43,0x43,0x0},
	{0x1e,0x1e,0x1e,0x0},
	{0x2a,0x2a,0x2a,0x0},
	{0x6,0x6,0x6,0x0},
	{0x0,0x0,0x0,0x0},
	{0x0,0x0,0x0,0x0},
	{0x0,0x0,0x0,0x0}
};
UCHAR SiS300_SR1F=0x0;
UCHAR SiS300_SR21=0x16;
UCHAR SiS300_SR22=0xb2;
UCHAR SiS300_SR23=0xf6;
UCHAR SiS300_SR24=0xd;
UCHAR SiS300_SR25[]={0x0,0x0};
UCHAR SiS300_SR31=0x0;
UCHAR SiS300_SR32=0x11;
UCHAR SiS300_SR33=0x0;
UCHAR SiS300_CRT2Data_1_2 = 0x40;
UCHAR SiS300_CRT2Data_4_D = 0x0;
UCHAR SiS300_CRT2Data_4_E = 0x0;
UCHAR SiS300_CRT2Data_4_10 = 0x80;
USHORT SiS300_RGBSenseData = 0xd1;
USHORT SiS300_VideoSenseData = 0xb3;
USHORT SiS300_YCSenseData = 0xb9;
USHORT SiS300_RGBSenseData2 = 0x0190;     /*301b*/
USHORT SiS300_VideoSenseData2 = 0x0174;
USHORT SiS300_YCSenseData2 = 0x016b;

UCHAR SiS300_CR40[5][4];
UCHAR SiS300_CR49[2];
UCHAR SiS300_NTSCPhase[]  = {0x21,0xed,0x8a,0x08};
UCHAR SiS300_PALPhase[]   = {0x2a,0x05,0xd3,0x00};
UCHAR SiS300_NTSCPhase2[] = {0x21,0xF0,0x7B,0xD6};/*301b*/
UCHAR SiS300_PALPhase2[]  = {0x2a,0x09,0x86,0xe9};
UCHAR SiS300_PALMPhase[]  = {0x21,0xE4,0x2E,0x9B};   /*palmn*/
UCHAR SiS300_PALNPhase[]  = {0x21,0xF4,0x3E,0xBA};

typedef struct _SiS300_PanelDelayTblStruct
{
	UCHAR timer[2];
} SiS300_PanelDelayTblStruct;

SiS300_PanelDelayTblStruct SiS300_PanelDelayTbl[]=
{
	{{0x05,0xaa}},
	{{0x05,0x14}},
	{{0x05,0x36}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x90}},
	{{0x05,0x90}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x64}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}}
};

typedef struct _SiS300_LCDDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS300_LCDDataStruct;

SiS300_LCDDataStruct  SiS300_StLCD1024x768Data[]=
{
	{   66,  31, 992, 510,1320, 816},
	{   66,  31, 992, 510,1320, 816},
	{  176,  75, 900, 510,1320, 816},
	{  176,  75, 900, 510,1320, 816},
	{   66,  31, 992, 510,1320, 816},
	{   27,  16,1024, 650,1350, 832},
	{    1,   1,1344, 806,1344, 806}
};

SiS300_LCDDataStruct  SiS300_ExtLCD1024x768Data[]=
{
	{   12,   5, 896, 512,1344, 806},
	{   12,   5, 896, 510,1344, 806},
	{   32,  15,1008, 505,1344, 806},
	{   32,  15,1008, 514,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

SiS300_LCDDataStruct  SiS300_St2LCD1024x768Data[]=
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

SiS300_LCDDataStruct  SiS300_StLCD1280x1024Data[]=
{
	{    4,   1, 880, 510,1650,1088},
	{    4,   1, 880, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{    4,   1, 880, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

SiS300_LCDDataStruct  SiS300_ExtLCD1280x1024Data[]=
{
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 500,1688,1066},
	{  211,  75,1024, 625,1688,1066},
	{  211, 120,1280, 798,1688,1066},
	{    1,   1,1688,1066,1688,1066}
};

SiS300_LCDDataStruct  SiS300_St2LCD1280x1024Data[]=
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

SiS300_LCDDataStruct  SiS300_NoScaleData[]=
{
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 800, 525, 800, 525},
	{    1,   1,1056, 628,1056, 628},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1688,1066,1688,1066}
};

SiS300_LCDDataStruct  SiS300_LCD1280x960Data[]=
{
	{    9,   2, 800, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{   30,  11,1056, 625,1800,1000},
	{    5,   3,1350, 800,1800,1000},
	{    1,   1,1576,1050,1576,1050},
	{    1,   1,1800,1000,1800,1000}
};

typedef struct _SiS300_TVDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT TVHDE;
	USHORT TVVDE;
	USHORT RVBHRS;
	UCHAR FlickerMode;
	USHORT HALFRVBHRS;
	UCHAR RY1COE;
	UCHAR RY2COE;
	UCHAR RY3COE;
	UCHAR RY4COE;
} SiS300_TVDataStruct;

SiS300_TVDataStruct  SiS300_StPALData[]=
{
	{    1,   1, 864, 525,1270, 400, 100,   0, 760,0xf4,0xff,0x1c,0x22},
	{    1,   1, 864, 525,1270, 350, 100,   0, 760,0xf4,0xff,0x1c,0x22},
	{    1,   1, 864, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
	{    1,   1, 864, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
	{    1,   1, 864, 525,1270, 480,  50,   0, 760,0xf4,0xff,0x1c,0x22},
	{    1,   1, 864, 525,1270, 600,  50,   0,   0,0xf4,0xff,0x1c,0x22}
};

SiS300_TVDataStruct  SiS300_ExtPALData[]=
{
	{   27,  10, 848, 448,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
	{  108,  35, 848, 398,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
	{   12,   5, 954, 448,1270, 530,  50,   0,  50,0xf1,0x04,0x1f,0x18},
	{    9,   4, 960, 463,1644, 438,  50,   0,  50,0xf4,0x0b,0x1c,0x0a},
	{    9,   4, 848, 528,1270, 530,   0,   0,  50,0xf5,0xfb,0x1b,0x2a},
	{   36,  25,1060, 648,1316, 530, 438,   0, 438,0xeb,0x05,0x25,0x16},
	{    3,   2,1080, 619,1270, 540, 438,   0, 438,0xf3,0x00,0x1d,0x20},
	{    1,   1,1170, 821,1270, 520, 686,   0, 686,0xF3,0x00,0x1D,0x20}     /*301b*/

};

SiS300_TVDataStruct  SiS300_StNTSCData[]=
{
	{    1,   1, 858, 525,1270, 400,  50,   0, 760,0xf1,0x04,0x1f,0x18},
	{    1,   1, 858, 525,1270, 350,  50,   0, 640,0xf1,0x04,0x1f,0x18},
	{    1,   1, 858, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
	{    1,   1, 858, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
	{    1,   1, 858, 525,1270, 480,   0,   0, 760,0xf1,0x04,0x1f,0x18}
};

SiS300_TVDataStruct  SiS300_ExtNTSCData[]=
{
	{  143,  65, 858, 443,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
	{   88,  35, 858, 393,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
	{  143,  70, 924, 443,1270, 440,  92,   0,  92,0xf1,0x04,0x1f,0x18},
	{  143,  70, 924, 393,1270, 440,  92,   0,  92,0xf4,0x0b,0x1c,0x0a},
	{  143,  76, 836, 523,1270, 440, 224,   0,   0,0xf1,0x05,0x1f,0x16},
	{  143, 120,1056, 643,1270, 440,   0, 128,   0,0xf4,0x10,0x1c,0x00},
	{  143,  76, 836, 523,1270, 440,   0, 128,   0,0xee,0x0c,0x22,0x08},
	{   65,  64,1056, 791,1270, 480, 638,   0,   0,0xf1,0x04,0x1f,0x18} /*301b*/
};

SiS_TVDataStruct  SiS300_St1HiTVData[]=
{
 	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

SiS_TVDataStruct  SiS300_St2HiTVData[]=
{
 	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

SiS_TVDataStruct  SiS300_ExtHiTVData[]=
{
 	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

UCHAR SiS300_NTSCTiming[] = {
	0x17,0x1d,0x03,0x09,0x05,0x06,0x0c,0x0c,
	0x94,0x49,0x01,0x0a,0x06,0x0d,0x04,0x0a,
	0x06,0x14,0x0d,0x04,0x0a,0x00,0x85,0x1b,
	0x0c,0x50,0x00,0x97,0x00,0xda,0x4a,0x17,
	0x7d,0x05,0x4b,0x00,0x00,0xe2,0x00,0x02,
	0x03,0x0a,0x65,0x9d,0x08,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x50,
	0x00,0x40,0x44,0x00,0xdb,0x02,0x3b,0x00
};

UCHAR SiS300_PALTiming[] = {
	0x19,0x52,0x35,0x6e,0x04,0x38,0x3d,0x70,
	0x94,0x49,0x01,0x12,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0x45,0x2b,
	0x70,0x50,0x00,0x9b,0x00,0xd9,0x5d,0x17,
	0x7d,0x05,0x45,0x00,0x00,0xe8,0x00,0x02,
	0x0d,0x00,0x68,0xb0,0x0b,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x63,
	0x00,0x40,0x3e,0x00,0xe1,0x02,0x28,0x00
};

UCHAR SiS300_HiTVExtTiming[] = {0x00};

UCHAR SiS300_HiTVSt1Timing[] = {0x00};

UCHAR SiS300_HiTVSt2Timing[] = {0x00};

UCHAR SiS300_HiTVTextTiming[] = {0x00};

UCHAR SiS300_HiTVGroup3Data[] = {0x00};

UCHAR SiS300_HiTVGroup3Simu[] = {0x00};

UCHAR SiS300_HiTVGroup3Text[] = {0x00};

typedef struct _SiS300_LVDSDataStruct
{
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS300_LVDSDataStruct;

SiS300_LVDSDataStruct  SiS300_LVDS800x600Data_1[]=
{
	{848, 433,1060, 629},
	{848, 389,1060, 629},
	{848, 433,1060, 629},
	{848, 389,1060, 629},
	{848, 518,1060, 629},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{800, 449,1000, 644},
	{800, 525,1000, 635}
};

SiS300_LVDSDataStruct  SiS300_LVDS800x600Data_2[]=
{
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{800, 449,1000, 644},
	{800, 525,1000, 635}
};

SiS300_LVDSDataStruct  SiS300_LVDS1024x768Data_1[]=
{
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

SiS300_LVDSDataStruct  SiS300_LVDS1024x768Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

SiS300_LVDSDataStruct  SiS300_LVDS1280x1024Data_1[]=
{
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

SiS300_LVDSDataStruct  SiS300_LVDS1280x1024Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

SiS300_LVDSDataStruct  SiS300_LVDS640x480Data_1[]=
{
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 525, 800, 525},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628}
};

/* TW: New: */
SiS300_LVDSDataStruct  SiS300_CHTVUNTSCData[]=
{
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{784, 600, 784, 600},
	{1064, 750,1064, 750}
};

SiS300_LVDSDataStruct  SiS300_CHTVONTSCData[]=
{
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{784, 525, 784, 525},
	{1040, 700,1040, 700}
};

SiS300_LVDSDataStruct  SiS300_CHTVUPALData[]=
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{840, 750, 840, 750},
	{936, 836, 936, 836}
};

SiS300_LVDSDataStruct  SiS300_CHTVOPALData[]=
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{840, 625, 840, 625},
	{960, 750, 960, 750}
};
/* TW: new end */

typedef struct _SiS300_LVDSDesStruct
{
	USHORT LCDHDES;
	USHORT LCDVDES;
} SiS300_LVDSDesStruct;

SiS300_LVDSDesStruct  SiS300_PanelType00_1[]=
{
	{0, 626},
	{0, 624},
	{0, 626},
	{0, 624},
	{0, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType01_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType02_1[]=
{
	{0, 626},
	{0, 624},
	{0, 626},
	{0, 624},
	{0, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType03_1[]=
{
	{ 8, 436},
	{ 8, 440},
	{ 8, 436},
	{ 8, 440},
	{ 8, 512},
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794}
};

SiS300_LVDSDesStruct  SiS300_PanelType04_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType05_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType06_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType07_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType08_1[]=
{
	{1059, 626},
	{1059, 624},
	{1059, 626},
	{1059, 624},
	{1059, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType09_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0a_1[]=
{
	{1059, 626},
	{1059, 624},
	{1059, 626},
	{1059, 624},
	{1059, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0b_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0c_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0d_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0e_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0f_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType00_2[]=
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType01_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType02_2[]=
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType03_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{1152, 622},
	{1152, 597}
};

SiS300_LVDSDesStruct  SiS300_PanelType04_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType05_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType06_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType07_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType08_2[]=
{
 	{976, 527},
 	{976, 502},
 	{976, 527},
 	{976, 502},
 	{976, 567},
 	{  0, 627},
 	{  0, 627},
 	{  0,   0},
 	{  0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType09_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0a_2[]=
{
 	{976, 527},
 	{976, 502},
 	{976, 527},
 	{976, 502},
 	{976, 567},
 	{  0, 627},
 	{  0, 627},
 	{  0,   0},
 	{  0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0b_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0c_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0d_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0e_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

SiS300_LVDSDesStruct  SiS300_PanelType0f_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

/*301b*/
SiS300_LVDSDesStruct SiS300_PanelType1076_1[]=
{
	{0x00,0x00}
};
SiS300_LVDSDesStruct SiS300_PanelType1210_1[]=
{
	{0x00,0x00}
};
SiS300_LVDSDesStruct SiS300_PanelType1296_1[]=
{
	{0x00,0x00}
};
SiS300_LVDSDesStruct SiS300_PanelType1076_2[]=
{
	{0x00,0x00}
};
SiS300_LVDSDesStruct SiS300_PanelType1210_2[]=
{
	{0x00,0x00}
};
SiS300_LVDSDesStruct SiS300_PanelType1296_2[]=
{
	{0x00,0x00}
};
/*end 301b*/

/* TW: New */
SiS300_LVDSDesStruct  SiS300_CHTVUNTSCDesData[]=
{
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_CHTVONTSCDesData[]=
{
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0}
};

SiS300_LVDSDesStruct  SiS300_CHTVUPALDesData[]=
{
 	{256,   0},
 	{256,   0},
 	{256,   0},
 	{256,   0},
 	{  0,   0},
 	{  0,   0}
};

SiS300_LVDSDesStruct  SiS300_CHTVOPALDesData[]=
{
 	{256,   0},
 	{256,   0},
 	{256,   0},
 	{256,   0},
 	{  0,   0},
 	{  0,   0}
};
/* TW: New end */

typedef struct _SiS300_LVDSCRT1DataStruct
{
UCHAR CR[15];
} SiS300_LVDSCRT1DataStruct;

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_1[]=
{
	{{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
	  0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
	  0x00 }},
	{{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_1[]=
{ 
	{{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00}},
	{{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01}},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01} }
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_1[]=
{
	{{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00 }},
	{{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_1_H[]=
{
	{{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x04,0x3e,
	  0xe0,0x85,0xdf,0xfb,0x10,0x00,0x04,
	  0x00 }},
	{{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_1_H[]=
{
	{{0x37,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00 }},
	{{0x37,0x27,0x9B,0x2b,0x94,0x97,0x1f,
	  0x60,0x87,0x5D,0x83,0x01,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0x97,0x1f,
	  0x60,0x87,0x5D,0x83,0x01,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0x04,0x3e,
	  0xE2,0x89,0xDf,0x05,0x00,0x00,0x44,
	  0x00}},
	{{0x41,0x31,0x85,0x35,0x1d,0x7c,0xf0,
	  0x5A,0x8F,0x57,0x7D,0x20,0x00,0x55,
	  0x01}},
	{{0x4f,0x3F,0x93,0x45,0x0D,0x24,0xf5,
	  0x02,0x88,0xFf,0x25,0x10,0x00,0x01,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_1_H[]=
{
	{{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x04,
	  0x00 }},
	{{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_2[]=
{
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0xba,
	  0x1c,0x80,0xdf,0x73,0x00,0x00,0x06,
	  0x00 }},
	{{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_2[]=
{
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_2[]=
{
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_2_H[]=
{
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x3a,0x1a,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0xba,
	  0x1c,0x80,0xdf,0x73,0x00,0x00,0x05,
	  0x00 }},
	{{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_2_H[]=
{
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_2_H[]=
{
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x31,0x93,0x3e,0x86,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

/* TW: New */
SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1UNTSC[]=
{
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x5d,0x4f,0x81,0x53,0x9c,0x56,0xba,
	  0x18,0x84,0xdf,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x80,0x63,0x84,0x6c,0x17,0xec,0xf0,
	  0x90,0x8c,0x57,0xed,0x20,0x00,0x06,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1ONTSC[]=
{
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x5d,0x4f,0x81,0x56,0x9c,0x0b,0x3e,
	  0xe8,0x84,0xdf,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x7d,0x63,0x81,0x6a,0x16,0xba,0xf0,
	  0x7f,0x86,0x57,0xbb,0x00,0x00,0x06,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1UPAL[]=
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x55,0x80,0xec,0xba,
	  0x50,0x84,0xdf,0xed,0x00,0x00,0x05,
	  0x00 }},
	{{0x70,0x63,0x94,0x68,0x8d,0x42,0xf1,
	  0xc8,0x8c,0x57,0xe9,0x20,0x00,0x05,
	  0x01 }}
};

SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1OPAL[]=
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x55,0x80,0x6f,0xba,
	  0x20,0x83,0xdf,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x73,0x63,0x97,0x69,0x8e,0xec,0xf0,
	  0x90,0x8c,0x57,0xed,0x20,0x00,0x05,
	  0x01 }}
};
/* TW: New end */

/* TW: New */
typedef struct _SiS300_CHTVRegDataStruct
{
	UCHAR Reg[5];
} SiS300_CHTVRegDataStruct;

SiS300_CHTVRegDataStruct SiS300_CHTVReg_UNTSC[] = {
	{{0x4a,0x94,0x00,0x48,0xfe}},
	{{0x4a,0x94,0x00,0x48,0xfe}},
	{{0x4a,0x94,0x00,0x48,0xfe}},
	{{0x4a,0x94,0x00,0x48,0xfe}},
	{{0x6a,0x6a,0x00,0x2d,0xfa}}, /* Mode 17: 640x480 NTSC 7/8  */
	{{0x8d,0xc4,0x00,0x3b,0xfb}}  /* Mode 24: 800x600 NTSC 7/10 */
};

SiS300_CHTVRegDataStruct SiS300_CHTVReg_ONTSC[] = {
	{{0x49,0x94,0x00,0x34,0xfe}},
	{{0x49,0x94,0x00,0x34,0xfe}},
	{{0x49,0x94,0x00,0x34,0xfe}},
	{{0x49,0x94,0x00,0x34,0xfe}},
	{{0x69,0x6a,0x00,0x1e,0xfd}}, /* Mode 16: 640x480 NTSC 1/1 */
	{{0x8c,0xb4,0x00,0x32,0xf9}}  /* Mode 23: 800x600 NTSC 3/4 */
};

SiS300_CHTVRegDataStruct SiS300_CHTVReg_UPAL[] = {
	{{0x41,0x12,0x01,0x50,0x34}},
	{{0x41,0x12,0x00,0x50,0x00}},
	{{0x41,0x12,0x01,0x50,0x34}},
	{{0x41,0x12,0x00,0x50,0x00}},
	{{0x63,0x94,0x01,0x50,0x30}}, /* Mode 15: 640x480 PAL 5/6 */
	/* TW: For 800x600, 3/4 is VERY underscan */
	{{0x84,0x64,0x01,0x4e,0x2f}}  /* Mode 21: 800x600 PAL 3/4 */
	/* TW: Mode 20 is still underscan, use it instead? */
	/* {{0x83,0x76,0x01,0x40,0x31}} */ /* Mode 20: 800x600 PAL 5/6 */
};

SiS300_CHTVRegDataStruct SiS300_CHTVReg_OPAL[] = {
	{{0x41,0x12,0x01,0x50,0x34}}, /* Mode 9: 640x400 PAL 1/1 */
	{{0x41,0x12,0x00,0x50,0x00}},
	{{0x41,0x12,0x01,0x50,0x34}},
	{{0x41,0x12,0x00,0x50,0x00}},
	{{0x61,0x94,0x01,0x36,0x30}}, /* Mode 14: 640x480 PAL 1/1 */
	{{0x83,0x76,0x01,0x40,0x31}}  /* Mode 20: 800x600 PAL 5/6 */
	/* {{0x81,0x12,0x01,0x50,0x34}}  */ /* TW: (test) Mode 19: 800x600 PAL 1/1 */
};
/* TW: New end */

/* TW: New */
UCHAR SiS300_CHTVVCLKUNTSC[] = {0x29,0x29,0x29,0x29,0x2a,0x2e};

UCHAR SiS300_CHTVVCLKONTSC[] = {0x2c,0x2c,0x2c,0x2c,0x2d,0x2b};

UCHAR SiS300_CHTVVCLKUPAL[]  = {0x2f,0x2f,0x2f,0x2f,0x2f,0x31};

UCHAR SiS300_CHTVVCLKOPAL[]  = {0x2f,0x2f,0x2f,0x2f,0x30,0x32};
/* TW: New end */


