/* 
 * Copyright (c) 1995, 1996, 1997 Jeffrey A. Uphoff
 *
 * NSM for Linux.
 */

#include <errno.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include "statd.h"
#include "notlist.h"

#ifndef lint
static char vcid[] = "$Id: misc.c,v 2.2 1998/06/01 19:06:43 juphoff Exp $";
#endif

/*
 * Error-checking malloc() wrapper.
 */
void *
xmalloc (size_t size)
{
  void *ptr;

  if (size == 0)
    return ((void *)NULL);

  if (!(ptr = malloc (size)))
    /* SHIT!  SHIT!  SHIT! */
    die ("malloc: %s", strerror (errno));

  return (ptr);
}


/* 
 * Error-checking strdup() wrapper.
 */
char *
xstrdup (const char *string)
{
  char *result;

  /* Will only fail if underlying malloc() fails (ENOMEM). */
  if (!(result = strdup (string)))
    die ("strdup: %s", strerror (errno));

  return (result);
}


/*
 * Call with check=1 to verify that this host is not still on the rtnl
 * before unlinking file.
 */
void
xunlink (char *path, char *host, short int check)
{
  char tozap[PATH_MAX];

  snprintf (tozap, PATH_MAX, "%s/%s", path, host);

  if (!check || !nlist_gethost(rtnl, host, 0))
    if (unlink (tozap) == -1)
      log (L_ERROR, "unlink (%s): %s", tozap, strerror (errno));
    else
      dprintf (L_DEBUG, "Unlinked %s", tozap);
  else
    dprintf (L_DEBUG, "Not unlinking %s--host still monitored.", tozap);
}
