/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMap
implements Map {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    Set keys;
    Collection values;

    protected AbstractMap() {
    }

    public void clear() {
        this.entrySet().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractMap copy = (AbstractMap)super.clone();
        copy.keys = null;
        copy.values = null;
        return copy;
    }

    public boolean containsKey(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractMap.equals(key, ((Map.Entry)entries.next()).getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractMap.equals(value, ((Map.Entry)entries.next()).getValue())) continue;
            return true;
        }
        return false;
    }

    public abstract Set entrySet();

    public boolean equals(Object o) {
        return o == this || o instanceof Map && this.entrySet().equals(((Map)o).entrySet());
    }

    public Object get(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (!AbstractMap.equals(key, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(this){
                private /* synthetic */ AbstractMap this$0;
                {
                    this.this$0 = this$0;
                }

                static /* synthetic */ AbstractMap access$10(1 inst$, AbstractMap write_parm_value$) {
                    inst$.this$0 = write_parm_value$;
                    return inst$.this$0;
                }

                static AbstractMap access$0(1 inst$) {
                    return inst$.this$0;
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object key) {
                    return this.this$0.containsKey(key);
                }

                public Iterator iterator() {
                    return new Iterator(this){
                        private /* synthetic */ 1 this$1;
                        private final Iterator map_iterator;
                        {
                            this.this$1 = this$1;
                            this.finit$();
                        }

                        private /* synthetic */ void finit$() {
                            this.map_iterator = this.this$1.this$0.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.map_iterator.next()).getKey();
                        }

                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.keys;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        Iterator entries = m.entrySet().iterator();
        int pos = m.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (!AbstractMap.equals(key, entry.getKey())) continue;
            Object r = entry.getValue();
            entries.remove();
            return r;
        }
        return null;
    }

    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        Iterator entries = this.entrySet().iterator();
        StringBuffer r = new StringBuffer("{");
        for (int pos = this.size(); pos > 0; --pos) {
            Map.Entry entry = (Map.Entry)entries.next();
            r.append(entry.getKey());
            r.append('=');
            r.append(entry.getValue());
            if (pos <= 1) continue;
            r.append(", ");
        }
        r.append("}");
        return r.toString();
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(this){
                private /* synthetic */ AbstractMap this$0;
                {
                    this.this$0 = this$0;
                }

                static /* synthetic */ AbstractMap access$9(3 inst$, AbstractMap write_parm_value$) {
                    inst$.this$0 = write_parm_value$;
                    return inst$.this$0;
                }

                static AbstractMap access$0(3 inst$) {
                    return inst$.this$0;
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object value) {
                    return this.this$0.containsValue(value);
                }

                public Iterator iterator() {
                    return new Iterator(this){
                        private /* synthetic */ 3 this$1;
                        private final Iterator map_iterator;
                        {
                            this.this$1 = this$1;
                            this.finit$();
                        }

                        private /* synthetic */ void finit$() {
                            this.map_iterator = this.this$1.this$0.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.map_iterator.next()).getValue();
                        }

                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.values;
    }

    static final boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    static final int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    static class BasicMapEntry
    implements Map.Entry {
        Object key;
        Object value;

        BasicMapEntry(Object newKey, Object newValue) {
            this.key = newKey;
            this.value = newValue;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof BasicMapEntry) {
                BasicMapEntry e = (BasicMapEntry)o;
                return AbstractMap.equals(this.key, e.key) && AbstractMap.equals(this.value, e.value);
            }
            Map.Entry e = (Map.Entry)o;
            return AbstractMap.equals(this.key, e.getKey()) && AbstractMap.equals(this.value, e.getValue());
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final int hashCode() {
            return AbstractMap.hashCode(this.key) ^ AbstractMap.hashCode(this.value);
        }

        public Object setValue(Object newVal) {
            Object r = this.value;
            this.value = newVal;
            return r;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

