/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.InvalidObjectException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class DateFormat
extends Format
implements Cloneable {
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;

    protected DateFormat() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateFormat)) {
            return false;
        }
        DateFormat d = (DateFormat)obj;
        return this.numberFormat.equals(d.numberFormat);
    }

    public Object clone() {
        return super.clone();
    }

    public final StringBuffer format(Object obj, StringBuffer buf, FieldPosition pos) {
        if (obj instanceof Number) {
            obj = new Date(((Number)obj).longValue());
        } else if (!(obj instanceof Date)) {
            throw new IllegalArgumentException("Cannot format given Object as a Date");
        }
        return this.format((Date)obj, buf, pos);
    }

    public final String format(Date date) {
        StringBuffer sb = new StringBuffer();
        this.format(date, sb, new FieldPosition(2));
        return sb.toString();
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public static Locale[] getAvailableLocales() {
        Locale[] l = new Locale[]{Locale.US};
        return l;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    private static final DateFormat computeInstance(int style, Locale loc, boolean use_date, boolean use_time) {
        return DateFormat.computeInstance(style, style, loc, use_date, use_time);
    }

    private static final DateFormat computeInstance(int dateStyle, int timeStyle, Locale loc, boolean use_date, boolean use_time) {
        String def;
        String name;
        ResourceBundle res;
        try {
            res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", loc);
        }
        catch (MissingResourceException x) {
            res = null;
        }
        String pattern = null;
        if (use_date) {
            switch (dateStyle) {
                case 0: {
                    name = "fullDateFormat";
                    def = "EEEE MMMM d, yyyy G";
                    break;
                }
                case 1: {
                    name = "longDateFormat";
                    def = "MMMM d, yyyy";
                    break;
                }
                case 2: {
                    name = "mediumDateFormat";
                    def = "d-MMM-yy";
                    break;
                }
                case 3: {
                    name = "shortDateFormat";
                    def = "M/d/yy";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            try {
                pattern = res == null ? def : res.getString(name);
            }
            catch (MissingResourceException x) {
                pattern = def;
            }
        }
        if (use_time) {
            String s;
            pattern = pattern == null ? "" : pattern + " ";
            switch (timeStyle) {
                case 0: {
                    name = "fullTimeFormat";
                    def = "h:mm:ss;S 'o''clock' a z";
                    break;
                }
                case 1: {
                    name = "longTimeFormat";
                    def = "h:mm:ss a z";
                    break;
                }
                case 2: {
                    name = "mediumTimeFormat";
                    def = "h:mm:ss a";
                    break;
                }
                case 3: {
                    name = "shortTimeFormat";
                    def = "h:mm a";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            try {
                s = res == null ? def : res.getString(name);
            }
            catch (MissingResourceException x) {
                s = def;
            }
            pattern = pattern + s;
        }
        return new SimpleDateFormat(pattern, loc);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.getDateInstance(2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int style) {
        return DateFormat.getDateInstance(style, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int style, Locale loc) {
        return DateFormat.computeInstance(style, loc, true, false);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale loc) {
        return DateFormat.computeInstance(dateStyle, timeStyle, loc, true, true);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.getTimeInstance(2, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int style) {
        return DateFormat.getTimeInstance(style, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int style, Locale loc) {
        return DateFormat.computeInstance(style, loc, false, true);
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public int hashCode() {
        if (this.numberFormat != null) {
            return this.numberFormat.hashCode();
        }
        return 0;
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public Date parse(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Date result = this.parse(source, pos);
        if (result == null) {
            int index = pos.getErrorIndex();
            if (index < 0) {
                index = pos.getIndex();
            }
            throw new ParseException("invalid Date syntax", index);
        }
        return result;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public void setLenient(boolean lenient) {
        this.calendar.setLenient(lenient);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }

    public static class Field
    extends Format.Field {
        static final long serialVersionUID = 7441350119349544720L;
        private int calendarField;
        public static final Field ERA = new Field("era", 0);
        public static final Field YEAR = new Field("year", 1);
        public static final Field MONTH = new Field("month", 2);
        public static final Field DAY_OF_MONTH = new Field("day of month", 5);
        public static final Field HOUR_OF_DAY1 = new Field("hour of day 1", 11);
        public static final Field HOUR_OF_DAY0 = new Field("hour of day 0", 11);
        public static final Field MINUTE = new Field("minute", 12);
        public static final Field SECOND = new Field("second", 13);
        public static final Field MILLISECOND = new Field("millisecond", 14);
        public static final Field DAY_OF_WEEK = new Field("day of week", 7);
        public static final Field DAY_OF_YEAR = new Field("day of year", 6);
        public static final Field DAY_OF_WEEK_IN_MONTH = new Field("day of week in month", 8);
        public static final Field WEEK_OF_YEAR = new Field("week of year", 3);
        public static final Field WEEK_OF_MONTH = new Field("week of month", 4);
        public static final Field AM_PM = new Field("am/pm", 9);
        public static final Field HOUR1 = new Field("hour1", 10);
        public static final Field HOUR0 = new Field("hour0", 10);
        public static final Field TIME_ZONE = new Field("timezone", 15);
        public static final Field[] allFields = new Field[]{ERA, YEAR, MONTH, DAY_OF_MONTH, HOUR_OF_DAY1, HOUR_OF_DAY0, MINUTE, SECOND, MILLISECOND, DAY_OF_WEEK, DAY_OF_YEAR, DAY_OF_WEEK_IN_MONTH, WEEK_OF_YEAR, WEEK_OF_MONTH, AM_PM, HOUR1, HOUR0, TIME_ZONE};

        private Field() {
            super("");
        }

        protected Field(String name, int calendarField) {
            super(name);
            this.calendarField = calendarField;
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        public static Field ofCalendarField(int calendarField) {
            if (calendarField >= allFields.length || calendarField < 0) {
                throw new IllegalArgumentException("no such calendar field (" + calendarField + ")");
            }
            return allFields[calendarField];
        }

        protected Object readResolve() throws InvalidObjectException {
            String s = this.getName();
            for (int i = 0; i < allFields.length; ++i) {
                if (!s.equals(allFields[i].getName())) continue;
                return allFields[i];
            }
            throw new InvalidObjectException("no such DateFormat field called " + s);
        }
    }
}

