= delegate.rb
== 目的・概要
メソッドの委譲(delegation)を行う。

Delegatorクラスは指定したオブジェクトにメソッドの実行を委譲する。
Delegatorクラスを利用する場合はこれを継承して(({__getobj__}))メソッドを
再定義して委譲先のオブジェクトを指定する。

SimpleDelegatorはDelegatorの利用例の一つであり、コンストラクタに
渡されたオブジェクトにメソッドの実行を委譲する。

関数DelegateClass(((|supperclass|)))は((|superclass|))クラスの
オブジェクトをひとつとり、そのオブジェクトにインスタンスメソッドを委譲す
るクラスを定義して返す。

== クラス
* ((<delegate.rb/Delegator>))
  * ((<delegate.rb/SimpleDelegator>))
== サンプルコード
  require 'delegate'
  foo = Object::new
  def foo.test
    p 25
  end
  foo2 = SimpleDelegator::new(foo)
  foo2.test # => 25
  
  class ExtArray<DelegateClass(Array)
    def initialize()
      super([])
    end
  end
  a = ExtArray::new
  p a.type  # => ExtArray
  a.push 25
  p a       # => [25]
== Delegator
与えられたオブジェクトの持つメソッドに関して委譲用のメソッド定義を
提供するクラス。

コンストラクタで指定されたオブジェクトのもつインスタンスメソッドのうち、
自分の持たないメソッドについて、
(({__getobj__}))が返すオブジェクトに実行を委譲するようメソッドを定義する。
=== インスタンスメソッド
--- Delegator#initialize(obj)
        ((|obj|))のもつインスタンスメソッドのうち、
        自分の持たないメソッドについて、
        (({__getobj__}))が返すオブジェクトに実行を委譲する
        ようインスタンスメソッドを定義する。
--- Delegator#__getobj__
        委譲先のオブジェクトを返す。
        デフォルトではNotImplementErrorを発生するので、サブクラスで
        再定義する必要がある。
== SimpleDelegator
Delegatorクラスをそのまま利用した、
指定したオブジェクトにメソッドを委譲するクラス。
:上位クラス
         Delegator
=== クラスメソッド
--- SimpleDelegator.new(obj)
        ((|obj|))がもつメソッドについて、実行を((|obj|))に委譲する
        オブジェクトを生成する。
=== インスタンスメソッド
--- SimpleDelegator#__getobj__
        委譲先のオブジェクトを返す。
--- SimpleDelegator#__setobj__(obj)
        委譲先のオブジェクトを((|obj|))に変更する。

        委譲するメソッドの定義は生成時にのみ行われるため、
        以前の委譲先オブジェクトと((|obj|))の間でインスタンスメソッドに
        違いがあっても、
        委譲するインスタンスメソッドの再設定は行われないことに注意。
== 関数
--- function#DelegateClass(superclass)
        クラス((|superclass|))のインスタンスへメソッドを委譲するクラスを
        定義し、そのクラスを返す。
== SEE ALSO
--- Object#method_missing(method_symbol, ...)
        メソッドがオブジェクトに定義されていなかったときにこのメソッドが
        呼ばれる。これを使って自分の知らないメソッドをほかのオブジェクト
        に委譲することができる。

        例:
          def hoge.method_missing(message, *arg)
              @to_obj.send(message, *arg)
          end
