= PP
== super class
((<PrettyPrint>))

== class methods
--- PP.pp(obj[, out[, width]])
#    outputs ((|obj|)) to ((|out|)) in pretty printed format of
#    ((|width|)) columns in width.
    ((|obj|)) を ((|out|)) に幅 ((|width|)) で pretty print します。

#    If ((|out|)) is ommitted, (({$>})) is assumed.
#    If ((|width|)) is ommitted, 79 is assumed.
    ((|out|)) を省略した場合は、(({$>})) が指定されたものとみなされます。
    ((|width|)) を省略した場合は、79 が指定されたものとみなされます。

#    PP.pp returns ((|out|)).
    PP.pp は ((|out|)) を返します。

--- PP.sharing_detection
#    returns the sharing detection flag as a boolean value.
#    It is false by default.
    共有検出フラグを boolean すなわち true か false で返します。
    デフォルトは false です。

--- PP.sharing_detection = boolean_value
#    sets the sharing detection flag.
    共有検出フラグを設定します。

== methods
--- pp(obj)
#    adds ((|obj|)) to the pretty printing buffer
#    using Object#pretty_print or Object#pretty_print_cycle.
    Object#pretty_print や Object#pretty_print_cycle を使って、
    ((|obj|)) を pretty print バッファに追加します。

#    Object#pretty_print_cycle is used when ((|obj|)) is already
#    printed, a.k.a the object reference chain has a cycle.
    ((|obj|)) がすでに出力されていたときには Object#pretty_print_cycle 
    が使われます。これはオブジェクトの参照の連鎖がループしていることを
    意味します。

--- object_group(obj) { ... }
#    is a convenience method which is same as follows:

    以下と等価な働きをするもので簡便のために用意されています。
 
      group(1, '#<' + obj.class.name, '>') { ... }

--- comma_breakable
#    is a convenience method which is same as follows:

    以下と等価な働きをするもので簡便のために用意されています。

      text ','
      breakable

= Object
--- pretty_print(pp)
#    is a default pretty printing method for general objects.
#    It calls (({pretty_print_instance_variables})) to list instance variables.

    一般のオブジェクトのためのデフォルトの pretty print メソッドです。
    このメソッドはインスタンス変数を列挙するために
    (({pretty_print_instance_variables})) を呼びます。

#    If (({self})) has a customized (redefined) (({inspect})) method,
#    the result of (({self.inspect})) is used but it obviously has no
#    line break hints.

    カスタマイズ(再定義)された (({inspect})) を (({self})) が持つ場合、
    (({self.inspect})) の結果が使われますが、これは改行のヒントを持ちません。

#    This module provides predefined pretty_print() methods for some of
#    the most commonly used built-in classes for convenience.

    もっともよく使われるいくつかの組み込みクラスについて、
    PP モジュールはあらかじめ定義された pretty_print() メソッドを
    簡便のために提供しています。

--- pretty_print_cycle(pp)
#    is a default pretty printing method for general objects that are
#    detected as part of a cycle.

    一般のオブジェクトがサイクルの一部であることが検出されたときのための
    デフォルトの pretty print メソッドです。

--- pretty_print_instance_variables
#    returns a sorted array of instance variable names.

    ソートされたインスタンス変数の名前の配列を返します。

#    This method should return an array of names of instance variables as symbols or strings as:

    このメソッドはインスタンス変数の名前をシンボルか文字列として要素に持つ
    配列を返さなければなりません。
    (({[:@a, :@b]})).

