= Kconv

((<trap::Kconv>))

文字コードエンコーディングを変換するためのモジュール。
((<Kconv>))は((<NKF>))のラッパーです。

((<kconv.rb/String に追加されるメソッド>))も参照してください。

== 使用例

  newstring = Kconv::kconv(string, Kconv::JIS, Kconv::AUTO)
  newstring = Kconv::tojis(string)
  newstring = Kconv::toeuc(string)
  newstring = Kconv::tosjis(string)
  guessed_code = Kconv::guess(string)

または

  newstring = string.kconv(Kconv::JIS, Kconv::AUTO)
  newstring = string.tojis
  newstring = string.toeuc
  newstring = string.tosjis

== モジュール関数

--- Kconv.kconv(str, out_code, in_code = Kconv::AUTO)
    文字列 ((|str|)) のエンコーディングを ((|out_code|)) に変換したものを
    返します。((|in_code|)) も指定されていたら ((|str|)) のエンコーディングが
    ((|in_code|)) だとして動作します。

    ((|out_code|)) ((|in_code|)) は定数で指定します。

--- Kconv.tojis(str)
    文字列 ((|str|)) のエンコーディングを iso-2022-jp に変換して返します。
    以下と同じです。

        Kconv.kconv(str, Kconv::JIS)

--- Kconv.toeuc(str)
    文字列 ((|str|)) のエンコーディングを euc-jp に変換して返します。
    以下と同じです。

        Kconv.kconv(str, Kconv::EUC)

--- Kconv.tosjis(str)
    文字列 ((|str|)) のエンコーディングを shift_jis に変換して返します。
    以下と同じです。

        Kconv.kconv(str, Kconv::SJIS)

--- Kconv.guess(str)
    文字列 ((|str|)) のエンコーディングを判定します。戻り値は
    (({Kconv})) の定数です。


--- Kconv.toutf8(str)
    ((<ruby 1.8.2 feature>)):
    文字列 ((|str|)) のエンコーディングを utf8 に変換して返します。
    以下と同じです。

        Kconv.kconv(str, Kconv::UTF8)

--- Kconv.toutf16(str)
    ((<ruby 1.8.2 feature>)):
    文字列 ((|str|)) のエンコーディングを utf16 に変換して返します。
    以下と同じです。

        Kconv.kconv(str, Kconv::UTF16)

--- Kconv.iseuc(str)
    ((<ruby 1.8.2 feature>)):
    以下と同じです。
      Kconv::RegexpEucjp.match( str )

--- Kconv.issjis(str)
    ((<ruby 1.8.2 feature>)):
    以下と同じです。
      Kconv::RegexpShiftjis.match( str )

--- Kconv.isutf8(str)
    ((<ruby 1.8.2 feature>)):
    以下と同じです。
      Kconv::RegexpUtf8.match( str )


== 定数

--- Kconv::AUTO
    エンコーディングを自動検出する。
    入力の指定でのみ有効。

--- Kconv::JIS
    iso-2022-jp を表す。

--- Kconv::EUC
    euc-jp を表す。

--- Kconv::SJIS
    shift_jis (シフト JIS / MS 漢字コードとも言う) を表す。

--- Kconv::BINARY
    JIS EUC SJIS 以外

--- Kconv::UNKNOWN
    出力においては「エンコーディングを判定できなかった」
    入力においては AUTO と同様に「自動検出」を表す。

--- Kconv::NOCONV
    変換されないことを表す。


--- Kconv::ASCII
    ((<ruby 1.8.2 feature>)):
    ASCII を表す。

--- Kconv::UTF8
    ((<ruby 1.8.2 feature>)):
    UTF8 を表す。

--- Kconv::UTF16
    ((<ruby 1.8.2 feature>)):
    UTF16 を表す。

--- Kconv::RegexpShiftjis
    ((<ruby 1.8.2 feature>)):
    SJIS にマッチする正規表現です。
--- Kconv::RegexpEucjp
    ((<ruby 1.8.2 feature>)):
    EUCJP にマッチする正規表現です。
--- Kconv::RegexpUtf8
    ((<ruby 1.8.2 feature>)):
    UTF8 にマッチする正規表現です。
