= Generator

内部イテレータを外部イテレータに変えるためのクラスです。
実装に callcc を使っているので遅いです。

* ((<SyncEnumerator>))

== 例

   require 'generator'

   # Generator from an Enumerable object
   g = Generator.new(['A', 'B', 'C', 'Z'])

   while g.next?
     puts g.next
   end

   # Generator from a block
   g = Generator.new { |g|
     for i in 'A'..'C'
       g.yield i
     end

     g.yield 'Z'
   }

   # The same result as above
   while g.next?
     puts g.next
   end

== インクルードしているモジュール

((<Enumerable>))

== クラスメソッド

--- Generator.new(enum = nil)
--- Generator.new(enum = nil){|g|  ... }
    ((<Enumerable>)) オブジェクトかブロックから Generator オブジェクトを生成します。
    ((|enum|)) には ((<Enumerable>)) をインクルードしたオブジェクトを与えます。
    ((|enum|)) とブロックを同時に与えた場合は、ブロックは無視されます。
    
    ブロックは self を引数として呼ばれます。

== メソッド

--- current
    現在の位置にある要素を返します。next と違い位置は移動しません。

      g = Generator.new(['A', 'B', 'C', 'Z'])
      p g.current # => 'A'
      p g.current # => 'A'

--- each{|e| ... }
    ジェネレータの要素を引数としてブロックを評価します。self を返します。

--- end?
    次の要素がなく、ジェネレータが終わりに達しているなら真を返します。

--- index
--- pos
    現在の位置を返します。
      
      g = Generator.new(['A', 'B', 'C', 'Z'])
      p g.pos     # => 0
      p g.next    # => 'A'
      p g.pos     # => 1

--- next
    現在の位置にある要素を返し、位置を1つ増やします。次の要素がなければ、
    例外 EOFError を投げます。

      g = Generator.new() do |g|
            ['A', 'B', 'C', 'Z'].each{|s|
              g.yield s
            }
          end
      p g.next # => 'A'
      p g.next # => 'B'

--- next?
    次の要素が存在するなら真を返します。

--- rewind()
    ジェネレータを最初に巻戻します。self を返します。

      g = Generator.new() do |g|
            ['A', 'B', 'C', 'Z'].each{|s|
              g.yield s
            }
          end
      p g.next # => 'A'
      p g.next # => 'B'
      g.rewind
      p g.next # => 'A'

--- yield(val)
    ((|val|)) をジェネレータに渡します。
    Generator.new(){|g|  ... } のブロックの中でしか呼ぶことができません。
    ジェネレータに渡された ((|val|)) は next などで取り出すことができます。

      g = Generator.new() do |g|
            n = 0
            loop do            
              g.yield n
              n += 1
            end
          end
      p g.next # => 0
      p g.next # => 1
      p g.next # => 2
      g.rewind
      p g.next # => 0
